<?php namespace CodeIgniter\CLI;

use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\Test\Mock\MockCodeIgniter;
use CodeIgniter\Test\Mock\MockCLIConfig;
use CodeIgniter\Test\Filters\CITestStreamFilter;

class ConsoleTest extends \CodeIgniter\Test\CIUnitTestCase
{

	private $stream_filter;

	protected function setUp(): void
	{
		parent::setUp();

		CITestStreamFilter::$buffer = '';
		$this->stream_filter        = stream_filter_append(STDOUT, 'CITestStreamFilter');

		$this->env = new \CodeIgniter\Config\DotEnv(ROOTPATH);
		$this->env->load();

		// Set environment values that would otherwise stop the framework from functioning during tests.
		if (! isset($_SERVER['app.baseURL']))
		{
			$_SERVER['app.baseURL'] = 'http://example.com';
		}

		$_SERVER['argv'] = [
			'spark',
			'list',
		];
		$_SERVER['argc'] = 2;
		CLI::init();

		$this->app = new MockCodeIgniter(new MockCLIConfig());
	}

	public function tearDown(): void
	{
		stream_filter_remove($this->stream_filter);
	}

	public function testNew()
	{
		$console = new \CodeIgniter\CLI\Console($this->app);
		$this->assertInstanceOf(Console::class, $console);
	}

	public function testHeader()
	{
		$console = new \CodeIgniter\CLI\Console($this->app);
		$console->showHeader();
		$result = CITestStreamFilter::$buffer;
		$this->assertTrue(strpos($result, 'CodeIgniter CLI Tool') > 0);
	}

	public function testRun()
	{
		$request = new CLIRequest(config('App'));
		$this->app->setRequest($request);

		$console = new \CodeIgniter\CLI\Console($this->app);
		$console->run(true);
		$result = CITestStreamFilter::$buffer;

		// close open buffer
		ob_end_clean();

		// make sure the result looks like a command list
		$this->assertStringContainsString('Lists the available commands.', $result);
		$this->assertStringContainsString('Displays basic usage information.', $result);
	}

}
