<?php
# CmsEasy Enterprise Content Management System
# Copyright (C) CmsEasy Co.,Ltd (https://www.CmsEasy.cn). All rights reserved.
if (!defined('ROOT')) exit('Can\'t Access !');

class myconfig extends table
{

    public $name = 'config';
    public static $me;

    public static function getInstance()
    {
        if (!self::$me) {
            $class = new myconfig();
            $class->init();
            self::$me = $class;
        }
        return self::$me;
    }
    function init()
    {
        $_config = $this->getrows(null, 1000, 'id desc');
        $myconfigconfig = array();
        foreach ($_config as $one) {
            $myconfigconfig[$one['lang']][$one['name']] = $one;
        }
        $this->myconfig = $myconfigconfig;
    }

    function getcols($act)
    {
        switch ($act) {
            case 'manage':
                return '*';
            default:
                return '*';
        }
    }

    function get_form()
    {
        return array(
            "site"=>array(
                'stop_site' => array(
                    'selecttype' => 'radio',
                    'select' => array(1 => '开', 2=> '关',3=>'挂'),
                    'remarks' => lang_admin('site'),
                    'message' => lang_admin('site'),
                ),
                'user_outtime' => array(
                    'selecttype' => 'radio',
                    'select' => array(30=> '半小时',60 => '一小时',0 => '永不超时'),
                    'remarks' => lang_admin('设置账号超时'),
                ),
                'site_url' => array(
                    'remarks' => lang_admin('网站地址'),
                ),
                'site_mobile' => array(
                    'remarks' => lang_admin('管理员手机'),
                ),
                'admin_dir' => array(
                    'remarks' => lang_admin('后台地址'),
                ),
                'sitename' => array(
                    'remarks' => lang_admin('sitename'),
                ),
                'fullname' => array(
                    'remarks' => lang_admin('page_title'),
                ),
                'site_keyword' => array(
                    'remarks' => lang_admin('网站关键字'),
                ),
                'site_description' => array(
                    'remarks' => lang_admin('website_description'),
                ),
                'site_logo' => array(
                    'selecttype' => 'image',
                    'remarks' => lang_admin('网站logo'),
                ),
                'logo_width' => array(
                    'remarks' => lang_admin('logo宽度'),
                ),
                'logo_height' => array(
                    'remarks' => lang_admin('logo高度'),
                ),
                'site_ico' => array(
                    'selecttype' => 'image',
                    'remarks' => lang_admin('地址栏图标'),
                ),
                'site_right' => array(
                    'remarks' => lang_admin('网站版权'),
                )
            ),
            "websitesite"=>array(
                'isdebug' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('调试开关'),
                 ),
                'ueditor_open' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('编辑器是否支持div'),
                ),
                'lang_type' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('繁体切换'),
                ),
                'history_num' => array(
                    'remarks' => lang_admin('访问记录'),
                ),
                'show_top_text' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('置顶文字是否显示'),
                ),
                'nav_top' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('网站导航置顶'),
                ),
                'shield_right_key' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('屏蔽右键开关'),
                ),
                'nav_blank' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('栏目打开方式'),
                ),
                'onerror_pic' => array(
                    'selecttype' => 'image',
                    'remarks' => lang_admin('列表默认图片'),
                ),
                'thumb_width' => array(
                    'remarks' => lang_admin('列表中缩略图宽度'),
                ),
                'thumb_height' => array(
                    'remarks' => lang_admin('列表中缩略图高度'),
                ),
                'manage_pagesize' => array(
                    'remarks' => lang_admin('后台分页数量'),
                ),
                'list_pagesize' => array(
                    'remarks' => lang_admin('前台分页数量'),
                ),
                'like_news' => array(
                    'remarks' => lang_admin('相关文章条数'),
                ),
                'search_time' => array(
                    'remarks' => lang_admin('搜索时间限制'),
                ),
                'maxhotkeywordnum' => array(
                    'remarks' => lang_admin('搜索基数'),
                ),
                'archive_introducelen' => array(
                    'remarks' => lang_admin('内容简介自动截取长度'),
                ),
                'isecoding' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('防伪码开关'),
                ),
                'ecoding' => array(
                    'remarks' => lang_admin('防伪码前缀'),
                ),
                'site_icp' => array(
                    'remarks' => lang_admin('ICP备案号'),
                ),
                'icp_url' => array(
                    'remarks' => lang_admin('ICP备案号'),
                ),
                'site_beian_number' => array(
                    'remarks' => lang_admin('公网安备号'),
                ),
                'saic_pic' => array(
                    'remarks' => lang_admin('工商亮照ID'),
                ),
                'qrcodes' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('二维码开关'),
                ),
                'template_view' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('在线模板'),
                ),
                'buymodules_view' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('组件市场'),
                ),
                'extend_view' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('扩展市场'),
                ),
                'opguestadd' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('游客投稿开关'),
                ),
                'html_wow' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('网页动画'),
                ),
                'share' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('分享开关'),
                ),
                'hotsearch' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('热门关键词开关'),
                ),
                'video_url' => array(
                    'selecttype' => 'textarea',
                    'remarks' => lang_admin('视频地址'),
                ),
                'cache_make_open' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('php缓存开关'),
                ),
            ),
            "information"=>array(
                'address' => array(
                    'remarks' => lang_admin('联系地址'),
                ),
                'tel' => array(
                    'remarks' => lang_admin('联系电话'),
                ),
                'mobile' => array(
                    'remarks' => lang_admin('移动电话'),
                ),
                'fax' => array(
                    'remarks' => lang_admin('传真'),
                ),
                'email' => array(
                    'remarks' => lang_admin('邮箱'),
                ),
                'complaint_email' => array(
                    'remarks' => lang_admin('投诉邮箱'),
                ),
                'postcode' => array(
                    'remarks' => lang_admin('邮政编码'),
                )
            ),
            "langsite"=>array(
                'lang_switch' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('语言选择开关'),
                ),
             ),
            "filechecksite"=>array(
                'safe360_enable' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('360安全开关'),
                ),
                'session_ip' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('SESSION验证IP'),
                ),
                'ipcheck_enable' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('后台登录IP验证开关'),
                ),
                'template_nologin' => array(
                    'remarks' => lang_admin('前台登录错误次数'),
                ),
                'admin_nologin' => array(
                    'remarks' => lang_admin('后台登录错误次数'),
                ),
                'loginfalsetime' => array(
                    'selecttype' => 'select',
                    'select' => array(3600=> '1小时',18000 => '5小时',86400 => '24小时'),
                    'remarks' => lang_admin('登录失败时间'),
                ),
                'cookie_password' => array(
                    'remarks' => lang_admin('Cookie安全码'),
                ),
             ),
            "phonesite"=>array(
                'mobile_open' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('是否启用'),
                ),
                'wap_logo' => array(
                    'selecttype' => 'image',
                    'remarks' => lang_admin('手机版logo'),
                ),
                'wlogo_width' => array(
                    'remarks' => lang_admin('logo宽度'),
                ),
                'wlogo_height' => array(
                    'remarks' => lang_admin('logo高度'),
                ),
                'wap_style_color' => array(
                    'selecttype' => 'select',
                    'select' => array(0=> '无',1 => '红',2 => '橙',3 => '黄',4 => '绿',5 => '青',6 => '蓝',
                                        7 => '紫',8 => '黑',9 => '白'),
                    'remarks' => lang_admin('手机版整体颜色'),
                ),
                'wap_foot_nav' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '上弹',2 => '圆形',3 => '平铺'),
                    'remarks' => lang_admin('手机版底部菜单样式'),
                ),
                'wap_foot_nav_position' => array(
                    'selecttype' => 'select',
                    'select' => array("left"=> '左',"right"=> '右'),
                    'remarks' => lang_admin('手机版底部菜单样式'),
                ),
             ),
            "dynamic"=>array(
                'list_cache' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('列表缓存'),
                ),
                'list_cache_time' => array(
                    'remarks' => lang_admin('缓存时间'),
                ),
                'group_on' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('生成分组'),
                ),
                'group_count' => array(
                    'remarks' => lang_admin('每组生成个数'),
                ),
                'staticlang' => array(
                    'selecttype' => 'select',
                    'select' => array("-"=> '中划线',"_"=> '下划线'),
                    'remarks' => lang_admin('URL 分隔'),
                ),
                'pc_html_info' => array(
                    'remarks' => lang_admin('pc动静态'),
                ),
                'html_prefix' => array(
                    'remarks' => lang_admin('html路径'),
                ),
                'list_index_php' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '按指定',1 => '静态',2 => '动态'),
                    'remarks' => lang_admin('首页'),
                ),
                'list_page_php' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '按指定',1 => '静态',2 => '动态'),
                    'remarks' => lang_admin('栏目页'),
                ),
                'show_page_php' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '按指定',1 => '静态',2 => '动态'),
                    'remarks' => lang_admin('内容页'),
                ),
                'list_type_php' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '按指定',1 => '静态',2 => '动态'),
                    'remarks' => lang_admin('分类页'),
                ),
                'list_special_php' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '按指定',1 => '静态',2 => '动态'),
                    'remarks' => lang_admin('专题页'),
                ),
                'tag_html' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '按指定',1 => '静态',2 => '动态'),
                    'remarks' => lang_admin('生成TAG'),
                ),
                'wap_html_info' => array(
                    'remarks' => lang_admin('手机动静态'),
                ),
                'wap_html_prefix' => array(
                    'remarks' => lang_admin('html路径'),
                ),
                'wap_index_php' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '按指定',1 => '静态',2 => '动态'),
                    'remarks' => lang_admin('手机首页'),
                ),
                'wap_list_page_php' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '按指定',1 => '静态',2 => '动态'),
                    'remarks' => lang_admin('手机栏目页'),
                ),
                'wap_show_page_php' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '按指定',1 => '静态',2 => '动态'),
                    'remarks' => lang_admin('手机内容页'),
                ),
                'wap_type_php' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '按指定',1 => '静态',2 => '动态'),
                    'remarks' => lang_admin('手机分类页'),
                ),
                'wap_special_php' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '按指定',1 => '静态',2 => '动态'),
                    'remarks' => lang_admin('手机专题页'),
                ),
                'wap_tag_html' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '按指定',1 => '静态',2 => '动态'),
                    'remarks' => lang_admin('手机TAG'),
                ),
                'urlrewrite_info' => array(
                    'remarks' => lang_admin('请注意'),
                ),
                'urlrewrite_on' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('伪静态'),
                ),
                'custom404' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('伪静态404页面'),
                ),
                'autoDelRewriteFile' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('自动删除规则'),
                ),
                'isautocthmtl' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('0点自动生成'),
                ),
             ),
            "spidersite"=>array(
                'stats_enable' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('蜘蛛统计开关'),
                ),
                'iscleanstats' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '每日',2 => '每周'),
                    'remarks' => lang_admin('自动清除蜘蛛记录'),
                ),
                'site_push' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('百度推送'),
                ),
            ),
            "backupsite"=>array(
                'isautobak' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '每日',2 => '每周',3 => '每月'),
                    'remarks' => lang_admin('数据库自动备份'),
                ),
            ),
            "customer"=>array(
                'ifonserver' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('是否启用'),
                ),
                'server_template' => array(
                    'selecttype' => 'select',
                    'select' => array(1=> '扁平彩色',2 => '扁平灰色',3 => '扁平蓝色',4 => '经典',5 => '旧时光'),
                    'remarks' => lang_admin('选择网站客服样式'),
                ),
                'boxopen' => array(
                    'selecttype' => 'radio',
                    'select' => array("close"=> '关',"open" => '开'),
                    'remarks' => lang_admin('默认展开客服列表'),
                ),
                'serverlistp' => array(
                    'selecttype' => 'radio',
                    'select' => array("left"=> '左边',"right" => '右边'),
                    'remarks' => lang_admin('客服浮动框位置'),
                ),
                'worktime' => array(
                    'remarks' => lang_admin('工作时间'),
                ),
                'qq1name' => array(
                    'remarks' => lang_admin('客服职务'),
                ),
                'qq1' => array(
                    'remarks' => lang_admin('QQ号码'),
                ),
                'qq2name' => array(
                    'remarks' => lang_admin('客服职务'),
                ),
                'qq2' => array(
                    'remarks' => lang_admin('QQ号码'),
                ),
                'qq3name' => array(
                    'remarks' => lang_admin('客服职务'),
                ),
                'qq3' => array(
                    'remarks' => lang_admin('QQ号码'),
                ),
                'qq4name' => array(
                    'remarks' => lang_admin('客服职务'),
                ),
                'qq4' => array(
                    'remarks' => lang_admin('QQ号码'),
                ),
                'qq5name' => array(
                    'remarks' => lang_admin('客服职务'),
                ),
                'qq5' => array(
                    'remarks' => lang_admin('QQ号码'),
                ),
                'wangwangname' => array(
                    'remarks' => lang_admin('客服职务'),
                ),
                'wangwang' => array(
                    'remarks' => lang_admin('淘宝旺旺号码'),
                ),
                'aliname' => array(
                    'remarks' => lang_admin('客服职务'),
                ),
                'ali' => array(
                    'remarks' => lang_admin('阿里旺旺号码'),
                ),
                'skypename' => array(
                    'remarks' => lang_admin('客服职务'),
                ),
                'skype' => array(
                    'remarks' => lang_admin('Skype号码'),
                ),
                'weixin_pic' => array(
                    'selecttype' => 'image',
                    'remarks' => lang_admin('微信二维码'),
                ),
            ),
            "security"=>array(
                'filter_word' => array(
                    'remarks' => lang_admin('过滤字符'),
                ),
                'filter_x' => array(
                    'remarks' => lang_admin('替代字符'),
                ),
            ),
            "membersite"=>array(
                'reg_on' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('注册开关'),
                ),
                'site_login' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('是否显示用户登录'),
                ),
                'invitation_registration' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('邀请注册'),
                ),
            ),
            "discuss"=>array(
                'comment' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('是否启用'),
                ),
                'comment_list' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('显示评论列表'),
                ),
                'comment_num' => array(
                    'remarks' => lang_admin('内容页评论条数'),
                ),
                'comment_user' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('游客查看评论'),
                ),
                'comment_time' => array(
                    'selecttype' => 'select',
                    'select' => array(10=> '10秒',30 => '30秒',60 => '1分钟'),
                    'remarks' => lang_admin('评论时间间隔'),
                ),
                'comment_switch' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '游客',1 => '会员',2 => '禁止'),
                    'remarks' => lang_admin('评论条件'),
                ),
                'comment_title' => array(
                    'remarks' => lang_admin('评论页标题'),
                ),
                'reply_comment' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('多重回复'),
                ),
            ),
            "formsite"=>array(
                'guestformsubmit' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('游客表单提交'),
                ),
            ),
            "orders"=>array(
                'shoppingcart' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('购物车开关'),
                ),
                'memberbuy' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('会员购买'),
                ),
                'order_time' => array(
                    'selecttype' => 'select',
                    'select' => array(10=> '10秒',30 => '30秒',60 => '1分钟'),
                    'remarks' => lang_admin('订单时间间隔'),
                ),
            ),
            "guestbook"=>array(
                'guestbook_enable' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('是否启用'),
                ),
                'guestbook_list' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('显示留言列表'),
                ),
                'guestbook_time' => array(
                    'selecttype' => 'select',
                    'select' => array(10=> '10秒',30 => '30秒',60 => '1分钟'),
                    'remarks' => lang_admin('留言时间间隔'),
                ),
                'guestbook_user' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('游客查看留言'),
                ),
                'guestbook_switch' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '游客',1 => '会员',2 => '禁止'),
                    'remarks' => lang_admin('留言条件'),
                ),
                'guestbook_title' => array(
                    'remarks' => lang_admin('留言页标题'),
                ),
            ),
            "sitesetup"=>array(
                'website_list' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('站点列表'),
                ),
            ),
            "image"=>array(
                'watermark_open' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('是否启用'),
                ),
                'watermark_min_width' => array(
                    'remarks' => lang_admin('最小宽度'),
                ),
                'watermark_min_height' => array(
                    'remarks' => lang_admin('最小高度'),
                ),
                'watermark_path' => array(
                    'selecttype' => 'image',
                    'remarks' => lang_admin('水印路径'),
                ),
                'watermark_ts' => array(
                    'remarks' => lang_admin('透明度'),
                ),
                'watermark_qs' => array(
                    'remarks' => lang_admin('JPEG图片质量'),
                ),
                'watermark_pos' => array(
                    'remarks' => lang_admin('添加位置'),
                ),
            ),
            "upload"=>array(
                'upload_filetype' => array(
                    'selecttype' => 'textarea',
                    'remarks' => lang_admin('附件类型'),
                ),
                'upload_max_filesize' => array(
                    'remarks' => lang_admin('附件大小'),
                ),
            ),
            "ballot"=>array(
                'checkip' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('验证IP'),
                ),
                'timer' => array(
                    'remarks' => lang_admin('时间间隔'),
                ),
            ),
            "ditu"=>array(
                'ditu_APK' => array(
                    'remarks' => lang_admin('地图APK'),
                ),
                'ditu_width' => array(
                    'remarks' => lang_admin('地图宽度'),
                ),
                'ditu_height' => array(
                    'remarks' => lang_admin('地图高度'),
                ),
                'ditu_center_left' => array(
                    'remarks' => lang_admin('地图-经度'),
                ),
                'ditu_center_right' => array(
                    'remarks' => lang_admin('地图-纬度'),
                ),
                'ditu_level' => array(
                    'remarks' => lang_admin('显示级别'),
                ),
                'ditu_title' => array(
                    'remarks' => lang_admin('信息窗标题'),
                ),
                'ditu_content' => array(
                    'selecttype' => 'textarea',
                    'remarks' => lang_admin('信息窗内容'),
                ),
                'ditu_maker_left' => array(
                    'remarks' => lang_admin('标记点经度'),
                ),
                'ditu_maker_right' => array(
                    'remarks' => lang_admin('标记点纬度'),
                ),
                'ditu_explain' => array(
                    'remarks' => lang_admin('使用说明'),
                ),
            ),
            "mail"=>array(
                'send_type' => array(
                    'selecttype' => 'select',
                    'select' => array(0=> '请选择',1 => 'Sendmail',2 => 'SOCKET',3 => 'PHP函数'),
                    'remarks' => lang_admin('邮件发送方式'),
                ),
                'header_var' => array(
                    'selecttype' => 'select',
                    'select' => array(99=> '请选择',1 => 'CRLF分隔符(Windows)',0 => 'LF分隔符(Unix|Linux)',2 => 'CR分隔符(Mac)'),
                    'remarks' => lang_admin('邮件头的分隔符'),
                ),
                'kill_error' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '否',1 => '是'),
                    'remarks' => lang_admin('屏蔽错误提示'),
                ),
            ),
            "mail_socket"=>array(
                'smtp_mail_host' => array(
                    'remarks' => lang_admin('SMTP服务器'),
                ),
                'smtp_mail_port' => array(
                    'remarks' => lang_admin('SMTP端口'),
                ),
                'smtp_mail_auth' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '否',1 => '是'),
                    'remarks' => lang_admin('要求身份验证'),
                ),
                'smtp_user_add' => array(
                    'remarks' => lang_admin('发信人地址'),
                ),
                'smtp_mail_username' => array(
                    'remarks' => lang_admin('邮箱名'),
                ),
                'smtp_mail_password' => array(
                    'remarks' => lang_admin('密码'),
                ),
            ),
            "mail_php"=>array(
                'smtp_host' => array(
                    'remarks' => lang_admin('SMTP服务器'),
                ),
                'smtp_port' => array(
                    'remarks' => lang_admin('SMTP端口'),
                ),
            ),
            "mail_open"=>array(
                'email_gust_send_cust' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '否',1 => '是'),
                    'remarks' => lang_admin('留言发送客户邮箱'),
                ),
                'email_guest_send_admin' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '否',1 => '是'),
                    'remarks' => lang_admin('留言发送管理员邮箱'),
                ),
                'email_order_send_cust' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '否',1 => '是'),
                    'remarks' => lang_admin('订单发送客户邮箱'),
                ),
                'email_order_send_admin' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '否',1 => '是'),
                    'remarks' => lang_admin('订单发送管理员邮箱'),
                ),
                'email_form_on' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '否',1 => '是'),
                    'remarks' => lang_admin('自定义表单发送邮件'),
                ),
                'email_form_send_admin' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '否',1 => '是'),
                    'remarks' => lang_admin('自定义表单发送管理员邮箱'),
                ),
                'email_reg_on' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '否',1 => '是'),
                    'remarks' => lang_admin('注册用户发送邮件'),
                ),
            ),
            "vote"=>array(
                'vote_onlyone' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('投票只能表决一次'),
                ),
                'vote_auto_sms' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('发布投票自动发送短信'),
                ),
            ),
            "sms"=>array(
                'sms_explain' => array(
                    'remarks' => lang_admin('使用说明'),
                ),
                'sms_username' => array(
                    'remarks' => lang_admin('用户名'),
                ),
                'sms_password' => array(
                    'remarks' => lang_admin('密码'),
                ),
                'sms_on' => array(
                    'selecttype' => 'select',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('是否启用'),
                ),
                'sms_keyword' => array(
                    'remarks' => lang_admin('替换非法字符'),
                ),
                'sms_maxnum' => array(
                    'remarks' => lang_admin('最多发送'),
                ),
                'sms_reg_on' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '否',1 => '是'),
                    'remarks' => lang_admin('注册发送'),
                ),
                'sms_guestbook_on' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '否',1 => '是'),
                    'remarks' => lang_admin('留言发送'),
                ),
                'sms_order_on' => array(
                    'selecttype' => 'select',
                    'select' => array(0=> '否',1 => '是'),
                    'remarks' => lang_admin('订单发送'),
                ),
                'sms_form_on' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '否',1 => '是'),
                    'remarks' => lang_admin('表单发送'),
                ),
                'sms_guestbook_admin_on' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '否',1 => '是'),
                    'remarks' => lang_admin('确认留言'),
                ),
                'sms_form_admin_on' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '否',1 => '是'),
                    'remarks' => lang_admin('确认表单'),
                ),
                'sms_order_admin_on' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '否',1 => '是'),
                    'remarks' => lang_admin('确认订单'),
                ),
                'sms_consult_admin_on' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '否',1 => '是'),
                    'remarks' => lang_admin('弹开咨询'),
                ),
            ),
            "sms_contertall"=>array(
                'sms_manage' => array(
                    'remarks' => lang_admin('短信管理'),
                ),
            ),
            "verification"=>array(
                'verifycode' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '字符',2 => '拼图'),
                    'remarks' => lang_admin('验证码全局开关'),
                ),
                'pic_enable_info' => array(
                    'remarks' => lang_admin('提示'),
                ),
                'gee_id' => array(
                    'remarks' => lang_admin('极验验证后台ID'),
                ),
                'gee_key' => array(
                    'remarks' => lang_admin('极验验证后台KEY'),
                ),
                'mobilechk_enable_info' => array(
                    'remarks' => lang_admin('提示'),
                ),
                'mobilechk_enable' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('手机验证码开关'),
                ),
                'mobilechk_admin' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('后台登录短信验证开关'),
                ),
                'mobilechk_reg' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('注册手机短信验证'),
                ),
                'mobilechk_login' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('登录手机短信验证'),
                ),
                'mobilechk_buy' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('购买手机短信验证'),
                ),
                'mobilechk_form' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('自定义表单手机短信验证'),
                ),
                'mobilechk_comment' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('评论手机短信验证'),
                ),
                'mobilechk_guestbook' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '关',1 => '开'),
                    'remarks' => lang_admin('留言手机短信验证'),
                ),
            ),
            "shopping"=>array(
                'show_pice' => array(
                    'selecttype' => 'radio',
                    'select' => array(0=> '隐藏',1 => '显示'),
                    'remarks' => lang_admin('商品价格'),
                ),
            ),
            "template_user"=>array(
                'template_user_dir' => array(
                    'selecttype' => 'select',
                    'select' => front::$view->user_tpl_select(),
                    'remarks' => lang_admin('用户模板'),
                ),
            ),
        );
    }

    function gettitle_form()
    {
        $myconfig_gettitle_data=array(
            'site' => lang_admin("网站信息"),
            'websitesite' => lang_admin("网站自定义"),
            'information' => lang_admin("联系信息"),
            'langsite' => lang_admin("语言管理设置"),
            'filechecksite' => lang_admin("安全设置"),
            'phonesite' => lang_admin("手机版"),
            'dynamic' => lang_admin("动静态设置"),
            'spidersite' => lang_admin("蜘蛛统计设置"),
            'backupsite' => lang_admin("备份管理设置"),
            'customer' => lang_admin("客服列表"),
            'security' => lang_admin("字符过滤"),
            'membersite' => lang_admin("会员管理设置"),
            'discuss' => lang_admin("评论管理设置"),
            'formsite' => lang_admin("表单管理设置"),
            'orders' => lang_admin("订单管理设置"),
            'guestbook' => lang_admin("留言设置"),
            'sitesetup' => lang_admin("站点设置"),
            'image' => lang_admin("图片水印"),
            'upload' => lang_admin("附件设置"),
            'ballot' => lang_admin("投票设置"),
            'ditu' => lang_admin("地图设置"),
            'vote' => lang_admin("投票设置"),
            'verification' => lang_admin("验证码"),
            'shopping' => lang_admin("商品设置"),
        );
        $myconfig_gettitle_data[]=array(
            'template' => lang_admin("模板设置"),
            'template_shop' => lang_admin("商城模板"),
            'template_mobile' => lang_admin("手机模板"),
            'template_user' => lang_admin("其他模板"),
            'template_online' => lang_admin("在线模板"),
            'buymodules_online' => lang_admin("组件市场"),
        );
        $myconfig_gettitle_data[]=array(
            'mail' => lang_admin("邮件设置"),
            'mail_socket' => lang_admin("SOCKET"),
            'mail_php' => lang_admin("PHP函数"),
            'mail_open' => lang_admin("开关设置"),
        );
        $myconfig_gettitle_data[]=array(
            'sms' => lang_admin("短信设置"),
            'sms_contertall' => lang_admin("短信设置"),
        );
        return $myconfig_gettitle_data;
    }

    public static function set($name,$key)
    {
        //$where="name='".$name."' and (lang='all' or lang='".lang::getistemplate()."')";
        $where=array("name"=>$name,"lang"=>lang::getistemplate());
        myconfig::getInstance()->rec_update(array("key"=>$key),$where);
        $myconfig = self::getInstance();
        $myconfig->myconfig[lang::getistemplate()][$name]['key']=$key;
    }
    public static function setadmin($name,$key)
    {
        //$where="name='".$name."' and (lang='all' or lang='".lang::getisadmin()."')";
        $where=array("name"=>$name,"lang"=>lang::getisadmin());
        myconfig::getInstance()->rec_update(array("key"=>$key),$where);
        $myconfig = self::getInstance();
        $myconfig->myconfig[lang::getisadmin()][$name]['key']=$key;

    }
    public static function setall($name,$key)
    {
        myconfig::getInstance()->rec_update(array("key"=>$key),array("name"=>$name));
        $myconfig = self::getInstance();
        $myconfig->myconfig['all'][$name]['key']=$key;
    }

    public static function  getadmin($name){
       /* $myconfig_data=myconfig::getInstance()->getrow("name='".$name."' and lang='".lang::getisadmin()."'",'id desc','`name`,`key`');
        if (!is_array($myconfig_data)) {
            $myconfig_all_data = myconfig::getInstance()->getrow("name='" . $name . "' and lang='all'", 'id desc', '`name`,`key`');
            if (is_array($myconfig_all_data)) $myconfig_data = $myconfig_all_data;
        }*/
        $myconfig = self::getInstance();
        $myconfig_data=isset($myconfig->myconfig[lang::getisadmin()][$name])?$myconfig->myconfig[lang::getisadmin()][$name]:"";
        if (!is_array($myconfig_data)) {
            $myconfig_data=isset($myconfig->myconfig['all'][$name])?$myconfig->myconfig['all'][$name]:"";
        }
        if (is_array($myconfig_data)){
            if ("site_url"==$name){
                $domain=str_replace("https://","",$_SERVER['HTTP_HOST']);
                $domain=str_replace("http://","",$domain);
                if (substr($domain,-1)!="/"){
                    $domain=$domain.'/';
                }
                if (isset($_SERVER['HTTPS']) && ('1' == $_SERVER['HTTPS'] || 'on' == strtolower($_SERVER['HTTPS']))) {
                    $domain="https://".$domain;
                } elseif (isset($_SERVER['SERVER_PORT']) && ('443' == $_SERVER['SERVER_PORT'])) {
                    $domain="https://".$domain;
                }else{
                    $domain="http://".$domain;
                }
                if(strpos($myconfig_data["key"],$domain) == false){
                    return $domain;
                }
            }
            elseif ("ditu_content"==$name){
                $myconfig_data['key']=str_replace(array("\r\n", "\r", "\n"), " ", $myconfig_data['key']);
            }
            return $myconfig_data['key'];
        }
        else
            return "";
    }
    public static function  get($name){
        //内页幻灯片  --固定
        $arr = array(
            'cslide_width','cslide_height','cslide_number','cslide_time','cslide_style_position','cslide_text_color','cslide_input_bg',
            'cslide_input_color','cslide_btn_hover_color','cslide_btn_color','cslide_btn_width','cslide_btn_height','cslide_btn_shape',
            'cslide_button_size','cslide_button_color',
            'cslide_pic1','cslide_pic1_title','cslide_pic1_info','cslide_pic1_title_url','cslide_pic1_url',
            'cslide_pic2','cslide_pic2_title','cslide_pic2_info','cslide_pic2_title_url','cslide_pic2_url',
            'cslide_pic3','cslide_pic3_title','cslide_pic3_info','cslide_pic3_title_url','cslide_pic3_url',
            'cslide_pic4','cslide_pic4_title','cslide_pic4_info','cslide_pic4_title_url','cslide_pic4_url',
            'cslide_pic5','cslide_pic5_title','cslide_pic5_info','cslide_pic5_title_url','cslide_pic5_url',

        );
        //判断是否为特定字段  --图片字段
        if(in_array($name,$arr)){
            if ($name=="cslide_time"){
                $name="slide_time";
            }
            if ($name=="cslide_width"){
                $name="slide_width";
            }
            if ($name=="cslide_height"){
                $name="slide_height";
            }
            if ($name=="cslide_style_position"){
                $name="slide_style_position";
            }
            if ($name=="cslide_text_color"){
                $name="slide_text_color";
            }
            if ($name=="cslide_input_bg"){
                $name="slide_input_bg";
            }
            if ($name=="cslide_input_color"){
                $name="slide_input_color";
            }
            if ($name=="cslide_btn_hover_color"){
                $name="slide_btn_hover_color";
            }
            if ($name=="cslide_btn_color"){
                $name="slide_btn_color";
            }
            if ($name=="cslide_btn_width"){
                $name="slide_btn_width";
            }
            if ($name=="cslide_btn_height"){
                $name="slide_btn_height";
            }
            if ($name=="cslide_btn_shape"){
                $name="slide_btn_shape";
            }
            if ($name=="cslide_button_size"){
                $name="slide_button_size";
            }
            if ($name=="cslide_button_color"){
                $name="slide_button_color";
            }
            return self::getslide($name);
        }else{
            //判断是否为特定字段
           /* $myconfig_data=myconfig::getInstance()->getrow("name='".$name."' and lang='".lang::getistemplate()."'",'id desc','`name`,`key`');
            if (!is_array($myconfig_data)) {
                $myconfig_all_data = myconfig::getInstance()->getrow("name='" . $name . "' and lang='all'", 'id desc', '`name`,`key`');
                if (is_array($myconfig_all_data)) $myconfig_data = $myconfig_all_data;
            }*/
            $myconfig = self::getInstance();
            $myconfig_data=isset($myconfig->myconfig[lang::getistemplate()][$name])?$myconfig->myconfig[lang::getistemplate()][$name]:"";
            if (!is_array($myconfig_data)) {
                $myconfig_data=isset($myconfig->myconfig['all'][$name])?$myconfig->myconfig['all'][$name]:"";
            }
            if (is_array($myconfig_data)){
                if ("site_url"==$name){
                    $domain=str_replace("https://","",$_SERVER['HTTP_HOST']);
                    $domain=str_replace("http://","",$domain);
                    if (substr($domain,-1)!="/"){
                        $domain=$domain.'/';
                    }
                    if (isset($_SERVER['HTTPS']) && ('1' == $_SERVER['HTTPS'] || 'on' == strtolower($_SERVER['HTTPS']))) {
                        $domain="https://".$domain;
                    } elseif (isset($_SERVER['SERVER_PORT']) && ('443' == $_SERVER['SERVER_PORT'])) {
                        $domain="https://".$domain;
                    }else{
                        $domain="http://".$domain;
                    }
                    if(strpos($myconfig_data["key"],$domain) == false){
                        return $domain;
                    }
                }
                elseif ("ditu_content"==$name){
                    $myconfig_data['key']=str_replace(array("\r\n", "\r", "\n"), " ", $myconfig_data['key']);
                }
                return $myconfig_data['key'];
            }
        }
        return false;
    }
    public static function  getslide($name){
        $slide=slide::getInstance()->getrow(array("name"=>"内页切换图片","isdefault"=>1));
        if (is_array($slide)){
            if (array_key_exists($name, $slide)){
                return $slide[$name];
            }else{
                $slidechild=slidechild::getInstance()->getrows('slide_sid='.$slide['id'],5,'id asc');
                if ($name=="cslide_number"){
                    return count($slidechild);
                }
                $pic1 = array('cslide_pic1','cslide_pic1_title','cslide_pic1_info','cslide_pic1_title_url','cslide_pic1_url');
                $pic2 = array('cslide_pic2','cslide_pic2_title','cslide_pic2_info','cslide_pic2_title_url','cslide_pic2_url');
                $pic3 = array('cslide_pic3','cslide_pic3_title','cslide_pic3_info','cslide_pic3_title_url','cslide_pic3_url');
                $pic4 = array('cslide_pic4','cslide_pic4_title','cslide_pic4_info','cslide_pic4_title_url','cslide_pic4_url');
                $pic5 = array('cslide_pic5','cslide_pic5_title','cslide_pic5_info','cslide_pic5_title_url','cslide_pic5_url');
                if(in_array($name,$pic1)){
                    return self::getslidechild($name,$slidechild[0]);
                }
                elseif(in_array($name,$pic2)){
                    return self::getslidechild($name,$slidechild[1]);
                }
                elseif(in_array($name,$pic3)){
                    return self::getslidechild($name,$slidechild[2]);
                }
                elseif(in_array($name,$pic4)){
                    return self::getslidechild($name,$slidechild[3]);
                }
                elseif(in_array($name,$pic5)){
                    return self::getslidechild($name,$slidechild[4]);
                }
                elseif($slidechild[$name]){
                    return $slidechild[$name];
                }else
                    return "";
            }

        }
    }
    public static function  getslidechild($name,$slidechild){
        $langurl=lang::getistemplate();
        $slide_title=unserialize($slidechild['slide_title']);
        $new_slide_key=is_array($slide_title)?$slide_title[$langurl]:$slidechild['slide_title'];

        $slide_subtitle=unserialize($slidechild['slide_subtitle']);
        $new_slide_subtitle=is_array($slide_subtitle)?$slide_subtitle[$langurl]:$slidechild['slide_subtitle'];

        $slide_butname=unserialize($slidechild['slide_butname']);
        $new_slide_butname=is_array($slide_butname)?$slide_butname[$langurl]:$slidechild['slide_butname'];

        $slide_url=unserialize($slidechild['slide_url']);
        $new_slide_url=is_array($slide_url)?$slide_url[$langurl]:$slidechild['slide_url'];
        if($name=="cslide_pic1_title" || $name=="cslide_pic2_title" || $name=="cslide_pic3_title"
            || $name=="cslide_pic4_title" || $name=="cslide_pic5_title"){
            return $new_slide_key;
        }
        elseif($name=="cslide_pic1_info" || $name=="cslide_pic2_info" || $name=="cslide_pic3_info"
            || $name=="cslide_pic4_info" || $name=="cslide_pic5_info"){
            return $new_slide_subtitle;
        }
        elseif($name=="cslide_pic1_title_url" || $name=="cslide_pic2_title_url" || $name=="cslide_pic3_title_url"
            || $name=="cslide_pic4_title_url" || $name=="cslide_pic5_title_url"){
            return $new_slide_butname;
        }
        elseif($name=="cslide_pic1_url" || $name=="cslide_pic2_url" || $name=="cslide_pic3_url"
            || $name=="cslide_pic4_url" || $name=="cslide_pic5_url"){
            return $new_slide_url;
        } elseif($name=="cslide_pic1" || $name=="cslide_pic2" || $name=="cslide_pic3"
            || $name=="cslide_pic4" || $name=="cslide_pic5"){
            return $slidechild['slide_path'];
        }else
            return "";

    }



    public static function  getdefault($name){
      /* $myconfig_data=myconfig::getInstance()->getrow("name='".$name."' and lang='".lang::getisdefault()."'",'id desc','`name`,`key`');
        if (!is_array($myconfig_data)){
            $myconfig_all_data=myconfig::getInstance()->getrow("name='".$name."' and lang='all'",'id desc','`name`,`key`');
            if (is_array($myconfig_all_data))$myconfig_data=$myconfig_all_data;
        }*/
        $myconfig = self::getInstance();
        $myconfig_data=isset($myconfig->myconfig[lang::getisdefault()][$name])?$myconfig->myconfig[lang::getisdefault()][$name]:"";
        if (!is_array($myconfig_data)) {
            $myconfig_data=$myconfig->myconfig['all'][$name];
        }
        if (is_array($myconfig_data)){
            if ("site_url"==$name){
                $domain=str_replace("https://","",$_SERVER['HTTP_HOST']);
                $domain=str_replace("http://","",$domain);
                if (substr($domain,-1)!="/"){
                    $domain=$domain.'/';
                }
                if (isset($_SERVER['HTTPS']) && ('1' == $_SERVER['HTTPS'] || 'on' == strtolower($_SERVER['HTTPS']))) {
                    $domain="https://".$domain;
                } elseif (isset($_SERVER['SERVER_PORT']) && ('443' == $_SERVER['SERVER_PORT'])) {
                    $domain="https://".$domain;
                }else{
                    $domain="http://".$domain;
                }
                if(strpos($myconfig_data["key"],$domain) == false){
                    return $domain;
                }
            }
            return $myconfig_data['key'];
        }
        else
            return false;
    }

    static function modify_admin($var, $key = null, $value = null,$database=false)
    {
        //对数据库配置修改保存  修改数据库的配置文件
        if($database){
           config::modify($var,$key,$value,$database);
        }else{
            //配置文件中要统一的特定字段
            $arr = myconfig::getall();
            if (is_array($var)){
                foreach ($var as $key => $value) {
                    //判断是否为特定字段  是的话 修改全部语言的配置
                    if(in_array($key,$arr)){
                        myconfig::setall($key,$value);
                    }else{
                        myconfig::setadmin($key,$value);
                    }
                }
            }else {
                if (!$key || !$value)
                    return;
                //判断是否为特定字段  是的话 修改全部语言的配置
                if(in_array($key,$arr)){
                    myconfig::setall($key,$value);
                }else{
                    myconfig::setadmin($key,$value);
                }
            }
        }
    }
    static function modify($var, $key = null, $value = null,$database=false)
    {
        //对数据库配置修改保存  修改数据库的配置文件
        if($database){
            config::modify($var,$key,$value,$database);
        }
        else{
            //配置文件中要统一的特定字段
            $arr = myconfig::getall();
            if (is_array($var))
                foreach ($var as $key => $value) {
                    //判断是否为特定字段  是的话 修改全部语言的配置
                    if (in_array($key, $arr)) {
                        myconfig::setall($key,$value);
                    } else {
                        myconfig::set($key,$value);
                    }

                }
            else {
                if (!$key || !$value)
                    return;
                //判断是否为特定字段  是的话 修改全部语言的配置
                if (in_array($key, $arr)) {
                    myconfig::setall($key,$value);
                } else {
                    myconfig::set($key,$value);
                }
            }
        }

    }

    //发挥特定字段
    public static function  getall(){
       $all_data=array();
       $myconfig_data=myconfig::getInstance()->getrows(array("lang"=>"all"),0);
       if (is_array($myconfig_data)){
            foreach ($myconfig_data as $val){
                $all_data[]=$val['name'];
            }
       }
       return $all_data;
    }

}
# This program is an open source system, commercial use, please consciously to purchase commercial license.
# Copyright (C) CmsEasy Co., Ltd. (https://www.CmsEasy.cn). All rights reserved.