<?php
# CmsEasy Enterprise Content Management System
# Copyright (C) CmsEasy Co.,Ltd (https://www.CmsEasy.cn). All rights reserved.
class type_act extends act
{
    function list_action()
    {

        $this->view->page = front::get('page') ? front::get('page') : 1;
        $this->pagesize = config::get('list_pagesize');
        $limit = (($this->view->page - 1) * $this->pagesize) . ',' . $this->pagesize;
        $type =type::getInstance();
        $typeid = intval(front::get('typeid'));

        if (front::get("cache")==1 &&  config::get('list_type_php') == 1)
            $cache=true;
        else
            $cache=false;
        //判断是否静态生成
        $path_cache="";
        if ($cache){
            $path_cache = type::url($typeid, $this->view->page > 1 ? $this->view->page : 1, lang::getisadmin(), false);
            $path_cache = type::url_rule($path_cache);
            tool::mkdir(dirname($path_cache));
        }

        $topid=type::gettopparent($typeid);
        $this->view->topid = $topid;
        $types = $type->sons($typeid);
        $types[] = $typeid;
        $where = 'typeid in (' . implode(',', $types) . ') AND checked=1 AND state=1 ';
        $where.=' and langid = "'.lang::getlangid(lang::getistemplate()).'"';
        $this->view->type = $type->getrow($typeid);
        $this->view->type[$topid] = $type->getrow($topid);
        $this->view->pages = @$this->view->type['ispages'];
        $this->view->typeid = $typeid;
        $archive = new archive();
        $archives = $archive->getrows($where, $limit, 'listorder=0,listorder asc,aid desc');
        foreach ($archives as $order => $arc) {
            $archives[$order]['url'] = archive::url($arc);
            $archives[$order]['typename'] = type::name($arc['typeid']);
            $archives[$order]['typeurl'] = type::url($arc['typeid']);
            $archives[$order]['adddate'] = sdate($arc['adddate']);
            $archives[$order]['stitle'] = strip_tags($arc['title']);
            $archives[$order]['sthumb'] = @strstr($arc['thumb'], "http://") ? $arc['thumb'] : config::get('base_url') . '/' . $arc['thumb'];
			$prices = getPrices($archives[$order]['attr2']);
            $archives[$order]['attr2'] = $prices['price'];
            $archives[$order]['oldprice'] = $prices['oldprice'];
        }
        $this->view->archives = $archives;
        $this->view->record_count = $archive->rec_count($where);
        front::$record_count = $this->view->record_count;
        $this->type = type::getInstance();
        $template = $this->type->type[front::get('typeid')]['template'];
        if ($template && file_exists(TEMPLATE . '/' . $this->view->_style . '/' . $template))
            $this->out($template,$cache,$path_cache);
        else {
            $tpl = type::gettemplate($this->view->typeid);
            if (type::getishtml($this->view->typeid)) {
                $path = ROOT . type::url($this->view->typeid, @front::$get['page'] > 1 ? front::$get['page'] : null,config::get('lang_type'),$this->view->type['htmldir']);
                if (!preg_match('/\.[a-zA-Z]+$/', $path)) $path = rtrim(rtrim($path, '/'), '\\') . '/index.html';
                $this->cache_path = $path;
            }
            $this->out($tpl,$cache,$path_cache);
        }
    }


    function gettypeoption_action(){
        $data=type::getoption();
        $select="";
        $data[0]=lang_admin('multiple_choices_to_join_the_type');
        foreach ($data as $k => $d) {
            $select .= "<option value=\"$k\"";
            if (isset($_GET['id']) && ($_GET['table'] == 'category' || $_GET['table'] == 'type')) {
                if ($_GET['id'] == $k) {
                    $select .= ' disabled ';
                }
            }
            $select .= ">$d</option>";
        }
        echo $select;
        exit;
    }

    function gettypelist_action(){
        $token =front::get("token");
        echo type::gethtmltypedata_new(type::listtypedata_new(),false,0,$token);
        exit;
    }

    function end()
    {
        $this->render();
    }

    function out($tpl,$cache=false,$path_cache="")
    {
        if (front::$debug) return;
        if ($cache){
            $content= $this->render($tpl,$cache);
            file_put_contents($path_cache, $content);
            $path_cache = dirname($path_cache) . '/index.html';
            if ($this->view->page==1 && $path_cache != ROOT . '/index.html') {
                file_put_contents($path_cache, $content);
            }
            $return_data=array("suc"=>1);
            echo json_encode($return_data);
            exit;
        }
        $this->render($tpl);
        $this->out = true;
        exit;
    }
}
# This program is an open source system, commercial use, please consciously to purchase commercial license.
# Copyright (C) CmsEasy Co., Ltd. (https://www.CmsEasy.cn). All rights reserved.
