<?php
# CmsEasy Enterprise Content Management System
# Copyright (C) CmsEasy Co.,Ltd (https://www.CmsEasy.cn). All rights reserved.
class tag_act extends act {
    function show_action() {
        if (front::get('page'))
            $page = front::get('page');
        else
            $page = 1;
        $this->view->page = $page;
        $limit = (($this->view->page - 1) * $this->pagesize) . ',' .config::get('list_pagesize');
        $tag=tag::getInstance();
        if (front::get('tag')){
            $tagname=urldecode(front::get('tag'));
            $tag=$tag->getrow('tagname="'.$tagname.'" and langid='.lang::getlangid(lang::getistemplate()));
        }
        if (front::get('tagid')){
            $tagid=front::get('tagid');
            $tag=$tag->getrow('tagid="'.$tagid.'" and langid='.lang::getlangid(lang::getistemplate()));
            if (is_array($tag))
            $tagname=$tag['tagname'];
        }
        if(preg_match('/union/i',$tagname) || preg_match('/"/i',$tagname) ||preg_match('/\'/i',$tagname)){
        	exit(lang('illegal_parameter'));
        }

        if (front::get("cache")==1 &&  config::get('tag_html') == 1)
            $cache=true;
        else
            $cache=false;
        //判断是否静态生成
        $path_cache="";
        if ($cache){
            $path_cache =tag::url($tagname,$page,lang::getisadmin(),false);
            $path_cache = tag::url_rule($path_cache);
            tool::mkdir(dirname($path_cache));
        }
        $tagid=$tag['tagid'];
        $archives=array();
        if($tagid) {
            $arctag=new arctag();
            if(front::get('page')) $page=front::get('page');
            else $page=1;
            $this->view->page=$page;
            $this->view->pagesize=config::get('list_pagesize');
            $this->view->record_count=$arctag->rec_count('tagid='.$tagid);
            if($this->view->record_count>$this->view->pagesize)
                $this->view->pages=true;
            front::$record_count=$this->view->record_count;

            $arctags=$arctag->getrows('tagid='.$tagid,0);
            $arcids=array();
            foreach($arctags as $arctag) {
                $arcids[]=$arctag['aid'];
            }

            $archive=new archive();
            $where='checked=1';
            if(count($arcids)>0){
                $where=' aid in ('.implode(',',$arcids).') ';
            }
            $limit=(($this->view->page-1)*$this->view->pagesize).','.$this->view->pagesize;
            $archives=$archive->getrows($where,$limit,'aid desc');
            $this->view->pages = count($archives);
            $this->view->record_count = $archive->rec_count($where);
            front::$record_count = $this->view->record_count;

            foreach($archives as $order=>$arc) {
                $archives[$order]['url']=archive::url($arc);
                $archives[$order]['catname']=category::name($arc['catid']);
                $archives[$order]['caturl']=category::url($arc['catid']);
                $archives[$order]['adddate']= sdate($arc['adddate']);
                $archives[$order]['stitle']= strip_tags($arc['title']);
            }
        }
        else echo lang('label_information_does_not_exist');
        $this->view->tag=$tagname;
        $this->view->tags=$tag;
        $this->view->archives=$archives;
        $this->out(null,$cache,$path_cache);
    }
    function out($tpl=null,$cache=false,$path_cache="")
    {
        if (front::$debug) return;
        if ($cache){
            $content= $this->render($tpl,$cache);
            file_put_contents($path_cache, $content);
            $path_cache = dirname($path_cache) . '/index.html';
            if ($this->view->page==1 && $path_cache != ROOT . '/index.html') {
                file_put_contents($path_cache, $content);
            }
            $return_data=array("suc"=>1);
            echo json_encode($return_data);
            exit;
        }
        $this->render($tpl);
        $this->out = true;
        exit;
    }
}
# This program is an open source system, commercial use, please consciously to purchase commercial license.
# Copyright (C) CmsEasy Co., Ltd. (https://www.CmsEasy.cn). All rights reserved.
