<?php
# CmsEasy Enterprise Content Management System
# Copyright (C) CmsEasy Co.,Ltd (https://www.CmsEasy.cn). All rights reserved.
class special_act extends act
{
    function list_action()
    {
        $this->view->page = intval(front::get('page')) ? intval(front::get('page')) : 1;
        $this->pagesize = intval(config::get('list_pagesize'));
        $limit = (($this->view->page - 1) * $this->pagesize) . ',' . $this->pagesize;
        $special = special::getInstance();
        $where= ' langid = "'.lang::getlangid(lang::getistemplate()).'"';
        $specials = $special->getrows($where, $limit, 'listorder,spid desc');
        foreach ($specials as $order => $sp) {
            $specials[$order]['url'] = special::url($sp['spid']);
        }
        $this->view->specials = $specials;
        $this->view->record_count = $special->rec_count('');
        front::$record_count = $this->view->record_count;
        $this->view->page = true;
    }

    function show_action()
    {
        $this->view->page = intval(front::get('page')) ? intval(front::get('page')) : 1;
        $this->pagesize = intval(config::get('list_pagesize'));
        $limit = (($this->view->page - 1) * $this->pagesize) . ',' . $this->pagesize;
        $special = special::getInstance();
        $spid = intval(front::get('spid'));
        $where= 'spid='.$spid.' and langid = "'.lang::getlangid(lang::getisadmin()).'"';
        $this->view->special = $special->getrow($where);

        if (front::get("cache")==1 &&  config::get('list_type_php') == 1)
            $cache=true;
        else
            $cache=false;
        //判断是否静态生成
        $path_cache="";
        if ($cache){
            $path_cache =special::url($spid,$this->view->special['ishtml'],$this->view->page,$this->view->special['htmldir'],lang::getisadmin(),false);
            $path_cache = special::url_rule($path_cache);
            tool::mkdir(dirname($path_cache));
        }

        //$where= 'spid='.$spid.' and langid = "'.lang::getlangid(config::getisadmin('lang_type')).'"';

        $this->view->special['url'] = special::url($spid);
        $this->view->pages = true;
        $archive =archive::getInstance();
        $where= 'checked=1 and spid='.$spid.' and langid = "'.lang::getlangid(lang::getisadmin()).'"';
        $archives = $archive->getrows($where, $limit);
        foreach ($archives as $order => $arc) {
            $archives[$order]['url'] = archive::url($arc);
            $archives[$order]['catname'] = category::name($arc['catid']);
            $archives[$order]['caturl'] = category::url($arc['catid']);
            $archives[$order]['adddate'] = sdate($arc['adddate']);
            $archives[$order]['stitle'] = strip_tags($arc['title']);
        }
        $tpl = $this->view->special['template'];
        $this->view->archives = $archives;
        $this->view->record_count = $archive->rec_count(array('spid'=>$spid));
        front::$record_count = $this->view->record_count;
        $this->view->spid = front::get('spid');
        if ($tpl) {
            $this->out($tpl,$cache,$path_cache);
        }else{
            $this->out(null,$cache,$path_cache);
        }

    }

    function getspecialoption_action(){
        $data=special::getoption();
        $select="";
        $data[0]=lang_admin('multiple_choices_to_join_the_theme');
        foreach ($data as $k => $d) {
            $select .= "<option value=\"$k\"";
            if (isset($_GET['id']) && ($_GET['table'] == 'category' || $_GET['table'] == 'type')) {
                if ($_GET['id'] == $k) {
                    $select .= ' disabled ';
                }
            }
            $select .= ">$d</option>";
        }
        echo $select;
        exit;
    }

    function out($tpl,$cache=false,$path_cache="")
    {
        if (front::$debug) return;
        if ($cache){
            $content= $this->render($tpl,$cache);
            file_put_contents($path_cache, $content);
            $path_cache = dirname($path_cache) . '/index.html';
            if ($this->view->page==1 && $path_cache != ROOT . '/index.html') {
                file_put_contents($path_cache, $content);
            }
            $return_data=array("suc"=>1);
            echo json_encode($return_data);
            exit;
        }
        $this->render($tpl);
        $this->out = true;
        exit;
    }

    function end()
    {
        $this->render();
    }
}
# This program is an open source system, commercial use, please consciously to purchase commercial license.
# Copyright (C) CmsEasy Co., Ltd. (https://www.CmsEasy.cn). All rights reserved.
