<?php
# CmsEasy Enterprise Content Management System
# Copyright (C) CmsEasy Co.,Ltd (https://www.CmsEasy.cn). All rights reserved.
if (!defined('ROOT')) exit('Can\'t Access !');

class usermanage_admin extends admin
{
    function init()
    {
        if (!front::get('page')) front::$get['page'] = 1;
        $this->_pagesize = config::getadmin('manage_pagesize');

        $this->table = front::get('manage');
        $this->_table = new  $this->table;
    }

    function zanarchivelist_action(){
        $where = " praise <>'' ";
        $zanarchiveData =$this->_table->getrows($where, 0, 'adddate desc', $this->_table->getcols('manage'));
        $data=array();
        if (is_array($zanarchiveData)){
            //获取到点赞的数量
            foreach ($zanarchiveData as $key=>$val){
                $praise = explode(',',$val['praise']);
                $zanarchiveData[$key]['username_zan_num']=count($praise);
            }
            foreach ($zanarchiveData as $val){
                $praise = explode(',',$val['praise']);
                for($index=0;$index<count($praise);$index++){
                    $praise_array = explode(':',$praise[$index]);
                    $val['username']=$praise_array[0];
                    $val['username_zanadddate']=isset($praise_array[1])?$praise_array[1]:"";
                    $data[]=$val;
                }

            }
        }
        $this->view->record_count = $this->_table->record_count;
        $data=$this->pagedata($data,front::$get['page'],$this->_pagesize);

        //设置默认
        if (!isset(front::$get['type']) || !front::$get['type']){
            front::$get['type']="time_desc";
        }
        if(front::$get['type']=="time_desc"){
            $data = $this->array_sort($data,'username_zanadddate','desc');
        }
        else if(front::$get['type']=="time_asc"){
            $data = $this->array_sort($data,'username_zanadddate',"asc");
        }
        else if(front::$get['type']=="zan_desc"){
            $data = $this->array_sort($data,'username_zan_num',"desc");
        }
        else if(front::$get['type']=="zan_asc"){
            $data = $this->array_sort($data,'username_zan_num',"asc");
        }

        $this->view->data = $data;
    }

    /**
     * 二维数组排序
     * @param array $arr 需要排序的二维数组
     * @param string $keys 所根据排序的key
     * @param string $type 排序类型，desc、asc
     * @return array $new_array 排好序的结果
     */
    function array_sort($arr, $keys, $type = 'desc')
    {
        $key_value = $new_array = array();
        foreach ($arr as $k => $v) {
            $key_value[$k] = $v[$keys];
        }
        if ($type == 'asc') {
            asort($key_value);
        } else {
            arsort($key_value);
        }
        reset($key_value);
        foreach ($key_value as $k => $v) {
            $new_array[$k] = $arr[$k];
        }
        return $new_array;
    }

    function collectlist_action(){
        $where = "collect <> '' ";
        $data=array();
        $userdata=$this->_table->getrows($where, 0, '', $this->_table->getcols('manage'));
        foreach ($userdata as $val){
            $collect = explode(',',$val['collect']);
            for($index=0;$index<count($collect);$index++){
                $collect_array = explode(':',$collect[$index]);
                $archive=archive::getInstance()->getrow("aid=".$collect_array[0]);
                if (is_array($archive)){
                    $archive['username']=$val['username'];
                    $archive['username_collectdate']=isset($collect_array[1])?$collect_array[1]:"";
                    $data[]=$archive;
                }
            }

        }

        //记录收藏数
        $collect_num_array=array();
        foreach ($data as $val){
            if (!array_key_exists($val['aid'], $collect_num_array)){
                $collect_num_array[$val['aid']]=1;
            }else{
                $collect_num_array[$val['aid']]=$collect_num_array[$val['aid']]+1;
            }
        }
        //收藏数赋值进去
        foreach ($data as $key=>$val){
            $data[$key]['username_collect_num']=$collect_num_array[$val['aid']];
        }

        $this->view->record_count = $this->_table->record_count;
        $data=$this->pagedata($data,front::$get['page'],$this->_pagesize);

        //设置默认
        if (!isset(front::$get['type']) || !front::$get['type']){
            front::$get['type']="time_desc";
        }
        if(front::$get['type']=="time_desc"){
            $data = $this->array_sort($data,'username_collectdate','desc');
        }
        else if(front::$get['type']=="time_asc"){
            $data = $this->array_sort($data,'username_collectdate',"asc");
        }
        else if(front::$get['type']=="collect_desc"){
            $data = $this->array_sort($data,'username_collect_num',"desc");
        }
        else if(front::$get['type']=="collect_asc"){
            $data = $this->array_sort($data,'username_collect_num',"asc");
        }

        $this->view->data =$data;
    }

    //分页
    function pagedata($data,$page,$size){
        $index=1;
        $returndata=array();
        if($page==1){
            if(is_array($data)) {
                foreach ($data as $key => $val) {
                    if ($index <= $size) {
                        $returndata[$key] = $val;
                    }
                    $index++;
                }
            }
        }else{
            if(is_array($data)) {
                foreach ($data as $key => $val) {
                    if ($index > ($page - 1) * $size && $index <= $page * $size) {
                        $returndata[$key] = $val;
                    }
                    $index++;
                }
            }
        }
        return $returndata;
    }

    function end()
    {
        $this->render();
    }
}
# This program is an open source system, commercial use, please consciously to purchase commercial license.
# Copyright (C) CmsEasy Co., Ltd. (https://www.CmsEasy.cn). All rights reserved.
