<?php
# CmsEasy Enterprise Content Management System
# Copyright (C) CmsEasy Co.,Ltd (https://www.CmsEasy.cn). All rights reserved.
if (!defined('ROOT'))
    exit('Can\'t Access !');
class config_admin extends admin {
    function init() {
        //清空缓存---内容商品的
        if((front::get('act') == 'system')  && front::post('submit')){
            user::deletesession();
            category::deletesession();
            type::deletesession();
            special::deletesession();
        }
    }

    function getcnzz_action(){
        $cnzz = new cnzz();
        $infos = $cnzz->getinfo();
        config::modify(array('cnzz_user' => $infos[0]));
        config::modify(array('cnzz_pass' => $infos[1]));
        front::redirect(url('config/system/set/cnzz'));
    }
    //后台切换语言包
    function setadminlang_action(){
        if(front::get('langurl') != '' ){
            lang::setisadmin(front::get('langurl'));
        }
        //可视化
        if (front::get('visual'))
            echo '<script>window.location.href="'.url('template/visual',true).'";</script>';
        else
            echo '<script>window.location.href="'.url('index/index',true).'";</script>';
        exit;
    }
    private function setRewriteFile($urlrewrite_on)
    {
        $base = config::getadmin('base_url');
        if ($urlrewrite_on) {
            if (stristr($_SERVER['SERVER_SOFTWARE'], 'Apache') || stristr($_SERVER['SERVER_SOFTWARE'], 'IIS6')) {
                $htaccess = 'RewriteEngine on' . "\n";
                //$htaccess.= 'RewriteBase '.$base."\n";
                $htaccess .= 'RewriteCond %{REQUEST_FILENAME} !-d' . "\n";
                $htaccess .= 'RewriteCond %{REQUEST_FILENAME} !-f' . "\n";
                $htaccess .= 'RewriteRule !\.(mp3|mp4|wmv|wma|rm|rmvb|js|ico|gif|jpeg|jpg|png|css|swf|php|html|shtml|xml|xsl|wsdl|xslt|eot|svg|ttf|woff|woff2|map|txt)$ ' . $base . '/index.php [NC]' . "\n";
                $httpdurl = '.htaccess';
                $httpd = $htaccess;
            } else if (stristr($_SERVER['SERVER_SOFTWARE'], 'IIS/7') || stristr($_SERVER['SERVER_SOFTWARE'], 'IIS/10')) {
                $web = '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
                $web .= '<configuration>' . "\n";
                $web .= '<system.webServer>' . "\n";
                $web .= '<rewrite>' . "\n";
                $web .= '<rules>' . "\n";
                $web .= '<rule name="CmsEasy Url Rewrite">' . "\n";
                $web .= '<match url="\.(mp3|mp4|wmv|wma|rm|rmvb|js|ico|gif|jpeg|jpg|png|css|swf|php|html|shtml|xml|xsl|wsdl|xslt|eot|svg|ttf|woff|woff2|map|txt)$" negate="true" />' . "\n";
                $web .= '<conditions logicalGrouping="MatchAll">' . "\n";
                $web .= '<add input="{REQUEST_FILENAME}" matchType="IsDirectory" ignoreCase="false" negate="true" />' . "\n";
                $web .= '<add input="{REQUEST_FILENAME}" matchType="IsFile" ignoreCase="false" negate="true" />' . "\n";
                $web .= '</conditions>' . "\n";
                $web .= '<action type="Rewrite" url="index.php" />' . "\n";
                $web .= '</rule>' . "\n";
                $web .= '</rules>' . "\n";
                $web.= '</rewrite>'."\n";
                $web.= '<httpErrors errorMode="Custom">'."\n";
                $web.= '<remove statusCode="404" subStatusCode="-1" />'."\n";
                $web.= '<error statusCode="404" prefixLanguageFilePath="" path="/404.php" responseMode="ExecuteURL" />'."\n";
                $web.= '</httpErrors>'."\n";
                $web .= '</system.webServer>' . "\n";
                $web .= '</configuration>' . "\n";
                $httpdurl = 'web.config';
                $httpd = $web;
            } else if (stristr($_SERVER['SERVER_SOFTWARE'], 'nginx')) {
                $htaccess = 'if ($request_filename !~* \.(mp3|mp4|wmv|wma|rm|rmvb|js|ico|gif|jpeg|jpg|png|css|swf|php|html|shtml|xml|xsl|wsdl|xslt|eot|svg|ttf|woff|woff2|map|txt$)) {' . "\n";
                $htaccess .= 'rewrite .* ' . $base . '/index.php last;' . "\n";
                $htaccess .= '}' . "\n";
                $httpdurl = '.htaccess';
                $httpd = $htaccess;
            } else {
                $httpd = '[ISAPI_Rewrite]' . "\n";
                $httpd .= '# 3600 = 1 hour' . "\n";
                $httpd .= 'CacheClockRate 3600' . "\n";
                $httpd .= 'RepeatLimit 32' . "\n";
                $httpd .= 'RewriteRule !\.(mp3|mp4|wmv|wma|rm|rmvb|js|ico|gif|jpeg|jpg|png|css|swf|php|html|shtml|xml|xsl|wsdl|xslt|eot|svg|ttf|woff|woff2|map|txt)$ ' . $base . '/index.php [L]' . "\n";
                $httpdurl = 'httpd.ini';
            }
            if (!file_exists(ROOT . '/' . $httpdurl)){
                $fp = fopen(ROOT . '/' . $httpdurl, 'w');
                fputs($fp, $httpd);
                fclose($fp);
            }
        } else {
            if(config::getadmin('autoDelRewriteFile')){
                @unlink(ROOT . '/httpd.ini');
                @unlink(ROOT . '/.htaccess');
                @unlink(ROOT . '/web.config');
            }
        }
    }
    function _url($action = 'getmoinf') {
        form_admin::init();
        $this->__table=new defind($this->table);
        $pars=array(
            'action'=>$action,
            'tel'=>config::getadmin('tel'),
            'sitename'=>config::getadmin('sitename'),
            'site_url'=>config::getadmin('site_url'),
            'encoding'=>'utf-8',
            'host'=>$_SERVER['HTTP_HOST'],
            'version'=>'cmseasy3.0',
            'release'=>config::getadmin('version'),
            'os'=>PHP_OS,
            'php'=>phpversion(),
            'mysql'=>$this->__table->verison(),
            'browser'=>urlencode($_SERVER['HTTP_USER_AGENT']),
            'address'=>config::getadmin('address'),
            'email'=>config::getadmin('email'),
            'serverip'=>$_SERVER['REMOTE_ADDR'],
            'serverfilename'=>urlencode($_SERVER['SCRIPT_FILENAME']),
        );
        $data=http_build_query($pars);
        $verify=md5($data.config::getadmin('email'));
        return 'http://info.cmseasy.cn/server/upgrade.php?'.$data.'&verify='.$verify;
    }
    function config_info() {
    }
    function remove_action() {
        chkpw('cache_update');
        session::set('user_buy_all', "");  //清空服务端登陆缓存
        session::set('buymodules_lang', "");  //清空组件语言缓存
        session::set('user_buy_license', "");  //清空授权缓存
        front::remove(ROOT.'/cache/data');
        front::remove(ROOT.'/cache/template');
        front::remove(ROOT.'/cache/view');
        front::remove(ROOT.'/cache/downloads');
        front::remove(ROOT.'/cache/template_admin');
        //清空全部语言
        $langdata=getlang();
        if($langdata != ""){
            foreach ($langdata as $key=>$val){
                front::remove(ROOT.'/cache/'.$val['langurlname']);
                front::remove(ROOT.'/'.$val['langurlname'].'/template');
            }
        }
        unlink(ROOT.'/lang/config/lang_all.php');
        user::deletesession();
        category::deletesession();
        type::deletesession();
        special::deletesession();
        $user=new user();
        $user->close_db();
        cookie::del('passinfo');
        front::flash(lang_admin('cache').lang_admin('update').lang_admin('success'));
        front::redirect(url('index',true));
    }
    function sms_action() {
    }
    function hottag_action(){
        $set=settings::getInstance();
        if(front::post('submit')){
            $var=front::$post;
            unset($var['submit']);
            $set->rec_replace(array('value' => addslashes(serialize($var)), 'tag' => 'table-hottag', 'array' => addslashes(var_export($var, true))));
            event::log(lang_admin('tags').lang_admin('modify'),lang_admin('success'));
            front::flash(lang_admin('tags').lang_admin('modify').lang_admin('success'));
        }
        $sets=$set->getrow(array('tag'=>'table-hottag'));
        if(empty($sets)){
            $set->rec_insert(array('tag'=>'table-hottag'));
            $sets=$set->getrow(array('tag'=>'table-hottag'));
        }
        if(empty($sets['value']))
            $this->view->hottags = NULL;
        else
            $this->view->hottags =  unserialize($sets['value']);
    }
    function index_action(){
    }
    //打开多点地图
    function atlas_action(){
        if(session::get('ver') != 'corp'){
            front::alert(lang_admin('unauthorized_access'));
        }
        $atlasmap=new atlasmap();
        $atlasmaplist = $atlasmap->getrows('', 0,'id desc ');
        $this->view->data =$atlasmaplist;
        $this->view->atlasmaplist = json_encode($atlasmaplist);
    }
    //地图插入节点
    function saveatlas_action(){
        $returndata=array();
        $atlasmap=new atlasmap();
        $insert = $atlasmap->rec_insert(front::$post);
        if ($insert < 1) {
            $returndata['message']= lang_admin('add_to').lang_admin('failure');
        }
        else {
            $returndata['message']= lang_admin('add_to').lang_admin('success');
        }
        $atlasmaplist = $atlasmap->getrows('', 1,'id desc ');
        if(is_array($atlasmaplist)){
            $returndata['atlas']=$atlasmaplist[0];
        }
        echo  json_encode($returndata);
        exit;
    }
    //删除地图节点
    function deletemap_action(){
        $atlasmap=new atlasmap();
        $delete = $atlasmap->rec_delete(front::get('id'));
        if ($delete) {
            front::flash(lang_admin('successful_deletion'));
        }else{
            front::flash(lang_admin('delete').lang_admin('failure'));
        }
        front::redirect(url('config/atlas'));
    }
    //编辑节点
    function editmap_action(){
        $atlasmap=new atlasmap();
        $update =$atlasmap->rec_update(front::$post, front::get('id'));
        if ($update) {
            front::flash(lang_admin('save_successfully'));
        }else{
            front::flash(lang_admin('save_failed'));
        }
        front::redirect(url('config/atlas'));
    }

    //新版本 数据库配置
    function  system_action(){
        if (front::post('submit')) {
            //内容 切换到静态的时候  是否删除静态文件
            $oldshow_page_php=myconfig::getadmin("show_page_php");
            $oldlist_index_php=myconfig::getadmin("list_index_php");
            if ($oldshow_page_php==1 && array_key_exists('show_page_php',front::$post) && front::post('list_index_php')!=1){
                cache_admin::delete_make_show_action();
            }
            //栏目  切换到静态的时候  是否删除静态文件
            $oldlist_page_php=myconfig::getadmin("list_page_php");
            if ($oldlist_page_php==1 && array_key_exists('list_page_php',front::$post) && front::post('list_page_php')!=1){
                cache_admin::delete_make_list_action();
            }
            //分类  切换到静态的时候  是否删除静态文件
            $oldlist_type_php=myconfig::getadmin("list_type_php");
            if ($oldlist_type_php==1 && array_key_exists('list_type_php',front::$post) && front::post('list_type_php')!=1){
                cache_admin::delete_make_type_action();
            }
            //Tag  切换到静态的时候  是否删除静态文件
            $oldtag_html=myconfig::getadmin("tag_html");
            if ($oldtag_html==1 && array_key_exists('tag_html',front::$post) && front::post('tag_html')!=1){
                cache_admin::delete_make_tag_action();
            }
            //专题  切换到静态的时候  是否删除静态文件
            $oldlist_special_php=myconfig::getadmin("list_special_php");
            if ($oldtag_html==1 && array_key_exists('list_special_php',front::$post) && front::post('list_special_php')!=1){
                cache_admin::delete_make_special_action();
            }
            //首页设置动态 自动删除根目录index.html
            if(front::post('list_index_php')!=1  && array_key_exists('list_index_php',front::$post)){
                if(file_exists(ROOT.'/index.html')){
                    unlink(ROOT.'/index.html');
                }
                //删除全部语言
                $langdata=getlang();
                if($langdata != "") {
                    foreach ($langdata as $key => $val) {
                        if(file_exists(ROOT.'/index-'. $val['langurlname'].'.html')){
                            unlink(ROOT.'/index-'. $val['langurlname'].'.html');
                        }
                    }
                }
            }
            //手机内容 切换到静态的时候  是否删除静态文件
            $oldwap_show_page_php=myconfig::getadmin("wap_show_page_php");
            $oldwap_index_php=myconfig::getadmin("wap_index_php");
            if ($oldshow_page_php==1 && array_key_exists('wap_show_page_php',front::$post) && front::post('wap_show_page_php')!=1){
                wapcache_admin::delete_make_show_action();
                front::$admin = true;
            }
            //手机栏目  切换到静态的时候  是否删除静态文件
            $oldlwap_list_page_php=myconfig::getadmin("wap_list_page_php");
            if ($oldlwap_list_page_php==1 && array_key_exists('wap_list_page_php',front::$post) && front::post('wap_list_page_php')!=1){
                wapcache_admin::delete_make_list_action();
                front::$admin = true;
            }
            //手机分类  切换到静态的时候  是否删除静态文件
            $oldwap_type_php=myconfig::getadmin("wap_type_php");
            if ($oldwap_type_php==1 && array_key_exists('wap_type_php',front::$post) && front::post('wap_type_php')!=1){
                wapcache_admin::delete_make_type_action();
                front::$admin = true;
            }
            //手机Tag  切换到静态的时候  是否删除静态文件
            $oldwap_tag_html=myconfig::getadmin("wap_tag_html");
            if ($oldwap_tag_html==1 && array_key_exists('wap_tag_html',front::$post) && front::post('wap_tag_html')!=1){
                wapcache_admin::delete_make_tag_action();
                front::$admin = true;
            }
            //手机专题  切换到静态的时候  是否删除静态文件
            $oldwap_special_php=myconfig::getadmin("wap_special_php");
            if ($oldwap_special_php==1 && array_key_exists('wap_special_php',front::$post) && front::post('wap_special_php')!=1){
                wapcache_admin::delete_make_special_action();
                front::$admin = true;
            }
            if (front::post('list_page_php')!="" && front::post('show_page_php')!=""){
                front::remove(ROOT.'/cache/data/'.lang::getisadmin());
            }
            chkpw('system_'.front::$get['set']);
            front::$post['upload_filetype']=isset(front::$post['upload_filetype'])?front::$post['upload_filetype']:config::getadmin("upload_filetype");
            if(preg_match('/(php|asp|aspx|jsp|exe|dll|so|asa)/is',front::$post['upload_filetype'])){
                alerterror(lang_admin('setting_risk_type_file_upload_is_not_allowed'));
            }
            if (front::post('admin_dir') &&front::post('admin_dir') != config::getadmin('admin_dir')) {
                $new_dir=ROOT.'/'.front::post('admin_dir');
                if (ADMIN_DIRNAME != $new_dir) {
                    rename(ADMIN_DIRNAME,$new_dir);
                    if (is_dir($new_dir)) {
                        front::flash(lang_admin('lang_background').lang_admin('catalog').lang_admin('lang_change').'！&nbsp;&nbsp;');
                    }
                    else
                        unset(front::$post['admin_dir']);
                }
            }

            if (is_array(front::$post)){
                foreach (front::$post as $key=>$value) {
                    if(is_array($value)){
                        foreach ($value as $v) {
                            if(false !== strstr($v,'\\')){
                                alerterror(lang_admin('illegal_character'));
                            }
                        }
                    }else if(false !== strstr($value,'\\')){
                        alerterror(lang_admin('illegal_character'));
                    }
                }
            }
            front::$post['urlrewrite_on']=isset(front::$post['urlrewrite_on'])?front::$post['urlrewrite_on']:"";
            $this->setRewriteFile(front::$post['urlrewrite_on']);
            //修改ueditor_open 配置
            if (array_key_exists('ueditor_open',front::$post)){
                if (front::post('ueditor_open')==0){
                    $ueditor_data = file_get_contents(ROOT . '/ueditor/ueditor.config.js');
                    $ueditor_data = str_replace(",allowDivTransToP:false",",allowDivTransToP:true",$ueditor_data);
                    $ueditor_data = str_replace("//,allowDivTransToP:false ",",allowDivTransToP:true",$ueditor_data);
                    file_put_contents(ROOT . '/ueditor/ueditor.config.js', $ueditor_data);
                }else{
                    $ueditor_data = file_get_contents(ROOT . '/ueditor/ueditor.config.js');
                    $ueditor_data = str_replace(",allowDivTransToP:true",",allowDivTransToP:false",$ueditor_data);
                    $ueditor_data = str_replace("//,allowDivTransToP:true",",allowDivTransToP:false",$ueditor_data);
                    file_put_contents(ROOT . '/ueditor/ueditor.config.js', $ueditor_data);
                }
            }
            event::log(lang_admin('modify').lang_admin('website_configuration'),lang_admin('success'));
            myconfig::modify_admin(front::$post);
            front::flash(lang_admin('set_up').lang_admin('success'));

            //应用模板的时候
            if ((front::post("template_dir") && front::post("template_dir")!="")
                || (front::post("cache_make_open")==0 && front::post("cache_make_open")!="" )){
                //清空之前的全部php缓存和html缓存
                cache_make::all_make_delete();
                session::set("cache_make_php_array","");
            }
            $cache_make_array=array();
            session::set("cache_make_php_array","");
            if(front::post('list_index_php')!=1  && array_key_exists('list_index_php',front::$post) && $oldlist_index_php==1 ){
                //生成全部首页的缓存
                $cache_make_array[]="index";
            }
            if(front::post('list_page_php')!=1  && array_key_exists('list_page_php',front::$post) && $oldlist_page_php==1 ){
                //生成全部栏目的缓存
                $cache_make_array[]="list";
            }
            if(front::post('show_page_php')!=1  && array_key_exists('show_page_php',front::$post) && $oldshow_page_php==1 ){
                //生成全部内容的缓存
                $cache_make_array[]="show";
            }
            if(front::post('list_type_php')!=1  && array_key_exists('list_type_php',front::$post) && $oldlist_type_php==1 ){
                //生成全部分类的缓存
                $cache_make_array[]="type";
            }
            if(front::post('list_special_php')!=1  && array_key_exists('list_special_php',front::$post) && $oldlist_special_php==1 ){
                //生成全部专题的缓存
                $cache_make_array[]="special";
            }
            if(front::post('tag_html')!=1  && array_key_exists('tag_html',front::$post) && $oldtag_html==1 ){
                //生成全部tag的缓存
                $cache_make_array[]="tag";
            }
            if (count($cache_make_array)>0){
                session::set("cache_make_php_array",$cache_make_array);
            }
            $oldurl=uri();
            //当前地址
            //返回静态生成
            if(array_key_exists('list_index_php',front::$post) && (front::post('list_index_php')==1  && $oldlist_index_php!=front::post('list_index_php')) ){
                $new_url=url("config/system/set/dynamic/mache_type/index");
                front::adminconfirm(lang_admin("is_static_html"),$new_url,$oldurl);
            }
            else if(array_key_exists('show_page_php',front::$post) && ( $oldshow_page_php!=front::post('show_page_php') && front::post('show_page_php')==1)){
                $new_url=url("config/system/set/dynamic/mache_type/show");
                front::adminconfirm(lang_admin("is_static_html"),$new_url,$oldurl);
            }
            else if(array_key_exists('list_page_php',front::$post) && $oldlist_page_php!=front::post('list_page_php') && (front::post('list_page_php')==1)){
                $new_url=url("config/system/set/dynamic/mache_type/list");
                front::adminconfirm(lang_admin("is_static_html"),$new_url,$oldurl);
            }
            else if(array_key_exists('list_type_php',front::$post) && $oldlist_type_php!=front::post('list_type_php')  && (front::post('list_type_php')==1)){
                $new_url=url("config/system/set/dynamic/mache_type/type");
                front::adminconfirm(lang_admin("is_static_html"),$new_url,$oldurl);
            }
            else if(array_key_exists('list_special_php',front::$post) && $oldlist_special_php!=front::post('list_special_php') && (front::post('list_special_php')==1)){
                $new_url=url("config/system/set/dynamic/mache_type/special");
                front::adminconfirm(lang_admin("is_static_html"),$new_url,$oldurl);
            }
            else if(array_key_exists('tag_html',front::$post)  && $oldtag_html!=front::post('tag_html') && (front::post('tag_html')==1)){
                $new_url=url("config/system/set/dynamic/mache_type/tag");
                front::adminconfirm(lang_admin("is_static_html"),$new_url,$oldurl);
            }
            //手机返回静态生成
            if(array_key_exists('wap_index_php',front::$post) && (front::post('wap_index_php')==1  && $oldwap_index_php!=front::post('wap_index_php')) ){
                $new_url=url("wapcache/make_index/wap_config_cache/1");
                front::adminconfirm(lang_admin("is_static_html"),$new_url,$oldurl);
            }
            else if(array_key_exists('wap_show_page_php',front::$post) && ( $oldwap_show_page_php!=front::post('wap_show_page_php') && front::post('wap_show_page_php')==1)){
                $new_url=url("wapcache/make_show/wap_config_cache/1");
                front::adminconfirm(lang_admin("is_static_html"),$new_url,$oldurl);
            }
            else if(array_key_exists('wap_list_page_php',front::$post) && $oldlwap_list_page_php!=front::post('wap_list_page_php') && (front::post('wap_list_page_php')==1)){
                $new_url=url("wapcache/make_list/wap_config_cache/1");
                front::adminconfirm(lang_admin("is_static_html"),$new_url,$oldurl);
            }
            else if(array_key_exists('wap_type_php',front::$post) && $oldwap_type_php!=front::post('wap_type_php')  && (front::post('wap_type_php')==1)){
                $new_url=url("wapcache/make_type/wap_config_cache/1");
                front::adminconfirm(lang_admin("is_static_html"),$new_url,$oldurl);
            }
            else if(array_key_exists('wap_special_php',front::$post) && $oldwap_special_php!=front::post('wap_special_php') && (front::post('wap_special_php')==1)){
                $new_url=url("wapcache/make_special/wap_config_cache/1");
                front::adminconfirm(lang_admin("is_static_html"),$new_url,$oldurl);
            }
            else if(array_key_exists('wap_tag_html',front::$post)  && $oldwap_tag_html!=front::post('wap_tag_html') && (front::post('wap_tag_html')==1)){
                $new_url=url("wapcache/make_tag/wap_config_cache/1");
                front::adminconfirm(lang_admin("is_static_html"),$new_url,$oldurl);
            }

        }
        $type=front::get('set');
        $config=myconfig::getInstance();
        if ($type == 'security') {
            if(session::get('ver') != 'corp'){
                front::alert(lang_admin('unauthorized_access'));
            }
        }
        if (!$type)
            $type='[^-]+';
        $where="type='".$type."' and (lang='all' or lang='".lang::getisadmin()."')";
        $myconfig_data=$config->getrows($where,0,"listorder asc,id ASC");
        $myconfig_selecttype_data=$config->get_form();
        $myconfig_selecttype_data=isset($myconfig_selecttype_data[$type])?$myconfig_selecttype_data[$type]:"";
        $myconfig_gettitle_data=$config->gettitle_form();  //标题
        foreach($myconfig_data as $key=>$val){
            if (isset($myconfig_selecttype_data[$val['name']]) && is_array($myconfig_selecttype_data[$val['name']])){
                $val=array_merge($myconfig_selecttype_data[$val['name']],$val);
                $myconfig_data[$key]=$val;
            }
            if ($type=="site" && $val['name']=="site_url"){
                $myconfig_data[$key]['key']=config::getadmin("site_url");
            }
        }


        $configtitle=array();
        foreach ($myconfig_gettitle_data as $key=>$val){
            if (!is_array($val) && $key==$type){
                $configtitle=array($key=>$val);
            }
            elseif (is_array($val) && isset($val[$type]) && $val[$type]!="" ){
                $configtitle=$myconfig_gettitle_data[$key];
            }
        }
        $this->view->set=$type;
        $this->view->data=$myconfig_data;
        $this->view->configtitle=$configtitle;

        if ($type=="template"){
            $template_service_data=service::getInstance()->getservicetemplate();
            //pc模板
            $template_pc_data=array();
            foreach (front::$view->default_tpl_list() as $tpl){
                if (!preg_match('/user/',$tpl) && !preg_match('/wap/',$tpl) && !preg_match('/shop/',$tpl)
                    && !preg_match('/admin/',$tpl) &&!preg_match('/\./',$tpl)){
                    $template_pc_data[]=$tpl;
                }
            }
            //重新读取模板名称和模版版本
            foreach ($template_pc_data as $key=>$val){
                $new_template_data=array();
                $new_template_data['code']=$val;
                $new_template_data['remark_name']=$val;
                $path=ROOT."/template/".$val."/ui.json";
                if (!file_exists($path)){
                    $new_template_data['version']="1.0";
                }else{
                    $ui_json=json_decode(file_get_contents($path), true);
                    if (is_array($ui_json) && isset($ui_json['version'])){
                        $new_template_data['version']=$ui_json['version'];
                        $new_template_data['code']=$ui_json['template_name'];
                    }else{
                        $new_template_data['version']="1.0";
                    }
                }
                //是否有新版本
                $new_template_data['is_version']="0";
                if (isset($template_service_data[$new_template_data['code']])){
                    $service_version=$template_service_data[$new_template_data['code']]['version'];
                    $template_version=$new_template_data['version'];
                    if (self::versionCompare($service_version,$template_version)){
                        $new_template_data['is_version']="1";
                    }
                }
                $template_pc_data[$key]=$new_template_data;
            }
            $this->view->template_pc_data=$template_pc_data;
        }
        elseif($type=="template_shop"){
            $template_service_data=service::getInstance()->getservicetemplate();
            //商城模板
            $template_shop_data=array();
            foreach (front::$view->default_tpl_list() as $tpl){
                if (preg_match('/shop/',$tpl) && !preg_match('/\./',$tpl)){
                    $template_shop_data[]=$tpl;
                }
            }
            //重新读取模板名称和模版版本
            foreach ($template_shop_data as $key=>$val){
                $new_template_data=array();
                $new_template_data['code']=$val;
                $new_template_data['remark_name']=$val;
                $path=ROOT."/template/".$val."/ui.json";
                if (!file_exists($path)){
                    $new_template_data['version']="1.0";
                }else{
                    $ui_json=json_decode(file_get_contents($path), true);
                    if (is_array($ui_json) && isset($ui_json['version'])){
                        $new_template_data['version']=$ui_json['version'];
                        $new_template_data['code']=$ui_json['template_name'];
                    }else{
                        $new_template_data['version']="1.0";
                    }
                }
                //是否有新版本
                $new_template_data['is_version']="0";
                if (isset($template_service_data[$new_template_data['code']])){
                    $service_version=$template_service_data[$new_template_data['code']]['version'];
                    $template_version=$new_template_data['version'];
                    if (self::versionCompare($service_version,$template_version)){
                        $new_template_data['is_version']="1";
                    }
                }
                $template_shop_data[$key]=$new_template_data;
            }

            $this->view->template_shop_data = $template_shop_data;
        }
        elseif($type=="template_mobile"){
            $template_service_data=service::getInstance()->getservicetemplate();
            //手机模板
            $template_mobile_data=array();
            foreach (front::$view->default_tpl_list() as $tpl){
                if (preg_match('/wap/',$tpl) && !preg_match('/\./',$tpl)){
                    $template_mobile_data[]=$tpl;
                }
            }
            //重新读取模板名称和模版版本
            foreach ($template_mobile_data as $key=>$val){
                $new_template_data=array();
                $new_template_data['code']=$val;
                $new_template_data['remark_name']=$val;
                $path=ROOT."/template/".$val."/ui.json";
                if (!file_exists($path)){
                    $new_template_data['version']="1.0";
                }else{
                    $ui_json=json_decode(file_get_contents($path), true);
                    if (is_array($ui_json) && isset($ui_json['version'])){
                        $new_template_data['version']=$ui_json['version'];
                        $new_template_data['code']=$ui_json['template_name'];
                    }else{
                        $new_template_data['version']="1.0";
                    }
                }
                //是否有新版本
                $new_template_data['is_version']="0";
                if (isset($template_service_data[$new_template_data['code']])){
                    $service_version=$template_service_data[$new_template_data['code']]['version'];
                    $template_version=$new_template_data['version'];
                    if (self::versionCompare($service_version,$template_version)){
                        $new_template_data['is_version']="1";
                    }
                }
                $template_mobile_data[$key]=$new_template_data;
            }
            $this->view->template_mobile_data = $template_mobile_data;
        }

        //是否存在可视化目录
        $this->view->isvisual=file_exists(ROOT."/data/template/".myconfig::get('template_dir')."/index/index.html");

    }

    /*
*    版本号比较  by sam 20170412
*    @param $version1 版本A 如:5.3.2
*    @param $version2 版本B 如:5.3.0
*    @return int -1版本A小于版本B , 0版本A等于版本B, 1版本A大于版本B
*
*    版本号格式注意：
*        1.要求只包含:点和大于等于0小于等于2147483646的整数 的组合
*        2.boole型 true置1，false置0
*        3.不设位默认补0计算，如：版本号5等于版号5.0.0
*        4.不包括数字 或 负数 的版本号 ,统一按0处理
*
*    @example:
*       if (versionCompare('5.2.2','5.3.0')<0) {
*            echo '版本1小于版本2';
*       }
*/
    function versionCompare($versionA,$versionB) {
        if ($versionA>2147483646 || $versionB>2147483646) {
            //throw new Exception('版本号,位数太大暂不支持!','101');
            return -1;
        }
        $dm = '.';
        $verListA = explode($dm, (string)$versionA);
        $verListB = explode($dm, (string)$versionB);

        $len = max(count($verListA),count($verListB));
        $i = -1;
        while ($i++<$len) {
            $verListA[$i] = intval(@$verListA[$i]);
            $verListB[$i] = intval(@$verListB[$i]);
            if ($verListA[$i]>$verListB[$i]) {
                return 1;
            } else if ($verListA[$i]<$verListB[$i]) {
                return 0;
            } else if ($i==($len-1)) {
                return 0;
            }
        }
    }

    //勾选协议
    function  setagreement_action(){
        myconfig::setall("agreement",1);
    }

    //可视化打开关闭拖拽功能
    function  setopen_visual_action(){
        if (front::post("open_visual_drag")!="")
            myconfig::setall("open_visual_drag",front::post("open_visual_drag"));
    }

    function end() {
        $this->render();
    }
}
# This program is an open source system, commercial use, please consciously to purchase commercial license.
# Copyright (C) CmsEasy Co., Ltd. (https://www.CmsEasy.cn). All rights reserved.
