<?php

if (!defined('ROOT')) exit('Can\'t Access !');

class special extends table
{

    public $name = 'b_special';
    public static $me;

    public static function getInstance()
    {
        if (!self::$me) {
            $class = new special();
            self::$me = $class;
        }
        return self::$me;
    }

    function getcols($act)
    {
        switch ($act) {
            case 'manage':
                return 'spid,title,banner,listorder';
            default:
                return '*';
        }
    }

    function get_form()
    {
        return array(
            'banner' => array(
                'filetype' => 'thumb',
            ),
            'ishtml' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(0 => lang_admin('no_generate'), 1 => lang_admin('generate'))),
                'default' => 0,
            ),
            'langid'=>array(
                'selecttype'=>'select',
                'select'=>form::arraytoselect(lang::option(0,'tolast')),
                'default'=>lang::getlangid(lang::getisadmin()),
            ),
            'template' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->special_tpl_list()),
                //'tips'=>" 默认：{?category::gettemplate(get('id'),'showtemplate')}",
            ),
            'isscreening' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(1 => lang_admin('join_screening'), 0 => lang_admin('unfilter'))),
                'default' => '0',
            ),

        );
    }

    static function url($spid, $ishtml = false, $page = 1)
    {
        $ishtml = special::getishtml($spid);
        if (front::$get['t'] == 'wap') {
            if ($ishtml) {
                return config::get('site_url') . 'special_wap/' . $spid . '_'.config::get('lang_type').'/list-' . $page . '.html';
            } else {
                return url::create('special/show/t/wap/spid/' . $spid . ($page > 1 ? '/page/' . $page : ''), false);
            }
        }
        if (!$ishtml && !front::$rewrite) {
            return url::create('special/show/spid/' . $spid . ($page > 1 ? '/page/' . $page : ''), false);
        } else if (front::$rewrite) {
            return config::get('site_url') . 'speciallist-' . $spid . '-' . $page . '.html';
        } else {
            $html_prefix = config::get('html_prefix')?trim(config::get('html_prefix'),'/'):'';
            return config::get('site_url') .$html_prefix .'/special/' . $spid . '_'.config::get('lang_type').'/list-' . $page . '.html';
        }
    }

    function pagination()
    {
        return template('system/special_pagination.html');
    }

    public static function option($prop = "请选择...")
    {
        if(session::get("specialoption_".lang::getisadmin())){
            return session::get("specialoption_".lang::getisadmin());
        }
            //$sp = new special();
            $sp = special::getInstance();
            //增加语言包过滤
            $where = '  langid =  "'.lang::getlangid(lang::getisadmin()).'"';
            $sps = $sp->getrows($where, 500);
            $options = array(0 => $prop);
            foreach ($sps as $sp) {
                $options[$sp['spid']] = $sp['title'];
            }
            return $options;
    }

    function gettitle($spid)
    {
        if (empty($spid)) return;
        $sp = new special();
        $sp = $sp->getrow('spid=' . $spid);
        return $sp['title'];
    }

    static function getishtml($spid)
    {
        if (empty($spid)) return;
        $sp = special::getInstance();
        $sp = $sp->getrow('spid=' . $spid);
        return $sp['ishtml'];
    }

    function listdata($limit = 10)
    {
        $special = new special();
        $specials = $special->getrows('', $limit);
        foreach ($specials as $order => $sp) {
            $specials[$order]['url'] = special::url($sp['spid'], $sp['ishtml']);
        }
        return $specials;
    }
}