<?php

if (!defined('ROOT')) exit('Can\'t Access !');

class lang extends table
{
    public $name = 'lang';
    static $me;

    public static function getInstance() {
        if (!self::$me) {
            $class=new lang();
            self::$me=$class;
        }
        return self::$me;
    }

    function getcols($act)
    {
        return '*';
    }

    function get_form()
    {
        return array(
            'static' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(0 => lang_admin('forbidden'), 1 => lang_admin('enabling'))),
                'default' => 1,
            ),
            'langcopy'=>array(
                'selecttype'=>'select',
                'select'=>form::arraytoselect(lang::optionall('tolast')),
                'default'=>intval($this->getdefaultlang()),
            ),
            'isdefault'=>array(
                'selecttype'=>'select',
                'select'=>form::arraytoselect(array(0=>lang_admin('no'),1=>lang_admin('yes'))),
                'default' => 0,
            ),
        );
    }

    //获取默认的语言包ID
    function  getdefaultlang(){
        $lang = self::getInstance();
        $_lang = $lang->getrows('static=1 and isdefault=1 ', 1, 'id asc');
        if (is_array($_lang)){
            return $_lang[0]['id'];
        }
        return 0;
    }
    //获取默认的语言包url
    static function  getdefaultlangurl(){
        $lang = self::getInstance();
        $_lang = $lang->getrows('static=1 and isdefault=1 ', 1, 'id asc');
        if (is_array($_lang)){
            return $_lang[0]['langurlname'];
        }
        return 'cn';
    }

    //获取可用语言包
    public static function  getlang(){
        $lang = self::getInstance();
        $_lang = $lang->getrows('static=1 ', 0, 'id asc');
        if (is_array($_lang)){
            return $_lang;
        }
        return '';
    }

    //通过文件夹名称  获取语言包id
    public static function  getlangid($langurlname){
        $lang = self::getInstance();
        $_lang = $lang->getrows('static=1 and langurlname="'.$langurlname.'"', 0, 'id asc');
        if (is_array($_lang)){
            return $_lang[0]['id'];
        }
        return 0;
    }

    //通过语言包id   获取文件夹名称
    public static function  getlangurlname($langid){
        $lang = self::getInstance();
        $_lang = $lang->getrows('static=1 and id="'.$langid.'"', 0, 'id asc');
        if (is_array($_lang)){
            return $_lang[0]['langurlname'];
        }
        return '';
    }


    static function optionall($typeid = 0, $tag = 'all', &$option = array(0 => '请选择...'), &$level = 0)
    {
        $catid=0;
        $category = self::getInstance();

        $_category = $category->getrows('', 0, 'id asc');
        $category = array();
        foreach ($_category as $one) {
            $category[$one['id']] = $one['langname'];
        }
        return $category;


    }

    static function option($typeid = 0, $tag = 'all', &$option = array(), &$level = 0)
    {
        $catid=0;
        $category = self::getInstance();

        $_category = $category->getrows('static=1 ', 0, 'id asc');
        $category = array();
        foreach ($_category as $one) {
            $category[$one['id']] = $one['langname'];
        }
        return $category;


    }

//获取前台语言包的路径
    static function getistemplate( )
    {
        if(file_exists(ROOT."/data/locked")) {
            if (session::get('lang_getistemplate') && session::get('username')) {   //前提条件是登陆了
                $_lang = session::get('lang_getistemplate');
                return $_lang['templatelang'];
            } elseif (session::get('nolong_templatelang')) {   //没登陆的时候  看看session有没有前台语言
                return session::get('nolong_templatelang');
            }
            $configdatabase = config::getdatabase('database');
            $pddatabase=dbmysqli::getInstance($configdatabase['hostname'],$configdatabase['user'], $configdatabase['password'],$configdatabase['database']);
            if (!mysqli_connect_errno($pddatabase))
            {
                $table = $configdatabase['prefix'] . "lang";
                if (mysqli_num_rows($pddatabase->query( "SHOW TABLES LIKE '" . $table . "'")) == 1) {
                    $user = new user();
                    if (session::get('username')) {   //登陆的时候 取用户的语言
                        $_lang = $user->getrow("username='" . session::get('username') . "'", 1);
                        session::set('lang_getistemplate', $_lang);
                        if (is_array($_lang)) {
                            return $_lang['templatelang'];
                        }
                    } else {
                        return self::getdefaultlangurl();
                    }
                }
            }
        }
        return 'cn';
    }

    //修改前台语言包
    static function settistemplate($langurl)
    {
        if(session::get('username')){
            $user = new user();
            //然后修改当前数据
            $user-> rec_update(array('templatelang' => $langurl), "username='".session::get('username')."'");
            //清空
            session::set('lang_getistemplate','');
        }else{
            session::set('nolong_templatelang',$langurl);
        }
    }

    //获取后台语言包的路径
    static function getisadmin( )
    {
        if(file_exists(ROOT."/data/locked"))
        {
            if (session::get('lang_getisadmin') && session::get('username')) {   //前提条件是登陆了
                $_lang = session::get('lang_getisadmin');
                return $_lang['adminlang'];
            }else if(session::get('nolong_adminlang')){   //没登陆的时候  看看session有没有前台语言
                return session::get('nolong_adminlang');
            }
            $configdatabase = config::getdatabase('database');
            $pddatabase=dbmysqli::getInstance($configdatabase['hostname'],$configdatabase['user'], $configdatabase['password'],$configdatabase['database']);
            if (!mysqli_connect_errno($pddatabase))
            {
                $table =$configdatabase['prefix'] . "lang";
                if (mysqli_num_rows($pddatabase->query( "SHOW TABLES LIKE '" . $table . "'")) == 1) {
                    $user = new user();
                    if (session::get('username')){
                        $_lang = $user->getrow("username='".session::get('username')."'", 1);
                        session::set('lang_getisadmin', $_lang);
                        if (is_array($_lang)) {
                            return $_lang['adminlang'];
                        }
                    }else{
                        return  self::getdefaultlangurl();
                    }
                }
            }
        }
        return 'cn';
    }
    //获取默认语言包
    static function getisdefault( )
    {
        $lang = self::getInstance();
        $_lang = $lang->getrow('isdefault=1', 'id asc', '*');
        if (is_array($_lang)) {
            return $_lang['langurlname'];
        }
        return 'cn';
    }

    //修改后台语言包
    static function setisadmin($langurl)
    {
        if(session::get('username')) {
            $user = new user();
            //然后修改当前数据
            $user->rec_update(array('adminlang' => $langurl), "username='" . session::get('username') . "'");
            //清空
            session::set('lang_getisadmin', '');
        }else{
            session::set('nolong_adminlang',$langurl);
        }
    }

    //获取所有可用语言包的路径名称
    static function getlangurl()
    {
        $lang = self::getInstance();
        $_lang = $lang->getrows('static=1', 0, 'id asc');
        if (is_array($_lang)){
            return $_lang;
        }else{
            return '';
        }

    }



}