<?php

if (!defined('ROOT')) exit('Can\'t Access !');

class category extends table
{
    public $name = 'b_category';
    static $me;

    function getcols($act)
    {
        return '*';
    }

    function get_form()
    {
        return array(
            'parentid' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(category::optiontemplate(0, 'isnotlast')),
                'default' => get('parentid'),
            ),
            'langid'=>array(
                'selecttype'=>'select',
                'select'=>form::arraytoselect(lang::option(0,'tolast')),
                'default'=>lang::getlangid(lang::getisadmin()),
            ),
            'catidshopping'=>array(
                'selecttype'=>'select',
                'select'=>form::arraytoselect(category::optionshopping('0','tolast')),
                'default' => get('parentid'),
            ),
            'ishtml' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(0 => lang_admin('inherit'), 1 => lang_admin('generate'),
                    2 => lang_admin('no_generate'))),
                'default' => 0,
            ),
            'isshow' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(1 => lang_admin('normal_display'), 0 =>lang_admin('forbidden'))),
                'default' => '1',
            ),
            'ispages' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(1 => lang_admin('paging'), 0 => lang_admin('single_page'))),
                'default' => 1,
            ),
            'isshopping' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(0 => lang_admin('no'), 1 => lang_admin('yes'))),
                'default' => 0,
            ),
            'includecatarchives' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(1 => lang_admin('include'), 0 => lang_admin('no_include'))),
                'default' => 1,
            ),
            'isecoding' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(0 => lang_admin('inherit'), 1 => lang_admin('lang_open'), 2 => lang_admin('lang_no_open'))),
                'default' => 0,
            ),
            'scategory' => array(//'tips'=>"&nbsp;被调用的格式 categories(\$catid,'标记')",
            ),
            'image' => array(
                'filetype' => 'thumb',
            ),
            'template' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->archive_tpl_list('archive/list')),
                'default' => "{?category::gettemplate(get('id'),'listtemplate',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'))}",
            ),
            'templateshopping' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->archive_shoppingtpl_list('archive/list')),
                'default' => "{?category::gettemplate(get('id'),'listtemplate',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'))}",
            ),
            'listtemplate' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->archive_tpl_list('archive/list')),
                'default' => "{?category::gettemplate(get('id'),'listtemplate',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'),'listtemplate')}",
            ),
            'listshoppingtemplate' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->archive_shoppingtpl_list('archive/list')),
                'default' => "{?category::gettemplate(get('id'),'listtemplate',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'),'listtemplate')}",
            ),
            'showtemplate' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->archive_tpl_list('archive/show')),
                'default' => "{?category::gettemplate(get('id'),'showtemplate',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'),'showtemplate')}",
            ),
            'showshoppingtemplate' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->archive_shoppingtpl_list('archive/show')),
                'default' => "{?category::gettemplate(get('id'),'showtemplate',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'),'showtemplate')}",
            ),
            'templatewap' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->mobile_tpl_list('archive/list')),
                'default' => "{?category::gettemplate(get('id'),'listtemplatewap',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'))}",
            ),
            'listtemplatewap' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->mobile_tpl_list('archive/list')),
                'default' => "{?category::gettemplate(get('id'),'listtemplatewap',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'),'listtemplate')}",
            ),
            'showtemplatewap' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->mobile_tpl_list('archive/show')),
                'default' => "{?category::gettemplate(get('id'),'showtemplatewap',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'),'showtemplate')}",
            ),
            'showform' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(get_my_tables_list()),
                'default' => "0",
            ),
            'isnav' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(array(1 => lang_admin('show'), 0 => lang_admin('no_show'))),
                'default' => 1,
            ),
            'ismobilenav' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(array(1 => lang_admin('show'), 0 => lang_admin('no_show'))),
                'default' => 1,
            ),
            'htmlrule' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(getHtmlRule('category')),
                'default' => '',
            ),
            'listhtmlrule' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(getHtmlRule('category')),
                'default' => '',
            ),
            'showhtmlrule' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(getHtmlRule('archive')),
                'default' => '',
            ),
            'categorycontent' => array(
                'type' => 'mediumtext',
            ),
            'nofollow' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(1 => lang_admin('enabling'), 0 => lang_admin('forbidden'))),
                'default' => '0',
            ),
            'subListorder' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(array(0 =>lang_admin('release_time'),1 => lang_admin('edit_time'),2 => lang_admin('hottest'),3 => lang_admin('comment_most'))),
                'default' => '0',
            ),
            'contentrank' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(array(  'updatedate ASC'=> lang_admin('modification_time_positive_order'),
                                                        'updatedate DESC'=> lang_admin('modification_time_reverse_order'),
                                                        'adddate ASC' => lang_admin('add_time_positive_order'),
                                                        'adddate DESC'=> lang_admin('add_time_reverse_order_'),
                                                        'view ASC'=> lang_admin('browsing_volume_positive_order'),
                                                        'view DESC'=> lang_admin('browse_volume_reverse_order'),
                                                        'listorder ASC'=> lang_admin('by_serial_number_positive_order'),
                                                        'listorder DESC'=>lang_admin('number_in_reverse_order'),
                                                        'aid ASC'=> lang_admin('by_id_positive_order'),
                                                        'aid DESC'=> lang_admin('by_id_in_reverse_order'))),
                'default' => 'updatedate DESC',
            ),
            'isblank' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(array(0 => lang_admin('no'),1 => lang_admin('yes'))),
                'default' => '0',
            ),
            'isscreening' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(1 => lang_admin('join_screening'), 0 => lang_admin('unfilter'))),
                'default' => '0',
            ),

        );
    }

    function get_form_field()
    {
        return array(
            'parentid' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(category::optiontemplate(0, 'isnotlast')),
                'default' => get('parentid'),
            ),
            'langid'=>array(
                'selecttype'=>'select',
                'select'=>form::arraytoselect(lang::option(0,'tolast')),
                'default'=>lang::getlangid(lang::getisadmin()),
            ),
            'catidshopping'=>array(
                'selecttype'=>'select',
                'select'=>form::arraytoselect(category::optionshopping('0','tolast')),
                'default' => get('parentid'),
            ),
            'ishtml' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(0 => lang_admin('inherit'), 1 => lang_admin('generate'),
                    2 => lang_admin('no_generate'))),
                'default' => 0,
            ),
            'isshow' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(1 => lang_admin('normal_display'), 0 =>lang_admin('forbidden'))),
                'default' => '1',
            ),
            'ispages' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(1 => lang_admin('paging'), 0 => lang_admin('single_page'))),
                'default' => 1,
            ),
            'isshopping' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(0 => lang_admin('no'), 1 => lang_admin('yes'))),
                'default' => 0,
            ),
            'includecatarchives' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(1 => lang_admin('include'), 0 => lang_admin('no_include'))),
                'default' => 1,
            ),
            'isecoding' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(0 => lang_admin('inherit'), 1 => lang_admin('lang_open'), 2 => lang_admin('lang_no_open'))),
                'default' => 0,
            ),
            'scategory' => array(//'tips'=>"&nbsp;被调用的格式 categories(\$catid,'标记')",
            ),
            'image' => array(
                'filetype' => 'thumb',
            ),
            'template' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->archive_tpl_list('archive/list')),
                'default' => "{?category::gettemplate(get('id'),'listtemplate',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'))}",
            ),
            'templateshopping' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->archive_shoppingtpl_list('archive/list')),
                'default' => "{?category::gettemplate(get('id'),'listtemplate',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'))}",
            ),
            'listtemplate' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->archive_tpl_list('archive/list')),
                'default' => "{?category::gettemplate(get('id'),'listtemplate',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'),'listtemplate')}",
            ),
            'listshoppingtemplate' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->archive_shoppingtpl_list('archive/list')),
                'default' => "{?category::gettemplate(get('id'),'listtemplate',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'),'listtemplate')}",
            ),
            'showtemplate' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->archive_tpl_list('archive/show')),
                'default' => "{?category::gettemplate(get('id'),'showtemplate',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'),'showtemplate')}",
            ),
            'showshoppingtemplate' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->archive_shoppingtpl_list('archive/show')),
                'default' => "{?category::gettemplate(get('id'),'showtemplate',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'),'showtemplate')}",
            ),
            'templatewap' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->mobile_tpl_list('archive/list')),
                'default' => "{?category::gettemplate(get('id'),'listtemplatewap',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'))}",
            ),
            'listtemplatewap' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->mobile_tpl_list('archive/list')),
                'default' => "{?category::gettemplate(get('id'),'listtemplatewap',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'),'listtemplate')}",
            ),
            'showtemplatewap' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(front::$view->mobile_tpl_list('archive/show')),
                'default' => "{?category::gettemplate(get('id'),'showtemplatewap',false)}",
                //'tips'=>" 默认：{?category::gettemplate(get('id'),'showtemplate')}",
            ),
            'showform' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(get_my_tables_list()),
                'default' => "0",
            ),
            'isnav' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(array(1 => lang_admin('show'), 0 => lang_admin('no_show'))),
                'default' => 1,
            ),
            'ismobilenav' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(array(1 => lang_admin('show'), 0 => lang_admin('no_show'))),
                'default' => 1,
            ),
            'htmlrule' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(getHtmlRule('category')),
                'default' => '',
            ),
            'listhtmlrule' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(getHtmlRule('category')),
                'default' => '',
            ),
            'showhtmlrule' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(getHtmlRule('archive')),
                'default' => '',
            ),
            'categorycontent' => array(
                'type' => 'mediumtext',
            ),
            'nofollow' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(1 => lang_admin('enabling'), 0 => lang_admin('forbidden'))),
                'default' => '0',
            ),
            'subListorder' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(array(0 =>lang_admin('release_time'),1 => lang_admin('edit_time'),2 => lang_admin('hottest'),3 => lang_admin('comment_most'))),
                'default' => '0',
            ),
            'contentrank' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(array(  'updatedate ASC'=> lang_admin('modification_time_positive_order'),
                    'updatedate DESC'=> lang_admin('modification_time_reverse_order'),
                    'adddate ASC' => lang_admin('add_time_positive_order'),
                    'adddate DESC'=> lang_admin('add_time_reverse_order_'),
                    'view ASC'=> lang_admin('browsing_volume_positive_order'),
                    'view DESC'=> lang_admin('browse_volume_reverse_order'),
                    'listorder ASC'=> lang_admin('by_serial_number_positive_order'),
                    'listorder DESC'=>lang_admin('number_in_reverse_order'),
                    'aid ASC'=> lang_admin('by_id_positive_order'),
                    'aid DESC'=> lang_admin('by_id_in_reverse_order'))),
                'default' => 'updatedate DESC',
            ),
            'isblank' => array(
                'selecttype' => 'select',
                'select' => form::arraytoselect(array(0 => lang_admin('no'),1 => lang_admin('yes'))),
                'default' => '0',
            ),
            'isscreening' => array(
                'selecttype' => 'radio',
                'select' => form::arraytoselect(array(1 => lang_admin('join_screening'), 0 => lang_admin('unfilter'))),
                'default' => '0',
            ),

        );
    }

    public static function getInstance()
    {
        if (!self::$me) {
            $class = new category();
            $class->init();
            self::$me = $class;
        }
        return self::$me;
    }

    function init()
    {
        $_category = $this->getrows(null, 1000, 'listorder=0,listorder asc');
        $category = array();
        foreach ($_category as $one) {
            if (!front::$admin && !$one['isshow']) continue;
            $category[$one['catid']] = $one;
        }
        $this->category = $category;
        $parent = array();
        foreach ($category as $one) {
            $parent[$one['catid']] = $one['parentid'];
        }
        $this->parent = $parent;
        $this->tree = new tree($parent);
    }

    function son($id)
    {
        //增加语言包过滤
        $where = '  langid = "'.lang::getlangid(lang::getisadmin()).'"';
        $_category = $this->getrows($where, 1000, 'listorder=0,listorder asc');
        $category = array();
        foreach ($_category as $one) {
            if (!front::$admin && !$one['isshow']) continue;
            $category[$one['catid']] = $one;
        }
        $this->category = $category;
        $parent = array();
        foreach ($category as $one) {
            $parent[$one['catid']] = $one['parentid'];
        }
        $this->parent = $parent;
        $this->tree = new tree($parent);
        return $this->tree->get_son($id);
    }
    function shoppingson($id)
    {
        //增加语言包过滤
        $where = 'isshopping=1 and langid = "'.lang::getlangid(lang::getisadmin()).'"';
        $_category = $this->getrows($where, 1000, 'listorder=0,listorder asc');
        $category = array();
        foreach ($_category as $one) {
            if (!front::$admin && !$one['isshow']) continue;
            $category[$one['catid']] = $one;
        }
        $this->category = $category;
        $parent = array();
        foreach ($category as $one) {
            $parent[$one['catid']] = $one['parentid'];
        }
        $this->parent = $parent;
        $this->tree = new tree($parent);
        return $this->tree->get_son($id);
    }
    function connentson($id)
    {
        //增加语言包过滤
        $where = 'isshopping=0 and langid = "'.lang::getlangid(lang::getisadmin()).'"';
        $_category = $this->getrows($where, 1000, 'listorder=0,listorder asc');
        $category = array();
        foreach ($_category as $one) {
            if (!front::$admin && !$one['isshow']) continue;
            $category[$one['catid']] = $one;
        }
        $this->category = $category;
        $parent = array();
        foreach ($category as $one) {
            $parent[$one['catid']] = $one['parentid'];
        }
        $this->parent = $parent;
        $this->tree = new tree($parent);
        return $this->tree->get_son($id);
    }

    //前台栏目获取
    function templateson($id)
    {
        //增加语言包过滤
        $where = '  langid = "'.lang::getlangid(lang::getistemplate()).'"';
        $_category = $this->getrows($where, 1000, 'listorder=0,listorder asc');
        $category = array();
        foreach ($_category as $one) {
            if (!front::$admin && !$one['isshow']) continue;
            $category[$one['catid']] = $one;
        }
        $this->category = $category;
        $parent = array();
        foreach ($category as $one) {
            $parent[$one['catid']] = $one['parentid'];
        }
        $this->parent = $parent;
        $this->tree = new tree($parent);
        return $this->tree->get_son($id);
    }

    function sons($id)
    {
        if (!isset($this->tree)) $this->init();
        $sons = array();
        $this->tree->get_sons($id, $sons);
        return $sons;
    }

    function langsons($id)
    {
        $this->langinit();
        $sons = array();
        $this->tree->get_sons($id, $sons);
        return $sons;
    }

    function langinit()
    {
        $_category = $this->getrows( '  langid = "'.lang::getlangid(lang::getisadmin()).'"', 1000, 'listorder=0,listorder asc');
        $category = array();
        foreach ($_category as $one) {
            if (!front::$admin && !$one['isshow']) continue;
            $category[$one['catid']] = $one;
        }
        $this->category = $category;
        $parent = array();
        foreach ($category as $one) {
            $parent[$one['catid']] = $one['parentid'];
        }
        $this->parent = $parent;
        $this->tree = new tree($parent);
    }

    function hasson($id)
    {
        return self::getInstance()->tree->has_son($id);
    }

    function getparents($id, $up = true)
    {
        if (!isset($this->tree)) $this->init();
        return $this->tree->get_parents($id);
    }

    static function getparentsid($id, $up = true)
    {
        $category = self::getInstance();
        if (!isset($category->tree)) $category->init();
        return $category->tree->get_parents($id);
    }

    function getparent($id)
    {
        if (isset($this->tree->parent[$id])) return $this->tree->parent[$id];
        else return false;
    }

    function getposition($id)
    {
        if (!isset($this->tree)) $this->init();
        $position = $this->tree->get_parents($id);
        return $position;
    }

    function getposition1($id)
    {
        if (!isset($this->tree)) $this->init();
        $position = $this->tree->get_parents1($id);
        return $position;
    }

    static function gettopparent($id)
    {
        $position = self::getInstance()->getposition($id);
        return $position[count($position) - 1];
    }

    function htmlpath($id)
    {
        if (!isset($this->tree)) $this->init();
        $positions = $this->tree->get_parents($id);
        $path = array();
        foreach ($positions as $_id) {
            if ($_id && isset($this->category[$_id])) $path[] = $this->category[$_id]['htmldir'].'_'.lang::getisadmin();
        }
        return implode('/', $path);
    }

    static function option($catid = 0, $tag = 'all', &$option = array(0 => '请选择...'), &$level = 0)
    {
        if(session::get("categoryoption_".lang::getisadmin())){
            return session::get("categoryoption_".lang::getisadmin());
        }
        $category = self::getInstance();
        if (is_array($category->son($catid)))
            foreach ($category->son($catid) as $_catid) {
                if (!self::check($_catid, $tag)) continue;
                $strpre = $level > 0 ? str_pad('', $level * 12, '&nbsp;') . '└&nbsp;' : '';
                $option[$_catid] = $strpre . $category->category[$_catid]['catname'];
                if (is_array($category->son($_catid))) {
                    $level++;
                    self::option($_catid, $tag, $option, $level);
                    $level--;
                }
          }
        return $option;
    }

    static function optiontemplate($catid = 0, $tag = 'all', &$option = array(0 => '请选择...'), &$level = 0)
    {
        $category = self::getInstance();
        if (is_array($category->sontemplate($catid))) foreach ($category->sontemplate($catid) as $_catid) {
            if (!self::check($_catid, $tag)) continue;
            $strpre = $level > 0 ? str_pad('', $level * 12, '&nbsp;') . '└&nbsp;' : '';
            $option[$_catid] = $strpre . $category->category[$_catid]['catname'];
            if (is_array($category->sontemplate($_catid))) {
                $level++;
                self::optiontemplate($_catid, $tag, $option, $level);
                $level--;
            }
        }
        return $option;
    }

    function sontemplate($id)
    { //(SELECT id FROM cmseasy_lang WHERE  )=langid and
        $_category = $this->getrows(' isshopping=0 or parentid <> "0" ', 1000, 'listorder=0,listorder asc');
        $category = array();
        $_lang =new lang();
        $_langdata= $_lang->getrows('langurlname="'.lang::getisadmin().'"', 1, 'id asc');
        foreach ($_category as $key=>$one) {
            if($_langdata[0]['id'] != $_category[$key]['langid']){
                unset($_category[$key]);
                continue;
            }
            if (!front::$admin && !$one['isshow']) continue;
            $category[$one['catid']] = $one;
        }
        $this->category = $category;
        $parent = array();
        foreach ($category as $one) {
            $parent[$one['catid']] = $one['parentid'];
        }
        $this->parent = $parent;
        $this->tree = new tree($parent);
        return $this->tree->get_son($id);
        /*  if (!isset($this->tree)) $this->init();
          return $this->tree->get_son($id);*/
    }

    static function optionshopping($catid = 0, $tag = 'all', &$option = array(0 => '请选择...'), &$level = 0)
    {
        $category = self::getInstance();
        if (is_array($category->sonshopping($catid))) foreach ($category->sonshopping($catid) as $_catid) {
            if (!self::check($_catid, $tag)) continue;
            $strpre = $level > 0 ? str_pad('', $level * 12, '&nbsp;') . '└&nbsp;' : '';
            $option[$_catid] = $strpre . $category->category[$_catid]['catname'];
            if (is_array($category->sonshopping($_catid))) {
                $level++;
                self::optionshopping($_catid, $tag, $option, $level);
                $level--;
            }
        }
        return $option;
    }

    function sonshopping($id)
    {
        $_category = $this->getrows('isshopping=1 or parentid <> "0"', 1000, 'listorder=0,listorder asc');
        $category = array();
        $_lang =new lang();
        $_langdata= $_lang->getrows('langurlname="'.lang::getisadmin().'"', 1, 'id asc');
        foreach ($_category as $key=>$one) {
            if($_langdata[0]['id'] != $_category[$key]['langid']){
                unset($_category[$key]);
                continue;
            }
            if (!front::$admin && !$one['isshow']) continue;
            $category[$one['catid']] = $one;
        }
        $this->category = $category;
        $parent = array();
        foreach ($category as $one) {
            $parent[$one['catid']] = $one['parentid'];
        }
        $this->parent = $parent;
        $this->tree = new tree($parent);
        return $this->tree->get_son($id);
    }


   /* static function optionshopping($tag = 'all', &$option = array(0 => '请选择...'), &$level = 0)
    {
        $catid=0;
        $category = self::getInstance();
        if (is_array($category->sonshopping($catid)))
            foreach ($category->sonshopping($catid) as $_catid) {
            if (!self::check($_catid, $tag)) continue;
            $strpre = $level > 0 ? str_pad('', $level * 12, '&nbsp;') . '└&nbsp;' : '';
            $option[$_catid] = $strpre . $category->category[$_catid]['catname'];
            if (is_array($category->sonshopping($_catid))) {
                $level++;
                self::optiontemplate($_catid, $tag, $option, $level);
                $level--;
            }
        }
        return $option;
    }

    function sonshopping($id)
    {
        $_category = $this->getrows('isshopping=1 or parentid <> "0"', 1000, 'listorder=0,listorder asc');
        $category = array();
        $_lang =new lang();
        $_langdata= $_lang->getrows('langurlname="'.lang::getisadmin().'"', 1, 'id asc');
        foreach ($_category as $key=>$one) {
            if($_langdata[0]['id'] != $_category[$key]['langid']){
                unset($_category[$key]);
                continue;
            }
            if (!front::$admin && !$one['isshow']) continue;
            $category[$one['catid']] = $one;
        }
        $this->category = $category;
        $parent = array();
        foreach ($category as $one) {
            $parent[$one['catid']] = $one['parentid'];
        }
        $this->parent = $parent;
        $this->tree = new tree($parent);
        return $this->tree->get_son($id);
    }*/

    static function name($catid)
    {
        $category = self::getInstance();
        $categorydata=$category->getrow('catid='.$catid);
        if (is_array($categorydata)){
            return $categorydata['catname'];
        }
       // if (isset($category->category[$catid]['catname'])) return $category->category[$catid]['catname'];
         return '';
    }

    static function categorypages($catid)
    {
        $category = self::getInstance();
        if (isset($category->category[$catid]['attr3'])) return $category->category[$catid]['attr3'];
        else return '';
    }

    static function image($catid)
    {
        $category = self::getInstance();
        if (isset($category->category[$catid]['image'])) return config::get('base_url') . '/' . $category->category[$catid]['image'];
        else return '';
    }

    static function num($catid)
    {
        $category = self::getInstance();
        $catids = $category->sons($catid);
        //var_dump($catids);
        if($catids) {
            $where = "catid in($catid," . implode(',', $catids) . ")";
        }else{
            $where = "catid = '$catid'";
        }
        $arc = archive::getInstance();
        return $arc->rec_count($where);
    }

    static function url($catid, $page = null, $relative = false,$lang='')
    {
        //var_dump(front::$get);
        $category = self::getInstance();
        if (@$category->category[$catid]['linkto']) return $category->category[$catid]['linkto'];
        if (front::$ismobile == true) {
            if (config::get('wap_html_prefix')) {
                $wap_html_prefix = '/' . trim(config::get('wap_html_prefix'), '/');
            }
            if (front::$rewrite) {
                if (!$page) {
                    return config::get('site_url') . 'list-wap-' . $catid . '.htm';
                } else {
                    return config::get('site_url') . 'list-wap-' . $catid . '-' . $page . '.htm';
                }
            }
            if (!category::getiswaphtml($catid)) {
                if (!$page) {
                    return url::create('archive/list/t/wap/catid/' . $catid);
                } else {
                    return url::create('archive/list/t/wap/catid/' . $catid . '/page/' . $page);
                }
            }
            else {
                $rule = category::gethtmlrule($catid, 'listhtmlrule');
                $rule = str_replace('{$caturl}', $category->htmlpath($catid), $rule);
                $rule = str_replace('{$dir}', $category->category[$catid]['htmldir'], $rule);
                $rule = str_replace('{$catid}', $catid, $rule);
                if ($category->category[$catid]['ispages'] && !$page) $page = 1;
                if ($page) $rule = str_replace('{$page}', $page, $rule);
                else $rule = preg_replace('/\(.*?\)/', '', $rule);
                $rule = preg_replace('%/\.html$%', '/index.html', $rule);
                $rule = preg_replace('/[\(\)]/', '', $rule);
                $rule = preg_replace('%[\\/]index\.htm(l)?%', '', $rule);
                $rule = rtrim($rule, '/');
                $rule = trim($rule, '\\');
                if ($relative) return $wap_html_prefix . '/' . $rule;
                $rule = str_replace('/1.html', '', $rule);
                $path = config::get('base_url') . $wap_html_prefix . '/' . $rule;
                //echo $path;
                return $path;
            }
        }
        if (config::get('html_prefix')) $html_prefix = '/' . trim(config::get('html_prefix'), '/');
        if (!category::getishtml($catid) || front::$rewrite) {
            if (!$page){
                return url::create('archive/list/catid/' . $catid,false);
            }else {
                return url::create('archive/list/catid/' . $catid . '/page/' . $page,false);
            }
        }
        else {
            $rule = category::gethtmlrule($catid, 'listhtmlrule');
            $rule = str_replace('{$caturl}', $category->htmlpath($catid), $rule);
            //语言包生成
            if($catid != ''){
                $newhtmldir=$category->category[$catid]['htmldir'];
                $newhtmldir=$newhtmldir.'_'.lang::getistemplate();
            }else{
                $newhtmldir='';
            }
            $rule = str_replace('{$dir}', $newhtmldir, $rule);
            $rule = str_replace('{$catid}', $catid, $rule);
            if ($category->category[$catid]['ispages'] && !$page) {
                $page = 1;
            }
            if ($page) {
                $rule = str_replace('{$page}', $page, $rule);
            } else {
                $rule = preg_replace('/\(.*?\)/', '', $rule);
            }
            if($lang != '' && $category->category[$catid]['htmldir']!=''){
                //begin  生成文件夹名称加上语言包名称
                $newpath='';
                $source = explode("/",trim($rule));
               if (is_array($source)) {
                   for($index=0;$index<count($source);$index++){
                       if($source[$index]==$category->category[$catid]['htmldir'] && $source[$index+1] != ''){
                           $source[$index]=$source[$index].'_'.$lang;
                       }
                       if($index==0){
                           $newpath=$source[$index];
                       }else{
                           $newpath=$newpath.'/'.$source[$index];
                       }
                   }
                   $rule=$newpath;
               }
            }
            //echo '<script>alert("'.$rule.'");</script>';
            $rule = preg_replace('%/\.html$%', '/index.html', $rule);
            $rule = preg_replace('/[\(\)]/', '', $rule);
            $rule = preg_replace('%[\\/]index\.htm(l)?%', '', $rule);
            $rule = rtrim($rule, '/');
            $rule = trim($rule, '\\');

            if ($relative) return $html_prefix . '/' . $rule;
            $rule = str_replace('/1.html', '', $rule);
            return config::get('base_url') . $html_prefix . '/' . $rule;
        }
    }

    static function getpositionlink($catid)
    {
        $category = self::getInstance();
        if (!isset($category->category[$catid])) return;
        $position = $category->getposition($catid);
        $links = array();
        if (!$catid) return $links;
        foreach ($position as $order => $id) {
            $links[$order]['id'] = $id;
            $links[$order]['name'] = @$category->category[$id]['catname'];
            $links[$order]['url'] = self::url($id);
        }
        return $links;
    }

    static function getpositionlink1($catid)
    {
        $category = self::getInstance();
        if (!isset($category->category[$catid])) return;
        $position = $category->getposition($catid);
        $links = array();
        if (!$catid) return $links;
        foreach ($position as $order => $id) {
            $links['id'] = $id;
            $links['name'] = @$category->category[$id]['catname'];
            $links['url'] = self::url($id);
            break;
        }
        return $links;
    }

    static function getpositionlink2($catid)
    {
        $category = self::getInstance();
        if (!isset($category->category[$catid])) return;
        $position = $category->getposition1($catid);
        $links = array();
        if (!$catid) return $links;
        foreach ($position as $order => $id) {
            $links[$order]['id'] = $id;
            $links[$order]['name'] = @$category->category[$id]['catname'];
            $links[$order]['url'] = self::url($id);
        }
        return $links;
    }

    static function gettemplate($catid, $tag = 'listtemplate', $up = true)
    {
        if (!$catid && front::get('parentid')) $catid = front::get('parentid');
        $category = self::getInstance();
        if (@$category->category[$catid]['template'] && $tag == 'listtemplate') return $category->category[$catid]['template'];
        if (@$category->category[$catid][$tag]) return $category->category[$catid][$tag];
        if (!$up) return;
        $parents = $category->getparents($catid, true);
        ksort($parents);
        foreach ($parents as $pid) {
            if ($pid == $catid) continue;
            if (@$category->category[$pid][$tag]) return $category->category[$pid][$tag];
        }
        $default = array(
            'listtemplate' => 'archive/list.html',
            'showtemplate' => 'archive/show.html',
        );
        if (isset($default[$tag])) return $default[$tag];
    }

    static function gettemplatewap($catid, $tag = 'listtemplatewap', $up = true)
    {
        //echo 11;
        if (!$catid && front::get('parentid')) $catid = front::get('parentid');
        $category = self::getInstance();
        if (@$category->category[$catid]['templatewap'] && $tag == 'listtemplatewap') return $category->category[$catid]['templatewap'];
        if (@$category->category[$catid][$tag]) return $category->category[$catid][$tag];
        if (!$up) return;
        //echo 22;
        $parents = $category->getparents($catid, true);
        ksort($parents);
        foreach ($parents as $pid) {
            if ($pid == $catid) continue;
            if (@$category->category[$pid][$tag]) return $category->category[$pid][$tag];
        }
        $default = array(
            'listtemplatewap' => 'archive/list.html',
            'showtemplatewap' => 'archive/show.html',
        );
        //echo 11;
        if (isset($default[$tag])) return $default[$tag];
    }

    static function gethtmlrule($catid, $tag = 'listhtmlrule')
    {
        if (!$catid && front::get('parentid')) $catid = front::get('parentid');
        $category = self::getInstance();
        if (@$category->category[$catid]['htmlrule'] && $tag == 'listhtmlrule') return $category->category[$catid]['htmlrule'];
        if (@$category->category[$catid]['showhtmlrule'] && $tag == 'showhtmlrule') return $category->category[$catid]['showhtmlrule'];
        $parents = $category->getparents($catid, true);
        ksort($parents);
        foreach ($parents as $pid) {
            if ($pid == $catid) continue;
            if (@$category->category[$pid][$tag]) return $category->category[$pid][$tag];
        }
        $default = array(
            'listhtmlrule' => '{$dir}/{$page}.html',
            'showhtmlrule' => '{$dir}/show-{$aid}-{$page}.html',
        );
        if (isset($default[$tag])) return $default[$tag];
    }

    static function getishtml($catid)
    {
        if (config::get('list_page_php') == '1') return true;
        if (config::get('list_page_php') == '2') return false;
        $category = self::getInstance();
        if (@$category->category[$catid]['ishtml'] == '1') return true;
        $parents = $category->getparents($catid, true);
        ksort($parents);
        foreach ($parents as $pid) {
            if ($pid == $catid) continue;
            if (@$category->category[$pid]['ishtml'] == '1') return true;
            if (@$category->category[$pid]['ishtml'] == '2') return false;
        }
        return false;
    }

    static function getiswaphtml($catid)
    {
        if (config::get('wap_list_page_php') == '1') return true;
        if (config::get('wap_list_page_php') == '2') return false;
        $category = self::getInstance();
        if (@$category->category[$catid]['iswaphtml'] == '1') return true;
        $parents = $category->getparents($catid, true);
        ksort($parents);
        foreach ($parents as $pid) {
            if ($pid == $catid) continue;
            if (@$category->category[$pid]['iswaphtml'] == '1') return true;
            if (@$category->category[$pid]['iswaphtml'] == '2') return false;
        }
        return false;
    }

    static function getarcishtml($arc)
    {
        if (config::get('show_page_php') == '1') return true;
        if (config::get('show_page_php') == '2') return false;
        if ($arc['ishtml']) return true;
        if (self::getishtml($arc['catid'])) return true;
        return false;
    }

    static function getarciswaphtml($arc)
    {
        if (config::get('wap_show_page_php') == '1') return true;
        if (config::get('wap_show_page_php') == '2') return false;
        if ($arc['iswaphtml']) return true;
        if (self::getiswaphtml($arc['catid'])) return true;
        return false;
    }

    static function getattr($categoryid, $attr)
    {
        $category = self::getInstance();
        if (@$category->category[$categoryid][$attr]) return $category->category[$categoryid][$attr];
        $parents = $category->getparents($categoryid, true);
        ksort($parents);
        foreach ($parents as $pid) {
            if ($pid == $categoryid) continue;
            if (@$category->category[$pid][$attr]) return $category->category[$categoryid][$attr];
        }
        return false;
    }

    static function getwidthofthumb($catid)
    {
        $width = self::getattr($catid, 'thumb_width');
        if (!$width) $width = config::get('thumb_width');
        return $width;
    }

    static function getheightofthumb($catid)
    {
        $height = self::getattr($catid, 'thumb_height');
        if (!$height) $height = config::get('thumb_height');
        return $height;
    }

    static function getcategorydata($_catid = 0, &$data = array(), &$level = 0)
    {
        $category = self::getInstance();
        $categorys = $category->son($_catid);
        foreach ($categorys as $catid) {
            $info_ = $category->category[$catid];
            $strpre = $level > 0 ? str_pad('', $level * 12, '&nbsp;') . '└&nbsp;' : '';
           // $info_['catname'] = $strpre . $info_['catname'] . '<font color="Blue">' . (self::check($catid, 'islast') ? ('(' . countarchiveformcategory($catid) . ')') : '') . '</font>';
            $info_['catname'] = $strpre . $info_['catname'] ;
            $info_['level'] = $level;
            $data[] = $info_;
            if (is_array($category->son($catid))) {
                $level++;
                self::getcategorydata($catid, $data, $level);
                $level--;
            }
        }
        return $data;
    }
    static function getshoppingcategorydata($_catid = 0, &$data = array(), &$level = 0)
    {
        $category = self::getInstance();
        $categorys = $category->shoppingson($_catid);
        foreach ($categorys as $catid) {
                $info_ = $category->category[$catid];
                $strpre = $level > 0 ? str_pad('', $level * 12, '&nbsp;') . '└&nbsp;' : '';
                $info_['catname'] = $strpre . $info_['catname'];
            if(!category::hasson($catid)){
                $info_['catname'].= '<font color="Blue">' . (self::check($catid, 'islast') ? ('(' . countarchiveformcategory($catid) . ')') : '') . '</font>';
            }

                $info_['level'] = $level;
                $data[] = $info_;
                if (is_array($category->son($catid))) {
                    $level++;
                    self::getshoppingcategorydata($catid, $data, $level);
                    $level--;
                }
        }
        return $data;
    }
    static function getconnentcategorydata($_catid = 0, &$data = array(), &$level = 0)
    {
        $category = self::getInstance();
        $categorys = $category->connentson($_catid);
        foreach ($categorys as $catid) {
            $info_ = $category->category[$catid];
            $strpre = $level > 0 ? str_pad('', $level * 12, '&nbsp;') . '└&nbsp;' : '';
            $info_['catname'] = $strpre . $info_['catname'] ;
            if(!category::hasson($catid)){
                $info_['catname'].=  '<font color="Blue">' . (self::check($catid, 'islast') ? ('(' . countarchiveformcategory($catid) . ')') : '') . '</font>';
            }

            $info_['level'] = $level;
            $data[] = $info_;
            if (is_array($category->son($catid))) {
                $level++;
                self::getconnentcategorydata($catid, $data, $level);
                $level--;
            }
        }
        return $data;
    }

    static function listcategorydata($_catid = 0, &$data = array(), &$level = 0)
    {
        $category = self::getInstance();
        $categorys = $category->son($_catid);
        foreach ($categorys as $catid) {
            $info_ = $category->category[$catid];
            $strpre = $level > 0 ? str_pad('', $level * 12, '&nbsp;') . '└&nbsp;' : '';
            $info_['catname'] = $strpre . $info_['catname'];
            $info_['url'] = category::url($info_['catid']);
            $info_['level'] = $level;
            $info_['parentid'] = $category->getparent($info_['catid']);
            $data[] = $info_;
            if (is_array($category->son($catid))) {
                $level++;
                self::listcategorydata($catid, $data, $level);
                $level--;
            }
        }
        return $data;
    }

    static function check($catid, $tag = 'isnotlast')
    {
        return true;
        $_category = self::getInstance();
        $category = $_category->category[$catid];
        if ($tag == 'islast' && !$category['islast']) return false;
        if ($tag == 'isnotlast' && $category['islast']) return false;
        if ($tag == 'tolast') {
            if ($_category->category[$catid]['islast']) return true;
            $sons = $_category->sons($catid);
            foreach ($sons as $tid) {
                if ($_category->category[$tid]['islast']) return true;
            }
            return false;
        }
        return true;
    }

    static function htmlcache($catid)
    {
    }

    static function sitemap($path=null, $filename = null)
    {
        if(!isset($path)){
            $path = ROOT.'/sitemap/';
        }
        $filename = 'index_'.lang::getisadmin().'.html';
        category::listcategorydata(0, $arr, $level);
        front::$view->archive = $arr;
        $html = front::$view->fetch('system/sitemap.html');
        file_put_contents($path.$filename, $html);
    }

    static function listdata($parentid = 0, $limit = 10, $order = 'catid asc', $where = null, $includeson = true)
    {
        $category = new category();
        $where = 'parentid=' . ($parentid ? $parentid : '0') . ($where ? ' and ' . $where : '');
        $categories = $category->getrows($where, $limit, $order);
        foreach ($categories as $order => $category) {
            $categories[$order]['url'] = category::url($category['catid']);
        }
        return $categories;
    }

    static function getcategoryname($catid){
        $category = new category();
        $where = 'catid=' . $catid;
        $categories = $category->getrows($where, 1,  'catid asc','catname');
        return $categories;
    }
}