<?php

if (!defined('ROOT'))
    exit('Can\'t Access !');

class archive_act extends act
{

    public $auto_end = true;
    public $showform = '1';
    public $manage = null;

    function init()
    {
        $this->archive = new archive();
        $this->category = category::getInstance();
        $this->view->category = $this->category->category;
        if (front::get('page'))
            $page = front::get('page');
        else
            $page = 1;
        $this->view->page = $page;
        front::check_type($page);
        $_catpage = category::categorypages(front::get('catid'));
        if ($_catpage) {
            $this->pagesize = $_catpage;
        } else {
            $this->pagesize = config::getadmin('list_pagesize');
        }
        front::check_type($this->pagesize);
        $announcement = new announcement();
        $this->view->announcements = $announcement->getrows(null, 10);
    }

    //前端切换语言包
    function setlang_action(){
        if(front::get('langurl') != '' ){
           // config::modify(array('lang_type' => front::get('langurl')));
            //获取域名
            $langdomain=lang::getInstance()->getrow("langurlname='".front::get('langurl')."'",'1 desc','domain');
            //是当前域名才修改配置
            //if($langdomain['domain'] =="") {
                //修改当前语言包
                lang::settistemplate(front::get('langurl'));
           // }
            //清空购物车
            cookie::set('ce_orders_cookie', '');
        }
        if(front::get('user')){
            if($langdomain['domain'] !=""){
                echo '<script>window.location.href="'.$langdomain['domain'].'/index.php?case=user&act=index";</script>';
            }else {
                echo '<script>window.location.href="' . url('user/index') . '";</script>';
            }
        }else{
            if($langdomain['domain'] !=""){
                echo '<script>window.location.href="'.$langdomain['domain'].'";</script>';
            }else{
                echo '<script> window.location.href="'.config::getadmin('site_url').'";</script>';
            }
        }
        exit;
    }


    function getScreening_action(){
        /*$category = new category();
        $isparentid=true;
        //获取父类的id
        while ($isparentid) {
            $where = 'catid=' . $_GET['catid'];
            $categories = $category->getrows($where, 1,  'catid asc','parentid');
            if($categories[0]['parentid']=='0'){
                $isparentid=false;
            }else{
                $_GET['catid']=$categories[0]['parentid'];
            }
        }

        $sql=" select catid as id,catname as name from  cmseasy_b_category  ";
        if(isset($_GET['catid'])&&$_GET['catid']!=""){
            $sql=" select catid as id,catname as name from  cmseasy_b_category WHERE parentid=".$_GET['catid']." OR catid=".$_GET['catid'];
        }*/
        $sql=" select catid as id,catname as name from  cmseasy_b_category where isscreening=1 ";
        $sql.=' and langid = "'.lang::getlangid(lang::getistemplate()).'"';
        $cateGoryData = $this->category->rec_query($sql);
        $sql=" select typeid as id,typename as name from  cmseasy_type  where isscreening=1 ";
        $sql.=' and langid = "'.lang::getlangid(lang::getistemplate()).'"';
        $typeData =  $this->category->rec_query($sql);
        $sql=" select spid as id,title as name from  cmseasy_b_special  where isscreening=1  ";
        $sql.=' and langid = "'.lang::getlangid(lang::getistemplate()).'"';
        $specialData =  $this->category->rec_query($sql);
        $data = array(
            "cateGoryData" => $cateGoryData,
            "typeData" => $typeData,
            "specialData" => $specialData,
        );

        echo json_encode($data);
        exit;
    }


    //获取多点地图
    function getAtlas_action(){
        $atlasmap=new atlasmap();
        $atlasmaplist = $atlasmap->getrows('', 0,'id desc ');
        echo json_encode($atlasmaplist);
        exit;
    }

    function set_verify()
    {
        return array(
            'is_int' => 'id,aid',
            'is_word' => '',
            'is_email' => '',
            'is_text' => ''
        );
    }

    function index_action()
    {

    }

    function pages_action()
    {
        $p = front::get('p');
        if ($p != 'share' && $p != 'map') {
            die();
        }
        if (front::get('t') == 'wap') {
            $this->out("wap/$p.html");
            return;
        };
    }

    function rss_action()
    {
        $sitename = config::getadmin('sitename');
        $site_url = config::getadmin('site_url');
        $catid = intval(front::get('catid'));
        if (!$catid) {
            $title = $sitename;
            $url = $site_url;
            $articles = $this->archive->getrows('', 30);
        } else {
            $type = $this->category->category[$catid];
            $cids = $this->category->sons($catid);
            $where = "catid='$catid'";
            if ($cids) {
                $cids[] = $catid;
                $where = "catid in(" . implode(',', $cids) . ")";
            }
            $title = $type['catname'] . '-' . $sitename;
            //$url = $site_url . url('archive/list/catid/' . $catid);
            $url = 'http://' . $_SERVER['HTTP_HOST'] . category::url($catid);
            $articles = $this->archive->getrows($where, 30);
        }
        $code = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n";
        $code .= "<rss version=\"2.0\">\r\n";
        $code .= "<channel>\r\n";
        $code .= "<title>{$title}</title>\r\n";
        $code .= "<link><![CDATA[{$url}]]></link>\r\n";
        $code .= "<description>11{$title}</description>\r\n";
        $i = 1;
        if (is_array($articles) && !empty($articles)) {
            foreach ($articles as $arr) {
                $aurl = 'http://' . $_SERVER['HTTP_HOST'] . archive::url($arr);
                $text = strip_tags(cut($arr['content'], 588));
                $code .= "<item id=\"{$i}\">\r\n";
                $code .= "<title><![CDATA[{$arr['title']}]]></title>\r\n";
                $code .= "<link><![CDATA[" . $aurl . "]]></link>\r\n";
                $code .= "<description><![CDATA[{$text}]]></description>\r\n";
                $code .= "<pubDate>{$arr['adddate']}</pubDate>\r\n";
                $code .= "</item>\r\n";
                $i++;
            }
        }
        $code .= "</channel>\r\n";
        $code .= "</rss>";
        header('Content-type: application/xml');
        echo $code;
        exit;
    }

    function list_action()
    {
        front::check_type(front::get('catid'));
        $this->view->categorys = category::getpositionlink2(front::get('catid'));
        $topid = category::gettopparent(front::get('catid'));
        if (!isset($this->category->category[front::get('catid')]) ||
            !isset($this->category->category[$topid])
        ) {
            throw new HttpErrorException(404, lang('page_does_not_exist'), 404);
        }
        $limit = (($this->view->page - 1) * $this->pagesize) . ',' . $this->pagesize;
        $categories = array();
        if (@$this->category->category[front::get('catid')]['ispages'])
            $categories = $this->category->sons(front::get('catid'));
        $categories[] = front::get('catid');

        $this->view->pages = @$this->category->category[front::get('catid')]['ispages'];
        if (!rank::catget(front::get('catid'), $this->view->usergroupid))
            $this->out('message/error.html');

        $categoryslist=new  category();
        $categorysdata= $categoryslist->getrows(front::get('catid'), 1);
        if($categorysdata[0]['contentrank']!='' ){
            $order =$categorysdata[0]['contentrank'];
        }else{
            $order = "listorder=0,`listorder` asc,`adddate` DESC";
        }
        $tops = $this->archive->getrows("checked=1 AND state=1 AND toppost!=0 ".' and langid = "'.lang::getlangid(lang::getistemplate()).'"', 0, $order);
        if (@$this->category->category[front::get('catid')]['includecatarchives']) {
            $articlesWhere ='catid in (' . implode(',', $categories) . ') and checked=1';
        } else {
            $articlesWhere='catid=' . front::get('catid') . ' and checked=1';
        }
        //增加语言包过滤
        $articlesWhere=$articlesWhere. ' and langid = "'.lang::getlangid(lang::getistemplate()).'"';
      /*  if(isset($_GET['cateGory'])&&$_GET['cateGory']!=""){
            $articlesWhere=$articlesWhere.' and catid='.$_GET['cateGory'];
            $this->view->cateGorycolor = $_GET['cateGory'];
        }else{
            $this->view->cateGorycolor = '0';
        }
        if(isset($_GET['type'])&&$_GET['type']!=""){
            $articlesWhere=$articlesWhere.' and typeid='.$_GET['type'];
            $this->view->typecolor = $_GET['type'];
        }else{
            $this->view->typecolor = '0';
        }
        if(isset($_GET['special'])&&$_GET['special']!=""){
            $articlesWhere=$articlesWhere.' and spid='.$_GET['special'];
            $this->view->specialcolor = $_GET['special'];
        }else{
            $this->view->specialcolor = '0';
        }*/
        $articles = $this->archive->getrows($articlesWhere, $limit, $order);
        if (!is_array($articles)) {
            $this->out('message/error.html');
        }
        $isint =usergroup::getisint(user::getuserid());      //获取是否取整
        if (is_array($tops) && !empty($tops)) {
            foreach ($tops as $order => $arc) {
                if ($arc['toppost'] == 3) {
                    $tops[$order]['title'] = "[" . lang('the_total_top') . "]" . $arc['title'];
                }
                if ($arc['toppost'] == 2) {
                    $subcatids = $this->category->sons($arc['catid']);
                    if ($arc['catid'] != front::get('catid') && !in_array(front::get('catid'), $subcatids) && $arc['langid']!= lang::getlangid(lang::getistemplate())) {
                        unset($tops[$order]);
                    } else {
                        $tops[$order]['title'] = "[" . lang('the_column_top') . "]" . $arc['title'];
                    }
                }
            }
            $articles = array_merge($tops, $articles);
        }
        foreach ($articles as $order => $arc) {
            $articles[$order]['url'] = archive::url($arc);
            $articles[$order]['catname'] = category::name($arc['catid']);
            $articles[$order]['caturl'] = category::url($arc['catid']);
            $articles[$order]['adddate'] = sdate($arc['adddate']);
            $articles[$order]['title'] = $arc['title'];
            $articles[$order]['stitle'] = strip_tags($arc['title']);
            $articles[$order]['strgrade'] = archive::getgrade($arc['grade']);
            $articles[$order]['buyurl'] = url('archive/orders/aid/' . $arc['aid']);
            if (strtolower(substr($arc['thumb'], 0, 7)) == 'http://') {
                $articles[$order]['sthumb'] = $arc['thumb'];
            } else {
                $articles[$order]['sthumb'] = config::getadmin('base_url') . '/' . $arc['thumb'];
            }
            $pics = unserialize($arc['pics']);
            if(is_array($pics) && !empty($pics)){
                $articles[$order]['pics'] = $pics;
            }
            if($isint){                                                   //取整
                $articles[$order]['attr2']=round($articles[$order]['attr2']);
            }
            $prices = getPrices($articles[$order]['attr2']);
            $articles[$order]['attr2'] = $prices['price'];
            $articles[$order]['oldprice'] = $prices['oldprice'];

            if ($arc['strong']) {
                $articles[$order]['title'] = '<strong>' . $arc['title'] . '</strong>';
            }
            if ($arc['color']) {
                $articles[$order]['title'] = '<font style="color:' . $arc['color'] . ';">' . $articles[$order]['title'] . '</font>';
            }

            $taghtml = '';
            $tag_table = tag::getInstance();
            foreach ($tag_table->urls($arc['tag']) as $tag => $url) {
                $taghtml .= "<a href='$url' target='_blank' class='archive-tag'>$tag</a>";
            }
            $articles[$order]['tag'] = $taghtml;

        }
        cb_datas($articles);
        $this->view->archives = $articles;

        if (@$this->category->category[front::get('catid')]['includecatarchives'])
            $this->view->record_count = $this->archive->rec_count('catid in(' . implode(',', $categories) . ') AND state=1 AND checked=1');
        else
            $this->view->record_count = $this->archive->rec_count('catid=' . front::get('catid') . ' AND state=1 AND checked=1');
        front::$record_count = $this->view->record_count;
        $this->view->catid = front::get('catid');
        $this->view->ifson = category::hasson($articles[0]['catid'] ? $articles[0]['catid'] : $this->view->catid);
        $this->view->topid = category::gettopparent(front::get('catid'));
        $this->view->parentid = @$this->category->getparent($this->view->catid);
        if (front::$ismobile) {
            $cateobj = category::getInstance();
            $this->view->subids = $cateobj->son($this->view->catid);
            $template = $this->category->category[front::get('catid')]['templatewap'];
            if ($template && file_exists(TEMPLATE . '/' . $this->view->_style . '/' . $template)) {
                $this->out($template);
            } else {
                $tpl = category::gettemplatewap($this->view->catid);
                $this->out($tpl);
            }
            return;
        }

        $template = @$this->category->category[front::get('catid')]['template'];

        //动静态结合判断  商品
        if($categorysdata[0]['isshopping']){
            $template=config::getadmin('template_shopping_dir').'/'.$template;
        }
        if ($template && ( file_exists(TEMPLATE . '/' . $this->view->_style . '/' . $template)
                || (file_exists(TEMPLATE . '/'.$template) )))
        {
            $this->out($template);
        } else {
            $tpl = category::gettemplate($this->view->catid);
            if (category::getishtml($this->view->catid)) {
                $path = ROOT . category::url($this->view->catid, @front::$get['page'] > 1 ? front::$get['page'] : null);
                if (!preg_match('/\.[a-zA-Z]+$/', $path))
                    $path = rtrim(rtrim($path, '/'), '\\') . '/index.html';
                $this->cache_path = $path;
            }
            if($categorysdata[0]['isshopping']){
                $tpl=config::getadmin('template_shopping_dir').'/'.$tpl;
            }
            $this->out($tpl);
        }
    }

    //筛选结果
    function listscreening_action(){
        if(front::get('cateGory')!="" && front::get('cateGory')){
            $this->view->cateGorycolor = $_GET['cateGory'];
        }else{
            $this->view->cateGorycolor = '0';
        }
        if($_GET['type']!=""  && front::get('type')){
            $this->view->typecolor = $_GET['type'];
        }else{
            $this->view->typecolor = '0';
        }
        if($_GET['special']!=""  && front::get('special')){
            $this->view->specialcolor = $_GET['special'];
        }else{
            $this->view->specialcolor = '0';
        }
        if($_GET['minprice']!=""  && front::get('minprice')){
            $this->view->minprice = $_GET['minprice'];
        }else{
            $this->view->minprice = '';
        }
        if(isset($_GET['maxprice'])&&$_GET['maxprice']!=""){
            $this->view->maxprice = $_GET['maxprice'];
        }else{
            $this->view->maxprice = '';
        }

        $articlesWhere=' checked=1  and attr2<>"" ';
        if(front::get('cateGory') != '' && front::get('cateGory')){
            if(substr($_GET['cateGory'],strlen($_GET['cateGory'])-1,strlen($_GET['cateGory']))==','){
                $_GET['cateGory'] = substr($_GET['cateGory'],0,strlen($_GET['cateGory'])-1);
            }
            $articlesWhere=$articlesWhere.' and catid in ('.$_GET['cateGory'].')';
        }
        if(front::get('type') != ''  && front::get('type')){
            if(substr($_GET['type'],strlen($_GET['type'])-1,strlen($_GET['type']))==','){
                $_GET['type'] = substr($_GET['type'],0,strlen($_GET['type'])-1);
            }
            $articlesWhere=$articlesWhere.' and typeid in ('.$_GET['type'].')';
        }
        if(front::get('special') != '' && front::get('special')){
            if(substr($_GET['special'],strlen($_GET['special'])-1,strlen($_GET['special']))==','){
                $_GET['special'] = substr($_GET['special'],0,strlen($_GET['special'])-1);
            }
            $articlesWhere=$articlesWhere.' and spid in ('.$_GET['special'].')';
        }
        if(front::get('minprice') != ''){
            $articlesWhere=$articlesWhere.' and attr2  > '.front::get('minprice');
        }
        if(front::get('maxprice') != ''){
            $articlesWhere=$articlesWhere.' and attr2  < '.front::get('maxprice');
        }
        //筛选结果加上语言包判断
        $articlesWhere.=" and langid='".lang::getlangid(lang::getistemplate())."'";

        //排序
        $order = "listorder=0,`listorder` asc,`adddate` DESC";
        //分页
        //echo '<script>alert("'.$articlesWhere.'");</script>';
        $limit = (($this->view->page - 1) * $this->pagesize) . ',' . $this->pagesize;
        $archive=new archive();
        $articles = $archive->getrows($articlesWhere, $limit, $order);
        $this->view->record_count =$archive->record_count;
        if (!is_array($articles)) {
            $this->out('message/error.html');
        }else{
            $discount =usergroup::getusergrop(user::getuserid());
            //折扣
            $this->view->discount =$discount ;
            $isint =usergroup::getisint(user::getuserid());
            //取整
            $this->view->isint =$isint ;
            $this->view->archives = $articles;
            $this->view->articlesWhere = "cateGory=".$_GET['cateGory']."&type=".$_GET['type']."&special=".$_GET['special']."&minprice=".$_GET['minprice']."&maxprice=".$_GET['maxprice'];
        }
        $this->out('screening/list_screening.html');
    }

    //获取价格
    function getarchiveprice_action(){
        if (front::get('aid')!=''){
            //先获取折扣
            $usergroupid=user::getuserid();
            $discount =usergroup::getusergrop($usergroupid);
            //获取商品单价
            $archive=new archive();
            //保存商品价格
            $price = array();
            $articles = $archive->getrows(front::get('aid'), 1);
            //取整
            if(is_array($articles)){
                $isint =usergroup::getisint($usergroupid);
                if($isint){
                    $price['oldprice']=round($articles[0]['attr2']);
                    $price['newprice']=round($articles[0]['attr2']*$discount/10);
                }else{
                    $price['oldprice']=$articles[0]['attr2'];
                    $price['newprice']=$articles[0]['attr2']*$discount/10;
                }
                if (session::get('username')!=''){
                    $price['oldpricestatic']='1';
                }else{
                    $price['oldpricestatic']='0';
                }
                $articles['shoppingprice'] =$price;
               echo json_encode($articles);
               exit;
            }
        }
        echo '-1';
        exit;
    }

    function getlist_action(){
        $limit = (($this->view->page - 1) * $this->pagesize) . ',' . $this->pagesize;
        $order = "listorder=0,`listorder` asc,`adddate` DESC";
        $categories = array();
        if (@$this->category->category[front::get('catid')]['ispages'])
            $categories = $this->category->sons(front::get('catid'));
        $categories[] = front::get('catid');
        if (@$this->category->category[front::get('catid')]['includecatarchives']) {
            $articlesWhere ='catid in (' . implode(',', $categories) . ') and checked=1';
        } else {
            $articlesWhere='catid=' . front::get('catid') . ' and checked=1';
        }
        if(isset($_GET['cateGory'])&&$_GET['cateGory']!=""){
            $articlesWhere='catid='.$_GET['cateGory']. ' and checked=1';;
            $this->view->cateGorycolor = $_GET['cateGory'];
        }else{
            $this->view->cateGorycolor = '0';
        }
        if(isset($_GET['type'])&&$_GET['type']!=""){
            $articlesWhere=$articlesWhere.' and typeid='.$_GET['type'];
            $this->view->typecolor = $_GET['type'];
        }else{
            $this->view->typecolor = '0';
        }
        if(isset($_GET['special'])&&$_GET['special']!=""){
            $articlesWhere=$articlesWhere.' and spid='.$_GET['special'];
            $this->view->specialcolor = $_GET['special'];
        }else{
            $this->view->specialcolor = '0';
        }
        $articles = $this->archive->getrows($articlesWhere, $limit, $order);
        foreach ($articles as $k=>$v){
            $articles[$k]['url'] = archive::url($v);
        }
        $newarticles = $this->archive->rec_count($articlesWhere);
        $articles[0]['pageindex']=ceil((int)$newarticles/(int)($this->pagesize));
        $articles[0]['pagesize']=count($articles);
        $articles[0]['page']=$this->view->page;
        echo json_encode($articles);
        exit;
    }
    //防伪码搜索
    function ecodingsearch_action()
    {//print_r($_SESSION);exit();
        if (front::get('keyword') && !front::post('keyword'))
            front::$post['keyword'] = front::get('keyword');
        front::check_type(front::post('keyword'), 'safe');
        if (front::post('keyword')) {
            $this->view->keyword = trim(front::post('keyword'));
            if (preg_match('/union/i', $this->view->keyword) || preg_match('/"/i', $this->view->keyword) || preg_match('/\'/i', $this->view->keyword)) {
                exit(lang('illegal_parameter'));
            }
        } else {
            alerterror(lang('key_words_can_not_be_empty'));
        }

        if (preg_match('/union/i', $this->view->keyword) || preg_match('/"/i', $this->view->keyword) || preg_match('/\'/i', $this->view->keyword)) {
            exit(lang('illegal_parameter'));

        }
        $condition = "ecoding = '" . $this->view->keyword . "'";
        if (config::getadmin('isecoding')) {
            $condition .= " AND (isecoding=0 OR isecoding=1)";
        } else {
            $condition .= " AND (isecoding=1)";
        }
        $order = "`listorder`,aid DESC";
        $limit = (($this->view->page - 1) * $this->pagesize) . ',' . $this->pagesize;
        $articles = $this->archive->getrows($condition, $limit, $order);
        foreach ($articles as $order => $arc) {
            $articles[$order]['url'] = archive::url($arc);
            $articles[$order]['catname'] = category::name($arc['catid']);
            $articles[$order]['caturl'] = category::url($arc['catid']);
            $articles[$order]['adddate'] = sdate($arc['adddate']);
            $articles[$order]['stitle'] = strip_tags($arc['title']);
        }
        $this->view->articles = $articles;
        $this->view->archives = $articles;
        $this->view->record_count = $this->archive->record_count;

        if (front::get('t') == 'wap') {
            $this->out('wap/archive_search.html');
            return;
        }
    }

    function search_action()
    {//print_r($_SESSION);exit();

        if (front::get('ule')) {
            front::$get['keyword'] = str_replace('-', '%', front::$get['keyword']);
            front::$get['keyword'] = urldecode(front::$get['keyword']);
        }
        if (front::get('keyword') && !front::post('keyword'))
            front::$post['keyword'] = front::get('keyword');
        front::check_type(front::post('keyword'), 'safe');
        if (front::post('keyword')) {
            $this->view->keyword = trim(front::post('keyword'));
            if (preg_match('/union/i', $this->view->keyword) || preg_match('/"/i', $this->view->keyword) || preg_match('/\'/i', $this->view->keyword)) {
                exit(lang('illegal_parameter'));
            }
            session::set('keyword', trim(front::post('keyword')));
            /* if(isset(front::$get['keyword']))
              front::redirect(preg_replace('/keyword=[^&]+/','keyword='.urlencode($this->view->keyword),front::$uri));
              else  front::redirect(front::$uri.'&keyword='.urlencode($this->view->keyword)); */
        } else {
            $this->view->keyword = session::get('keyword');
            if (preg_match('/union/i', $this->view->keyword) || preg_match('/"/i', $this->view->keyword) || preg_match('/\'/i', $this->view->keyword)) {
                exit(lang('illegal_parameter'));
            }
        }

        if(front::post('catid')){
            session::set('searchcatid', trim(front::post('catid')));
            $this->view->catid = trim(front::post('catid'));
        }else{
            $this->view->catid =session::get('searchcatid');
        }

        if (preg_match('/union/i', $this->view->keyword) || preg_match('/"/i', $this->view->keyword) || preg_match('/\'/i', $this->view->keyword)) {
            exit(lang('illegal_parameter'));
        }

        $path = ROOT . '/data/hotsearch/' . urlencode($this->view->keyword) . '.txt';
        $mtime = @filemtime($path);
        $time = intval(config::getadmin('search_time')) ? intval(config::getadmin('search_time')) : 30;
        if (time() - $mtime < $time && !front::get('page')) {
            alertinfo($time . lang('within_seconds_can_not_repeat_search'), 'index.php?t=' . front::get('t'));
        }
        $keywordcount = @file_get_contents($path);
        $keywordcount = $keywordcount + 1;
        file_put_contents($path, $keywordcount);
        $type = $this->view->category;
        $condition = "";
        $cid = intval($this->view->catid);
        if ($cid) {
            $cateobj = category::getInstance();
            $sons = $cateobj->sons($cid);
            if (is_array($sons) && !empty($sons)) {
                $cids = $cid . ',' . implode(',', $sons);
            } else {
                $cids = $cid;
            }
            $condition .= "catid in (" . $cids . ") AND ";
            //var_dump($condition);exit;
        }
        $condition .= "(title like '%" . $this->view->keyword . "%'";
        $sets = settings::getInstance()->getrow(array('tag' => 'table-fieldset'));
        $arr = unserialize($sets['value']);
        if (is_array($arr['archive']) && !empty($arr['archive'])) {
            foreach ($arr['archive'] as $v) {
                if ($v['issearch'] == '1') {
                    $condition .= " OR {$v['name']} like '%{$this->view->keyword}%'";
                }
            }
        }
        $condition=$condition==""?' langid="'.lang::getlangid(lang::getistemplate()).'"':$condition.' and langid="'.lang::getlangid(lang::getistemplate()).'"';
        $condition.= ")";

        $order = "`listorder`,1 DESC";
        $limit = (($this->view->page - 1) * $this->pagesize) . ',' . $this->pagesize;
        $articles = $this->archive->getrows($condition, $limit, $order);
        foreach ($articles as $order => $arc) {
            $articles[$order]['url'] = archive::url($arc);
            $articles[$order]['catname'] = category::name($arc['catid']);
            $articles[$order]['caturl'] = category::url($arc['catid']);
            $articles[$order]['adddate'] = sdate($arc['adddate']);
            $articles[$order]['stitle'] = strip_tags($arc['title']);
        }
        $this->view->articles = $articles;
        $this->view->archives = $articles;
        $this->view->record_count = $this->archive->record_count;
    }

    function esearch_action()
    {
        front::check_type(front::get('keyword'), 'safe');
        $this->view->keyword = trim(front::get('keyword'));



        if ($this->view->keyword) {
            $path = ROOT . '/data/hotsearch/' . urlencode($this->view->keyword) . '.txt';
            $mtime = @filemtime($path);
            $time = intval(config::getadmin('search_time')) ? intval(config::getadmin('search_time')) : 30;
            if (time() - $mtime < $time && !front::get('page')) {
                alertinfo($time . lang('within_seconds_can_not_repeat_search'), 'index.php?t=' . front::get('t'));
            }
            $keywordcount = @file_get_contents($path);
            $keywordcount = $keywordcount + 1;
            file_put_contents($path, $keywordcount);
            $type = $this->view->category;
            $condition = "";
            if (front::get('catid')) {
                $condition .= "catid = '" . front::get('catid') . "' AND ";
            }
            $condition .= "(title like '%" . $this->view->keyword . "%'";
            $sets = settings::getInstance()->getrow(array('tag' => 'table-fieldset'));
            $arr = unserialize($sets['value']);
            if (is_array($arr['archive']) && !empty($arr['archive'])) {
                foreach ($arr['archive'] as $v) {
                    if ($v['issearch'] == '1' && front::get($v['name'])) {
                        if ($v['selecttype']) {
                            $condition .= " AND {$v['name']} = '" . front::get($v['name']) . "'";
                        } else {
                            $condition .= " AND {$v['name']} like '%" . front::get($v['name']) . "%'";
                        }
                    }
                }
            }
            $condition .= ")";
            $order = "`listorder`,1 DESC";
            $limit = (($this->view->page - 1) * $this->pagesize) . ',' . $this->pagesize;
            $articles = $this->archive->getrows($condition, $limit, $order);
            foreach ($articles as $order => $arc) {
                $articles[$order]['url'] = archive::url($arc);
                $articles[$order]['catname'] = category::name($arc['catid']);
                $articles[$order]['caturl'] = category::url($arc['catid']);
                $articles[$order]['adddate'] = sdate($arc['adddate']);
                $articles[$order]['stitle'] = strip_tags($arc['title']);
            }
            $this->view->articles = $articles;
            $this->view->archives = $articles;
            $this->view->record_count = $this->archive->record_count;
        }
        $this->view->field = $this->archive->getFields();
        if (isset($_GET['catid'])){
            $data=front::$get;
            $where='1=1 ';
            foreach ($data as $key=>$value){
                if($key != 'case' && $key!='act' && $key!='site' && $key!='page'
                    && $key !='dfile'&& ($key !='catid' && $value!='0')){
                    $value=$value==""?0:$value;
                    $where=$where." and IFNULL(".$key.",0)='".$value."'";
                }
            }
            $sql1=" select * from  cmseasy_archive where ".$where;
            $count=$this->archive->rec_query($sql1);
            $limit=' limit 0,5';
            if(isset($_GET['page'])){
                $page=$page*5;
                $limit=' limit '.$page.',5';
            }
            $sql2=" select * from  cmseasy_archive where ".$where.$limit;

            $articlesTites=$this->archive->rec_query($sql2);
            $this->view->articlesTites =$articlesTites;
            $this->view->count =count($count);
        }

    }

    function asearch_action()
    {
        if (front::get('keyword') && !front::post('keyword'))
            front::$post['keyword'] = front::get('keyword');
        front::check_type(front::post('keyword'), 'safe');
        if (front::post('keyword')) {
            $this->view->keyword = trim(front::post('keyword'));
            session::set('keyword', $this->view->keyword);
        } elseif (session::get('keyword')) {
            $this->view->keyword = trim(session::get('keyword'));
            session::set('keyword', $this->view->keyword);
        } else {
            session::set('keyword', null);
            $this->view->keyword = session::get('keyword');
        }
        $limit = (($this->view->page - 1) * $this->pagesize) . ',' . $this->pagesize;
        $articles = $this->archive->getrows("title like '%" . $this->view->keyword . "%'", $limit);
        foreach ($articles as $order => $arc) {
            $articles[$order]['url'] = archive::url($arc);
            $articles[$order]['catname'] = category::name($arc['catid']);
            $articles[$order]['caturl'] = category::url($arc['catid']);
            $articles[$order]['adddate'] = sdate($arc['adddate']);
            $articles[$order]['stitle'] = strip_tags($arc['title']);
        }
        $this->view->articles = $articles;
        $this->view->archives = $articles;
        $this->view->record_count = $this->archive->record_count;
    }

    function show_action()
    {
        $aid = intval(front::get('aid'));
        if (!$aid) {
            $aid = intval(front::get('id'));
        }
        //判断内容是否可查看  是否设置付费查看   商品除外
        $archivedata=$this->archive->getrow('aid='.$aid.' and (attr2 is null or attr2="") ');
        if($archivedata['readmenoy']>0){
            if (session::get('username')!=''){
                $userdata=user::getInstance()->getrow("username='".session::get('username')."'");
                $array = explode(",",$userdata['buyarchive']);
                if(!((in_array($aid,$array) || $userdata['buyarchive']==$aid))){
                    //exit(lang('no_buy_no_read'));
                    exit("<div class='tip_box' style='width:300px;margin:0px auto;margin-top:50px;padding:20px;border:5px solid #ccc;border-radius: 5px 5px 5px 5px;text-align:center;'>" . lang('error_url') . "<a href='javascript:history.back(-1);'>" . lang('no_buy_no_read') . "</a></div>");
                }
            }else{
                //exit(lang('buymenoycommont_noread'));
                exit("<div class='tip_box' style='width:300px;margin:0px auto;margin-top:50px;padding:20px;border:5px solid #ccc;border-radius: 5px 5px 5px 5px;text-align:center;'>" . lang('error_url') . "<a href='javascript:history.back(-1);'>" . lang('buymenoycommont_noread') . "</a></div>");
            }
        }
        front::check_type($aid);
        //获取自定义字段
        $this->view->field = $this->archive->getFields();
        $this->view->showarchive = archive::getInstance()->getrow($aid,'');
        //var_dump($this->view->showarchive);
        $this->manage = new table_archive();
        $this->manage->view_before($this->view->showarchive);
        $addcontentuser = new user();
        $addcontentuser = $addcontentuser->getrow(array('userid' => $this->view->showarchive['userid']));
        if (is_array($addcontentuser)) {
            $this->view->adduser = $addcontentuser;
        }

        if(session::get('ver') != 'corp'){
            $this->view->showarchive['my_field']='';
        }
        $this->view->archive = $this->view->showarchive;

        $this->view->categorys = category::getpositionlink2($this->view->archive['catid']);
        if (!is_array($this->view->archive))
            $this->out('message/error.html');
        if ($this->view->archive['checked'] < 1)
            exit("<div class='tip_box' style='width:300px;margin:0px auto;margin-top:50px;padding:20px;border:5px solid #ccc;border-radius: 5px 5px 5px 5px;text-align:center;'>" . lang('error_url') . "<a href='javascript:history.back(-1);'>" . lang('go_back') . "</a></div>");
        if (!rank::arcget(front::get('aid'), $this->view->usergroupid)) {
            $this->out('message/error.html');
        }
        $this->view->catid = $this->view->archive['catid'];
        $this->view->topid = category::gettopparent($this->view->catid);
        $this->view->parentid = $this->category->getparent($this->view->catid);
        if (!rank::catget($this->view->catid, $this->view->usergroupid))
            $this->out('message/error.html');
        if (!isset($this->category->category[$this->view->catid]) ||
            !isset($this->category->category[$this->view->topid])
        ) {

        }
        $template = @$this->view->archive['template'];

        $content = $this->view->archive['content'];
        //$contents = preg_split('%<div style="page-break-after(.*?)</div>%si', $content);
        $contents = preg_split('%<hr/>%', $content);
        if ($contents) {
            $this->view->pages = count($contents);
            front::$record_count = $this->view->pages * config::getadmin('list_pagesize');
            $content = $contents[$this->view->page - 1];
        }

        $this->view->likenews = $this->getLike($this->view->archive['tag'], $this->view->archive['keyword']);

        $taghtml = '';
        $tag_table = new tag();
        foreach ($tag_table->urls($this->view->archive['tag']) as $tag => $url) {
            $taghtml .= "<a href='$url' target='_blank'>$tag</a>&nbsp;&nbsp;";
        }
        $this->view->archive['tag'] = $taghtml;

        $this->view->archive['special'] = null;
        if ($this->view->archive['spid']) {
            $spurl = special::url($this->view->archive['spid'], special::getishtml($this->view->archive['spid']));
            $sptitle = special::gettitle($this->view->archive['spid']);
            $this->view->archive['special'] = "<a href='$spurl' target='_blank'>$sptitle</a>&nbsp;&nbsp;";
        }
        $this->view->archive['type'] = null;
        if ($this->view->archive['typeid']) {
            $typeurl = type::url($this->view->archive['typeid'], 1);
            $typetitle = type::name($this->view->archive['typeid']);
            $this->view->archive['type'] = "<a href='$typeurl' target='_blank'>$typetitle</a>&nbsp;&nbsp;";
        }
        //$this->view->archive['area'] = null;
        //$this->view->archive['area'] = area::getpositonhtml($this->view->archive['province_id'], $this->view->archive['city_id'], $this->view->archive['section_id']);
        $this->view->archive['content'] = $content;
        $aid = intval(front::$get['aid']);
        $catid = $this->view->catid;
        if (!$this->view->archive['showform']) {
            $this->getshowform($catid);
        } else if ($this->view->archive['showform'] && $this->view->archive['showform'] == '1') {
            $this->showform = 1;
        } else {
            $this->showform = $this->view->archive['showform'];
        }
        if (preg_match('/^my_/is', $this->showform)) {
            $this->view->archive['showform'] = $this->showform;
            $o_table = new defind($this->showform);
            front::$get['form'] = $this->showform;
            $this->view->primary_key = $o_table->primary_key;
            $field = $o_table->getFields();
            $fieldlimit = $o_table->getcols('user_modify');
            helper::filterField($field, $fieldlimit);
            $this->view->field = $field;
        } else {
            $this->view->archive['showform'] = '';
        }

        $str = "";
        cb_data($this->view->archive);
        $newcname='cname_'.lang::getistemplate();
        foreach ($this->view->archive as $key => $value) {
            if (!preg_match('/^my/', $key) || !$value)
                continue;
            $category = category::getInstance();
            $sonids = $category->sons(setting::$var['archive'][$key]['catid']);
            if (setting::$var['archive'][$key]['catid'] != $this->view->archive['catid']
                && !in_array($this->view->archive['catid'], $sonids) ) {//&& (setting::$var['archive'][$key]['catid'])
                unset($this->view->field[$key]);
                continue;
            }
            $str .= '<p> ' . setting::$var['archive'][$key][$newcname] . ':' . $value . '</p>';
        }
        $this->view->archive['my_fields'] = $str;

        $sql1 = "SELECT aid,title,catid FROM `{$this->archive->name}` WHERE catid = '$catid' AND aid > '$aid' and state=1 and checked=1 ORDER BY aid ASC LIMIT 0,1";
        $sql2 = "SELECT aid,title,catid FROM `{$this->archive->name}` WHERE catid = '$catid' AND aid < '$aid' and state=1 and checked=1 ORDER BY aid DESC LIMIT 0,1";
         $n = $this->archive->rec_query_one($sql1);
        $p = $this->archive->rec_query_one($sql2);
        $this->view->archive['p'] = $p;
        $this->view->archive['n'] = $n;
        $this->view->archive['p']['url'] = archive::url($p);
        $this->view->archive['n']['url'] = archive::url($n);

        $this->view->archive['strgrade'] = archive::getgrade($this->view->archive['grade']);
        $prices = getPrices($this->view->archive['attr2']);
        $this->view->archive['attr2'] = $prices['price'];
	$this->view->archive['url'] = archive::url($this->view->archive);
        $this->view->archive['oldprice'] = $prices['oldprice'];
        $this->view->groupname = $prices['groupname'];


        //自定义字段区分语言包
        $datanamefield=explode(",",trim($this->view->archive['my_field']));
        $fieldName='';
        for($index=0;$index<count($datanamefield);$index++){
            $category = category::getInstance();
            $sonids = $category->sons(setting::$var['archive'][$datanamefield[$index]]['catid']);
            $sonids[count($sonids)]=setting::$var['archive'][$datanamefield[$index]]['catid'];
            if (setting::$var['archive'][$datanamefield[$index]]['catid'] == $this->view->archive['catid']
                || in_array($this->view->archive['catid'], $sonids) ) { //&& (setting::$var['archive'][$datanamefield[$index]]['catid'])
                    if($fieldName==''){
                        $fieldName=$datanamefield[$index];
                    }else{
                        $fieldName=$fieldName.','.$datanamefield[$index];
                    }
            }
        }

        $this->view->archive['my_field'] =$fieldName;



        if (front::$ismobile) {
            $templatewap = @$this->view->archive['templatewap'];
            if ($templatewap && file_exists(TEMPLATE . '/' . $this->view->_style . '/' . $templatewap)) {
                $this->out($templatewap);
            } else {
                $tpl = category::gettemplate($this->view->catid, 'showtemplatewap');
                if (!$tpl) $tpl = 'archive/show.html';
                $this->out($tpl);
                return;
            }
        }


        //动态下  区分商品和内容
        if( $this->view->archive['attr2']!=''){
            $template=config::getadmin('template_shopping_dir').'/'.$template;
        }
        if ($template && (file_exists(TEMPLATE . '/' . $this->view->_style . '/' . $template)
            || file_exists(TEMPLATE . '/' . $template) )){
            $this->out($template);
        }else {
            $tpl = category::gettemplate($this->view->catid, 'showtemplate');
            if (category::getarcishtml($this->view->archive)) {
                $path = ROOT . archive::url($this->view->archive);
                if (!preg_match('/\.[a-zA-Z]+$/', $path))
                    $path = rtrim(rtrim($path, '/'), '\\') . '/index.html';
                $this->cache_path = $path;
            }
            if( $this->view->archive['attr2']!=''){
                $tpl=config::getadmin('template_shopping_dir').'/'.$tpl;
            }
            $this->out($tpl);
        }
    }

    //获取标题和按钮
    function gettitle_action(){
        $aid=front::get('aid');
        $returndata='';
        $archive=archive::getInstance();
        $user = user::getInstance();
        $archivedata=$archive->getrow('aid='.$aid);
        if (is_array($archivedata)){
            //$name = archive_attachment($aid, 'intro');   //名称
            $userdata=$user->getrow("username='".session::get('username')."'"); //用户是否购买过
            $array = explode(",",$userdata['buyarchive']);
            $url="'".url('archive/buyarchive/aid/'.$aid)."'";   //购买链接
            if($archivedata['attachment_path']){
                if($archivedata['readmenoy']>0){
                    if(in_array($aid,$array)){
                        $returndata.='<a title="'.strip_tags($archivedata['title']).'" href="'.archive::url($archivedata).'" target="_blank">'.$archivedata['title'].'</a>';
                        $returndata.="<span><a target='_blank' title='".strip_tags($archivedata['title'])."' id='att' name='attmenoy' href='" . url::create('attachment/down/aid/' . $aid) . "' class='btn btn-default visual-content-down-link-btn'>" . lang('nowdownload') . "</a></span>";
                    }else{
                        $returndata.='<a title="'.strip_tags($archivedata['title']).'">'.$archivedata['title'].'</a>';
                        $returndata.= "<span><a target='_blank' id='att' name='attmenoy' onclick=\"shoppingarchive(".$url.",'".lang('doyou_buy')."')\" class='btn btn-default visual-content-down-link-btn'>" . lang('buy') . "</a></span>";
                    }
                }else if ($archivedata['domwmenoy']>0){
                    $returndata.='<a title="'.strip_tags($archivedata['title']).'" href="'.archive::url($archivedata).'" target="_blank">'.$archivedata['title'].'</a>';
                    if(in_array($aid,$array)){
                        $returndata.="<span><a target='_blank' title='".strip_tags($archivedata['title'])."' id='att' name='attmenoy' href='" . url::create('attachment/down/aid/' . $aid) . "' class='btn btn-default visual-content-down-link-btn'>" . lang('nowdownload') . "</a></span>";
                    }else{
                        $returndata.= "<span><a target='_blank' id='att' name='attmenoy' onclick=\"shoppingarchive(".$url.",'".lang('doyou_buy')."')\" class='btn btn-default visual-content-down-link-btn'>" . lang('buy') . "</a></span>";
                    }
                }else{
                    //$returndata .= '<a title="' . strip_tags($archivedata['title']) . '">' . $archivedata['title'] . '</a>';
                    $returndata.='<a title="'.strip_tags($archivedata['title']).'" href="'.archive::url($archivedata).'" target="_blank">'.$archivedata['title'].'</a>';
                    $returndata.= "<span><a target='_blank' title='".strip_tags($archivedata['title'])."' id='att' name='attmenoy' href='" . url::create('attachment/down/aid/' . $aid) . "' class='btn btn-default visual-content-down-link-btn'>" . lang('nowdownload') . "</a></span>";
                }
            }else{
                if($archivedata['readmenoy']>0  && in_array($aid,$array)) {
                    $returndata .= '<a title="' . strip_tags($archivedata['title']) . '">' . $archivedata['title'] . '</a>';
                    $returndata.= "<span><a target='_blank' id='att' name='attmenoy' onclick=\"shoppingarchive(".$url.",'".lang('doyou_buy')."')\" class='btn btn-default visual-content-down-link-btn'>" . lang('buy') . "</a></span>";
                }else{
                    $returndata.='<a title="'.strip_tags($archivedata['title']).'" href="'.archive::url($archivedata).'" target="_blank">'.$archivedata['title'].'</a>';
                    $returndata.='<span><a class="visual-content-down-link-btn">'.lang('nodownload').'</a></span>';
                    }

            }
        }
        echo json_encode($returndata);
        exit;
    }


    //购买阅读内容
    function buyarchive_action(){
        if(session::get('username')==''){
            $returndata=array('static'=>0,'message'=>lang('buy_old_login'));
        }else{
            $aid=front::get('aid');
            $archive = archive::getInstance();
            $archivedata=$archive->getrow('aid='.$aid);
            if (is_array($archivedata)){
                //购买的价格
                $archivemenoy=0;
                if($archivedata['readmenoy']>0){
                   $archivemenoy=$archivedata['readmenoy'];
                }else  if ($archivedata['domwmenoy']>0){
                    $archivemenoy=$archivedata['domwmenoy'];
                }
                $user=user::getInstance();
                $userdata=$user->getrow("username='".session::get('username')."'");
                if($userdata['menoy']>$archivemenoy){
                    //减少用户余额
                    $userdata['menoy']=round($userdata['menoy']-$archivemenoy,2);
                    if( $userdata['buyarchive']==''){
                        $userdata['buyarchive']=$aid;
                    }else{
                        $userdata['buyarchive'].=','.$aid;
                    }
                    $user->rec_update(array('menoy'=>$userdata['menoy'],'buyarchive'=>$userdata['buyarchive']),$userdata['userid']);
                    //生成订单
                    $xfconsumption = new xfconsumption();
                    $xfconsumptiondata['adddate'] =  date('Y-m-d h:i:s', time());
                    $xfconsumptiondata['mid'] = $userdata['userid'];
                    $payname ='none';
                    $xfconsumptiondata['oid'] = date('YmdHis') . '-' . $xfconsumptiondata['mid'] . '-' . $payname;
                    $xfconsumptiondata['status'] = 1;
                    $xfconsumptiondata['menoy'] = $archivemenoy;
                    $xfconsumptiondata['content'] = lang('pay_reading_download_No').$aid;
                    $xfconsumption->rec_insert($xfconsumptiondata);
                    $returndata=array('static'=>1,'message'=>lang('buy_success'));
                }else{
                    $returndata=array('static'=>0,'message'=>lang('insufficient_balance_please_recharge_first'));
                }
            }else{
                $returndata=array('static'=>0,'message'=>lang('no_archive'));
            }
        }
        echo json_encode($returndata);
        exit;
    }

    //商品类型名称
    function getfieldName_action(){
        $field=front::get('field');

        $dataname= array();
        $datanamefield=explode(",",trim($field));
        $fieldName='';
        $newcname='cname_'.lang::getistemplate();
        for($index=0;$index<count($datanamefield);$index++){
                if($fieldName==''){
                    $fieldName=setting::$var['archive'][$datanamefield[$index]][$newcname];
                }else{
                    $fieldName=$fieldName.','.setting::$var['archive'][$datanamefield[$index]][$newcname];
                }
        }
        echo json_encode($fieldName);
        exit;
    }
   //商品类型
    function getarchiveType_action(){
        $aid = intval(front::get('aid'));
        if (!$aid) {
            $aid = intval(front::get('id'));
        }
        front::check_type($aid);
        $archivedata=archive::getInstance()->getrow($aid,'');
        if(is_array($archivedata)){
            $prices = getPrices($archivedata['attr2']);
            $archivedata['attr2'] = $prices['price'];
            $archivedata['oldprice'] = $prices['oldprice'];
        }
        echo json_encode($archivedata);
        exit;
    }
    //商品类型
    function searAdminTitle_action(){
        $sear_name = front::get('sear_name');
        $path=ROOT.'/lang/'.lang::getisadmin().'/system_search.php';
        $content=include($path);
        $newcontent=array();
        foreach ($content as $key=>$value){
            if( $sear_name=="" || (strpos($key,$sear_name) !== false)  ){
                $newstatic=true;
                foreach ($newcontent as $newkey=>$newval){
                    if($newval['titleURL']==$value){
                        $newstatic=false;
                    }
                }
                if($newstatic){
                    array_push($newcontent,array("title"=>$key,"titleURL"=>$value));
                }
            }
        }
        echo json_encode($newcontent);
        exit;

    }

    function getLike($tag, $keyword)
    {
        $str = '';
        if ($tag) {
            $tags = explode(',', $tag);
            foreach ($tags as $v) {
                if ($v)
                    $str .= " OR tag LIKE '%$v%'";
            }
        }
        if ($keyword) {
            $keywords = explode(",", $keyword);
            foreach ($keywords as $v) {
                if ($v)
                    $str .= " OR keyword LIKE '%$v%'";
            }
        }
        $str = substr($str, 3);
        if (!$str) {
            return null;
        }
        $prefix = config::getdatabase('database', 'prefix');
        $limit = intval(config::getadmin('like_news')) ? intval(config::getadmin('like_news')) : 5;
        $sql = "SELECT aid,catid,typeid,title,adddate,linkto,iswaphtml,htmlrule,ishtml,introduce,thumb FROM `{$prefix}archive` where checked=1 AND ($str) ORDER BY aid DESC LIMIT 0,$limit";
        //echo $sql;
        $row = $this->archive->rec_query($sql);
        return $row;
    }

    function getshowform($cid)
    {
        $category = category::getInstance();
        $row = $category->getrow(array('catid' => $cid), '1 desc', 'catid,showform,parentid');
        if ($row['showform'] && $row['showform'] != 1) {
            $this->showform = $row['showform'];
        } else if ($row['showform'] && $row['showform'] == 1) {
            $this->showform = 1;
        } else if (!$row['showform']) {
            if ($row['parentid'] != 0) {
                $this->getshowform($row['parentid']);
            } else {
                $this->showform = '1';
            }
        }
    }

    function view_js_action()
    {
        front::check_type(front::get('aid'));
        $aid = intval(front::get('aid'));
        $this->archive->rec_update('view=view+1', $aid);
        $archive = $this->archive->getrow($aid);
        echo tool::text_javascript($archive['view']);
        exit;
    }

    function jsPrice_action()
    {
        front::check_type(front::get('aid'));
        $aid = intval(front::get('aid'));
        $archive = $this->archive->getrow($aid);
        $price = getPrices($archive['attr2']);
        echo tool::text_javascript($price['price']);
        exit;
    }

    function email_action()
    {
        if (front::post('submit')) {
            $path = ROOT . '/data/subscriptionmail.txt';
            $maillist = file_get_contents($path);
            $content = $maillist . ',guest' . time() . ' [' . front::$post['email'] . ']';
            file_put_contents($path, $content);
            echo '<script type="text/javascript">alert("' . lang('operation_complete') . '")</script>';
            front::refresh(url('archive/email', true));
        }
        $this->render('email/email.html');
        exit;
    }

    function respond_action()
    {
        //file_put_contents('get.txt',var_export($_GET,true));
        if(front::$get['code'] == 'wxscanpay') {
            //$xml = $GLOBALS['HTTP_RAW_POST_DATA'];
            //file_put_contents('xlog.txt',$xml);
            include_once ROOT . '/lib/plugins/pay/wxscanpay.php';
            $payobj = new wxscanpay();
            $payobj->notify();
            exit;
        }
        //file_put_contents('post.txt',var_export($_POST,true));

        $out_trade_no = $_GET['subject'] ? $_GET['subject'] : $_POST['subject'];
        if(!$out_trade_no){
            $out_trade_no = $_GET['out_trade_no'] ? $_GET['out_trade_no'] : $_POST['out_trade_no'];
        }
        $code = explode('-', $out_trade_no);
        if(front::$get['tablename'] == 'consumption'){
            $payclassname = $code[2];
        }else{
            $payclassname = $code[3];
        }

        $flist = array('alipay', 'nopay', 'paypal', 'paypal_ec', 'tenpay', 'malipay','wxpay','wxscanpay');
        if (!in_array($payclassname, $flist)) {
            exit(lang('illegal_parameter'));
        }

        include_once ROOT . '/lib/plugins/pay/' . $payclassname . '.php';

        $payobj = new $payclassname();
        $status = $payobj->respond(front::$get['tablename']);

        //var_dump($status);
        if ($_POST['out_trade_no']) {
            if ($status) {
                exit('success');
            } else {
                exit('fail');
            }
        }

        $url='archive/'.front::$get['tablename'].'/oid/';

        $xfconsumptiondata=xfconsumption::getInstance()->getrows('oid="'.$out_trade_no.'"');//查询是否存在消费订单
        if ($status && count($xfconsumptiondata)<1) {
            $table = new front::$get['tablename']();
            $tabledata = $table->getrows("oid='".$out_trade_no."'", 1); //查询订单表
            //新增消费记录
            $xfconsumption = new xfconsumption();
            $xfconsumptiondata = array();
            $xfconsumptiondata['status'] = '1';
            $xfconsumptiondata['adddate'] = date('Y-m-d h:i:s', time());
            $xfconsumptiondata['mid'] = $this->view->user['userid'] ? $this->view->user['userid'] : 0;
            $xfconsumptiondata['trade_no'] = '';

            if(front::$get['tablename'] == 'consumption'){
                $user=new user();
                $userdata = $user->getrows("userid='".$code[1]."'", 1);
                $moeny=$userdata[0]['menoy'];
                $moeny=(float)($moeny)+(float)($tabledata[0]['menoy']);
                $moenyarray = array('menoy' => $moeny);
                $user->rec_update($moenyarray, "userid='".$code[1]."'");
                $xfconsumptiondata['oid'] = $out_trade_no;
                $xfconsumptiondata['menoy'] =$tabledata[0]['menoy'];
                $xfconsumptiondata['content'] = lang('lang_user').lang('recharge').'！';
            }else{
                //商品购买的订单
                $xfconsumptiondata['oid'] = $out_trade_no;
                $xfconsumptiondata['menoy'] = $tabledata[0]['menoy'];
                $xfconsumptiondata['content'] = lang('purchase_and_consumption_of_goods');
                //获取到购买的商品  进行计算销售量
                $ordersAid = explode("-",trim($tabledata[0]['aid']));

                for($index=0;$index<count($ordersAid);$index++){
                    $source = explode("#",trim($ordersAid[$index]));
                    $_aidArrys = explode(",", trim($source[0]));
                    $datavuel = archive::getInstance()->getrows('aid = '.$_aidArrys[0],1);
                    $newsalesnum=$datavuel[0]['salesnum']+1;   //销售加1
                    //修改销售量
                    archive::getInstance()->rec_update(array('salesnum'=>$newsalesnum), $_aidArrys[0]);

                }

            }
            //新增消费订单
            $xfconsumption->rec_insert($xfconsumptiondata);
            $table->rec_update(array('status' => '1'), 'oid=\''.$out_trade_no.'\'');


            echo '<script type="text/javascript">alert("' . lang('go_order') . '")</script>';
            front::refresh(url($url . $out_trade_no, true));
        } else {
            echo '<script type="text/javascript">alert("' . lang('go_order') . '")</script>';
            front::refresh(url($url . $out_trade_no, true));
        }
        exit;
    }

    function chkorders_action()
    {
        $oid = front::get('oid');
        $row = orders::getInstance()->getrow(array('oid'=>$oid));
        echo $row['status'];
        exit;
    }

    function payorders_action()
    {
        //var_dump($_SERVER['QUERY_STRING']);
        if (front::get('oid')) {
            preg_match_all("/-(.*)-(.*)-(.*)/isu", front::get('oid'), $oidout);
            $this->view->paytype = $oidout[3][0];
            if($this->view->paytype=='none'){
                echo '<script type="text/javascript">alert("'.lang('no_payment_contact_administrator').'");window.opener=null;window.close();</script>';
                exit;
            }
            $this->view->user_id = $oidout[2][0];
            $where = array();
            $where['oid'] = front::get('oid');
            //手续费为0
            $this->view->freetotal=0;
            $this->view->orders = orders::getInstance()->getrow($where);
            //获取AID   后面永远都带逗号    所以 $pos !== false永远不会进入else
            $newaid=$this->view->orders['aid'];
            $source = explode("-",trim( $this->view->orders['aid']));
            $this->view->orders['aid']='';
            for($index=0;$index<count($source);$index++){
                $sourceindex = explode("#",trim($source[$index]));
                $_aidArrys = explode(",", trim($sourceindex[0]));
                $this->view->orders['aid']=$this->view->orders['aid'].$_aidArrys[0].',';
            }

            $string = $this->view->orders['aid'];
            $find = ',';
            $pos = strpos($string, $find);
            $this->view->statusnum = $data['status'] = $this->view->orders['status'];
            switch ($data['status']) {
                case 1:
                    $this->view->orders['status'] = lang('complete');
                    break;
                case 2:
                    $this->view->orders['status'] = lang('processing');
                    break;
                case 3:
                    $this->view->orders['status'] = lang('shipped');
                    break;
                case 4:
                    $this->view->orders['status'] = lang('pending_audit_payment');
                    break;
                case 5:
                    $this->view->orders['status'] = lang('check_payment');
                    break;
                default:
                    $this->view->orders['status'] = lang('ordersnotalreadydo');
                    break;
            }
            //var_dump($this->view);
            if (!$this->view->user['userid']) {
                echo '<script type="text/javascript">alert("' . lang('not_logged_save_the_order_number') .$oidout[1][0].'-'.$oidout[2][0].'-'.$oidout[3][0]. '")</script>';
            }
            $logisticsid = $oidout[1][0];
            if ($pos !== false) {
                $_aid = $string;
                $_aid = substr($_aid, 0, -1);
                //获取产品
                $orderssomedata=array();
                $ordersAid = explode("-",trim($newaid));
                $discount=usergroup::getusergrop(user::getuserid($oidout[2][0])); //获取用户组的折扣
                $isint =usergroup::getisint(user::getuserid($oidout[2][0]));      //获取是否取整
                for($index=0;$index<count($ordersAid);$index++){
                    $source = explode("#",trim($ordersAid[$index]));
                    $_aidArrys = explode(",", trim($source[0]));
                    $datavuel = archive::getInstance()->getrows('aid in ('.$_aidArrys[0].')',100);
                    $datavuel[0]['attr2']=(floatval($datavuel[0]['attr2'])*$discount/10);   //单价打折
                    if($isint){                                  //判断取整
                        $datavuel[0]['attr2']=round($datavuel[0]['attr2']);
                    }
                    if(count($source)>0){
                        $datavuel[0]['leixing']=$source[1];
                    }else{
                        $datavuel[0]['leixing']='';
                    }
                    $datavuel[0]['num']=$_aidArrys[1];
                    $orderssomedata[count($orderssomedata)]=$datavuel[0];
                }
                $this->view->archivearr1 = $this->view->_archivearr =$orderssomedata;

                //重算单价和数量
                foreach ($this->view->archivearr1 as $key => $val) {
                    if($val['leixing']!=''){
                        //重算单价
                        $newsource = explode(".",trim($val['leixing']));
                        for($index=0;$index<count($newsource);$index++){
                            $sourceArry = explode(":",trim($newsource[$index]));
                            $sourceArry = explode(",",trim($sourceArry[1]));
                            if($sourceArry[1]=="jia"){
                                $val['attr2']=floatval($val['attr2'])+floatval($sourceArry[2]);
                            }else if($sourceArry[1]=="jian"){
                                $val['attr2']=floatval($val['attr2'])-floatval($sourceArry[2]);
                            }else if($sourceArry[1]=="chen"){
                                $val['attr2']=floatval($val['attr2'])*floatval($sourceArry[2]);
                            }else if($sourceArry[1]=="chu"){
                                $val['attr2']=floatval($val['attr2'])/floatval($sourceArry[2]);
                            }
                        }
                    }
                    $pnums=$val['num'];

                   /* $prices = getPrices($val['attr2']);
                    $val['attr2'] = $prices['price'];*/
                    $this->view->archivearr1[$key]['attr2'] = $val['attr2'];
                    $this->view->orders[$key]['pnums'] = $pnums;
                    $this->view->archive['title'] .= $val['title'];
                    $where = array();
                    $payfilename = $where['pay_code'] = $this->view->paytype;
                    $where['langid']=lang::getlangid(lang::getistemplate());
                    $this->view->pay = pay::getInstance()->getrows($where);
                    $where = array();
                    $where['id'] = $logisticsid;
                    $this->view->logistics = logistics::getInstance()->getrows($where);
                    if ($this->view->logistics[0]['cashondelivery']) {
                        $this->view->logistics[0]['price'] = 0.00;
                    } else {
                        if ($this->view->logistics[0]['insure']) {
                            $this->view->logistics[0]['price'] = $this->view->logistics[0]['price'] + ($val['attr2'] * $this->view->orders[$key]['pnums']) * ($this->view->logistics[0]['insureproportion'] / 100);
                        }
                    }
                    if (!isset($this->view->logistics[0]['price']))
                        $this->view->logistics[0]['price'] = 0;
                    $this->view->pay[0]['pay_fee'] = $this->view->pay[0]['pay_fee'] / 100;
                    //重算总价
                    $this->view->archivearr1[$key]['total'] = $val['attr2'] * $pnums  + ($val['attr2'] * $pnums * $this->view->pay[0]['pay_fee']);

                    $this->view->total += $val['attr2'] * $pnums  + ($val['attr2'] * $pnums * $this->view->pay[0]['pay_fee']);

                    //计算手续费
                    $this->view->freetotal+=$val['attr2'] * $pnums * $this->view->pay[0]['pay_fee'];
                }
                $this->view->total += $this->view->logistics[0]['price']-$this->view->orders['admindiscounts'];
                $this->view->total= $this->view->total>0?$this->view->total:0;

                //优惠劵使用
                $couponmenoy=array();
                $this->view->fktotal=$this->view->total;
                if(isset($this->view->orders['somecoupon']) && $this->view->orders['somecoupon'] != '' ){
                    if(strpos(trim($this->view->orders['somecoupon']),',') !== false) {
                        $source = explode(",", trim($this->view->orders['somecoupon']));
                        for ($index = 0; $index < count($source); $index++) {
                            $coupondata=coupon::getcouponid( $source[$index]);; //优惠劵信息获取
                            $this->view->fktotal=(float)($this->view->total)-(float)($coupondata['moeny']);
                            $couponmenoy[count($couponmenoy)]=array((int)$coupondata['moeny'],$coupondata['coupontitle']); //保存优惠金额
                        }
                    }
                    else{
                        $coupondata=coupon::getcouponid(  $this->view->orders['somecoupon']);; //优惠劵信息获取
                        $this->view->fktotal=(float)($this->view->total)-(float)($coupondata['moeny']);
                        $couponmenoy[count($couponmenoy)]=array((int)$coupondata['moeny'],$coupondata['coupontitle']);  //保存优惠金额
                    }
                }
                $this->view->archivearr1['couponmenoy']=$couponmenoy;

                $order['ordersn'] = front::get('oid');
                $order['title'] = $this->view->archive['title'];
                $order['id'] = $this->view->orders['id'];
                $order['orderamount'] = $this->view->fktotal;
                $order['talename'] ='orders';
                include_once ROOT . '/lib/plugins/pay/' . $payfilename . '.php';
                $payclassname = $payfilename;
                $payobj = new $payclassname();
                $this->view->pay[0]['pay_config'];
                $this->view->gotopaygateway = $payobj->get_code($order, unserialize_config($this->view->pay[0]['pay_config']));
                //var_dump($this->view->gotopaygateway);exit;
            }
            else {
              /*  $this->view->archive = archive::getInstance()->getrow($this->view->orders['aid']);
                $prices = getPrices($this->view->archive['attr2']);
                $this->view->archive['attr2'] = $prices['price'];
                $where = array();
                $payfilename = $where['pay_code'] = $this->view->paytype;
                $this->view->pay = pay::getInstance()->getrows($where);
                $where = array();
                $where['id'] = $logisticsid;
                $this->view->logistics = logistics::getInstance()->getrows($where);
                if ($this->view->logistics[0]['cashondelivery']) {
                    $this->view->logistics[0]['price'] = 0.00;
                } else {
                    if ($this->view->logistics[0]['insure']) {
                        $this->view->logistics[0]['price'] = $this->view->logistics[0]['price'] + ($this->view->archive['attr2'] * $this->view->orders['pnums']) * ($this->view->logistics[0]['insureproportion'] / 100);
                    }
                }
                if (!isset($this->view->logistics[0]['price']))
                    $this->view->logistics[0]['price'] = 0;
                $this->view->pay[0]['pay_fee'] = $this->view->pay[0]['pay_fee'] / 100;
                $this->view->total = $this->view->archive['attr2'] * $this->view->orders['pnums'] + $this->view->logistics[0]['price'] + ($this->view->archive['attr2'] * $this->view->orders['pnums'] * $this->view->pay[0]['pay_fee']);
                $order['ordersn'] = front::get('oid');
                $order['title'] = $this->view->archive['title'];
                $order['id'] = $this->view->orders['id'];
                $order['orderamount'] = $this->view->total;
                $order['talename'] ='orders';
                include_once ROOT . '/lib/plugins/pay/' . $payfilename . '.php';
                $payclassname = $payfilename;
                $payobj = new $payclassname();

                $this->view->gotopaygateway = $payobj->get_code($order, unserialize_config($this->view->pay[0]['pay_config']));*/
            }
        }
        $this->render('pay/payorders.html');
        exit;
    }

    function confirmationorders_action(){
        $oid = front::get('oid');
        $update = orders::getInstance()->rec_update(array('status'=>'3'),array('oid'=>$oid));
        if ($update > 0) {
            front::flash(lang('order').$oid.lang('confirmation_of_receipt').lang('success'));
        }
        front::redirect(url('manage/orderslist/manage/orders/type/all'));
    }

    function doorders_action()
    {
        $aid = intval(front::get('aid'));
        if (archive::getInstance()->getrow($aid)) {
            $oreders_c = cookie::get('ce_orders_cookie');
            $oreders_c = base64_decode($oreders_c);
            $oreders_c = xxtea_decrypt($oreders_c, config::getadmin('cookie_password'));
            $oreders_c = stripslashes(htmlspecialchars_decode($oreders_c));

            //var_dump($orders_c);
            if (empty($oreders_c)) {
                $c_aid = '0' . front::get('aid');
                $orders_c = array($c_aid => array('aid' => $aid, 'amount' => (int)($_GET['thisnum']),'datatype' => $_GET['datatype']));
                $orders_c = serialize($orders_c);
                //var_dump($orders_c);
            } else {
                $orderid =unserialize($oreders_c);
                if (count($orderid) >= 12) {
                    echo 'limit';
                    exit;
                }
                $newc_aid="";
                $newctype=false;

                for($i=0;$i<count($orderid);$i++){
                    if($i == 0){
                        $c_aid= '0' . front::get('aid');
                    }else{
                        $c_aid=(string)($i).front::get('aid');
                    }
                    if (is_array($orderid) && array_key_exists($c_aid, $orderid) && trim($orderid[$c_aid]['datatype'])==trim($_GET['datatype'])) {
                        $newctype=true;
                        $newc_aid=$c_aid;
                    }

                }

                if ($newctype) {
                    $amount = $orderid[$newc_aid]['amount'] + (int)($_GET['thisnum']);
                    unset($orderid[$newc_aid]);
                    $orderid[$newc_aid] = array('aid' => $aid, 'amount' => (int)($amount),'datatype' => $_GET['datatype']);
                    $orders_c = serialize($orderid);

                } else{
                    $newc_aid=count($orderid).front::get('aid');
                    $orderid[$newc_aid]=array('aid' => $aid, 'amount' => (int)($_GET['thisnum']),'datatype' =>$_GET['datatype']);
                    $orders_c = serialize($orderid);
                }
            }
            //echo '<script type="text/javascript">alert('.$orders_c.');</script>>';
            //echo $orders_c."<br/>";
            $orders_c = xxtea_encrypt($orders_c, config::getadmin('cookie_password'));
            //var_dump(config::getadmin('cookie_password'));
            $orders_c = base64_encode($orders_c);
            //var_dump($orders_c);
            cookie::set('ce_orders_cookie', $orders_c);
            if(isset($_GET['buy'])){
                if($_GET['buy']){
                    echo '<script type="text/javascript">';
                    echo 'window.location.href="' . url('archive/orders',true) . '";';
                    echo '</script>';
                    exit;
                }
            }
            echo  lang('add_to_cart');
            exit;
            //echo '<script type="text/javascript">alert("' . lang('完成操作，你可以继续购物，或者在购物车中结算！') . '");window.location.href="'.url('archive/show/aid/' . front::get('aid'), true).'";</script>';
        }
    }

    //退款申请
    function refund_action(){
            if(front::$post['refund_oid']!=""){
                $orders=orders::getInstance();
                $orders->rec_update(array("refund_user"=>front::$post['refund_user'],"status"=>"6","refund_type"=>front::$post['refund_type'],"refund_connent"=>front::$post['refund_connent']),array("oid"=>front::$post['refund_oid']));
                echo json_encode(array("static"=>1,"retdata"=>lang('successful_application')));
                exit;
            }
        echo  json_encode(array("static"=>0,"retdata"=>lang('application_failure')));
        exit;


    }

    //清空购物车
    function emptyorders_action(){
        if (front::get('delete')){
            $oreders_c = cookie::get('ce_orders_cookie');
            $oreders_c = base64_decode($oreders_c);
            $oreders_c = xxtea_decrypt($oreders_c, config::getadmin('cookie_password'));
            $oreders_c = stripslashes(htmlspecialchars_decode($oreders_c));
            $aid = !empty($oreders_c) ? unserialize($oreders_c) : 0;
            if ($aid) {
                if($aid[front::get('key')]['aid']==front::get('aid')){

                    unset($aid[front::get('key')]);
                }
                $orders_c = serialize($aid);
                $orders_c = xxtea_encrypt($orders_c, config::getadmin('cookie_password'));
                $orders_c = base64_encode($orders_c);
                cookie::set('ce_orders_cookie', $orders_c);
                exit;
            }
        }else{
            cookie::set('ce_orders_cookie', '');
            echo "<script>history.go(-1);</script>";
        }
        exit;
    }

    function orders_action()
    {

        $this->view->aid = trim(front::get('aid'));

        if (config::getadmin('memberbuy') && !front::$user['userid']) {
            alertinfo(lang('not_logged'), url('user/login'));
            return;
        }

        //var_dump($this->view->user);
        if (front::post('submit')) {
            //var_dump($this->view->user);exit;
            $this->orders = new orders();
            $row = $this->orders->getrow("", "adddate DESC");
            //var_dump(time());
            //下单间隔
            if ($row['adddate'] && time() - $row['adddate'] <= intval(config::getadmin('order_time'))) {
                alerterror(lang('frequent_operation_please_wait'));
                return;
            }
            //联系电话必填
            if (front::$post['telphone'] == '') {
                alerterror(lang('telephone_is_required'));
                return;
            }
            //手机验证码
            if (config::getadmin('mobilechk_enable') && config::getadmin('mobilechk_buy')) {
                $mobilenum = front::$post['mobilenum'];
                $smsCode = new SmsCode();
                if (!$smsCode->chkcode($mobilenum)) {
                    alerterror(lang('cell_phone_parity_error'));
                    return false;
                }
            }

            front::$post['mid'] = $this->view->user['userid'] ? $this->view->user['userid'] : 0;

            front::$post['adddate'] = time();
            front::$post['ip'] = front::ip();
            $moeny=0;   //支付总金额
            $discount=usergroup::getusergrop(user::getuserid()); //获取用户组的折扣
            $isint =usergroup::getisint(user::getuserid());      //获取是否取整
            $finalkey='';  //伟哥需要
            if (isset(front::$post['aid']) && front::$post['aid']!='') {
                $aidarr = front::$post['aid'];
                unset(front::$post['aid']);
                foreach ($aidarr as $val) {
                    $aid=substr($val,1,strlen($val));
                    //重新编辑aid  取出key
                    $source = explode("#",trim($aid));
                    $aid=$source[0].'#';
                    $source = explode(".",trim($source[1]));
                    $newaid='';
                    for($index=0;$index<count($source);$index++){
                        //获取到key
                        $sourcedata = explode(":",trim($source[$index]));
                        $sourcekeyval = explode(",",trim($sourcedata[0]));
                        $sourcename = $sourcekeyval[0];  //字段名称
                        $sourcekey  = $sourcekeyval[1];  //字段key
                        if($sourcename != ''){
                            if(strpos($finalkey,$sourcename . ':' . $sourcekey) === false) {
                                if ($finalkey == '') {
                                    $finalkey = $sourcename . ':' . $sourcekey;   //伟哥需要
                                } else {
                                    $finalkey = $finalkey . ',' . $sourcename . ':' . $sourcekey;   //伟哥需要
                                }
                            }

                            //恢复aid
                            if($index==0){
                                $newaid.=$sourcename.':'.$sourcedata[1];
                            }else{
                                $newaid.='.'.$sourcename.':'.$sourcedata[1];
                            }
                        }
                    }
                    $aid.=$newaid;

                    if(front::$post['aid']==""){
                        front::$post['aid'] .= $aid;
                    }else{
                        front::$post['aid'] .= '-'.$aid;
                    }
                    $source = explode("#",trim($aid));
                    $_aidArrys = explode(",", trim($source[0]));
                    $datavuel = archive::getInstance()->getrows('aid in ('.$_aidArrys[0].')',100);

                    if($datavuel[0]['inventory'] >0){              //库存减1
                        $inventorynum=$datavuel[0]['inventory']-(int)($_aidArrys[1]);
                    }else{
                        $inventorynum=0;
                    }
                    //修改库存
                    archive::getInstance()->rec_update(array('inventory'=>$inventorynum), $_aidArrys[0]);

                    $datavuel[0]['attr2']=(floatval($datavuel[0]['attr2'])*$discount/10);   //单价打折
                    if($isint){                                  //判断取整
                        $datavuel[0]['attr2']=round($datavuel[0]['attr2']);
                    }
                    $source = explode(".",trim($source[1]));
                    for($index=0;$index<count($source);$index++){
                        $sourceArry = explode(":",trim($source[$index]));
                        $sourceArry = explode(",",trim($sourceArry[1]));
                        if($sourceArry[1]=="jia"){
                            $datavuel[0]['attr2']=floatval($datavuel[0]['attr2'])+floatval($sourceArry[2]);
                        }else if($sourceArry[1]=="jian"){
                            $datavuel[0]['attr2']=floatval($datavuel[0]['attr2'])-floatval($sourceArry[2]);
                        }else if($sourceArry[1]=="chen"){
                            $datavuel[0]['attr2']=floatval($datavuel[0]['attr2'])*floatval($sourceArry[2]);
                        }else if($sourceArry[1]=="chu"){
                            $datavuel[0]['attr2']=floatval($datavuel[0]['attr2'])/floatval($sourceArry[2]);
                        }
                    }
                    $moeny=$moeny+(floatval($datavuel[0]['attr2'])*floatval($_aidArrys[1]));
                    front::$post['pnums'] .= abs(intval(front::$post['thisnum'][$val])) . ',';
                }
            } else {
                front::$post['aid'] = $this->view->aid;
            }
            if (!isset(front::$post['logisticsid']))
                front::$post['logisticsid'] = 0;
            $payname = front::$post['payname'] ? front::$post['payname'] : 'none';
            front::$post['oid'] = date('YmdHis') . '-' . front::$post['logisticsid'] . '-' . front::$post['mid'] . '-' . $payname;
            unset(front::$post['status']);
            front::$post['status'] = 0;
            front::$post['courier_number'] = '';
            front::$post['s_status'] = 0;
            front::$post['trade_no'] = '';
            //获取运费
            $where = array();
            $where['id'] = front::$post['logisticsid'];
            $this->view->logistics = logistics::getInstance()->getrows($where);
            front::$post['menoy'] = $moeny+$this->view->logistics[0]['price'];
            front::$post['finalkey']=$finalkey;
            $insert = $this->orders->rec_insert(front::$post);
            if ($insert < 1) {
                front::flash($this->tname . lang('add_failure'));
            }
            else {
                cookie::set('ce_orders_cookie', '');
                //优惠劵使用
                if(isset(front::$post['somecoupon']) && front::$post['somecoupon'] != '' ){
                    if(strpos(trim(front::$post['somecoupon']),',') !== false) {
                        $source = explode(",", trim(front::$post['somecoupon']));
                        for ($index = 0; $index < count($source); $index++) {
                            user::setcouponidnum($source[$index], 1, '-');   //优惠劵变更
                            $coupondata=coupon::getcouponid( $source[$index]);; //优惠劵信息获取
                            $moeny=(float)($moeny)-(float)($coupondata['moeny']);
                        }
                    }
                    else{
                        user::setcouponidnum(front::$post['somecoupon'], 1, '-');   //优惠劵变更
                        $coupondata=coupon::getcouponid(front::$post['somecoupon']);; //优惠劵信息获取
                        $moeny=(float)($moeny)-(float)($coupondata['moeny']);
                    }
                }
                user::setintegration($moeny);   //积分增加

                if (config::getadmin('sms_on') && config::getadmin('sms_order_on')) {
                    $smsCode = new SmsCode();
                    $content = $smsCode->getTemplate('order', array($this->view->user['usernam'], front::$post['oid']));
                    sendMsg(front::$post['telphone'], $content);
                }
                if (config::getadmin('sms_on') && config::getadmin('sms_order_admin_on') && $mobile = config::getadmin('site_mobile')) {
                    sendMsg($mobile, lang('web_ site') . date('Y-m-d H:i:s') . lang('ordersnotalreadydo'));
                    //echo 11;
                }

                //$user = $this->view->user;
                if (config::getadmin('email_order_send_cust') && front::$post['postcode']) {
                    $title = lang('you_in') . config::getadmin('sitename') . lang('the_order') . front::get('oid') . lang('has_been_submitted');
                    $this->sendmail(front::$post['postcode'], $title, $title);
                }
                if (config::getadmin('email_order_send_admin') && config::getadmin('email')) {
                    $title = lang('web_ site') . date('Y-m-d H:i:s') . lang('ordersnotalreadydo');
                    $this->sendmail(config::getadmin('email'), $title, $title);
                }
                if (front::$post['payname'] && front::$post['payname'] != 'nopay') {

                    echo '<script type="text/javascript">alert("' . lang('orderssuccess') . ' ' . lang('now_turn_to_pay_page') . '");window.location.href="' . url('archive/payorders/oid/' . front::$post['oid'], true) . '";</script>';
                    exit;
                }
                echo '<script type="text/javascript">alert("' . lang('orderssuccess') . '");window.location.href="' . url('archive/orders/oid/' . front::$post['oid'], true) . '";</script>';
                exit;
            }
        }
        elseif
        (front::get('oid')) {
            preg_match_all("/-(.*)-(.*)-(.*)/isu", front::get('oid'), $oidout);
            $this->view->paytype = $oidout[3][0];
            //非会员不可查看
            if ($oidout[2][0] != $this->view->user['userid']) {
                alertinfo(lang('view_order_failure'), url::create('index/index'));
            }

            $where = array();
            $where['oid'] = front::get('oid');
            $this->view->orders = orders::getInstance()->getrow($where);
            $this->view->orders['status2'] = $this->view->orders['status'];
            $this->view->statusnum = $data['status'] = $this->view->orders['status'];
            $unpay = false;
            switch ($data['status']) {
                case 1:
                    $data['status'] = lang('complete');
                    break;
                case 2:
                    $data['status'] = lang('processing');
                    break;
                case 3:
                    $data['status'] = lang('shipped');
                    break;
                case 4:
                    $data['status'] = lang('pending_audit_payment');
                    break;
                case 5:
                    $data['status'] = lang('check_payment');
                    break;
                default:
                    $data['status'] = lang('ordersnotalreadydo');
                    $unpay = true;
                    break;
            }
            $this->view->orders['status'] = $data['status'];
            /*if ($this->view->paytype) {
                $this->view->gotopaygateway = '<a href="' . url('archive/payorders/oid/' . front::get('oid'), true) . '">进入支付页面</a>';
            }*/

            //获取支付链接
            if ($unpay && $this->view->paytype && $this->view->paytype != 'nopay' && $this->view->paytype != 'none') {

                $logisticsid = $oidout[1][0];
                $aid='aid in (17,18)';
                $this->view->archive = archive::getInstance()->getrow($aid);
                $prices = getPrices($this->view->archive['attr2']);
                $this->view->archive['attr2'] = $prices['price'];
                $where = array();
                $payfilename = $where['pay_code'] = $this->view->paytype;
                $this->view->pay = pay::getInstance()->getrows($where);
                $where = array();
                $where['id'] = $logisticsid;
                $this->view->logistics = logistics::getInstance()->getrows($where);
                if ($this->view->logistics[0]['cashondelivery']) {
                    $this->view->logistics[0]['price'] = 0.00;
                } else {
                    if ($this->view->logistics[0]['insure']) {
                        $this->view->logistics[0]['price'] = $this->view->logistics[0]['price'] + ($this->view->archive['attr2'] * $this->view->orders['pnums']) * ($this->view->logistics[0]['insureproportion'] / 100);
                    }
                }
                if (!isset($this->view->logistics[0]['price'])) {
                    $this->view->logistics[0]['price'] = 0;
                }
                $this->view->pay[0]['pay_fee'] = $this->view->pay[0]['pay_fee'] / 100;
                $this->view->total = $this->view->archive['attr2'] * $this->view->orders['pnums'] + $this->view->logistics[0]['price'] + ($this->view->archive['attr2'] * $this->view->orders['pnums'] * $this->view->pay[0]['pay_fee']);
                $order['ordersn'] = front::get('oid');
                $order['title'] = $this->view->archive['title'];
                $order['id'] = $this->view->orders['id'];
                $order['orderamount'] = $this->view->total;
                $order['talename'] ='orders';
                include_once ROOT . '/lib/plugins/pay/' . $payfilename . '.php';
                $payclassname = $payfilename;
                $payobj = new $payclassname();
                $this->view->gotopaygateway = $payobj->get_code($order, unserialize_config($this->view->pay[0]['pay_config']));
            }

            //var_dump($this->view->user);var_dump($_SESSION);exit();

            $this->out('message/orderssuccess.html');
        }
        elseif
        (intval(front::get('aid'))) {
            front::check_type(front::get('aid'));
            $aid = intval(front::get('aid'));
            $this->view->archive = archive::getInstance()->getrow($aid);
            $this->view->categorys = category::getpositionlink2($this->view->archive['catid']);
            $this->view->paylist = pay::getInstance()->getrows('', 50);
            $this->view->logisticslist = logistics::getInstance()->getrows('', 50);
            $prices = getPrices($this->view->archive['attr2']);
            $this->view->archive['attr2'] = $prices['price'];
            if (!is_array($this->view->archive))
                $this->out('message/error.html');
            if ($this->view->archive['checked'] < 1)
                exit(lang('unaudited'));
            if (!rank::arcget($aid, $this->view->usergroupid)) {
                $this->out('message/error.html');
            }
        }
        else
            {
            //直接跳到结算
            if(front::get('settlement')){
                $this->view->settlement =front::get('settlement');
            }
            $oreders_c = cookie::get('ce_orders_cookie');
            $oreders_c = base64_decode($oreders_c);
            $oreders_c = xxtea_decrypt($oreders_c, config::getadmin('cookie_password'));
            //var_dump($oreders_c);
            if (preg_match('/(union|select|update|delete)/i', $oreders_c)) {
                alerterror(lang('illegal_character'));
            }
            $oreders_c = stripslashes(htmlspecialchars_decode($oreders_c));
            $aid = !empty($oreders_c) ? unserialize($oreders_c) : 0;
           /* echo print_r($aid);*/
            if ($aid) {
                foreach ($aid as $key => $val) {
                    $archive = archive::getInstance()->getrow(intval($val['aid']));
                    $val['title'] = $archive['title'];
                    $prices = getPrices($archive['attr2']);
                    $val['attr2'] = $prices['price'];
                    $val['thumb'] = $archive['thumb'];
                    $val['url'] = $archive['url'];
                    $val['inventory'] = $archive['inventory'];
                    $val['name'] = $key;
                    $val['catid'] = $archive['catid'];
                    $aid[$key] = $val;
                }
                $this->view->orderaidlist = $aid;
                $this->view->paylist = pay::getInstance()->getrows(' langid='.lang::getlangid(lang::getistemplate()), 50);
                $this->view->logisticslist = logistics::getInstance()->getrows('', 50);
            } else {
                if (isset(front::$get['oid'])) {
                    if ($_SERVER['HTTP_REFERER']) {
                        front::refresh($_SERVER['HTTP_REFERER']);
                    } else {
                        front::refresh(url('index'));
                    }
                    exit;
                }
                $this->view->orderaidlist ="";
               /* echo '<script type="text/javascript">alert("' . lang('the commodity shopping cart') . '");';
                if ($_SERVER['HTTP_REFERER']) {
                    echo 'window.location.href="' . $_SERVER['HTTP_REFERER'] . '";';
                } else {
                    echo 'window.location.href="' . url('index') . '";';
                }
                echo '</script>';*/
            }
        }
        $this->render('pay/orders.html');
        exit;
    }

    //获取购物车
    function getorders_action(){
        $oreders_c = cookie::get('ce_orders_cookie');
        $oreders_c = base64_decode($oreders_c);
        $oreders_c = xxtea_decrypt($oreders_c, config::getadmin('cookie_password'));
        //var_dump($oreders_c);
        if (preg_match('/(union|select|update|delete)/i', $oreders_c)) {
            alerterror(lang('illegal_character'));
        }
        $oreders_c = stripslashes(htmlspecialchars_decode($oreders_c));
        $aid = !empty($oreders_c) ? unserialize($oreders_c) : 0;
        $archivedata=array();
        foreach ($aid as $key => $val) {
            $archive = archive::getInstance()->getrow(intval($val['aid']));
            $val['title'] = $archive['title'];
            $prices = getPrices($archive['attr2']);
            $val['attr2'] = $prices['price'];
            $val['thumb'] = $archive['thumb'];
            $val['url'] = $archive['url'];
            $val['inventory'] = $archive['inventory'];
            $val['name'] = $key;
            $val['catid'] = $archive['catid'];
            $aid[$key] = $val;
        }
        echo json_encode($aid);
        exit;
    }

    //取消订单
    function droporders_action(){
        $xfconsumption = new orders();
        //获取到购买的商品  进行计算销售量
        $tabledata = $xfconsumption->getrows("oid='".front::get('oid')."'", 1); //查询订单表
        if(is_array($tabledata)){
            //获取到购买的商品  进行计算库存
            $ordersAid = explode("-",trim($tabledata[0]['aid']));
            //循环多个商品
            for($index=0;$index<count($ordersAid);$index++){
                $source = explode("#",trim($ordersAid[$index]));
                $_aidArrys = explode(",", trim($source[0]));
                $datavuel = archive::getInstance()->getrows('aid = '.$_aidArrys[0],1);
                //库存还原
                $inventorynum=$datavuel[0]['inventory']+(int)($_aidArrys[1]);
                //修改库存
                archive::getInstance()->rec_update(array('inventory'=>$inventorynum), $_aidArrys[0]);
            }
        }
        $delete = $xfconsumption->rec_delete("oid='".front::get('oid')."'");
        if($delete>0){
            echo '<script type="text/javascript">alert("'.lang('cancellation_of_order').lang('success').'！");window.location.href="' . url('manage/orderslist/manage/orders', true) . '";</script>';
        }else{
            echo '<script type="text/javascript">alert("'.lang('cancellation_of_order').lang('failure').'！");window.location.href="' . url('manage/orderslist/manage/orders', true) . '";</script>';
        }
          exit;
    }

    //获取cookie里面的购买数量
    function getshoppinginventory_action(){
        $oreders_c = cookie::get('ce_orders_cookie');
        $oreders_c = base64_decode($oreders_c);
        $oreders_c = xxtea_decrypt($oreders_c, config::getadmin('cookie_password'));
        //var_dump($oreders_c);
        if (preg_match('/(union|select|update|delete)/i', $oreders_c)) {
            alerterror(lang('illegal_character'));
        }
        $oreders_c = stripslashes(htmlspecialchars_decode($oreders_c));
        $aid = !empty($oreders_c) ? unserialize($oreders_c) : 0;
        if($aid){
            $shoppinginventory=0;
            foreach ($aid as $key => $val) {
                if($val['aid']==front::get('aid')){
                    $shoppinginventory=$shoppinginventory+(int)($val['amount']);
                }
            }
            echo $shoppinginventory;
        }else{
            echo 0;
        }
        exit;
    }

    function consumption_action()
    {
        //校验是否登陆
        if ( !front::$user['userid']) {
            alertinfo(lang('not_logged'), url('user/login'));
            return;
        }

        if (front::post('submit')) {
            $this->consumption = new consumption();
            front::$post['adddate'] =  date('Y-m-d h:i:s', time());
            front::$post['mid'] = $this->view->user['userid'] ? $this->view->user['userid'] : 0;
            $payname = front::$post['payname'] ? front::$post['payname'] : 'none';
            front::$post['oid'] = date('YmdHis') . '-' . front::$post['mid'] . '-' . $payname;
            unset(front::$post['status']);
            front::$post['status'] = 0;
            front::$post['s_status'] = 0;
            $insert = $this->consumption->rec_insert(front::$post);
            if($insert>0){
                echo '<script type="text/javascript">alert("' . lang('orderssuccess') . ' ' . lang('now_turn_to_pay_page') . '");window.location.href="' . url('archive/payconsumption/oid/' . front::$post['oid'], true) . '";</script>';
                exit;
            }
        }
        elseif  (front::get('oid')) {
            preg_match_all("/-(.*)-(.*)/isu", front::get('oid'), $oidout);
            $this->view->paytype = $oidout[2][0];
            //非会员不可查看
            if ($oidout[1][0] != $this->view->user['userid']) {
                alertinfo(lang('view_order_failure'), url::create('index/index'));
            }

            $where = array();
            $where['oid'] = front::get('oid');
            $this->view->consumption = consumption::getInstance()->getrow($where);
            $this->view->statusnum = $data['status'] = $this->view->consumption['status'];
            $unpay = false;
            switch ($data['status']) {
                case 1:
                    $data['status'] = lang('complete');
                    break;
                case 2:
                    $data['status'] = lang('processing');
                    break;
                case 3:
                    $data['status'] = lang('shipped');
                    break;
                case 4:
                    $data['status'] = lang('pending_audit_payment');
                    break;
                case 5:
                    $data['status'] = lang('check_payment');
                    break;
                default:
                    $data['status'] = lang('ordersnotalreadydo');
                    $unpay = true;
                    break;
            }
            $this->view->consumption['status'] = $data['status'];

            //获取支付链接
            if ($unpay && $this->view->paytype && $this->view->paytype != 'nopay' && $this->view->paytype != 'none') {

                $where = array();
                $where['oid'] = front::get('oid');
                $this->view->consumption = consumption::getInstance()->getrow($where);

                $where = array();
                $payfilename = $where['pay_code'] = $this->view->paytype;
                $this->view->pay = pay::getInstance()->getrows($where);
                $this->view->pay[0]['pay_fee'] = $this->view->pay[0]['pay_fee'] / 100;
                $this->view->total = $this->view->consumption['menoy']  + ($this->view->archive['menoy']  * $this->view->pay[0]['pay_fee']);
                $consumption['ordersn'] = front::get('oid');
                $consumption['title'] = lang('recharge_amount');
                $consumption['id'] = $this->view->consumption['id'];
                $consumption['orderamount'] = $this->view->total;
                $consumption['talename'] ='consumption';
                include_once ROOT . '/lib/plugins/pay/' . $payfilename . '.php';
                $payclassname = $payfilename;
                $payobj = new $payclassname();
                $this->view->gotopaygateway = $payobj->get_code($consumption, unserialize_config($this->view->pay[0]['pay_config']));
            }

            //var_dump($this->view->user);var_dump($_SESSION);exit();

            $this->out('message/consumptionsuccess.html');
        }
        else{
            $this->view->paylist = pay::getInstance()->getrows('', 50);
        }
        $this->render('consumption/consumption.html');
        exit;
    }

    function expresslist_action()
    {
        //校验是否登陆
        if ( !front::$user['userid']) {
            alertinfo(lang('not_logged'), url('user/login'));
            return;
        }
        if(front::get('expressid') !='' && front::get('expresstype')!='') {
            $this->_table  =new orders();
            $this->_table->querexpress(front::get('expressid'),front::get('expresstype'),$this->view);
        }
        $this->render('express/expresslist.html');
        exit;
    }

    function payconsumption_action()
    {
        if (front::get('oid')) {
            preg_match_all("/-(.*)-(.*)/isu", front::get('oid'), $oidout);
            $this->view->paytype = $oidout[2][0];
            if($this->view->paytype=='none'){
                echo '<script type="text/javascript">alert("'.lang('no_payment_contact_administrator').'");window.opener=null;window.close();</script>';
                exit;
            }
            $this->view->user_id = $oidout[1][0];
            $where = array();
            $where['oid'] = front::get('oid');
            $this->view->consumption = consumption::getInstance()->getrow($where);
            $this->view->statusnum = $data['status'] = $this->view->consumption['status'];
            switch ($data['status']) {
                case 1:
                    $this->view->orders['status'] = lang('complete');
                    break;
                case 2:
                    $this->view->orders['status'] = lang('processing');
                    break;
                case 3:
                    $this->view->orders['status'] = lang('shipped');
                    break;
                case 4:
                    $this->view->orders['status'] = lang('pending_audit_payment');
                    break;
                case 5:
                    $this->view->orders['status'] = lang('check_payment');
                    break;
                default:
                    $this->view->orders['status'] = lang('ordersnotalreadydo');
                    break;
            }

            if (!$this->view->user['userid']) {
                echo '<script type="text/javascript">alert("' . lang('not_logged_save_the_order_number') .$oidout[1][0].'-'.$oidout[2][0]. '")</script>';
            }

            $where = array();
            $payfilename = $where['pay_code'] = $this->view->paytype;
            $this->view->pay = pay::getInstance()->getrows($where);
            $this->view->consumption['title']= lang('recharge_amount');
            $this->view->consumption['total']= $this->view->consumption['menoy']+( $this->view->consumption['menoy']* $this->view->pay[0]['pay_fee']);

            $this->view->pay[0]['pay_fee'] = $this->view->pay[0]['pay_fee'] / 100;
            $this->view->total = $this->view->consumption['menoy'] + ($this->view->consumption['menoy']  * $this->view->pay[0]['pay_fee']);
            $consumption['ordersn'] = front::get('oid');
            $consumption['title'] = lang('recharge_amount');
            $consumption['id'] = $this->view->consumption['id'];
            $consumption['orderamount'] = $this->view->total;
            $consumption['talename'] ='consumption';

            include_once ROOT . '/lib/plugins/pay/' . $payfilename . '.php';
            $payclassname = $payfilename;
            $payobj = new $payclassname();

            $this->view->gotopaygateway = $payobj->get_code($consumption, unserialize_config($this->view->pay[0]['pay_config']));
        }
        $this->render('consumption/payconsumption.html');
        exit;
    }

    function payappsconsumption_action()
    {
        if (front::get('oid')) {
            preg_match_all("/-(.*)-(.*)/isu", front::get('oid'), $oidout);
            $this->view->paytype = $oidout[2][0];
            if($this->view->paytype=='none'){
                echo '<script type="text/javascript">alert("'.lang('no_payment_contact_administrator').'");window.opener=null;window.close();</script>';
                exit;
            }
            $this->view->user_id = $oidout[1][0];
            $where = array();
            $where['oid'] = front::get('oid');
            $this->view->consumption = consumption::getInstance()->getrow($where);
            $this->view->statusnum = $data['status'] = $this->view->consumption['status'];
            switch ($data['status']) {
                case 1:
                    $this->view->orders['status'] = lang('complete');
                    break;
                case 2:
                    $this->view->orders['status'] = lang('processing');
                    break;
                case 3:
                    $this->view->orders['status'] = lang('shipped');
                    break;
                case 4:
                    $this->view->orders['status'] = lang('pending_audit_payment');
                    break;
                case 5:
                    $this->view->orders['status'] = lang('check_payment');
                    break;
                default:
                    $this->view->orders['status'] = lang('ordersnotalreadydo');
                    break;
            }

            $where = array();
            $payfilename = $where['pay_code'] = $this->view->paytype;
            $this->view->pay = pay::getInstance()->getrows($where);
            $this->view->consumption['title']= lang('recharge_amount');
            $this->view->consumption['total']= $this->view->consumption['menoy']+( $this->view->consumption['menoy']* $this->view->pay[0]['pay_fee']);

            $this->view->pay[0]['pay_fee'] = $this->view->pay[0]['pay_fee'] / 100;
            $this->view->total = $this->view->consumption['menoy'] + ($this->view->consumption['menoy']  * $this->view->pay[0]['pay_fee']);
            $consumption['ordersn'] = front::get('oid');
            $consumption['title'] = lang('recharge_amount');
            $consumption['id'] = $this->view->consumption['id'];
            $consumption['orderamount'] = $this->view->total;
            $consumption['talename'] ='consumption';

            include_once ROOT . '/lib/plugins/pay/' . $payfilename . '.php';
            $payclassname = $payfilename;
            $payobj = new $payclassname();

            $this->view->gotopaygateway = $payobj->get_code($consumption, unserialize_config($this->view->pay[0]['pay_config']));
        }
        $this->render('consumption/payconsumption.html');
        exit;
    }

    function chkconsumption_action()
    {
        $oid = front::get('oid');
        $row = consumption::getInstance()->getrow(array('oid'=>$oid));
        echo $row['status'];
        exit;
    }

    //id查询商品
    function getcouponid_action(){
        if(front::get('couponid') && front::get('couponid')!=''){
            $coupon=coupon::getcouponid(front::get('couponid'));
            echo  json_encode($coupon);
        }
        exit;

    }

    //增删收藏
    function setcollect_action(){
        if(front::get('couponid') && front::get('couponid')!=''){
            $messagelist=user::setcollect(front::get('couponid'));
            echo  json_encode($messagelist);
        }
        exit;

    }

    //增删点赞
    function setpraise_action(){
        if(front::get('aid') && front::get('aid')!=''){
            $messagelist=archive::setpraise(front::get('aid'));
            echo  json_encode($messagelist);
        }
        exit;

    }

    public function delbuycar_action()
    {
        $id = intval($_POST['aid']);
        $oreders_c = cookie::get('ce_orders_cookie');
        $oreders_c = base64_decode($oreders_c);
        $oreders_c = xxtea_decrypt($oreders_c, config::getadmin('cookie_password'));
        if (preg_match('/(union|select|update|delete)/i', $oreders_c)) {
            alerterror(lang('illegal_character'));
        }
        $oreders_c = stripslashes(htmlspecialchars_decode($oreders_c));
        $aid = !empty($oreders_c) ? unserialize($oreders_c) : 0;
        if ($aid) {
            foreach ($aid as $key => $val) {
                if ($val['aid'] == $id) {
                    unset($aid[$key]);
                }
            }
            cookie::set('ce_orders_cookie', xxtea_encrypt(serialize($aid), config::getadmin('cookie_password')));
        }
        echo 'ok';
        exit;

    }

    private function sendmail($smtpemailto, $title, $mailbody)
    {
        include_once(ROOT . '/lib/plugins/smtp.php');
        $mailsubject = mb_convert_encoding($title, 'GB2312', 'UTF-8');
        $mailtype = "HTML";
        $smtp = new include_smtp(config::getadmin('smtp_mail_host'), config::getadmin('smtp_mail_port'), config::getadmin('smtp_mail_auth'), config::getadmin('smtp_mail_username'), config::getadmin('smtp_mail_password'));
        $smtp->debug = false;
        $smtp->sendmail($smtpemailto, config::getadmin('smtp_user_add'), $mailsubject, $mailbody, $mailtype);
    }

    //地图
    function sitemap_action(){

        $tpl='sitemap/index.php';
        $tpltemplate='sitemap/index_'.lang::getisadmin().'.html';
        //优先访问静态
        if(file_exists($tpltemplate))
        {
            echo '<script>window.location.href ="/'.$tpltemplate.'";</script>';
            exit;
        }
        $this->render($tpl);
        exit;
    }


    function out($tpl)
    {

        if (front::$debug)
            return;
        $this->render($tpl);
        $this->out = true;
        exit;
    }

    function end()
    {
        if (isset($this->out))
            return;
        if ($this->auto_end) {
            if (front::$debug)
                $this->render('style/index.html');
            else
                $this->render();
        }
    }

}