<?php

if (!defined('ROOT'))
    exit('Can\'t Access !');
class template_admin extends admin
{
    function init()
    {
        $this->check_pw();
    }

    function visual_action()
    {
        chkpw('template_visual');
        $dir = config::get('template_dir');
        $tempname = front::$get['tempname'];
        if (!$tempname) $tempname = 'index-index';
       /* $tempname=$tempname.'_'.lang::getisadmin();*/
        if (session::get('ver') != 'corp' && $tempname != 'index-index') {
            alerterror(lang_admin('free_users_can_only_edit_the_home_page'));
        }
        if (!session::get('root')) {
            session::set('root', 'no');
        }
        if (front::$get['setroot']) {
            session::set('root', front::$get['setroot'] == 'yes' ? 'no' : 'yes');
        }
        $tempcontent = @file_get_contents(ROOT . '/data/template/' . $dir . '/' . str_replace('-', '/', $tempname) . '.html');
        //var_dump($file);
        $this->view->tempname = $tempname;
        $this->view->tempcontent = $tempcontent;
        $content = $this->view->adminfetch();
        echo($content);
        exit;
    }

    function getnav_action()
    {
        nav(front::$post['id']);
        exit;
    }

    function getTel_action()
    {
        $code = '<div class="column">' . "\r\n";
        if (front::$post['tel']) {
            $code .= '<p>' . lang('tel') . '：<span class="custtag tel" rel="config::get(\'tel\')">' . config::get('tel') . '</span></p>' . "\r\n";
        }
        if (front::$post['address']) {
            $code .= '<p>' . lang('address') . '：<span class="custtag address" rel="config::get(\'address\')">' . config::get('address') . '</span></p>' . "\r\n";
        }
        if (front::$post['postcode']) {
            $code .= '<p>' . lang('postcode') . '：<span class="custtag postcode" rel="config::get(\'postcode\')">' . config::get('postcode') . '</span></p>' . "\r\n";
        }
        if (front::$post['mobile']) {
            $code .= '<p>' . lang('mobile') . '：<span class="custtag mobile" rel="config::get(\'mobile\')">' . config::get('mobile') . '</span></p>' . "\r\n";
        }
        if (front::$post['fax']) {
            $code .= '<p>' . lang('fax') . '：<span class="custtag fax" rel="config::get(\'fax\')">' . config::get('fax') . '</span></p>' . "\r\n";
        }
        if (front::$post['email']) {
            $code .= '<p>' . lang('email') . '：<span class="custtag email" rel="config::get(\'email\')">' . config::get('email') . '</span></p>' . "\r\n";
        }
        if (front::$post['complaint_email']) {
            $code .= '<p>' . lang('complaint') . '' . lang('email') . '：<span class="custtag complaint_email" rel="config::get(\'complaint_email\')">' . config::get('complaint_email') . '</span></p>' . "\r\n";
        }
        $code .= '<div class="clearfix"></div>' . "\r\n";
        $code .= '</div>' . "\r\n";
        echo $code;
        exit;
    }

    function getlist_action()
    {
        $tpl = 'visual/list/listtag/' . front::$post['listtemplate'];
        echo $this->view->visualfetch($tpl);
        exit;
    }

    function gettypelist_action()
    {
        $tpl = 'visual/list/listtypetag/' . front::$post['listtemplate'];
        echo $this->view->visualfetch($tpl);
        exit;
    }

    function getspeciallist_action()
    {
        $tpl = 'visual/list/listspecialtag/' . front::$post['listtemplate'];
        echo $this->view->visualfetch($tpl);
        exit;
    }

    function getannounlist_action()
    {
        //var_dump(front::$post);
        $str = file_get_contents(ROOT . '/template/' . config::get('template_dir') . '/visual/list/listannountag/' . front::$post['annountemplate']);
        $str = preg_replace(
            array(
                '/<var id="num">\d*<\/var>/i',
                '/<var id="title_len">\d*<\/var>/i',
                '/<var id="is_date">\d*<\/var>/i',
            ),
            array(
                '<var id="num">' . front::$post['num'] . '</var>',
                '<var id="title_len">' . front::$post['title_len'] . '</var>',
                '<var id="is_date">' . front::$post['is_date'] . '</var>',
            ),
            $str
        );
        $str = preg_replace('/\{loop announ\((.*?),(.*?),(.*?)\) \$an\}/', '{loop announ(' . front::$post['num'] . ',' . front::$post['title_len'] . ',' . front::$post['is_date'] . ') \$an}', $str);
        //var_dump($str);
        $str = $this->view->compile($str);
        $str = $this->view->_eval($str);
        //var_dump($str);
        echo $str;
        exit;
    }

    function getfieldlist_action()
    {
        if (is_array(front::$post['fields']) && !empty(front::$post['fields'])) {
            $sets = setting::getInstance();
            $str = $str1 = $str2 = '';
            $fields = setting::$var['archive'];
            foreach (front::$post['fields'] as $field) {
                if (isset($fields[$field])) {
                    $str .= '<p><span>' . $fields[$field]['cname'] . " : " . '</span>' . '{$archive[\'' . $fields[$field]['name'] . '\']}</p>' . "\n";
                    $str1 .= '<p><span>' . $fields[$field]['cname'] . " : " . '</span>' . $fields[$field]['cname'] . '</p>';
                    $str2 .= $fields[$field]['name'] . ',';
                }
            }
            $code = "<div class=\"codearea\">\n";
            $code .= "<var class='selected'>" . substr($str2, 0, -1) . "</var>\n" . $str;
            $code .= "</div>\n";
            $code .= "<div class=\"viewarea\">\n" . $str1;
            $code .= "</div>\n";
            echo $code;
        } else {
            echo lang_admin('no_fields_selected');
        }
        //echo $str;
        exit;
    }

    function saveCache($dir, $name, $data)
    {
        $file = ROOT . '/data/template/' . $dir . '/' . str_replace('-', '/', $name) . '.html';
        if (!is_dir(dirname($file))) {
            tool::mkdir(dirname($file));
        }
        return file_put_contents($file, $data);
    }

    function saveTemp($dir, $name, $data)
    {
        $file = TEMPLATE . '/' . $dir . '/' . str_replace('-', '/', $name) . '.html';
        $arr = array('top', 'bottom');
        if (!in_array($name, $arr)) {
            $data = '{template \'header.html\'}' . $data;
            $data = $data . '{template \'footer.html\'}';
        }
        return file_put_contents($file, $data);
    }

    private function saveNote($type, $name, $notename, $note = '')
    {
        $key = str_replace('-', '/', $type) . $name . '_html';
        help::$_var['template_note'][$key . '_name'] = $notename;
        help::$_var['template_note'][$key . '_note'] = $note;
        help::save();
    }

    function newtemplate_action()
    {
        $dir = config::get('template_dir');
        $file = TEMPLATE . '/' . $dir . '/' . str_replace('-', '/', front::$post['type']) . front::$post['name'] . '.html';
        if (file_exists($file)) {
            echo json_encode(array('code' => '1', 'info' => lang_admin('template_file_already_exists')));
            exit;
        } else {
            file_put_contents($file, '');
            $this->saveNote(front::$post['type'], front::$post['name'], front::$post['notename']);
        }
        echo json_encode(array('code' => '0', 'info' => front::$post['type'] . front::$post['name']));
        //echo json_encode(array('code'=>'1','info'=>'模板文件已存在'));
        exit;
    }

    function copytemplate_action()
    {
        $dir = config::get('template_dir');
        $file = TEMPLATE . '/' . $dir . '/' . str_replace('-', '/', front::$post['type']) . front::$post['name'] . '.html';
        if (file_exists($file)) {
            echo json_encode(array('code' => '1', 'info' => lang_admin('template_file_already_exists')));
            exit;
        } else {
            file_put_contents($file, file_get_contents(ROOT . '/template/' . $dir . '/' . str_replace('-', '/', front::$post['oldname']) . '.html'));
            $this->saveNote(front::$post['type'], front::$post['name'], front::$post['notename']);
        }
        $data = file_get_contents(ROOT . '/data/template/' . $dir . '/' . str_replace('-', '/', front::$post['oldname']) . '.html');
        $str = file_put_contents(ROOT . '/data/template/' . $dir . '/' . str_replace('-', '/', front::$post['type']) . front::$post['name'] . '.html', $data);
        echo json_encode(array('code' => '0', 'info' => front::$post['type'] . front::$post['name']));
        exit;
    }

    function savetemp_action()
    {
        front::$post['content'] = stripslashes(htmlspecialchars_decode(htmlspecialchars_decode(front::$post['content'], ENT_QUOTES), ENT_QUOTES));
        front::$post['tempdata'] = stripslashes(htmlspecialchars_decode(htmlspecialchars_decode(front::$post['tempdata'], ENT_QUOTES), ENT_QUOTES));
        //var_dump(front::$post['tempdata']);
        $dir = config::get('template_dir');
        $cache = $this->saveCache($dir, front::$post['name'], front::$post['content']);
        $temp = $this->saveTemp($dir, front::$post['name'], front::$post['tempdata']);
        if (!$cache) {
            echo lang_admin('cache_write').lang_admin('failure');
            exit;
        }
        if (!$temp) {
            echo lang_admin('template_writing').lang_admin('failure');
            exit;
        }
        echo lang_admin('preservation').lang_admin('success');
        exit;
    }

    function gettag_action()
    {
        //var_dump(front::$post['tag']);
        //echo '111';
        preg_match('/^{tag_(.*?)}$/', front::$post['tag'], $out);

        //var_dump($out);
        if (isset($out[1]) && $out[1]) {
            $this->_table = new templatetag();
            $row = $this->_table->getrow("name='{$out[1]}'");
            //var_dump($row);
            echo json_encode($row);
        }
        exit;
    }

    function deltag_action()
    {
        preg_match('/^{tag_(.*?)}$/', front::$post['tag'], $out);
        //var_dump($out);
        if (isset($out[1]) && $out[1]) {
            $this->_table = new templatetag();
            $rs = $this->_table->rec_delete(templatetag::id($out[1]));
            //var_dump($rs);
            echo json_encode($rs);
        }
        exit;
    }

    function savetag_action()
    {
        $this->_table = new templatetag();
        $this->manage = new table_templatetag();
        //$this->_table->getFields();
        if (intval(front::$post['id']) > 0) {
            $insert = $this->_table->rec_update(front::$post, intval(front::$post['id']));
        } else {
            $insert = $this->_table->rec_insert(front::$post);
        }
        if ($insert < 1) {
            echo lang_admin('add_to').lang_admin('failure');
        } else {
            //echo "{tag_".front::$post['name']."}";
            echo '<div class="tag"><span class="removeClean tagname">{tag_' . front::$post['name'] . '}</span>';
            echo templatetag::tagadmin(front::$post['name']);
            echo '</div>';
        }
        exit;
    }

    function note_action()
    {

        chkpw('template_note');
        if (front::post('submit')) {
            unset(front::$post['submit']);
            help::$_var['template_note'] = front::$post;
            help::save();
        }
        $dir = ROOT . '/template/' . config::get('template_dir');
        $_dir = dir($dir);
        while ($file = $_dir->read()) {
            if (!preg_match('/^\./', $file) && is_dir($dir . '/' . $file) && !preg_match('/[#@]/', $file) && !preg_match('/^_/', $file)) {
                $this->view->tps[$file] = '<b>' . $file . '</b>';
                $__dir = dir($dir . '/' . $file);
                while ($_file = $__dir->read()) {
                    if (!preg_match('/^\./', $_file) && !preg_match('/[#@]/', $_file)) {
                        if ($file == 'skin' && !preg_match('/\.(css|js)$/', $_file))
                            continue;
                        $_file = str_replace('.', '_', $_file);
                        if (is_dir($dir . '/' . $file . '/' . $_file))
                            $this->view->tps[$file . '/' . $_file] = "&nbsp;&nbsp;└<b>" . $_file . '</b>';
                        else
                            $this->view->tps[$file . '/' . $_file] = "&nbsp;&nbsp;└" . $_file;
                    }
                }
            } elseif (!preg_match('/^\./', $file) && is_file($dir . '/' . $file) && !preg_match('/[#@]/', $file)) {
                $file = str_replace('.', '_', $file);
                $tps[$file] = $file;
            }
        }
        //$this->view->tps = array_merge($tps,$this->view->tps);
        $tps_arr = array_merge($tps, $this->view->tps);
        //分页
        $limit = 20;
        if (!front::get('page'))
            $page = 1;
        else
            $page = front::get('page');
        $total = ceil(count($tps_arr) / $limit);
        if ($page < 1) $page = 1;
        if ($page > $total) $page = $total;
        $start = ($page - 1) * $limit;
        $end = $start + $limit - 1;
        $tmp = range($start, $end);
        $list_tps_arr = array();
        $i = 0;
        foreach ($tps_arr as $k => $v) {
            if (in_array($i++, $tmp))
                $list_tps_arr[$k] = $v;
        }
        $this->view->tps = $list_tps_arr;
        $this->view->link_str = listPage($total, $limit, $page);
    }

    function tag_action()
    {
        if (front::post('submit')) {
            unset(front::$post['submit']);
            help::$var['tag_note2'] = array();
            help::$_var['tag_note2'] = front::post('tag');
            help::save();
        }
        for ($i = 0; $i <= 49; $i++)
            $this->view->tags[$i] = null;
    }

    function edit_action()
    {
        chkpw('template_edit');

        if (front::post('submit')) {
            unset(front::$post['submit']);
            help::$_var[config::get('template_dir') . '_template_note'] = front::$post;
            help::save();
        }
        $dir = ROOT . '/template/' . config::get('template_dir');
        $_dir = dir($dir);
        while ($file = $_dir->read()) {
            if (!preg_match('/^\./', $file) && is_dir($dir . '/' . $file) && !preg_match('/[#@]/', $file) && !preg_match('/^_/', $file)) {
                $this->view->tps[$file] = '<b>' . $file . '</b>';
                $__dir = dir($dir . '/' . $file);
                while ($_file = $__dir->read()) {
                    if (!preg_match('/^\./', $_file)) {
                        if ($file == 'skin' && !preg_match('/\.(css|js)$/', $_file))
                            continue;
                        $_file = str_replace('.', '_', $_file);
                        if (is_dir($dir . '/' . $file . '/' . $_file)) {
                            $this->view->tps[$file . '/' . $_file] = "&nbsp;&nbsp;└<b>" . $_file . '</b>';
                        } else {
                            $this->view->tps[$file . '/' . $_file] = "&nbsp;&nbsp;└" . $_file;
                        }
                    }
                }
            } elseif (!preg_match('/^\./', $file) && is_file($dir . '/' . $file)) {
                $file = str_replace('.', '_', $file);
                $tps[$file] = $file;
            }
        }
        //$this->view->tps = array_merge($tps,$this->view->tps);
        $tps_arr = array_merge($tps, $this->view->tps);
        //分页
        /*$limit = 20;
        if(!front::get('page'))
            $page = 1;
        else
            $page = front::get('page');
        $total = ceil(count($tps_arr)/$limit);
        if($page < 1) $page = 1;
        if($page > $total) $page = $total;
        $start = ($page-1) * $limit;
        $end = $start+$limit-1;
        $tmp = range($start,$end);
        $list_tps_arr = array();
        $i = 0;
        foreach($tps_arr as $k => $v){
        	if(in_array($i++,$tmp)){
        	    $list_tps_arr[$k] = $v;
                }
        }*/
        $this->view->tps = $tps_arr;
        //$this->view->link_str = listPage($total,$limit,$page);
    }

    function downlist_action()
    {
        $str = file_get_contents('http://template.cmseasy.cn/template-7/template.html');
        $this->view->tpllist = $str;
    }

    function savecookie_action()
    {
        if(front::post('submit')){
            $cmseasyusers['username']=front::post('username');
            $cmseasyusers['passwrod']=front::post('passwrod');
            $cmseasyusers = serialize($cmseasyusers); //序列化
            $cmseasyusers = xxtea_encrypt($cmseasyusers, config::getadmin('cookie_password'));  //加密
            $cmseasyusers = base64_encode($cmseasyusers);//更改格式
            cookie::set('cmseasyusers_cookie', $cmseasyusers,time()+3600*24*7);//保存cookie
        }
        $this->render(url('template/downlist'));
    }


   /* function get_remote_file_url($filename)
    {
        $domain = 'http://template.cmseasy.cn';
        $path = '/template-7/';
        $url = $domain . $path . $filename;
        return $url;
    }*/

    function get_remote_file_size($url)
    {
        $headers = get_headers($url, 1);
        return $headers['Content-Length'] ? $headers['Content-Length'] : 0;
    }

    function json($args)
    {
        echo json_encode($args);
    }

    function json_info($code, $msg)
    {
        // echo json_encode(array('code'=>$code,'msg'=>$msg));
        //$str = '<div id="message"><div class="alert alert-warning alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><span class="glyphicon glyphicon-warning-sign"></span>	 '.$msg.'</div></div>';
        echo json_encode(array('code' => $code, 'msg' => $msg));
    }

    function down_action()
    {
        set_time_limit(0);
        session_write_close();
        $action = front::$get['action'];
        $f = front::$post['f'] ? front::$post['f'] : front::$get['f'];
        $isSql = front::$post['sql'] ? front::$post['f'] : front::$get['sql'];
        $filename = $f . '.zip';

        $download_cache = ROOT . '/cache/downloads/';
        $buytemplatedata=buytemplate::getInstance()->getrow("code='".$f."'");
        if (is_array($buytemplatedata)){
            $remote_url=$buytemplatedata['zipurl'];
        }else{
            $remote_url="";
        }

        $file_size = $this->get_remote_file_size($remote_url);
        $tmp_path = $download_cache . $filename;

        switch ($action) {
            case 'prepare-download':
                // 下载缓存文件夹
                if (!is_dir($download_cache)) {
                    tool::mkdir($download_cache);
                }
                $this->json(compact(/*'remote_url', 'tmp_path',*/ 'file_size'));
                break;
            case 'start-download':
                try {
                    touch($tmp_path);
                    if ($fp = fopen($remote_url, "rb")) {
                        if (!$download_fp = fopen($tmp_path, "wb")) {
                            $this->json_info(1, lang_admin('unable_to_open_temporary_file'));
                            exit;
                        }
                        while (!feof($fp)) {
                            if (!file_exists($tmp_path)) {
                                fclose($download_fp);
                                $this->json_info(2, lang_admin('temporary_file_does_not_exist'));
                                exit;
                            }
                            fwrite($download_fp, fread($fp, 1024 * 8), 1024 * 8);
                            //$_SESSION['tmp_size'] = 1024 * 8 + $_SESSION['tmp_size'];
                        }
                        fclose($download_fp);
                        fclose($fp);
                    } else {
                        $this->json_info(3, lang_admin('cannot_open_remote_file'));
                        exit;
                    }
                } catch (Exception $e) {
                    //@unlink($tmp_path);
                    //exit('发生错误：'.$e->getMessage());
                    $this->json_info(4, $e->getMessage());
                    exit;
                }
                $this->json_info(0, $tmp_path);
                break;
            case 'get-file-size':
                // 这里检测下 tmp_path 是否存在
                //var_dump($tmp_path);
                if (file_exists($tmp_path)) {
                    // 返回 JSON 格式的响应
                    $this->json(array('size' => filesize($tmp_path)));
                }
                //return json(array('size'=>$_SESSION['tmp_size']));
                break;
            case 'exzip':
                $unpath = TEMPLATE;
                if (false !== stristr($f, 'cmseasy')) {
                    config::modify(array(
                        'template_dir' => $f,
                    ));
                } else if (preg_match('/f/i', $f)) {
                    config::modify(array(
                        'template_dir' => $f,
                    ));
                    $unpath = ROOT;
                } else if (false !== stristr($f, 'mobile')) {
                    config::modify(array(
                        'template_mobile_dir' => $f,
                    ));
                }
                $archive = new PclZip($tmp_path);
                if (!$archive->extract(PCLZIP_OPT_PATH, $unpath, PCLZIP_OPT_REPLACE_NEWER)) {
                    $this->json_info(1, $archive->errorInfo(true));
                }
                if ($isSql == 'true' && file_exists(ROOT . '/data/template/' . $f . '/install.sql')) {
                    $rs = tdatabase::getInstance()->restoreTables(ROOT . '/data/template/' . $f . '/install.sql');
                    if ($rs) {
                        $this->json_info(5, $rs);
                        exit;
                    }
                }
                //修改安装状态为已安装
                buytemplate::getInstance()->rec_update("installed=1","static=1 and code='".$f."'");
                $this->json_info(0, lang_admin('template').lang_admin('install').lang_admin('success'));
                break;
            default:
                # code...
                break;
        }
        exit;
    }

    function fckedit_action()
    {
        $id = front::post('id');
        $tpl = str_replace('#', '', $id);
        $tpid = $tpl;
        $tpl = str_replace('_d_', '/', $tpl);
        $tpl = str_replace('_html', '.html', $tpl);
        $res = array();
        $res['content'] = file_get_contents(TEMPLATE . '/' . config::get('template_dir') . '/' . $tpl);
        $res['content'] = "<span id='{$tpid}_fck'></span>" . form::editor($tpid . '_content', $res['content']);
        session::set('fcid', $tpid . '_content');
        session::set('fcid_life', time() + 10);
        echo json::encode($res);
        exit;
    }

    function fetch_action()
    {

        $id = front::post('id');
        $tpl = str_replace('#', '', $id);
        $tpid = $tpl;
        $tpl = str_replace('_d_', '/', $tpl);
        $tpl = str_replace('_html', '.html', $tpl);
        $tpl = str_replace('_css', '.css', $tpl);
        $tpl = str_replace('_js', '.js', $tpl);
        $res = array();
        $res['content'] = file_get_contents(TEMPLATE . '/' . config::get('template_dir') . '/' . $tpl);
        $res['content'] = preg_replace('%</textarea%', '<&#47textarea', $res['content']);
        //$res['content'] = "<textarea rows=\"20\" cols=\"78\" id=\"{$tpid}_content\" style=\" font-size: 12px;\" name=\"{$tpid}_content\">$res[content]</textarea>";
        echo json::encode($res);
        exit;
    }

    function save_action()
    {
        $id = front::post('sid');
        $tpl = str_replace('_d_', '/', $id);
        $tpl = str_replace('#', '', $tpl);
        $tpl = str_replace('_html', '.html', $tpl);
        $tpl = str_replace('_css', '.css', $tpl);
        $tpl = str_replace('_js', '.js', $tpl);
        $res = array();
        $content = htmlspecialchars_decode(front::post('scontent'));
        $content = preg_replace('/\&#039;/s', "'", $content);   //单引号转义
        $content = preg_replace('%<&#47textarea%', '</textarea', $content);
        if ($_GET['site'] != 'default') {
            set_time_limit(0);
            $ftp = new nobftp();
            $ftpconfig = config::get('website');
            $ftp->connect($ftpconfig['ftpip'], $ftpconfig['ftpuser'], $ftpconfig['ftppwd'], $ftpconfig['ftpport']);
            $ftperror = $ftp->returnerror();
            if ($ftperror) {
                exit($ftperror);
            } else {
                $ftp->nobchdir($ftpconfig['ftppath']);
                file_put_contents(ROOT . '/data/tpl.tmp.php', $content);
                $ftp->nobput($ftpconfig['ftppath'] . '/template/' . config::get('template_dir') . '/' . $tpl, ROOT . '/data/tpl.tmp.php');
                $res['message'] = 'ok';
            }
        } else {
            if ($content) {
                $content = stripslashes($content);
                file_put_contents(TEMPLATE . '/' . config::get('template_dir') . '/' . $tpl, $content);
                $res['message'] = 'ok';
            }
        }
        echo $res['message'];
        exit;
    }

    function del_action()
    {
        $dirname = front::get('tplname');
        tool::deleteDir($dirname);
        front::redirect(url('config/system/set/template', 1));
    }

    function end()
    {
        $this->render();
    }
}
    