<?php

if (!defined('ROOT'))
    exit('Can\'t Access !');
set_time_limit(0);
class app_admin extends admin
{

    function init()
    {

    }

    function execSql($sqlquery){
        if (!$sqlquery)
            return '';
        $database = config::getdatabase('database');
        $sqlquery = str_replace("\r", "", $sqlquery);
        $sqlquery = str_replace("cmseasy_", $database['prefix'], $sqlquery);
        $sqls = preg_split("/;(--)*[ \t]{0,}\n/", $sqlquery);
        //var_dump($sqls);exit;
        $nerrCode = "";
        $i = 0;
        foreach ($sqls as $q) {
            $q = trim($q);
            if ($q == "") {
                continue;
            }
            if (tdatabase::getInstance()->query($q))
                $i++;
            else
                $nerrCode .= "执行： $q 出错!\n";
        }
        return $nerrCode;
    }

    function insSql($app_dir)
    {
        if(file_exists($app_dir.'install.sql')){
            $sqlquery = file_get_contents($app_dir.'install.sql');
            return $this->execSql($sqlquery);
        }
        return '';
    }

    function unsSql($app_dir)
    {
        if(file_exists($app_dir.'uninstall.sql')){
            $sqlquery = file_get_contents($app_dir.'uninstall.sql');
            return $this->execSql($sqlquery);
        }
        return '';
    }

    function alertJson($code=0,$msg=''){
        echo json_encode(['code'=>$code,'msg'=>$msg]);
        exit;
    }

    function insFiles($app_id,$app_dir){
        $src_list = front::$apps[$app_id]['filelist'];
        $dec_list = front::$apps[$app_id]['filelist'];
        array_walk($src_list,function(&$item,$key){
            $item = str_replace([
                '%root%',
                '%template%',
                '%template_admin%',
                '%template_shopping_dir%',
                '%user_template_dir%',
                '%admin_template_dir%',
            ],[
                '',
                'template',
                'template_admin',
                'shop',
                'user',
                'admin',
            ],$item);
        });
        array_walk($dec_list,function(&$item,$key){
            $item = str_replace([
                '%root%',
                '%template%',
                '%template_admin%',
                '%template_shopping_dir%',
                '%user_template_dir%',
                '%admin_template_dir%',
            ],[
                ROOT.'/',
                TEMPLATE,
                TEMPLATE_ADMIN,
                config::get('template_shopping_dir'),
                config::get('user_template_dir'),
                config::get('admin_template_dir'),
            ],$item);
        });
        foreach ($src_list as $k => $v){
            $dirPath = dirname($dec_list[$k]);//获取文件目录  目的地目录
            if(!is_dir($dirPath))
            {
                mkdir($dirPath, 0777, true );   //不存在则创建文件夹
            }
            copy($app_dir.'files/'.$v,$dec_list[$k]);
        }
        return;
    }

    function unsFiles($app_id,$app_dir){
        $dec_list = front::$apps[$app_id]['filelist'];
        array_walk($dec_list,function(&$item,$key){
            $item = str_replace([
                '%root%',
                '%template%',
                '%template_admin%',
                '%template_shopping_dir%',
                '%user_template_dir%',
                '%admin_template_dir%',
            ],[
                ROOT.'/',
                TEMPLATE,
                TEMPLATE_ADMIN,
                config::get('template_shopping_dir'),
                config::get('user_template_dir'),
                config::get('admin_template_dir'),
            ],$item);
        });
        foreach ($dec_list as $k => $v){
            unlink($v);
        }
        return;
    }

    //安装插件
    function install($app_id)
    {
       // $app_id = front::$post['app_id'];
        $app_dir = ROOT . '/apps/' . $app_id . '/';

        $app = front::$apps[$app_id];
        $app['installed'] = true;
        if($res = $this->insSql($app_dir)){
            $this->alertJson(-1,$res);
        }
        $this->insFiles($app_id,$app_dir);
        apps::getInstance()->rec_update("installed=1","static=1 and id='".$app_id."'");
      /*  $str = json_encode($app,JSON_UNESCAPED_UNICODE);
        $rs = file_put_contents($app_dir.'/config.json', $str);*/
        //echo $rs;
    }

    function uninstall_action()
    {
        $app_id = front::$post['app_id'];
        $app_dir = ROOT . '/apps/' . $app_id . '/';
        $app = front::$apps[$app_id];
        $app['installed'] = false;

        if($res = $this->unsSql($app_dir)){
            $this->alertJson(-1,$res);
        }
        $this->unsFiles($app_id,$app_dir);
       /* $str = json_encode($app,JSON_UNESCAPED_UNICODE);
        $rs = file_put_contents($app_dir.'config.json', $str);*/
        $rs=apps::getInstance()->rec_update("installed=0","static=1 and id='".$app_id."'");
        echo $rs;
    }

    function get_remote_file_url($filename)
    {
        $domain = 'https://u.cmseasy.cn';
        $path = '/apps/apps-7/';
        $url = $domain . $path . $filename;
        return $url;
    }

    function get_remote_file_size($url)
    {
        $headers = get_headers($url, 1);
        return $headers['Content-Length'] ? $headers['Content-Length'] : 0;
    }

    //远程下载插件
    function down_action()
    {
        set_time_limit(0);
        session_write_close();
        $action = front::$get['action'];
        $f = front::$post['appname'] ? front::$post['appname'] : front::$get['appname'];
        $isSql = front::$post['sql'] ? front::$post['appname'] : front::$get['sql'];
        $filename = $f . '.zip';

        $download_cache = ROOT . '/apps/';

        $remote_url = $this->get_remote_file_url($filename);
        $file_size = $this->get_remote_file_size($remote_url);
        $tmp_path = $download_cache . $filename;

        switch ($action) {
            case 'prepare-download':
                // 下载缓存文件夹
                if (!is_dir($download_cache.$f)) {
                    tool::mkdir($download_cache.$f);
                }
                echo json_encode(array("static"=>1,"message"=>"文件创建成功！"));
                break;
            case 'start-download':
                try {
                    touch($tmp_path);
                    if ($fp = fopen($remote_url, "rb")) {
                        if (!$download_fp = fopen($tmp_path, "wb")) {
                            echo json_encode(array("static"=>0,"message"=>lang_admin("unable_to_open_temporary_file！")));
                            exit;
                        }
                        while (!feof($fp)) {
                            if (!file_exists($tmp_path)) {
                                fclose($download_fp);
                                echo json_encode(array("static"=>0,"message"=>lang_admin("temporary_file_does_not_exist！")));
                                exit;
                            }
                            fwrite($download_fp, fread($fp, 1024 * 8), 1024 * 8);
                        }
                        fclose($download_fp);
                        fclose($fp);
                    } else {
                        echo json_encode(array("static"=>0,"message"=>lang_admin("cannot_open_remote_file！")));
                        exit;
                    }
                } catch (Exception $e) {
                    $messagedata=$e->getMessage();
                    echo json_encode(array("static"=>0,"message"=>$messagedata));
                    exit;
                }
                echo json_encode(array("static"=>1,"message"=>"下载成功，路径：".$tmp_path));
                break;
            case 'get-file-size':
                // 这里检测下 tmp_path 是否存在

                break;
            case 'exzip':
                $unpath = ROOT . '/apps/'.$f;  //解压路径
                $archive = new PclZip($tmp_path);
                if (!$archive->extract(PCLZIP_OPT_PATH, $unpath, PCLZIP_OPT_REPLACE_NEWER)) {
                    echo json_encode(array("static"=>0,"message"=>$archive->errorInfo(true)));
                }
                //解压完成删除压缩包
                if(file_exists($tmp_path)){
                    unlink($tmp_path);
                }
                $this->install($f);
                echo json_encode(array("static"=>1,"message"=>"安装成功！"));
                break;
            default:
                break;
        }
        exit;
    }

    //服务端登陆
    function  login_action(){
        //服务器登陆校验的地址
        $url="https://u.cmseasy.cn/index.php?case=client&act=cmseaylogin&username=".front::$get['app_username']."&passwrod=".front::$get['app_passwrod'];
        $data=service::cmseayurl($url);   //获取服务器的数据
        $data=json_decode($data, true);
        if($data["static"]){
            //登陆成功保存到vookie
            $app_login=array("username"=>front::$get['app_username'],"passwrod"=>front::$get['app_passwrod']);
            $app_login = serialize($app_login);
            $app_login = xxtea_encrypt($app_login, config::getadmin('cookie_password'));
            $app_login = base64_encode($app_login);
            cookie::set('app_login_cookie', $app_login);
        }
        echo json_encode($data);
        exit;
    }

    //校验服务端登陆
    function jklogin_action(){
        $app_login = cookie::get('app_login_cookie');
        $app_login = base64_decode($app_login);
        $app_login = xxtea_decrypt($app_login, config::getadmin('cookie_password'));
        $returndata=array();
        if(!empty($app_login)){
            $applogin=unserialize($app_login);   //反序列化
            $url="https://u.cmseasy.cn/index.php?case=client&act=cmseaylogin&username=".$applogin["username"]."&passwrod=".$applogin['passwrod'];  //服务器获取列表的地址
            $data=service::cmseayurl($url);   //获取服务器的数据
            $data=json_decode($data, true);
            if($data['static']){
                $returndata['static']=1;
                $returndata["message"]=$data['message'];  //登陆成功
                $returndata["modeldata"]=$data['modeldata'];
                $returndata["appsdata"]=$data['appsdata'];
            }
        }
        if($returndata['static']!=1 || $returndata==""){
            $returndata['static']=0;
            $returndata["message"]=lang('login_failure');  //登陆失败
        }
         echo json_encode($returndata);

        exit;
    }

    //退出登陆
    function  close_action(){
        //清空cookie
        cookie::set('app_login_cookie', "");
        front::refresh(url("expansion/index", true));
    }

    //购买插件商品
    function  buyapps_action(){
       //购买插件
        $url="https://u.cmseasy.cn/index.php?case=client&act=buyapps&app_buyusername=".front::$get['app_buyusername'];
        $url.="&app_buyuserid=".front::$get['app_buyuserid'];
        $url.="&app_buytel=".front::$get['app_buytel'];
        $url.="&app_buyip=".front::$get['app_buyip'];
        $url.="&app_buyremarks=".front::$get['app_buyremarks'];
        $url.="&app_buymenoy=".front::$get['app_buymenoy'];
        $url.="&app_buypayname=".front::$get['app_buypayname'];
        $url.="&app_buytype=2";
        $url.="&app_appsname=".front::$get['app_appsname'];
        $data=service::cmseayurl($url);   //获取服务器的数据
        $data=json_decode($data, true);
        if($data['static']){
            apps::getInstance()->rec_update("isbuy=1","id='".front::$get['app_appsname']."'");
        }
        echo json_encode($data);
        exit;
    }
    //购买在线模板商品
    function  buytemplates_action(){
       //购买插件
        $url="https://u.cmseasy.cn/index.php?case=client&act=buyapps&app_buyusername=".front::$get['app_buyusername'];
        $url.="&app_buyuserid=".front::$get['app_buyuserid'];
        $url.="&app_buytel=".front::$get['app_buytel'];
        $url.="&app_buyip=".front::$get['app_buyip'];
        $url.="&app_buyremarks=".front::$get['app_buyremarks'];
        $url.="&app_buymenoy=".front::$get['app_buymenoy'];
        $url.="&app_buypayname=".front::$get['app_buypayname'];
        $url.="&app_buytype=1";
        $url.="&app_appsname=".front::$get['app_appsname'];
        $data=service::cmseayurl($url);   //获取服务器的数据
        $data=json_decode($data, true);
        echo json_encode($data);
        exit;
    }

    //用户充值
    function buyusermenoy_action(){
       //购买插件
        $url="http://u.cmseasy.cn/index.php?case=client&act=buyusermenoy";
        $url.="&app_buyuserid=".front::$get['app_buyuserid'];
        $url.="&app_buyuserpayname=".front::$get['app_buyuserpayname'];
        $url.="&user_menoy=".front::$get['user_menoy'];
        $data=service::cmseayurl($url);   //获取服务器的数据
        $data=json_decode($data, true);
        echo json_encode($data);
        exit;
    }



}
