local handler = geterrorhandler();
seterrorhandler(message)

local ShowFriends = ShowFriends or C_FriendList.ShowFriends
local GetFriendInfo = GetFriendInfo or function(i) local t=C_FriendList.GetFriendInfoByIndex(i); return t.name, t.level, t.className, t.area, t.connected, (t.dnd and "<DND>" or t.afk and "<Away>" or "") end
local GetNumFriends = GetNumFriends or function() return C_FriendList.GetNumFriends(), C_FriendList.GetNumOnlineFriends() end
FriendsMicroButton = FriendsMicroButton or QuickJoinToastButton 

if not FriendsMicroButton then 
	local f = CreateFrame("Button", "FriendsMicroButton", UIParent)
	f:SetFrameStrata("LOW")
	f:SetSize(32,32)
	f:SetPoint("BOTTOM", ChatFrameChannelButton, "TOP",0,5)
	
	f:SetNormalTexture("Interface/ChatFrame/UI-ChatIcon-BattleBro-Up")
    f:SetPushedTexture("Interface/ChatFrame/UI-ChatIcon-BattleBro-Down")
    f:SetHighlightTexture("Interface/Buttons/UI-Common-MouseHilight","ADD")
	
	f.num = f:CreateFontString(f:GetName().."Text", "ARTWORK", "GameFontNormalSmall")
	f.num:SetPoint("BOTTOM", 0, 3)
	f.num:SetText("N/A")
	f.num:SetTextColor(1,1,1,1)
	
end

FriendsMicroButton.t = 50;
FriendsMicroButton:RegisterEvent("FRIENDLIST_UPDATE")
FriendsMicroButton:SetScript("OnEvent",function(s)
	local func,_,y = s:GetScript("OnEnter"), GetNumFriends()
	if s.num then s.num:SetText(y) end
	if func and MouseIsOver(s) then return func(s) end
end)
FriendsMicroButton:SetScript("OnUpdate", function(s,t) 
	s.t = (s.t or 0) + t
	if not ((MouseIsOver(s) and s.t > 1.4) or s.t > 40) then return end
	s.t = 0
	ShowFriends()
end)
FriendsMicroButton:SetScript("OnClick", function()  ToggleFriendsFrame(1) end)
FriendsMicroButton:SetScript("OnLeave", function() GameTooltip:Hide() end)
FriendsMicroButton:SetScript("OnEnter", function() 
	GameTooltip:ClearLines()
	GameTooltip:SetOwner(UIParent, "ANCHOR_CURSOR")
	local x,y = GetNumFriends()
	GameTooltip:AddLine(format("%d/%d 好友在线", y, x))
	while y > 0 do
		local name, level, class, area, connected, status = GetFriendInfo(y);
		local classcap = class:gsub("%a", string.upper):gsub(" ", "")
		local r,g,b = RAID_CLASS_COLORS[classcap].r, RAID_CLASS_COLORS[classcap].g, RAID_CLASS_COLORS[classcap].b
		if status == "<Away>" then
			r,g,b = 0.4,0.4,0.4
		end
		if status == "<DND>" then
			r,g,b = 1,0,0
		end
		GameTooltip:AddLine(format("[%d] %s%s (%s)", level, status or "", name, area), r, g, b)
		y = y - 1
	end
	GameTooltip:Show()
end)


seterrorhandler(handler)