/*
 * Decompiled with CFR 0.152.
 */
package com.jh.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.UUID;
import javax.swing.JOptionPane;

public final class JHHardWareInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String cpuCode;
    private String diskCode;
    private String biosCode;
    public String regex = "\\s+";

    public static void main(String[] args) {
        JHHardWareInfo jhHardWareInfo = new JHHardWareInfo();
        JOptionPane.showConfirmDialog(null, "MAC\u5730\u5740\u4e3a:" + jhHardWareInfo.getBiosCode(), "\u672c\u673aMAC\u5730\u5740", 2);
    }

    public JHHardWareInfo() {
        String s = JHHardWareInfo.runExternalCommand("wmic cpu get ProcessorID");
        this.getCpuCode(this.regex, s);
        s = JHHardWareInfo.runExternalCommand("wmic diskdrive get SerialNumber");
        this.getDiskCode(this.regex, s);
        s = JHHardWareInfo.runExternalCommand("wmic nic where netconnectionid!=NULL get macaddress");
        this.getBiosCode(this.regex, s);
    }

    public void getCpuCode(String regex, String s) {
        if (s.indexOf("ProcessorId") >= 0) {
            s = s.substring("ProcessorId".length()).trim();
            s = s.split(regex)[0];
        }
        this.cpuCode = s;
    }

    public void getDiskCode(String regex, String s) {
        if (s.indexOf("SerialNumber") >= 0) {
            s = s.substring("SerialNumber".length()).trim();
            s = s.split(regex)[0];
        }
        if (s == null || s.trim().length() == 0) {
            s = UUID.randomUUID().toString().replaceAll("-", "");
        }
        this.diskCode = s;
    }

    public void getBiosCode(String regex, String s) {
        if (s.indexOf("MACAddress") >= 0) {
            String maxStr;
            s = s.substring("MACAddress".length()).trim();
            String[] split = s.split(regex);
            s = maxStr = split[0].replace(":", "");
            int i = 1;
            while (i < split.length) {
                String replace = split[i].replace(":", "");
                if (replace.compareTo(maxStr) > 0) {
                    s = replace;
                }
                ++i;
            }
        }
        this.biosCode = s;
    }

    public String getCpuCode() {
        return this.cpuCode;
    }

    public String getDiskCode() {
        return this.diskCode;
    }

    public String getBiosCode() {
        return this.biosCode;
    }

    private static String runExternalCommand(String cmdStr) {
        String s = null;
        StringBuffer sb = new StringBuffer();
        try {
            Process p = Runtime.getRuntime().exec(cmdStr);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((s = stdInput.readLine()) != null) {
                sb.append(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

