var WebSocket = require('ws');

var wss = new WebSocket.Server({ port: 9980 });
wss.setMaxListeners(50);

var TA_MSG_KV_CODE_NAME_EMPTY = 5;
var TA_MSG_KV_CODE_NAME_EXISTS = 4;
var TA_MSG_KV_CODE_ACTION_UNKNOWN = 2;
var TA_MSG_KV_CODE_TYPE_UNKNOWN = 1;
var TA_MSG_KV_CODE_OK = 0;

wss.apps = {};

wss.broadcast = function broadcast(msg) {
  wss.clients.forEach(function each(client) {
    if (client.readyState === WebSocket.OPEN) {
      client.send(JSON.stringify(msg));
    }
  });
};

var sendReplyMsg = function(ws,msg,code,reply){
    msg["return"] = {
        "code": code,
        "msg": reply
    };
    ws.send(JSON.stringify(msg));
};

var sendWsMsg = function(ws,msg){
    ws.send(JSON.stringify(msg));
};

var packList = function(){
    var msg = {
        action:"list",
        data:{
            list:Object.keys(wss.apps)
        },
        from:"",
        to:"all",
        type:"conn"
    };
    return msg;
};

var packOnline = function(){
    var msg = {
        action:"online",
        data:{},
        from:"",
        to:"all",
        type:"conn"
    };
    for(var name in wss.apps){
        msg.data[name] = {
            pid:wss.apps[name].pid
        };
    }
    return msg;
};


wss.on('connection', function connection(ws) {
    console.log(arguments);
    //
    ws.on("close",function(){
        var name = ws.registeredName;
        delete wss.apps[name];
        ws.terminate();
        wss.broadcast(packList());
        wss.broadcast(packOnline());
    })
    //
    ws.on('message', function incoming(data) {
        console.log(data);
        //
        try{
            var msg = JSON.parse(data);
            if(msg.type === "conn"){
                if(msg.action === "register"){
                    if(!msg.from){
                        sendReplyMsg(ws,msg,TA_MSG_KV_CODE_NAME_EMPTY,"Name empty");
                    }
                    else if(msg.from === "all" || wss.apps.hasOwnProperty(msg.from)){
                        sendReplyMsg(ws,msg,TA_MSG_KV_CODE_NAME_EXISTS,"Name registered");
                    }
                    else{
                        var pid = 0;
                        if(msg.data && msg.data.pid){
                            pid = msg.data.pid;
                        }
                        ws.registeredName = msg.from;
                        wss.apps[msg.from] = {
                            "ws": ws,
                            "pid": pid
                        };
                        sendReplyMsg(ws,msg,TA_MSG_KV_CODE_OK,0);
                        wss.broadcast(packList());
                        wss.broadcast(packOnline());
                    }
                }
                else if(msg.action === "quit"){
                    ws.registeredName = "";
                    delete wss.apps[msg.from];
                    //
                    sendReplyMsg(ws,msg,TA_MSG_KV_CODE_OK,0);
                    wss.broadcast(packList());
                    wss.broadcast(packOnline());
                }
                else if(msg.action === "list" || msg.action === "online"){
                    sendReplyMsg(ws,msg,TA_MSG_KV_CODE_OK,0);
                    sendWsMsg(ws,packList());
                    sendWsMsg(ws,packOnline());
                }
                else{
                    sendReplyMsg(ws,msg,TA_MSG_KV_CODE_ACTION_UNKNOWN,"Unknown action");
                }
            }
            else if(msg.type === "logic"){
                sendReplyMsg(ws,msg,TA_MSG_KV_CODE_OK,0);
                delete msg["return"];
                if(msg.to === "all"){
                    wss.broadcast(msg);
                }
                else{
                    if(wss.apps.hasOwnProperty(msg.to)){
                        var dst = wss.apps[msg.to].ws;
                        sendWsMsg(dst,msg);
                    }
                }
            }
            else{
                sendReplyMsg(ws,msg,TA_MSG_KV_CODE_TYPE_UNKNOWN,"Unknown type");
            }

        }
        catch(e){
            console.log(e);
        }
    });
});

// wss.timerCheckAlive = setInterval(function(){
//     wss.clients.forEach(function(ws){

//     })
// }, 2000)