local ffi = require("ffi")
ffi.cdef[[
    typedef struct {
        DWORD cbSize;  
        ULONG fMask;
        HWND hwnd;
        LPCTSTR lpVerb;
        LPCTSTR lpFile;
        LPCTSTR lpParameters;
        LPCTSTR lpDirectory;
        int nShow;
        HINSTANCE hInstApp;
        LPVOID lpIDList;
        LPCTSTR lpClass;
        HKEY hkeyClass;
        DWORD dwHotKey;
        union {
            HANDLE hIcon;
            HANDLE hMonitor;
        }DUMMYUNIONNAME;
        HANDLE hProcess;
    }SHELLEXECUTEINFO,*LPSHELLEXECUTEINFO;
    BOOL ShellExecuteExA(SHELLEXECUTEINFO *pExecInfo);
]]

local __shell32 = ffi.load("shell32")

local SHELL32 = {
    SEE_MASK_DEFAULT = 0x00000000,
    SEE_MASK_CLASSNAME = 0x00000001,  -- SHELLEXECUTEINFO.lpClass is valid
    SEE_MASK_CLASSKEY = 0x00000003, -- SHELLEXECUTEINFO.hkeyClass is valid
    -- Note SEE_MASK_INVOKEIDLIST(0xC) implies SEE_MASK_IDLIST(0x04)
    SEE_MASK_IDLIST = 0x00000004,   -- SHELLEXECUTEINFO.lpIDList is valid
    SEE_MASK_INVOKEIDLIST = 0x0000000c,   -- enable IContextMenu based verbs
    SEE_MASK_ICON = 0x00000010,   -- not used
    SEE_MASK_HOTKEY = 0x00000020,   -- SHELLEXECUTEINFO.dwHotKey is valid
    SEE_MASK_NOCLOSEPROCESS = 0x00000040,   -- SHELLEXECUTEINFO.hProcess
    SEE_MASK_CONNECTNETDRV = 0x00000080,   -- enables re-connecting disconnected network drives
    SEE_MASK_NOASYNC = 0x00000100,   -- block on the call until the invoke has completed, use for callers that exit after calling ShellExecuteEx()
    SEE_MASK_FLAG_DDEWAIT = 0x00000000, -- Use SEE_MASK_NOASYNC instead of SEE_MASK_FLAG_DDEWAIT as it more accuratly describes the behavior
    SEE_MASK_DOENVSUBST = 0x00000200,   -- indicates that SHELLEXECUTEINFO.lpFile contains env vars that should be expanded
    SEE_MASK_FLAG_NO_UI = 0x00000400,   -- disable UI including error messages
    SEE_MASK_UNICODE = 0x00004000,
    SEE_MASK_NO_CONSOLE = 0x00008000,
    SEE_MASK_ASYNCOK = 0x00100000,
    SEE_MASK_HMONITOR = 0x00200000,  -- SHELLEXECUTEINFO.hMonitor
    SEE_MASK_NOZONECHECKS = 0x00800000,
    SEE_MASK_NOQUERYCLASSSTORE = 0x01000000,
    SEE_MASK_WAITFORINPUTIDLE = 0x02000000,
    SEE_MASK_FLAG_LOG_USAGE = 0x04000000,

    ShellExecuteEx = __shell32.ShellExecuteExA
}
return SHELL32