/*
* 实物展台入口文件，包括91文件夹的全局变量的保存
*
* */

var CameraPrepare =function () {
    var obj={
        fromapp:"",//从哪个app启动的，TA/IFB/IFS/SKJL(授课精灵)
        video:null,//video对象
        videoAspectRatio:1,//video的长宽比
        context :$("#canvas")[0].getContext("2d"),//canvas context对象
        containerHeight:0,//容器高度，对多种分辨率图片兼容使用
        containerWidth:0,//容器宽度，对多种分辨率图片兼容使用
        containerRadio:1,//容器的宽高比（width/height），对多种分辨率图片兼容使用
        init:function () {
            var that = this;
            setTimeout(function () {
                win.focus();
            });
             that.containerHeight = $("#bigImageListContainer").height();
             that.containerWidth  = window.innerWidth;
             that.containerRadio = that.containerWidth/that.containerHeight;
            //设置图片预览界面 图片的高度
            $("#bigImageListContainer div.item").height(that.containerHeight / 2 + "px");

            that.video = $("#video")[0];
            //ifs，ifb，TA调用实物展台进入拍照页面，授课精灵启动进入预览界面
            var argument =gui.App.argv[0];
            if(argument&&argument.indexOf('skjl')!=-1){//授课精灵启动实物展台，进入预览界面
                setTimeout(function () {//需要cameraAvalon加载完成，所以写setTimeout
                    that.fromapp = 'skjl';//授课精灵启动实物展台
                    window.mainBodyVm.photograph = true;
                    window.previewPicVM.showReturnBtn = false;//屏蔽“返回”按钮
                    $("#fullscreen-close2-btn").css('left','15px');
                    navigator.mediaDevices.enumerateDevices().then(that.gotDevicesSuccess).catch(that.enumerateDevicesError);//获取摄像头信息
                    that.getUserMedia();//获取输入流
                    var jsonStr = argument.substring(argument.indexOf('args')+'args='.length);//截取json对象字符串
                    window.previewPicVM.viewPhotoArr=[];//置空原数组
                    var jsonObj = $.parseJSON(jsonStr);//字符串转json
                    for(var i =0 ;i<jsonObj.imgs.length;i++){
                        var tempObj ={src:jsonObj.imgs[i].src};
                        window.previewPicVM.viewPhotoArr.push(tempObj);
                    }
                    if(jsonObj.imgs.length ==1){//只传过来一张图，进入单页模式
                        window.previewPicVM.multiple = false; //单图
                        window.previewPicVM.singlePicSrc = jsonObj.imgs[0].src;//单图src
                        window.previewPicVM.isAllPicPreview = true; //是否展示全部图片
                        socketEvent.one('singleState',function () {
                            window.previewPicVM.sendImgNumState('single');//向ifs发送消息
                            cmpreview.init(jsonObj.imgs[0].src);
                        })
                        cmpreview.init(jsonObj.imgs[0].src);//初始化缩放工具栏
                    }else if(jsonObj.imgs.length ==2){//传过来两张图，两张图和，3、4张图样式不同，分别设置
                        window.previewPicVM.multiple = true; //多图
                        window.previewPicVM.singlePicSrc = "";//单图src置空
                        window.previewPicVM.isTwoPic =true;//设置样式为两张图样式
                        window.previewPicVM.isAllPicPreview = true; //是否展示全部图片
                        socketEvent.one('multipleState',function () {
                            window.previewPicVM.sendImgNumState('multiple');//向ifs发送消息
                        })
                    }else{//传过来3、4张图；和两张图样式不同
                        window.previewPicVM.multiple =true;//进入多图展示页面
                        window.previewPicVM.isTwoPic =false;//设置样式为三、四张图样式
                        window.previewPicVM.isAllPicPreview = true; //进入预览全部图片状态
                        socketEvent.one('multipleState',function () {
                            window.previewPicVM.sendImgNumState('multiple');//向ifs发送消息
                        })
                    }
                    window.mainBodyVm.photograph = false;
                })
            }else{//非授课精灵启动实物展台，进入拍照界面
                setTimeout(function (){//需要cameraAvalon加载完成，所以写setTimeout
                    window.mainBodyVm.photograph = true;
                    navigator.mediaDevices.enumerateDevices().then(that.gotDevicesSuccess).catch(that.enumerateDevicesError);//获取摄像头信息
                    that.getUserMedia();//获取输入流
                    that.setTypeAndPageDisplay(argument); //根据调用实物展台的APP不同ifb，ifs，ta展示不同的“加入课本”按钮
                })
            }
        },
        //获取设备信息成功并在页面添加摄像头列表
        gotDevicesSuccess:function (deviceInfos) {
            console.log("gotDevicesSuccess deviceInfos:%o", deviceInfos);
            var exArray = [];
            var videoSource = $("#cameraList").val();
            for (var i = 0; i != deviceInfos.length; ++i) {
                var deviceInfo = deviceInfos[i];
                // 这里会遍历audio,video，所以要加以区分
                if (deviceInfo.kind === 'videoinput'&&deviceInfo.label!="screen-capture-recorder") {
                    exArray.push(deviceInfo);
                }
            }
            var options = "";
            exArray.forEach(function (el) {
                if(el.label.length>25){
                    el.label = el.label.substring(0,22)+'...'
                }
                if (el.deviceId === videoSource) {
                    options += "<option value='" + el.deviceId + "' selected='selected'>" + el.label + "</option>";
                }
                else {
                    options += "<option value='" + el.deviceId + "'>" + el.label + "</option>";
                }
            });
            //当前选中videosource,默认为第一个
            _curVideoSource=exArray[0].deviceId;
            $("#cameraList").html(options);
        },
        //获取设备信息失败
        enumerateDevicesError:function(error) {
            console.log('navigator.getUserMedia error: ', error);
        },
        //获取输入流
        getUserMedia : function(){
            var that = this;
            var videoSource = $("#cameraList").val();
            $("#video").hide();//不屏蔽video的话会出现黑框
            navigator.webkitGetUserMedia({
                video: {
                    mandatory: {
                        minAspectRatio: 1.40,
                        maxAspectRatio: 1.78,
                        minFrameRate: 30,
                        maxFrameRate: 30,
                        minWidth: 1920,
                        minHeight: 1080
                    },
                    optional: [
                        {
                            // sourceId: exArray[0],
                            sourceId: videoSource
                        }
                    ]
                }
            }, function (stream) {
                that.getUserMediaSuccess(stream);
            }, function (error) {
                console.log(error);
            });
        },
        //获取media成功
        getUserMediaSuccess:function(stream) {
            var that = this;
            // var stream=stream;
            // that.video = $("#video")[0];
            // that.video.src = window.webkitURL.createObjectURL(stream);
            // that.video.play();
            // window.stream = stream; // make stream available to browser console
            // that.video.srcObject = stream;

            //延时可以拍照
            setTimeout(function(){
                window.photographVM.forbidTakePicture = false;
            },800)

            //需延时才能获得videoWidth和videoHeight，动态设置各种框
            setTimeout(function(){
                //  video的宽高比，用于动态设置canvas的宽高
                that.videoAspectRatio=(that.video.videoWidth/that.video.videoHeight).toFixed(2);
                //video根据摄像头的长宽比重新设置后，重新为video设置stream信息，这样是为了适应不同摄像头尺寸比例
                that.video = $("#video")[0];
                that.video.src = window.webkitURL.createObjectURL(stream);
                that.video.play();
                setTimeout(function () {//这个逻辑不是很好，希望的是video的src加载完成后再显示出来
                    $("#video").show();
                    window.photographVM.takePicture = true;
                },350);
                window.stream = stream; // make stream available to browser console
                that.video.srcObject = stream;
            },300);
            return navigator.mediaDevices.enumerateDevices();
        },
        //得到当前使用者的类型 type类型为 ifs|ifb|''
        //设置页面可显示数据
        //添加了argument参数  根据调用实物展台的APP不同ifb，ifs，ta展示不同的“加入课本”按钮
        setTypeAndPageDisplay:function(argument){
            var that =this;
            if(!argument){//不含参数的是TA打开
                that.fromapp = 'ta';
                window.previewPicVM.addtoBook = false;//隐藏“加入课本”/“加入课件按钮”
            }else{
                if(argument.indexOf("iflybook")!=-1&&argument.indexOf("fromapp")!=-1){
                    that.fromapp = 'ifb'//iflybook启动
                    window.previewPicVM.addtoBook = true;//显示“加入课本”/“加入课件按钮”
                    window.previewPicVM.needPaging = false;//显示“加入课本”按钮
                }
                if(argument.indexOf("iflyslide")!=-1&&argument.indexOf("fromapp")!=-1){
                    that.fromapp = 'ifs'//iflyslide启动
                    window.previewPicVM.addtoBook = true;//显示“加入课本”/“加入课件按钮”
                    window.previewPicVM.needPaging = true;//显示“加入课件”按钮
                }
            }
        }



    };
    return obj;
};

var cameraPrepare =CameraPrepare();
$(document).ready(function () {
    cameraPrepare.init();
});


// $(function () {
//     var gui = require('nw.gui');
//     //ifs，ifb，TA调用实物展台进入拍照页面，授课精灵启动进入预览界面
//     var argument =gui.App.argv[0];
//     if(argument&&argument.indexOf('skjl')!=-1){//授课精灵启动实物展台，进入预览界面
//
//     }else{//非授课精灵启动实物展台，进入拍照界面
//         // video = $("#video")[0];
//         // navigator.mediaDevices.enumerateDevices().then(gotDevicesSuccess).catch(enumerateDevicesError);
//         // getUserMedia();
//         // setTypeAndPageDisplay();
//         // if(!argument){//TA启动实物展台
//         //
//         // }else if(argument.indexOf('iflybook')!=-1){//iflybook启动实物展台
//         //
//         // }else if(argument.indexOf('flyslide')!=-1){//iflyslide启动实物展台
//         //
//         // }
//     }
// });