var cmpreview = {
	zoom:1,
	direction:0,
	src:"",
	zoom_ratio:1.2,
	max_zoom_ratio: Math.pow(1.2,6),
	min_zoom_ratio: Math.pow(1.2,-6),
	rotate_ratio:90,
	max_rotate_ratio:360
}
var dom = {};
var cW,cH;
var srcW,srcH;//图片原始大小
var _isdrag = false; //是否绑定过拖拽事件
cmpreview.reset = function(src){
	dom.test_img.removeClass("rotate"+cmpreview.getCurDirection());
	cmpreview.setDirection(0);
	cmpreview.setZoom(1);
	cmpreview.src = src || "";
	
}
cmpreview.init = function(src) {
	dom.test_img = $("#test_img");
	dom.enlarge = $("#enlarge");
	dom.narrow = $("#narrow");
	dom.left_rotate = $("#left_rotate");
	dom.right_rotate = $("#right_rotate");
	dom.test_dom = $("#test_dom");
	cW = $(document).width();
	cH = $(document).height() - 48;
	dom.test_dom.width(cW).height(cH);
	if(cmpreview.src == src){
		//这里再加上这一块是为了避免两次src一样不会走到load方法中
		cmpreview.reset(src);
		var ret = cmpreview.initImage();
		dom.test_img.width(ret.width).height(ret.height);
		cmpreview.setPosition();
	}else{
		cmpreview.reset(src);
		dom.test_img.attr("src",src).load(function(){
			var ret = cmpreview.initImage();
			if(!_isdrag){
				cmpreview.drag();
				_isdrag = true;
			}
			dom.test_img.width(ret.width).height(ret.height);
			cmpreview.setPosition();
		});
	}
}

//放大
cmpreview.enlarge = function(){
	var w = dom.test_img.width();
	var h = dom.test_img.height();
	var next_width,next_height;
	next_width = w * cmpreview.zoom_ratio;
	next_height = h * cmpreview.zoom_ratio;
	dom.test_img.width(next_width).height(next_height);
	var curzoom = cmpreview.getCurZoom()*cmpreview.zoom_ratio;
	cmpreview.setZoom(curzoom);
	cmpreview.setPosition();
}
//缩小
cmpreview.narrow = function(){
	var w = dom.test_img.width();
	var h = dom.test_img.height();
	var next_width,next_height;
	next_width = w / cmpreview.zoom_ratio;
	next_height = h / cmpreview.zoom_ratio;
	dom.test_img.width(next_width).height(next_height);
	var curzoom = cmpreview.getCurZoom()/cmpreview.zoom_ratio;
	cmpreview.setZoom(curzoom);
	cmpreview.setPosition();
}
//左旋转
cmpreview.left_rotate = function(){
	var r = cmpreview.getCurDirection();
	dom.test_img.removeClass("rotate"+r);
	if(r > 0){
		r -= 90;
	}else{
		r = 360 - 90;
	}
	cmpreview.setDirection(r);
	dom.test_img.addClass("rotate"+r);
	cmpreview.resizeImage(r);
	cmpreview.setZoom(1);
}
//右旋转
cmpreview.right_rotate = function(){
	var r = cmpreview.getCurDirection();
	dom.test_img.removeClass("rotate"+r);
	if(r < 270){
		r += 90;
	}else{
		r = 0;
	}
	cmpreview.setDirection(r);
	dom.test_img.addClass("rotate"+r);
	cmpreview.resizeImage(r);
	cmpreview.setZoom(1);
}

cmpreview.getCurZoom = function(){
	return cmpreview.zoom;
}
cmpreview.setZoom = function(zoom){
	cmpreview.zoom = zoom;
	//授课精灵发送缩放状态
	var json = {
		action:"state_zoom_cmpage",
		data:{
			zoom:zoom  // 当前缩放级别, 1.0 代表不缩放，其余表示缩放级
		},
		from:"cameraplat",
		id:"",
		to:"iflyslide",
		type:"logic"
	}
	socket.send(json);
}

cmpreview.getCurDirection = function(){
	return cmpreview.direction;
}
cmpreview.setDirection = function(direction){
	cmpreview.direction = direction;
}
//设置图片初始自适应
cmpreview.initImage = function(){
	var result = {};
	var image = new Image();
	image.src=dom.test_img.attr("src");
	srcW = image.width;
	srcH = image.height;
	var w,h;
	var r = cmpreview.getCurDirection();
	// if(r / 90 % 2 === 0 ){
	// 	w = image.width;
	// 	h = image.height;
	// }else{
	// 	w = image.height;
	// 	h = image.width;
	// }
	w = image.width;
	h = image.height;
	if(w > cW || h > cH){
		if(w/cW > h/cH){
			result.width = cW;
			result.height = h / (w/cW);
		}else{
			result.height = cH;
			result.width = w / (h/cH);
		}
	}else{
		result.width = w;
		result.height = h;
	}
	return result;
}
//设置位置
cmpreview.setPosition = function(){
	var w = dom.test_img.width();
	var h = dom.test_img.height();
	var l = (cW - w)/2;
	var t = (cH - h)/2;
	dom.test_img.css({"left":l + "px","top":t + "px"});
}

// 重置图片宽高
cmpreview.resizeImage = function(rotateDeg){

	var mH = cH,
		mW = cW;
	if(rotateDeg == '90' || rotateDeg == '270'){
		mW = [mH, mH = mW][0];
	}
	var $image = dom.test_img;
	var imageWidth = srcW;
	var imageHeight = srcH;
	var imgRatio = imageWidth/ imageHeight;

	var width, height;
	width = Math.min(imageWidth, mW);
	height = Math.min(imageHeight, mH);

	if(width / height > imgRatio){
		width = height * imgRatio;
	} else{
		height = width / imgRatio;
	}

	$image.css({
		width:width,
		height:height
	});
	cmpreview.setPosition();
}

cmpreview.drag = function(){
	var dragX = -1;
	var $image = dom.test_img;
	var down = {
		x:-1,
		y:-1
	}
	$image.on("mousedown",function(e){
		dragX = e.clientX || e.pageX;
		dragY = e.clientY || e.pageY;
	});
	$image.on("mousemove",function(e){
		if(dragX > 0){
			var nextDragX=e.pageX || e.clientX;
			var nextDragY=e.pageY || e.clientY;
			var o = $image.offset(),
				left =o.left +  (nextDragX - dragX),
				top =o.top + (nextDragY - dragY),
				w = $image.width(),
				h = $image.height();
			var r = cmpreview.getCurDirection();
			if(r / 90 % 2 === 0 ){
				if(w > cW){
					if(left > 0){
						left = 0 ;
					}
					else if(left < cW - w){
						left = cW - w;
					}
				}else{
					left = o.left;
				}
				if(h > cH){
					if(top > 0){
						top = 0 ;
					}
					else if(top < cH - h){
						top = cH - h;
					} 
				} else{
					top = o.top;
				}	
			}else{
				if(w > cH){
					if(top > 0){
						top = 0;
					}else if(top < cH - w){
						top = cH - w;
					}
				}else{
					top = o.top;
				}

				if(h > cW){
					if(left > 0){
						left = 0;
					}else if(left < cW - h){
						left = cW - h;
					}
				}else{
					left = o.left;
				}
			}
			
		
			$image.offset({
				left : left,
				top : top
			});
			dragX=nextDragX;
			dragY=nextDragY; 
		}
		
	});
	$image.on("mouseup",function(e){
		dragX = -1;
	});
	$image.on("mouseout",function(e){
		dragX = -1;
	});

	//保证只绑定一次鼠标滚动事件

	var MOUSEWHEEL_EVENT ="mousewheel";
	if(document.attachEvent){
		document.attachEvent("on"+MOUSEWHEEL_EVENT, function(e){
			mouseWheelScroll(e);
		});
	} else if(document.addEventListener){
		document.addEventListener(MOUSEWHEEL_EVENT, function(e){
			mouseWheelScroll(e);
		}, false);
	}	
	function mouseWheelScroll(e){
		var _delta = parseInt(e.wheelDelta || -e.detail);
		//向上滚动
			if (_delta > 0) {
			cmpreview.enlarge();
		}
		//向下滚动
		else {
	    	cmpreview.narrow();
		}
	}
	

		
}





