﻿avalon.ready(function(){
    //最大的那个Vm
    var mainBodyVm = avalon.define({
        $id:"mainBodyVm",
        photograph:true,//在拍照界面还是在图片展示界面
        //关闭实物展台
        closeCameraPlat:function () {
            win.close();
        }
    })
    window.mainBodyVm =mainBodyVm;

    //拍照界面VM
    var photographVM = avalon.define({
        $id:"photographVM",
        photoArr:[{src:"",_index:0},{src:"",_index:1},{src:"",_index:2},{src:"",_index:3}],//初始化图片数组（这里这样写拍照函数比较方便）
        existPic:false,//存在已经拍好的照片，设置“预览”按钮是否置灰
        curPhotoIndex:0,//当前照片下标
        takePicture:true,//是在拍照状态还是在展示照片状态
        showPicSrc:'',//预览的照片的src
        forbidTakePicture:true,//禁止拍照功能，刚刚载入页面，切换摄像头时使用

        //关闭实物展台
        closeCameraPlat1:function () {
            win.close();
        },
        //进入图片预览界面
        toPreviewPic:function () {
            mainBodyVm.photograph = false;
            previewPicVM.viewPhotoArr=[];//置空展示图片数组
            for(var i=0;i<photographVM.photoArr.length;i++){
                if(photographVM.photoArr[i].src){
                    var obj={
                        src:photographVM.photoArr[i].src,
                    };
                    previewPicVM.viewPhotoArr.push(obj);
                }
            }
            //根据展示图片数量不同走不同逻辑
            if(previewPicVM.viewPhotoArr.length==1){//这里不能简单的直接用jumpToSingle方法，因为jumpToSingle方法设置了“退出预览全部图片状态”
                previewPicVM.multiple =false;//进入单图展示页面
                previewPicVM.singlePicSrc =previewPicVM.viewPhotoArr[0].src;
                previewPicVM.isAllPicPreview = true; //进入预览全部图片状态
                previewPicVM.sendImgNumState('single');//向ifs发送消息
                cmpreview.init(previewPicVM.viewPhotoArr[0].src);
            }else if(previewPicVM.viewPhotoArr.length==2){
                previewPicVM.multiple =true;//进入多图展示页面
                previewPicVM.isTwoPic =true;//设置样式为两张图样式
                previewPicVM.isAllPicPreview = true; //进入预览全部图片状态
                previewPicVM.sendImgNumState('multiple');//向ifs发送消息
            }else{
                previewPicVM.multiple =true;//进入多图展示页面
                previewPicVM.isTwoPic =false;//设置样式为三、四张图样式
                previewPicVM.isAllPicPreview = true; //进入预览全部图片状态
                previewPicVM.sendImgNumState('multiple');//向ifs发送消息
            }
        },
        //拍照
        getPic:function () {
            var img = photographVM.catchPicture();
            photographVM.photoArr[photographVM.curPhotoIndex].src=img.src;
            if(photographVM.curPhotoIndex<3){
                photographVM.curPhotoIndex++;
            }else{
                photographVM.curPhotoIndex = 0;
            }
            photographVM.existPic = true;//拍照后一定存在照片，设置为true
        },
        //拍照函数
        catchPicture:function(){
            //设置canvas的宽和高同video保持一致
            cameraPrepare.context.canvas.width = cameraPrepare.video.videoWidth;
            cameraPrepare.context.canvas.height = cameraPrepare.video.videoHeight;
            cameraPrepare.context.drawImage(cameraPrepare.video,0,0,cameraPrepare.video.videoWidth,cameraPrepare.video.videoHeight);
            var image=new Image();
            image.src = $("#canvas")[0].toDataURL("image/png");
            return image;
        },
        //点击小图片，展示大图
        showPic:function (el) {
            photographVM.curPhotoIndex = el._index;
        },
        //删除当前照片
        deleteCurPic:function () {
            photographVM.photoArr[photographVM.curPhotoIndex].src="";
            photographVM.takePicture = true;
            photographVM.showPicSrc = "";
            //判断删除后是否存在照片
            var existPicArr =photographVM.photoArr.filter(function (el) {
                return el.src !=""
            })
            if(existPicArr.length>0){
                photographVM.existPic = true;
            }else{
                photographVM.existPic = false;
            }
        }
    });
    window.photographVM =photographVM;

    //照片预览界面VM
    var previewPicVM = avalon.define({
        $id:"previewPicVM",
        viewPhotoArr:[],//展示图片数组
        multiple:true,//true:多图预览界面;false:单图预览界面
        isTwoPic:true,//显示多图预览情况下，是2张图片还是3或4张图片，true时为两张图
        singlePicSrc:'',//单图预览界面图片src
        addtoBook:false,//是否从IFB,IFS打开实物展台，该值为true是显示“加入课本”/“加入课件”按钮的  必要条件
        isAllPicPreview:false,//是否预览全部图片（两种情况：1、只有一张图片时，单图预览；2、有多张图片时，多图预览）该值为true是显示“加入课本”的必要条件
        needPaging:false,//是否需要分页加入课本（IFS需要分页，IFB不需要）
        showReturnBtn:true,//是否展示“返回”按钮
        //跳转到单图预览界面（此方法仅供多图预览跳转至单图预览界面使用，因为isAllPicPreview属性特殊）
        jumpToSingle:function (el) {
            previewPicVM.multiple=false;
            previewPicVM.singlePicSrc=el.src;//设置单图预览图片src
            previewPicVM.isAllPicPreview = false; //退出预览全部图片状态
            //todo
            // if(cameraPrepare.fromapp == 'skjl') {//如果是从授课精灵启动的，图片是传入进来的
            //     $("#test_img").css('min-height','').css('min-width','')//重置样式
            //     var src = el.src;
            //     previewPicVM.adjustPosition(src, 0, 'One');
            // }
            previewPicVM.sendImgNumState('single');//向ifs发送消息
            cmpreview.init(el.src);
        },
        //跳转到多图预览界面
        jumpToMultiple:function () {
            if(previewPicVM.isAllPicPreview){//如果是只有一张图片
                return ;
            }
            previewPicVM.multiple=true;//设置是多图预览
            previewPicVM.singlePicSrc="";//清空单图预览图片src
            previewPicVM.isAllPicPreview = true; //进入预览全部图片状态
            previewPicVM.sendImgNumState('multiple');//向ifs发送消息
        },
        //返回上一级（单图预览-->返回上一层(拍照或多图预览)；多图预览--->返回拍照；）
        returnUpperLever :function () {
            if(!previewPicVM.multiple){//单图预览
                if(previewPicVM.viewPhotoArr.length!=1){//单图预览-->有多张图-->返回多图预览
                    previewPicVM.jumpToMultiple();
                }else{//单图预览-->如果一只有一张图-->返回拍照；
                    mainBodyVm.photograph = true;
                    setTimeout(function () {//因为avalon控制的页面显示隐藏会有一点点延迟，所有要setTimeout以后让video play
                        cameraPrepare.video.play();
                    })
                }
            }else{//多图预览，返回拍照界面
                mainBodyVm.photograph = true;
                setTimeout(function () {//因为avalon控制的页面显示隐藏会有一点点延迟，所有要setTimeout以后让video play
                    cameraPrepare.video.play();
                })
            }
        },
        //添加图片到IFB
        addToIfb:function () {
            var path = require('path');
            var execPath = process.execPath;
            execPath = execPath.substring(0, execPath.lastIndexOf('nw.exe'));
            var temppng = path.join(execPath, "plugins/91/temppng.png");
            var drawImgCallbackObj={
                onrendered: function (canvas) {
                    var base64Data=canvas.toDataURL('image/jpg').replace(/^data:image\/\w+;base64,/,"");
                    var dataBuffer = new Buffer(base64Data,'base64');
                    fs.writeFile(temppng,dataBuffer,function (err) {
                        if(err){
                            console.log('err:' + err);
                            process.exit(0);
                        } else {
                            console.log('success');
                            process.exit(3);
                        };
                    });
                }
            };
            if(!previewPicVM.multiple){ //就一页
                html2canvas($('#bigImageContainer'), drawImgCallbackObj);
            }else {  //多页绘图
                html2canvas($('#bigImageListContainer'),drawImgCallbackObj);
            }
        },
        //添加图片到IFS
        addToIfs:function () {
            // var $imgs = $('#slideList li img');
            // previewPicVM.viewPhotoArr
            if($('.addType_Ifs:checked').val() == 'single'){    //不分页
                if(previewPicVM.viewPhotoArr.length == 1){ //就一张图
                    previewPicVM.savePic([previewPicVM.viewPhotoArr[0].src],'single',function () {
                        window.close();
                    });
                }else{  //一页多张图
                    html2canvas($('#bigImageListContainer'), {
                        onrendered: function(canvas) {
                            var imgData = canvas.toDataURL("image/png");
                            var param = {'imgs':[imgData]};
                            previewPicVM.savePic([imgData],'single',function () {
                                window.close();
                            });
                        }
                    });
                }
            }else{  //多页多张图
                var imgSrcs = [];
                for(var i=0;i<previewPicVM.viewPhotoArr.length;i++){
                    imgSrcs.push(previewPicVM.viewPhotoArr[i].src);
                }
                if(imgSrcs.length){  //存在图片
                    var param = {'imgs':imgSrcs};
                    previewPicVM.savePic(imgSrcs,'multiple',function () {
                        window.close();
                    });
                }
            }
        },
        /*
         *生成图片，现在默认为png
         */
         savePic:function(arr,type,callback) {
             var pathArr =[];
             for(var i=0,len = arr.length;i<len;i++){
                 var path = sysTmp+COMMON_._getRandomString(16)+'.png';
                 pathArr.push(path);
                 var dataBuffer = new Buffer(arr[i].replace(/^data:image\/\w+;base64,/,""),'base64');
                 fs.writeFileSync(path,dataBuffer);
             }
             console.log(pathArr);
             previewPicVM.send2ifsPic(pathArr,type,callback);
         },

        //向j0发送socket消息(加入课件)
         send2ifsPic:function(pathArr,type,callback) {
            var obj = {
                to:'iflyslide',
                type:'logic',
                action:'cam2ifs',
                data:{
                    type:type,
                    filePath:pathArr,
                }
            }
            socket && socket.send(obj);
            callback&&callback();
        },
        //关闭实物展台
        closeCameraPlat2:function () {
            win.close();
        },
        //放大
        enlarge:function(){
            cmpreview.enlarge();
        },
        //缩小
        narrow:function(){
            cmpreview.narrow();
        },
        //左旋转
        left_rotate:function(){
            cmpreview.left_rotate();
        },
        //右旋转
        right_rotate:function(){
            cmpreview.right_rotate();
        },

        //发送单图预览/多图预览状态消息
        sendImgNumState:function (state) {
            var obj ={
                action:"state_imgNum_cmpage",
                data:{
                    state:"" //multiple多图预览 or single单图预览
                },
                from:"cameraplat",
                id:"",
                to:"iflyslide",
                type:"logic"
            }
            if(state =='single'){//单图预览界面
                obj.data.state = 'single';
            }else if(state == 'multiple'){//多图预览界面
                obj.data.state = 'multiple';
            }else{//如果参数不正确..return
                return false;
            }
            socket&&socket.send(obj);
            body_focus();//切换图片时一定实物展台会在最前方的
        },

        //多张图片展示完成后回调，用于图片展示样式调整
        showMulPicRendered:function () {
            var  picNum = previewPicVM.viewPhotoArr.length;//展示的图片数量
            previewPicVM.reSetCssOption();
            if(picNum==1){//单图片
                //todo
                // if(cameraPrepare.fromapp == 'skjl') {//如果是从授课精灵启动的，图片是传入进来的
                //     var src1 = previewPicVM.viewPhotoArr[0].src;
                //     previewPicVM.adjustPosition(src1, 0, 'One');
                // }
            }else if(picNum==2){//两张图片
                if(cameraPrepare.fromapp == 'skjl'){//如果是从授课精灵启动的，图片是传入进来的
                    for(var j=0;j<picNum;j++){
                        var src2 = previewPicVM.viewPhotoArr[j].src;
                        previewPicVM.adjustPosition(src2,j,'Two');
                    }
                }
            }else{//3、4张图片
                if(cameraPrepare.fromapp == 'skjl'){//如果是从授课精灵启动的，图片是传入进来的
                    for(var i=0;i<picNum;i++){
                        var src = previewPicVM.viewPhotoArr[i].src;
                        previewPicVM.adjustPosition(src,i,'Multi');
                    }
                }else{//从TA、IFB、IFS启动实物展台，图片从摄像头获得
                    //这段代码说的是：如果最终照片的高度比半屏高度要小，会产生样式问题，需要手动设置margin-top来处理。最终照片可能会产生压缩，如果
                    //是在y轴压缩不出现问题，如果在x轴压缩，需要计算压缩后图片的高度，然后再计算出margin-top的值
                    var marginTopNum = 0; //初始化需要调整的margin-top
                    var videoHeight = cameraPrepare.video.videoHeight;//video高度
                    var videoWidth = cameraPrepare.video.videoWidth;//video宽度
                    var videoRadio =videoWidth/videoHeight;//video 的宽高比
                    if(videoRadio-cameraPrepare.containerRadio>0){//图片宽高比比屏幕宽高比要宽（只有这种情况才会出现x轴压缩后样式问题）
                        if(videoWidth-cameraPrepare.containerWidth/2>0){//如果摄像头宽度比半屏宽度要大，则图片会x轴压缩
                            var picRealHeight = videoHeight/videoWidth*(cameraPrepare.containerWidth/2);//图片最终真实高度
                            marginTopNum = (cameraPrepare.containerHeight/2 - picRealHeight)/2;
                        }else{//图片不会x轴压缩
                            marginTopNum =(cameraPrepare.containerHeight/2 -videoHeight)/2;
                        }
                        for(var k=0;k<picNum;k++){
                            $($("#bigImageListContainer img")[k]).css("margin-top",marginTopNum+"px");
                        }
                    }else{ //屏幕宽高比 比摄像头宽高比要宽
                        //这时候只会产生y轴压缩，若图片y轴压缩则正常，若摄像头本身高度小于半屏高度，也会产生样式问题，需要手动处理
                        if(cameraPrepare.containerHeight/2-videoHeight>0){
                            marginTopNum = (cameraPrepare.containerHeight/2-videoHeight)/2
                            for(var l=0;l<picNum;l++){
                                $($("#bigImageListContainer img")[l]).css("margin-top",marginTopNum+"px");
                            }
                        }
                    }
                }
            }
        },

        //调整授课精灵传过来的图片位置
        /*
        * src:图片src
        * index:图片的index
        * type:单图、双图还是多图模式
        * */
        adjustPosition:function (src,index,type) {
            gm_ta(src,GMPath_E).size(function (err,size) {
                if (!err) {
                    var marginTop;
                    var radio = size.width / size.height;//图片的宽高比
                    switch(type){
                        case 'One':
                            //todo
                            // $("#test_img").css('height',"").css('width','')
                            // radio-cameraPrepare.containerRadio>0?$("#test_img").css('min-width','100%'):$("#test_img").css('min-height','100%')
                            // break;
                        case 'Two':
                            $("#bigImageListContainer div.item").height(cameraPrepare.containerHeight + "px");
                            var specContainerRadio = cameraPrepare.containerRadio * 2;//新的“两分屏”的宽高比
                            if(radio-specContainerRadio>0){//图片的宽高比 比 容器的宽高比要大;传入图片比较“宽”
                                //因为图片比四分屏“宽”，所以会最终图片宽度等于四分屏宽度，高度需要重新计算
                                var _realHeight = size.height/size.width * (cameraPrepare.containerWidth/2);
                                marginTop = (cameraPrepare.containerHeight-_realHeight)/2;//margin-top
                                $($("#bigImageListContainer").find('img')[index]).css('margin-top',marginTop).css("min-width",'100%')
                            }else{
                                $($("#bigImageListContainer").find('img')[index]).css("min-height",'100%')
                            }
                            break;
                        case 'Multi':
                            if(radio-cameraPrepare.containerRadio>0) {//图片的宽高比 比 容器的宽高比要大;传入图片比较“宽”
                                //因为图片比四分屏“宽”，所以会最终图片宽度等于四分屏宽度，高度需要重新计算
                                var realHeight = size.height/size.width * (cameraPrepare.containerWidth/2);
                                marginTop = (cameraPrepare.containerHeight/2-realHeight)/2;//margin-top
                                $($("#bigImageListContainer").find('img')[index]).css('margin-top',marginTop).css('min-width','100%');
                            }else{//传入图片比较“高”
                                $($("#bigImageListContainer").find('img')[index]).css("min-height",'100%')
                            }
                            break;
                    }

                }
            })
        },

        //在设置多图展示的css样式前，先将css样式设置为初始值
        reSetCssOption:function () {
            //设置图片预览界面 图片的高度
            $("#bigImageListContainer div.item").height(cameraPrepare.containerHeight / 2 + "px");
            $("#bigImageListContainer").find('img').css('min-height','').css('min-width','').css('margin-top','');
        }

    })
    window.previewPicVM =previewPicVM;

    //切换摄像头确认弹框VM
    var switchCameraVM = avalon.define({
        $id:"switchCameraVM",
        showPop:false,
        //确定切换摄像头
        confirm:function () {
            cameraPrepare.context.clearRect(0,0,1920,1080);
            photographVM.takePicture = true;//展示拍照按钮
            //设置当前选中摄像头
            _curVideoSource=$("#cameraList").val();
            switchCameraVM.showPop = false;
            photographVM.photoArr.map(function (el) {
                el.src="";
            });
            photographVM.curPhotoIndex=0;
            photographVM.forbidTakePicture = true;//置灰拍照按钮
            photographVM.existPic = false;//置灰预览按钮
            cameraPrepare.getUserMedia();
        },
        //取消切换摄像头
        cancel:function () {
            $("#cameraList").val(_curVideoSource);
            switchCameraVM.showPop = false;
        }
    });
    window.switchCameraVM = switchCameraVM;

    avalon.scan();
//-----------------------------------下方写watch函数，jq函数等-----------------------------------------------------
    //监听当前照片下标
    photographVM.$watch("curPhotoIndex",function(newVal,oldVal){
        if(photographVM.photoArr[photographVM.curPhotoIndex].src){//如果有src，展示“重新拍照按钮”，展示图片
            photographVM.takePicture = false;
            //因为src过长，拖拽会导致nw.js崩溃，所以我把拖拽禁了，如果需要拖拽，需要改
            photographVM.showPicSrc = photographVM.photoArr[photographVM.curPhotoIndex].src;
            // photographVM.showPicSrc ="D:/pdf Demo/16本正式教材底图/英语/上教英语3A（修订）/英语3A (4).jpg"
        }else{//反之展示“拍照按钮”
            photographVM.takePicture = true;
            photographVM.showPicSrc = "";
        }
    })


    //选中下拉框，切换摄像头
    $("#cameraList").change(function (oldValue,newValue) {
        var existPicArr = photographVM.photoArr.filter(function (el) {
            if(el.src){return el};
        });
        if(existPicArr.length>0){
            //一开始设置为display=none，是为了防止加载过程中闪现弹框
            if($("#confirmpop").css('display')=='none'){
                $("#confirmpop").show();
            }
            switchCameraVM.showPop=true;//展示弹框
        }else{
            _curVideoSource=$("#cameraList").val();//设置当前选中摄像头
            photographVM.forbidTakePicture = true;//置灰拍照按钮
            cameraPrepare.getUserMedia();//获取输入流
        }
    });

})