﻿/**
 * SmartBook入口模块
 */
define(function (require, exports) {
    require('lab');
    require('jquery');
    require('xml2json');
    require('jquery_ui');
    require('pagination');
    require('browserContext');
    require('./app/book/pageitem');
    var path = require('./common/path');
    var confirmExit = require('./common/confirmExit');
    var _define = require('./app/define');
    var ebookContext = require('./app/ebookcontext').Instance;
    var trace = require('./app/trace').Instance;
    var actionType = require('./app/trace').ActionType;
    var shellcmd = require('./common/shellcmd');
    var bookAccessor = require('./app/bookshelf/bookaccessor').Instance;
    var userLog = require('./app/logmgr').Instance;
    var userData = require('./common/userdata').Instance;
    var indexhelper = require("./indexhelper");
    var snapShot = require('./app/book/toolbar/snapShot').Instance;
    var monitorInfo = require('./common/MonitorInfo').Instance;
    var guidCreate = require('./common/guid').Instance;
    var recordLesson = require('./app/book/toolbar/recordlesson').Instance;
    var homework = require('./app/book/homework/homework').Instance;
    var ibWSLogic = require("./ibWSLogic");
    var bookShelfHelper = require('./bookshelfhelper');
    var QQService = require('./common/QQService').QQService;
    var _ktsl = require('./app/book/toolbar/ktsl');
    var ibHPLogic = require("./ibHPLogic");
    var importMtbkRes = require('./app/book/importexport/importmtbk').Instance;


    /** @type {BookContainer} */
    var _bookContainer;

    /** @type {CanvasManager}*/
    var canvasManager, BlackBoard, mainToolbar, sideToolbar, CardWrapper, smartBar, ResBar;

    //是否正在编辑模式
    var isEditing = true;
    var isWB = false;
    //20150116 此字段用于区分是否显示change
    var isWB2 = "";

    $(function () {
        if(gui.App.argv && gui.App.argv[0]){
            indexhelper.setTaUrl(gui.App.argv[0]);
            console.log("%c首页加载参数:%s","background-color:rgb(90,192,90);",gui.App.argv[0]);
            gui.App.argv[0] = "";
        }

        var browserWidth = Config["Width"];
        var browserHeight = Config["Height"];
        // 是留给下面工具条的高度
        // var viewHeight = browserHeight - $('#mainToolBar').height() - $('#header').height() - 10;
        var viewHeight = browserHeight - $('.J_nav').height() - $('#header').height() - 10;
        //这里我们假设所有屏幕都是高小于宽
        var scale = correctToBaseResolution();
        //var viewWidth = browserWidth - $("#leftToolbar").width() * scale[0] - $('#rightToolbar').width() * scale[0];
        //左右预留5px空白
        var viewWidth = browserWidth - $(".J_resource_center_bar").width() * scale[0] - 10;
        // var viewWidth = browserWidth - $(".J_resource_center_bar").width() * scale[0];
        var $book = $("#book");
        var bookContainerEle = $('#bookContainer');
        var $bookwarp = $("#bookwarp");
        $bookwarp.css("minHeight", viewHeight + "px");
        // $bookwarp.css("margin-left",$("#leftToolbar").width());
        // $bookwarp.css("margin-left",$(".J_resource_center_bar").width());
        if (browserWidth < 1000) {
            // $book.css("width", (viewWidth + 10) + "px").css("height", viewHeight + 'px');
            $book.css("width", viewWidth + "px").css("height", viewHeight + 'px');
            bookContainerEle.css({
                width: viewWidth + 'px',
                height: viewHeight + 'px'
                // marginLeft: '5px'
            });

            $bookwarp.css("marginLeft", "45px").css("marginRight", "45px").css("minHeight", viewHeight - 24 + "px");
            $("#rbarWarp").css("width", "45px");
            $("#lbarWarp").css("width", "45px");
            $("#btnMoveMenuBar").css("bottom", "-20px");
        }
        else {
            bookContainerEle.css({
                // width: (viewWidth - 10 ) + 'px',
                width: viewWidth + 'px',
                height: viewHeight + 'px'
                // marginLeft: '5px'
            });
            $book.css("width", viewWidth + "px").css("height", viewHeight + 'px');
        }
        // $("#smartbar").show();

        bookShelfHelper.StartMonitor();
        bookShelfHelper.changeFloatBarBtnCfg();
        bookShelfHelper.StartFloatToolBar();
        bookShelfHelper.mtbkIconRegist('HKEY_CLASSES_ROOT' , 'mtbkfile' , '' , '.mtbk' , 'share/res/MTBK.ico' , 'iFlybook授课文件');

        var downloadQueue = require("./common/downloadmgr").DownloadQueueMgr;
        setGlobalDownloadMgr(downloadQueue);

//        setTimeout(function(){
//            showLoading({tips: AppBlackBoardTipsList.Loading});
//        },0);

        var playerMgr = require('./app/book/hotspot/playerMgr').Instance;
        var pageProvider = require('./app/book/pageprovider').Instance;
        var firstload = indexhelper.QueryString("firstload"); //判断是否为第一次打开书本
        var bookCode = indexhelper.QueryString("bookCode");
        var curUser = decodeURIComponent(indexhelper.QueryString("user"));
        var pwd = indexhelper.QueryString("pwd");
        var ticket = indexhelper.QueryString("ticket");
        var points = indexhelper.QueryString("points");
        var books = indexhelper.QueryString("books");
        var phone = indexhelper.QueryString("phone");
        var province = indexhelper.QueryString("p");
        var uid = indexhelper.QueryString("uid");
        var userName = decodeURIComponent(indexhelper.QueryString("userName"));
        var userLoginName = decodeURIComponent(indexhelper.QueryString("userloginname"));
        var isOnline = !!(indexhelper.QueryString("isonline") == 'true');
        var isActive = !!(indexhelper.QueryString("isactive") == 'true');
        var pageIndex = parseInt(indexhelper.QueryString('pageIndex'));
        var loginFrom = indexhelper.QueryString("LoginFrom");
        var isU = indexhelper.QueryString("isU");
        var isWB = indexhelper.QueryString("isWB");
        var SSOTicket = indexhelper.QueryString("SSOTicket");

        var classId = indexhelper.QueryString("classId");
        var role = indexhelper.QueryString("role");
        var userAppName = indexhelper.QueryString("userAppName");
        var unit1 = indexhelper.QueryString("unit1");
        var unit2 = indexhelper.QueryString("unit2");
        var unit3 = indexhelper.QueryString("unit3");
        var unit4 = indexhelper.QueryString("unit4");
        var unit=indexhelper.QueryString("unit") || "";
        var bookStatus=indexhelper.QueryString("bookStatus");
        var isOpenTeachingPackage = indexhelper.QueryString("isOpenTeachingPackage");

        var menuObj = {unit1:unit1,unit2:unit2,unit3:unit3,unit4:unit4};
        //设置当前书本第几页
        ibWSLogic.setCurrentBookCode(bookCode);

        isWB2 = isWB;

        indexhelper.setTime();
        setInterval(indexhelper.setTime, 5000);
        LAN = null;
        var langPath = Config.binPath + "webapp/assert/js/lang/" + AppCfg.lang + "/index.json";
        var lanpack = null;
        shellcmd.readFileAsync(langPath).done(function (ret) {
            lanpack = JSON.parse(ret);
            if (AppCfg.lang == "uyghur") {
                var Uycss = {
                    fontFamily: "ALKATIP Basma"
                }
                LAN = new Lang(lanpack, Uycss);
            }
            else {
                LAN = new Lang(lanpack, {});
            }

            userData.init();
            curUser = curUser ? curUser : AppCfg.testUser;
            bookCode = bookCode ? bookCode : AppCfg.testBook;

            trace.log('ebook', actionType.SetBook, {bookCode: bookCode});

            ebookContext.setBinPath(Config.binPath);
            ebookContext.setWBEB("EB");
            ebookContext.setIsU(isU);
            ebookContext.setUser(curUser, pwd);
            ebookContext.setBookCode(bookCode);
            ebookContext.setUserBaseInfo(uid, "", phone, userName, province);
            ebookContext.setUserExtInfo(ticket, isOnline, isActive, userLoginName, loginFrom, points, SSOTicket, books);

            ebookContext.setUserClassId(classId);
            ebookContext.setUserRole(role);
            ebookContext.setUserAppName(userAppName);

            var sndPlayer = playerMgr.createPlayer(_define.PlayerType.AudioPlayer);
            sndPlayer.init($('#player'));
            setGloabalContextPlayer(playerMgr);
            pageProvider.setPlayer(playerMgr.createPlayer(_define.PlayerType.HotspotPlayer), sndPlayer);

            // 初始化课本容器
            _bookContainer = initBookContainer(bookContainerEle);
            // 初始化画布
            var canvasMgr = initPaintCanvas(_bookContainer);

            // 初始化工具栏
            // 初始化主工具栏结束之后初始化幕布,工具箱，模板
            // 等课本初始化之后再去初始化目录，页面预览（否则拿不到目录信息）资源库，搜索面板（优化体验）
            initToolbar(_bookContainer, canvasMgr, pageIndex, bookCode);

            //插入cards模板
            if ($("#openFileDialog").parent().next().length == 0){
                insertCardTemplate();
            }

            var iFlyMouse = require('./iFlyMouse');
            iFlyMouse.init(_bookContainer);
            iFlyMouse.registerEvent();

            var cardWrapper = require('./app/card/cardwrapper');
            CardWrapper = cardWrapper.Instance;
            CardWrapper.init("cardWrapper", "siderbar_left", "siderbar_right", "pic_zoomin", "pic_zoomout");
            //聚焦初始化
            var surfaceTool = require('./app/paint/surfacetool');
            var SurfaceTool = surfaceTool.Instance;
            SurfaceTool.init(_bookContainer);

            indexhelper.setIatPanelPos();
            
            $.when(loadBook(bookCode, pageIndex, isWB, menuObj).done(function () {
                console.log("index.js:index->loadBook callback begin");
                //记录书本使用时间，取消‘新’字段
                bookAccessor.updateBookUseDate(bookCode, ebookContext.getUser()).done(function(){
                    //书本时间更新完成后，刷新TA首页显示
                    var json = {
                        type   : "logic",
                        action : "refreash_ta_book",
                        from   : "ib",
                        to : "main"
                    };
                    socket.send(json);
                });
                //写日志，记录书号
                userLog.init();
                userLog.addUsedBook(bookCode);
                //初始化目录导航
                sideToolbar.initnavigator(_bookContainer);
                //初始化退出按钮
                confirmExit.init(_bookContainer, canvasManager);
                //初始化资源展示
                ResBar = require('./app/book/resbar/resbar').Instance;
                ResBar.init(_bookContainer);
                isWB && changeWBEB();

                if (curUser == AppCfg.defaultuser) {
                    var userLogin = require("./app/login/loginmgr").Instance;
                    userLogin.initDOM(), userLogin.bingEventsToDOM(), setGlobalLoginMgr(userLogin);
                }

                //若第一次打开书本，则启动上传器
                if(firstload){
                    var ebookuser = ebookContext.getUser();
                    bookShelfHelper.StartUpload(ebookuser);
                }
                if(isOpenTeachingPackage == "true"){
                    app_global_statics = {
                        statics:true
                    };
                    $("#J_teaching_package").trigger("click");
                }else {
                    app_global_statics = {
                        statics:false
                    };
                }
                LAN.refreshUI();
                // 打开书本，检测书本资源是否已导入
                setTimeout(function(){
                    importMtbkRes.firstImportMtbkCheck(bookCode);
                },10);
            })).done(function () {
                // $(document).trigger("firstImportMtbk");
            });

        });

        if (Config.Width < 950) {
            $("#main td").css("padding-left", "50px");
        }

        //禁用拖放打开本地文件操作
        var commonfunc = require("./common/commonfunc");
        commonfunc.disabledDropLocalFiles();

        $("body").keydown(function (e) {
            //如果type存在，则是text节点
            //反之是body，如果发现问题，再处理
            if (e.which == 8 && (!e.target.type)) {
                return false;
            }
            //屏蔽Alt+X热键（这里屏蔽了Alt键）
            if (e.which == 18 && (!e.target.type)) {
                return false;
            }
        });

        //禁用flash的右键
        $(document).bind("mousedown", function (e) {
            if (e.button === 2 ) {
                if($('#'+ e.target.id).parent().attr('id') == 'preview_office'
                    || $(e.target.offsetParent).attr('id') == 'smartbar_preview'){
                    e.preventDefault();
                }
                if($(e.target).parent().parent().attr('id') == 'cardWrapperDiv'){
                    e.preventDefault();
                }

            }
        });

        //复制empty.exe文件
        loadClearMemory();

        //监管平台
        var session_id = guidCreate.guid(32);
        var session_id_trigger = guidCreate.guid(32);
        var monitorMessage = '';
        var monitorMessage_trigger = '';
        var uid = ebookContext.getUser().getUid();
        uid = uid == "0" ? "" : uid;
        if (isWB != true) {
            monitorMessage = 'entry|||' + session_id + '|{"module":02 , "user_id":' + uid + '}';
            monitorInfo.addMonitorInfo('02', session_id);
            shellcmd.MonitorSend(monitorMessage);
            monitorMessage_trigger = 'trigger|||' + session_id_trigger + '|{"module":02,"param":"entryEbook","user_id":' + uid + '}';
            shellcmd.MonitorSend(monitorMessage_trigger);
            console.log('entry电子书:' + session_id);
            console.log('entry电子书_trigger:' + session_id_trigger);
        }

        var pluginMgr = require("./app/plugins/pluginsmgr").Instance;
        pluginMgr.init();
        setGlobalPluginMgr(pluginMgr);


//        var PluginChineseTest = require("./app/plugins/pluginitem/chinesetest/chinesetest.js").PluginChineseTest;
//        var chineseTest = new PluginChineseTest();
//        $("#header").click(function(){
//            chineseTest.init();
//            chineseTest.startOpen();
//        })

//        var PluginChineseTest = require("./app/plugins/pluginitem/chinesetest/chinesetest.js").PluginChineseTest;
//        var chineseTest = new PluginChineseTest();
//        chineseTest.init();
//        chineseTest.startOpen();

//        var PluginEnglishTest = require("./app/plugins/pluginitem/englishtest/englishtest.js").PluginEnglishTest;
//        var englishTest = new PluginEnglishTest();
//        englishTest.init();
//        englishTest.startOpen();

     //   pluginMgr.openPlugin("snapshot");

     //   pluginMgr.OpenCall()
    //    setTimeout('App_p.receiveMsgTOTA("open","64")',5000);
    });

    function initBookContainer(bookContainerEle) {
        var bookContainerModule = require('./app/book/container');

        //在书本上操作的时候，先隐藏目录导航
        bookContainerEle.mousedown(function () {
            $("#directory_box_right").hide();
            $("#directory_box_left").hide();
            $("#localResId").hide();
            $("#localResNoneId").hide();
            //隐藏资源荐下拉框
            $(".J_recommend_submenu").hide();
            // 点击课本空白区域关闭资源预览框
            if(!$('#smallPreviewviewBox').is(":hidden")){
                $('#smallPreviewviewBox').hide();
            }
        });

        var bookContainer = new bookContainerModule.BookContainer(bookContainerEle, confirmExit);

        var saveStroke = function () {
            //笔迹有改变，才保存
            if (canvasManager.getStrokeCanvas()) {
                if (canvasManager.getIsStrokeChanged()) {
                    canvasManager.drawStrokeCanvasToBookContainer();
                }
                $("#pen_canvas").hide();
            }
        }

        var rePaintStroke = function () {
            //不在鼠标状态时，翻页时才需要把笔迹重绘到全局canvas并显示全局canvas
            //否则只需要显示pageItem的canvas即可(这一步已经在pageItemload的时候做了)
            if (!canvasManager.isMouseMode()) {
                if (canvasManager.getStrokeCanvas()) {
                    canvasManager.restoreStrokeFromBookContainer();
                }
            }
            //翻页后需设定canvasManager的isStrokeChanged属性为false，这样防止连续翻页时笔迹没变也保存到本地
            canvasManager.setIsStrokeChanged(false);
            //编辑状态下，隐藏笔迹
            //if (isEditing) {
            //    _bookContainer.hidePageItemCanvas();
            //}
        }
//翻页之前，编辑状态为false？？
        $(bookContainer).bind('beforePageChange', function (e, indexInfo) {
            saveStroke();
            if(mainToolbar.getIsHavingClass()){
                isEditing = false;
                smartBar.setIsEditing(false);
            } else {
                isEditing = true;
                smartBar.setIsEditing(true);
            }
            smartBar.closeSmartBar();
            localResMgr.hideLocalResPanel();
            // 点击课本空白区域关闭资源预览框
            if(!$('#smallPreviewviewBox').is(":hidden")){
                $('#smallPreviewviewBox').hide();
            }
        })

        $(bookContainer).bind('pageChanged', function (e, indexInfo) {
            var canvasmgr = require('./app/paint/canvasmgr').Instance;
            rePaintStroke();

            try{
                if(indexInfo && indexInfo.newIndex){
                    var lessonName = '';
                    var pageMetadata = _bookContainer.getPageMetadata(indexInfo.newIndex);
                    if(pageMetadata){
                        if(pageMetadata.unit4 != ''){
                            lessonName = pageMetadata.unit4Name || '';
                        }else if(pageMetadata.unit3 != ''){
                            lessonName = pageMetadata.unit3Name || '';
                        }else if(pageMetadata.unit2 != ''){
                            lessonName = pageMetadata.unit2Name || '';
                        }else if(pageMetadata.unit1 != ''){
                            lessonName = pageMetadata.unit1Name || '';
                        }
                        if(lessonName){
                            lessonName = lessonName + '_';
                        }
                    }
                    var title= _bookContainer.bookMetaInfo.title;
                    document.getElementById("bookTitle").innerHTML = lessonName + title;
                }
            }catch(e){
                console.error(e);
            }

            //加载手势
//            this.getPageViewType() === _define.PageViewType.WhiteBoardView && ($("#btnPen").click());
            //这句写在上一句的后面是为了纠正鼠标指针的显示错误   ---  by  yczhu
            // smartBar.openClose();
            smartBar.returnInit();
            if(mainToolbar.getIsHavingClass()){
                isEditing = false;
                smartBar.setIsEditing(false);
            } else {
                isEditing = true;
                smartBar.setIsEditing(true);
            }

            canvasmgr.restoreStrokeFromBookContainer();
            var click = global_user_clicks.pop();
            if(click == 'mouse'){
                $('#btnMouse').click();
            }else if(click == 'eraser'){
                $('#btnEraser').click();
            }else if(click == 'pen'){
                $('#btnPen').click();
            }else if(click == 'r_eraser'){
                // $('#btnRightEraser').click();
            }else if(click == 'r_pen'){
                // $('#btnRightPen').click();
            }
            // 点击课本空白区域关闭资源预览框
            if(!$('#smallPreviewviewBox').is(":hidden")){
                $('#smallPreviewviewBox').hide();
            }
//            global_user_clicks = [];
//            e.preventDefault();
//            e.stopPropagation();
            //切换页面时请求资源工具栏数据
            // var ResBar = require('./resbar/resbar').Instance;
            if(typeof ResBar != "undefined"){
                ResBar.refreshbyLabel();
            }
            var win = gui.Window.get();
            win.focus();
        });

        $(bookContainer).bind('beforeBookViewChange', function (e, bookViewInfo) {
            //笔迹有改变，才保存
            saveStroke();
            isEditing = false;
            smartBar.closeSmartBar();
            localResMgr.hideLocalResPanel();
            //书本加载完毕，修正背景颜色
            bookContainerEle.css({backgroundColor: "#fff"});
        })

        $(bookContainer).bind('bookViewChanged', function (e, bookViewInfo) {
            rePaintStroke();
            // 点击课本空白区域关闭资源预览框
            if(!$('#smallPreviewviewBox').is(":hidden")){
                $('#smallPreviewviewBox').hide();
            }
         //   _teachingpackage.getWidgets();

            //加载手势
            this.getPageViewType() === _define.PageViewType.WhiteBoardView && (/*$("#btnPen").click(),*/
                bookContainerEle.css({backgroundColor: AppCfg.wbcolor}),isWB2 = 0);

            //下面代码原来做查看时，给出的引导，现在不用，注释掉

//            if (!isWB2 && AppCfg.showLastChange && this.getPageViewType() != _define.PageViewType.WhiteBoardView ) {
//
//                var h0 = $("#header")[0].offsetHeight;
//                var h1 = $("#mainToolBar")[0].offsetHeight;
//                var $leftToolbar = $("#leftToolbar");
//                var h00 = parseInt($leftToolbar.css("padding-top"));
//                var h001 = parseInt($leftToolbar.css("margin-top"));
//                var h2 = $(".mt10")[0].offsetHeight;
//                var h3 = $(".bt_line")[0].offsetHeight;
//                var h4 = $("#btnLocalResMgr")[0].offsetHeight;
//                var h = h0 + h1 + h2 + h3 + h00 + h001 - h4 - 30.8 + "px";
//                var $guide02 = $(".guide02");
//                var $guid_box = $(".guid_box");
//
//                $(".guide01").css("top", h);
//                $guid_box.show();
//                $guide02.show();
//                $guide02.click(function () {
//                    return false;
//                })
//                $guid_box.click(function () {
//                    //获取存放showLastChange值的文件路径fliepath，并读取到ff
//                    var fliepath = path.join(Config.binPath, "webapp/assert/js/appcfg.js");
//                    var ff = shellcmd.readFile(fliepath);
//                    //更改showLastChange值，并保存
//                    var ff2 = ff.replace("showLastChange : true,", "showLastChange : false,");
//                    shellcmd.saveFile(ff2, fliepath);
//                    $guid_box.hide();
//                    $guide02.hide();
//					AppCfg.showLastChange = false;
//                });
//            }

            //根据icw是否启动决定是否显示截取按钮
            var display = localStorage.getItem('btn_cut_pf') || '';
            var displayIcon = localStorage.getItem('btn_cut_pf_icon') || '';
            var $guide02 = $(".guide02");
            var $guid_box = $(".guid_box");

            if(display == 'true' && !isWB && this.getPageViewType() != _define.PageViewType.WhiteBoardView){

                $("#toICW").parent().css('width','980px').end().show();
                if(window.screen.availWidth == 1024){
                    $('#btnBookShelf').css('right','5px');
                    
                }
                var start = ($('#mainToolBar').width() - $('#eBookToolBar').width())*0.5;
                var delta = 622;
                var left = start+delta;
                var top = parseInt($('#header').height()) - 6 +3 ;
                $(".guide03").css("left", left +'px');
                $(".guide03").css("top", top +'px');

                $guid_box.show();
                $guide02.show();
                $guide02.click(function () {
                    return false;
                })
                $guid_box.click(function () {

                    $guid_box.hide();
                    $guide02.hide();
                    localStorage.setItem('btn_cut_pf','false');

                });
            }
            else{
                $guid_box.hide();
                $guide02.hide();
            }

            if(display == 'false' && displayIcon == 'true' && !isWB){//前两行刚设置
                $("#toICW").parent().css('width','980px').end().show();
            }

//            if(displayIcon == 'true'){
//                $("#toICW").show();
//            }else{
//                $("#toICW").hide();
//            }

            //这句写在上一句的后面是为了纠正鼠标指针的显示错误   -----  by  yczhu
            // smartBar.openClose();
            smartBar.returnInit();           
        });

        // 调试状态下暴露移动BookView的方法
        if (AppCfg.isDebug) {
            window.move = function (x, y) {
                _bookContainer.moveView({x: x, y: y});
            }
            window.bookContainer = _bookContainer;
        }
        setGlobalBookContainer(bookContainer);
        return bookContainer;
    }

    /**
     * 初始化工具栏
     * @param {BookContainer} bookContainer
     * @param {PaintCanvas} canvasMgr
     */
    function initToolbar(bookContainer, canvasMgr, pageIndex, bookCode) {
        // 初始化主工具栏
        mainToolbar = require('./app/book/toolbar/maintoolbar');
        mainToolbar.init({
            btnToggleHotspot: $('#btnToggleHotspot'),
            btnTogglePlay: $('#btnTogglePlay'),
            btnWaitplay: $('.btn-waitplay'),
            btnClearRes: $('#btnClearRes'),
            mainToolBar: $('#mainToolBar'),
            btnMoveMenuBar: $("#btnMoveMenuBar"),
            btnWBBlack: $("#WBBlack"),
            btnWBWhite: $("#WBWhite"),
            btnWBGreen: $("#WBGreen"),
            btnHavingClass: $("#J_having_class"),
            btnAfterClass: $("#J_after_class"),
            btnTeachingPackage: $("#J_teaching_package"),
            btnResCenter: $("#J_res_center")
        }, bookContainer, pageIndex, bookCode);

        setGlobalMainToolbar(mainToolbar);
        // 初始化侧边工具栏
        sideToolbar = require('./app/book/toolbar/sidetoolbar');
        var buttons = {
            btnLeftSwitchPageView: $('#btnLeftPageView'),       // 左侧切换书本视图按钮
            btnRightSwitchPageView: $('#btnRightPageView'),     // 右侧切换书本视图按钮
            btnLeftPrePage: $("#btnLeftPrePage"),               // 左侧上一页按钮
            btnLeftNextPage: $("#btnLeftNextPage"),             // 左侧下一页按钮
            btnRightPrePage: $("#btnRightPrePage"),             // 右侧上一页按钮
            btnRightNextPage: $("#btnRightNextPage"),           // 右侧下一页按钮
            btnZoomIn: $('#btnZoomIn'),                         // 页面放大按钮
            btnZoomOut: $('#btnZoomOut'),                       // 页面缩小按钮
            btnBookShelf: $("#btnBookShelf"),                     //书架按钮
            btnLBlackBoard: $('#btnBlackBoardLeft'),
            btnRBlackBoard: $("#btnBlackBoardRight"),
            WBL: $("#WBL"),                                    //左右黑板
            WBR: $("#WBR"),
            EBL: $("#EBL"),                                    //左右课本
            EBR: $("#EBR"),
            btnMuluR: $("#contentRight"),                      //左右目录
            btnMuluL: $("#contentLeft"),
            btnResShow: $("#btnLocalResMgr"),
            contentDrawerL: $(".drawer-left"),
            contentDrawerR: $(".drawer-right")
        };
        sideToolbar.init(buttons, bookContainer, canvasMgr, confirmExit, BlackBoard);

        var CloudresourceBase = require('./app/book/smartbar/cloudresourcebase');
        var resCloudresourceBase = require('./app/book/resbar/cloudresourcebase');
        smartBar = require('./app/book/smartbar/smartbar').Instance;
        localResMgr = require('./app/book/toolbar/localres').Instance;
        var webMtbkRes = require('./app/book/importexport/webMtbkImport');
        var smartBarEle = $("#smartbar");
        smartBar.init(bookContainer, smartBarEle);

        // setGlobalContextCloudresourceBase(new CloudresourceBase(bookContainer));
        setGlobalContextCloudresourceBase(new resCloudresourceBase(bookContainer));
        setGlobalwebMtbkImport(webMtbkRes);
    }

    function initPaintCanvas(bookContainer) {
        //全局画笔板擦声明与初始化
        var CanvasManager = require('./app/paint/canvasmgr');
        canvasManager = CanvasManager.Instance;
        canvasManager.init();
        //如果全局笔迹改变，则会保存到pageItem的canvas上后显示pageItem的canvas，否则直接显示pageItem的canvas
        $(canvasManager).bind('strokeChanged', function (e, StrokeCanvas, IsStrokeChanged, Strokes) {
            bookContainer.paintStroke(StrokeCanvas, IsStrokeChanged, Strokes);
        })

        $(canvasManager).bind('doEraser', function (e, l, t, w, h) {
            //第一个参数e表示事件本身
            bookContainer.doEraser(l, t, w, h);
        });

        $(canvasManager).bind('recognition', function (e, lan) {
            //第一个参数e表示事件本身
            bookContainer.recognition(lan);
        });

        $(canvasManager).bind('restoreStroke', function () {
            var viewDom = bookContainer.getViewDOM();
            var strokeCanvas = this.getStrokeCanvas();
            var tempCanvas = this.getTempCanvas();
            var w = viewDom.width();
            var h = viewDom.height();
            if (tempCanvas) {
                tempCanvas.attr({width: w, height: h});
            }
            if (strokeCanvas) {
                strokeCanvas.attr({width: w, height: h});
                // 恢复笔迹
                this.clearCanvas();
                bookContainer.restoreStroke(strokeCanvas[0], this);
            }

            viewDom.append(this.getCanvasContainer());
        });

        return canvasManager;
    }

    function changeWBEB(value) {
        if (value) {
            if (value == isWB) return;
            else isWB = value;
        }
        else isWB = !isWB;
        var uid = ebookContext.getUser().getUid();
        uid = uid == "0" ? "" : uid;
        if (isWB) {
            setBlackboardFlag(true);
            //监管平台
            var session_id = guidCreate.guid(32);
            var session_id_trigger = guidCreate.guid(32);
            var monitorMessage;
            var monitorMessage_trigger;
            monitorMessage = 'entry|||' + session_id + '|{"module":03 , "user_id":' + uid + '}';
            monitorInfo.addMonitorInfo('03', session_id);
            monitorMessage_trigger = 'trigger|||' + session_id_trigger + '|{"module":03,"param":"entryBlackboard","user_id":' + uid + '}';
            shellcmd.MonitorSend(monitorMessage);
            shellcmd.MonitorSend(monitorMessage_trigger);
            console.log('entry黑板:' + session_id);
            console.log('entry黑板trigger:' + session_id_trigger);

            session_id = monitorInfo.getSession_id('02');
            if (session_id != undefined) {
                monitorMessage = 'quit|||' + session_id + '|{"module":02 , "user_id":' + uid + '}';
                monitorInfo.deleteMonitorInfo('02');
                shellcmd.MonitorSend(monitorMessage);
                console.log('quit电子书:' + session_id);
            }
        }
        else {
            setBlackboardFlag(false);
            var session_id = guidCreate.guid(32);
            var monitorMessage;
            var session_id_trigger = guidCreate.guid(32);
            var monitorMessage_trigger;
            monitorMessage = 'entry|||' + session_id + '|{"module":02 , "user_id":' + uid + '}';
            monitorMessage_trigger = 'trigger|||' + session_id_trigger + '|{"module":02,"param":"entryEbook","user_id":' + uid + '}';
            monitorInfo.addMonitorInfo('02', session_id);
            shellcmd.MonitorSend(monitorMessage);
            shellcmd.MonitorSend(monitorMessage_trigger);
            console.log('entry电子书:' + session_id);
            console.log('entry电子书_trigger:' + session_id_trigger);

            session_id = monitorInfo.getSession_id('03');
            monitorMessage = 'quit|||' + session_id + '|{"module":03 , "user_id":' + uid + '}';
            monitorInfo.deleteMonitorInfo('03');
            shellcmd.MonitorSend(monitorMessage);
            console.log('quit黑板:' + session_id);
        }

        smartBar.closeSmartBar();
        localResMgr.hideLocalResPanel();
        mainToolbar.changeWBEB(isWB);
        sideToolbar.changeWBEB(isWB);
    }

    function bindCommands() {

        $('#WBL, #WBR, #EBL, #EBR')
            .click(function (e) {
                var usePen = ebookContext.getIsPenUse();
                if (usePen == true) {//如果有笔迹，则后台调用快照截图
                    // $(document).trigger("callSnapshot");
                }
                var thisDomId = $(this).attr('id');
                if(thisDomId=='WBL'){
                    //temp eshop监管 linwang5@iflytek.com
                    var staticParams = {
                        uid:ebookContext._curUser._uid,
                        module:'03017',
                        type:'trigger',
                        havingClass:_isHavingClass?1:0
                    };
                    edcService.Instance().api_eshop_baseStatics(staticParams);
                    //
                    //切换到黑板隐藏实物展台 --zqwie 2017-2-25 09:59:22
                    $("#btnCap").hide();
                }else if(thisDomId=='EBL'){
                    //temp eshop监管 linwang5@iflytek.com
                    var staticParams = {
                        uid:ebookContext._curUser._uid,
                        module:'03018',
                        type:'trigger',
                        havingClass:_isHavingClass?1:0
                    };
                    edcService.Instance().api_eshop_baseStatics(staticParams);
                    //切换到黑板隐藏实物展台 --zqwie 2017-2-25 09:59:22
                    $("#btnCap").show();
                }

                ebookContext.setIsPenUse(false);//画笔设置为未使用
                //调用iflyslide的黑板
               /* if(ebookContext.ifsBoard==true){
                    alert("黑板已打开并开始上课了");
                }else{
                    console.log("调用iflyslide的黑板");
                    var json={
                        type : "logic",
                        action : "goto_board",
                        from : "iflybook",
                        to : "all",
                        data : {
                            state: 1 // 从底部工具栏进入黑板是已上课状态
                        }
                    };
                    socket.send(json);
                }*/
                   changeWBEB();
                   $("#directory_box_right, #directory_box_left").css("display", "none");
                   $("#pluginpanel").hide();
                   $("#localResId").hide();
                   $("#localResNoneId").hide();
                    //隐藏资源荐下拉框
                    $(".J_recommend_submenu").hide();
                    //这两行是为了避免黑板过程中按‘esc’导致的切换回来，单双页显示不正确的问题
                    if(app_global_bookContainer.getPageViewType()=='2'){//双页模式
                        $("#btnLeftPageView [name='pageview_text']").html('单页');
                    }else if(app_global_bookContainer.getPageViewType()=='3'){//单页模式
                        $("#btnLeftPageView [name='pageview_text']").html('双页');
                    }

                   //这里是为了 在黑板界面为板擦时，回到电子书不能擦除，所有trigger一下 让重新绘制一下canvas 具体见canvasmgr.js 842行
                   //_drawStrokeCanvasToBookContainer();
                   //_restoreStrokeFromBookContainer(); --by linwang5 2015-12-28 god bless me.
                   setTimeout(function(){
                       if($('#btnEraser').hasClass('tool_current')&&isWB == false){
                           $('#btnEraser').trigger('click');
                       }
                       if($('#btnPen').hasClass('tool_current')){
                           $('#btnPen').click();
                       }
                       $("#btnMouse").trigger('click');
                   },500)

              /*  changeWBEB();
                $("#directory_box_right, #directory_box_left").css("display", "none");
                $("#pluginpanel").hide();
                $("#localResId").hide();
                $("#localResNoneId").hide();
                //这里是为了 在黑板界面为板擦时，回到电子书不能擦除，所有trigger一下 让重新绘制一下canvas 具体见canvasmgr.js 842行
                //_drawStrokeCanvasToBookContainer();
                //_restoreStrokeFromBookContainer(); --by linwang5 2015-12-28 god bless me.
                setTimeout(function(){
                    if($('#btnEraser').hasClass('tool_current')&&isWB == false){
                        $('#btnEraser').trigger('click');
                    }
                    if($('#btnPen').hasClass('tool_current')){
                        $('#btnPen').click();
                    }
                },500)*/

                e.stopPropagation();
                e.preventDefault();
            })
            .mousedown(function (e) {
//                if (!smartBar.editStatus) this.className = 'sidertool_current';
                e.stopPropagation();
                e.preventDefault();
            });
//
        //TODO : 这两行暂时放这里

//        $("#snapShot").click(function () {
//            snapShot.snap();
//        });
//
//        $("#recordLesson").click(function () {
//            recordLesson.recordlesson();
//        });

        //作业应用
        $("#btnZuoYe").click(function(){
//            alert('homework')
            homework.homework();
        })

        //还没完成的"白板"模块直接删掉了 ------ by yczhu
        $("#btnExitApp").click(function () {
            /*
            var bookLock=process.execPath.substring(0,process.execPath.lastIndexOf('\\')).replace(/\\/g,"/")+'/fb.lock';
            if(fs.existsSync(bookLock)){
                fs.unlinkSync(bookLock);
            }
            var isHavingClass=app_global_MainToolbar.getIsHavingClass();
            if(isHavingClass){
                $("#J_after_class").trigger("click");
                ebookContext.EndClassStyle=2;
            }else{*/
            $('#lessonRecord').attr('endStyle',2);
           _ktsl.afterOrLeave(function () {
                 // 王哒哒修改
                // confirmExit.ExitAlert();
                $("#btnBookShelf").click()
           });
                
            // }
        });

        $(document).on("ExitBook",function(){
       /*
       var bookLock=process.execPath.substring(0,process.execPath.lastIndexOf('\\')).replace(/\\/g,"/")+'/fb.lock';
            if(fs.existsSync(bookLock)){
                fs.unlinkSync(bookLock);
            }
            var endStyle=ebookContext.EndClassStyle;
            if(endStyle==3){*/
                WIN.restore();
            // }
            confirmExit.ForceExit();
        });

        WIN.on('close',function(){
            // var bookLock=process.execPath.substring(0,process.execPath.lastIndexOf('\\')).replace(/\\/g,"/")+'/fb.lock';
            // if(fs.existsSync(bookLock)){
            //     fs.unlinkSync(bookLock);
            // }
            // var isHavingClass=app_global_MainToolbar.getIsHavingClass();
            // if(isHavingClass){
            //     $("#J_after_class").trigger("click");
            //     ebookContext.EndClassStyle=3;
            // }else{
            $('#lessonRecord').attr('endStyle',3);
            _ktsl.afterOrLeave(function () {
                WIN.restore();
                confirmExit.ExitAlert();
            });
                
            // }
        });
        WIN.on('restore',function(){
            socket.send({"type":"logic","action":"floattoolbar_ib_max","from":"ib","to":"floatToolBar","data":""})
        });

        WIN.on('minimize',function(){
            socket.send({"type":"logic","action":"floattoolbar_ib_min","from":"ib","to":"floatToolBar","data":""})
        })

        $(window).on('realexit',function(){
            confirmExit.ForceExit();
        })

        $("#btnMinApp").click(function () {
            //sessionStorage['isBookMin']=true;
            app_global_screenSaversMgr && app_global_screenSaversMgr.setScreenSavers(false);
            app_global_playerMgr && app_global_playerMgr.pause();   //暂停音频资源播放
            shellcmd.ebookMin();
        });

        $("#btnGloQQService").click(function () {

            QQService(ebookContext.getUser().getUid());
//            shellcmd.openPageOutside('http://wpa.b.qq.com/cgi/wpa.php?ln=1&key=XzkzODAwMDQ4NF8zMDI3MzRfNDAwODg3ODU1N18yXw');
        });

        /**
         * 警告：该方法只是临时方法，其设计思路错误，只是为了效果的展示，后期有时间需要重构
         * 原因为 user-popover 为插件生成的固定class,这里对其('.user-popover').hide()是错误的，会引起不可预知的问题
         * 目前仅做了缩小范围的处理
         */
        $(document).on("click","#book",function(e){
            //点击课本空白区域关闭弹窗
            if(mainToolbar.getIsHavingClass()){
                //上课模式
                // $('#book').find('.jxbubble-box').hide();
                if(app_global_curWidget && app_global_curWidget.Content){
                    app_global_curWidget.Content.popover('hide','intro');
                }
                //如果画笔、板擦出于选中状态并且弹框出于显示状态，点击书本隐藏画笔、板擦的弹框
                if($("#eraserMenuBtn").hasClass("tool_current")&&$("#penEraserTool").css('display')!='none'){
                    $("#eraserMenuBtn").trigger('click');
                };
                if($("#penMenuBtn").hasClass("tool_current")&&$("#penEraserTool").css('display')!='none'){
                    $("#penMenuBtn").trigger('click');
                }
            }else{
                //下课模式
                // $("#book").find('.user-popover').hide();
                if(app_global_curWidget && app_global_curWidget.Content){
                    app_global_curWidget.Content.popover('hide','toolbar');
                }
            }

            //下面这段代码是“上课模式”点击书本时隐藏“授课包”那一栏，如果以后需求有变更放出来就好
            // //关闭上课模式左右授课包列表，控制左右关闭按钮方向
            // $(".drawer-left").find(".J_drawer_content").hide();
            // $(".drawer-right").find(".J_drawer_content").hide();
            //
            // if(!$("#J_teaching_package_rbtn").find(".J_hidden").is(":hidden")){
            //     $("#J_teaching_package_rbtn").find(".J_hidden").hide();
            //     $("#J_teaching_package_rbtn").find(".J_show").show();
            // }
            // if(!$("#J_teaching_package_lbtn").find(".J_hidden").is(":hidden")){
            //     $("#J_teaching_package_lbtn").find(".J_hidden").hide();
            //     $("#J_teaching_package_lbtn").find(".J_show").show();
            // }
        });

    }

    var win = gui.Window.get();

    $(document).on("setOnTop",function(){
        win.setAlwaysOnTop(true);
        setTimeout(function(){
            win.setAlwaysOnTop(false);
        },500);
    });

    win.on("focus",function(){
        $(document).trigger("setOnTop");
    });
    /**
     *
     * @param {string} bookCode
     * @param {int} pageIndex
     * @returns {*}
     */
    function loadBook(bookCode, pageIndex, WB,menuObj) {
        var def = $.Deferred();

        if (pageIndex === 'undefined' || pageIndex === undefined || !pageIndex) pageIndex = 1;

        try {
            if(pageIndex > -1){
                //原来流程
                _bookContainer.loadPage(bookCode, pageIndex).done(function () {
                    console.log("index.js:container->loadPage callback begin");
                    _bookContainer.switchPageView(_define.PageViewType.SimpleDoublePage).done(function () {
                        $(_bookContainer).trigger('bookViewChanged');
                        $(_bookContainer).trigger('pageChanged');

                        (!WB) && hideLoading();

                       // (!WB) && $("#loading_tip_pre").hide();
                        bindCommands();
                        def.resolve();
                    });
                });
            }else if(pageIndex == -1){
                //取得目录信息，然后跳转
                _bookContainer.loadPageByMenu(bookCode, menuObj).done(function () {
                    console.log("index.js:container->loadPageByMenu callback begin");

                    _bookContainer.switchPageView(_define.PageViewType.SimpleDoublePage).done(function () {
                        $(_bookContainer).trigger('bookViewChanged');
                        $(_bookContainer).trigger('pageChanged');

                        (!WB) && hideLoading();
                        bindCommands();
                        def.resolve();
                    });
                });
            }

        } catch (e) {
            console.error("---index load book error ---");
            hideLoading();
            bindCommands();

            $.Zebra_Dialog(AppBookShelfTipsList.OpenBookError, {
                'type': 'information',
                'title': AppTips.WarmTips,
                'buttons': [AppTips.OkTips],
                'onClose': function (capition) {
                    //这个时候需要清除内存中的该书本的LIC，并返回书架
                    ebookContext.getUser().getUserToken().done(function (token) {
                        var msg = {
                            licfile: path.trimPosix(ebookContext.getUser().getBookLicenseFullPath(bookCode)),
                            token: token
                        }
                        shellcmd.removeResLicFromMem(JSON.stringify(msg));
                        var _pageNavigatorHelper = require('./common/pagenavigatorhelper');
                        _pageNavigatorHelper.goToBookShelf(ebookContext.getUser());
                    })
                }
            });
            def.reject();
        }

        return def.promise();
    }

    function initScreenSavers() {
        app_global_screenSaversMgr = {};

        var _eventListener = function () {
            app_global_screenSaversMgr._leftTime = AppCfg.screenSaversTime;
        };

        app_global_playerMgr.bind('play', function () {
            app_global_screenSaversMgr && app_global_screenSaversMgr.setScreenSavers(false);
        }).bind('pause', function () {
            app_global_screenSaversMgr.setScreenSavers(true);
        }).bind('ended', function () {
            app_global_screenSaversMgr.setScreenSavers(true);
        });

        var _timerId = null, _triggerEvent = ['mousedown', 'mousemove', 'keydown'], _hasScreenSavers = false;
        /**
         * @param {boolean=} index 是否设置屏保
         */
        app_global_screenSaversMgr.setScreenSavers = function (index) {
            index = (index === undefined ? true : index);
            if (index) {
                if (AppCfg.screenSaversTime <= 0 || _hasScreenSavers) return;
                _hasScreenSavers = true;
                app_global_screenSaversMgr._isPause = false;
                app_global_screenSaversMgr._leftTime = AppCfg.screenSaversTime;

                _timerId = setTimeout(function () {
                    if (!app_global_screenSaversMgr._isPause) {
                        var self = arguments.callee;
                        if (app_global_screenSaversMgr._leftTime > 0) {
                            --app_global_screenSaversMgr._leftTime;
                            if (app_global_screenSaversMgr._leftTime <= 0) {
                                app_global_screenSaversMgr._leftTime = AppCfg.screenSaversTime;
                                //没有任何可见的iframe的情况下才允许进入屏保.
                                if (!$("iframe:visible").length) {
                                    CardWrapper.minimize();
                                    //进入黑板
                                    BlackBoard.enter();
                                }
                            }
                        }
                        _timerId = setTimeout(function () {
                            self();
                        }, 1000);
                    }
                }, 1000);

                for (var i = 0; i < _triggerEvent.length; ++i) {
                    document.addEventListener(_triggerEvent[i], _eventListener, true);
                }
            }
            else {
                app_global_screenSaversMgr._leftTime = AppCfg.screenSaversTime;
                app_global_screenSaversMgr._isPause = true;
                _hasScreenSavers = false;

                clearTimeout(_timerId);
                _timerId = null;
                for (var i = 0; i < _triggerEvent.length; ++i) {
                    document.removeEventListener(_triggerEvent[i], _eventListener, true);
                }
            }
        }
        shellcmd.isAppMin().done(function (ret) {
            !ret && app_global_screenSaversMgr.setScreenSavers(true);
        })

    }

    function initCfgDom() {
        loadConfig().done(function (configs) {
            console.log('mvvm init invoked');
            ko.applyBindings(configs);
        })
    }

    function loadConfig() {
        var def = $.Deferred();
        //这句是为了获取window对象
        var win = (function () {
            return this;
        })();

        if (AppVersionCfg.AppVersion !== AppVerCfg.BaseLine) {
            $LAB.script("assert/js/configs/" + AppVersionCfg.AppVersion + ".js").wait(function () {
                var prjConfig = win['AppVersionCfg' + AppVersionCfg.AppVersion];
                $.extend(true, AppVersionCfg, prjConfig);
                console.log(AppVersionCfg);
                def.resolve(AppVersionCfg);
            });
        }
        else {
            def.resolve(AppVersionCfg);
        }

        return def.promise();
    }

    function SocketLogic(){
        socket = nodereq('websocketclient')(window,'ib', function( event ){
            window.console.log("收到的信息内容::"+ event.data);
            if(!event) return;
            try{
                var receive = JSON.parse(event.data);
                ibWSLogic.ibWSLogic(receive);
            }catch (e){
                window.console.log(e);
            }
        });

        var json = {
            "type":"conn",
            "action":"list",
            "from":"ib",
            "to":"",
            "id":0,
            "data":""
        };

        socket.send(json);
    }

    function hproseLogic(){
        window.hproseClientSub(CONST_hproseClientName,function (message) {
            var _from = message.from;
            var _to = message._to;
            console.log('hproseClient[ib]客户端接收到了消息:\n');
            console.log(message);

            ibHPLogic.ibHPLogic(message);

        });
    }

    //拷贝empty.exe文件到temp文件下
    function loadClearMemory(){
        var tmpPath = ebookContext.getSysTmpPath() + "/empty.exe";
        var emptyPath = Config.binPath + "empty.exe";

        if(!shellcmd.isFileExistSync(tmpPath)){
            shellcmd.copyFile(emptyPath, tmpPath);
        }
    }

    //添加卡片资源模板，提供配置
    function insertCardTemplate(){
        var path = Config.binPath + "webapp/CardTemplate.html";
        var cards = "";

        if(!shellcmd.isFileExistSync(path)){
            cards = shellcmd.readFile(path);
            $("#openFileDialog").parent().after(cards);
        }
    }

    exports.initCfgDom = initCfgDom;
    exports.loadBook = loadBook;
    exports.SocketLogic = SocketLogic;
    exports.hproseLogic = hproseLogic;
})
