/**
 * 本文件依赖sso.min.js的window.RSAUtils方法,依赖Edc_Cfg配置（EDC_SSORSAExponent，EDC_SSORSAModulus）
 * 注意点：edc接口调用为用户级别授权，所以在调用接口前，需要通过setEncryptedUserInfo方法设置用户信息
 * @type {{Instance}}
 */
var edcService = (function() {
    var instance;
    function interface(){
        var _this = this;
        /**
         * 用户信息存储结构
         * @type {{loginName: string, des_encrypted_userInfo: string, rsa_encrypted_password: string, sso_openId: string}}
         * loginName-用户登录名  des_encrypted_userInfo-des加密后字符串 rsa_encrypted_password-rsa加密后字符串 sso_openId-用户的openId
         */
        _this.userInfo = {
            loginName: '',
            des_encrypted_userInfo: '',
            rsa_encrypted_password: '',
            sso_openId: ''
        };
        //edc鉴权属性名称
        _this.edcAttribute = {
            //缓存access_token的Name,默认为"access_token"
            cacheName : 'access_token',
            //应用属性名称，默认为"client_id"
            cacheId : 'client_id',
            //用户唯一标识
            userId: 'loginName',
            //鉴权类型 enum('client_credentials','password')
            grantType : 'password',
            //应用key
            appKey : Easy_Cfg.APPKEY,
            //应用secret
            appSecret : Easy_Cfg.SECRET,
            //应用baseUrl
            baseUrl : Easy_Cfg.EASYSVC,
            //应用oauth server url
            oauthTokenServer : Easy_Cfg.OAUTH_TOKEN_SERVER
        };
        //eshop鉴权属性名称
        _this.eshopAttribute = {
            baseUrl : Base_Cfg.ESHOP
        };
        //sso 鉴权属性名称
        _this.ssoAttribute = {
            appName : Edc_Cfg.EDC_appName,
            appKey : Edc_Cfg.EDC_appKey,
            ssoServerUrl : Edc_Cfg.EDC_SSOServerUrl,
            loginRedirectUrl : Edc_Cfg.EDC_loginRedirectUrl,
            client : Edc_Cfg.EDC_client,
            isCenterSSO : Edc_Cfg.EDC_isCenterSSO,
            needAttribute : Edc_Cfg.EDC_needAttribute
        };
        //access_token缓存
        _this.AccessTokenCache = [];
        //rsa加密模块
        _this.rsa = {
            exponent : Edc_Cfg.EDC_SSORSAExponent,
            modulus : Edc_Cfg.EDC_SSORSAModulus
        };
        //des加密模块
        _this.des = {
            key : 'wyc4yrmK'
        };
        var _path = require('path');
        //security.cr文件路径
        _this.security_cr_path = process.env.APPDATA + '\\iflytek\\security.cr';
        //用户信息文件
        _this.uli_dat_path = process.execPath.replace('nw.exe', 'uli.dat');
    }
    function httpRequest(url, options){
        var def = jQuery.Deferred();
        if ( typeof url === "object" ) {
            options = url;
            url = undefined;
        }
        options = options || {};
        var s = {
            url:window.location.href,
            type:"GET",
            timeout:"30000",
            async:true,
            cache:true,
            data:"",
            dataType:"json"
        };
        options.url = url || options.url || s.url;
        options.type = options.type || s.type;
        options.type = options.type.toUpperCase();
        options.timeout = options.timeout || s.timeout;
        options.async = options.async || s.async;
        options.cache = options.cache || s.cache;
        options.data = options.data || s.data;
        options.dataTpye = options.dataType || s.dataType;
        options.success = function(data){
            def.resolve(data);
        };
        options.error = function(e){
            def.reject(e);
        }
        jQuery.ajax(options);
        // jQuery.ajax(options).done(function(data) {
        //         def.resolve(data);
        //     }).fail(function(e){
        //         def.reject(e);
        // });
        return def.promise();
    }

    function parseParam(param, settings){
        if ( typeof settings != "object" ) {
            settings = {};
        }
        settings = settings || {};
        if ( typeof param === "object" ) {
            //解析特殊参数
            if(param && param["_forceRefresh"] == true){
                settings._forceRefresh = true;
                delete param._forceRefresh;
            }
            settings.data = param;
        }
        return settings;
    }

    function createUuid(){
        var s = [];
        var hexDigits = "0123456789abcdef";
        for (var i = 0; i < 36; i++) {
            s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
        }
        s[14] = "4";  // bits 12-15 of the time_hi_and_version field to 0010
        s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1);  // bits 6-7 of the clock_seq_hi_and_reserved to 01
        s[8] = s[13] = s[18] = s[23] = "-";

        var uuid = s.join("");
        return uuid;
    }
    interface.prototype = {
        ////// 网盘
        //获取与存储预上传信息 - unknow
        pan_file_prepare_add: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "pan.file.prepare.add",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //获取文件详情
        /*openId	True	String	无	openid
         fileId	True	String	无	文件id
         thumbSize	True	Enum	DEFAULT	缩略图大小，枚举（BIG，NORMAL，SMALL，DEFAULT）
         platForm	False	String	rrt_ewp	平台名称（cycore appname，且注册使用过文件存储服务）*/
        pan_file_detail: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "pan.file.detail",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        /**根据父文件夹、文件夹名获取文件夹id added by linwang5
         * openId
         * parentId
         * dirName
         * @returns {*}
         */
        pan_dir_id_get:function (param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "pan.dir.id.get",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        /**网盘创建文件夹id added by linwang5
         * openId
         * goalDirId
         * dirName
         * folder
         * isReadOnly
         * @returns {*}
         */
        pan_dir_create:function (param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "pan.dir.create",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 网盘文件索引上传 -good
        /*openId	True	String	无	openid
         goalDirId	True	String	无	目标文件夹id
         fileName	True	String	无	文件名
         aliasName	False	String	fileName	文件别名，默认为文件名
         description	False	String	无	文件描述
         extension	False	String	无	文件后缀
         contextId	False	String	无	文件服务contextid
         url	True	String	无	文件服务中文件下载地址
         md5	True	String	无	文件md5值
         length	True	long	无	文件长度
         status	False	int	无	文件上传状态
         token	False	String	无	文件服务上传返回token值
         platForm	False	string	rrt_ewp	文件服务使用的appname*/
        pan_file_uploadafter: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "pan.file.uploadafter",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取文件下载地址 -good
        /*openId	True	String	无	openid
         fileId	True	String	无	文件id列表
         expires	False	long	八小时	过期时间
         platForm	False	String	rrt_ewp	平台名称（cycore appname且在文件服务中申请过应用）*/
        pan_file_download_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "pan.file.download.get",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },

        // 获取文件下载地址 -good
        /*param ={
            md5: 	True	String		文件md5值
         }）*/
        pan_file_check: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "pan.file.check",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },

        // 多文件下载地址获取 -good
        /*openId	True	String	无	openid
         fileIds	True	String[]	无	文件id列表
         expires	False	long	八小时	过期时间
         platForm	False	String	rrt_ewp	平台名称（cycore appname且在文件服务中申请过应用）*/
        pan_files_download_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "pan.files.download.get",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取文件预览地址 -good
        /*openId	True	String	无	openid
         fileId	True	String	无	文件id列表
         platForm	False	String	rrt_ewp	平台名称（cycore appname且在文件服务中申请过应用）*/
        pan_file_preview_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "pan.file.preview.get",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //获取文件夹下文件/文件夹列表 - good
        /*openId	True	String	无	openid
         dirId	True	String	无	文件夹id
         coverDir	False	boolean	true	是否包含文件夹
         coverFile	False	boolean	true	是否包含文件
         page	False	int	1	分页
         limit	False	int	10	数量
         order	False	String	1	1：修改时间，2：名称，3：创建时间*/
        pan_children_directly: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "pan.children.directly",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // # 资源预上传 -good
        /*openId	True	String	无	用户登录返回的openId
         extension	True	String	无	文件的后缀名
         chunks	False	int	1	分片上传分片数(分片数为1不传)
         platForm	False	string	rrt_ewp	文件服务使用的appname
         callbackMethod	False	string	无	文件上传完回调方法
         callbackUrl	False	string	无	文件上传完回调地址
         callbackParams	False	string	无	文件上传完回调参数
         callbackProtocol	False	string	无	文件上传完回调方法*/
        pan_file_resource_prepare: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "pan.file.resource.prepare",
                version: "2.0",
                format: "json",
                platForm : Easy_Cfg.PLATFORM
            };
            param.random = Math.random(0,1);//因同时可能产生多个相同的请求，为防止url缓存问题，加一个随机数
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 完成文件上传接口 -good
        /*platForm : "", //prepare返回接口数据中的appKey
         contextId: "" //prepare接口中返回的contextId*/
        pan_file_upload_complete: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "pan.file.upload.complete",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        /**
         * 新增课堂实录
         * @param param 参数太多就不一一列举了 具体可参见 ktsl.js 中的 _SaveToService 方法
         * created by linwang5@iflytek.com 2016-09-22 14:45
         * @param settings
         * @returns {*}
         */
        ktsl_course_add:function (param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ktsl.course.add",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },

        ////// 中心云-用户

        // #查询用户信息 - good
        /*# key	True	String	无	用户唯一性属性，包括loginName、loginEmail、loginMobile、openId、id
         # value	True	String	无	属性值*/
        core_user_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.user.get",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //查询用户身份 - good
        /*userId	True	String	无	用户openId*/
        core_user_type_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.user.type.get",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //删除用户
        //批量查询用户信息 - good
        /*# key 	True 	String 	无 	用户唯一性属性，包括loginName、loginEmail、loginMobile、openId
         # values 	True 	String 	无 	属性值，多个用逗号隔开*/
        core_user_batch_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.user.batch.get",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //查询用户信息详情 - good
        /*openId	True	String	无	用户sso登录返回的openId
         userId	True	String	无	需要查询的用户openId
         userType	True	String	无	用户身份类型，001机构用户，002行政教师用户，003行政学生用户，004家长用户，005自由老师，006自由学生*/
        core_user_detail: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.user.detail",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //获取用户关系详情 - good
        /*openId 	True 	String 	无 	用户sso登录返回的openId
         userId 	True 	String 	无 	需要查询的用户openId*/
        core_user_org_detail: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.user.org.detail",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //创建用户
        //更新用户信息 - good -but 参数与描述不同
        /*# openId	True	String	无	用户sso登录获取的openId(使用用户sso登录返回的不对，需要使用用户openId)
         # userId	True	String	无	修改的用户openId
         # type	True	String	无	用户身份类型，001机构用户，002行政教师用户，003行政学生用户，004家长用户，005自由老师，006自由学生
         # userName	False	String	无	用户名(用于展示在页面上的)
         # loginName	False	String	无	用户登录名
         # loginEmail	False	String	无	登录邮箱
         # loginMobile	False	String	无	登录手机号
         # userEnName	False	String	无	英文名
         # gender	False	String	无	性别，字典，用字典接口查询type为gender的具体值
         # idCardNo	False	String	无	证件号，可存居民身份证、军官证等
         # idCardType	False	String	无	证件类型，字典，100080身份证，证件类型，用字典接口查询type为idCardType的具体值
         # pinyinName	False	String	无	拼音名
         # birthDate	False	String	无	生日，形如"1990-01-01 00:00:00"
         # im	False	String	无	其他通讯号，如QQ，阿里旺旺等
         # imType	False	String	无	及时通讯类型，字典，100340QQ，100341阿里旺旺
         # displayMobile	False	String	无	其他手机号
         # displayEmail	False	String	无	其他邮箱
         # teacherStaffNo	False	String	无	教职工编号，限行政教师用户
         # studentEnrollNo	False	String	无	学籍号，限行政学生用户
         # studentNo	False	String	无	学生班内学号，限行政学生用户*/
        core_user_update: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.user.update",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //用证件号查询用户
        //重置用户密码 -good
        /*openId	True	String	无	用户sso登录获取的openId
         userId	True	String	无	被重置密码用户的openId
         userPassword	True	String	无	重置后的密码，使用RSA加密，加密方式请联系管理员获取*/
        core_user_pwd_reset: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.user.pwd.reset",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 查询用户使用情况
        /*userId	True	String	无	用户openId*/
        core_user_usage: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.user.usage",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //获取用户头像上传信息
        //用学籍号查询学生用户
        //用教职工编号查询教师用户
        //获取用户内部id
        /*userId	True	String	无	用户openId
         userAppKey	True	String	无	用户openId对应的appKey*/
        core_user_inner_id_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.user.inner.id.get",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //批量创建用户
        //批量获取用户内部id
        /*userIds	True	String	无	用户openId，多个用逗号隔开
         userAppKey	True	String	无	用户openId对应的appKey*/
        core_user_inner_id_batch_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.user.inner.id.batch.get",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //用户修改密码 -check
        /*openId	True	String	无	用户sso登录返回的userID
         userOldPassword	True	String	无	用户旧密码，使用RSA加密，加密方式请联系管理员获取
         userNewPassword	True	String	无	用户新密码，使用RSA加密，加密方式请联系管理员获取*/
        core_user_pwd_update: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.user.pwd.update",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //查询用户是否存在 -unknow
        /*key	True	String	无	用户唯一性属性，包括loginName、loginEmail、loginMobile、openId
         value	True	String	无	属性值*/
        core_user_exist: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.user.exist",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //批量查询用户是否存在 - unknow
        /*key	True	String	无	用户唯一性属性，包括loginName、loginEmail、loginMobile、openId
         values	True	String	无	属性值，多个用逗号隔开*/
        core_user_batch_exist: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.user.batch.exist",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        ////// 中心云-公共接口

        // 获取字典列表 -good
        /*type	True	String	无	字典类型（phase|grade|system|gender）*/
        core_common_dic_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.common.dic.get",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 通过学制和学段获取年级字典列表 - good
        /*# phase	True	String	无	学段，用字典接口(core.common.dic.get)查询type为phase的具体值
         # eduSystem	False	String	无	学制，用字典接口(core.common.dic.get)查询type为system的具体值，默认值见注意事项2
         # 1. 学段和学制还可以参考学校的属性或者接口(core.common.phase.list、core.common.edu.system.list)
         # 2. 学制不填时，会根据学段取默认值，默认值如下：01幼儿园 01，02学前班 20，03小学 02，04初中 03，05高中 04*/
        core_common_grade_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.common.grade.list",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 通过学段获取学制信息列表 - good
        /*phase	True	String	无	学段，用字典接口(core.common.dic.get)查询type为phase的具体值*/
        core_common_edu_system_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.common.edu.system.list",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 通过学制获取学段信息列表 - good
        /*eduSystem	True	String	无	学制，用字典接口(core.common.dic.get)查询type为system的具体值*/
        core_common_phase_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.common.phase.list",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 按条件查询地区 - good
        /*# parentId	False	String	无	父级地区id
         # withAllChildren	False	bool	无	是：查找指定区域中所有的，否：只查询直属于指定区域下的
         # areaName	False	String	无	地区名称
         # page	False	int	1	分页信息，页数
         # limit	False	int	20	分页信息，每页数量*/
        core_common_area_query: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.common.area.query",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 根据区域id查询区域信息 - good
        /*areaId	True	String	无	区域id*/
        core_common_area_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.common.area.get",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 根据区域code查询区域信息 - bad -不清楚code的值是什么，查询地区接口没有返回code 字段
        core_common_area_get_code: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        ////// 中心云-学校

        // 查询用户的学校 -good
        /*param = {
         # userId	True	String	无	用户openId
         }*/
        core_school_list_user: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.school.list.user",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 根据条件查询学校内教师
        core_teacher_list_school: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 设置用户到学校
        core_school_set_user: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 查询学校中没有部门的教师
        core_teacher_list_school_no_dept: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 从学校删除用户
        core_school_remove_user: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 按条件查询学校
        core_school_query: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 查询学校内的学生
        core_student_list_school: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 学校创建自定义学科
        core_school_subject_create: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 修改学校自定义学科
        core_school_subject_update: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 学校添加系统学科
        core_school_subject_set: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 学校移除学科
        core_school_subject_remove: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 查询学校下的学科列表
        core_school_subject_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 查询学校下的学科
        core_school_subject_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },

        ////// 资源运营--基础信息服务
        // 获取资源类型 -good
        ersp_resource_metadata_type_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.metadata.type.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取标签列表 -good
        ersp_resource_metadata_label_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.metadata.label.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取教材列表 -good
        ersp_resource_metadata_book_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.metadata.book.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取教材详情
        ersp_resource_metadata_book_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.metadata.book.get",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取资源目录树相关的类别列表 -good
        ersp_resource_metadata_category_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.metadata.category.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取知识点树
        ersp_resource_metadata_knowledgeTree_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取卷库资源类型
        ersp_resource_metadata_testtype_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取学科列表
        ersp_resource_metadata_subject_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.metadata.subject.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取年级列表
        ersp_resource_metadata_grade_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取版本列表
        ersp_resource_metadata_edition_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.metadata.edition.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取学段
        ersp_resource_metadata_phase_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取出版社列表
        ersp_resource_metadata_publisher_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取册别列表
        ersp_resource_metadata_volume_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取教材目录
        /*bookCode  True    String  无   教材code*/
        ersp_resource_metadata_book_unit_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.metadata.book.unit.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },

        ////// 资源运营--资源服务

        // 获取资源列表 - good
        ersp_resource_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取单个资源详情 - good
        //此方法获得的数据缺少pamodel和exchargecredit字段，需要时使用api_ersp_resource_get_ext方法
        /*"id":resId,
         "autov":"false"*/
        ersp_resource_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.get",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取单个资源详情_ext - good
        //ersp_resource_get方法获得的数据缺少某些字段（paymodel，付费资源下载使用），需要时改用这个方法
        /*"id":resId,
         "autov":"false"*/
        api_ersp_resource_get_ext: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.list",
                version: "1.0",
                format: "json",
                ct: "3",
                cver: "4.0.3",
                thumbSize: "185_185",
                limit: "1"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 增加资源下载量 -good
        /*id	True	String	无	资源id*/
        ersp_resource_download_inc: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.download.inc",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取资源标签 -good
        /*id	True	String	无	资源id(官方文档不对，经验证，应为resId)*/
        ersp_resource_label_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.label.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 添加资源标签 - good
        /*id	True	String	无	资源id
         userId	True	String	无	用户id(内部id)
         labelId	True	String	无	标签id*/
        ersp_resource_label_add: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.label.add",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 新增资源评分 - good
        /*id	True	String	无	资源id
         score	True	int	无	评分*/
        ersp_resource_score_add: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.score.add",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 新增评论 - good
        /*# resourceId	True	String	无	资源id
         # uid	True	String	无	用户id
         # content	True	String	无	评论内容
         # toCommentId	False	Integer	无	被评论的评论id
         # toUid	False	String	无	被评论用户id(当为回复评论时该字段才必填(True))*/
        ersp_resource_comment_add: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.comment.add",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取资源评论列表 - good
        /*resourceId	True	String	无	资源id*/
        ersp_resource_comment_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.comment.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 按属性统计资源信息 -good
        ersp_resource_staticResource: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.staticResource",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 判断用户是否添加资源映象 - good
        /*# userId	True	String	无	用户id
         # resId	True	String	无	资源id
         # labelId	True	String	无	资源标签id*/
        ersp_resource_label_user_exist: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.label.user.exist",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 分享资源到资源网关 -good
        /*fileInfo	True	String	无	资源属性json串
         fileIndex	False	String	无	资源基本信息json
         auditStatus	False	String	无	0:未审核1:审核通过2:审核不通过,5:下架
         NOTE（以下参数尽量完整，文档上并不全；关于课本信息，可以考虑请求ersp.resource.metadata.book.get接口拉取完整的信息）:
         fileInfo:
         ---
         {
         "properties":{
         "rrtlevel1":["08"], #对应为topic，08同步精选
         "book":[fileInfo_book[0]],
         "edition":[fileInfo_edition[0]],
         "grade":[fileInfo_grade[0]],
         "phase":[fileInfo_phase[0]],
         "stage":[fileInfo_stage[0]],
         "subject":[fileInfo_subject[0]],
         "type":[fileInfo_type],（0100教案,0300素材,0400习题,0600课件）
         "unit1":[fileInfo_unit1],
         "unit2":[fileInfo_unit2],
         "unit3":[fileInfo_unit3],
         "unit4":[fileInfo_unit4],
         "volumn":[fileInfo_volumn[0]]
         },
         "extension":fileInfo_extension,
         "title":fileInfo_title,（不包含文件后缀名）
         "source":fileInfo_source,（填写 iflytek）
         "description":fileInfo_description,
         "uploader":fileInfo_uploader, # （如User1447418965887）
         "quality":fileInfo_quality, # 设置为20-普通资源
         "language":"zh-CN",
         "creator":fileInfo_creator,
         "action":"",
         "module":""
         "lifecycle":{
         "securitystatus":1,
         "auditstatus":1, # 不能为0，否则不能显示
         "dependencystatus":1 # 不能为0，否则不能显示
         }
         }
         ---
         fileIndex：
         ---
         {
         "md5":fileIndex_md5,//必传
         "filePath":fileIndex_filePath,//必传
         "length":fileIndex_length,//必传
         "filename":fileInfo_title, //文件名称 必传（不包含文件后缀）
         }
         ---
         */
        ersp_resource_importResourceInfo: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.importResourceInfo",
                version: "1.0",
                format: "json"
            };

            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取推荐资源topN
        ersp_resource_topn_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //获取资源下载地址 -good
        /*userId	True	String	无	用户id
         id	True	String	无	资源id*/
        ersp_resource_download_url: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.download.url",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //分享资源到中心，学校，班级(该接口用于支持资源信息不完整业务)
        ersp_resource_import_imperfect: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.import.imperfect",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //点赞接口 - good
        /*userId	True	String	无	用户id
         resId	True	String	无	资源id*/
        ersp_resource_point_add: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.point.add",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //#取消点赞 - bad
        /*# userId	True	String	无	用户id
         # resId	True	String	无	资源id*/
        ersp_resource_point_cancel: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.point.cancel",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取点赞人数列表 - good
        /*# resId	True	String	无	资源id
         # page	True	Integer	1	页码
         # limit	False	Integer	10	每页数量*/
        ersp_resource_point_user_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.point.user.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 删除资源评论 - bad
        // 删除资源(支持批量删除) - unknow
        // 获取资源列表(信息不完整资源信息，皆成使用) - unknow
        // 添加用户行为 - unknow
        // 查询局校平台资源 - unknow
        // 获取行为动态 - unknow
        // 支持获取其他平台资源 - good
        /*
         有两个参数是和ersp_resource_list不一样的，要注意，其他参数和使用方法一致。
         platform	False	String	无	中心资源平台标识
         appName	False	String	无	用户appName如果不为空则优先查询覆盖platform查询
         */
        ersp_resource_platform_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.platform.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取同步精选资源 -good
        /*id	False	Integer	无	数据库主键
         rid	False	String	无	同步精选唯一性标识
         book	False	String	无	教材code
         bookPage	False	Integer	无	教材页码
         resourceId	False	String	无	资源id
         resourceName	False	String	无	资源名称
         md5	False	String	无	资源md5值
         positionX	False	String	无	资源书本位置
         positionY	False	String	无	位置Y坐标
         createId	False	String	无	用户id
         createTime	False	Date	无	创建时间
         updateTime	False	Date	无	更新时间*/
        ersp_resource_perfect_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.perfect.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 删除同步精选资源记录 -good
        /*rid	True	String	无	同步精选唯一标识(支持逗号分隔)
         book	True	String	无	教材code*/
        ersp_resource_perfect_delete: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.perfect.delete",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 更新同步精选 -good
        /*rid	True	String	无	同步精选唯一性标识
         book	False	String	无	教材code
         bookPage	False	Integer	无	教材页码
         resourceId	False	String	无	资源id
         resourceName	False	String	无	资源名称
         md5	False	String	无	资源md5值
         positionX	False	String	无	资源书本位置
         positionY	False	String	无	位置Y坐标
         updateTime	False	Date	无	更新时间*/
        ersp_resource_perfect_update: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.perfect.update",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 新增同步精选 -good
        /*bookResourceJson	True	String	无	同步精选json串(见备注)*/
        ersp_resource_perfect_add: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.perfect.add",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },


////// 资源运营--积分服务

        //获取用户积分 -good
        /*userId	True	String	无	用户id*/
        ersp_resource_user_credit_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.user.credit.get",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 修改用户积分[记录用户行为] - good
        /*# userId    True    String  无   用户id
         # resId False   String  无   资源id
         # action    True    String  无   操作类型（download）
         # data  True    String  无   操作详情
         # score False   String  无   积分为加积分-为减积分(实际上需要为true)*/
        ersp_resource_user_credit_update: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.user.credit.update",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 判断用户是不是进行了某种操作（行为） -good
        /*action	True	String	无	操作类型如:download
         userId	True	String	无	用户id
         resId	False	String	无	资源id*/
        ersp_resource_user_credit_action: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.user.credit.action",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 判断用户是否已对某资源进行扣分 -good
        ersp_resource_user_credit_resourcePoint: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.resource.user.credit.resourcePoint",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },

        ////// 中心云-行政班级
        // 创建行政班级 -bad
        core_class_org_create: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "2.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 更新行政班级信息
        core_class_org_update: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 删除行政班级
        core_class_org_delete: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取学校内的行政班级
        core_class_org_list_school: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 查询教师在学校下的班级列表（行政班级）- good
        /*param_core_class_org_list_teacher_20160826 = {
         # userId	TRUE	String	无	用户openId
         # schoolId	TRUE	String	无	学校id
         # className	FALSE	String	无	班级名称
         # year	FALSE	int	无	入学年份
         # teacherType	FALSE	String	无	在班级的身份类型，默认：不限制，1：管理员身份，2：教师身份，其他：不限制
         # order	FALSE	String	无	排序方式，支持："create_time"按创建时间正序，"-create_time"按创建时间倒序
         }*/
        core_class_org_list_teacher: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.class.org.list.teacher",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 查询学生的行政班级
        core_class_org_list_student: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取行政班下的学生
        core_student_list_class_org: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 设置学生到行政班级
        core_student_set_class_org: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 从行政班中移除学生
        core_student_remove_class_org: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 查询班级下的授课老师
        core_teacher_list_class_org: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 设置老师到行政班级
        core_teacher_set_class_org: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 移除行政班教师
        core_teacher_remove_class_org: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 清空行政班级下成员
        core_class_org_clear: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 按条件查询行政班级授课信息
        core_class_org_teaching_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 从行政班级删除教师的授课学科
        core_class_org_teaching_remove: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //批量获取行政班级的学生数
        core_class_org_count_student:function (param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.class.org.count.student",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },

        ////// 中心云-自由班级
        // 用户创建自由班级 - good
        /*openId	True	String	无	用户sso登录返回的openId
         # className	True	String	无	班级名称
         # schoolId	False	String	无	学校id
         # phase	False	String	无	学段，字典，用字典接口查询type为phase的具体值
         # grade	False	String	无	年级，字典，用字典接口查询type为grade的具体值
         # year	False	int	无	入学年份*/
        core_class_free_create: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.class.free.create",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 删除自由班级 -checked badss
        core_class_free_delete: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "2.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 更新自由班级
        core_class_free_update: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 查询教师所在自由班级 - good
        // param_core_class_free_list_teacher_20160826 = {
        //     # userId	True	String	无	教师用户openId
        //     # className	False	String	无	班级名称
        //     # year	False	int	无	入学年份
        //     # order	False	String	无	排序方式，支持："create_time"按创建时间正序，"-create_time"按创建时间倒序
        // }
        core_class_free_list_teacher: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.class.free.list.teacher",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 查询学生所在自由班级
        core_class_free_list_student: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 查询自由班级下的授课老师
        core_teacher_list_class_free: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 设置教师到自由班级
        core_teacher_set_class_free: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 移除自由班级教师
        core_teacher_remove_class_free: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 查询自由班级下学生
        core_student_list_class_free: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 设置学生到自由班级
        core_student_set_class_free: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 从自由班级中移除学生
        core_student_remove_class_free: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 更新自由班级学生学号
        core_class_free_update_student: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 清空自由班级下成员 - checked ? 清空后班级也会被清除
        core_class_free_clear: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "2.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 按条件查询自由班级授课信息
        core_class_free_teaching_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 从自由班级删除教师的授课学科
        core_class_free_teaching_remove: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 自由班级添加一个教师（添加失败返回详细错误码）
        core_class_free_add_teacher_single: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 自由班级添加一个学生（添加失败返回详细错误码）
        core_class_free_add_student_single: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 查询自由班级中是否存在教师
        core_class_free_exist_teacher: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 查询自由班级中是否存在学生
        core_class_free_exist_student: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        ////// 资源运营--题库服务
        // 通过目录code获取知识点
        ersp_question_knowledge_catalog_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 通过父级知识点获取子集知识点
        ersp_question_knowledge_children_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取本节点和父级知识点
        ersp_question_knowledge_parent_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取试题信息
        ersp_question_exercise_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //获取所有平台的appname对应的ichangyan跳转ktsl的地址
        ita_get_appname_url:function () {
            var _this = this;
            var def = jQuery.Deferred();
            httpRequest(Base_Cfg.ITA_BASE+'/appnamecfg').done(function (ret) {
                def.resolve(ret);
            }).fail(function (e) {
                def.reject(e);
            });
            return def.promise();
        },
        // 根据年级获取学科
        ersp_question_metadata_subject_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取出版社
        ersp_question_metadata_publisher_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取册别
        ersp_question_metadata_volume_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取题库教材
        ersp_question_metadata_book_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取教材信息
        ersp_question_metadata_book_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取题库所有年级
        ersp_question_metadata_grade_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 根据学科、学段获取题型列表
        ersp_question_metadata_section_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取枚举
        ersp_question_metadata_enum_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取题库区域列表
        ersp_question_metadata_area_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 根据学科、学段获取认知能力
        ersp_question_metadata_ability_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取题库组卷
        ersp_question_paper_get: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取最新知识点试题
        ersp_question_exercise_new_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 分页查询组卷列表
        ersp_question_paper_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "",
                version: "1.0",
                format: "json"
            };
            var url = baseUrl + "&" + jQuery.param(s) + "&" + jQuery.param(param);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        ////// 校本资源服务
        // 获取校本资源
        /*schoolId	False	String	无	学校id
        subject	False	String	无	学科
        edition	False	String	无	版本
        book	False	String	无	教材code
        volume	False	String	无	册别
        grade	False	String	无	年级code
        share	False	String	无	该资源是否分享(0:未分享，1:已分享)
        sortType	False	String	无	排序类型(ASC|DESC)
        sortField	False	String	无	排序字段
        value	False	String	无	查询值
        fields	False	String	无	查询字段
        thumbSize	False	String	无	缩略图大小(120_20)
        highLight	False	String	false	是否高亮
        inScript	False	String	无	排序算法
        uploader	True	String	无	用户loginName
        range	True	String	无	区间查询range={"field":"createTime","value":"2016-11-01~2016-11-04"}
        mustnot	False	String	无	非查询(例:{"auditStaus":"1","id":"abwdc"})
        page	False	Integer	1	页码
        limit	False	Integer	10	数据条数
        specialType	False	String	无	特色资源类型
        specialBook	False	String	无	特色教材
        specialUnits	False	String	无	特色单元
        schoolProvince	False	String	无	学校所在省份
        schoolCity	False	String	无	学校所在市id
        schoolDistrict	False	String	无	区域id
        topic	False	String	无	资源大类型
        effectiveScope	False	String	无	资源私密状态(0:私密,1:公开)*/
        ersp_xbzy_resource_list: function(param, settings){
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "ersp.xbzy.resource.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        ////// 云备课
        // 备课资源分类列表 -good
        /*openId	True	String	无	openid
         isAll	False	boolean	true	是否包含全部类型
         bookCode	False	String	无	书本编号
         unit1	False	String	无	课本一级目录
         unit2	False	String	无	课本二级目录
         unit3	False	String	无	课本三级目录
         unit4	False	String	无	课本四级目录
         subject	False	String	无	学科
         grade	False	String	无	年级*/
        beike_type_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "beike.type.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        //// 云备课
        // 云备课资源查重 -debug
        /*openId	True	String	无	openid
         md5	True	Strubg  无  资源md5值(多个资源的MD5用","连接起来即可)
         book	True	String	无	书本编号
         unit1	True	String	无	课本一级目录
         unit2	True	String	无	课本二级目录
         unit3	True	String	无	课本三级目录
         unit4	True	String	无	课本四级目录
         */
        beike_nodes_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "beike.nodes.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取备课本书本列表
        /*openId	True	String	无	openid
         isAll	False	String	false	选择所有课本或者选择用户拥有资源的课本
         page	False	int	1	页码
         limit	False	int	10	分页数量
         grade	False	String	无	年级属性
         subject	False	String	无	学科属性
         publisher	False	String	无	出版社属性
         phase	False	String	无	学段属性
         volumn	False	String	无	上下册属性
         edition	False	String	无	版本属性
         stage	False	String	无	stage*/
        beike_book_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "beike.book.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取书本单元列表 -good
        /*openId	True	String	无	openid
         bookCode	True	String	无	书本code码*/
        beike_book_info: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "beike.book.info",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 备课资源文件列表 -good
        /*openId	True	String	无	openid
         page	False	int	1	页码
         limit	False	int	10	分页数量
         order	False(实际上需要为True,=3)	String	3	排序方法（1: 修改时间，2:名称(utf8字符顺序) 3:创建时间）
         type	False	String	无	资源类型
         book	False	String	无	书本code
         unit1	False	String	无	单元code
         unit2	False	String	无	单元code
         unit3	False	String	无	书本三级目录
         unit4	False	String	无	书本四级目录
         name	False	String	无	名称关键词搜索
         year	False	Integer	无	年份
         month	False	Integer	无	月份*/
        beike_file_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "beike.file.list",
                version: "1.0",
                format: "json",
                fromApp: _this.edcAttribute.appKey
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取备课资源时间周年份列表
        /*openId	True	String	无	openid
         type	False	String	无	资源类型
         book	False	String	无	书本code
         unit1	False	String	无	单元code
         unit2	False	String	无	单元code
         unit3	False	String	无	书本三级目录
         unit4	False	String	无	书本四级目录
         name	False	String	无	名称关键词搜索
         grade	False	String	无	年级属性
         subject	False	String	无	学科属性*/
        beike_timeline_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "beike.timeline.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 新增备课文件 -good
        /*openId	True	String	无	openid
         name	True	String	无	String
         url	True	String	无	文件地址
         md5	True	String	无	文件md5值
         length	True	String	无	文件长度
         status	False	int	无	文件上传状态(可不加该参数)
         token	False	String	无	结果签名（contextId、url、md5、length、status进行计算）(可不加该参数)
         contextId	True	String	无	通过文件服务上传后文件服务返回id
         description	False	String	无	文件描述
         grade	False	String	无	年级属性
         subject	False	String	无	学科属性
         publisher	False	String	无	出版社属性
         phase	False	String	无	学段属性
         volumn	False	String	无	上下册
         edition	False	String	无	版本属性
         stage	False	String	无	Stage
         type	False	String	无	类型属性
         book	False	String	无	书本属性
         unit1	False	String	无	课本一级目录
         unit2	False	String	无	课本二级目录
         unit3	False	String	无	课本三级目录
         unit4	False	String	无	课本四级目录*/
        beike_file_add: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "beike.file.add",
                version: "1.0",
                format: "json",
                platForm: "rrt_xj"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 备课文件删除 - good
        /*openId	True	String	无	openid
         fileId	True	String	无	文件id*/
        beike_file_delete: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "beike.file.delete",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 更新备课属性
        /*openId	True	String	无	openid
         name	False	String	无	更新名称
         fileId	True	String	无	文件id
         description	False	String	无	描述信息
         grade	False	String	无	年级属性
         subject	False	String	无	学科属性
         publisher	False	String	无	出版社属性
         phase	False	String	无	学段属性
         volumn	False	String	无	上下册属性
         edition	False	String	无	版本属性
         stage	False	String	无	stage
         book	False	String	无	书本编号
         unit1	False	String	无	课本一级目录
         unit2	False	String	无	课本二级目录
         unit3	False	String	无	课本三级目录
         unit4	False	String	无	课本四级属性*/
        beike_file_update: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "beike.file.update",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取文件上传来源列表
        //参数空
        beike_source_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "beike.source.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取各种分类列表
        /*key	True	String	无	需要查找的字段
         grade	False	String	无	年级属性
         subject	False	String	无	学科属性
         publisher	False	String	无	出版社属性
         phase	False	String	无	学段属性
         volumn	False	String	无	上下册属性
         edition	False	String	无	版本属性
         stage	False	String	无	stage
         book	False	String	无	书本编号
         unit1	False	String	无	课本一级目录
         unit2	False	String	无	课本二级目录
         unit3	False	String	无	课本三级目录
         unit4	False	String	无	课本四级属性*/
        beike_category_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "beike.category.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },
        // 获取用户grade、subject list
        /*openId	True	String	无	openid
         key	True	String	无	查询字段（如subject、grade）*/
        beike_user_category_list: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "beike.user.category.list",
                version: "1.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },

        // 获取关联关系中与特定产品相绑定的用户
        /*"openId": openId, // 当前用户的OpenID
        "productId": productId // 欲查询绑定关系的产品ID
        "userQuery": true/false // 是否查询详细信息(可选,注意值不同返回结构不同)*/
        core_usercenter_account_get_by_product: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "core.usercenter.account.get.by.product",
                version: "2.0",
                format: "json"
            };
            var url = _this.edcAttribute.baseUrl + 'api?appkey=' + _this.edcAttribute.appKey + "&" + jQuery.param(s);
            _this.getDataByAccessToken(url,parseParam(param,settings)).done(function(ret) {
                def.resolve(ret);
            }).fail(function(e) {
                console.log(e);
                def.reject(e);
            });
            return def.promise();
        },

        //// 其他接口
        /*classId:"", //班级id
         uid:"" //用户id*/
        api_eschool_class_feed_getUnreadCount: function(param, settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                method: "class.feed.getUnreadCount"
            };
            var url = Edc_Cfg.YUN_ESCHOOL + "/api.php?" + jQuery.param(s);
            var options = parseParam(param, settings);
            httpRequest(url,options).done(function(ret){
                def.resolve(ret);
            }).fail(function (e) {
                def.reject(e);
            });
            return def.promise();
        },
        //获取用户授权信息
        /*accountname:"" //用户名*/
        api_eshop_getCardOfUser:function(param,settings){
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                c: "home",
                a: "getCardOfUser"
            };
            var url = _this.eshopAttribute.baseUrl + "/index.php?" + jQuery.param(s);
            var options = parseParam(param, settings);
            httpRequest(url,options).done(function(ret){
                def.resolve(ret);
            }).fail(function (e) {
                def.reject(e);
            });
            return def.promise();
        },
        //同步精选 - 查询指定课本的同步精选资源列表
        /*bookCode	TRUE	string		教材code
         resId	FALSE	string		资源id
         bookPage	FALSE	string	1	教材页码
         position	FALSE	string		资源位置(x,y)
         page	FALSE	int	1	页码
         limit	FALSE	int	2000	每页条数*/
        api_eshop_selResource_lists:function(param,settings){
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                c: "selResource",
                a: "lists"
            };
            var url = _this.eshopAttribute.baseUrl + "/index.php?" + jQuery.param(s);
            var options = parseParam(param, settings);
            httpRequest(url,options).done(function(ret){
                def.resolve(ret);
            }).fail(function (e) {
                def.reject(e);
            });
            return def.promise();
        },
        //同步精选 - 查询资源信息
        /*bookCode	TRUE	string		教材code
         resId	FALSE	string		资源id，支持多个资源id,用逗号隔开
         bookPage	FALSE	string	1	教材页码
         position	FALSE	string		资源位置(x,y)
         page	FALSE	int	1	页码
         limit	FALSE	int	2000	每页条数
         */
        api_eshop_selResource_batchget:function(param,settings){
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                c: "selResource",
                a: "batchget"
            };
            var url = _this.eshopAttribute.baseUrl + "/index.php?" + jQuery.param(s);
            var options = parseParam(param, settings);
            httpRequest(url,options).done(function(ret){
                def.resolve(ret);
            }).fail(function (e) {
                def.reject(e);
            });
            return def.promise();
        },
        //同步精选 - 新增同步精选资源(POST请求)
        /*bookCode	TRUE	string
         data	TRUE	string		"将数组json序列化后，放在data参数里post到接口
         [{
         ""bookCode"":""13170425-022"",
         ""page"":""1"",
         ""resName"":""西湖.jpg"",
         ""resId"":""123"",
         ""position"":""155,213"",
         ""md5"":""123456"",
         ""author"":""2000000030000013771""
         },…]
         */
        api_eshop_selResource_add:function(param,settings){
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                c: "selResource",
                a: "add"
            };
            var url = _this.eshopAttribute.baseUrl + "/index.php?" + jQuery.param(s);
            var options = parseParam(param, settings);
            httpRequest(url,options).done(function(ret){
                def.resolve(ret);
            }).fail(function (e) {
                def.reject(e);
            });
            return def.promise();
        },
        //同步精选 - 更新同步精选资源
        /*rid	TRUE	string		资源唯一标识符
         bookCode	FALSE	string		教材code
         resId	FALSE	string		资源id
         md5	FALSE	string		资源md5值
         page	FALSE	int		资源在教材中的页码
         resName	FALSE	string		资源名称
         position	FALSE	string		资源位置(x,y)
         author	FALSE	int		资源提交者uid
         */
        api_eshop_selResource_update:function(param,settings){
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                c: "selResource",
                a: "update"
            };
            var url = _this.eshopAttribute.baseUrl + "/index.php?" + jQuery.param(s);
            var options = parseParam(param, settings);
            httpRequest(url,options).done(function(ret){
                def.resolve(ret);
            }).fail(function (e) {
                def.reject(e);
            });
            return def.promise();
        },
        //同步精选 - 删除同步精选资源
        /*bookCode	TRUE	string		教材code
         rid	TRUE	string		资源唯一标识符，支持多个rid，并以逗号隔开
         */
        api_eshop_selResource_delete:function(param,settings){
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                c: "selResource",
                a: "delete"
            };
            var url = _this.eshopAttribute.baseUrl + "/index.php?" + jQuery.param(s);
            var options = parseParam(param, settings);
            httpRequest(url,options).done(function(ret){
                def.resolve(ret);
            }).fail(function (e) {
                def.reject(e);
            });
            return def.promise();
        },
        //统计监管eshop接口
        /*
         uid : 必传 string 用户的id
         module:
         type:
         bookCode:
         cardId:
         appId:
         havingClass:
         patternType
         */
        api_eshop_baseStatics:function (param,settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                c: "home",
                a: "baseStatics"
            };
            param.random = Math.random(0,1);//因同时可能产生多个相同的请求，为防止url缓存问题，加一个随机数
            var url = _this.eshopAttribute.baseUrl + "/index.php?" + jQuery.param(s);
            var options = parseParam(param, settings);
            httpRequest(url,options).done(function(ret){
                def.resolve(ret);
            }).fail(function (e) {
                def.reject(e);
            });
            return def.promise();
        },
        // 根据用户appName获取区域名称
        /*appName:"",
         page:"",
         limit:""*/
        api_eshop_home_getUserAreaName:function (param,settings) {
            var _this = this;
            var def = jQuery.Deferred();
            var s = {
                c: "home",
                a: "getUserAreaName"
            };
            var url = _this.eshopAttribute.baseUrl + "/index.php?" + jQuery.param(s);
            var options = parseParam(param, settings);
            httpRequest(url,options).done(function(ret){
                def.resolve(ret);
            }).fail(function (e) {
                def.reject(e);
            });
            return def.promise();
        },
        /**
         * sso根据tgt获取ticket
         * @param url(string or obj)
         * @param options(obj)
         * @returns {*}
         */
        /*param = {
            data: {
                service: encodeURI(url)
            },
            type:'post'
            [tgt:'tgt-value']
        }*/
        api_sso_v1_ticket_get:function(url,options){
            var _this = this;
            var def = jQuery.Deferred();
            // 只传了一个参数
            if ( typeof url === "object" ) {
                options = url;
                url = undefined;
                if(options && options.tgt){
                    url = _this.ssoAttribute.ssoServerUrl + '/v1/tickets/' + options.tgt;
                    delete options.tgt;
                }else{
                    console.error('获取sso Ticket 缺少option.tgt 参数');
                }
            };
            options = options || {};
            httpRequest(url,options).done(function(ret){
                def.resolve(ret);
            }).fail(function (e) {
                def.reject(e);
            });
            return def.promise();
        },
        /**
         * 获取接口数据（仅适用于edc接口）
         * @param url
         * @param options
         * @param oauthUrl
         * @returns {*}
         */
        getDataByAccessToken: function(url,options,oauthUrl) {
            var _this = this;
            var def = jQuery.Deferred();
            options = options || {};
            var httpurl = "";
            var forceRefresh = false;
            //openId参数名称
            var openIdName = 'openId';
            if(options._forceRefresh == true){
                forceRefresh = true;
                delete options._forceRefresh;
            }
            _this.getAccessToken(oauthUrl,forceRefresh).done(function(ret){
                //用户级别授权时，需要额外传入"openId=value"参数，value为sso登录返回的用户openId
                switch (_this.edcAttribute.grantType.toLowerCase()) {
                    case 'client_credentials':
                        break;
                    case 'password':
                    default:
                        if($.isPlainObject(options) && options.data && (openIdName in options.data)){
                            //参数中存在openId参数,这里忽略
                        }else{
                            if(!options.data){
                                options.data = {};
                            }
                            //参数中不存在openId参数，这里动态加入
                            var user_openId = _this.userInfo && _this.userInfo.sso_openId || "";
                            options.data[openIdName] = user_openId;
                        }
                        break;
                }

                //加入tid参数（用于edc接口统计等）
                httpurl = url + "&" + "access_token=" + ret + "&" + "tid=" + createUuid();
                httpRequest(httpurl,options).done(function(ret){
                    def.resolve(ret);
                }).fail(function (e) {
                    //查看返回错误信息，105-access_token缺少 106-access_token异常
                    // password级别 128 - openId和access_token不匹配，此时只能重新生成token
                    if(e && e.responseJSON){
                        if(-1 == $.inArray('' + e.responseJSON.code,['105','106','128']) && -1 == e.responseText.indexOf('access_token')){
                            //非access_token异常，重新请求接口
                            httpRequest(httpurl,options).done(function(ret2){
                                def.resolve(ret2);
                            }).fail(function (e) {
                                def.reject(e);
                            });
                        }else{
                            //access_token过期或者异常，发起重试
                            _this.getOauthRefreshToken(_this.edcAttribute.appKey,_this.userInfo).done(function(access_token){
                                _this.retryGetDataByAccessToken(url,options,access_token).done(function(ret4){
                                    def.resolve(ret4);
                                }).fail(function(e){
                                    def.reject(e);
                                });
                            }).fail(function(e){
                                def.reject(e);
                            });
                        }
                    }else{
                        //非json数据返回,不判断了，重试吧
                        _this.getOauthRefreshToken(_this.edcAttribute.appKey,_this.userInfo).done(function(access_token){
                            _this.retryGetDataByAccessToken(url,options,access_token).done(function(ret4){
                                def.resolve(ret4);
                            }).fail(function(e){
                                def.reject(e);
                            });
                        }).fail(function(e){
                            def.reject(e);
                        });
                    }
                });
            }).fail(function (e) {
                //获取access_token失败
                def.reject(e);
            });
            return def.promise();
        },
        /**
         * 获取数据异常，重试方法（仅适用于edc接口）
         */
        retryGetDataByAccessToken: function(url,options,access_token,retryCount) {
            var _this = this;
            var def = jQuery.Deferred();
            var httpurl = "",
                retry = 3;
            //加入tid参数（用于edc接口统计等）
            httpurl = url + "&" + "access_token=" + access_token + "&" + "tid=" + createUuid();
            httpRequest(httpurl, options).done(function (ret) {
                def.resolve(ret);
            }).fail(function(e){
                def.reject(e);
            });
            return def.promise();
        },
        /**
         * 接口获取access_token（仅适用于edc接口）
         * @param oauthUrl
         * @param forceRefresh
         * @returns {*}
         */
        getAccessToken: function(oauthUrl,forceRefresh) {
            var _this = this;
            var def = $.Deferred();
            //强制刷新access_token
            if(forceRefresh && forceRefresh == true){
                _this.getOauthRefreshToken(_this.edcAttribute.appKey,_this.userInfo).done(function(access_token){
                    def.resolve(access_token);
                }).fail(function (e) {
                    def.reject(e);
                });
            }else {
                var cachedAccessToken = _this._getEdcAccessTokenCache(_this.edcAttribute.appKey,_this.userInfo);
                //命中缓存
                if(cachedAccessToken){
                    def.resolve(cachedAccessToken);
                }else{
                    switch (_this.edcAttribute.grantType.toLowerCase()){
                        case 'client_credentials':
                            if (typeof (oauthUrl) == "undefined" || oauthUrl == '') {
                                var option = {
                                    client_id: _this.edcAttribute.appKey,
                                    client_secret: _this.edcAttribute.appSecret,
                                    grant_type: "client_credentials",
                                    tid: createUuid() //edc接口统计和排错使用
                                };
                                oauthUrl = _this.edcAttribute.oauthTokenServer + jQuery.param(option);
                            }
                            httpRequest(oauthUrl).done(function (ret) {
                                if(ret && ret[_this.edcAttribute.cacheName]){
                                    var access_token = ret[_this.edcAttribute.cacheName] || "";
                                    ret[_this.edcAttribute.userId] = _this.userInfo.loginName;
                                    _this._updateAccessTokenCache('refresh',_this.edcAttribute.appKey,ret);
                                    def.resolve(access_token);
                                }else{
                                    def.reject();
                                }
                            }).fail(function (e) {
                                def.reject(e);
                            });
                            break;
                        case 'password':
                        default:
                            if (typeof (oauthUrl) == "undefined" || oauthUrl == '') {
                                //获取rsa密码信息
                                _this.getEncryptedUserInfo().done(function(userObj){
                                    var loginName = userObj.loginName;
                                    var rsa_encrypted_password = userObj.rsa_encrypted_password;
                                    var option = {
                                        client_id: _this.edcAttribute.appKey,
                                        username: loginName,
                                        password: rsa_encrypted_password,
                                        grant_type: "password",
                                        tid: createUuid() //edc接口统计和排错使用
                                    };
                                    oauthUrl = _this.edcAttribute.oauthTokenServer + jQuery.param(option);
                                    httpRequest(oauthUrl).done(function (ret) {
                                        if(ret && ret[_this.edcAttribute.cacheName]){
                                            var access_token = ret[_this.edcAttribute.cacheName] || "";
                                            ret[_this.edcAttribute.userId] = _this.userInfo.loginName;
                                            _this._updateAccessTokenCache('refresh',_this.edcAttribute.appKey,ret);
                                            def.resolve(access_token);
                                        }else{
                                            def.reject();
                                        }
                                    }).fail(function (e) {
                                        def.reject(e);
                                    });
                                }).fail(function(e){
                                    def.reject(e);
                                });
                            }else{
                                httpRequest(oauthUrl).done(function (ret) {
                                    if(ret && ret[_this.edcAttribute.cacheName]){
                                        var access_token = ret[_this.edcAttribute.cacheName] || "";
                                        ret[_this.edcAttribute.userId] = _this.userInfo.loginName;
                                        _this._updateAccessTokenCache('refresh',_this.edcAttribute.appKey,ret);
                                        def.resolve(access_token);
                                    }else{
                                        def.reject();
                                    }
                                }).fail(function (e) {
                                    def.reject(e);
                                });
                            }
                            break;
                    }
                }
            }
            return def.promise();
        },
        /**
         * 刷新access token并续期
         * 目前只有grant_type=password支持refreshToken方法
         * @param string refresh_token
         */
        getOauthRefreshToken:function(appkey,userInfo){
            var _this = this;
            var def = $.Deferred();
            if(!userInfo){
                userInfo = _this.userInfo;
            }
            var oauthUrl = '';
            if(appkey == _this.edcAttribute.appKey) {
                switch (_this.edcAttribute.grantType.toLowerCase()) {
                    case 'client_credentials':
                        var option = {
                            client_id: _this.edcAttribute.appKey,
                            client_secret: _this.edcAttribute.appSecret,
                            grant_type: "client_credentials",
                            tid: createUuid() //edc接口统计和排错使用
                        };
                        oauthUrl = _this.edcAttribute.oauthTokenServer + jQuery.param(option);
                        break;
                    case 'password':
                    default:
                        var cachedObj = _this._updateAccessTokenCache('get',_this.edcAttribute.appKey,userInfo);
                        if(cachedObj && $.isArray(cachedObj) && cachedObj[0] && cachedObj[0]['refresh_token']){
                            var refresh_token = cachedObj[0]['refresh_token'];
                            var refresh_option = {
                                client_id: _this.edcAttribute.appKey,
                                refresh_token: refresh_token,
                                grant_type: "refresh_token",
                                tid: createUuid() //edc接口统计和排错使用
                            };
                            var oauthUrl = _this.edcAttribute.oauthTokenServer + jQuery.param(refresh_option);
                        }
                        break;
                }
                //发送请求
                httpRequest(oauthUrl).done(function (ret) {
                    if(ret && ret[_this.edcAttribute.cacheName]){
                        var access_token = ret[_this.edcAttribute.cacheName] || "";
                        ret[_this.edcAttribute.userId] = _this.userInfo.loginName;
                        _this._updateAccessTokenCache('refresh',appkey,ret);
                        def.resolve(access_token);
                    }else{
                        def.reject(ret);
                    }
                }).fail(function (e) {
                    def.reject(e);
                });
            }else{
                //其他应用的access_token续期（暂无）
                console.error('暂不支持' + appkey + '应用refresh access_token.');
                def.reject();
            }
            return def.promise();
        },
        /**
         * 获取client_id 和 userInfo 对应的缓存数据
         * @param client_id
         * @returns {*}
         * @private
         */
        _getEdcAccessTokenCache:function(client_id,userInfo){
            var _this = this;
            if(!client_id){
                return false;
            }
            if(!userInfo){
                userInfo = _this.userInfo;
            }
            var result = _this._updateAccessTokenCache('get',client_id,userInfo);
            if(result && result[0] && result[0][_this.edcAttribute.cacheName]){
                return result[0][_this.edcAttribute.cacheName];
            }else{
                return false;
            }
        },
        /**
         * 更新access_token缓存
         * @param operation
         * @param client_id
         * @param obj
         * @returns {*}
         * @private
         */
        _updateAccessTokenCache:function(operation,client_id,obj){
            var _this = this;
            if(!operation || !client_id){
                return false;
            }
            var newcache = [],
                cached = _this.AccessTokenCache,
                result = [];
            var findCache = cached.filter(function(el){
                if(obj && typeof obj === "object" && obj.loginName){
                    return el[_this.edcAttribute.cacheId] == client_id && el[_this.edcAttribute.userId] == obj.loginName;
                }else{
                    return el[_this.edcAttribute.cacheId] == client_id;
                }
            })

            if(operation == 'create'){
                if(obj && typeof obj === "object") {
                    if(findCache.length == 0) {
                        //新增cache
                        obj[_this.edcAttribute.cacheId] = client_id;
                        newcache = cached.push(obj);
                        _this.AccessTokenCache = newcache;
                        return true;
                    }else{
                        //更新cache
                        operation = 'refresh';
                    }
                }else{
                    return false;
                }
            }
            if(operation == 'get'){
                if(findCache.length == 1){
                    return findCache;
                }else{
                    return false;
                }
            }
            if(operation == 'refresh'){
                if(obj && typeof obj === "object") {
                    for (var i = 0, count = cached.length; i < count; i++) {
                        var _item = cached[i];
                        if (_item[_this.edcAttribute.cacheId] == client_id && _item[_this.edcAttribute.userId] == obj.loginName) {
                            obj[_this.edcAttribute.cacheId] = client_id;
                            newcache.push(obj);
                        } else {
                            newcache.push(_item);
                        }
                    }
                    //如果没有被cache,则立即cache
                    if(findCache.length == 0) {
                        obj[_this.edcAttribute.cacheId] = client_id;
                        newcache.push(obj);
                    }
                    _this.AccessTokenCache = newcache;
                    return true;
                }else{
                    return false;
                }
            }
            if(operation == 'delete'){
                for(var i=0,count = cached.length;i<count;i++) {
                    var _item = cached[i];
                    if(_item[_this.edcAttribute.cacheId] != client_id  && el[_this.edcAttribute.userId] != obj.loginName){
                        newcache.push(_item);
                    }
                }
                _this.AccessTokenCache = newcache;
            }
        },
        /**
         * 设置用户信息
         * @param userInfo {loginName:'',des_encrypted_userInfo:'',rsa_encrypted_password:'',sso_openId:''}
         * @returns {{}|*}
         */
        setEncryptedUserInfo:function(userInfo){
            var _this = this;
            //依赖的必要属性
            var essential_property = ['loginName','rsa_encrypted_password'];
            for(key in userInfo){
                _this.userInfo[key] = userInfo[key];
            }
            if(!userInfo.hasOwnProperty('loginName') || !userInfo.hasOwnProperty('rsa_encrypted_password' || !userInfo.hasOwnProperty('sso_openId'))){
                console.error('edcService.js 的setEncryptedUserInfo方法参数属性loginName或者rsa_encrypted_password不存在');
            }
            //为了防止页面被刷新造成用户数据丢失，这里采用sessionStorage保存一份数据备用
            _this.sessionUserInfo('set',_this.userInfo);
            return _this.userInfo;
        },
        /**
         * 获取用户信息
         * 这里读取的security.cr文件或者uli.dat文件，是互联教学助手产品特有文件。
         * 其他平台使用，请务必确保调用接口之前通过setEncryptedUserInfo方法设置用户基本信息
         */
        getEncryptedUserInfo:function(){
            var _this = this;
            var def = $.Deferred();
            var result = {};
            if(_this.userInfo.loginName && _this.userInfo.rsa_encrypted_password){
                result = _this.userInfo;
                def.resolve(result);
            }else{
                /**
                 * 使用security_cr
                 * 已废弃，因为用户级别授权在调用 core.*.* 接口时，必须额外加入"openId=value"参数，value为sso登录返回的openId
                 */
                // _this.readFileContent(_this.security_cr_path).done(function(fileContent){
                //     var encryptedInfo = fileContent;
                //     var plainText = decodeURIComponent(_this.desDecrypt(_this.des.key,encryptedInfo));
                //     if(plainText) {
                //         var userObj = _this.translateEncryptedUserInfo(plainText);
                //         if (userObj) {
                //             //缓存这份用户数据
                //             _this.setEncryptedUserInfo(userObj);
                //             def.resolve(userObj);
                //         } else {
                //             //转换为标准格式失败
                //             def.reject();
                //         }
                //     }else{
                //         //des解密失败
                //         def.reject();
                //     }
                // }).fail(function(e){
                //     def.reject();
                // });

                //使用uli.dat
                _this.readFileContent(_this.uli_dat_path).done(function(fileContent){
                    var encryptedInfo = fileContent;
                    try{
                        var json_content = JSON.parse(encryptedInfo) || {};
                        if(json_content._sso_openId){
                            var userObj = {
                                loginName: json_content._sso_loginName,
                                des_encrypted_userInfo: json_content.des_encrypted_userInfo,
                                rsa_encrypted_password: json_content.rsa_encrypted_password,
                                sso_openId: json_content._sso_openId
                            };
                            //缓存这份用户数据
                            _this.setEncryptedUserInfo(userObj);
                            def.resolve(userObj);
                        }else{
                            var userObj = _this.sessionUserInfo('get');
                            if(userObj){
                                //缓存这份用户数据
                                _this.setEncryptedUserInfo(userObj);
                                def.resolve(userObj);
                            }else{
                                def.reject(fileContent);
                            }
                        }
                    }catch (e){
                        var userObj = _this.sessionUserInfo('get');
                        if(userObj){
                            //缓存这份用户数据
                            _this.setEncryptedUserInfo(userObj);
                            def.resolve(userObj);
                        }else{
                            def.reject(e);
                        }
                    }
                }).fail(function(e){
                    // uli.dat文件不存在
                    var userObj = _this.sessionUserInfo('get');
                    if(userObj){
                        //缓存这份用户数据
                        _this.setEncryptedUserInfo(userObj);
                        def.resolve(userObj);
                    }else{
                        def.reject(e);
                    }
                });
            }
            return def.promise();
        },
        /**
         * 判断文件是否存在
         * @param {string} filePath 文件路径
         * @returns {boolean}
         */
        isFileExist: function(filePath) {
            var _this = this;
            var def = $.Deferred();
            var fs = window.require("fs");
            if (!filePath) return def.resolve(false);

            fs.exists(filePath, function (exists) {
                def.resolve(exists);
            });
            return def.promise();
        },
        /**
         * 将C:\\test.txt 这样的路径转为 C:/test.txt
         * @param path
         * @returns {*}
         */
        toPosix:function(path){
            var _this = this;
            if (/^[a-zA-Z]\:\\/.test(path)) {
                path=path.replace(/\\/g,'/');
            }
            return path;
        },
        /**
         * DES加密
         * @param key
         * @param content
         * @returns {*}
         */
        desDecrypt:function(key,content){
            var _this = this;
            if(!key){
                return false;
            }
            try {
                content = content.toString();
                DES.init(key, content);
                var plainText = decodeURIComponent(DES.Encrypt("Decrypt"));
                return plainText;
            }catch (e) {
                return false;
            }
        },
        /**
         * 形如"loginName=password"格式转换为标准的格式
         * @param content
         * @returns {*}
         */
        translateEncryptedUserInfo:function(content){
            var _this = this;
            if (!content || content.indexOf('=') == -1){
                return false;
            }
            var userInfo = content.split('=');
            if (userInfo.length != 2) {
                userInfo[1] = content.substr(val.indexOf('=') + 1);
            }
            var loginName = userInfo[0];
            // password结尾有空字符
            var password = userInfo[1].replace(/\0/g,"");
            return _this.encryptUserInfo(loginName,password);
        },
        /**
         * 将账号和密码进行DES和RSA加密
         * @param loginName
         * @param password
         * @returns {{loginName: *, des_encrypted_userInfo, rsa_encrypted_password}}
         */
        encryptUserInfo:function(loginName,password){
            var _this = this;
            //将用户信息DES(key,loginName=password)加密存储到全局des_encrypted_userInfo --用于单点登录
            var plain_userInfo = loginName + '=' + password;
            var des_key = _this.des.key;
            DES.init(des_key, plain_userInfo);
            var des_encrypted_userInfo = DES.Encrypt();

            //将用户明文密码RSA(key,password)加密存储到rsa_encrypted_password -- 用于用户级别授权接口
            //这里的RSA算法和sso登录的RSA算法一致，（n,e）
            var exponent = _this.rsa.exponent;
            var modulus = _this.rsa.modulus;
            if(typeof window.RSAUtils == undefined){
                console.error('对密码加密依赖window.RSAUtils方法（一般sso.min.js已集成）');
                return {};
            }else {
                var key = window.RSAUtils.getKeyPair(exponent, "", modulus);
                var rsa_encrypted_password = RSAUtils.encryptedString(key, password);
                return {
                    loginName: loginName,
                    des_encrypted_userInfo: des_encrypted_userInfo,
                    rsa_encrypted_password: rsa_encrypted_password
                };
            }
        },
        readFileContent:function(filePath){
            var _this = this;
            var def = $.Deferred();
            var fs = window.require("fs");
            var standardFilePath = _this.toPosix(filePath);
            _this.isFileExist(standardFilePath).done(function(exist){
                if(exist){
                    fs.readFile(standardFilePath, 'utf8', function(err, data){
                        if(!err){
                            def.resolve(data);
                        }else{
                            //读取文件失败
                            def.reject(err);
                        }
                    });
                }else{
                    //文件不存在
                    def.reject(exist);
                }
            });
            return def.promise();
        },
        // session 保存和读取userInfo
        sessionUserInfo:function(op,obj){
            var _this = this;
            var result = false;
            switch(op.toLocaleLowerCase()){
                case 'get':
                    try{
                        result = JSON.parse(sessionStorage.getItem('_userInfo'));
                    }catch(e){
                        result = false;
                    }
                    break;
                case 'set':
                    if(jQuery.isPlainObject(obj)){
                        sessionStorage.removeItem('_userInfo');
                        sessionStorage.setItem('_userInfo',JSON.stringify(obj));
                        result = true;
                    }
                    break;
                default:
                    break;
            }
            return result;
        }
    };
    return {
        Instance:function(){
            if (instance === undefined) {
                instance = new interface();
            }
            return instance;
        }
    };
})();
