/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 13-11-19
 * Time: 下午3:56
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports) {

    var _shellcmd = require('./shellcmd');

    function UserData() {
        var _self = this;
        var path = require('./path');
        _self.ebookContext = require('../app/ebookcontext').Instance;
        _self.ip = "";
        //待发送临时数据
        _self.postStr = "";
        //sqlite数据库位置
        _self.dbPath = path.join(path.trimPosix(Config.binPath), 'iflybook.db');

        //indexedDB对象
        _self.indexedDB = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
        _self.IDBTransaction = window.IDBTransaction || window.webkitIDBTransaction || window.msIDBTransaction;
        _self.IDBKeyRange = window.IDBKeyRange || window.webkitIDBKeyRange || window.msIDBKeyRange;
        _self.db = null;

        _self.init = function(){
           _self.getIP();
        }

        _self.start = function(something,pama){
            var _self = this;
            var def = $.Deferred();

            if (something == "add") {
                _self.add(pama).done(function(){
                    def.resolve();
                });
            }
            else if (something == "getAll") {
                _self.getAll().done(function(res){
                    def.resolve(res);
                });
            }
            else if (something == "clear") {
                _self.clear().done(function(){
                    def.resolve();
                });
            }
            return def.promise();
        }

        _self.add = function(pama){
            var _self = this;
            var def = $.Deferred();
            var nowTime = _self.getTime();
            var account = _self.ebookContext.getUser().getName();
            var sqlStr = 'insert into actionLog(timeStamp,ip,user,fileExtension,source,bookcode,fileUrl,data,reserved) values("'+nowTime+'","'+_self.ip+
                '","'+account+ '","'+pama.type+ '","'+pama.source+ '","'+pama.bookcode+'","'+pama.url+'","","")';
            _shellcmd.executeDbAsyn(_self.dbPath,sqlStr).done(function(res){
                def.resolve();
            });
            return def.promise();
        }

        _self.getAll = function(){
            var _self = this;
            var def = $.Deferred();
            var sqlStr = "select * from actionLog";
            _shellcmd.retriveDbAsyn(_self.dbPath,sqlStr).done(function (res) {
                _self.postStr = res;
                def.resolve(res);
            });
            return def.promise();
        }

        _self.clear = function(){
            var _self = this;
            var def = $.Deferred();
            var sqlStr = "delete from actionLog";
            _shellcmd.executeDbAsyn(_self.dbPath,sqlStr).done(function(){
                def.resolve();
            });
            return def.promise();
        }

        _self.postToWeb = function(){
            var _self = this;
            //联网时发送
            var def = $.Deferred();
            if (_self.ebookContext.getUser().getIsOnline()) {
                _self.start("getAll", "").done(function (retStr) {
                    var httpurl = AppRemoteSvcCfg.DownLoadDataUrl;
                    var msgJson = {
                        url: httpurl,
                        userActionLog:retStr
                    };
                    _shellcmd.postHttpRequest(msgJson).done(function (ret) {
                        //清空log
                        _self.start("clear","").done(function () {
                            def.resolve();
                        });
                    });
                });
            }
            else {
                //断网或失败不处理（保存）
                def.resolve();
            }
            return def.promise();
        }

        _self.getTime = function () {
            return (new Date()).Format("yyyy-MM-dd hh:mm:ss.S");
        }

        _self.getIP = function () {
            var _self = this;
            var def = $.Deferred();
            if (!_self.ip) {
                _shellcmd.getipv4address().done(function (ret) {
                    _self.ip = ret;
                    def.resolve();
                });
            }
            else {
                def.resolve();
            }
            return def.promise();
        }
    }

    //格式化时间
    Date.prototype.Format = function (fmt) { //author: meizz
        var o = {
            "M+": this.getMonth() + 1,                 //月份
            "d+": this.getDate(),                    //日
            "h+": this.getHours(),                   //小时
            "m+": this.getMinutes(),                 //分
            "s+": this.getSeconds(),                 //秒
            "q+": Math.floor((this.getMonth() + 3) / 3), //季度
            "S": this.getMilliseconds()             //毫秒
        };
        if (/(y+)/.test(fmt))
            fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
        for (var k in o)
            if (new RegExp("(" + k + ")").test(fmt))
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
        return fmt;
    }


//    UserData.prototype.clearUserData = function () {
//        var _self = this;
//        var def = $.Deferred();
//        var store = _self.db.transaction(["userdata"], "readwrite")
//            .objectStore("userdata");
//        store.clear();
//        def.resolve();
//
//        return def.promise();
//    }
//
//    //获取全部数据并拼接成字符串
//    UserData.prototype.getAllData = function () {
//        var _self = this;
//        var def = $.Deferred();
//        var objectStore = _self.db.transaction("userdata").objectStore("userdata");
//        var Str = "";
//        objectStore.openCursor().onsuccess = function (event) {
//            var cursor = event.target.result;
//            if (cursor) {
//                Str += '{"timeStamp":"' + cursor.key + '"' + ",";
//
//                if (cursor.value.ip) {
//                    Str += '"ip":"' + cursor.value.ip + '"' + ",";
//                } else {
//                    Str += '"ip":"",';
//                }
//
//                if (cursor.value.user) {
//                    Str += '"user":"' + cursor.value.user + '"' + ",";
//                } else {
//                    Str += '"user": "",';
//                }
//
//                if (cursor.value.type) {
//                    Str += '"type":"' + cursor.value.type + '"' + ",";
//                } else {
//                    Str += '"type": "",';
//                }
//
//                if (cursor.value.source) {
//                    Str += '"source":"' + cursor.value.source + '"' + ",";
//                } else {
//                    Str += '"source": "",';
//                }
//
//                if (cursor.value.bookCode) {
//                    Str += '"bookCode":"' + cursor.value.bookCode + '"' + ",";
//                } else {
//                    Str += '"bookCode": "",';
//                }
//
//                if (cursor.value.data) {
//                    Str += '"data":"' + cursor.value.data + '"' + ",";
//                } else {
//                    Str += '"data": "",';
//                }
//
//                if (cursor.value.reserved) {
//                    Str += '"reserved":"' + cursor.value.reserved + '"';
//                } else {
//                    Str += '"reserved": ""';
//                }
//                Str += '},';
//                cursor.continue();
//            }
//            else {
//                _self.postStr = Str;
//                def.resolve(Str);
//            }
//        };
//        return def.promise();
//    }
//
//    UserData.prototype.addLog = function (type, source, bookcode) {
//        var _self = this;
//        var def = $.Deferred();
//
//        var nowTime = _self.getTime();
//        var account = _self.ebookContext.getUser();
//
//        var addObj = {
//            timeStamp: nowTime,
//            ip: _self.ip,
//            user: account._name,
//            type: type,
//            source: source,
//            bookCode: bookcode
//        }
//        var request = _self.db.transaction(["userdata"], "readwrite")
//            .objectStore("userdata")
//            .add(addObj);
//
//        request.onsuccess = function (event) {
//            def.resolve();
//        };
//
//        request.onerror = function (event) {
//            def.resolve();
//        }
//        return def.promise();
//    }
//
//    UserData.prototype.postToWeb = function () {
//        var _self = this;
//        //联网时发送
//        var def = $.Deferred();
//        if (_self.ebookContext.getUser().getIsOnline()) {
//            _self.start("getAll", "").done(function (retStr) {
//                //删除末尾逗号,所有单引号转为双引号
//                var readyStr1 = _self.postStr.replace(/\'/ig, "\"");
//                var readyStr2 = readyStr1.substring(0, readyStr1.length - 1);
//                //封装成json串
//                var readyJsonStr = '{"data":[' + readyStr2 + ']}';
//                var httpurl = AppRemoteSvcCfg.DownLoadDataUrl;
//                var msgJson = {
//                    url: httpurl,
//                    userActionLog: readyJsonStr
//                };
//                _self.shellcmd.postHttpRequest(msgJson).done(function (ret) {
//                    //清空log
//                    _self.start("clear", "").done(function () {
//                        def.resolve();
//                    });
//                });
//            });
//        }
//        else {
//            //断网或失败不处理（保存）
//            def.resolve();
//        }
//        return def.promise();
//    }

    exports.Instance = new UserData();
})
;
