/**
 * touch event transform to mouse event
 * created by lwang1222@gmail.com or linwang5@iflytek.com
 * Date on Dec.18 2015
 */
;
(function(){

    function touchHandler(event){

        //如果是pen_canvas 则返回，其绑定了touch事件
        if(event.target == document.getElementById('pen_canvas')) return;
        var touches = event.changedTouches,
            first = touches[0],
            type = "";
        /**
         * 这里是为了开打文件对话框获取不到焦点的处理，大部分情况下都可以，偶发失败。
         */

        if(event.target == document.getElementById('openFileDialog')||event.target.parentElement == document.getElementById('openFileDialog')){

            if(event.type == "touchend"){
                $("#openFileDialog").trigger('click');
            }
            return;
        }
        switch (event.type){

            case "touchstart" : type = "mousedown"; break;
            case "touchmove"  : type = "mousemove"; break;
            case "touchend"   : type = "mouseup"; break;
            default :           return;
        }

        var simulatedEvent = document.createEvent("MouseEvent");
        simulatedEvent.initMouseEvent(type, true, true, window, 1,
                                      first.screenX ,first.screenY,
                                      first.clientX, first.clientY, false,
                                      false, false ,false, 0/*left*/, null);

        first.target.dispatchEvent(simulatedEvent);

        //注释因为其会导致click事件不可用
        //event.preventDefault();
    }

    function initTouchHandler(){

        document.addEventListener("touchstart",touchHandler,true);
        document.addEventListener("touchmove",touchHandler,true);
        document.addEventListener("touchend",touchHandler,true);
        document.addEventListener("touchcanel",touchHandler,true);

    }

    initTouchHandler();

})();