﻿/*
* @author: xlzhao3
* @date: 2013-07-29
* @description: 字符串format方法
*/

define(function(require, exports, module){
    /**
     * 利用占位符格式化字符串
     * 例如：StringFormat("你好，{0}, {1}",'bintang', 'Nice to meet you!') = "你好，bintang, Nice to meet you!";
     */
    function StringFormat(str) {
        var s = str;
        var i = arguments.length;

        while (--i) {
            s = s.replace(new RegExp('\\{' + (i-1) + '\\}', 'gm'), arguments[i]);
        }
        return s;
    };

    /**
    * 解析字符串的EL表达式。
    * 例如：
    *       var o = {name:"bintang"}
    *       StringFormatEl("你好，{name}",o) = "你好，bintang"
    *
    * @param o 数据对象
    * @return 返回解析后的字符串
    */
    function StringFormatEl(str,o) {
        var s = str;

        if (typeof (o) != 'object') return '';

        return s.replace(new RegExp('\\{([^\\{\\}]*?)\\}', 'igm'), function ($, $1) {
            // return o[$1]?o[$1]:$;
            return o[$1];
        });
    }
    
    exports.StringFormat = StringFormat;
    exports.StringFormatEl = StringFormatEl;
});
