/**
 * Created with JetBrains WebStorm.
 * User: feiqian
 * Date: 13-12-11
 * Time: 上午10:50
 * To change this template use File | Settings | File Templates.
 */

define(function (require, exports, module) {
    /**
     * 获得一个可拖动和移动大小的对象
     * @param {object=} obj  设置参数(可选）,或者调用setOption函数
     * @constructor
     */

    var _model = require('../app/model');
    var _eventUtil = require('../common/eventUtil');

    function ResizeableAndDraggableBound(obj) {
        this._options = $.extend({}, ResizeableAndDraggableBound._defaults, obj);
        this._bound = null;

        this._hasInit = false;
        this._bookContainer = $("#bookContainer");
        this._containmentRect = null;
    }

    ResizeableAndDraggableBound.prototype = new _eventUtil();
    ResizeableAndDraggableBound.constructor = ResizeableAndDraggableBound;


    //默认参数
    ResizeableAndDraggableBound._defaults = {
        minWidth: 200,
        minHeight: 160,
        content: null,
        container: null,
        //是否禁止拖动和调整大小
        draggable: false,
        resizable: true,
        style: {},
        left: 0,
        top: 0,
        width: 0,
        height: 0
    };

    ResizeableAndDraggableBound.prototype._bindCommands = function () {
        var _self = this;
        this._options.resizable && this._setResizeable();
        this._options.draggable && this._setDraggable();
        this._options.content.bind('remove', function () {
            _self.destroy();
        });
    }


    ResizeableAndDraggableBound.prototype._setResizeable = function () {
        var content = this._options.content;
        if (!content) return;

        var _self = this;
        var scale = ResizeableAndDraggableBound.getTransformMatrix(this._options.container);

        //设置可变化大小和拖动
        content.resizable({
            handles: "all",
            minWidth: _self._options.minHeight,
            minHeight: _self._options.minWidth,
            containment: 'parent',
            scale: scale,
            start: function (event) {
                //禁止滑动防止拖动过快引起翻页
                _self._bookContainer.trigger("unSwipable").trigger("unDraggable");
                //触发resizeStart事件
                _self.trigger(_self._options.content, 'resizeStart');
                event.stopPropagation();
            },
            resize: function (event) {
                _self.trigger(_self._options.content, 'resize', _self.getBound());
                event.stopPropagation();
            },
            stop: function (event) {
                setTimeout(function () {
                    _self._bookContainer.trigger("swipable").trigger("draggable"); //重新设置滑动防止拖动过快引起翻页
                }, 500);
                event.stopPropagation();
            }
        });
    }

    ResizeableAndDraggableBound.prototype._setUnResizable = function () {
        if(this.options){
            var content = this._options.content;
            content.resizable('destroy');
        }
    }

    ResizeableAndDraggableBound.prototype._setDraggable = function () {
        var content = this._options.content;
        if (!content) return;

        var startX, startY, endX, endY, originalLeft, originalTop, isDragging = false, oldZIndex, _self = this;
        var containerEle = _self._options.container;
        var scale = ResizeableAndDraggableBound.getTransformMatrix(this._options.container);

        //限制范围暂时只支持容器元素范围
        var containmentEle = containerEle;
        var selfFun = arguments.callee;
        var containmentEleOffset;

        if (!_self._pageIndex && containerEle.hasClass('pageItem')) {
            //因为pageItem默认绑定drop事件,这里已经可以实现拖拽了,所以把它禁用掉
            content.children().attr('draggable', false);
            _self._setPageIndex(content, containerEle);
        }

        var left, top, minLeft = 0, minTop = 0, maxLeft, maxTop;
        var actualWidth , actualHeight , isDoublePage;

        content.bind('mousedown.bound',function () {
            if (!$(event.target).hasClass('ui-resizable-handle') && !isDragging) {
                //每次重新计算限制区域，因为可能调整工具栏位置使其发生变化
                containmentEleOffset = containmentEle.offset();
                actualWidth = content.width() * scale[0], actualHeight = content.height() * scale[3];
                isDoublePage = $('.pageItem').length === 2 ? true : false;
                left = containmentEleOffset.left , top = containmentEleOffset.top;

                if (_self._pageIndex) {
                    var ele = containerEle.parent().parent();
                    var matrixTransform = ResizeableAndDraggableBound.getTransformMatrix(ele);
                    left += (matrixTransform[0] - 1) * ele.width() / 2 - matrixTransform[4], top += (matrixTransform[3] - 1) * ele.height() / 2 - matrixTransform[5];
                }

                _self._containmentRect = new _model.Bound(left, top, containmentEle.width() * scale[0], containmentEle.height() * scale[3]);
                maxLeft = _self._containmentRect.width - actualWidth, maxTop = _self._containmentRect.bottom - actualHeight - top;

                var point = new _model.Point(event.clientX, event.clientY);
                if (_self._containmentRect.isContainsPoint(point)) {
                    startX = point.x, startY = point.y;
                    originalLeft = content[0].offsetLeft * scale[0], originalTop = content[0].offsetTop * scale[3];
                    isDragging = true;

                    oldZIndex = content.css('z-index');
                    if (oldZIndex == 'auto' || !oldZIndex) oldZIndex = 0;
                    content.css('z-index', oldZIndex + 1);
                    //禁止滑动防止拖动过快引起翻页
                    _self._bookContainer.trigger("unSwipable").trigger("unDraggable");
                    //触发dragStart事件
                    _self.trigger('dragStart');
                }
            }
        }).bind('mousemove.bound',function () {
                if (isDragging) {

                    endX = originalLeft + event.clientX - startX;
                    endY = originalTop + event.clientY - startY;

                    var hasCrossPage = false;
//                                console.log(minLeft,minTop,endX,endY);
                    if (endX >= minLeft && endX <= maxLeft) content.css('left', endX / scale[0]);
                    else if (_self._pageIndex && isDoublePage) {
                        if (_self._pageIndex === 1 && endX >= maxLeft + Math.min(actualWidth / 3, 250)) {
                            endX = endX <= _self._containmentRect.width ? 0 : (endX - _self._containmentRect.width);
                            _self._pageIndex = 2;
                            hasCrossPage = true;
                        }
                        else if (_self._pageIndex === 2 && endX <= -Math.min(actualWidth / 2, 200)) {
                            endX = -endX <= actualWidth ? maxLeft : (_self._containmentRect.width + endX);
                            _self._pageIndex = 1;
                            hasCrossPage = true;
                        }
                    }
                    if (endY >= minTop && endY < maxTop) {
                        content.css('top', endY / scale[3] + "px");
                    }
                    //是否跨页了
                    if (hasCrossPage) {
                        //触发crossChange事件，如果crossChange返回true,说明事件处理函数已经处理该事件，否则执行默认操作
                        endX = endX / scale[0], endY = endY / scale[3];
                        if (!_self.triggerHandler('crossPage', [_self._pageIndex, endX, endY, actualWidth / scale[0], actualHeight / scale[3]])) {
                            _self._setUnDraggable();
                            _self._setUnResizable();
                            _self._anotherPageItem.append((_self._options.content = content.clone(true)
                                .css('left', endX)));
                            var temp = _self._anotherPageItem;
                            _self._anotherPageItem = containerEle;
                            _self._options.container = temp;
                            content.unbind('remove').remove();
                            content.triggerHandler('mouseup.bound');
                            //重新绑定事件
                            selfFun.apply(_self);
                        }
                    }
                }
            }).bind('mouseup.bound mouseout.bound', function () {
                if (isDragging) {
                    setTimeout(function () {
                        //重新设置滑动防止拖动过快引起翻页
                        _self._bookContainer.trigger("swipable").trigger("draggable");
                    }, 500);
                    isDragging = false;
                    content.css('z-index', oldZIndex);
                }
            });
    }

    ResizeableAndDraggableBound.prototype._setUnDraggable = function () {
        var content = this._options.content;
        content.unbind('.bound');
    }


    ResizeableAndDraggableBound.prototype._setPageIndex = function (content, containerEle) {
        var _self = this;
        var fun = arguments.callee;
        var pageItems = $('.pageItem');
        //页面可能没加载完成,轮询。
        if (pageItems.length) {
            clearTimeout(_self._timeId);
            if (containerEle[0] === pageItems[0]) {
                _self._pageIndex = 1;
                _self._anotherPageItem = $(pageItems[1]);
            }
            else {
                _self._pageIndex = 2;
                _self._anotherPageItem = $(pageItems[0]);
            }
        }
        else _self._timeId = setTimeout(function () {
            fun.apply(_self, [content, containerEle])
        }, 300);
    }


    /**
     *获得区域大小
     * @param {object=} _bound
     * @returns {*}
     */
    ResizeableAndDraggableBound.prototype.getBound = function (_bound) {

        var content = this._options.content;
        if (content) {
            if (content.css('display') && content.css('display') != 'none') {
                this._bound = new _model.Bound(parseFloat(content.css('left')), parseFloat(content.css('top')), content.width(), content.height());
            }
            else if (!this._bound) {
                this._bound = new _model.Bound(this._options.left, this._options.top, this._options.width, this._options.height);
            }
        }

        if (_bound) $.extend(this._bound, _bound);
//        this.correctBound(this._bound);
        this._bound.width = this._bound.width < this._options.minWidth ? this._options.minWidth : this._bound.width;
        this._bound.height = this._bound.height < this._options.minHeight ? this._options.minHeight : this._bound.height;
        return $.extend({}, this._bound);
    }


    //更正区域大小
    ResizeableAndDraggableBound.prototype.correctBound = function (bound) {

        if (!bound) return;
        var containmentEle = this._options.container, content = this._options.content;
        var matrixTransform = ResizeableAndDraggableBound.getTransformMatrix(content);
        var offsetX = (matrixTransform[0] - 1) * bound.width / 2, offsetY = (matrixTransform[3] - 1) * bound.height / 2;
        var actualWidth = bound.width * matrixTransform[0],
            actualHeight = bound.height * matrixTransform[3];

        if (bound.left < offsetX) {
            bound.width += bound.left - offsetX;
            bound.left = offsetX;
        }

        if (bound.top < offsetY) {
            bound.height += bound.top - offsetY;
            bound.top = offsetY;
        }

        var maxLeft = containmentEle.outerWidth(), maxTop = containmentEle.outerHeight();
        if (bound.left + actualWidth > maxLeft) {
            bound.width = maxLeft - bound.left - offsetX;
        }
        if (bound.top - offsetY + actualHeight > maxTop) {
            bound.height = maxTop - bound.top - offsetY;
        }
    }


    //设置参数
    ResizeableAndDraggableBound.prototype.setOptions = function (options) {
        if (!$.isPlainObject(options)) return;
        if(!this._options){
            this._options = {}
        };
        var isDraggable = options['draggable'], isResizeable = options['resizable'];
        if (isDraggable != undefined && isDraggable != this._options['draggable'])
            isDraggable ? this._setDraggable() : this._setUnDraggable();

        if (isResizeable != undefined && isResizeable != this._options['resizable'])
            isResizeable ? this._setResizeable() : this._setUnResizable();

        this._options = $.extend(this._options, options);
    }

    //获得参数
    ResizeableAndDraggableBound.prototype.getOption = function (name) {
        return this._options[name];
    }

    ResizeableAndDraggableBound.prototype.show = function (bound) {
        if (!this._options.content || !this._options.container) return;

        if (!bound) this.getBound();
        else {
            this.correctBound(bound);
            this._bound = bound;
        }
        this._options.content.css({left: this._bound.left, top: this._bound.top, width: this._bound.width, height: this._bound.height});
        if (!this._hasInit) {
            this._bindCommands();
            if (!this._options.content.parents(this._options.container).length) this._options.container.append(this._options.content);
            this._hasInit = true;
        }
        this._options.style['position'] = 'absolute';
        this._options.content.css(this._options.style).show();
    }

    ResizeableAndDraggableBound.prototype.hide = function () {
        var content = this._options.content;
        if (content.css('display') && content.css('display') !== 'none') {
            this.getBound();
            this._options.content.hide();
        }
    }

    ResizeableAndDraggableBound.prototype.destroy = function () {
        if (this._options) {
            this._setUnDraggable();
            this._setUnResizable();
            this._options = null;
        }
    }

    ResizeableAndDraggableBound.getTransformMatrix = function (ele) {
        var matrix = [1, 0, 0, 1, 0, 0];
        if (ele) {
            var matrixTransform = ele.css('-webkit-transform');
            if (matrixTransform && matrixTransform != 'none')  matrix = matrixTransform.substr(7, matrixTransform.length - 8).split(",");
        }
        return matrix;
    };

    module.exports = ResizeableAndDraggableBound;
})
