/**
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-12-12
 * Time: 下午5:30
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports) {
        var _shellcmd = require('./shellcmd');


        function RemoteBookDirectoryAccess() {
            var _self = this;

            /**
             * 读保存在本地的书本目录JSON
             * @param localFilePath
             * @returns {*}
             */
            _self.getBookDirFromFile = function (localFilePath) {
                var def = $.Deferred();
                _shellcmd.isFileExist(localFilePath).done(function (ret) {
                    if (ret) { //读本地文件
                        _shellcmd.readFileAsync(localFilePath).done(function (content) {
                            try {
                                var jsonObj = JSON.parse(content);
                                def.resolve(jsonObj);
                            } catch (ex) {
                                def.resolve(null);
                                return def.promise();
                            }
                        });
                    } else {
                        def.resolve(null);
                    }
                });
                return def.promise();
            }

            /**
             * 从远程下载书本目录JSON
             * @param localFilePath
             * @param bookId
             * @returns {*}
             */
            _self.getBookDirFromWeb = function (localFilePath, bookId,user) {
                var def = $.Deferred();
                var bookDirUrl = AppRemoteSvcCfg.GetBookDirUrl.replace("{0}", bookId);
                user.getDataByUserToken(bookDirUrl).done(function (content) {
             //   _shellcmd.getHttpRequest(bookDirUrl).done(function (content) {
                    try {
                        //在我接手这一块的时候，传递回来的结果就已经是json了  ----  by yczhu
                        def.resolve(content);
                    } catch (ex) {
                        def.resolve(null);
                        return def.promise();
                    }
                });
                return def.promise();
            }

            /**
             * 将书本目录JSON保存到本地
             * @param content
             * @param localFilePath
             */
            this.saveRemoteBookDir=function(content,localFilePath){
                if (content) _shellcmd.saveFilAsync(JSON.stringify(content), localFilePath);
            }
        }

        exports.RemoteBookDirectoryAccess = RemoteBookDirectoryAccess;
    }

)
;