define(function(require,exports){
    require('jquery');
    var shellcmd = require('./common/shellcmd');
    var ebookContext = require('./app/ebookcontext').Instance;
    var _Des = require('./common/des');
    var fs = nodereq('fs');
    var commFunc = require('./common/commonfunc');
    var userInfo = null;
    var uliDat = process.execPath.replace('nw.exe', 'uli.dat');

    var template = '<div style="position: absolute;left:0px;top:0px;z-index: 500;width:100%;height:100%;display: none">'+
        '<div class="jxpop-box" style="width:448px;display:none;position:absolute;z-index:1000;" id="classSelector">'+
        '    <div class="jxpop-tab"><p>发送</p><p><a class="close" href="javascript:void(0)"><i class="icon iconfont" name="close">&#xe60a;</i></a></p></div>'+
        '    <div class="jxpop-main">'+
        '        <div class="jxpop-infolist">'+
        '            <dl class="clearfix">'+
        '                <dt class="w110">请选择要发送的班级</dt>'+
        '                <dd class="clearfix">'+
        '                    <select class="select-list fl select-list4" name="" style="width:222px;" id="snapshot_classList">'+
        '                        <option>全部</option>'+
        '                    </select>'+
        '                    <span style="width: 214px;" class="select-list fl select-list4" id="snapshot_noClass"><p style="margin-top: 4px;margin-left: 4px;">待创建</p></span>'+
        '                    <span class="ml4"><a href="#" id="refresh_snapshotClass" title="刷新班级"><em class="icon iconfont" style="font-size: 22px;">&#xe637;</em></a></span>'+
        '                </dd>'+
        '            </dl>'+
        '        </div>'+
        '        <div class="mb-10 ml4">#课堂实录#</div>'+
        '        <div class="jxpop-poety" style="width:418px;height:250px;text-align: center;vertical-align: middle;"><img style="width:100%;height:100%;" src=""></div>'+
        '    </div>'+
        '    <div class="jxpop-btnbar jxpop-notline">'+
        '        <button type="button" class="btn-blue btnconfirm" name="complete">确定</button>'+
        '        <button type="button" class="btn-gray btncancel" name="cancel">取消</button>'+
        '    </div>'+
        '</div>'+
    '</div>';
    var _domSnapshot = $(template);
    _domSnapshot.appendTo("body");
    _domSnapshot.find("#classSelector").draggable({
        cursor: "move",
        containment: $("#bookContainer"),
        handle: ".jxpop-tab"
    });
    var _close = _domSnapshot.find(".close"); //关闭弹出框
    var _createClass = _domSnapshot.find('#snapshot_noClass');//创建班级
    var _classInfo = _domSnapshot.find('#snapshot_classList'); //班级列表
    var _refresh_class = _domSnapshot.find('#refresh_snapshotClass'); //刷新班级列表
    var _class_ok = _domSnapshot.find("button[name='complete']");
    var _class_no = _domSnapshot.find("button[name='cancel']");
    var _classInfo_no = $('#snapshot_noClass');
    var fileFullPath = ''; //文件全路径
    var labelName = '';
    var attachType = 0;
    var duration = 0;

    var phaseToGrade = [
        {
            "phase": "01",
            "grade": [
                {
                    "code": "14",
                    "name": "幼儿园小班"
                },
                {
                    "code": "15",
                    "name": "幼儿园中班"
                },
                {
                    "code": "16",
                    "name": "幼儿园大班"
                },
            ]
        },
        {
            "phase": "02",
            "grade": [
                {
                    "code": "17",
                    "name": "学前班"
                }
            ]
        },
        {
            "phase": "03",
            "grade": [
                {
                    "code": "01",
                    "name": "一年级"
                },
                {
                    "code": "02",
                    "name": "二年级"
                },
                {
                    "code": "03",
                    "name": "三年级"
                },
                {
                    "code": "04",
                    "name": "四年级"
                },
                {
                    "code": "05",
                    "name": "五年级"
                },
                {
                    "code": "06",
                    "name": "六年级"
                },
            ]
        },
        {
            "phase": "04",
            "grade": [
                {
                    "code": "07",
                    "name": "七年级"
                },
                {
                    "code": "08",
                    "name": "八年级"
                },
                {
                    "code": "09",
                    "name": "九年级"
                },
            ]
        },
        {
            "phase": "05",
            "grade": [
                {
                    "code": "10",
                    "name": "高一"
                },
                {
                    "code": "11",
                    "name": "高二"
                },
                {
                    "code": "12",
                    "name": "高三"
                },
            ]
        },
    ];

    var template = '<div style="position: absolute;left:0px;top:0px;z-index: 500;width:100%;height:100%;display: none">'+
		'<div class="jxpop-box" style="width:448px;display:none;position:absolute;z-index:1000;" id="classSelector">'+
        '<div class="jxpop-tab"><p>发送</p><p><a class="close" href="javascript:void(0)"><i class="icon iconfont">&#xe60a;</i></a></p></div>'+
        '<div class="jxpop-main">'+
        '<div class="jxpop-infolist">'+
        '<dl class="clearfix">'+
        '<dt class="w110">请选择要发送的班级</dt>'+
        '<dd class="clearfix">'+
        '<select class="select-list fl select-list7 classList" name="" style="width:auto">'+
        '</select>'+
        '</dd>'+
        '</dl>'+
        '</div>'+
        '<div class="mb-10 ml4">#课堂实录#</div>'+
        '<div class="jxpop-poety" style="width:418px;height:250px"><img style="width:418px;height:auto" src=""></div>'+
        '</div>'+
        '<div class="jxpop-btnbar jxpop-notline">'+
        '<button type="button" class="btn-blue btnconfirm">确定</button>'+
        '<button type="button" class="btn-gray btncancel">取消</button>'+
        '</div>'+
        '</div></div>';

    var classInfo = "";

    _classInfo.unbind('change').on('change',function () {
        var $this = $(this).find('option:selected');
        $(this).attr('title',$this.attr('grade')+$this.attr('attrName'));
    });

    _class_ok.unbind('click').on('click', function () {
        console.log('start send data');

        //获取选择的班级id
        var classIdArr = [];
        var selectDom = _classInfo.find('option:selected');
        var classId = selectDom.attr('classId') || "0";
        //选择了全部
        if(classId == "0"){
            _classInfo.find('option').each(function() {
                var cid = $(this).attr('classId');
                if(cid != "0" && (-1 == jQuery.inArray(cid,classIdArr))){
                    classIdArr.push(cid);
                }
            });
            if(classIdArr.length > 0){
                classId = classIdArr.join(',');
            }
        }
        var attachName = '';
        if (fileFullPath) {
            attachName = fileFullPath.slice(fileFullPath.lastIndexOf('/') + 1, fileFullPath.length);
        }
        var param = {
            file: fileFullPath,
            ownerId: ebookContext.getUser().getUid(),
            classIds: classId,
            labelName: labelName || '课堂记录',
            attachType: attachType,
            duration: duration,
            attachName: attachName
        };
        api_jx_feed_add(param).done(function(){
            //关闭弹窗并重置模板数据
            _domSnapshot.hide();
            resetDomSnapshot();
        }).fail(function(e){
            console.log(e);
            //关闭弹窗并重置模板数据
            _domSnapshot.hide();
            resetDomSnapshot();
            tipsDialog({
                "id":"snapshotFail" + new Date().getTime(),
                "content":"快照发送失败..."
            });
        });
    });
    _class_no.unbind('click').on('click', function () {
        _domSnapshot.hide();
        resetDomSnapshot();
    });

    _close.unbind('click').on('click', function () {
        _domSnapshot.hide();
        resetDomSnapshot();
    });

    _refresh_class.unbind('click').on('click', function () {
        getLessonInfo();
    });

    _createClass.unbind('click').on('click', function () {
        // shellcmd.openPageOutside(Base_Cfg.YUN_CREATE_CLASS);
        //des单点登录跳转地址
        // loginUrl(Base_Cfg.YUN_CREATE_CLASS_BASE);

        //和课堂实录待创建一致，不作跳转了
        //sso单点登录跳转地址
        // commFunc.openWebPage(Base_Cfg.YUN_CREATE_CLASS_BASE + '&' + 'from=ew&appId=web');
    });

    //该方法废弃(html写在index.html模板里) -- by xinfang
    //获取selector,未创建时，创建selecotr
    var getSelector = function(){
        var selecor = $("#classSelector");
        if(selecor.length == 0){
            $("body").append(template);
            selecor = $("#classSelector");
        }
        return selecor;
    };

    //该方法废弃(html写在index.html模板里) -- by xinfang
    //调整弹窗的位置
    var trimCss = function(){
        var selecor = getSelector();
        selecor.css({
            //"top":$("#wrap").height()/2 - selecor.height()/2,
            "top":$("#wrap").height()/4,
            "left":$("#wrap").width()/2 - selecor.width()/2
        })
    }

    //该方法废弃(html写在index.html模板里) -- by xinfang
    //获取班级id
    var getClassIdSelected = function(){
        var selecor = getSelector();
        var classId = selecor.find("option:selected").attr("classid");
        var classes = [];
        if(classId == 0){
            for(var i = 0;i < classInfo.length; i++){
                classes.push(classInfo[i].classId);
            }
        }
        else{
            classes.push(classId);
        }

        return classes.length > 0 ? classes.join(",") : null;
    }

    //该方法废弃(html写在index.html模板里) -- by xinfang
    var resetSelector = function(selecor,callback){
        selecor.find("option").remove();
        selecor.off();
        selecor.on("click",".close,.btncancel",function(e){
            selecor.parent().hide();
            selecor.hide();
            callback(false);
        })
        selecor.on("click",".btnconfirm",function(e){
            selecor.parent().hide();
            selecor.hide();
            callback(true,getClassIdSelected());
        })
    }

    //该方法废弃(html写在index.html模板里) -- by xinfang
    //完善班级名称
    var fixClassName = function(classInfo){
        var curDate = new Date();
        var curYear, curMonth, curDay;
        curYear = curDate.getFullYear();//当前年
        curMonth = curDate.getMonth() + 1;//当前月
        curDay = curDate.getDate();//当前天
        curPhase = classInfo.phase;//当前学段
        var startYear = classInfo.year;
        var attrGrade = "", attrClassName = "";
        if (curPhase == "" || curPhase == null || curPhase == undefined) {
            attrGrade = startYear + "级";
        } else {
            var gradeIdx = curYear - startYear;
            switch (curPhase) {//找到当前学段号对应的学段
                case '01':
                    phaseIndex = 0;
                    break;
                case '02':
                    phaseIndex = 1;
                    break;
                case '03':
                    phaseIndex = 2;
                    break;
                case '04':
                    phaseIndex = 3;
                    break;
                case '05':
                    phaseIndex = 4;
                    break;
            }

            if ((curMonth > 8 && curDay >= 15) || curMonth > 9) {
                if (gradeIdx >= 1) {
                    if (gradeIdx < phaseToGrade[phaseIndex].grade.length) {
                        gradeIdx++;//超过九月中旬的了  加一年级

                    } else if (gradeIdx == phaseToGrade[phaseIndex].grade.length) {
                        gradeIdx = 1;
                        phaseIndex++;
                    } else {
                        gradeIdx = gradeIdx - phaseToGrade[phaseIndex].grade.length;
                        phaseIndex++;
                    }
                    attrGrade = phaseToGrade[phaseIndex].grade[gradeIdx - 1].name;
                } else {
                    attrGrade = phaseToGrade[phaseIndex].grade[gradeIdx].name;
                }
            } else {
                if (gradeIdx >= 1) {
                    if (gradeIdx > phaseToGrade[phaseIndex].grade.length) {
                        gradeIdx = gradeIdx - phaseToGrade[phaseIndex].grade.length;
                        phaseIndex++;
                    }
                    attrGrade = phaseToGrade[phaseIndex].grade[gradeIdx - 1].name;
                } else {
                    attrGrade = phaseToGrade[phaseIndex].grade[gradeIdx].name;
                }

            }

        }
        attrClassName = classInfo.className;
        className = attrGrade + attrClassName;
        return className;
    };

    //该方法废弃(html写在index.html模板里) -- by xinfang
	/*
	 显示班级选择弹出框，并展示发送文件
	 */
    var show = function(f,options,callback){
        if(Object.prototype.toString.call(options) == "[object Function]"){
            callback = options;
            options = {};
        }
        var selecor = getSelector();
        selecor.hide();
        var uid = ebookContext.getUser().getUid();
        var role = ebookContext.getUser().getUserRole();
        var schoolsUrl = AppCenterSvcHelper.CYSVC+ "&method=jx.class.list&userId=" + uid + '&roleName='+role;
        ebookContext.getUser().getDataByUserToken(schoolsUrl).done(function(ret){
            classInfo = ret;

            resetSelector(selecor,callback);
            if(classInfo instanceof Array && classInfo.length > 0){
                trimCss();
                selecor.parent().show();
                selecor.show();
                $("#classSelector").find(".classList").append('<option classid=0>全部</option>');
                $.each(classInfo, function(i, n){
                    var el = "<option classid="+ n.classId +">"+fixClassName(n)+"</option>";
                    $("#classSelector").find(".classList").append(el);
                })

                var img = $("#classSelector").find("img")[0];
                img.onload = function(){
                    $("#classSelector .jxpop-poety").css("background","url('')");
                    var imgWidth = img.width;
                    var imgHeight = img.height;
                    console.log(imgWidth,imgHeight);
                    var imgRate = imgWidth / imgHeight;
                    var width = $("#classSelector .jxpop-poety").width();
                    var height = $("#classSelector .jxpop-poety").height();
                    console.log(width,height);
                    var rate = width/height;
                    if(imgRate < rate){
                        $("#classSelector img").width(imgWidth * height / imgHeight);
                        $("#classSelector img").height(height);
                    }
                    else{
                        $("#classSelector img").width(width);
                        $("#classSelector img").height(imgHeight * width / imgWidth);
                    }
                    console.log(width,height);
                }
                img.src = f;
            }
        })
    };

    function FormatClassInfo(_userInfo, data) {
        var orgClass = [], freeClass = [];
        var classList = data.extInfo.orgClass || [], freeClassList = data.extInfo.freeClass || [];
        for (var i = 0, count = classList.length; i < count; i++) {
            var item = classList[i];
            var rs = {
                "classCode": item.classShortId || "",
                "classShortId": item && item.classShortId || "",
                "classId": item.id || "",
                "className": item.className || "",
                "shortName": item.shortName || "",
                "eduSystem": item.eduSystem || "",
                "classLabel": item.classLabel || "",
                "classOrder": item.classOrder || "",
                "passed": item.passed || "",
                "createTime": "undefined",
                "phase": item.phase || "",
                "schoolId": item.schoolId || "",
                "schoolName": "undefined",
                "studentCount": "undefined",
                "subject": "undefined",
                "subjectName": "undefined",
                "year": item.year || "",
                "extInfo": item.extInfo || ""
            };
            orgClass.push(rs);
        }
        //这里对自由班级做格式化处理，是为了在后期班级合并展示时避免兼容性问题
        for (var i = 0, count = freeClassList.length; i < count; i++) {
            var item = freeClassList[i];
            var rs = {
                "classCode": item.classShortId || "undefined",
                "classShortId": item.classShortId || "",
                "classId": item.id || "",
                "className": item.className || "",
                "shortName": "undefined",
                "eduSystem": "undefined",
                "classLabel": "undefined",
                "classOrder": "undefined",
                "passed": "undefined",
                "createTime": "undefined",
                "grade": item.grade || "",
                "phase": item.phase || "",
                "schoolId": item.schoolId || "",
                "schoolName": "undefined",
                "studentCount": "undefined",
                "subject": "undefined",
                "subjectName": "undefined",
                "year": item.year || "",
                "extInfo": item.extInfo || ""
            };
            freeClass.push(rs);
        }
        _userInfo.classInfo = orgClass;
        _userInfo.freeClass = freeClass;
        userInfo = _userInfo;
        return userInfo;

    }

    function getClassInfo(callback) {
        getUserInfo(function (userInfo) {
            var p = {
                userId: userInfo._user_openId,
                openId: userInfo._sso_openId
            };
            edcService.Instance().core_user_org_detail(p).done(function (ret) {
                if (ret && ret.code == 0) {
                    callback && callback(FormatClassInfo(userInfo, ret.data));
                } else {
                    callback && callback(userInfo);
                }

            }).fail(function () {
                callback && callback(userInfo);
            });
        });
    }

    function resetDomSnapshot() {
        fileFullPath = '';
        attachType = 0;
        duration = 0;
        var selector = $(_domSnapshot.find("#classSelector"));
        selector.find("img")[0].src = '';
        _classInfo.append('');
        _classInfo_no.show();
        _classInfo.hide();
    }

    /**
     * 获取用户信息
     * @param callback 回调
     */
    function getUserInfo(callback) {
        if (userInfo) callback(userInfo);
        else {
            shellcmd.readFileAsync(uliDat).done(function (ret) {
                userInfo = JSON.parse(ret);
                callback(userInfo);
            })
        }
    }

    function formatClassShow(str) {
        return str.length>16?str.substr(0,15)+'...':str;
    }

    /**
     * 请求班级接口，将结果显示在快照弹框中
     * @param callback
     */

    function getLessonInfo(callback) {
        getClassInfo(function (userInfo) {
            var selectAllTemplate = '<option grade = "" attrName="" isFree="{{Free}}" classId="0">全部</option>';
            var optionTemplate = '<option grade = "{{attrGrade}}" attrName="{{attrClassName}}" isFree="{{Free}}" classId="{{classId}}">{{className}}</option>';
            var optionStr = '';
            var orgClass = null, freeClass = null, curPhase;
            var className, startYear, curDate;
            var phaseIndex = 0;
            curDate = new Date();
            var curYear, curMonth, curDay;

            curYear = curDate.getFullYear();//当前年
            curMonth = curDate.getMonth() + 1;//当前月
            curDay = curDate.getDate();//当前天
            orgClass = userInfo.classInfo;//获取行政班级信息
            freeClass = userInfo.freeClass;//获取自由班级信息
            var classInfoTemp = orgClass, classInfo = [];

            // var classInfoTemp = $.merge(orgClass, freeClass), classInfo = [];
            if (classInfoTemp.length) {
                classInfo[0] = classInfoTemp[0];
                classInfo[0].isFree = false;
            } //班级列表有可能为空
            for (var k = 1, l = classInfoTemp.length; k < l; k++) {
                //--------去除自由班级--------------
                classInfo[k] = classInfoTemp[k];
                classInfo[k].isFree = false;
                //--------------------------------
                // var flag = true;
                // for (var j = 0, ll = classInfo.length; j < ll; j++)
                //     if (classInfo[j].classId == classInfoTemp[k].classId) {
                //         flag = false;
                //         break;
                //     }
                // if (flag) {
                //     if (classInfoTemp[k].phase == "") {
                //         classInfoTemp[k].isFree = true;
                //     } else {
                //         classInfoTemp[k].isFree = false;
                //     }
                //     classInfo[classInfo.length] = classInfoTemp[k];
                // }

            }
            for (var i = 0; i < classInfo.length; i++) {
                var attrGrade = "", attrClassName = "";
                curPhase = classInfo[i].phase;//当前学段
                startYear = classInfo[i].year;
                if (curPhase == "" || curPhase == null || curPhase == undefined) {
                    attrGrade = startYear + "级";
                } else {
                    var gradeIdx = curYear - startYear;
                    switch (curPhase) {//找到当前学段号对应的学段
                        case '01':
                            phaseIndex = 0;
                            break;
                        case '02':
                            phaseIndex = 1;
                            break;
                        case '03':
                            phaseIndex = 2;
                            break;
                        case '04':
                            phaseIndex = 3;
                            break;
                        case '05':
                            phaseIndex = 4;
                            break;
                    }

                    if ((curMonth > 8 && curDay >= 15) || curMonth > 9) {
                        if (gradeIdx >= 1) {
                            if (gradeIdx < phaseToGrade[phaseIndex].grade.length) {
                                gradeIdx++;//超过九月中旬的了  加一年级

                            } else if (gradeIdx == phaseToGrade[phaseIndex].grade.length) {
                                gradeIdx = 1;
                                phaseIndex++;
                            } else {
                                gradeIdx = gradeIdx - phaseToGrade[phaseIndex].grade.length;
                                phaseIndex++;
                            }
                            attrGrade = phaseToGrade[phaseIndex].grade[gradeIdx - 1].name;
                        } else {
                            attrGrade = phaseToGrade[phaseIndex].grade[gradeIdx].name;
                        }
                    } else {
                        if (gradeIdx >= 1) {
                            if (gradeIdx > phaseToGrade[phaseIndex].grade.length) {
                                gradeIdx = gradeIdx - phaseToGrade[phaseIndex].grade.length;
                                phaseIndex++;
                            }
                            attrGrade = phaseToGrade[phaseIndex].grade[gradeIdx - 1].name;
                        } else {
                            attrGrade = phaseToGrade[phaseIndex].grade[gradeIdx].name;
                        }

                    }

                }


                attrClassName = classInfo[i].className;
                className = attrGrade + attrClassName;
                var tpmStr = optionTemplate.replace('{{className}}', formatClassShow(className)).replace('{{attrClassName}}', attrClassName)
                    .replace('{{attrGrade}}', attrGrade).replace('{{Free}}', classInfo[i].isFree).replace('{{classId}}', classInfo[i].classId);
                optionStr += tpmStr;
            }
            _classInfo.find('option').remove();
            if(optionStr == "" || classInfo.length == 1){
                _classInfo.append(optionStr);
            }else{
                _classInfo.append(selectAllTemplate + optionStr);
            }
            var firstOption = _classInfo.find('option:first');
            _classInfo.attr('title',firstOption.attr('grade')+firstOption.attr('attrName'));
            // getHistoryClass(userInfo._sso_openId);
            if (optionStr == "") {
                _classInfo_no.show();
                _classInfo.hide();
                callback && callback(false);
            } else {
                _classInfo_no.hide();
                _classInfo.show();
                callback && callback(true);
            }
        });
    }

    /**
     * 分享文件到畅言云班级
     * options = {
     *  file: //截图文件地址
     *  ownerId: //用户uid
     *  classIds: //班级id(string,多个用英文逗号隔开)
     *  content: // 课程名称
     *  attachInfo: // 固定值
     *  labelName: //label名称
     * }
     * @param options
     */
    function api_jx_feed_add(options){
        var def = jQuery.Deferred();
        if (!options || typeof options !== "object" ) {
            options = {};
        }
        var pm = app_global_bookContainer.getCurrPageMetadata();
        var content = pm.unit4Name || pm.unit3Name || pm.unit2Name || pm.unit1Name || '';
        var attachType = options && options.attachType || 0;
        var duration = options && options.duration || 0;
        var attachName = options && options.attachName || '';
        var s = {
            file: '',
            ownerId: ebookContext.getUser().getUid(),
            classIds: '',
            content: content,
            attachInfo: '[{"attachType":' + attachType + ',"duration":' + duration + ',"attachName":"' + encodeURI(attachName) + '"}]',
            labelName: '课堂记录'
        };

        // 赋值
        options.file = options.file || s.file;
        options.ownerId = options.ownerId || s.ownerId;
        options.classIds = options.classIds || s.classIds;
        options.content = options.content || s.content;
        options.attachInfo = options.attachInfo || s.attachInfo;
        options.labelName = options.labelName || s.labelName;

        //解析content和labelId(根据labelName匹配)
        content = encodeURI(options.content);
        var labelId = '';

        var labelIdUrl = AppCenterSvcHelper.CYSVC +"&method=jx.label.extend.list&labelType=3";
        ebookContext.getUser().getDataByUserToken(labelIdUrl).done(function(labelRet){
            $.each(labelRet,function(){
                if(this.labelName == options.labelName){
                    labelId = this.labelId;
                }
            })
            shellcmd.getHttpRequestJSON(AppRemoteSvcCfg.ClientToken).done(function(ret){
                if(ret){
                    app_ClientToken = ret.access_token;
                    url = AppCenterSvcHelper.CYSVC +"&method=jx.feed.add&ownerId=" + options.ownerId +'&classIds='+options.classIds+ '&access_token='+app_ClientToken+'&content='+content+'&attachInfo='+options.attachInfo+'&labelIds='+labelId+'&fromApp=3';
                    var obj = {"type":"logic",
                        "action":"ta_upload",
                        "from":"ib",
                        "to":"ta_dum",
                        "id":0,
                        "data":{"id":"abc","key":"attachments","url":url,"file": options.file}
                    };
                    socket.send(obj);
                    def.resolve();
                }else{
                    def.reject(ret);
                    console.error('access_token get error');
                }
            }).fail(function(e){
                console.error(e);
                def.reject(e);
            });
        }).fail(function(e){
            console.error(e);
            def.reject(e);
        });
        return def.promise();
    }

    /**
     * 发送到班级功能弹窗
     * @param file //jx.feed.add接口参数，要上传的文件地址（必填，重要）
     * @param options
     * {
     *  labelName:,  //jx.feed.add接口labelId依赖的labelName（必填，重要）
     *  showLableName:, //显示在弹窗中 ## 之间的标签文字（默认'课堂实录'）
     *  showPic:, //显示在弹窗中的图片（有默认值，建议传该参数）
     *  attachType:, //jx.feed.add接口参数（必填，重要）
     *  duration:, //jx.feed.add接口参数（默认0）
     *  }
     * @param callback //这个参数未使用
     */
    function render(file,options,callback) {
        fileFullPath = file;
        if(Object.prototype.toString.call(options) == "[object Function]"){
            callback = options;
            options = {};
        }

        //要展示的lableName文字，注意不是lableName实际值
        var showLableName = '课堂实录';
        //要展示的图片，注意不是file实际值
        var showPic = '';
        var userId = ebookContext.getUser().getUid();
        if(userId == 0){
            app_global_loginMgr.show();
            return;
        }

        labelName = options && options.labelName || '课堂记录';
        showLableName = options && options.showLableName || showLableName;
        attachType = options && options.attachType || 0;
        duration = options && options.duration || 0;

        if(options && options.showPic){
            showPic = options.showPic;
        }else{
            switch(labelName){
                case '课堂记录':
                    showPic = file;
                    break;
                case '课堂同步资源':
                    showPic = 'assert/images/default_01.jpg';
                    break;
                default:
                    showPic = '';
                    break;
            }
        }
        //检查用户班级信息是否存在
        getLessonInfo(function(existClass){
            if(existClass){
                var selector = $(_domSnapshot.find("#classSelector"));
                //显示labelName
                selector.find("#snapshot_showLabelName").text('').text(showLableName);
                //加载图片
                var img = selector.find("img")[0];
                img.onload = function(){
                    selector.find(".jxpop-poety").css("background","none");
                    var imgWidth = img.width;
                    var imgHeight = img.height;
                    console.log(imgWidth,imgHeight);
                    var imgRate = imgWidth / imgHeight;
                    var width = selector.find(".jxpop-poety").width();
                    var height = selector.find(".jxpop-poety").height();
                    console.log(width,height);
                    var rate = width/height;
                    if(imgRate < rate){
                        selector.find("img").width(imgWidth * height / imgHeight);
                        selector.find("img").height(height);
                    }
                    else{
                        selector.find("img").width(width);
                        selector.find("img").height(imgHeight * width / imgWidth);
                    }
                    console.log(width,height);
                }
                img.src = showPic;

                //调整弹窗的位置
                _domSnapshot.css({
                    //"top":$("#wrap").height()/2 - selecor.height()/2,
                    "top":$("#wrap").height()/4,
                    "left":$("#wrap").width()/2 - selector.width()/2
                });
                selector.show();
                _domSnapshot.show();
            }else{
                // 没有班级数据，不作响应
                console.log('用户没有班级数据');
            }
        });

        // shellcmd.checkOnline().done(function(online) {
        //     if (online) {
        //         //检查用户班级信息是否存在
        //         getLessonInfo(function(existClass){
        //             if(existClass){
        //                 var selector = $(_domSnapshot.find("#classSelector"));
        //                 //显示labelName
        //                 selector.find("#snapshot_showLabelName").text('').text(showLableName);
        //                 //加载图片
        //                 var img = selector.find("img")[0];
        //                 img.onload = function(){
        //                     selector.find(".jxpop-poety").css("background","none");
        //                     var imgWidth = img.width;
        //                     var imgHeight = img.height;
        //                     console.log(imgWidth,imgHeight);
        //                     var imgRate = imgWidth / imgHeight;
        //                     var width = selector.find(".jxpop-poety").width();
        //                     var height = selector.find(".jxpop-poety").height();
        //                     console.log(width,height);
        //                     var rate = width/height;
        //                     if(imgRate < rate){
        //                         selector.find("img").width(imgWidth * height / imgHeight);
        //                         selector.find("img").height(height);
        //                     }
        //                     else{
        //                         selector.find("img").width(width);
        //                         selector.find("img").height(imgHeight * width / imgWidth);
        //                     }
        //                     console.log(width,height);
        //                 }
        //                 img.src = showPic;
        //
        //                 //调整弹窗的位置
        //                 _domSnapshot.css({
        //                     //"top":$("#wrap").height()/2 - selecor.height()/2,
        //                     "top":$("#wrap").height()/4,
        //                     "left":$("#wrap").width()/2 - selector.width()/2
        //                 });
        //                 selector.show();
        //                 _domSnapshot.show();
        //             }else{
        //                 // 没有班级数据，不作响应
        //                 console.log('用户没有班级数据');
        //             }
        //         });
        //     }else{
        //         tipsDialog({
        //             "id":"snapshotFail" + new Date().getTime(),
        //             "content":"您当前处于离线状态，请检查网络连接"
        //         });
        //     }
        // });
    }
    exports.show = show;
    exports.render = render;
    exports.getClassInfo = getClassInfo;
})
