define(function (require, exports) {

    var shellcmd = require('./common/shellcmd');
    var path = require('./common/path');
    var userLog = require('./app/logmgr').Instance;
    var confirmExit = require('./common/confirmExit');
    var _pageNavigatorHelper = require('./common/pagenavigatorhelper');
    var ebookContext = require('./app/ebookcontext').Instance;
    var clickLock = false;

    //禁用某些快捷键
    function disableKey() {
        $("body").keydown(function (e) {
            //如果type存在，则是text节点
            //反之是body，如果发现问题，再处理
            if (e.which == 8 && (!e.target.type)) {
                return false;
            }
            //屏蔽Alt+X热键（这里屏蔽了Alt键）
            if (e.which == 18 && (!e.target.type)) {
                return false;
            }
        });
    }

    //获得页面参数的方法
    function QueryString(val) {
        var uri = window.location.search;
        var reg = new RegExp("" + val + "=([^&?]*)", "ig");
        return ((uri.match(reg)) ? (uri.match(reg)[0].substr(val.length + 1)) : null);
    }
    //延迟创建快捷方式
    function createShortCutDelay() {
        setTimeout(createShortCut, 100);
    }
    //创建快捷方式
    var createShortCut = function () {
        if (AppCfg.isShortCut == false) {
            //create shortCut , just be showed at the first time after user login;
            var tips = $("<div><p style = 'margin-left: 0px;margin-top: 4px;font-size: 15px;color:black;'>确定创建快捷方式?</p>" +
                "<p style='margin-top: 6px;margin-bottom: 10px;'><a id='a_t' style='margin-left: 0px;font-size: 13px;color:rgb(140,140,140);'>默认创建到桌面</a>" +
                "<a id='tips' style='color:rgb(5,135,245);margin-left: 88px;font-size: 13px;cursor:pointer;'>更改路径</a></p></div></div>");
            var shortCutPath = 'desktop';

            tips.find('#tips').click(function () {
                if (clickLock == false) {
                    clickLock = true;
                    shellcmd.openDirSelect().done(function (ret) {
                        if (ret != "") {
                            tips.find('#a_t').html(ret);
                            shortCutPath = ret;
                            shortCutPath = shortCutPath.replace(/\\/g, '/');

                        }
                        clickLock = false;
                    });

                }

            });
            $.Zebra_Dialog(tips, {
                'type': 'ibicon',
                'title': AppTips.WarmTips,
                'buttons': [AppTips.CancelTips, AppTips.CreateTips],
                'onClose': function (capition) {
                    if (capition == AppTips.CreateTips) {
                        shellcmd.createShortCut(shortCutPath);
                        var rootPath = shortCutPath;
                        if (rootPath != 'desktop') {
                            if (rootPath.length == 3) {
                                rootPath = rootPath + 'iFlybook.lnk';
                            } else {
                                rootPath = rootPath + '/iFlybook.lnk';
                            }
                        }
                        // var regCmd = "reg add HKEY_CLASSES_ROOT\\.mtbk \/t reg_sz \/d \"" + '111' + '" \/f';
                        //                        var regCmd = "reg add HKEY_CURRENT_USER\\SOFTWARE\\iflytek\\TPlatform  \/v ifbShortcut \/t reg_sz \/d \"" + rootPath + '" \/f';
                        //                        var exec = nodereq("child_process").exec;
                        //                        var cmdHandler = exec(regCmd, {
                        //                            timeout: 0,
                        //                            maxBuffer: 200 * 1024,
                        //                            killSignal: 'SIGTERM'
                        //                        }, function (error) {
                        //                            if(error){
                        //                                console.log('error shortcut');
                        //                            }
                        //                        });
                        var regPath = 'HKEY_CURRENT_USER\\SOFTWARE\\iflytek\\TPlatform';
                        var regName = 'ifbShortcut';
                        var regType = 'reg_sz';
                        var regData = rootPath;
                        shellcmd.writeRegedit(regPath, regName, regType, regData);
                    }
                }
            });
            shellcmd.rewriteAppCfg(path.trimPosix(Config.binPath) + 'webapp/assert/js/appcfg.js');
        }
    }

    /**
     * 启动上传
     */
    function StartUpload(ebookuser) {
        //写上传参数文件，启动上传器
        ebookuser.setDynamicToken().done(function (token) {
            var obj = {
                'appkey': 'HWQIjW2K',
                'token': token,
                'uid': ebookuser.getUid(),
                'loginname': ebookuser.getName()
            }
            var str = JSON.stringify(obj);
            var filePath = Config.binPath + 'users/';
            shellcmd.saveFile(str, filePath + 'awdlog.cr');
            var uploadManagerexe = Config.binPath + 'iFlybookUploadMananger.exe';
            shellcmd.shellexecutewithargs(uploadManagerexe, AppRemoteSvcCfgBase.CYAPI);
            console.log('uploadManagerexe start success!');
            var configPath = path.trimPosix(Config.nwexePath + 'node_modules/Iflybook_modules/LogCenterExtract.cfg');
            configPath = path.trimPosix(configPath);
            configPath = path.toWindows(configPath);
            shellcmd.MonitorStart(configPath);
        });
    }

    /**
     * 更新用户授权
     */
    function writeUserLic() {
        //获取用户登录授权文件
        var _loginAssistor = require('./app/login/loginAssistor');
        var getHdTypeTask = shellcmd.getHardwareType();
        var getHdInfoTask = shellcmd.getHardwareInfo(ebookContext.getUser().getName());
        $.when(getHdTypeTask, getHdInfoTask).done(function (hdType, hardwareInfo) {
            _loginAssistor.callGetUserLicense(ebookContext.getUser(), hardwareInfo, hdType)
                .done(function (dataReceived) {
                    hideLoading();
                    var retObj = _loginAssistor.userLicDataConverter(dataReceived);
                    if (retObj.statusCode == 0 && retObj.data) {
                        shellcmd.saveFile(retObj.data, path.trimPosix(ebookContext.getUser().getUserLicenseFullPath()))
                    }
                });
        });
    }

    /**
     *
     * @param RootKey 注册表根键值
     * @param AppKey  应用注册键值
     * @param AppName 应用名称
     * @param extName 应用后缀名
     * @param IconPath 关联图标路径
     * @param Describe 应用描述
     */
    function mtbkIconRegist(RootKey, AppKey, AppName, extName, IconPath, Describe) {
        // var regCmd = "reg add HKEY_CLASSES_ROOT\\.mtbk \/t reg_sz \/d \"" + 'mtbkfile' + '" \/f';
        RootKey = RootKey + '\\';
        var regPath = RootKey + extName;
        var regName = '';
        var regType = 'reg_sz';
        var regData = AppKey;
        shellcmd.writeRegedit(regPath, regName, regType, regData);

        regPath = RootKey + AppKey;
        regData = Describe;
        shellcmd.writeRegedit(regPath, regName, regType, regData);

        regPath = RootKey + AppKey + '\\DefaultIcon';
        regData = Config.binPathNoFile + IconPath;
        shellcmd.writeRegedit(regPath, regName, regType, regData);

        regPath = RootKey + AppKey + '\\Shell';
        regData = 'Open';
        shellcmd.writeRegedit(regPath, regName, regType, regData);

        regPath = RootKey + AppKey + '\\Shell\\Open\\Command';
        regData = AppName;
        shellcmd.writeRegedit(regPath, regName, regType, regData);

    }

    /**
     * 检测用户数据库
     */
    function checkDBOK(dbpath, tempdbpath) {
        var def = $.Deferred();
        dbpath = path.trimPosix(dbpath);
        console.log(dbpath);

        // 因为存在偶发创建用户目录的时候userdb.db文件copy不成功
        // 表现是userdb.db文件已经创建，但大小是0kb（正常是7kb，准确点7100+）
        // 故在此做文件大小检测，以做容错处理。
        shellcmd.getFileSize(dbpath).done(function (ret) {
            console.log("---dbsize : " + ret + "---");
            if (ret < 7000) {
                tempdbpath = path.trimPosix(tempdbpath);
                shellcmd.deleteFile(dbpath).done(function () {
                    shellcmd.copyFile(tempdbpath, dbpath).done(function () {
                        def.resolve("");
                    });
                });
            } else {
                def.resolve("");
            }
        });
        return def.promise();
    }

    /**
     * 写日志文件
     */
    function logged() {
        userLog.init();
        userLog.insertNewLog();
    }

    /**
     * 通用事件DOM
     */
    function EventLogicDom() {
        var buttons = {
            btnEditCancel: $("#editCancel"),
            btnAllBooks: $("#allBooks"),
            btnSelectedBooks: $("#selectedBooks")
        };
        var controls = {
            ctrFlipLeftImg: $("#ringLeft"),
            ctrFlipRightImg: $("#ringRight"),
            leftRing: $("#leftRing"),
            rightRing: $("#rightRing"),
            leftArrow: $("#leftArrow"),
            rightArrow: $("#rightArrow"),
            ctrFlipPanelDiv: $("#panel"),
            ctrClassBookCaseDiv: $(".bookoutside"),
            ctrRingLeftImg: $(".ring_left"),
            ctrRingRightImg: $(".ring_right"),
            ctrBookCaseTopShadowImg: $(".bookcase_shadow"),
            ctrBookShowListDiv: $("#bookShowList"),
            ctrSectionPanelDiv: $("#panelsection"),
            ctrGradePanelDiv: $("#panelgrade"),
            ctrBookInfoContentDiv: $("#bookInfoContent"),
            ctrBooksListDiv: $("#bookslist")
        }

        return {
            buttons: buttons,
            controls: controls
        }
    }

    /**
     * 工具栏DOM
     */
    function ToolBarDom() {
        var buttons = {
            btnBooksNeedUpdate: $("#booksNeedUpdate"),
            btnEditBooks: $("#editBooks"),
            btnEditCancel: $("#editCancel"),
            btnAllBooks: $("#allBooks"),
            btnSelectedBooks: $("#selectedBooks"),
            btnRecentBooks: $("#recentBooks"),
            btnNewBooks: $("#newBooks"),
            btnCancelBooks: $("#cancelBooks"),
            btnNameModelDisplay: $("#nameModelDisplay"),
            btnIconModelDisplay: $("#iconModelDisplay"),
            btnEditAllSelect: $("#editAllSelect"),
            btnEditNoSelect: $("#editNoSelect"),
            btnEditDelete: $("#editDelete"),
            btnExBook: $("#exportBook"),
            btnInBook: $("#inportU"),
            btnInPDF: $("#inportPDF"),
            btnBookLib: $("#btnBookStack"),
            btnYJBookStack: $("#btnYJBookStack")
        };
        var controls = {
            ctrRingLeftImg: $(".ring_left"),
            ctrRingRightImg: $(".ring_right"),
            ctrBookCaseTopShadowImg: $(".bookcase_shadow"),
            ctrFlipPanelDiv: $("#panel"),
            ctrGradePanelDiv: $("#panelgrade"),
            ctrSectionPanelDiv: $("#panelsection"),
            ctrClassBookCaseDiv: $(".bookcase"),
            ctrBooksListDiv: $("#bookslist"),
            ctrBookShowListDiv: $("#bookShowList"),
            ctrBookOutSideDiv: $("#bookoutside"),
            ctrBookInfoContentDiv: $("#bookInfoContent")
        }

        return {
            buttons: buttons,
            controls: controls
        }
    }

    /**
     * 加载书DOM
     */
    function BookLoaderDom() {
        var buttons = {
            btnBooksNeedUpdate: $("#booksNeedUpdate"),
            btnAllBooks: $("#allBooks"),
            btnNewBooks: $("#newBooks"),
            btnEditAllSelect: $("#editAllSelect"),
            btnEditNoSelect: $("#editNoSelect"),
            btnExBook: $("#exportBook")
        };
        var controls = {
            ctrBookCaseDiv: $(".bookoutside"),
            ctrFlipPanelImg: $(".flip"),
            ctrRingLeftImg: $(".ring_left"),
            ctrRingRightImg: $(".ring_right"),
            ctrBookCaseTopShadowImg: $(".bookcase_shadow"),
            ctrBookShowListDiv: $("#bookShowList"),
            ctrBookListAndListTopDiv: $("#bookListAndListTop"),
            ctrBookListOutSide: $("#listOutSide"),
            ctrBooksListDiv: $("#bookslist"),
            ctrFlipPanelDiv: $("#panel"),
            ctrBookInfoContentDiv: $("#bookInfoContent")
        };
        return {
            buttons: buttons,
            controls: controls
        }
    }

    /**
     * 书库DOM
     */
    function BookLibDom() {
        var buttons = {
            EditCancelTrigger: $("#editCancel"),
            AllBookTrigger: $("#allBooks"),
            RecentBookTrigger: $("#recentBooks"),
            btnCloseBookLib: $("#btnCloseBookLib"),
            downLoadRenJiaoBook: $("#downLoadRenJiaoBook")

        };
        var controls = {
            bookLibIfrm: $("#bookLibIfrm"),
            bookLibPanel: $("#bookLibPanel")
        };
        return {
            buttons: buttons,
            controls: controls
        }
    }

    /**
     * 书本更新DOM
     */
    function UpdateDom(resUpdatePanel) {
        var buttons = {
            booksNeedUpdate: $("#booksNeedUpdate"),
            closePanel: resUpdatePanel.find("#closeBooksUpdatePanel"),
            lastPage: resUpdatePanel.find("#btnLastPage"),
            nextPage: resUpdatePanel.find("#btnNextPage"),
            selectPage: resUpdatePanel.find("#btnSelectPage"),
            selectPageArrow: resUpdatePanel.find("#btnSelectPageArrow")
        };
        var controls = {
            shelfPanel: $("body"),
            resUpdatePanel: resUpdatePanel,
            resUpdateList: resUpdatePanel.find("#resUpdateList"),
            pageTip: resUpdatePanel.find("#pageTip"),
            updateTab: resUpdatePanel.find("#updateTab"),
            personalInfoPanel: $("#personalInfoPanel"),
            purchasedBooksPanel: $("#purchasedBooksPanel")
        };
        return {
            buttons: buttons,
            controls: controls
        }
    }

    /**
     * 个人中心DOM
     */
    function PersonalInfoDom(resUpdatePanel) {
        var buttons = {
            btnOpenPersonalInfo: $("#btnOpenPersonalInfo"),
            btnClosePersonalInfoPanel: $("#btnClosePersonalInfoPanel"),
            btnClosePurchasedBooksPanel: $("#btnClosePurchasedBooksPanel"),
            btnPurchasedBooks: $("#btnPurchasedBooks"),
            // 王哒哒修改
            btnCloseApp: $("#btnCloseApp")
        };
        var controls = {
            personalInfoIfrm: $("#personalInfoIfrm"),
            personalInfoPanel: $("#personalInfoPanel"),
            purchasedBooksPanel: $("#purchasedBooksPanel"),
            purchasedBooksIfrm: $("#purchasedBooksIfrm"),
            purchasedBooksPanelMask: $("#purchasedBooksPanelMask"),
            bookpop_tab: $("#bookpop_tab"),
            booklist_tab: $("#booklist_tab"),
            personalInfoPanelMask: $("#personalInfoPanelMask"),
            ctrHeadPortrait: $("#ctrHeadPortrait"),
            resUpdatePanel: resUpdatePanel
        };
        return {
            buttons: buttons,
            controls: controls
        }
    }

    /**
     * 这个函数改动的可能性很小很小了
     * 主要是一些不变的固定事件
     */
    function someOKThing() {

        /* the methods of $(window).height() and $(window).width() have inner bug in the browser,
         when the screen image resolution changed and the browser is not active or be minimization.
         The above two methods will not update their data immediately. But when we get the data from
         Config file also have problems, it will not adapted when the windows TaskBar changed.------JJ*/

        var _windowHeight = Config.Height;
        var _windowWidth = Config.Width;
        var _h = $("#first").height();
        var _showBookDivHeight = _windowHeight - _h;

        $(".book").css("min-height", _showBookDivHeight);
        $("#bookShowList").css("min-height", _showBookDivHeight);
        $("#bookLibPanel").css("height", _windowHeight).hide();
        $("#bookLibIfrm").css("height", _windowHeight);
        $(".bookoutside").css("height", _showBookDivHeight);
        $("#listOutSide").css("height", _showBookDivHeight - 39);

        //分辨率为800*600时，列表模式标题宽度改变
        if (_windowWidth < 1000) {
            $(".w180").css("width", "120px");
            $(".shelf_list .xk").css("width", "100px");
            $("#editBooks").css("margin-left", "-10px");
            $(".book_head").css("margin-left", "-30px").css("-webkit-transform", "matrix(0.8,0,0,1,0,0)");
            $(".open_board").css("margin-left", "-35px").css("-webkit-transform", "matrix(0.7,0,0,1,0,0)");
        }

        //        //兼容特殊分辨率下书架上用户反馈按钮有偏移
        //        if(_windowHeight <= 800){
        //            $("#feedbackBtn").css("padding-left","13px").css("padding-right","13px");
        //        }



        $("#personalInfoPanel").hide();

        $("#btnMinApp").click(function () {
            shellcmd.ebookMin();
        });

        $("#btnExitApp").click(function () {
            // confirmExit.ExitAlert(null, null);
            // 王哒哒修改
            WIN.restore();
            console.log(1234324)
            confirmExit.ExitAlert_new(null, null);
        });

        WIN.on('close', function () {
            WIN.restore();
            // 王哒哒修改
            // confirmExit.ExitAlert(null, null);
            confirmExit.ExitAlert_new(null, null);
        });

        $(window).on('realexit', function () {
            confirmExit.ForceExit();
        })

        //从minimize还原，该事件触发
        WIN.on('restore', function () {
            socket.send({
                "type": "logic",
                "action": "floattoolbar_ib_max",
                "from": "ib",
                "to": "floatToolBar",
                "data": ""
            })
        });

        WIN.on('minimize', function () {
            socket.send({
                "type": "logic",
                "action": "floattoolbar_ib_min",
                "from": "ib",
                "to": "floatToolBar",
                "data": ""
            })
        })


        $("#btnGloQQService").click(function () {
            var QQService = require('./common/QQService').QQService;
            QQService(ebookContext.getUser().getUid());
            //            shellcmd.openPageOutside('http://wpa.b.qq.com/cgi/wpa.php?ln=1&key=XzkzODAwMDQ4NF8zMDI3MzRfNDAwODg3ODU1N18yXw');
        });

        $("#btnLogout").click(function () {
            confirmExit.GoToLoginAlert();
        });

        $("#goToWhiteBoard").click(function () {

            //监管
            var action = LogManager.action.trigger;
            var params = {};
            params.module = '1130615';
            var user_id = ebookContext.getUser().getUid();
            if (user_id != '0' && user_id) {
                params.user_id = user_id;
            }
            LogManager.statistics(action, params);
            _pageNavigatorHelper.goToWhiteBoard(ebookContext.getUser());

            //启用iflyslide黑板
            /* var json={
                 type : "logic",
                     action : "goto_board",
                 from : "iflybook",
                 to : "all",
                 data : {
                 state: 0 // 0 表示未上课，1表示上课状态
                 }
             };
             socket.send(json);*/
        });

        $("#feedbackBtn").click(function () {
            var feedback = require("./app/bookshelf/feedback/feedback.js").Instance;
            feedback.show();
        });

        $("#addPoints").click(function () {
            var recharge = require("./app/bookshelf/recharge/recharge").Instance;
            recharge.show();
        });

        $("#userlogout").click(function () {
            confirmExit.GoToLoginAlert();
        })

        $("#goToPay").click(function () {
            shellcmd.openPageOutside(AppRemoteSvcCfg.BuyPointUrl + (ebookContext.getUser().getSSOTicket() || ""));
        });


        $("#helpLinkUrl").click(function () {
            shellcmd.openPageOutside(AppRemoteSvcCfg.UserHelpDocUrl + (ebookContext.getUser().getSSOTicket() || ""));
        });


        $("#shareHelperId").bind('click', function () {
            $("#shareHelpPntId").toggle();
            $("#shareHelpCntId").toggle();
        });

        $("#userschools").change(function () {
            var classId = $(this).children('option:selected').attr('classid');
            ebookContext.setUserClassId(classId);
            var uid = ebookContext.getUser().getUid();
            //更新本地存储
            var ret = localStorage.getItem(uid + 'schoolList');
            var newRet = [];
            if (ret instanceof Array && ret.length > 0) {
                $.each(ret, function (index) {
                    //                    console.log(ret[index])
                    if (ret[index].classId == classId) {
                        newRet.push(ret[index]);
                    }
                });
                $.each(ret, function (index) {
                    if (ret[index].classId != classId) {
                        newRet.push(ret[index]);
                    }
                })
                localStorage.setItem(uid + 'schoolList', JSON.stringify(newRet));
            }

        })
    }

    function changeLoginStyle(curUser, isOnline, isActive, userLoginName, userName, role) {
        $("#loginafter").show();
        $("#loginbefore").hide();
        var roleName = '';
        if (role == 'student') {
            roleName = '学生';
        } else {
            roleName = '教师';
        }
        //书架用户标识显示，老版本策略
        // var display = roleName+'：'+(userLoginName || ( /^User/.test(curUser) ?  userName : curUser));
        //书架用户标识显示，新版本策略        
        var display = roleName + '：' + (userLoginName || (userName) ? userName : curUser);
        //第三方账户显示第三方账户名，反之显示账户名，自动生成的账户名显示用户名
        $("#curUser").html(display);
        var $inAccount = $("#inAccount"),
            $okAccount = $("#okAccount");
        //解决手机号绑定但未激活，激活时报错：已绑定，将充值码入口放出来   导致所有未激活的用户都可以看到充值码入口    --by shengyang2
        //isActive ? ($okAccount.show(),$inAccount.hide()) : ($inAccount.show(),$okAccount.hide());
        $okAccount.show();
        $inAccount.hide();

        //    $("#userActive").css("display",isActive ? "none" : "inline");

    }

    //T型平台需求
    function prepareSchoolInfo(uid, role, classId) {

        var def = $.Deferred();
        var schoolsUrl = AppCenterSvcHelper.CYSVC + "&method=jx.class.list&userId=" + uid + '&roleName=' + role;
        $("#userschools").empty();
        var tpl = '<option classId ="{classid}">{className}</option>';
        //classId不为空，并非重新登陆
        if (classId && classId != 'null') {
            //从电子书或黑板页面跳转过来,从本地存储取
            ebookContext.setUserClassId(classId);
            var ret = JSON.parse(localStorage.getItem(uid + 'schoolList'));
            if (ret instanceof Array && ret.length > 0) {
                //TODO:重新组装ret顺序
                var newRet = [];
                $.each(ret, function (index) {
                    //                    console.log(ret[index])
                    if (ret[index].classId == classId) {
                        newRet.push(ret[index]);
                    }
                });
                $.each(ret, function (index) {
                    if (ret[index].classId != classId) {
                        newRet.push(ret[index]);
                    }
                })
                var i = 0;
                for (; i < newRet.length; i++) {
                    var temp = tpl.replace("{classid}", newRet[i].classId).replace("{className}", newRet[i].className);
                    $("#userschools").append(temp);
                }

                localStorage.setItem(uid + 'schoolList', JSON.stringify(newRet));
                def.resolve(classId);
            } else {
                $("#userschools").append('<option classId ="">无班级</option>');
                def.resolve('');
            }


        } else {
            //从登陆页跳转过来，先从本地存储取，但是要保证本地存储与服务端数据一致
            var flag = true;
            var ret2 = JSON.parse(localStorage.getItem(uid + 'schoolList'));
            var originRet2 = [];

            if (ret2 instanceof Array && ret2.length > 0) {
                $.each(ret2, function (index) {
                    originRet2.push(ret2[index]);
                })
                //要判断是否与服务端一致
                ebookContext.getUser().getDataByUserToken(schoolsUrl).done(function (ret3) {
                    if (ret3 instanceof Array && ret3.length > 0) {
                        if (ret2.length != ret3.length) {
                            flag = false;
                        } else {
                            ret2.sort(_sortByAttr('classId'));
                            ret3.sort(_sortByAttr('classId'));
                            for (var j = 0; j < ret2.length; j++) {
                                if (ret2[j].classId != ret3[j].classId) {
                                    flag = false;
                                    break;
                                }
                            }
                        }
                        if (!flag) {
                            //与服务端不一致，用服务端
                            localStorage.setItem(uid + 'schoolList', JSON.stringify(ret3));
                            ebookContext.setUserClassId(ret3[0].classId);
                            var i = 0;
                            for (; i < ret3.length; i++) {
                                var temp = tpl.replace("{classid}", ret3[i].classId).replace("{className}", ret3[i].className);
                                $("#userschools").append(temp);
                            }
                            def.resolve(ret3[0].classId);

                        } else {
                            //与服务端一致，用上次结果
                            //                            localStorage.setItem(uid+'schoolList',JSON.stringify(originRet2));
                            ebookContext.setUserClassId(originRet2[0].classId);
                            var i = 0;
                            for (; i < originRet2.length; i++) {
                                var temp = tpl.replace("{classid}", originRet2[i].classId).replace("{className}", originRet2[i].className);
                                $("#userschools").append(temp);
                            }
                            def.resolve(originRet2[0].classId);
                        }
                    }


                })
            } else {
                //TODO:本地存储不正常，从网络取
                ebookContext.getUser().getDataByUserToken(schoolsUrl).done(function (ret) {
                    console.log(ret);
                    //            var ret = [{"classId":"2300000017000002094","schoolId":"2244000014000000012","className":"七年级(1)班 ","classCode":null,"year":2014,"phase":"04","studentCount":2,"subject":"null"},
                    //                {"classId":"2300000017000002095","schoolId":"2244000014000000012","className":"七年级(2)班 ","classCode":null,"year":2014,"phase":"04","studentCount":2,"subject":"null"}];

                    if (ret instanceof Array && ret.length > 0) {
                        localStorage.setItem(uid + 'schoolList', JSON.stringify(ret));
                        ebookContext.setUserClassId(ret[0].classId);
                        var i = 0;
                        for (; i < ret.length; i++) {
                            var temp = tpl.replace("{classid}", ret[i].classId).replace("{className}", ret[i].className);
                            $("#userschools").append(temp);
                        }
                        def.resolve(ret[0].classId);
                    } else {
                        $("#userschools").append('<option classId ="">无班级</option>');
                        def.resolve('');
                    }


                })
            }


        }

        return def.promise();

    }

    //根据属性值进行排序
    function _sortByAttr(name) {
        return function (o, p) {
            var a, b;
            if (typeof o === "object" && typeof p === "object" && o && p) {
                a = o[name];
                b = p[name];
                if (a === b) {
                    return 0;
                }
                if (typeof a === typeof b) {
                    return a < b ? -1 : 1;
                }
                return typeof a < typeof b ? -1 : 1;
            } else {
                throw ("error");
            }
        }
    }

    function StartMonitor() {
        // var configPath = path.trimPosix(Config.binPath + 'LogCenterExtract.cfg');
        var configPath = path.trimPosix(Config.nwexePath + 'node_modules/Iflybook_modules/LogCenterExtract.cfg');

        configPath = path.trimPosix(configPath);
        configPath = path.toWindows(configPath);
        shellcmd.MonitorStart(configPath);
    }

    function StartFloatToolBar() {
        //For:屏蔽iflybook入口，避免重复打开导致截图路径错误
        // var FloatToolBarExe = Config.binPath + 'tools/iFLY_FloatToolBar.exe';
        // shellcmd.shellexecutewithargs(FloatToolBarExe, 'ws://127.0.0.1:9980 ib');
    }

    function afterReder() {
        $("#usrInfo").show();
        $("#btnbarleft").show();
        $("#btnBookStack").show();
        $("#cylogo").show();

        setTimeout(function () {
            //隐藏欢迎页
            shellcmd.AfterRender();
        }, 1000);
    }

    function noticeStart() {
        var spawn = nodereq('child_process').spawn;
        var nw_path = path.trimPosix(Config.nwexePath);
        var nw_exe = nw_path + 'nw.exe';
        var nw_param = nw_path + 'notice';
        if (!confirmExit.noticeProcess) {
            confirmExit.noticeProcess = spawn(nw_exe, [nw_param]).on('error', function (err) {
                //                shellcmd.log('公告栏::启动失败' + JSON.stringify(err));
                confirmExit.noticeProcess.kill();
                confirmExit.noticeProcess = null;
            }).on('exit', function () {
                confirmExit.noticeProcess = null;
            });
        }
    }

    function sendLoginInfo(user) {
        var userid = '';
        if (user) {
            userid = ebookContext.getUser().getUid();
        }
        socket.send({
            type: 'logic',
            action: 'login',
            data: {
                url: AppRemoteSvcCfg.MessageStatic + userid
            }
        });

    }

    function changeFloatBarBtnCfg() {
        var defaultjson = {
            "button_height": 44,
            "button_list": [{
                    "type": "cancel",
                    "name": "cancel",
                    "width": 81,
                    "normal_image": "ToolRes\\screenshot_cancel_1.png",
                    "pushed_image": "ToolRes\\screenshot_cancel_2.png"
                },
                {
                    "type": "save",
                    "name": "save",
                    "width": 72,
                    "normal_image": "ToolRes\\screenshot_save_1.png",
                    "pushed_image": "ToolRes\\screenshot_save_2.png",
                    "auto_upload": true,
                    "ws_action": ""
                }
            ]
        }
        var ifbjson = {
            "button_height": 44,
            "button_list": [{
                    "type": "cancel",
                    "name": "cancel",
                    "width": 81,
                    "normal_image": "ToolRes\\screenshot_cancel_1.png",
                    "pushed_image": "ToolRes\\screenshot_cancel_2.png"
                },
                {
                    "type": "save",
                    "name": "save",
                    "width": 72,
                    "normal_image": "ToolRes\\screenshot_save_1.png",
                    "pushed_image": "ToolRes\\screenshot_save_2.png",
                    "auto_upload": true,
                    "ws_action": ""
                },
                // {
                //     "type": "save",
                //     "name": "share",
                //     "width": 111,
                //     "normal_image": "ToolRes\\screenshot_share_1.png",
                //     "pushed_image": "ToolRes\\screenshot_share_2.png",
                //     "auto_upload": false,
                //     "ws_action": "T_share"
                // }
            ]
        }

        var jsonfile = Config.binPathNoFile + "tools/Skin/ScreenShot.json";
        shellcmd.saveFilAsync(JSON.stringify(ifbjson), jsonfile);
    }

    exports.changeFloatBarBtnCfg = changeFloatBarBtnCfg;
    exports.disableKey = disableKey;
    exports.Request = QueryString;
    exports.createShortCut = createShortCut;
    exports.StartUpload = StartUpload;
    exports.writeUserLic = writeUserLic;
    exports.checkDBOK = checkDBOK;
    exports.logged = logged;
    exports.EventLogicDom = EventLogicDom;
    exports.ToolBarDom = ToolBarDom;
    exports.BookLoaderDom = BookLoaderDom;
    exports.BookLibDom = BookLibDom;
    exports.UpdateDom = UpdateDom;
    exports.PersonalInfoDom = PersonalInfoDom;
    exports.someOKThing = someOKThing;
    exports.changeLoginStyle = changeLoginStyle;
    exports.prepareSchoolInfo = prepareSchoolInfo;
    exports.StartMonitor = StartMonitor;
    exports.afterReder = afterReder;
    exports.StartFloatToolBar = StartFloatToolBar;
    exports.noticeStart = noticeStart;
    exports.sendLoginInfo = sendLoginInfo;
    exports.createShortCutDelay = createShortCutDelay;
    exports.mtbkIconRegist = mtbkIconRegist;
});