/**
 * Created with JetBrains WebStorm.
 * User: jhwang
 * Date: 13-8-2
 * Time: 上午9:01
 * To change this template use File | Settings | File Templates.
 */

/**
 * 用户对象
 * 基本上在使用的时候是使用ebookContext里面保存的唯一实例对象
 * 对象无法跨页面保存，
 * 所以每次都在代码中保存关键字段并在新页面中重新创建对象
 *
 * （其实我一直很怀疑这里可以用sessionStorage实现，
 * 想法是让user对象的基本属性字段消失不保存，
 * 在sessionStorage里面存储相应的字符串，
 * 如果你有足够的时间，可以考虑重写）
 *
 *        -----------   by  yczhu
 */
define(function (require, exports) {

    function User() {
        var path = require('../common/path');
        var _shellcmd = require('../common/shellcmd');
        var _userAccess = require('./login/userinfoAccessor');

        var _self = this;
        _self._name = "";      //账户名
        _self._userName = "";   //用户姓名
        _self._password = ""; //用户密码
        _self._isOnline = false;//是否是联网登陆
        _self._ticket = "";    //用户Token，登陆功能时返回的
        _self._photo = ""; //用户头像
        _self._basePath = "";    // application bin path
        _self._selfBasePath = ""; //current user res base path
        _self._userToken = null;
        _self._isActive = false;
        _self._uid = 0;
        _self._email = "";
        _self._phoneNum = "";
        _self._points = 0;   //剩余点数
        _self._books = 0 ;   //剩余本数
        _self._p = "";
        _self._userLoginName = "";  //第三方账户专用字段
        _self._province = "" ; //用户所在省市
        _self._dynamicToken = "";//get dynamic token from cloud, the token will be changed in specific time;
        _self._LoginFrom = "";  // present the entry name , for instance 东阳 ，甘肃 ...

        //HERE CAN BE DELETE
        _self._ClientToken = "";
        _self.SSOTicket = "";

        //T型方案需求
        _self._classId = '';

        _self._role = '';

        //用户的appName
        _self._userAppName = '';

        //硬件号
        var _hardwareInfo;

        _self.getSSOTicket = function(){
            return _self.SSOTicket;
        }

        _self.setSSOTicket = function(SSOInfo){
            _self.SSOTicket = SSOInfo;
        }

        _self.setProvince = function(province){
            _self._province = (province == "undefined" ? "" : province);
        }

        _self.getProvince = function(province){
            return _self._province || "";
        }

        _self.getDynamicToken = function(){
            return _self._dynamicToken;
        }

        _self.setDynamicToken = function(){
            //ajax异步从云端获取动态token
            var defer = $.Deferred();
            _self.getPassword().done(function(ret){
                var httpurl =AppRemoteSvcCfg.TokenRemote + _self._name+'&password=' + ret ;
//                var httpurl = AppRemoteSvcCfg.ClientToken;
                console.log(httpurl);
                _shellcmd.getHttpRequestJSON(httpurl).done(function (ret1) {
                    _self._dynamicToken = ret1.access_token;
                    defer.resolve(ret1.access_token);
                });
            });
            return defer.promise();
        }

        _self.setUserLoginName = function (userLoginName) {
            _self._userLoginName = userLoginName;
        };

        _self.getUserLoginName = function () {
            return _self._userLoginName;
        };

        _self.setUserName = function (userName) {
            _self._userName = userName;
        };

        _self.setUserRole = function(role){
            _self._role = role;
        }

        _self.getUserRole = function(role){
            return _self._role;
        }

        _self.setUserAppName = function(appName){
            _self._userAppName = appName;
        }

        _self.getUserAppName = function(){
            return _self._userAppName;
        }

        _self.getUserName = function () {
            return _self._userName;
        };

        _self.setPoints = function (num) {
            _self._points = num;
        };

        _self.getPoints = function (dir) {
           return _self._points;
        };

        _self.setBooks = function (num) {
            _self._books = num;
        };

        _self.getBooks = function () {
            return _self._books;
        };

        _self.setBasePath = function (dir) {
            _self._basePath = dir;
        };

        _self.setEmail = function (email) {
            _self._email = email;
        };

        _self.getEmail = function () {
            return _self._email;
        };

        _self.setPhoneNum = function (phoneNum) {
            _self._phoneNum = phoneNum;
        };

        _self.getPhoneNum = function () {
            return _self._phoneNum;
        };

        _self.setUid = function (uid) {
            _self._uid = uid;
        };

        _self.getUid = function () {
            return _self._uid;
        };

        _self.setName = function (name) {
            _self._name = name;
        };

        _self.getName = function () {
            return _self._name;
        };

        _self.setPassword = function (password) {
            _self._password = password;
        };

        _self.getPassword = function () {
            var defer = $.Deferred();
            if(_self._name == AppCfg.defaultuser){
                defer.resolve("");
            }
            else{
                if(!_self._password || _self._password == "null"){
                    _userAccess.getPass(_self._name).done(function(ret){
                        _self._password = ret;
                        defer.resolve(ret);
                    });
                }
                else{
                    defer.resolve(_self._password);
                }
            }
            return defer.promise();
        };

        //此函数只在导出时调用
        _self.getP = function(){
            var defer = $.Deferred();
            if(_self._name == AppCfg.defaultuser){
                defer.resolve("");
            }
            else{
                if(!_self._p || _self._p == "null"){
                    _userAccess.getP(_self._name).done(function(ret){
                        _self._p = ret;
                        defer.resolve(ret);
                    });
                }
                else{
                    defer.resolve(_self._p);
                }
            }
            return defer.promise();
        }

        _self.setTicket = function (ticket) {
            _self._ticket = ticket;
        };

        _self.getTicket = function () {
            return _self._ticket;
        };

        _self.setPhoto = function (photo) {
            _self._photo = photo;
        };

        _self.getPhoto = function () {
            return _self._photo;
        };

        _self.setIsOnline = function (isOnline) {
            _self._isOnline = isOnline;
        }

        _self.getIsOnline = function () {
            return _self._isOnline;
        }
        _self.setIsActive = function (isActive) {
            _self._isActive = isActive;
        }

        _self.getIsActive = function () {
            return _self._isActive;
        }

        //T型方案家校互联需求,设置用户学校对象
        _self.setUserClassId = function(id){
            _self._classId = id;
        }
        _self.getUserClassId = function(){
            return _self._classId;
        }

        //用户电子书根目录绝对地址
        _self.getStdBookBasePath = function () {
            return path.join(_self._basePath, 'users/' + _self._name + '/ebook');
        };

        //用户电子书试用地址
        _self.getStdTestBookBasePath = function () {
            return path.join(_self._basePath, 'users/'+ AppCfg.testBook);
        };

        //用户电子书2试用地址
        _self.getStdTestBook2BasePath = function () {
            return path.join(_self._basePath, 'users/'+ AppCfg.testBook2);
        };

        //用户电子书根目录相对地址
        _self.getStdBookRelativeBasePath = function () {
            return 'users/' + _self._name + '/ebook';
        }

        //用户电子书资源根目录绝对地址
        _self.getUserBookBasePath = function () {
            return path.join(_self._basePath, 'users/' + _self._name + '/userbook');
        };

        //用户电子书资源根目录相对地址
        _self.getUserBookRelativeBasePath = function () {
            return 'users/' + _self._name + '/userbook';
        };

        //用户快照资源根目录绝对地址
        _self.getUserSnapShotBasePath = function () {
            return path.join(_self._basePath, 'users/' + _self._name + '/snapshot');
        }

        //用户快照资源根目录相对地址
        _self.getUserSnapShotRelativePath = function () {
            return 'users/' + _self._name + '/snapshot';
        }

        //用户本地资源保存地址（绝对地址）
        _self.getUserResourceBasePath = function () {
            return path.join(_self._basePath, 'users/' + _self._name + '/localresource');
        }

        //用户本地资源保存地址（相对地址）
        _self.getUserResourceRelativeBasePath = function () {
            return   'users/' + _self._name + '/localresource';
        }

        /**
         * 获取用户目录相对路径
         */
        _self.getUserBaseRelativePath = function () {
            return  'users/' + _self._name;
        }

        /**
         * 获取用户目录绝对路径
         */
        _self.getUserBasePath = function () {
            return path.join(_self._basePath, 'users/' + _self._name);
        }

        /**
         * 获取用户数据库路径
         */
        _self.getUserDbFullPath = function () {
            return path.join(path.trimPosix(_self._basePath), 'users/' + _self._name + '/userdb.db');
        }

        /**
         * 获取用户授权文件绝对路径
         */
        _self.getUserLicenseFullPath = function () {
            return   path.join(_self._basePath, 'users/' + _self._name + '/license.dat');
        }

        /**
         * 获取用户plugin排序文件路径
         */
        _self.getUserSortFileFullPath = function () {
            return path.join(path.trimPosix(_self._basePath), 'users/' + _self._name + '/sort.json');
        }

        /**
         * 获取书本授权文件绝对路径
         * @param bookCode
         */
        _self.getBookLicenseFullPath = function (bookCode) {
            return   path.join(_self._basePath, 'users/' + _self._name + '/ebook/' + bookCode + '/' + bookCode + '.lic');
        }

        /**
         * 获取书本关联的到位资源绝对路径
         * @param bookCode
         */
        _self.getBookResourceFullPath = function (bookCode) {
            return   path.join(_self._basePath, 'users/' + _self._name + '/userbook/' + bookCode + '.zip');
        }
        /**
         * 获取用户头像相对路径,相对于bookshelf.html
         * @returns {*}
         */
        _self.getUserAvatarRelativePath = function () {
            return  '../users/' + _self._name;
        }

        /**
         * 获取用户Token
         * @returns {string}
         */
        _self.getUserToken = function () {
            var def = $.Deferred();
            if (!_self._userToken) {
                _shellcmd.getHardwareInfo(_self.getName()).done(function (ret) {
                    var token = _self.getName() + ret;
                    _self._userToken = token;
                    def.resolve(token);
                });
            } else {
                def.resolve(_self._userToken);
            }
            return def.promise();
        }

        //获取用户模板数据库
        _self.getTempUserDb = function () {
            return path.join(_self._basePath, 'users/template.db');
        }

        _self.getUserWBPath = function () {
            return path.join(_self._basePath, 'users/' + _self._name + '/wboard');
        }

        /**
         * 获取用户备课本路径
         */
        _self.getUserPpticwsBasePath = function () {
            var ppticws_path = 'file:///'+ Config.nwexePath + '/ppticws';
            if(_self._uid == "") {
                _self._uid = "0";
            }
            return path.join(path.trimPosix(ppticws_path), _self._uid);
        }

        /**
         * 获取备课本路径
         */
        _self.getPpticwsBasePath = function () {
            var ppticws_path = 'file:///'+ Config.nwexePath + '/';
            return path.join(path.trimPosix(ppticws_path), "ppticws");
        }

        /**
         * 获取用户课本的资源目录(使用 TA/user/User~/books/Book~/resource.db 数据库)
         * @param bookCode
         */
        _self.getUserBookResourceBasePath = function (bookCode) {
            return path.join(path.trimPosix(Config.nwexePath), 'user/' + _self.getName() + '/books/' + bookCode + '/');
        }

        //判断用户是否在另一台机器登陆了
        _self.checkSingleLogin = function (_pageNavigatorHelper) {
            if (AppCfg.checkSingleLoginInterval <= 0 || _self._name === AppCfg.defaultuser) return;
            var timeId;
            var lastTime = sessionStorage["lastCheckSingleLogin"];
            var leftTime;
            leftTime = (lastTime && lastTime != 'undefined') ? (new Date().getTime() - lastTime) : AppCfg.checkSingleLoginInterval;

            var fun = function () {

                var msg = {
                    url: AppRemoteSvcCfg.CheckSingleLogin,
                    userAccount: _self.getName(),
                    mcCode: _hardwareInfo,
                    ticket: _self.getTicket()
                };

                var task1 = _shellcmd.postHttpRequest(msg);
                var task2 = _shellcmd.checkOnline();

                $.when(task1, task2).done(function (ret1, ret2) {
                    sessionStorage["lastCheckSingleLogin"] = ret2 ? new Date().getTime() : undefined;
                    console.log(ret1, sessionStorage["lastCheckSingleLogin"], JSON.stringify(msg));

                    //直接屏蔽离线图标  无论在线或者离线均不显示
                    //_self.showIsOnline(ret2);

                    if (ret1 === 'false' && ret2) {
                        clearTimeout(timeId);
                        _shellcmd.killProcess("getres.exe");
                        _shellcmd.killProcess("uploadres.exe");
                        $.Zebra_Dialog(AppTips.loginOnAnotherMachine, {
                            'type': 'information',
                            'title': AppTips.WarmTips,
                            'buttons': [AppTips.OkTips],
                            'forceClosePrev': true,
                            'zIndex': 10001,
                            'onClose': function () {
                                _shellcmd.beforeExitApp();
                                socket.send({"type":"logic","action":"logout","from":"ib","to":"all","data":""});
                                $(window).trigger('realexit');
                                // _pageNavigatorHelper.goToLogin();
                            }
                        });
                    }
                    else timeId = setTimeout(fun, AppCfg.checkSingleLoginInterval);
                });
            };
            if (!_hardwareInfo) {
                _shellcmd.getHardwareInfo(_self.getName()).done(function (hardwareInfo) {
                    _hardwareInfo = hardwareInfo;
                    setTimeout(fun, leftTime);
                });
            }
            else  setTimeout(fun, leftTime);
        }

        _self.showIsOnline = function(isOnline){
            var _notOnlineDom = $("#notOnline");
            _self._isOnline = isOnline;
            //直接屏蔽离线图标  无论在线或者离线均不显示
            //isOnline ?  _notOnlineDom.hide() : _notOnlineDom.show();
            _notOnlineDom.hide();
        }

        _self.getPointsThenSet = function(){
            var msgJson = {
                url: AppRemoteSvcCfg.getPoints ,
                account: _self.getName()
            };
            _shellcmd.postHttpRequest(msgJson).done(function (ret) {
                try{
                    var jsonObj = JSON.parse(ret);
                    console.log(jsonObj);
                    _self.setPoints(jsonObj.points);
                    _self.setBooks(jsonObj.bookAllNum);
                    $("#bookNum").text(jsonObj.bookAllNum);
                }
                catch(e){
                 //   $("#bookNum").text("--");
                    $("#lastBooks").hide();
                }
              //  $("#points").text(jsonObj.points);
            });
        }

        _self.getDataByUserToken = function(url){
            var def = $.Deferred();
            var httpurl = "";
            if(_self._name == AppCfg.defaultuser){

                //临时添加调试
                app_ClientToken = 'changyanyun';

                //没有client_token
                if(!app_ClientToken){
                    _shellcmd.getHttpRequestJSON(AppRemoteSvcCfg.ClientToken).done(function(ret1){
                        if(ret1){
                            app_ClientToken = ret1.access_token;

                            //add by chengyang token写死
//                            _self._dynamicToken = ret1.access_token;

                            httpurl = url + "&access_token=" + app_ClientToken;
                            _shellcmd.getHttpRequestJSON(httpurl).done(function (retData5) {
                                    def.resolve(retData5);
                            });
                        }
                        else{
                            def.resolve("");
                        }
                    });
                }
                else{
                    httpurl = url + "&access_token=" + app_ClientToken;
                    _shellcmd.getHttpRequestJSON(httpurl).done(function (retData6) {
                        if(retData6){
                            def.resolve(retData6);
                        }
                        else{
                            _shellcmd.getHttpRequestJSON(AppRemoteSvcCfg.ClientToken).done(function(ret7){
                                if(ret7){
                                    app_ClientToken = ret7.access_token;
                                    httpurl = url + "&access_token=" + app_ClientToken;
                                    _shellcmd.getHttpRequestJSON(httpurl).done(function (retData8) {
                                        def.resolve(retData8);
                                    });
                                }
                                else{
                                    def.resolve("");
                                }
                            });
                        }
                    });
                }
            }
            else{
                _self._dynamicToken = 'changyanyun';
                if(_self._dynamicToken){
                    //有token，直接用
                    httpurl = url + "&access_token=" + _self._dynamicToken;
                    _shellcmd.getHttpRequestJSON(httpurl).done(function (retData) {
                        if(retData){
                            def.resolve(retData);
                        }
                        else{
                            //认为token过期，重新获取。80%概率走不到这里
                            _self.setDynamicToken().done(function(){
                                console.log("---------token guo qi chu li -------------");
                                //重新拼接token地址
                                httpurl = url + "&access_token=" + _self._dynamicToken;
                                _shellcmd.getHttpRequestJSON(httpurl).done(function (retData2) {
                                    def.resolve(retData2);
                                });
                            });
                        }
                    });
                }
                else{
                    //没有token去获取,初步判断是99%概率走不到这里
                    _self.setDynamicToken().done(function(){
                        httpurl = url + "&access_token=" + _self._dynamicToken;
                        _shellcmd.getHttpRequestJSON(httpurl).done(function (retData3) {
                            def.resolve(retData3);
                        });
                    });
                }
            }
            return def.promise();
        }

        _self.getLoginForm = function(){
            return _self._LoginFrom ;
        }

        _self.setLoginFrom = function(loginFrom){
            _self._LoginFrom = decodeURI(loginFrom) ;
        }
    }

    exports.User = User;
});

