/**
 * Created with JetBrains WebStorm.
 * User: Administrator
 * Date: 15-5-12
 * Time: 下午8:17
 * To change this template use File | Settings | File Templates.
 */
;
define(function(require,exports){

    var shellcmd = require("../../../../common/shellcmd");
    var bbhelper = require("../../../blackboard/blackboardhelper").instance;
    var CardWrapper = require('../../../card/cardwrapper').Instance;
    var pyUtil = require('pyutil').Instance;
    var ibWSLogic = require("../../../../ibWSLogic");
    var ebkcontext = require('../../../ebookcontext').Instance;

    function PluginChineseTest(){

        var _resulttpl = '<li><span class="dist-pinyin">{1}</span><span class="dist-txt">{2}</span></li>';

        var _self = this;
        var _tplpath = Config.binPathNoFile + "webapp/assert/js/app/plugins/pluginitem/chinesetest/tpl.html" ;
        var _ready = false;
        var _Dom = null;
        var btns = {};
        var controls = {};
        var _toStrokeResultWordStr = "";
        var _toStrokeResultWords = [];
        var _strokeOrderResultWordArr = [];

        var _curIndex = 0;

        //识别板的宽和高
        var _canvasWidth = 674,_canvasHeight = 430;
        //默认画笔颜色
        var _color = "#000";
        //默认画笔粗细
        var _size = 4;
        //点迹数组
        var strokes = [];
        //合成拼音的发音人
        var speecher = "wangru";
        // TODO : 这里是个坑，调用的是别的地方的player，没细看
        var _player = $("#blackBoardPlayer");

        _self.init = function(){
            var _tpl = shellcmd.readFile(_tplpath);
            _ready = false;
            _Dom = $(_tpl);
            btns.closebtn = _Dom.find("#cntestclose");
            controls.cntestcanvas = _Dom.find("#cntestcanvas");
            controls.cnresult = _Dom.find("#cnresult");
            controls.cnwrite = _Dom.find("#cnwrite");
            //文字结果展示区
            controls.cnreContent = _Dom.find("#cnreContent");
            btns.retocnwrite = _Dom.find("#retocnwrite");
            btns.cnrecognize = _Dom.find("#cnrecognize");
            btns.cnEraser = _Dom.find("#cnEraser");
            btns.showcnpy = _Dom.find("#showcnpy");
            btns.girlsay = _Dom.find("#girlsay");
            btns.boysay = _Dom.find("#boysay");
            btns.cnWordsEval = _Dom.find("#cnWordsEval");
            btns.cnSingleEval = _Dom.find("#cnSingleEval");
            btns.cnEval = _Dom.find("#cnEval");
            btns.cnBiShun = _Dom.find("#cnBiShun");
            btns.cnNextPage = _Dom.find("#cnNextPage");
            btns.cnPrePage = _Dom.find("#cnPrePage");
            controls.cnEvalDiv = _Dom.find("#cnEvalDiv");
            controls.cnBiShunPanel = _Dom.find("#cnBiShunPanel");
            //笔顺汉字显示面板
            controls.cnbsch = _Dom.find("#cnbsch");
            controls.cntestcanvas.attr("width", _canvasWidth).attr("height",_canvasHeight);
            controls.cntestcanvasCtx = controls.cntestcanvas[0].getContext("2d");

            controls.cntestcanvas.css("cursor", bbhelper.cursor.penCursor);
            controls.cntestcanvasCtx.strokeStyle = _color;
            controls.cntestcanvasCtx.fillStyle = _color;
            controls.cntestcanvasCtx.lineWidth = _size;
            controls.cntestcanvasCtx.lineJoin = "round";
            controls.cntestcanvasCtx.lineCap = "round";

            _self.addEvents();
        }

        //添加绑定事件
        _self.addEvents = function(){

            btns.closebtn.click(_self.close);

            btns.retocnwrite.click(_self.show);

            btns.cnrecognize.click(_self.showResult);

            btns.showcnpy.click(_self.togglePy);

            btns.girlsay.click(function(){
                _self.playSoundHelper(bbhelper.LanguageType.Chinese, "wangru");
            });

            btns.boysay.click(function(){
                _self.playSoundHelper(bbhelper.LanguageType.Chinese, "xiaoyu");
            });

            btns.cnEval.click(_self.evalToggle);

            btns.cnEraser.click( _self.clearStrokePoints)

            //中文单字评测
            btns.cnSingleEval.click(function () {
                _self.evalHelper(bbhelper.LanguageType.Chinese, "cn_word", "wangru");
            });

            //中文词语评测
            btns.cnWordsEval.click(function () {
                _self.evalHelper(bbhelper.LanguageType.Chinese, "cn_word", "wangru");
            });

            btns.cnBiShun.click(_self.bishunToggle);

            controls.cnbsch.click(function(){
                var s = $(this).attr("word");
                _self.createStrokeOrder(s);
            });

            btns.cnPrePage.click(function(){
                if(_curIndex > 0){
                    _self.showStroke(--_curIndex);
                }
            });

            btns.cnNextPage.click(function(){
                if(_curIndex < _toStrokeResultWords.length ){
                    _self.showStroke(++_curIndex);
                }
            });

            var sx,sy,ex,ey;
            var   _isPainting = false;
            controls.cntestcanvas.mousedown(function(e){
                controls.cntestcanvasCtx.beginPath();
                var startX = e.offsetX, startY = e.offsetY;
                //在仅仅点击鼠标时，需要画出一个点，如果不加上这0.01个像素，则画不出来
                sx = startX + 4,sy = startY + 4;
                ex = startX + 4 + 0.01, ey = startY + 4 + 0.01;
                strokes.push([sx,sy]);
                controls.cntestcanvasCtx.moveTo(sx, sy);
                controls.cntestcanvasCtx.lineTo(ex, ey);
                controls.cntestcanvasCtx.stroke();
                _isPainting = true;
            }).mousemove(function(e){
                    if(_isPainting){
                        ex = e.offsetX + 4, ey = e.offsetY + 4;
                        strokes.push([ex, ey]);
                        controls.cntestcanvasCtx.lineTo(ex, ey);
                        controls.cntestcanvasCtx.stroke();
                    }
                }).mouseup(function(){
                    strokes.push([-1, -1]);
                    _isPainting = false;
                    strokes = bbhelper.removeSerialJoints(bbhelper.removeFirstJoint(strokes));
                }).mouseout(function(){
                    strokes.push([-1, -1]);
                    _isPainting = false;
                    strokes = bbhelper.removeSerialJoints(bbhelper.removeFirstJoint(strokes));
                });
        }

        _self.evalToggle = function(){
            controls.cnEvalDiv.toggle();
        }

        _self.bishunToggle = function(){
            controls.cnBiShunPanel.toggle();
            _self.showStroke(0);
        }

        _self.close = function(){
            _Dom.hide();
        }

        _self.startOpen = function(){
            if(!_ready){
                _Dom.appendTo("body");
                _ready = true;
                _self.show("",1);
            }
            else{
                _self.show("",1);
            }
            //监管
            var action = LogManager.action.trigger;
            var params = {};
            params.module = '1130413';
            var user_id = ebkcontext.getUser().getUid();
            if(user_id != '0' && user_id){
                params.user_id =user_id;
            }
            LogManager.statistics(action,params);
        }

        _self.show = function(e,flag){
            controls.cnwrite.show();
            controls.cnresult.hide();
            _Dom.show();
            if(flag){
                _self.clearStrokePoints();
            }
        }

        _self.clearStrokePoints = function(){
            strokes = [];
            _toStrokeResultWordStr = "";
            _toStrokeResultWords = [];
            _strokeOrderResultWordArr = [];
            controls.cntestcanvasCtx.clearRect(0,0,_canvasWidth,_canvasHeight);
            _curIndex = 0;
        }

        //识别
        _self.showResult = function(){
            if(strokes.length>0){
                //TODO : 后续可以考虑缓存优化，在“返回”之后不需要再进行“识别”
                bbhelper.initShellTTs().done(function (initResult) {
                    if (!initResult) {
                        _self.showTips(AppBlackBoardTipsList.InitTTSFailed);
                        return;
                    }
                    bbhelper.strokes2Words(bbhelper.LanguageType.Chinese, strokes).done(function (wordStr) {
                        if (wordStr) {
                            _toStrokeResultWordStr = wordStr;
                            _toStrokeResultWords = [];
                            for (var i = 0; i < wordStr.length; i++) {
                                _toStrokeResultWords.push(wordStr[i]);
                            }
                            //先整个句子都合成，得到每个字的拼音
                            bbhelper.textToSpeech([wordStr], speecher).done(function (result) {
                                if (result) {
                                    var pylist = [];
                                    var everyPyArr = result.everyPyArr;
                                    for (var j = 0; j < wordStr.length; j++) {
                                        var py = pyUtil.convertToPy(everyPyArr[j]);
                                        pylist.push(py);
                                    }
                                    _self.addResult(wordStr,pylist);
                                    controls.cnwrite.hide();
                                    controls.cnresult.show();
                                    controls.cnEvalDiv.hide();
                                    controls.cnBiShunPanel.hide();
                                }
                            });
                        }

                    });
                });
            }
            else{
                _self.showTips("请先书写文字");
            }
        }

        //将结果添加到DOM上
        _self.addResult = function(wordsString,pylist){
            var i,len,htmlstr = "";
            for(i=0,len=wordsString.length;i<len;i++){
                htmlstr += _resulttpl.replace("{1}",pylist[i]).replace("{2}",wordsString[i]);
            }
            var htmlObj = $(htmlstr);
            controls.cnreContent.empty().append(htmlObj).find(".dist-pinyin").css("visibility","hidden");
        }

        //拼音显示隐藏切换
        _self.togglePy = function(){
            var spans = controls.cnreContent.find(".dist-pinyin");
            if($(spans[0]).css("visibility") == "visible"){
                spans.css("visibility","hidden");
            }
            else{
                spans.css("visibility","visible");
            }
        }

        //发音
        _self.playSoundHelper = function (language, speecher) {
            showLoading({tips: AppBlackBoardTipsList.ConvertingTextToSpeech});
            if(AppCfg.isBBT){
                ibWSLogic.setDongleAction(ibWSLogic.DONGLE_ACTION.TTS);
                ibWSLogic.setTTSObj(_self,language,speecher);
                var json = {
                    to     : "tray",
                    action : "watchdog_exist"
                };
                socket.send(json);
            }else{
                _self.realPlaySoundHelper(language,speecher);
            }
        };

        _self.realPlaySoundHelper = function (language, speecher) {
            bbhelper.initShellTTs().done(function (initResult) {
                if (!initResult) {
                    hideLoading();
                    _self.showTips(AppBlackBoardTipsList.InitTTSFailed);
                    return;
                }
                bbhelper.textToSpeech([_toStrokeResultWordStr], speecher, false).done(function (result) {
                    hideLoading();
                    result && bbhelper.audioPlay(result.audioPaths[0], _player);
                });
            });
        };

        _self.evalHelper = function (language, cardType, speecher) {
            showLoading({tips: AppBlackBoardTipsList.CreatingCards});
            if(AppCfg.isBBT){
                ibWSLogic.setDongleAction(ibWSLogic.DONGLE_ACTION.TTSEVALCARD);
                ibWSLogic.setTTSEvalCard(_self,language,cardType,speecher);
                var json = {
                    to     : "tray",
                    action : "watchdog_exist"
                };
                socket.send(json);
            }else{
                _self.realEvalHelper(language,cardType,speecher);
            }
        };

        _self.realEvalHelper = function (language, cardType, speecher) {
            bbhelper.initShellTTs().done(function (initResult) {
                if (!initResult) {
                    hideLoading();
                    _self.showTips(AppBlackBoardTipsList.InitTTSFailed);
                    return;
                }
                if (language === bbhelper.LanguageType.Chinese) {
                    if (speecher === "wangru") {
                        _self.CNwordsEvaHelper(speecher, cardType);
                    }
                    else if (speecher === "xiaoyan") {
                        _self.CNchEvaHelper("wangru", cardType);
                    }
                }
            });
        };

        _self.CNwordsEvaHelper = function (speecher, cardType) {
            //先整个句子都合成，得到每个字的拼音
            bbhelper.textToSpeech(_toStrokeResultWords, speecher).done(function (result) {
                if (result) {
                    var cssmlWords = [];
                    var everyPyArr = result.everyPyArr;
                    //需要把识别出来的字符串拆成单个字
                    for (var i = 0; i < _toStrokeResultWords.length; i++) {
                        var wordCSSML = '<?xml version="1.0" encoding="gb2312"?><speak><phoneme py=' + everyPyArr[i] + '>' +
                            _toStrokeResultWords[i] + '</phoneme>';
                        cssmlWords.push(wordCSSML);
                    }
                    hideLoading();
                    var card = bbhelper.createMeta(cardType, result);
                    _showCard(card);
                }
            });
        }

        _self.CNchEvaHelper = function (speecher, cardType) {
            bbhelper.textToSpeech([_toStrokeResultWordStr], speecher).done(function (result) {
                if (result) {
                    var resultWords = result.resultWords;
                    bbhelper.textToSpeech(resultWords, speecher).done(function (newResult) {
                        if (newResult) {
                            (newResult.resultWords.length == 0) ? (bbhelper.showTips(AppBlackBoardTipsList.InitTTSFailed)) :
                                (_showCard(bbhelper.createMeta(cardType, newResult)));
                        }
                        hideLoading();
                    });
                }
            });
        }

        function _showCard(card) {
            bbhelper.showCard(card,CardWrapper);
        }

        _self.showTips = function(tips){
            showAlertTips(tips);
        }

        _self.showStroke = function (index) {
            index && (_curIndex = index);
            controls.cnbsch.attr("word",_toStrokeResultWords[_curIndex]).text(_toStrokeResultWords[_curIndex]);
        }

        _self.createStrokeOrder = function (word) {
            var strokeUrl = AppRemoteSvcCfg.BlackBoardStrokeOrderPageUrl;
            var source =  "&type=0604&keyword=" + word;
            var src = strokeUrl + source;
            var strokeIframe = $('<iframe id="dictionary_'+ source +'" frameborder="0" allowtransparency="true" scrolling="no" src="' + src + '"></iframe>').load(function () {
            });

            bbhelper.checkShellOnline().done(function (isNetWorking) {
                if (!isNetWorking) {
                    _self.showTips( (!ebkcontext.getUser().getIsOnline())? AppTips.LocalLoignMsg : AppTips.NetWorkConnectFailed);
                } else {
                    registerIframe( 'dictionary_'+ source, '*');
                    CardWrapper.show(strokeIframe[0]);
                    //下面这段代码先屏蔽放到这里吧，说不定对某些人很有用的，linwang5
                   // var idTemp = "dictionary_"+ source;
                    //var iframeLoad = document.getElementById(idTemp);
                    //iframeLoad.onload = function(){
                    //    console.log(' %c dapingzi.................','color:red');
                    //}
                }
            });
        }

    }

    exports.PluginChineseTest = PluginChineseTest;
});
