/**
 * 云端插件管理
 *
 */

/**
 * Caution : 暂未考虑云端下架删除APP的情况
 */
;define(function(require,exports){

    function CloudPlugins(){
        var _pluginprovider = require("./cloudpluginsprovider").Instance;

        var _pluginItemTpl = '<li class="relative"><span style="background:url(assert/images/{{thumbnail}})" class="plug-ic plug-ic01 absolute"></span><div class="plug-con clearfix">'+
                 '<div class="plug-con-c fl"><h3>{{title}}{{spanflag}}</h3><p>{{description}}</p></div>{{btn}}</div></li>';

        var _newSpan = '<span class="ic-new relative"><img src="assert/images/ic_new.png" alt=""></span>';
        var _alreadySpan = '<span class="blue">(已安装)</span>';
        var _unistallBtn = '<a href="javascript:void(0);" name="{{name}}" pcode="dele" class="btn-plug btn-uninst fr">卸载</a>';
        var _installBtn = '<a href="javascript:void(0);" name="{{name}}" pcode="add" class="btn-plug btn-install fr">安装</a>';

        var _list = [];

        var _self = this ;

        var _DOM = {};

        var _newItems = [];

        var _pluginMgr = null;

        //初始化
        _self.init = function(domParam ,pluginMgr){
            var def = $.Deferred();
            _pluginMgr = pluginMgr;

            //获取item信息,将item存在_list里面
            _DOM.cloudpluginlist = domParam.find("#cloudpluginlist");
            _self.getInfo().done(function(){
                def.resolve();
            });

            _self.addEvents();

            return def.promise();
        }

        _self.addEvents = function(){
            _DOM.cloudpluginlist.click(function(e){
                var $etarget = $(e.target);
                if($etarget.attr("pcode") == "add"){
                    _self.addPlugin($etarget.attr("name"))
                }
                else if($etarget.attr("pcode") == "dele"){
                    _self.delePlugin($etarget.attr("name"))
                }

            })
        };

        _self.getInfo = function(){
            var def = $.Deferred();
            var task1 = _pluginprovider.getLocalInfo();
            var task2 =  _self.getCloudInfo();
            $.when(task1,task2).done(function(retlist1,retlist2){
                //能获取到最新信息，更新下
                if(retlist2){
                    _list = _self.mergeInfo(retlist1,retlist2);
                    _pluginprovider.updateLocalInfo(_list);
                }
                else{
                    _list = retlist1;
                }
                def.resolve();
            });
            return def.promise();
        }

        _self.mergeInfo = function(localinfo,cloudinfo){
            var i,leni, j,lenj;
            //更新已有信息
            for(i=0,leni=localinfo.length;i<leni;i++){
                for(j=0,lenj = cloudinfo.length;j<lenj;j++){
                    if(localinfo[i].id === cloudinfo[j].id){
                        $.extend(localinfo[i],cloudinfo[j]);
                        cloudinfo.splice(j,1);
                        break;
                    }
                }
            }
            //添加没有信息
            if(cloudinfo.length>0){
                //_newItems另做他用
                _newItems = cloudinfo;
                localinfo = localinfo.concat(cloudinfo);
            }
            console.log("%c yczhu:","background:#4CB4C8",localinfo);
            return localinfo;
        }

        //从云端接口
        _self.getCloudInfo = function(){
            //TODO : 获取不到信息时要做处理
            var def = $.Deferred();
            var ans = '[{"Id":"1","name":"中文识别","englishname":"test","version":"1.1","model":"0","content":null,"updown":"1","lowurl":"http:\/\/192.168.62.57\/Main\/TPlatform\/upload\/picture\/10_low_nmfyNxSqSK.jpg","highurl":"http:\/\/192.168.62.57\/Main\/TPlatform\/upload\/picture\/10_high_x76Wd98F9d.jpg","screenurl":["http:\/\/192.168.62.57\/Main\/TPlatform\/upload\/picture\/10_screen_MmD8rkQYY0.jpg","http:\/\/192.168.62.57\/Main\/TPlatform\/upload\/picture\/10_screen_XvsAEFByPl.jpg","http:\/\/192.168.62.57\/Main\/TPlatform\/upload\/picture\/10_screen_75xXf7i1Na.jpg"],"zipurl":"http:\/\/192.168.62.57\/Main\/TPlatform\/upload\/zip\/10_zip_l8uWewpY2r.zip","createtime":"2015-05-13 15:00:11","zipsize":"0","description":"asdaddads","minversion":"1.1111111111","is_ta":"1","is_nw":"0","open_path":"\/","title":"1"},{"Id":"11","name":"\u518d\u6765\u4e00\u6b21","englishname":"123","version":"1.0","model":"0","content":null,"updown":"1","lowurl":"http:\/\/192.168.62.57\/Main\/TPlatform\/upload\/picture\/11_low_4Doent791i.jpg","highurl":"http:\/\/192.168.62.57\/Main\/TPlatform\/upload\/picture\/11_high_lInjiEUU1B.jpg","screenurl":["http:\/\/192.168.62.57\/Main\/TPlatform\/upload\/picture\/11_screen_kn0LVMxoRW.jpg","http:\/\/192.168.62.57\/Main\/TPlatform\/upload\/picture\/11_screen_nq9Q0YE206.jpg","http:\/\/192.168.62.57\/Main\/TPlatform\/upload\/picture\/11_screen_VKCgmPcLNd.jpg"],"zipurl":"http:\/\/192.168.62.57\/Main\/TPlatform\/upload\/zip\/11_zip_cuI9brgbXJ.zip","createtime":"2015-05-13 11:28:36","zipsize":"0","description":"\u54c8\u54c8","minversion":"1.1","is_ta":"1","is_nw":"1","open_path":"","title":"111"}]';
            var jsonObj = JSON.parse(ans);
            jsonObj = [];
            def.resolve(_self.cloudInfoFormat(jsonObj));
            return def.promise();
        }

        _self.show = function(){
            //根据_list显示界面
            var i,len,data;
            var htmlStr = "";
            for(i=0,len = _list.length;i<len;i++){
                data = _list[i];
                htmlStr += _pluginItemTpl.replace("{{spanflag}}",_newSpan)
                    .replace("{{description}}",data.description)
                    .replace("{{btn}}",data.download == "1" ? _unistallBtn : _installBtn)
                    .replace("{{thumbnail}}",data.thumbnail)
                    .replace("{{title}}",data.title)
                    .replace("{{name}}",data.name)
            }
            var htmlObj = $(htmlStr);
            _DOM.cloudpluginlist.empty().append(htmlObj);
        }

        //云端信息格式转换
        _self.cloudInfoFormat = function(list){
            var i,len,obj,listHere = [];
            for(i=0,len=list.length;i<len;i++){
                obj = {};
                obj.id = list[i].Id;
                obj.requireclient = list[i].minversion;
                obj.cloudversion = list[i].version;
                obj.description =  list[i].description;
                obj.title = list[i].name;
                obj.fileUrl = list[i].zipurl;
                listHere.push(obj);
            }
            console.log("%c yczhu:","background:#4CB4C8",listHere);
            return listHere;
        }

        _self.saveThumbnail = function(){

        }

        _self.returnDownloadPlugin = function(){
            var def = $.Deferred();

            def.resolve(selectPlugin(_list,"download",1));

           return def.promise();
        }

        function selectPlugin(list,key,value) {
            var listHere = [];
            var i, len;
            for (i = 0, len = list.length; i < len; i++) {
                if(list[i][key] == value){
                    listHere.push(list[i])
                }
            }
            return listHere;
        }

        function versionCompare (localv,cloudv){
            var _lv = parseFloat(localv);
            var _cv = parseFloat(cloudv);
            return _lv > _cv;
        }

        _self.addPlugin = function(name){
            var i,len;
            for(i=0,len=_list.length;i<len;i++){
                if(_list[i].name == name){
                    _list[i].download = 1;
                    break;
                }
            }
            _self.show();
            _pluginprovider.addOneInfo(_list[i].name);
            _pluginMgr.add(_list[i]);
        }

        _self.delePlugin = function(name){
            var i,len;
            for(i=0,len=_list.length;i<len;i++){
                if(_list[i].name == name){
                    _list[i].download = 0;
                    break;
                }
            }
            _self.show();
            _pluginprovider.deleOneInfo(_list[i].name);
            _pluginMgr.dele(_list[i].name);
        }
    }

    exports.CloudPlugins = CloudPlugins;
});
