/**
 * 随写板模块，提供随写板的功能
 * Date: 2013/06/16
 * Author: luxing@iflytek.com
 * @version 1.0
 * @module app/paint/miniBoardmgr
 */
/******************************************************
 * Caution :
 * 这也是个该死的废弃模块，名叫随写板，简称 sxb
 * 您在查看代码的时候可以考虑忽略。
 * 至于它为什么被废弃了，不详，
 * 只是我在维护代码的时候不敢轻易删除它。
 * 至少，对于新手，多看看前人写的代码总是有好处的。
 * 如果您有胆量，可以试一试。
 *
 *              -------  by yczhu
 *****************************************************/
define(function(require,exports,module){

    var MiniBoardManager = {};
    MiniBoardManager.canvasDiv=null;
    MiniBoardManager.canvasDivWidth=0;
    MiniBoardManager.canvasDivHeight=0;
    MiniBoardManager.canvasDivLeft=0;
    MiniBoardManager.canvasDivTop=0;
    MiniBoardManager.miniBoard_canvas=null;
    MiniBoardManager.miniBoard_context = null;
    MiniBoardManager.curPenSize=4;
    MiniBoardManager.curEraserSize=55;
    MiniBoardManager.isPainting=false;
    MiniBoardManager.curTool="pen";
    /**
     * @description 初始化绘图区域的基本信息
     * @param {string}  canvasDivId  随写板主显示区div的Id
     * @returns {}
     */
    MiniBoardManager.init = function(canvasDivId) {
        this.canvasDiv =$("#"+canvasDivId);
        this.canvasDivHeight = this.canvasDiv.height();
        this.canvasDivWidth = this.canvasDiv.width();
    }

    /**
     * @description 设置画笔颜色
     * @param {string} color 颜色值，可以是"black"等字符串，也可以直接是"FF00FF"之类的色值
     * @returns {}
     */
    MiniBoardManager.setColor = function (color) {
        this.miniBoard_context.strokeStyle = color;
        this.miniBoard_context.fillStyle = color;
    }

    /**
     * @description 设置画笔、板擦粗细
     * @param {string} tool 给哪个工具设置大小,pen,eraser
     * @param {number} size 笔迹大小
     * @returns {}
     */
    MiniBoardManager.setSize = function (tool,size) {
        if(this.miniBoard_canvas != null){
            this.miniBoard_context.lineWidth = size;
            this.miniBoard_context.lineJoin = 'round';
            this.miniBoard_context.lineCap = 'round';
            if(tool=="pen"){
                this.curPenSize=size;
            }else if(tool=="eraser"){
                this.curEraserSize=size;
            }
        }
    }
    /**
     * @description 隐藏随写板
     * @param {}
     * @returns {}
     */
    MiniBoardManager.hideMiniBoard=function(){
       $('#miniBoardControl').css("display","none");
    }

    /**
     * @description 设置工具类型
     * @param {string} tool 设置成哪个工具,mouse,pen,eraser
     * @returns {}
     */
    MiniBoardManager.setTool = function (tool) {
        if(tool=="mouse"){
            this.miniBoard_canvas.css("cursor","move");
            $(this.miniBoard_canvas).unbind();
            this.setMovable("miniBoardControl");
            this.curTool="mouse";
        }
        if (tool == "pen") {
            this.setUnmovable("miniBoardControl");
            if(this.miniBoard_canvas==null){
                this.createCanvas();
            }
            this.bindCommands();
            MiniBoardManager.miniBoard_context.globalCompositeOperation="source-over";
            MiniBoardManager.setSize("pen",MiniBoardManager.curPenSize);
            MiniBoardManager.setColor("white");
            this.miniBoard_canvas.css("cursor","crosshair");
            this.curTool="pen";
        }
        if (tool == "eraser") {
            this.setUnmovable("miniBoardControl");
            if (this.miniBoard_canvas == null) {
                this.createCanvas();
            };
            this.bindCommands();
            MiniBoardManager.miniBoard_context.globalCompositeOperation="destination-out";
            MiniBoardManager.setSize("eraser",MiniBoardManager.curEraserSize);
            this.miniBoard_canvas.css("cursor","url(assert/images/bc_normal.cur),auto");
            this.curTool="eraser";
        }
    }

    /**
     * @description 创建绘图的canvas
     * @param {}
     * @returns {}
     */
    MiniBoardManager.createCanvas=function(){
        if (this.miniBoard_canvas == null) {
            this.miniBoard_canvas = $("<canvas>");
            this.miniBoard_canvas.attr("width", this.canvasDivWidth-40);
            this.miniBoard_canvas.attr("height", this.canvasDivHeight-80);
            this.miniBoard_canvas.attr("id", 'miniBoard_canvas');
            this.miniBoard_canvas.css("position","absolute");
            //这里需要在设置style属性时，将px加上，否则赋值不成功
            this.miniBoard_canvas.css("left",this.canvasDivLeft+20 + "px");
            this.miniBoard_canvas.css("top",this.canvasDivTop+20 + "px");
            this.canvasDiv.append(this.miniBoard_canvas);
            this.miniBoard_context = this.miniBoard_canvas.get(0).getContext("2d");
            this.setSize("pen",this.curPenSize);

        };
    };
    /**
     * @description 绑定绘制笔迹的事件
     * @param {}
     * @returns {}
     */
    MiniBoardManager.bindCommands=function(){
        this.miniBoard_canvas.unbind();

        this.miniBoard_canvas.mousedown(function (evt) {
            MiniBoardManager.miniBoard_context.beginPath();
            var startX,startY;
            var endX,endY;
            if(MiniBoardManager.curTool=="pen"){
                startX=evt.pageX-MiniBoardManager.miniBoard_canvas.parent().offset().left-20;
                startY=evt.pageY-MiniBoardManager.miniBoard_canvas.parent().offset().top-20;
                endX = startX+ 0.01;
                endY = startY+ 0.01;
            }else if(MiniBoardManager.curTool=="eraser"){
                startX = evt.offsetX + MiniBoardManager.curEraserSize / 2;
                startY = evt.offsetY + MiniBoardManager.curEraserSize / 2;
                endX = startX + 0.01;
                endY = startY + 0.01;
            }
            MiniBoardManager.miniBoard_context.moveTo(startX, startY);
            MiniBoardManager.miniBoard_context.lineTo(endX, endY);
            MiniBoardManager.miniBoard_context.stroke();
            MiniBoardManager.isPainting=true;
        });
        this.miniBoard_canvas.mousemove(function (evt) {
            if(MiniBoardManager.curTool=="pen"){
                endX=evt.pageX-MiniBoardManager.miniBoard_canvas.parent().offset().left-20;
                endY=evt.pageY-MiniBoardManager.miniBoard_canvas.parent().offset().top-20;
            }else if(MiniBoardManager.curTool=="eraser"){
                endX=evt.pageX-MiniBoardManager.miniBoard_canvas.parent().offset().left-20+MiniBoardManager.curEraserSize / 2;
                endY=evt.pageY-MiniBoardManager.miniBoard_canvas.parent().offset().top-20+MiniBoardManager.curEraserSize / 2;
            }

            if (MiniBoardManager.isPainting) {
                MiniBoardManager.miniBoard_context.lineTo(endX,endY);
                MiniBoardManager.miniBoard_context.stroke();
            };
        });
        this.miniBoard_canvas.mouseup(function (e) {
            MiniBoardManager.isPainting = false;
        });
        this.miniBoard_canvas.mouseout(function (e) {
            MiniBoardManager.isPainting = false;
        });
    }
    /**
     * @description 移动整个Div
     * @param {string}  miniBoardDivId 整个随写板区域Div的Id
     * @returns {}
     */
    MiniBoardManager.setMovable=function(miniBoardDivId){
        var isDraging = false;
        function setCanMove(miniBoardDivId) {
            var miniBoardDiv = document.getElementById(miniBoardDivId);
            var startX, startY;
            var endX,endY;
            var originalLeft,originalTop;

            $("#"+miniBoardDivId).mousedown(function(e) {
                isDraging = true;
                originalLeft = miniBoardDiv.offsetLeft;
                originalTop = miniBoardDiv.offsetTop;
                startX = e.clientX;
                startY = e.clientY;
            });
            $("#"+miniBoardDivId).mousemove(function(e) {
                endX= originalLeft + e.clientX - startX;
                endY=originalTop+ e.clientY - startY;
                if (!isDraging) return false;
                if(endX>=-10 && endX<document.body.clientWidth-miniBoardDiv.offsetWidth+10){
                    miniBoardDiv.style.left = endX + "px";
                }
                if(endY>=-10 && endY<document.body.clientHeight-miniBoardDiv.offsetHeight-10){
                    miniBoardDiv.style.top = endY + "px";
                }

            });
            $("#"+miniBoardDivId).mouseup(function(){

                isDraging=false;
            });
            $("#"+miniBoardDivId).mouseout(function(){
                isDraging=false;
            });
        }
        setCanMove(miniBoardDivId);
    }
    /**
     * @description 取消移动Div
     * @param {string}  miniBoardDivId 整个随写板区域Div的Id
     * @returns {}
     */
    MiniBoardManager.setUnmovable=function(miniBoardDivId){
        $("#"+miniBoardDivId).unbind();
    }
    /**
     * @description 缩放整个Div
     * @param {string}  cornerDivId 随写板边角的Id
     * @returns {}
     */
    /*
    MiniBoardManager.setResizable=function(cornerDivId){
        var isResizing = false;
        function setCanResize(cornerDivId) {
            var cornerDiv=document.getElementById(cornerDivId);
            var startX, startY;
            var increaceX,increaceY;
            var mouseX=[];
            var mouseY=[];
            //var originalDivLeft,originalDivTop;
            var boardWidth,boardHeight;
            var canvasWidth,canvasHeight;
            var originalCanvas;
            $("#"+cornerDivId).mousedown(function(e) {
                isResizing = true;
                startX = e.clientX;
                startY = e.clientY;
                mouseX.push(startX);
                mouseY.push(startY);
                increaceX=0;
                increaceY=0;
                boardWidth=$("#miniBoardCenter").width();
                boardHeight=$("#miniBoardCenter").height();
                canvasWidth=MiniBoardManager.miniBoard_canvas.width();
                canvasHeight=MiniBoardManager.miniBoard_canvas.height();
                originalCanvas=MiniBoardManager.miniBoard_canvas.get(0).toDataURL();
            });
            $("#"+cornerDivId).mousemove(function(e){
                e.preventDefault();
                if (isResizing==false) return false;
                mouseX.push(e.clientX);
                mouseY.push(e.clientY);
                MiniBoardManager.clearCanvas();
                increaceX= mouseX[mouseX.length-1]-startX;
                increaceY= mouseY[mouseY.length-1]-startY;
                $("#miniBoardCenter").css("width",boardWidth+increaceX + "px");
                $("#miniBoardCenter").css("height",boardHeight+increaceY + "px");
                MiniBoardManager.miniBoard_canvas.width(canvasWidth+increaceX + "px");
                MiniBoardManager.miniBoard_canvas.height(canvasHeight+increaceY+"px");
                var img=$("<img>");
                img.attr("src",originalCanvas);
                img.get(0).onload=function(){
                    MiniBoardManager.miniBoard_context.drawImage(img.get(0),0,0);
                };

                console.log("+X:"+increaceX+"+Y:"+increaceY);
            });
            $("#"+cornerDivId).mouseup(function(e){
                isResizing=false;
            });
            $("#"+cornerDivId).mouseout(function(e){
                isResizing=false;

            });
        }
        setCanResize(cornerDivId);
    }
    */
    /**
     * @description 清空canvas
     * @param {}
     * @returns {}
     */
    MiniBoardManager.clearCanvas = function () {
        this.miniBoard_context.clearRect(0, 0, this.miniBoard_canvas.width(), this.miniBoard_canvas.height());
    };


    //给页面元素绑定点击事件,miniBoardBottomControl里的按钮
    $('#btnMiniBoardLeft').click(function(){
        if($('#miniBoardControl').css("display")=="none"){
            $('#miniBoardControl').css("display","block");
            $('#miniBoardControl').css("zIndex",1);
            if(MiniBoardManager.curTool=="pen"){
                $("#miniBoardControl").children().children(".toolbar_black_current").attr("class", "toolbar_black");
                $('#btnMiniBoardPen').attr("class", "toolbar_black_current");
                MiniBoardManager.setTool('pen');
            }else if(MiniBoardManager.curTool=="eraser"){
                $("#miniBoardControl").children().children(".toolbar_black_current").attr("class", "toolbar_black");
                $('#btnMiniBoardEraser').attr("class", "toolbar_black_current");
                MiniBoardManager.setTool('eraser');
            }else if(MiniBoardManager.curTool=="mouse"){
                $("#miniBoardControl").children().children(".toolbar_black_current").attr("class", "toolbar_black");
                $('#btnMiniBoardMouse').attr("class", "toolbar_black_current");
                MiniBoardManager.setTool('mouse');
            }
        }else if($('#miniBoardControl').css("display")=="block"){
            MiniBoardManager.hideMiniBoard();
        }
    });
    $('#btnMiniBoardRight').click(function(){
        if($('#miniBoardControl').css("display")=="none"){
            $('#miniBoardControl').css("display","block");
            $('#miniBoardControl').css("zIndex",1);
            MiniBoardManager.setTool('pen');
            if(MiniBoardManager.curTool=="pen"){
                $("#miniBoardControl").children().children(".toolbar_black_current").attr("class", "toolbar_black");
                $('#btnMiniBoardPen').attr("class", "toolbar_black_current");
                MiniBoardManager.setTool('pen');
            }else if(MiniBoardManager.curTool=="eraser"){
                $("#miniBoardControl").children().children(".toolbar_black_current").attr("class", "toolbar_black");
                $('#btnMiniBoardEraser').attr("class", "toolbar_black_current");
                MiniBoardManager.setTool('eraser');
            }else if(MiniBoardManager.curTool=="mouse"){
                $("#miniBoardControl").children().children(".toolbar_black_current").attr("class", "toolbar_black");
                $('#btnMiniBoardMouse').attr("class", "toolbar_black_current");
                MiniBoardManager.setTool('mouse');
            }
        }else if($('#miniBoardControl').css("display")=="block"){
            MiniBoardManager.hideMiniBoard();
        }
    });

    $('#btnMiniBoardMouse').click(function(){
        //去除随写板工具栏中，所有按钮的选中状态
        $("#miniBoardControl").children().children(".toolbar_black_current").attr("class", "toolbar_black");
        //给当前按钮设定选中状态
        $('#btnMiniBoardMouse').attr("class", "toolbar_black_current");
        MiniBoardManager.setTool('mouse');
        //MiniBoardManager.setResizable("sxb_botright");

    });
    $('#btnMiniBoardPen').click(function(){
        $("#miniBoardControl").children().children(".toolbar_black_current").attr("class", "toolbar_black");
        $('#btnMiniBoardPen').attr("class", "toolbar_black_current");
        MiniBoardManager.setTool('pen');
    });
    $('#btnMiniBoardEraser').click(function(){
        $("#miniBoardControl").children().children(".toolbar_black_current").attr("class", "toolbar_black");
        $('#btnMiniBoardEraser').attr("class", "toolbar_black_current");
        MiniBoardManager.setTool('eraser');
    });
    $('#btnMiniBoardClear').click(function(){
        MiniBoardManager.clearCanvas();
    });
    $('#btnMiniBoardClose').click(function(){
        MiniBoardManager.hideMiniBoard();
    });
    /*
    $("#sxb_topleft").mouseover(function(){
        $("#sxb_topleft").css("cursor","se-resize");
    });
    $("#sxb_topright").mouseover(function(){
        $("#sxb_topright").css("cursor","ne-resize");
    });
    $("#sxb_botleft").mouseover(function(){
        $("#sxb_botleft").css("cursor","sw-resize");
    });
    $("#sxb_botright").mouseover(function(){
        $("#sxb_botright").css("cursor","nw-resize");
    });
    */
    exports.Instance = MiniBoardManager;
});