/**
 * 画笔板擦模块，提供全局的画笔、板擦功能
 * Date: 2013/06/16
 * Author: luxing@iflytek.com
 * @version 1.0
 * @module app/paint/canvasmgr
 */

define(function (require, exports, module) {
    var _model = require('../model');
    var canvasMgrHelper = require("./canvasmgrhelper").CanvasMgrHelper;
    var bbhelper = require("../blackboard/blackboardhelper").instance;
    var StrokeResult = require("./strokeresult").Instance;
    var ebContext = require("../ebookcontext").Instance;
    var ibWSLogic = require("../../ibWSLogic");

    var TempToolType = {
        TransPenYellow: 'transPenYellow',
        TransPenRed: 'transPenRed',
        TransPenBlue: 'transPenBlue'
    }

    var Dom = {
        _colorBoxImg: $("#colorBoxImg"),
        _colorBox: $(document.getElementById('template_color_box').innerHTML),
        _otherPenControl: $('#otherPenControl'),
        /** @type {jQuery} */
        _canvasContainer: $('<div/>').attr('class', 'paint_container').css({'width': '100%', 'height': '100%'}),
        _toolQtb: $("#tool_qtb"),
      //  _btnPen : $("#btnPen")
        _penEraserTool:$("#penEraserTool"),
        _PenControlPanel : $("#penControl") ,
        _r_PenControlPanel : $("#r_penControl") ,
        _Pen : $(".pen") ,
        _nitePen:$(".jxbubble-pen"),
        _erase : $("#eraserControl"),
        _r_erase : $("#r_eraserControl"),
        colorBoxShow : $('#color_box'),
        _penMenuBtn:$("#penMenuBtn"),
        _eraserMenuBtn:$("#eraserMenuBtn")
    }


    /**
     */
    var GlobalListen = function(){
       // console.log("Global Listen");
        //console.log(event.target);
        var $TargetDom = $(event.target);
        if ($TargetDom.parents('#color_box').length != 0){
            return ;
        }
        if($TargetDom.parents("#penControl").length != 0 || $TargetDom.parents("#eraserControl").length != 0){
            return ;
        }
        if($TargetDom.parents("#btnImportChoicePanel").length != 0){
            return ;
        }
        $("#btnImportChoicePanel").hide();
        //左右黑板、课本
        var theDomId = $(event.target).parent().attr('id');
        if(theDomId == 'r_tool_mid' || theDomId == 'r_tool_qycc'|| theDomId == 'r_tool_qbcc'||
            theDomId == 'r_penClr_black' || theDomId == 'r_penClr_red' || theDomId == 'r_penClr_blue'||
            theDomId == 'r_tool_dl2' || theDomId == 'r_tool_dl3' || theDomId == 'r_tool_dl4' ||
            theDomId == 'btnRightPen' || theDomId == 'btnRightEraser'){
            return true;
        }else{
            Dom._r_PenControlPanel.hide();
            Dom._r_erase.hide();
        }
        /**
         *监测同步资源标签属性的变化,控制灰色气泡的显隐性
        */
        //TODO::气泡位置移除待重构-$.parents();
        setTimeout(function(){
            var a = $(".J_selected_content").is(":visible");
            if(a){
                $(".selected-bubble").show();
            }else{
                $(".selected-bubble").hide();
            }
        },500)
    } ;


    document.addEventListener("mousedown",GlobalListen,true);


    function PaintCanvas() {
        var strokes = [];
        var clearAreaPoints = [];
        //添加color_box

       // Dom._btnPen.popover({content: Dom._PenControlPanel, userDefinePopover: true, popoverId: 'title', verticalOffset: "20"});

        Dom._colorBoxImg.popover({content: Dom._colorBox, userDefinePopover: true, popoverId: 'title', verticalOffset: "20"});

        //翻译
        LAN.translateObj(Dom._colorBox);

        //添加otherPenControl
        //Dom._toolQtb.popover({content: Dom._otherPenControl, userDefinePopover: true, popoverId: 'title', verticalOffset: "35"});

        Dom = canvasMgrHelper.getCanvasMgrDom(Dom);
        var _self = this;
        /** @type {jQuery} */
        var _strokeCanvas;
        var _strokeCanvasDom;
        /** @type {CanvasRenderingContext2D} */
        var _strokeContext;
        /** @type {HTMLCanvasElement} */
        var _tempCanvas;
        var _tempCanvasDom;
        /** @type {CanvasRenderingContext2D} */
        var _tempContext;
        var _curPenSize = 4;
        var _curPenColor = "red";
        var _curEraserSize = bbhelper.EraserSize.Normal;
        var _isPainting = false;
        var _curTool = bbhelper.ToolType.Mouse;
        var _curOtherPen = TempToolType.TransPenYellow;
        var _curCursor = bbhelper.cursor.auto;
        var _lastSelected = {
            curToolType: null,
            penColorEle: $(Dom._penColors[1]),
            penColorValue: _curPenColor,
            penSizeEle: $(Dom._penSizes[1]),
            penSizeValue: _curPenSize,
            otherPenEle: null,
            otherPenValue: _curOtherPen,
            eraserType: bbhelper.ToolType.NormalEraser,
            eraserTypeEle: $(Dom._eraserTypes[1]),
            eraserTypeValue: _curEraserSize
        };
        var _isStrokeChanged = false;
        var _zoomRate = 1;
        var _isEditing = false;

        this.getStrokes = function () {
            return strokes;
        }

        this.setStrokes = function (_strokes) {
            strokes = _strokes;
        }

        /**
         * 返回基础画布canvas对象
         * @returns {jQuery}
         */
        this.getStrokeCanvas = function () {
            return   _strokeCanvas;
        }

        /**
         * 返回荧光笔、区域擦除临时画布canvas对象
         * @returns {jQuery}
         */
        this.getTempCanvas = function () {
            return   _tempCanvas;
        }

        /**
         * 返回画布父容器Div
         * @returns {jQuery}
         */
        this.getCanvasContainer = function () {
            return Dom._canvasContainer;
        }

        /**
         * 初始化画布
         */

        this.init = function () {
            _removePenSlectedStyles();
            _hidePopControls();
            _bindClickEventsToMainUI();



        }

        /**
         * 设置缩放后的板擦大小,否则放大的情况下板擦会跟着变大（鼠标很小，很怪）
         */
        this.setZoomedEraserSize = function (zoomRate) {
            _zoomRate = zoomRate;
            _curEraserSize = bbhelper.EraserSize[_lastSelected.eraserType] / zoomRate;
        }

        /**
         * 将_strokeCanvas内容绘制到viewDom
         */
        this.drawStrokeCanvasToBookContainer = function () {
            _drawStrokeCanvasToBookContainer();
        }

        /**
         * 将viewDom的canvas笔迹恢复到全局_strokeCanvas
         */
        this.restoreStrokeFromBookContainer = function () {
            _restoreStrokeFromBookContainer();
        }

        /**
         * 获取当前所处工具状态，是否处于鼠标状态
         */
        this.isMouseMode = function () {
            return (Dom.btnMouse.attr("class") === "tool_current");
        }

        /**
         * 清空canvas
         */
        this.clearCanvas = function () {
            _strokeContext.clearRect(0, 0, _strokeCanvas.width(), _strokeCanvas.height());
        }

        /**
         * 隐藏颜色选择器、荧光笔等弹出层控件
         */
        this.hidePopControls = function () {
            _hidePopControls();
        }

        /**
         * 设置编辑模式状态标记
         * @param {Boolean} value
         */
        this.setIsEditing = function (value) {
            if (value == _isEditing) return;
            _isEditing = value;

            Dom.btnPen.find('img:first').attr('src', 'assert/images/tool_brush' + (_isEditing ? '_disable' : '') + '.png');
            Dom.btnRightPen.find('img').attr('src', 'assert/images/tool_brush' + (_isEditing ? '_disable' : '') + '.png');
            Dom.btnEraser.find('img:first').attr('src', 'assert/images/tool_ostrich' + (_isEditing ? '_disable' : '') + '.png');
            Dom.btnRightEraser.find('img').attr('src', 'assert/images/tool_ostrich' + (_isEditing ? '_disable' : '') + '.png');
            Dom.tool_ClearAllWBEraser.find('img').attr('src','assert/images/clear-up' + (_isEditing ? '_disable' : '') + '.png');

           (_isEditing) && ( Dom.btnMouse.trigger("click"));
        }

        /**
         * 获取画笔笔迹是否改变标记值
         */
        this.getIsStrokeChanged = function () {
            return _isStrokeChanged;
        }
        /**
         * 设定画笔笔迹是否改变标记值
         */
        this.setIsStrokeChanged = function (isStrokeChanged) {
            _isStrokeChanged = isStrokeChanged;
        }

        this.recognitionEvent = function(type){
            _drawStrokeCanvasToBookContainer();
            $(_self).trigger('recognition',[type]);
        }

        /**
         * 设置画笔颜色
         */
        function _setColor(color) {
            (_strokeContext != null) && ( _strokeContext.strokeStyle = color , _strokeContext.fillStyle = color, _curPenColor = color);
        }

        /**
         * 设置画笔、板擦粗细
         */
        function _setSize(tool, size) {
            if (_strokeContext) {
                _strokeContext.lineWidth = size, _strokeContext.lineJoin = "round", _strokeContext.lineCap = "round";
                if (tool === bbhelper.ToolType.Pen) {
                    _curPenSize = size;
                } else if (tool === bbhelper.ToolType.Eraser) {
                    _curEraserSize = size;
                }
            }
        }

        /**
         * 设置鼠标样式
         */
        function _setCursor(cursor) {
            (_strokeCanvas) && ( _strokeCanvas.css("cursor", cursor) , _curCursor = cursor);
        }

        /**
         * 设置工具类型
         */
        function _changeToMode(toolType,isRight) {
            _removeToolBarSlectedStyles();
            if (toolType === bbhelper.ToolType.Mouse) {
              //temp eshop监管 linwang5@iflytek.com
                var staticParams = {
                    uid:ebContext._curUser._uid,
                    module:'03010',
                    type:'trigger',
                    havingClass:_isHavingClass?1:0
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);
                _lastSelected.curToolType = _curTool = bbhelper.ToolType.Mouse;
                //设置工具栏鼠标选中状态
                // Dom.btnMouse.attr("class", "tool_current");
                Dom.btnMouse.addClass("tool_current");
                Dom.btnRightMouse.attr("class", "sidertool_current");
                _hidePopControls();
                _hideTempCanvas();
            }
            else if (toolType === bbhelper.ToolType.Pen) {

                //temp eshop监管 linwang5@iflytek.com
                var staticParams = {
                    uid:ebContext._curUser._uid,
                    module:'03009',
                    type:'trigger',
                    havingClass:_isHavingClass?1:0
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);

                //这里要先设置curtool，后面的bindCommands会用到
                _lastSelected.curToolType = _curTool = bbhelper.ToolType.Pen;
                //设置工具栏画笔选中状态
                // Dom.btnPen.attr("class", "tool_current");
                Dom.btnPen.addClass("tool_current");
                Dom.btnRightPen.attr("class", "sidertool_current");
                _lastSelected.penColorEle.attr("class", "current");
                _lastSelected.penSizeEle.attr("class", "current");
                //隐藏板擦控件，显示画笔控件
                var btnRightOffset = $('#btnRightPen').offset();
                var btnOffset = $('#btnPen').offset();
                var penCanvas = $('#pen_canvas');
                if(app_global_isMainToolBarUp == false){
                    if(isRight == bbhelper.ToolType.isRight){
                        /**
                         * 点击右边的画笔效果,
                         * 为什么减30和310,目前不得知，后期优化不用数字，刚刚接触IFB，代码提多无暇顾及
                         * created by linwang5 2015-11-16
                         */

                        Dom.penControl.attr('isRight','true');
                        Dom.penControl.css("top" ,btnRightOffset.top.toFixed(0)-penCanvas.height()-40+"px")
                                      .css("left" ,btnRightOffset.left.toFixed(0)-btnOffset.left.toFixed(0)-300+"px");
                    }else{
                        Dom.penControl.attr('isRight','false');
                        Dom.penControl.css("top" ,"-87px").css('left','-54px');
                    }

                } else {

                    if(isRight == bbhelper.ToolType.isRight){
                        /**
                         * 点击右边的画笔效果,
                         * 为什么减30和310,目前不得知，后期优化不用数字，刚刚接触IFB，代码提多无暇顾及
                         * created by linwang5 2015-11-16
                         */
                        Dom.penControl.attr('isRight','true');
                        Dom.penControl.css("top" ,btnRightOffset.top.toFixed(0)-30+"px")
                                      .css("left" ,btnRightOffset.left.toFixed(0)-btnOffset.left.toFixed(0)-300+"px");
                    }else{
                        Dom.penControl.attr('isRight','false');
                        Dom.penControl.css("top" ,"69px").css("left" ,"-54px");
                    }

                }
                Dom.penControl.show(), Dom.eraserControl.hide();
                _hideTempCanvas();
                _createCanvas(), _bindCommands();
                _strokeContext.globalCompositeOperation = "source-over";
            //    _setSize(bbhelper.ToolType.Pen, _curPenSize);
            //    _setColor(_curPenColor);
                _setCursor(bbhelper.cursor.penCursor);
            }
            else if (toolType === bbhelper.ToolType.Eraser) {


                _lastSelected.curToolType = _curTool = bbhelper.ToolType.Eraser;
                //设置工具栏板擦选中状态
                // Dom.btnEraser.attr("class", "tool_current");
                Dom.btnEraser.addClass("tool_current");
                Dom.btnRightEraser.attr("class", "sidertool_current");
                Dom.btnLeftEraser.attr("class", "sidertool_current");
                _lastSelected.eraserTypeEle.attr("class", "party_current");
                if(_lastSelected.eraserTypeEle.attr('id') == 'tool_mid' ||
                    _lastSelected.eraserTypeEle.attr('id') == 'r_tool_mid'){
                    $('#tool_mid').attr("class", "party_current");
                    $('#r_tool_mid').attr("class", "party_current");
                }
                else if(_lastSelected.eraserTypeEle.attr('id') == 'tool_qycc' ||
                    _lastSelected.eraserTypeEle.attr('id') == 'r_tool_qycc'){
                    $('#tool_qycc').attr("class", "party_current");
                    $('#r_tool_qycc').attr("class", "party_current");
                }


                //隐藏画笔控件，显示板擦控件
                var btnRightOffset = $('#btnRightEraser').offset();
                var btnOffset = $('#btnEraser').offset();
                var penCanvas = $('#pen_canvas');
                Dom.penControl.hide();
                Dom.eraserControl.show();
                _createCanvas(), _bindCommands();
                _strokeContext.globalCompositeOperation = "destination-out";
               // _setSize("eraser", _curEraserSize);
                _setCursor(_curCursor === bbhelper.cursor.auto ? bbhelper.cursor.midEraCursor  : _curCursor);
            }
        }

        /**
         * @description 创建绘图的canvas
         */
        function _createCanvas() {
            _strokeCanvas ? (_strokeCanvas.show()) :
                (_strokeCanvas = canvasMgrHelper.creatStrokeCanvas(_strokeCanvas),
                    Dom._canvasContainer.append(_strokeCanvas), _strokeContext = _strokeCanvas[0].getContext("2d"));
        };

        /**
         * 绑定绘制笔迹的事件
         */
        function _bindCommands() {

            //写的时候，记录手势
            //擦的时候，将修正手势的操作放至wbitem中
            _strokeCanvasDom = _strokeCanvas[0];

            _strokeCanvas.off();
            _strokeCanvasDom.removeEventListener('touchstart', touchstartHanlder, false);
            _strokeCanvasDom.removeEventListener('touchmove', touchmoveHandler, false);
            _strokeCanvasDom.removeEventListener('touchend', touchendHandler, false);


            _strokeCanvasDom.addEventListener('touchstart', touchstartHanlder, false);
            _strokeCanvasDom.addEventListener('touchmove', touchmoveHandler, false);
            _strokeCanvasDom.addEventListener('touchend', touchendHandler, false);

            _strokeCanvas.on("mousedown",mousedownHandler);
            _strokeCanvas.on("mousemove",mousemoveHandler);
            _strokeCanvas.on("mouseup",mouseupHandler);
            //注意这里由mouseout改成mouseleave，注意两者的区别 liwang5 20160123
            _strokeCanvas.on("mouseleave",mouseleaveHandler);



        }

        /**
         * 区域擦除、荧光笔时，显示上层的tempCanvas
         */
        function _showTempCanvas(tempTool) {
            _createCanvas();
            //创建tempCanvas
            _tempCanvas ? (_tempCanvas.show()) :
                ( _tempCanvas = canvasMgrHelper.creatTempCanvas(_tempCanvas, _strokeCanvas),
                    Dom._canvasContainer.append(_tempCanvas), _tempContext = _tempCanvas[0].getContext("2d"));

            _tempCanvasDom = _tempCanvas[0];

            _tempCanvas.off();
           // _tempCanvasDom.removeEventListener('touchstart', areaEra_touchstartHanlder, false);
           // _tempCanvasDom.removeEventListener('touchmove', areaEra_touchmoveHandler, false);
            //_tempCanvasDom.removeEventListener('touchend', areaEra_touchendHandler, false);

            _tempCanvasDom.removeEventListener('touchstart', transPen_touchstartHanlder, false);
            _tempCanvasDom.removeEventListener('touchmove', transPen_touchmoveHandler, false);
            _tempCanvasDom.removeEventListener('touchend', transPen_touchendHandler, false);


            isTouching_tmp = false;
            _isPainting = false;
            if (tempTool === bbhelper.ToolType.AreaEraser) {
                _tempCanvas.css("cursor", bbhelper.cursor.areaEraCursor);
                _tempContext.strokeStyle = "blue";
                _tempContext.lineWidth = 1;
                //绑定事件 多次绑定会照成变量混乱
                //_tempCanvasDom.addEventListener('touchstart', areaEra_touchstartHanlder, false);
                //_tempCanvasDom.addEventListener('touchmove', areaEra_touchmoveHandler, false);
                //_tempCanvasDom.addEventListener('touchend', areaEra_touchendHandler, false);

                _tempCanvas.on("mousedown",areaEra_mousedownHandler);
                _tempCanvas.on("mousemove",areaEra_mousemoveHandler);
                _tempCanvas.on("mouseup",areaEra_mouseupHandler);
                _tempCanvas.on("mouseout",areaEra_mouseoutHandler);
            }
            if (tempTool === TempToolType.TransPenYellow
                || tempTool === TempToolType.TransPenRed
                || tempTool === TempToolType.TransPenBlue) {
                _curOtherPen = tempTool;
                _tempContext.lineWidth = 20, _tempContext.lineCap = "round", _tempContext.lineJoin = "round";
                if (tempTool === TempToolType.TransPenYellow) {
                    _tempContext.strokeStyle = _tempContext.fillStyle = "rgba(255,255,0,0.5)";
                } else if (tempTool === TempToolType.TransPenRed) {
                    _tempContext.strokeStyle = _tempContext.fillStyle = "rgba(255,0,0,0.5)";
                } else if (tempTool === TempToolType.TransPenBlue) {
                    _tempContext.strokeStyle = _tempContext.fillStyle = "rgba(0,0,255,0.5)";
                }

                _tempCanvasDom.addEventListener('touchstart', transPen_touchstartHanlder, false);
                _tempCanvasDom.addEventListener('touchmove', transPen_touchmoveHandler, false);
                _tempCanvasDom.addEventListener('touchend', transPen_touchendHandler, false);

                _tempCanvas.on("mousedown",transPen_mousedownHandler);
                _tempCanvas.on("mousemove",transPen_mousemoveHandler);
                _tempCanvas.on("mouseup",transPen_mouseupHandler);
                _tempCanvas.on("mouseout",transPen_mouseoutHandler);
            }
        }

        /**
         * 初始化页面时隐藏一些控件，例如板擦控件、颜色选择器、其他笔
         */
        function _hidePopControls() {
            //隐藏课本目录
            $("#directory_box_left").css("display", "none");
            $("#directory_box_right").css("display", "none");
            $("#localResId").hide();
            $("#localResNoneId").hide();
            //隐藏资源荐下拉框
            $(".J_recommend_submenu").hide();
        }

        /**
         * 隐藏上层tempCanvas
         */
        function _hideTempCanvas() {
            _tempCanvas && _tempCanvas.hide();
        }

        /**
         * 清空canvas
         * @private from
         * 这里加个参数是表明是否来自于全部擦除功能，如果是的话，初始化canvas，则可擦除区域还没有显示，这时候用bookContainer的区域，
         * 理论上说这个东西应该是属于板擦的一部分，这样做就不回有问题，
         * but,你懂的，业务复杂的一比，以本人的能力将要hold不住啦(总不能每次都重构吧，或者搞个全局变量) updated by linwang5 2015-01-20
         */
        function _clearCanvas(from) {

            _strokeCanvas ? (console.log('nothing,you do not want to see')) :
                (_strokeCanvas = canvasMgrHelper.creatStrokeCanvas(_strokeCanvas),
                    Dom._canvasContainer.append(_strokeCanvas), _strokeContext = _strokeCanvas[0].getContext("2d"));

            var clearAreaChoice = (from=='clearAllWBEraserFile')?$('#bookContainer'):_strokeCanvas;

            _strokeContext.clearRect(0, 0, clearAreaChoice.width(), clearAreaChoice.height());
            $(_self).trigger('doEraser',[0, 0, clearAreaChoice.width(), clearAreaChoice.height()]);

        }

        /**
         * 将_strokeCanvas内容绘制到底层
         */
        function _drawStrokeCanvasToBookContainer() {
            (_strokeCanvas) && (_hideTempCanvas(), $(_self).trigger('strokeChanged',[_strokeCanvas[0],_isStrokeChanged,strokes]),strokes = []);
        }

        /**
         * 将底层的canvas笔迹恢复到全局_strokeCanvas
         */
        function _restoreStrokeFromBookContainer() {
            if (_strokeCanvas) {
                _strokeContext.globalCompositeOperation = "source-over";
                $(_self).trigger('restoreStroke');
                _strokeCanvas.show();
                //解决bug：单双页切换后事件消失
                _bindCommands();
                //如果是区域擦除、荧光笔选中，则还显示tempCanvas
                if (Dom.tool_qycc.attr("class") === "party_current") {
                    (Dom.btnPen.attr("class") != "tool_current") && _showTempCanvas(bbhelper.ToolType.AreaEraser);
                }
            }
        }

        /**
         * 删除上方和左右两侧所有按钮的选中状态
         */
        function _removeToolBarSlectedStyles() {
            Dom.mainToolBar.children().children(".tool_current").attr("class", "tool_normal");
            Dom.rightToolbar.children().children(".sidertool_current").attr("class", "sidertool_normal");
            Dom.leftToolbar.children().children(".sidertool_current").attr("class", "sidertool_normal");
        };

        /**
         * 去除所有画笔颜色、粗细的选中状态
         */
        function _removePenSlectedStyles() {
            Dom._penColors.attr("class", "normal"), Dom._penSizes.attr("class", "normal");
            Dom.otherPenControl.children(".current").attr("class", "normal");
        };

        /**
         * 去除所有板擦颜色、粗细的选中状态
         */
        function _removeEraserSlectedStyles() {
            Dom.eraserControl.find("dd").attr("class", "party_normal");
        };

        /**
         * 给页面元素绑定点击事件
         */
        function _bindClickEventsToMainUI() {

            $("#zwsb").unbind().click(function () {
//                _drawStrokeCanvasToBookContainer();
//                $(_self).trigger('recognition',[bbhelper.LanguageType.Chinese]);

                if(AppCfg.isBBT){
                    ibWSLogic.setDongleAction(ibWSLogic.DONGLE_ACTION.RECOGNISE);
                    ibWSLogic.setRecogniseObj(_self,bbhelper.LanguageType.Chinese);
                    var json = {
                        to     : "tray",
                        action : "watchdog_exist"
                    };
                    socket.send(json);

                }else{
                    _self.recognitionEvent(bbhelper.LanguageType.Chinese);
                }
            });

            $("#ywsb").unbind().click(function () {
//                _drawStrokeCanvasToBookContainer();
//                $(_self).trigger('recognition',[bbhelper.LanguageType.English]);

                if(AppCfg.isBBT){
                    ibWSLogic.setDongleAction(ibWSLogic.DONGLE_ACTION.RECOGNISE);
                    ibWSLogic.setRecogniseObj(_self,bbhelper.LanguageType.English);
                    var json = {
                        to     : "tray",
                        action : "watchdog_exist"
                    };
                    socket.send(json);

                }else{
                    _self.recognitionEvent(bbhelper.LanguageType.English);
                }


//                (!StrokeResult.ready ) && StrokeResult.init();
//                _drawStrokeCanvasToBookContainer();
//                StrokeResult.showResult(bbhelper.LanguageType.English, strokes);
            });

//            function recognitionEvent(type){
//                _drawStrokeCanvasToBookContainer();
//                $(_self).trigger('recognition',[type]);
//            }

            //全局鼠标
            Dom.btnMouse.click(function () {
                //画笔、板擦都设置为未选中样式，鼠标设置为选中样式
                $("#btnPen").removeClass("tool_current");
                $("#penMenuBtn").removeClass("tool_current");
                $("#btnEraser").removeClass("tool_current");
                $("#eraserMenuBtn").removeClass("tool_current");

                //屏蔽画笔、板擦控制板
                $("#penEraserTool").hide();
                global_user_clicks.push('mouse');
                _removePenSlectedStyles();
                _removeEraserSlectedStyles();
                _changeToMode(bbhelper.ToolType.Mouse);
                _drawStrokeCanvasToBookContainer();
                //切换到鼠标状态后设为false，则在翻页等操作时就不用再保存笔迹到pageItem上了
                _isStrokeChanged = false;
                (_strokeCanvas) && (_strokeCanvas.hide());

                Dom._r_erase.hide();
                Dom._r_PenControlPanel.hide();

                //监管
//                var action = LogManager.action.trigger;
//                var params = {};
//                params.module = '1130405';
//                var user_id = ebContext.getUser().getUid();
//                if(user_id != '0' && user_id){
//                    params.user_id =user_id;
//                }
//                LogManager.statistics(action,params);
            });

            //全局画笔
            Dom.btnPen.click(function (event) {
                var isFromMouse = (Dom.btnMouse.hasClass("tool_current"));
                //鼠标、板擦都设置为未选中样式，画笔设置为选中样式
                $("#btnMouse").removeClass("tool_current");
                $("#penMenuBtn").removeClass("tool_current");
                $("#btnEraser").removeClass("tool_current");
                $("#eraserMenuBtn").removeClass("tool_current");
                //_removePenSlectedStyles();
                Dom._Pen.children(".current").attr("class", "normal");
                if (!_isEditing) {
                    //加载这里两行是为了每次选中板擦的时候都重载全局画布，原有的逻辑是trigger鼠标，产品有新的需求，请恕我短期内无法重构这代码 by linwang5 --2015-12-28
                    //_drawStrokeCanvasToBookContainer();
                    //_restoreStrokeFromBookContainer();
                    global_user_clicks.push('pen');
                    $('.notes_box').hide();
                    //如果已经存在板擦工具栏，隐藏工具栏，此代码配合底部工具栏功能
                    if(Dom._erase[0].style.display!="none"){
                        _changeToMode(bbhelper.ToolType.Pen);
                        //隐藏鼠标工具栏
                        Dom._penEraserTool.hide();
                        //下面两行默认选中红色按钮
                    }else{
                        _changeToMode(bbhelper.ToolType.Pen);
                    }

                    //$(this).popover('show', 'title', {position: app_global_isMainToolBarUp ? 'bottom' : 'top'});
                    //从鼠标切换过来时才恢复笔迹
                    (isFromMouse) &&  _restoreStrokeFromBookContainer();
                    event.stopPropagation();


                    if(_lastSelected.otherPenEle && _lastSelected.otherPenEle[0]){
                        if(_lastSelected.otherPenEle[0].id == 'tool_flupen'){
                            var nowFluPen = Dom.tool_flupen ;
                            var colorstr = "transPenYellow";
                            var herethis = Dom.tool_flupen;
                            var toolType = bbhelper.ToolType.TransPenYellow;
                        }
                        else if(_lastSelected.otherPenEle[0].id == 'tool_flugred'){
                            var nowFluPen = Dom.tool_flugred ;
                            var colorstr = "transPenRed";
                            var herethis = Dom.tool_flugred;
                            var toolType = bbhelper.ToolType.TransPenRed;
                        }
                        else if(_lastSelected.otherPenEle[0].id == 'tool_flugblue'){
                            var nowFluPen = Dom.tool_flugblue ;
                            var colorstr = "transPenBlue";
                            var herethis = Dom.tool_flugblue;
                            var toolType = bbhelper.ToolType.TransPenBlue;
                        }

                        Dom._penColors.attr("class", "normal"), Dom._penSizes.attr("class", "normal");
                        Dom._Pen.children(".current").attr("class", "normal");
                        nowFluPen.attr("class", "current");
                        _showTempCanvas(colorstr);
                        _curOtherPen = colorstr;
                        _lastSelected.otherPenEle = herethis;
                        _lastSelected.otherPenValue = colorstr;
                        _lastSelected.curToolType = toolType;
                        _tempCanvas.css("cursor", bbhelper.cursor.penCursor);
                    }
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
                //画笔主按钮设置为选中
                $("#btnPen").attr("class","tool_current tool_normal");
            });

            //底部画笔菜单
            Dom._penMenuBtn.click(function(){
                Dom.btnPen.click();
                //暂时屏蔽
                //$(".jxbubble-box").hide();
                //板擦、鼠标都设置为未选中样式，板擦侧边按钮设置为选中样式
                $("#btnMouse").removeClass("tool_current");
                $("#btnPen").removeClass("tool_current");
                $("#eraserMenuBtn").removeClass("tool_current");
                $("#btnEraser").removeClass("tool_current");
                $("#penMenuBtn").addClass("tool_current");
                //设置画笔菜单位置
                xpos = $(this).offset().left;
                var exportPanel =Dom._penEraserTool;
                exportPanel.css({  //设置位置
                    position: 'absolute',
                    left: xpos-150+8,
                    bottom: 58+5+5
                }).draggable({               //设置可拖动
                    containment: "body",
                    handle: ".pop_top"
                });

                if($("#penEraserTool")[0].style.display=="none"||Dom._erase[0].style.display!="none"){
                    Dom._penEraserTool.show();
                    Dom._PenControlPanel.show();
                    Dom._erase.hide();
                }else{
                    $("#penEraserTool").hide();
                }

            });

            //全局板擦
            Dom.btnEraser.click(function () {
                var isFromMouse = (Dom.btnMouse.hasClass("tool_current"));
                //鼠标、画笔都设置为未选中样式，板擦侧边按钮设置为选中样式
                $("#btnMouse").removeClass("tool_current");
                $("#btnPen").removeClass("tool_current");
                $("#penMenuBtn").removeClass("tool_current");
                $("#eraserMenuBtn").removeClass("tool_current");

                //temp eshop监管 linwang5@iflytek.com
                var staticParams = {
                    uid:ebContext._curUser._uid,
                    module:'03011',
                    type:'trigger',
                    havingClass:_isHavingClass?1:0
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);

                //Dom._penEraserTool.hide();
                if (!_isEditing) {
                    //加载这里两行是为了每次选中板擦的时候都重载全局画布，原有的逻辑是trigger鼠标，产品有新的需求，请恕我短期内无法重构这代码 by linwang5 --2015-12-28
                    //_drawStrokeCanvasToBookContainer();
                    //_restoreStrokeFromBookContainer();
                    global_user_clicks.push('eraser');
                    (!_lastSelected.eraserType) ?
                        (_lastSelected.eraserType = bbhelper.ToolType.NormalEraser, _lastSelected.curToolType = bbhelper.ToolType.NormalEraser) :
                        ( _lastSelected.curToolType = _lastSelected.eraserType);

                    //  yczhu  add    2014年10月23日17:22:24
                    _lastSelected.eraserType == bbhelper.ToolType.SmallEraser && _setCursor(bbhelper.cursor.minEraCursor);
                    _lastSelected.eraserType == bbhelper.ToolType.NormalEraser && _setCursor(bbhelper.cursor.midEraCursor);
                    _lastSelected.eraserType == bbhelper.ToolType.BigEraser && _setCursor(bbhelper.cursor.bigEraCursor);

                    //如果已经存在板擦工具栏，隐藏工具栏，此代码配合底部工具栏功能
                    if(Dom._PenControlPanel[0].style.display!="none"){
                        _changeToMode(bbhelper.ToolType.Eraser);
                        //隐藏鼠标工具栏
                        Dom._penEraserTool.hide();
                        //下面两行默认选中红色按钮
                    }else{
                        _changeToMode(bbhelper.ToolType.Eraser);
                    }

                    //当鼠标处于选中状态时，直接点击板擦按钮，需要从页面上恢复笔迹给全局Canvas
                    isFromMouse && _restoreStrokeFromBookContainer();
                    //这一步是为了将全局画布转到板擦状态
                    _changeToMode(bbhelper.ToolType.Eraser);
                    //修复荧光笔直接到板擦的bug
                    (_tempCanvas && _tempCanvas.css("display") == "block") && _tempCanvas.hide();
                    //如果是区域擦除选中，则还显示tempCanvas.
                    (_lastSelected.eraserType === bbhelper.ToolType.AreaEraser) && (Dom.btnPen.attr("class") != "tool_current") && _showTempCanvas(bbhelper.ToolType.AreaEraser);

                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }

                //监管
                var action = LogManager.action.trigger;
                var params = {};
                params.module = '1130407';
                var user_id = ebContext.getUser().getUid();
                if(user_id != '0' && user_id){
                    params.user_id =user_id;
                }
                //设置板擦按钮样式
                $("#btnEraser").attr("class","tool_current tool_normal");
                LogManager.statistics(action,params);
            });

            //底部板擦菜单
            Dom._eraserMenuBtn.click(function(){
                Dom.btnEraser.click();
                //暂时屏蔽
                //$(".jxbubble-box").hide();
                //画笔、鼠标都设置为未选中样式，板擦侧边按钮设置为选中样式
                $("#btnMouse").removeClass("tool_current");
                $("#btnPen").removeClass("tool_current");
                $("#penMenuBtn").removeClass("tool_current");
                $("#btnEraser").removeClass("tool_current");
                $("#eraserMenuBtn").addClass("tool_current");

                //设置板擦菜单位置
                var position,xPos,yPos;
                xpos = $(this).offset().left;
               // ypos = $(this).offset().top - $(this).width() - $("#header").height();
                var exportPanel =Dom._penEraserTool;
                exportPanel.css({  //设置位置
                    position: 'absolute',
                    left: xpos-113+8,
                    bottom:58+5+5
                }).draggable({               //设置可拖动
                    containment: "body",
                    handle: ".pop_top"
                });

                if($("#penEraserTool")[0].style.display=="none"||Dom._PenControlPanel[0].style.display!="none"){
                    Dom._penEraserTool.show();
                    Dom.penControl.hide();
                    Dom._erase.show();
                }else{
                    $("#penEraserTool").hide();
                }
            })


            //绑定顶部画笔颜色点击事件
            Dom._penColors.click(function (event) {
                _lastSelected.otherPenEle = null;
                if (!_isEditing) {
                    //如果当前为鼠标状态，需要先切换到画笔状态，相当于先点击了画笔按钮
                    //Dom.btnPen.triggerHandler('click');
                    //if(Dom.penControl.attr('isRight') == 'true'){
                    //    Dom.btnRightPen.click();
                    //}else{
                        Dom.btnPen.click();
                    //}
                    Dom._nitePen.children(".current").attr("class", "normal");
                    Dom._penColors.attr("class", "normal");
                    Dom.r_penClr_black.attr("class",'normal');
                    Dom.r_penClr_red.attr("class",'normal');
                    Dom.r_penClr_blue.attr("class",'normal');
                    Dom._Pen.children(".current").attr("class", "normal");
                    var _herethis = $(this);
                    _herethis.attr("class", "current");
                    var penColor = _herethis.attr('color');
                    if(penColor == "000000"){
                        Dom.r_penClr_black.attr("class",'current');
                        $('#penClr_black').attr("class", "current");
                    }
                    if(penColor == "FF0000"){
                        Dom.r_penClr_red.attr("class",'current');
                        $('#penClr_red').attr("class", "current");
                    }
                    if(penColor == "0000FF"){
                        Dom.r_penClr_blue.attr("class",'current');
                        $('#penClr_blue').attr("class", "current");
                    }
                    if(penColor!="000000"&&penColor!="FF0000"&&penColor!="0000FF"){
                        Dom._colorBoxImg.attr("class",'current');
                    }
                    _lastSelected.penColorEle = _herethis;
                    if (typeof(penColor) != "undefined"){
                        _setColor(penColor);
                        _lastSelected.penColorValue = penColor;
                    }
                    _lastSelected.curToolType = bbhelper.ToolType.Pen;


                    event.stopPropagation();
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
            });

            Dom.r_penClr_black.click(function (event) {
                var obj = $(this);
                R_penColorSelect(event,obj);
            });
            Dom.r_penClr_red.click(function (event) {
                var obj = $(this);
                R_penColorSelect(event,obj);
            });
            Dom.r_penClr_blue.click(function (event) {
                var obj = $(this);
                R_penColorSelect(event,obj);
            });

            function R_penColorSelect(event,obj){
                _lastSelected.otherPenEle = null;
                if (!_isEditing) {
                    //如果当前为鼠标状态，需要先切换到画笔状态，相当于先点击了画笔按钮
                    //Dom.btnPen.triggerHandler('click');
                    //if(Dom.penControl.attr('isRight') == 'true'){
                    //    Dom.btnRightPen.click();
                    //}else{
                        Dom.btnPen.click();
                    //}

                    Dom._penColors.attr("class", "normal");
                    Dom.r_penClr_black.attr("class",'normal');
                    Dom.r_penClr_red.attr("class",'normal');
                    Dom.r_penClr_blue.attr("class",'normal');
                    Dom._Pen.children(".current").attr("class", "normal");
                    var _herethis = obj;
                    _herethis.attr("class",'current');
                    var penColor = _herethis.attr('color');
                    if(penColor == "000000"){
                       $('#penClr_black').attr("class", "current");
                        _lastSelected.penColorEle = $('#penClr_black')
                    }
                    if(penColor == "FF0000"){
                        $('#penClr_red').attr("class", "current");
                        _lastSelected.penColorEle = $('#penClr_red');
                    }
                    if(penColor == "0000FF"){
                        $('#penClr_blue').attr("class", "current");
                        _lastSelected.penColorEle = $('#penClr_blue');
                    }
                    _setColor(penColor);
                    _lastSelected.penColorValue = penColor;
                    _lastSelected.curToolType = bbhelper.ToolType.Pen;


                    event.stopPropagation();
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
            }

            //颜色选择器图标
            Dom._colorBoxImg.click(function (event) {
                if (!_isEditing) {
                    _hidePopControls();
                    var $this = $(this);
                    $this.popover("fadeOutAll");
                    (!$this.popover('isShow', 'title')) ?
                        ( $this.popover('show', 'title', {position: app_global_isMainToolBarUp ? 'bottom' : 'top'})) :
                        ($this.popover('hide', 'title'));
                    Dom._colorBox.parent().css("z-index", 110);
                    //TODO 这是临时的显示出来颜色选择器
                    Dom._colorBox.parent().css("left",$(this).offset().left-40);
                    var top=$(this).offset().top-$(this).parent().parent().height()-Dom._colorBox.height()+30;

                    Dom._colorBox.parent().css("top",top);
                    event.stopPropagation();
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
            });


            //关闭颜色选择器
            Dom._colorBox.find("#close_box").click(function () {
                Dom._colorBoxImg.popover('hide');
                event.stopPropagation();
            });

            //绑定画笔粗细
            Dom._penSizes.click(function (event) {
                _lastSelected.otherPenEle = null;

                if (!_isEditing) {
                    //如果当前为鼠标状态，需要先切换到画笔状态，相当于先点击了画笔按钮
                    //if(Dom.penControl.attr('isRight') == 'true'){
                    //    Dom.btnRightPen.click();
                    //}else{
                    Dom._nitePen.children(".current").attr("class", "normal");
                        Dom.btnPen.click();
                    //}

                    Dom._penSizes.attr("class", "normal");
                    $('#r_tool_dl2').attr("class", 'normal');
                    $('#r_tool_dl3').attr("class", 'normal');
                    $('#r_tool_dl4').attr("class", 'normal');
                    var herethis = $(this);
                    herethis.attr("class", "current");
                    var penSize = herethis.attr("size");
                    if(penSize == 4){
                        $('#r_tool_dl2').attr("class", 'current');
                    }
                    if(penSize == 6){
                        $('#r_tool_dl3').attr("class", 'current');
                    }
                    if(penSize == 8){
                        $('#r_tool_dl4').attr("class", 'current');
                    }
                    _setSize(bbhelper.ToolType.Pen,penSize);
                    _lastSelected.penSizeEle = herethis;
                    _lastSelected.penSizeValue = penSize;


                    event.stopPropagation();
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
            });

            Dom.r_tool_dl2.click(function (event) {
                var obj = $(this);
                R_penSizeSelect(event,obj);
            });
            Dom.r_tool_dl3.click(function (event) {
                var obj = $(this);
                R_penSizeSelect(event,obj);
            });
            Dom.r_tool_dl4.click(function (event) {
                var obj = $(this);
                R_penSizeSelect(event,obj);
            });

            function R_penSizeSelect(event,obj){

                _lastSelected.otherPenEle = null;

                if (!_isEditing) {
                    //如果当前为鼠标状态，需要先切换到画笔状态，相当于先点击了画笔按钮
                    //if(Dom.penControl.attr('isRight') == 'true'){
                    //    Dom.btnRightPen.click();
                    //}else{
                        Dom.btnPen.click();
                    //}

                    Dom._penSizes.attr("class", "normal");
                    Dom.r_tool_dl2.attr("class", 'normal');
                    Dom.r_tool_dl3.attr("class", 'normal');
                    Dom.r_tool_dl4.attr("class", 'normal');
                    var herethis = obj;
                    herethis.attr("class", 'current');
                    var penSize = herethis.attr("size");
                    if(penSize == 4){
                        $('#tool_dl2').attr("class", "current");
                        _lastSelected.penSizeEle = $('#tool_dl2');
                    }
                    if(penSize == 6){
                        $('#tool_dl3').attr("class", "current");
                        _lastSelected.penSizeEle = $('#tool_dl3');
                    }
                    if(penSize == 8){
                        $('#tool_dl4').attr("class", "current");
                        _lastSelected.penSizeEle = $('#tool_dl4');
                    }
                    _setSize(bbhelper.ToolType.Pen,penSize);
                    _lastSelected.penSizeValue = penSize;


                    event.stopPropagation();
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
            }


            //绑定板擦粗细
            Dom.tool_small.click(function (event) {
                if (!_isEditing) {
                    eraserClickHelper(bbhelper.ToolType.SmallEraser, Dom.tool_small,
                        bbhelper.cursor.minEraCursor, $(this), bbhelper.EraserSize.Small);
                    Dom.r_tool_mid.attr("class", "party_normal");
                    Dom.r_tool_qbcc.attr("class", "party_normal");
                    Dom.r_tool_qycc.attr("class", "party_normal");
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
                event.stopPropagation();
            });
            Dom.tool_mid.click(function (event) {
                if (!_isEditing) {
                    eraserClickHelper(bbhelper.ToolType.NormalEraser, Dom.tool_mid,
                        bbhelper.cursor.midEraCursor, $(this), bbhelper.EraserSize.Normal);
                    Dom.r_tool_qbcc.attr("class", "party_normal");
                    Dom.r_tool_qycc.attr("class", "party_normal");
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
                event.stopPropagation();
            });
            //右侧中型擦除
            Dom.r_tool_mid.click(function (event) {
                if (!_isEditing) {
                    eraserClickHelper(bbhelper.ToolType.NormalEraser, Dom.r_tool_mid,
                        bbhelper.cursor.midEraCursor, $(this), bbhelper.EraserSize.Normal);
                    Dom.r_tool_qbcc.attr("class", "party_normal");
                    Dom.r_tool_qycc.attr("class", "party_normal");
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
                event.stopPropagation();
            });

            Dom.tool_big.click(function (event) {
                if (!_isEditing) {
                    eraserClickHelper(bbhelper.ToolType.BigEraser, Dom.tool_big,
                        bbhelper.cursor.bigEraCursor, $(this), bbhelper.EraserSize.Big);
                    Dom.r_tool_mid.attr("class", "party_normal");
                    Dom.r_tool_qbcc.attr("class", "party_normal");
                    Dom.r_tool_qycc.attr("class", "party_normal");
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
                event.stopPropagation();
            });

            //右侧区域擦除
            Dom.r_tool_qycc.click(function (event) {
                eraserCleanArea(event);
            });
            //顶部区域擦除
            Dom.tool_qycc.click(function (event) {
                eraserCleanArea(event);
            });

            //右侧全部擦除
            Dom.r_tool_qbcc.click(function (e) {
                eraserCleanAll();
                e.preventDefault();
                e.stopPropagation();
            });
            //顶部全部擦除
            Dom.tool_qbcc.click(function (e) {
                eraserCleanAll();
                e.preventDefault();
                e.stopPropagation();
            });
            //擦出所有黑板的内容
            Dom.tool_ClearAllWBEraser.click(function(e){
                //给出提示框
                if(!_isEditing){
                    $.Zebra_Dialog(AppBlackBoardTipsList.ClearAllWBContent, {
                        'type': 'question',
                        'title': AppTips.WarmTips,
                        'buttons': [AppTips.CancelTips, AppTips.OkTips],
                        'onClose': function (capition) {
                            if (capition == AppTips.OkTips){

                                //删除当前放入此黑板的图片  created by linwang5 20160108
                                var widgets = curtainmgr._bookContainer.getCurrentBookView().getShowPageItem()[0].widgets;
                                for(var j in widgets){
                                    widgets[j].destroy();
                                }
                                //删除完成后记得讲内存中的数据清零，否则翻页的时候会报错 created by linwang5 20160108
                                curtainmgr._bookContainer.getCurrentBookView().getShowPageItem()[0].widgets = [];
                                clearAllWBEraserFile();
                                eraserCleanAll('clearAllWBEraserFile');
                                //清除所有的图片

                                event.stopPropagation();

                            }
                            /**
                             * 顺便啰嗦一句，这里做和canvas业务的不相关东西应该是很不适合的，
                             * 不知道为何要明明删除的是笔迹，却要把图片删除掉，也难怪，
                             * 产品换的次数太频繁了，本人对这块复杂的业务想要重新梳理估计要很长时间，
                             * 好吧，我承认我不想重构，god bless . 下个改这块代码的人，祝你好运。
                             * created by linwang5 2015 - 01 -08
                             */
                        }
                    });
                    //擦除当前界面的笔迹
                    e.preventDefault();
                    e.stopPropagation();
                }else{
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }

            });
            //清除所有的板擦文件
            function clearAllWBEraserFile(){
               var wbPath = ebContext._binPath+'users/'+ebContext._curUser._name+'/wboard/';
               var shellcmd = require("../../common/shellcmd");
               for(var k = 1;k<=20;k++){
                   var numStr = k.toString();
                   var tempPath = wbPath+ numStr;
                  shellcmd._rmdirASync(tempPath.replace(/\bfile:(\/+)/g, ""));
               }
            }
            //区域擦除
            function eraserCleanArea(event){
                if(!_isEditing){
                    //模拟点击一次板擦按钮

                    Dom._erase.hide();
                    if(Dom._erase.attr('isRight') == 'true'){
                        Dom.btnRightEraser.click();
                    }else{
                        Dom.btnEraser.click();
                    }
                    _removeEraserSlectedStyles();
                    Dom.r_tool_mid.attr("class", "party_normal");
                    Dom.r_tool_qbcc.attr("class", "party_normal");
                    Dom.r_tool_qycc.attr("class", "party_current");
                    Dom.tool_qycc.attr("class", "party_current");
                    _showTempCanvas(bbhelper.ToolType.AreaEraser);
                    _tempCanvas.css("cursor", bbhelper.cursor.areaEraCursor);
                    _lastSelected.eraserTypeEle = Dom.tool_qycc;
                    _lastSelected.eraserTypeValue = bbhelper.ToolType.AreaEraser;
                    _lastSelected.curToolType = bbhelper.ToolType.AreaEraser;
                    _lastSelected.eraserType = bbhelper.ToolType.AreaEraser;
                    event.stopPropagation();
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
            }
            //全部擦除
            function eraserCleanAll(from){
                if (!_isEditing) {
                    _clearCanvas(from);
                    _setCursor(_curCursor);
                    _isStrokeChanged = true;
                    strokes = [];
                    while(global_user_clicks.length > 0 ){
                        var lastClick = global_user_clicks.pop();
                        if((lastClick != 'eraser') && (lastClick != 'r_eraser')){
                            break;
                        }
                    }
                    // 修复回到水表状态BUG
                    if(lastClick == 'eraser'){
                        lastClick = 'mouse';
                    }
                    if(lastClick == 'pen' || lastClick == 'eraser' || lastClick == 'r_eraser'){
                        //Dom._PenControlPanel.show();
                        //Dom._erase.hide();
                        //Dom._r_PenControlPanel.hide();
                        //Dom._r_erase.hide();
                        Dom.btnPen.click();
                    }else if(lastClick == 'r_pen'){
                        Dom._r_PenControlPanel.hide();
                        Dom._r_erase.hide();
                        Dom.btnPen.click();
                    }else if(lastClick == 'mouse'){
                        Dom._r_erase.hide();
                        Dom.btnMouse.click();
                    }
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
            }
            //给其他笔绑定点击事件
            Dom._toolQtb.click(function () {
                if (!_isEditing) {
                    //如果当前为鼠标状态，需要先切换到画笔状态，相当于先点击了画笔按钮
                    //if(Dom.penControl.attr('isRight') == 'true'){
                    //    Dom.btnRightPen.click();
                    //}else{
                        Dom.btnPen.click();
                    //}
                    _hidePopControls();
                    $(this).popover('show', 'title', {position: app_global_isMainToolBarUp ? 'bottom' : 'top'});
                    //Dom._otherPenControl.parent().css("z-index", 11);
                    //Dom._otherPenControl.find(app_global_isMainToolBarUp ? ".bot_arrow" : ".top_arrow").hide().siblings().show();
                    _showTempCanvas(_curOtherPen);
                    _tempCanvas.css("cursor", bbhelper.cursor.penCursor);
                    if (_curOtherPen === TempToolType.TransPenYellow) {
                        QTBClickHelper(Dom.tool_flupen, TempToolType.TransPenYellow);
                    } else if (_curOtherPen === TempToolType.TransPenRed) {
                        QTBClickHelper(Dom.tool_flugred, TempToolType.TransPenRed);
                    } else if (_curOtherPen === TempToolType.TransPenBlue) {
                        QTBClickHelper(Dom.tool_flugblue, TempToolType.TransPenBlue);
                    }
                    event.stopPropagation();
                }
            });

            Dom.tool_flupen.click(function () {
                if (!_isEditing) {
                    fiuPenClickHelper(Dom.tool_flupen, "transPenYellow", $(this), bbhelper.ToolType.TransPenYellow);
                }
                event.stopPropagation();
            });
            Dom.tool_flugred.click(function () {
                if (!_isEditing) {
                    fiuPenClickHelper(Dom.tool_flugred, "transPenRed", $(this), bbhelper.ToolType.TransPenRed);
                }
                event.stopPropagation();
            });
            Dom.tool_flugblue.click(function () {
                if (!_isEditing) {
                    fiuPenClickHelper(Dom.tool_flugblue, "transPenBlue", $(this), bbhelper.ToolType.TransPenBlue);
                }
                event.stopPropagation();
            });

        }

        function eraserClickHelper(tooltype, domeraser, curstr, herethis, erasersize) {
            _lastSelected.eraserType = tooltype;
            _self.setZoomedEraserSize(_zoomRate);
            //模拟点击一次板擦按钮
            Dom._erase.hide();
            if(Dom._erase.attr('isRight') == 'true'){
                Dom.btnRightEraser.click();
            }else{
                Dom.btnEraser.click();
            }
            _removeEraserSlectedStyles();
            domeraser.attr("class", "party_current");
            if(Dom.r_tool_mid == domeraser || Dom.tool_mid == domeraser){
                Dom.r_tool_mid.attr("class", "party_current");
                Dom.tool_mid.attr("class", "party_current");
            }
            _hideTempCanvas();
            _setCursor(curstr);
            _lastSelected.eraserTypeEle = herethis;
            _lastSelected.eraserTypeValue = erasersize;
            _lastSelected.curToolType = tooltype;

        }

        function QTBClickHelper(pen, color) {
            Dom.children().children(".current").attr("class", "normal");
            pen.attr("class", "current");
            _lastSelected.curToolType = color;
        }

        function fiuPenClickHelper(nowFluPen, colorstr, herethis, toolType) {
            Dom._penColors.attr("class", "normal"), Dom._penSizes.attr("class", "normal");
            Dom._nitePen.children(".current").attr("class", "normal");
            nowFluPen.attr("class", "current");
            _showTempCanvas(colorstr);
            _curOtherPen = colorstr;
            _lastSelected.otherPenEle = herethis;
            _lastSelected.otherPenValue = colorstr;
            _lastSelected.curToolType = toolType;
            _tempCanvas.css("cursor", bbhelper.cursor.penCursor);
            Dom.btnPen.click();
        }






        /****************************处理画笔事件***************************************************/
        var startPoint = new _model.Point(), endPoint = new _model.Point();
        var offset = $("#bookContainer").offset();
        var offsetX = offset.left;
        var offsetY = offset.top;
        var isTouching = false;
        _isPainting = false;

        function touchstartHanlder(event){
            var touch = event.touches[0];
            var startX = touch.pageX - offsetX + 4, startY = touch.pageY - offsetY + 4;
            paintBegin(startX, startY);
            isTouching = true;
        }

        function touchmoveHandler(event){
            if(_isPainting && isTouching){
                var touch = event.touches[0];
                var endX = touch.pageX - offsetX + 4;
                var endY = touch.pageY - offsetY + 4;
                paintMove(endX,endY);
            }
        }

        function touchendHandler(){
            paintEnd();
            isTouching = false;
        }

        function mousedownHandler(event){
            if(!isTouching){
                var startX = event.offsetX, startY = event.offsetY;
                if(_curTool === bbhelper.ToolType.Pen){
                    startX = startX + 4;
                    startY = startY + 4;
                }
                paintBegin(startX, startY);
            }

        }

        function mousemoveHandler(event){
            if(_isPainting && !isTouching){
                var endX = event.offsetX;
                var endY = event.offsetY;
                if(_curTool === bbhelper.ToolType.Pen){
                    endX = endX + 4;
                    endY = endY + 4;
                }
                paintMove(endX,endY);
            }
        }

        function mouseupHandler(){
            paintEnd();
            ebContext.setIsPenUse(true);//画笔拖动结束，将画笔使用状态置为true
        }

        function mouseleaveHandler(){
            paintEnd();
            // ebContext.setIsPenUse(true);
        }

        function paintBegin(startX, startY){
            _strokeContext.beginPath();
            if (_curTool === bbhelper.ToolType.Pen) {
                _hidePopControls();
                //在仅仅点击鼠标时，需要画出一个点，如果不加上这0.01个像素，则画不出来
                startPoint.x = startX, startPoint.y = startY;
                endPoint.x = startX + 0.01, endPoint.y = startY + 0.01;
                strokes.push([startPoint.x, startPoint.y]);
                //很奇怪的，这两句放在这里才会起作用，并不是多余   ----  by  yczhu
                _setSize("pen", _curPenSize);
                _setColor(_curPenColor);
                _strokeContext.moveTo(startPoint.x, startPoint.y), _strokeContext.lineTo(endPoint.x, endPoint.y);
                _strokeContext.stroke();
            } else if (_curTool === bbhelper.ToolType.Eraser) {
                startPoint.x = startX, startPoint.y = startY;
                _strokeContext.clearRect(startPoint.x, startPoint.y, _curEraserSize, _curEraserSize);
                //解决bug：翻页时为了将笔迹恢复而改成了source-over，但是板擦状态下需要改回来
                _strokeContext.globalCompositeOperation = "destination-out";
                //解决bug:单双页切换时板擦大小问题
                _setSize(bbhelper.ToolType.Eraser, _curEraserSize);
                strokes = bbhelper.clearPoints(startPoint, {width: _lastSelected.eraserTypeValue, height: _lastSelected.eraserTypeValue}, strokes);
                $(_self).trigger('doEraser',[startPoint.x, startPoint.y, _curEraserSize, _curEraserSize])
            }
            _isPainting = _isStrokeChanged = true;
        }

        function paintMove(endX,endY){
            if (_isPainting) {
                endPoint.x = endX;
                endPoint.y = endY;
                if (_curTool === bbhelper.ToolType.Pen) {
                    strokes.push([endPoint.x, endPoint.y]), _strokeContext.lineTo(endPoint.x, endPoint.y);
                    _strokeContext.stroke();
                } else if (_curTool === bbhelper.ToolType.Eraser) {
                    _strokeContext.clearRect(endPoint.x, endPoint.y, _curEraserSize, _curEraserSize);

                    //TODO : here!!!
                    strokes = bbhelper.clearPoints(endPoint, {width: _lastSelected.eraserTypeValue, height: _lastSelected.eraserTypeValue}, strokes);
                    strokes = bbhelper.removeSerialJoints(bbhelper.removeFirstJoint(strokes));
                    $(_self).trigger('doEraser',[endPoint.x, endPoint.y,_curEraserSize, _curEraserSize])
                }
            }
        }

        function paintEnd(){
            _mouseUpEventHelper();
        }

        /**
         * 辅助函数，只在这里使用。原因是_isPainting为_bindCommands函数内部有效
         */
        function _mouseUpEventHelper() {
            _isPainting = false;
            (_lastSelected.curToolType === bbhelper.ToolType.Pen) && (strokes.push([-1, -1]));
            (_lastSelected.curToolType === bbhelper.ToolType.Eraser) && (clearAreaPoints = []);

            //TODO : here!!!
            strokes = bbhelper.removeSerialJoints(bbhelper.removeFirstJoint(strokes));
        }


        /****************************处理荧光笔和区域擦除***********************************/
        var startX_tmp, startY_tmp, endX_tmp, endY_tmp;
        var offset_tmp = $("#bookContainer").offset();
        var offsetX_tmp = offset_tmp.left;
        var offsetY_tmp = offset_tmp.top;
        var isTouching_tmp = false;
        function areaEraBegin(){
            _tempContext.lineJoin = "miter";
            _tempContext.beginPath();
            _isPainting = true;
        }

        function areaEra_touchstartHanlder(event){
            var touch = event.touches[0];
            startX_tmp = touch.pageX - offsetX_tmp, startY_tmp = touch.pageY - offsetY_tmp;
            areaEraBegin();
            isTouching_tmp = true;

        }

        function areaEra_mousedownHandler(event){
            if(!isTouching_tmp){
                startX_tmp = event.offsetX, startY_tmp = event.offsetY;
                areaEraBegin();
            }

        }


        function areaEraMove(){
            _tempContext.clearRect(0, 0, _tempCanvas.width(), _tempCanvas.height());
            _tempContext.strokeRect(startX_tmp, startY_tmp, endX_tmp - startX_tmp, endY_tmp - startY_tmp);
        }

        function areaEra_touchmoveHandler(event){
            if(_isPainting && isTouching_tmp){
                var touch = event.touches[0];
                endX_tmp = touch.pageX - offsetX_tmp;
                endY_tmp = touch.pageY - offsetY_tmp;
                areaEraMove();
            }
        }

        function areaEra_mousemoveHandler(event){
            if(_isPainting && !isTouching_tmp){
                endX_tmp = event.offsetX, endY_tmp = event.offsetY;
                if (_isPainting) {
                    areaEraMove();
                }
            }
        }


        function areaEraEnd(){
            var clearAreaWidth = endX_tmp - startX_tmp, clearAreaHeight = endY_tmp - startY_tmp;
            _strokeContext.globalCompositeOperation = "destination-out";
            _strokeContext.fillRect(startX_tmp, startY_tmp, clearAreaWidth, clearAreaHeight);
            _tempContext.clearRect(0, 0, _tempCanvas.width(), _tempCanvas.height());
            _isStrokeChanged = true;

            //TODO : here!!!
            strokes = bbhelper.clearPoints({x: startX_tmp, y: startY_tmp}, {width: clearAreaWidth, height: clearAreaHeight}, strokes);
            strokes = bbhelper.removeSerialJoints(bbhelper.removeFirstJoint(strokes));
            $(_self).trigger('doEraser',[startX_tmp,startY_tmp,clearAreaWidth,clearAreaHeight]);

            _isPainting = false;

        }

        function areaEra_touchendHandler(){
            if (_isPainting && isTouching_tmp) {
                areaEraEnd();
            }
            _isPainting = false;
            isTouching_tmp = false;
        }

        function areaEra_mouseupHandler(){
            if (_isPainting && !isTouching_tmp) {
                areaEraEnd();
            }
            _isPainting = false;
        }

        function areaEra_mouseoutHandler(){
            if (_isPainting) {
                _tempContext.clearRect(0, 0, _tempCanvas.width(), _tempCanvas.height());
            }
            _isPainting = false;
        }



        var mouse = {x: 0, y: 0}, ppts = [];
        function transPenBegin(){
            _onPaint();
            _isPainting = _isStrokeChanged = true;
            strokes.push([mouse.x -1, mouse.y -1]);
        }

        function transPen_touchstartHanlder(event){
            var touch = event.touches[0];
            mouse.x = touch.pageX - offsetX_tmp, mouse.y = touch.pageY - offsetY_tmp;
            transPenBegin();
            isTouching_tmp = true;
        }

        function transPen_mousedownHandler(event){
            if(!isTouching_tmp){
                mouse.x = event.offsetX, mouse.y = event.offsetY;
                transPenBegin();
            }
        }


        function transPenMove(){
            if (_isPainting) {
                _onPaint();
                strokes.push([mouse.x, mouse.y]);
            }
        }

        function transPen_touchmoveHandler(event){
            if(_isPainting && isTouching_tmp){
                var touch = event.touches[0];
                mouse.x = touch.pageX - offsetX_tmp;
                mouse.y = touch.pageY - offsetY_tmp;
                transPenMove();
            }
        }

        function transPen_mousemoveHandler(event){
            if(_isPainting && !isTouching_tmp){
                mouse.x = event.offsetX, mouse.y = event.offsetY;
                transPenMove();
            }
        }


        function transPen_touchendHandler(){//触屏
            _onEnd(this);
            isTouching_tmp = false;
        }

        function transPen_mouseupHandler(){
            _onEnd(this);
        }

        function transPen_mouseoutHandler(){
            _onEnd(this);
        }



        function _onPaint() {
            ppts.push({x: mouse.x, y: mouse.y});
            if (ppts.length < 2) {
                var b = ppts[0];
                _tempContext.beginPath();
                _tempContext.arc(b.x, b.y, _tempContext.lineWidth / 2, 0, Math.PI * 2, !0);
                _tempContext.fill();
                _tempContext.closePath();
                return;
            }
            _tempContext.clearRect(0, 0, _tempCanvas.width(), _tempCanvas.height());
            _tempContext.beginPath();
            for (var i = 0; i < ppts.length - 1; i++) {
                var c = (ppts[i].x + ppts[i + 1].x) / 2;
                var d = (ppts[i].y + ppts[i + 1].y) / 2;
                _tempContext.quadraticCurveTo(ppts[i].x, ppts[i].y, c, d);
            }
            _tempContext.stroke();
        }

        function _onEnd(_this) {
            //将笔迹拷贝到下层的canvas上
            _strokeContext.drawImage(_this, 0, 0);
            _tempContext.clearRect(0, 0, _tempCanvas.width(), _tempCanvas.height());
            ppts = [];
            _isPainting && strokes.push([-1, -1]);
            _isPainting = false;
        }






    }

    exports.Instance = new PaintCanvas();
});