/**
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-7-31
 * Time: 下午6:04
 * To change this template use File | Settings | File Templates.
 */

/****************************************************************
 *
 * 这一模块初步打算废弃，暂时请不要删除。还有参考价值。
 *                            ------  by  yczhu
 *
 ***************************************************************/

define(function (require, exports, module) {
    require('jquery');
    require('jqjson');
    var _define = require('../define');
    var _loginAssistor = require('./loginAssistor');
    var _userinfoAccessor = require('./userinfoAccessor');
    var ebookContext = require('../ebookcontext').Instance;
    var _path = require('../../common/path');
    var _shellcmd = require('../../common/shellcmd');
    var _pageNavigatorHelper = require('../../common/pagenavigatorhelper');
    require('zebra_dialog');

    function UserLoginManager() {
        var _self = this;
        _self.buttons = {};
        _self.controls = {};
        _self.userBindMgr = null;
        _self.currentUser = null;

        /**
         * @param buttons   按钮
         * @param controls  非按钮类控件
         * @param bookContainer
         */
        this.init = function (buttons, controls, userBindMgr) {

            _self.buttons = buttons;
            _self.controls = controls;
            _self.userBindMgr = userBindMgr;
            _self._account = "";
            _self._password = "";

            _self._hideTip();
			
            //用户登陆
            _self.buttons.btnUserLogin.click(function () {
                _self._hideTip();
                _userinfoAccessor.creatTable();
                _self._account = _self.controls.iptUserAccount.val();
                _self._password = _self.controls.iptUserPassword.val();
                _self.login(_self._account, _self._password);
            });
            _self.buttons.btnUserRegister.click(function () {
                _shellcmd.openPageOutside(AppRemoteSvcCfg.UserRegisterPageUrl);
            });
            _self.buttons.btnForgetPassword.click(function () {
                _shellcmd.openPageOutside(AppRemoteSvcCfg.UserForgetPasswordPageUrl);
            });

            _self.buttons.btnCloseLogin.click(function () {
                $("#loginOverlay").hide();
              //  _shellcmd.closeApp();
            });

            _self.buttons.btnMinLogin.click(function () {
                _shellcmd.ebookMin();
            });

            _self.buttons.btnUserActivate.click(function () {
                _shellcmd.openPageOutside(AppRemoteSvcCfg.UserActivationPageUrl);
            });

            _self.buttons.btnDownList.click(function (e) {
                e.stopPropagation();
                _self.buttons.btnDownList.css("display", "none");
                _self.buttons.btnUpList.css("display", "inline");
                _self.controls.lstAccount.css("display", "inline");
            });

            _self.buttons.btnUpList.click(function () {
                _self.hideAccountList();
            });

            /**
             * 单击其他地方，收起用户列表
             */
            _self.controls.loginPanel.click(function () {
                _self.hideAccountList();
            });

            /**
             * 回车键触发登录
             */
            _self.controls.iptUserPassword.keypress(function (e) {
                var key = e.which; //e.which是按键的值
                if (key == 13) {
                    _self.buttons.btnUserLogin.trigger("click");
                }
            });

            /**
             * 回车键触发登录
             */
            _self.controls.iptUserAccount.keypress(function (e) {
                var key = e.which; //e.which是按键的值
                if (key == 13) {
                    _self.buttons.btnUserLogin.trigger("click");
                }
            });

            _self.controls.iptUserAccount.focus(function () {
                _self._hideTip();
            });

            _self.controls.iptUserPassword.focus(function () {
                _self._hideTip();
            });

            _self.hideLoginPanel();

            _self.initListAccount().done(function () {
                _self.initLastUser();
            });

            /**
             * 弹出软键盘
             */
            _self.buttons.btnKeyboardIme.click(function () {
                _shellcmd.callIme("keyboard", _self.controls.iptUserAccount);
            });

            _self.buttons.chkboxRememberPassword.click(function () {
                if ("assert/images/login_checkbox.png" == $(this).attr("src")) {
                    _self.setRememberPasswordChecked(true);
                } else {
                    _self.setRememberPasswordChecked(false);
                }
            });

            //根据程序配置决定是否进入登录界面时弹出软键盘
            if (AppCfg.isShowKeyboard) {
                _self.buttons.btnKeyboardIme.trigger("click");
            }
        };

        _self.setRememberPasswordChecked = function (checked) {
            if (checked) {
                _self.buttons.chkboxRememberPassword.attr("src", "assert/images/login_checkbox2.png");
            } else {
                _self.buttons.chkboxRememberPassword.attr("src", "assert/images/login_checkbox.png");
            }
            _self.buttons.chkboxRememberPassword.attr("data-checked", checked);
        }

        _self.login = function (account, password) {
            if (account == "" || password == "") {
                _self._showTip(AppTips.loginNoPasswordMsg);
                return;
            }
            //检查环境
            _shellcmd.checkEnvironment().done(function (isEnvironmentAllowed) {
                if (isEnvironmentAllowed) {
                    _shellcmd.checkRunningDiskSpace().done(function (freeSpace) {
                        console.log(freeSpace);
                        if (freeSpace < AppCfg.memoryRequired) {
                            $.Zebra_Dialog(AppTips.OutOFMemoryMsg, {
                                'type': 'question',
                                'title': AppTips.WarmTips,
                                'buttons': [AppTips.CancelTips, AppTips.OkTips],
                                'onClose': function (capition) {
                                    if (capition == AppTips.OkTips) {
                                        _self._userLogin(account, password);
                                    } else {
                                        return;
                                    }
                                }
                            });
                        } else {
                            _self._userLogin(account, password);
                        }
                    });
                } else {
                    _self._showTip(AppTips.loginWrongMachineMsg);
                }
            });
        }

        _self._userLogin = function (account, password) {
//                通过DELPHI进行登陆，消息异步
//                if (isEnvironmentAllowed) {
//                    _self._hideTip();
//                    _loginAssistor.callUserLogin(account, password);
//                    _self._showTip(AppTips.loginingMsg);
//                } else {
//                    _self._showTip(AppTips.loginWrongMachineMsg);
//                }
//              通过AJAX进行登陆

            _self._hideTip();
            _loginAssistor.userLogin(account, password).done(function (ret) {
                console.log(ret);
                var obj = null;
                try {
                    obj = JSON.parse(ret);
                }
                catch (e) {
                    obj = null;
                }
                var loginResultObj = _loginAssistor.parseOnlineLoginData(obj);
                var loginResult = _self._onlineLoginHandler(loginResultObj);
                loginResult.done(function (ret) {
                    if (ret == _define.LoginResultType.RemoteFail) { //如果联网登陆失败，则尝试本地登陆
                        _self._localLogin(_self._account, _self._password).done(function (ret) {
                            _self._LoginResultProcessor(ret);
                        });
                    }
                    else {
                        _self._LoginResultProcessor(ret);
                    }
                });
            });
            _self._showTip(AppTips.loginingMsg);
        }

        /**
         * 全局回调消息，实现异步登陆
         * @param obj
         */
        this.onMessageReceived = function (obj) {
            if (obj.evt == "appclosing") {
                _shellcmd.closeApp();
            }
            if (obj.evt == "tryonlinelogin") {
                console.log("tryonlinelogin:" + JSON.stringify(obj.data));
                var loginResultObj = _loginAssistor.parseOnlineLoginData(obj.data);
                var loginResult = _self._onlineLoginHandler(loginResultObj);
                loginResult.done(function (ret) {
                    if (ret == _define.LoginResultType.RemoteFail) { //如果联网登陆失败，则尝试本地登陆
                        _self._localLogin(_self._account, _self._password).done(function (ret) {
                            _self._LoginResultProcessor(ret);
                        });
                    }
                    else {
                        _self._LoginResultProcessor(ret);
                    }
                });
            }
        }

        /**
         * 本地登陆
         * @param account
         * @param password
         * @returns {*}
         * @private
         */
        _self._localLogin = function (account, password) {
            var defer = $.Deferred();
            _loginAssistor.getUserAccount(account).done(function (userAccount) {

                if (userAccount == null || userAccount == "") {
                    console.log("local login not find user:" + userAccount);
                    userAccount = account;
                    //   defer.resolve(_define.LoginResultType.AccountNotMatchPwd);
                }
                //else {
                //检查授权文件是否存在
                _loginAssistor.checkUserLicenseExist(userAccount).done(function (isLicenseExist) {
                    console.log("isLicenseExist:" + isLicenseExist);
                    if (!isLicenseExist) {
                        console.log("noLicense");
                        defer.resolve(_define.LoginResultType.NoLicense);
                    } else {
                        _shellcmd.getHardwareInfo(userAccount).done(function (hdInfo) {
                            //检查账号有效性
                            _loginAssistor.checkAuthorization(userAccount, password, hdInfo).done(function (isValid) {
                                console.log(isValid);
                                switch (isValid) {
                                    case '-2':
                                        defer.resolve(_define.LoginResultType.AccountForbidden);
                                        break;
                                    case '-1':
                                        defer.resolve(_define.LoginResultType.NoLicense);
                                        break;
                                    case '0':
                                        defer.resolve(_define.LoginResultType.ArgumentImperfect);
                                        break;
                                    case '1':
                                        defer.resolve(_define.LoginResultType.AccountNotMatchPwd);
                                        break;
                                    case '2':
                                        defer.resolve(_define.LoginResultType.AccountNotMatchMachineCode);
                                        break;
                                    case '3':
                                        defer.resolve(_define.LoginResultType.TimeStampOver);
                                        break;
                                    case '4':
                                        ebookContext.setBinPath(Config.binPath);
                                        ebookContext.setUser(userAccount, password);
                                        ebookContext.getUser().setIsOnline(false);
                                        ebookContext.getUser().setTicket("");
                                        defer.resolve(_define.LoginResultType.LocalSuccess);
                                        break;
                                    default:
                                        defer.resolve(_define.LoginResultType.LocalFail);
                                }
                            });
                        });
                    }
                });
            });
            return defer.promise();
        }

        /**
         * 统一处理用户登陆结果,包括联网登陆和本地登陆结果
         * @param loginResult
         * @private
         */
        _self._LoginResultProcessor = function (loginResult) {
            switch (loginResult) {
                case _define.LoginResultType.AccountForbidden:
                    _self._showTip(AppTips.accountForbiddenMsg);
                    break;
                case _define.LoginResultType.NotActivated:
                    _self._showTip(AppTips.activateAccountMsg);
                    _self.controls.tipsPanel.find("#btnActivated").click(function () {
                        _shellcmd.openPageOutside(AppRemoteSvcCfg.UserActivationPageUrl);
                    });
                    break;
                case _define.LoginResultType.AllowBind:
                    console.log("允许绑定");
                    _self._hideTip();
                    _self.hideLoginPanel();
                    _self.userBindMgr.showBindPanel(AppTips.bindHardwareMsg);
                    break;
                case _define.LoginResultType.BindOverflow:
                    console.log("绑定数已满");
                    _self._showTip(AppTips.bindOverflowMsg);
                    _self.controls.tipsPanel.find("#btnRempveBind").click(function () {
                        var removeRebindUrl = AppRemoteSvcCfg.RemoveRebindUrl + "&ticket=" + ebookContext.getUser().getTicket();
                        console.log("解綁定URL=" + removeRebindUrl);
                        _shellcmd.openPageOutside(removeRebindUrl);
                    });
                    break;
                case _define.LoginResultType.AlreadyBind:
                    console.log("已经绑定,联网登录成功");
                    //如果没有用户目录，则创建，防止用户删除了自己的目录
                    _loginAssistor.createUserFolder(ebookContext.getUser()).done(function (ret) {
                        if (!ret) {
                            console.log("创建用户目录失败");
                            _shellcmd.deleteDir(_path.trimPosix(ebookContext.getUser().getUserBasePath()));
                            _self._showTip(AppTips.loginCreateFolderFailMsg);
                            return;
                        }
                        _pageNavigatorHelper.goToShelfFromLogin(ebookContext.getUser(), _self._password);
                    });
                    break;
                case _define.LoginResultType.GetBindMsgError:
                    console.log("获取绑定信息失败");
                    _self._showTip(AppTips.loginFailMsg);
                    break;
                case _define.LoginResultType.CannotCreateLocalUserFold:
                    console.log("在创建新用户目录时失败");
                    _self._showTip(AppTips.loginCreateFolderFailMsg);
                    break;
                case _define.LoginResultType.CannotInsertLocalUserinfo:
                    console.log("向本地数据库中插入数据失败");
                    _self._showTip(AppTips.loginCreateFolderFailMsg);
                    break;
                case _define.LoginResultType.RemoteFail:
                    console.log("联网登录失败");
                    _self._showTip(AppTips.loginFailMsg);
                    break;
                case _define.LoginResultType.LocalSuccess:
                    console.log("本地登录成功");
                    var rememberPasswordFlag = _self.buttons.chkboxRememberPassword.attr("data-checked") == "true" ? 1 : 0;
                    //记住密码
                    _userinfoAccessor.updateAccount(ebookContext.getUser().getName(), "", "", "", rememberPasswordFlag).done(function () {
                        _pageNavigatorHelper.goToShelfFromLogin(ebookContext.getUser(), ""); //跳转到书架
                    });
                    break;
                case _define.LoginResultType.NoLicense:
                    console.log("license不存在");
                    _self._showTip(AppTips.loginFailMsg);
                    break;
                case _define.LoginResultType.ArgumentImperfect:
                    console.log("参数传递错误");
                    _self._showTip(AppTips.loginFailMsg);
                    break;
                case _define.LoginResultType.AccountNotMatchPwd:
                    console.log("账号和密码不匹配");
                    _self._showTip(AppTips.localLoginWrongPasswordMsg);
                    break;
                case _define.LoginResultType.AccountOutDate:
                    console.log("账号过期了");
                    _self._showTip(AppTips.AccountOutdateMsg);
                    break;
                case _define.LoginResultType.AccountNotMatchMachineCode:
                    console.log("账号和机器码不匹配");
                    _self._showTip(AppTips.localLoginWrongMachineMsg);
                    break;
                case _define.LoginResultType.TimeStampOver:
                    console.log("license已过期");
                    _self._showTip(AppTips.timeStampOverMsg);
                    break;
                case  _define.LoginResultType.NoAccountFold:
                    console.log("没有用户目录");
                    _self._showTip(AppTips.loginFailMsg);
                    break;
                case _define.LoginResultType.LocalFail:
                    console.log("本地登录失败");
                    _self._showTip(AppTips.loginFailMsg);
                    break;
                default:
                    console.log("登录失败");
                    _self._showTip(AppTips.loginFailMsg);
                    break;
            }
        }

        /**
         * 对联网登陆数据进行结果判定
         * @param loginResutl
         * @returns {*}
         * @private
         */
        _self._onlineLoginHandler = function (loginResutl) {
            var def = $.Deferred();
            switch (loginResutl.statusCode) {
                case 0:
                    console.log("联网登录成功，准备进行授权判断");
                    var userInfo = loginResutl.data; //记录返回的用户信息，包括了userAccount,email,phonenum
                    ebookContext.setBinPath(Config.binPath);
                    ebookContext.setUser(userInfo.userAccount, _self._password);
                    ebookContext.getUser().setIsOnline(true);
                    ebookContext.getUser().setTicket(userInfo.ticket);
                    //在这里执行用户头像下载，以固定的名称保存到用户目录下，下载路径存在userInfo.photo里
                    ebookContext.getUser().setPhoto(userInfo.photo);

                    var rememberPasswordFlag = _self.buttons.chkboxRememberPassword.attr("data-checked") == "true" ? 1 : 0;
                    _shellcmd.desEncrpty(_self._password, userInfo.userAccount).done(function (passwordData) {
                        _loginAssistor.addUserToLocalDb(userInfo, passwordData, rememberPasswordFlag).done(function (rett) {
                            var getHdTypeTask = _shellcmd.getHardwareType(ebookContext.getUser().getName());
                            var getHdInfoTask = _shellcmd.getHardwareInfo(ebookContext.getUser().getName());
                            //等待task1,task2都完成
                            $.when(getHdTypeTask, getHdInfoTask).done(function (hdType, hardwareInfo) {

                                var checkBindTask = _loginAssistor.callCheckBind(ebookContext.getUser().getName(), hardwareInfo, hdType);
                                checkBindTask.done(function (dataReceived) {
                                    var retObj = _loginAssistor.userBindDataConverter(dataReceived);
                                    var retResult = _define.LoginResultType.RemoteFail;
                                    switch (retObj.statusCode) {
                                        case 0:
                                            retResult = _define.LoginResultType.AllowBind;
                                            break;
                                        case 1:
                                            retResult = _define.LoginResultType.BindOverflow;
                                            break;
                                        case 2:
                                            retResult = _define.LoginResultType.AlreadyBind;
                                            break;
                                        case 3:
                                            retResult = _define.LoginResultType.GetBindMsgError;
                                            break;
                                        default:
                                            console.log("验证绑定回传数据有问题");
                                            retResult = _define.LoginResultType.RemoteFail;
                                            break;
                                    }
                                    def.resolve(retResult);
                                });
                            });
                        });//将用户添加到本地数据库
                    });

                    break;
                case 1:
                    console.log("联网登录失败，未知错误");
                    def.resolve(_define.LoginResultType.RemoteFail);
                    break;
                case 2:
                    console.log("联网登录失败，用户未激活");
                    def.resolve(_define.LoginResultType.NotActivated);
                    break;
                case 3:
                    console.log("联网登录失败，参数错误");
                    def.resolve(_define.LoginResultType.RemoteFail);
                    break;
                case 4:
                    console.log("联网登录失败，用户被禁用");
                    _self._downloadUserLic();
                    def.resolve(_define.LoginResultType.AccountForbidden);
                    break;
                case 5:
                    console.log("联网登录失败，集团用户被禁用");
                    _self._downloadUserLic();
                    def.resolve(_define.LoginResultType.AccountForbidden);
                    break;
                case 6:
                    console.log("联网登录失败，用户名或密码错误");
                    def.resolve(_define.LoginResultType.AccountNotMatchPwd);
                    break;
                case 7:
                    console.log("联网登陆失败，账号过期");
                    def.resolve(_define.LoginResultType.AccountOutDate);
                default :
                    console.log("登录回传数据有问题");
                    def.resolve(_define.LoginResultType.RemoteFail);
                    break;
            }
            return def.promise();
        }

        this._downloadUserLic = function () {
            ebookContext.setBinPath(Config.binPath);
            ebookContext.setUser(_self._account, _self._password);
            var getHdTypeTask = _shellcmd.getHardwareType(ebookContext.getUser().getName());
            var getHdInfoTask = _shellcmd.getHardwareInfo(ebookContext.getUser().getName());
            $.when(getHdTypeTask, getHdInfoTask).done(function (hdType, hardwareInfo) {
                _loginAssistor.callGetUserLicense(ebookContext.getUser(), hardwareInfo, hdType)
                    .done(function (dataReceived) {
                        var retObj = _loginAssistor.userLicDataConverter(dataReceived);
                        if (retObj.statusCode == 0 && retObj.data) {
                            _shellcmd.isFileExist(_path.trimPosix(ebookContext.getUser().getUserLicenseFullPath()))
                                .done(function (isFileExist) {
                                    if (isFileExist)
                                        _shellcmd.saveFile(retObj.data, _path.trimPosix(ebookContext.getUser().getUserLicenseFullPath()));
                                });
                        }
                    });
            });
        }

        this.hideLoginPanel = function () {
            _self.controls.loginOverlay.hide();
        }
        this.showLoginPanel = function () {
            _self.controls.loginOverlay.show();
        }
        this._showTip = function (msg) {
            _self.controls.tipsPanel.html(msg);
            _self.controls.tipsPanel.show();
        }
        this._hideTip = function () {
            _self.controls.tipsPanel.html("");
            _self.controls.tipsPanel.hide();
        }

        _self.initListAccount = function () {
            var def = $.Deferred();
            var allUserAccountTask = _userinfoAccessor.loadAccountList();
            allUserAccountTask.done(function (res) {

                //检测用户数是否超过10个，超过10个的部分删掉
                _userinfoAccessor.deleteMoreAccount();

                var allUserAccountJson = JSON.parse(res);
                var allUserAccountList = [];
                var data = allUserAccountJson.data;

                var lstAccountTemplate = "<li class='' account = '{{account}}'>{{account}}</li>";
                var delTmpl = "<p><input type='button' value='' class='login_del'></p>";
                var html = "";
                for (var item in data) {
                    var account = data[item].account;
                    allUserAccountList.push(account);
                    html += lstAccountTemplate.replace("{{account}}", account).replace("{{account}}", account);
                }
                var listHtml = $(html);
                _self.controls.lstAccount.append(listHtml);

                var allAccountItem = _self.controls.lstAccount.find("li");

                allAccountItem.mouseenter(function (e) {
                    e.stopPropagation();
                    var _newP = $(delTmpl);
                    $(this).addClass("pick").append(_newP);
                });

                allAccountItem.mouseleave(function (e) {
                    e.stopPropagation();
                    $(this).removeClass("pick").find('p').remove();
                });

                //注册单击选中事件
                allAccountItem.click(function (e) {
                    e.stopPropagation();
                    var _hereThis = $(this);
                    var _account = _hereThis.attr("account");
                    if (e.target.tagName.toLowerCase() == "li") {
                        _self.changeAccount(_hereThis, _account, allAccountItem);
                    }
                    else {
                        _self.deleAccount(_hereThis, _account);
                    }
                    _self.hideAccountList();
                });

                def.resolve();
            });
            return def.promise();
        }

        /**
         * 显示最后登录的用户
         */
        _self.initLastUser = function () {
            var lastUserTask = _userinfoAccessor.getLastLoginUser();
            lastUserTask.done(function (res) {
                _self.controls.iptUserAccount.val(res.account);
                if (res.IsRememberPasswordOrNOt == "1") {
                    //秘钥是账号
                    _self.setRememberPasswordChecked(true);
                    var dataTask = _shellcmd.desDecrpty(res.password, res.account);
                    dataTask.done(function (data) {
                        _self.controls.iptUserPassword.val(data);
                    });
                }
            });
        }

        /**
         * 收起账户面板
         */
        _self.hideAccountList = function () {
            _self.buttons.btnDownList.css("display", "inline");
            _self.buttons.btnUpList.css("display", "none");
            _self.controls.lstAccount.css("display", "none");
        }

        /**
         * 切换账户
         */
        _self.changeAccount = function (domLi, account, allAccount) {
            allAccount.each(function () {
                $(this).removeClass("pick");
            });
            domLi.addClass("pick");
            _self.controls.iptUserAccount.val(account);
            //清空密码
            _self.controls.iptUserPassword.val("");
        }

        /**
         * 删除账户
         * @param domLi 界面上需要删除的Dom元素
         * @param account   需要在数据库里删除的账号
         */
        _self.deleAccount = function (domLi, account) {
            domLi.remove();
            _userinfoAccessor.deleteAccount(account);
        }

        /**
         * 静默登陆，无界面，给电子书包用
         * @param account
         * @param password
         */
        _self.silenceLogin = function (account, password) {
            _loginAssistor.userLogin(account, password).done(function (ret) {
                console.log(ret);
                var obj = null;
                try {
                    obj = JSON.parse(ret);
                    var loginResultObj = _loginAssistor.parseOnlineLoginData(obj);
                    var loginResult = _self._onlineLoginHandler(loginResultObj);
                    loginResult.done(function (ret) {
                        if (ret == _define.LoginResultType.RemoteFail) { //如果联网登陆失败，则尝试本地登陆
                            _self._localLogin(account, password).done(function (ret) {
                                if (ret) {
                                    console.log("local login success");
                                    _pageNavigatorHelper.goToShelfFromLogin(ebookContext.getUser(), "");
                                }
                                else  console.log("local login fail");
                            });
                        } else if (ret == _define.LoginResultType.RemoteSuccess) {
                            console.log("online login success");
                            _pageNavigatorHelper.goToShelfFromLogin(ebookContext.getUser(), "");
                        } else {
                            console.log("online login fail");
                        }
                    });
                } catch (e) {
                    _self._localLogin(account, password).done(function (ret) {
                        if (ret) {
                            console.log("local login success");
                            _pageNavigatorHelper.goToShelfFromLogin(ebookContext.getUser(), "");
                        }
                        else  console.log("local login fail");
                    });
                }
            });
        }

        /**
         * 书架界面登录
         * 传入数据必须非空，有效性在书架检验
         */
        _self.loginFromShelf = function(account,password){
            var def = $.Deferred();
            _self._password = password;
            _self._account = account;
            _shellcmd.checkEnvironment().done(function (isEnvironmentAllowed) {
                if (isEnvironmentAllowed) {
                    _shellcmd.checkRunningDiskSpace().done(function (freeSpace) {
                        console.log(freeSpace);
                        if (freeSpace < AppCfg.memoryRequired) {
                            $.Zebra_Dialog(AppTips.OutOFMemoryMsg, {
                                'type': 'question',
                                'title': AppTips.WarmTips,
                                'buttons': [AppTips.CancelTips, AppTips.OkTips],
                                'onClose': function (capition) {
                                    if (capition == AppTips.OkTips) {
                                        _self.userLoginFromShelf(account, password).done(function(){
                                            def.resolve();
                                        });
                                    } else {
                                    }
                                }
                            });
                        } else {
                            _self.userLoginFromShelf(account, password).done(function(result){
                                def.resolve(result);
                            });
                        }
                    });
                } else {
                    // 20140617 暂不处理
                    def.resolve(false);
                }
            });
            return def.promise();
        }

        _self.userLoginFromShelf = function(account,password){
            var def = $.Deferred();
            _loginAssistor.userLogin(account, password).done(function (ret) {
                console.log(ret);
                var obj = null;
                try {
                    obj = JSON.parse(ret);
                }
                catch (e) {
                    obj = null;
                }
                var loginResultObj = _loginAssistor.parseOnlineLoginData(obj);
                var loginResult = _self.onlineLoginFromShelf(loginResultObj);
                loginResult.done(function (ret) {
                    if (ret == _define.LoginResultType.RemoteFail) { //如果联网登陆失败，则尝试本地登陆
                        _self._localLogin(_self._account, _self._password).done(function (ret) {
                            _self.LoginResultProFromShelf(ret).done(function(result){
                                def.resolve(result);
                            });
                        });
                    }
                    else {
                        _self.LoginResultProFromShelf(ret).done(function(result){
                            def.resolve(result);
                        });
                    }
                });
            });
            return def.promise();
        }



        _self.LoginResultProFromShelf = function(loginResult){
            var def = $.Deferred();
            switch (loginResult) {
                case _define.LoginResultType.AccountForbidden:
                    def.resolve(false);
                    break;
                case _define.LoginResultType.NotActivated:
                    console.log("未激活，允许从书架界面绑定");
                    _self.bindClientFromShelf().done(function(ret){
                        def.resolve(ret);
                    });
                    break;
                case _define.LoginResultType.AllowBind:
                    console.log("已激活，允许从书架界面绑定");
                    _self.bindClientFromShelf().done(function(ret){
                        def.resolve(ret);
                    });
                    break;
                case _define.LoginResultType.BindOverflow:
                    console.log("绑定数已满");
                    def.resolve(false);
                    break;
                case _define.LoginResultType.AlreadyBind:
                    console.log("已经绑定,联网登录成功");
                    //如果没有用户目录，则创建，防止用户删除了自己的目录
                    _loginAssistor.createUserFolder(ebookContext.getUser()).done(function (ret) {

                        var account = ebookContext.getUser().getName();
                        var pwd = _self._password;
                        var pname = 'iFlyBook.exe';
                        _shellcmd.findProcess(pname).done(function (retpid) {
                            var pid = retpid;
                            var transmitJson = {
                                account: account,
                                pwd: pwd,
                                pname: pname,
                                pid: pid
                            };

                            _shellcmd.saveFilAsync(JSON.stringify(transmitJson), _path.trimPosix(Config.binPath) + 'transmit.dat').done(function (ret) {
                                if (!ret) {
                                    console.log("创建用户目录失败");
                                    _shellcmd.deleteDir(_path.trimPosix(ebookContext.getUser().getUserBasePath()));
                                    def.resolve(false);
                                }
                                else{
                                    def.resolve(true);
                                }
                            });
                        });
                    });
                    break;
                case _define.LoginResultType.GetBindMsgError:
                    console.log("获取绑定信息失败");
                    def.resolve(false);
                    break;
                case _define.LoginResultType.CannotCreateLocalUserFold:
                    console.log("在创建新用户目录时失败");
                    def.resolve(false);
                    break;
                case _define.LoginResultType.CannotInsertLocalUserinfo:
                    console.log("向本地数据库中插入数据失败");
                    def.resolve(false);
                    break;
                case _define.LoginResultType.RemoteFail:
                    console.log("联网登录失败");
                    break;
                case _define.LoginResultType.LocalSuccess:
                    console.log("本地登录成功");
                    break;
                case _define.LoginResultType.NoLicense:
                    console.log("license不存在");
                    def.resolve(false);
                    break;
                case _define.LoginResultType.ArgumentImperfect:
                    console.log("参数传递错误");
                    def.resolve(false);
                    break;
                case _define.LoginResultType.AccountNotMatchPwd:
                    console.log("账号和密码不匹配");
                    def.resolve(false);
                    break;
                case _define.LoginResultType.AccountOutDate:
                    console.log("账号过期了");
                    def.resolve(false);
                    break;
                case _define.LoginResultType.AccountNotMatchMachineCode:
                    console.log("账号和机器码不匹配");
                    def.resolve(false);
                    break;
                case _define.LoginResultType.TimeStampOver:
                    console.log("license已过期");
                    def.resolve(false);
                    break;
                case  _define.LoginResultType.NoAccountFold:
                    console.log("没有用户目录");
                    def.resolve(false);
                    break;
                case _define.LoginResultType.LocalFail:
                    console.log("本地登录失败");
                    def.resolve(false);
                    break;
                default:
                    console.log("登录失败");
                    def.resolve(false);
                    break;
            }
            return def.promise();
        }

        _self.onlineLoginFromShelf = function (loginResutl) {
            var def = $.Deferred();
            switch (loginResutl.statusCode) {
                case 0:
                    console.log("联网登录成功，准备进行授权判断");
                    var userInfo = loginResutl.data; //记录返回的用户信息，包括了userAccount,email,phonenum
                    ebookContext.setBinPath(Config.binPath);
                    ebookContext.setUser(userInfo.userAccount, _self._password);
                    ebookContext.getUser().setIsOnline(true);
                    ebookContext.getUser().setTicket(userInfo.ticket);
                    ebookContext.getUser().setIsActive(true);
                    //在这里执行用户头像下载，以固定的名称保存到用户目录下，下载路径存在userInfo.photo里
               //     ebookContext.getUser().setPhoto(userInfo.photo);

                    var getHdTypeTask = _shellcmd.getHardwareType(ebookContext.getUser().getName());
                    var getHdInfoTask = _shellcmd.getHardwareInfo(ebookContext.getUser().getName());
                    //等待task1,task2都完成
                    $.when(getHdTypeTask, getHdInfoTask).done(function (hdType, hardwareInfo) {

                        var checkBindTask = _loginAssistor.callCheckBind(ebookContext.getUser().getName(), hardwareInfo, hdType);
                        checkBindTask.done(function (dataReceived) {
                            var retObj = _loginAssistor.userBindDataConverter(dataReceived);
                            var retResult = _define.LoginResultType.RemoteFail;
                            switch (retObj.statusCode) {
                                case 0:
                                    retResult = _define.LoginResultType.AllowBind;
                                    break;
                                case 1:
                                    retResult = _define.LoginResultType.BindOverflow;
                                    break;
                                case 2:
                                    retResult = _define.LoginResultType.AlreadyBind;
                                    break;
                                case 3:
                                    retResult = _define.LoginResultType.GetBindMsgError;
                                    break;
                                default:
                                    console.log("验证绑定回传数据有问题");
                                    retResult = _define.LoginResultType.RemoteFail;
                                    break;
                            }
                            def.resolve(retResult);
                        });
                    });
                    break;
                case 1:
                    console.log("联网登录失败，未知错误");
                    def.resolve(_define.LoginResultType.RemoteFail);
                    break;
                case 2:
                    console.log("联网登录失败，用户未激活");
                    def.resolve(_define.LoginResultType.NotActivated);
                    break;
                case 3:
                    console.log("联网登录失败，参数错误");
                    def.resolve(_define.LoginResultType.RemoteFail);
                    break;
                case 4:
                    console.log("联网登录失败，用户被禁用");
                    _self._downloadUserLic();
                    def.resolve(_define.LoginResultType.AccountForbidden);
                    break;
                case 5:
                    console.log("联网登录失败，集团用户被禁用");
                    _self._downloadUserLic();
                    def.resolve(_define.LoginResultType.AccountForbidden);
                    break;
                case 6:
                    console.log("联网登录失败，用户名或密码错误");
                    def.resolve(_define.LoginResultType.AccountNotMatchPwd);
                    break;
                case 7:
                    console.log("联网登陆失败，账号过期");
                    def.resolve(_define.LoginResultType.AccountOutDate);
                default :
                    console.log("登录回传数据有问题");
                    def.resolve(_define.LoginResultType.RemoteFail);
                    break;
            }
            return def.promise();
        }

        /**
         * 默认绑定方式，不应该写在这里的函数，权宜之计
         */
        _self.bindClientFromShelf = function () {
            var def = $.Deferred();
            console.log("用户绑定 userAccount:" + ebookContext.getUser().getName());
            var hdInfoTask = _shellcmd.getHardwareInfo(ebookContext.getUser().getName());
            var hdTypeTask = _shellcmd.getHardwareType();
            var hdNameTask = _shellcmd.getHardwareName();
            $.when(hdInfoTask, hdTypeTask, hdNameTask).done(function (hdInfo, hdType, hdName) {
                _loginAssistor.callBindUser(ebookContext.getUser().getName(), hdInfo, hdType, hdName).done(function (dataReceived) {
                    console.log(dataReceived);
                    var retObj = _loginAssistor.userBindDataConverter(dataReceived);
                    switch (retObj.statusCode) {
                        case 0://绑定成功
                            console.log("绑定成功");
                            _loginAssistor.createUserFolder(ebookContext.getUser()).done(function (ret) {
                                if (!ret) {
                                    console.log("创建用户目录失败");
                                    _shellcmd.deleteDir(_path.trimPosix(ebookContext.getUser().getUserBasePath()));
                                    def.resolve(false);
                                }
                                else{
                                    def.resolve(true);
                                }
                            });
                            break;
                        default ://绑定失败
                            console.log("绑定失败");
                            def.resolve(false);
                            break;
                    }
                });
            });

            return def.promise();
        }
    }

    UserLoginManager.prototype = new UserLoginManager();
    UserLoginManager.prototype.constructor = UserLoginManager;

    exports.UserLoginManager = UserLoginManager;
    exports.Instance = new UserLoginManager();
})
;
