/**
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-8-2
 * Time: 下午2:50
 * To change this template use File | Settings | File Templates.
 */

/**************************************************************
 * 这里封装的是用户绑定模块。
 * 目前已经把这块功能交由eshop处理。
 * 由eshop调用自己相应的接口自动完成用户硬件绑定。
 * 简化用户操作。
 * 至于为什么没有删除，是因为我觉得还有保留的价值。
 *                 ---------  by  yczhu
 *************************************************************/

define(function (require, exports, module) {
    require('jquery');
    var _loginAssistor = require('./loginAssistor');
    var ebookContext = require('../ebookcontext').Instance;
    var _userinfoAccessor = require('./userinfoAccessor');
    var _pageNavigatorHelper = require('../../common/pagenavigatorhelper');
    var _shellcmd = require('../../common/shellcmd');
    var _path = require('../../common/path');

    function UserBindManager() {
        var _self = this;
        _self.buttons = {};
        _self.controls = {};

        /**
         * @param buttons   按钮
         * @param controls  非按钮类控件
         * @param bookContainer
         */
        this.init = function (buttons, controls) {
            _self.buttons = buttons;
            _self.controls = controls;
            _self.userLoginMgr = null;

            _self.controls.bindResultTipsPanel.hide();
            _self.buttons.btnConfirmBind.click(function () {
                _self.controls.bindResultTipsPanel.hide();
                _self.bindClient();
            });
            _self.buttons.btnCancelBind.click(function () {
                _self.userLoginMgr.showLoginPanel();
                _self.hideBindPanel();
            });
            _self.buttons.btnCloseBind.click(function () {
                _self.userLoginMgr.showLoginPanel();
                _self.hideBindPanel();
            });
            _self.buttons.btnWhatIsBind.click(function () {
                _shellcmd.openPageOutside(AppRemoteSvcCfg.WhatIsBindPageUrl);
            });

            _self.hideBindPanel();
        };
        _self.setUserLoginMgr = function (userLoginMgr) {
            _self.userLoginMgr = userLoginMgr;
        }

        /**
         * 用户绑定
         */
        _self.bindClient = function () {
            console.log("用户绑定 userAccount:" + ebookContext.getUser().getName());
            var hdInfoTask = _shellcmd.getHardwareInfo(ebookContext.getUser().getName());
            var hdTypeTask = _shellcmd.getHardwareType();
            var hdNameTask = _shellcmd.getHardwareName();
            $.when(hdInfoTask, hdTypeTask, hdNameTask).done(function (hdInfo, hdType, hdName) {
                _loginAssistor.callBindUser(ebookContext.getUser().getName(), hdInfo, hdType, hdName).done(function (dataReceived) {
                    console.log(dataReceived);
                    var retObj = _loginAssistor.userBindDataConverter(dataReceived);
                    switch (retObj.statusCode) {
                        case 0://绑定成功
                            console.log("绑定成功");

                            _loginAssistor.createUserFolder(ebookContext.getUser()).done(function (ret) {
                                if (!ret) {
                                    console.log("创建用户目录失败");
                                    _shellcmd.deleteDir(_path.trimPosix(ebookContext.getUser().getUserBasePath()));
                                    _self._showTip(AppTips.bindFailMsg);
                                    return;
                                }
                                _self.hideBindPanel();
                                ebookContext.getUser().getPassword().done(function(pass){
                                    _pageNavigatorHelper.goToShelfFromLogin(ebookContext.getUser(),pass); //跳转到书架
                                });

                            });
                            break;
                        default ://绑定失败
                            console.log("绑定失败");
                            _self._showTip(AppTips.bindFailMsg);
                            break;
                    }
                });
            });
        }


        _self.hideBindPanel = function () {
            _self.controls.bindOverlay.hide();
        }

        _self.showBindPanel = function (msg) {
            _self.controls.bindOverlay.show();
            _self.controls.bindTipsMsgPanel.html(msg);
        }

        this._showTip = function (msg) {
            _self.controls.bindResultTipsPanel.html(msg);
            _self.controls.bindResultTipsPanel.show();
        }
    }

    UserBindManager.prototype = new UserBindManager();
    UserBindManager.prototype.constructor = UserBindManager;

    exports.UserBindManager = UserBindManager;
});

