﻿///<jscompress sourcefile="security.js" />
/*
 * RSA, a suite of routines for performing RSA public-key computations in JavaScript.
 * Copyright 1998-2005 David Shapiro.
 * Dave Shapiro
 * dave@ohdave.com 
 * changed by Fuchun, 2010-05-06
 * fcrpg2005@gmail.com
 *////<jscompress sourcefile="sso.js" />
/*
 * 文件名: sso.js
 * 描述: 提供对 CAS 单点登录的封装
 *
 * 功能说明：
 * 实现多个应用之间的单点登录（SSO）功能，应用可以部署在不同的域名。
 *
 */(function(p){function t(b){var d=a,c=d.biDivideByRadixPower(b,this.k-1),c=d.biMultiply(c,this.mu),c=d.biDivideByRadixPower(c,this.k+1);b=d.biModuloByRadixPower(b,this.k+1);c=d.biMultiply(c,this.modulus);c=d.biModuloByRadixPower(c,this.k+1);b=d.biSubtract(b,c);b.isNeg&&(b=d.biAdd(b,this.bkplus1));for(c=0<=d.biCompare(b,this.modulus);c;)b=d.biSubtract(b,this.modulus),c=0<=d.biCompare(b,this.modulus);return b}function k(b,d){var c=a.biMultiply(b,d);return this.modulo(c)}function n(b,d){var c=new h;c.digits[0]=1;for(var f=b,l=d;;){0!=(l.digits[0]&1)&&(c=this.multiplyMod(c,f));l=a.biShiftRight(l,1);if(0==l.digits[0]&&0==a.biHighIndex(l))break;f=this.multiplyMod(f,f)}return c}if("undefined"===typeof p.RSAUtils)var a=p.RSAUtils={};var e,g,v,q,h=p.BigInt=function(b){this.digits="boolean"==typeof b&&1==b?null:g.slice(0);this.isNeg=!1};a.setMaxDigits=function(b){e=b;g=Array(e);for(b=0;b<g.length;b++)g[b]=0;v=new h;q=new h;q.digits[0]=1};a.setMaxDigits(20);a.biFromNumber=function(b){var d=new h;d.isNeg=0>b;b=Math.abs(b);for(var c=0;0<b;)d.digits[c++]=b&65535,b=Math.floor(b/65536);return d};var m=a.biFromNumber(1E15);a.biFromDecimal=function(b){for(var d="-"==b.charAt(0),c=d?1:0,f;c<b.length&&"0"==b.charAt(c);)++c;if(c==b.length)f=new h;else{var l=(b.length-c)%15;0==l&&(l=15);f=a.biFromNumber(Number(b.substr(c,l)));for(c+=l;c<b.length;)f=a.biAdd(a.biMultiply(f,m),a.biFromNumber(Number(b.substr(c,15)))),c+=15;f.isNeg=d}return f};a.biCopy=function(b){var d=new h(!0);d.digits=b.digits.slice(0);d.isNeg=b.isNeg;return d};a.reverseStr=function(b){for(var d="",c=b.length-1;-1<c;--c)d+=b.charAt(c);return d};var u="0123456789abcdefghijklmnopqrstuvwxyz".split("");a.biToString=function(b,d){var c=new h;c.digits[0]=d;for(var f=a.biDivideModulo(b,c),l=u[f[1].digits[0]];1==a.biCompare(f[0],v);)f=a.biDivideModulo(f[0],c),digit=f[1].digits[0],l+=u[f[1].digits[0]];return(b.isNeg?"-":"")+a.reverseStr(l)};a.biToDecimal=function(b){var d=new h;d.digits[0]=10;for(var c=a.biDivideModulo(b,d),f=String(c[1].digits[0]);1==a.biCompare(c[0],v);)c=a.biDivideModulo(c[0],d),f+=String(c[1].digits[0]);return(b.isNeg?"-":"")+a.reverseStr(f)};var r="0123456789abcdef".split("");a.digitToHex=function(b){var d="";for(i=0;4>i;++i)d+=r[b&15],b>>>=4;return a.reverseStr(d)};a.biToHex=function(b){var d="";a.biHighIndex(b);for(var c=a.biHighIndex(b);-1<c;--c)d+=a.digitToHex(b.digits[c]);return d};a.charToHex=function(b){return 48<=b&&57>=b?b-48:65<=b&&90>=b?10+b-65:97<=b&&122>=b?10+b-97:0};a.hexToDigit=function(b){for(var d=0,c=Math.min(b.length,4),f=0;f<c;++f)d<<=4,d|=a.charToHex(b.charCodeAt(f));return d};a.biFromHex=function(b){for(var d=new h,c=b.length,f=0;0<c;c-=4,++f)d.digits[f]=a.hexToDigit(b.substr(Math.max(c-4,0),Math.min(c,4)));return d};a.biFromString=function(b,d){var c="-"==b.charAt(0),f=c?1:0,l=new h,e=new h;e.digits[0]=1;for(var w=b.length-1;w>=f;w--)var g=b.charCodeAt(w),g=a.charToHex(g),g=a.biMultiplyDigit(e,g),l=a.biAdd(l,g),e=a.biMultiplyDigit(e,d);l.isNeg=c;return l};a.biDump=function(b){return(b.isNeg?"-":"")+b.digits.join(" ")};a.biAdd=function(b,d){var c;if(b.isNeg!=d.isNeg)d.isNeg=!d.isNeg,c=a.biSubtract(b,d),d.isNeg=!d.isNeg;else{c=new h;for(var f=0,l=0;l<b.digits.length;++l)f=b.digits[l]+d.digits[l]+f,c.digits[l]=f%65536,f=Number(65536<=f);c.isNeg=b.isNeg}return c};a.biSubtract=function(b,d){var c;if(b.isNeg!=d.isNeg)d.isNeg=!d.isNeg,c=a.biAdd(b,d),d.isNeg=!d.isNeg;else{c=new h;for(var f,l=f=0;l<b.digits.length;++l)f=b.digits[l]-d.digits[l]+f,c.digits[l]=f%65536,0>c.digits[l]&&(c.digits[l]+=65536),f=0-Number(0>f);if(-1==f){for(l=f=0;l<b.digits.length;++l)f=0-c.digits[l]+f,c.digits[l]=f%65536,0>c.digits[l]&&(c.digits[l]+=65536),f=0-Number(0>f);c.isNeg=!b.isNeg}else c.isNeg=b.isNeg}return c};a.biHighIndex=function(b){for(var d=b.digits.length-1;0<d&&0==b.digits[d];)--d;return d};a.biNumBits=function(b){var d=a.biHighIndex(b);b=b.digits[d];var d=16*(d+1),c;for(c=d;c>d-16&&0==(b&32768);--c)b<<=1;return c};a.biMultiply=function(b,d){for(var c=new h,f,l=a.biHighIndex(b),e=a.biHighIndex(d),w,g=0;g<=e;++g){f=0;w=g;for(j=0;j<=l;++j,++w)f=c.digits[w]+b.digits[j]*d.digits[g]+f,c.digits[w]=f&65535,f>>>=16;c.digits[g+l+1]=f}c.isNeg=b.isNeg!=d.isNeg;return c};a.biMultiplyDigit=function(b,d){var c,f;result=new h;c=a.biHighIndex(b);for(var l=f=0;l<=c;++l)f=result.digits[l]+b.digits[l]*d+f,result.digits[l]=f&65535,f>>>=16;result.digits[1+c]=f;return result};a.arrayCopy=function(b,d,c,a,l){for(l=Math.min(d+l,b.length);d<l;++d,++a)c[a]=b[d]};var y=[0,32768,49152,57344,61440,63488,64512,65024,65280,65408,65472,65504,65520,65528,65532,65534,65535];a.biShiftLeft=function(b,d){var c=Math.floor(d/16),f=new h;a.arrayCopy(b.digits,0,f.digits,c,f.digits.length-c);for(var c=d%16,l=16-c,e=f.digits.length-1,g=e-1;0<e;--e,--g)f.digits[e]=f.digits[e]<<c&65535|(f.digits[g]&y[c])>>>l;f.digits[0]=f.digits[e]<<c&65535;f.isNeg=b.isNeg;return f};var x=[0,1,3,7,15,31,63,127,255,511,1023,2047,4095,8191,16383,32767,65535];a.biShiftRight=function(b,d){var c=Math.floor(d/16),f=new h;a.arrayCopy(b.digits,c,f.digits,0,b.digits.length-c);for(var c=d%16,l=16-c,e=0,g=e+1;e<f.digits.length-1;++e,++g)f.digits[e]=f.digits[e]>>>c|(f.digits[g]&x[c])<<l;f.digits[f.digits.length-1]>>>=c;f.isNeg=b.isNeg;return f};a.biMultiplyByRadixPower=function(b,d){var c=new h;a.arrayCopy(b.digits,0,c.digits,d,c.digits.length-d);return c};a.biDivideByRadixPower=function(b,d){var c=new h;a.arrayCopy(b.digits,d,c.digits,0,c.digits.length-d);return c};a.biModuloByRadixPower=function(b,d){var c=new h;a.arrayCopy(b.digits,0,c.digits,0,d);return c};a.biCompare=function(b,d){if(b.isNeg!=d.isNeg)return 1-2*Number(b.isNeg);for(var c=b.digits.length-1;0<=c;--c)if(b.digits[c]!=d.digits[c])return b.isNeg?1-2*Number(b.digits[c]>d.digits[c]):1-2*Number(b.digits[c]<d.digits[c]);return 0};a.biDivideModulo=function(b,d){var c=a.biNumBits(b),f=a.biNumBits(d),l=d.isNeg,e,g;if(c<f)return b.isNeg?(e=a.biCopy(q),e.isNeg=!d.isNeg,b.isNeg=!1,d.isNeg=!1,g=biSubtract(d,b),b.isNeg=!0,d.isNeg=l):(e=new h,g=a.biCopy(b)),[e,g];e=new h;g=b;for(var m=Math.ceil(f/16)-1,k=0;32768>d.digits[m];)d=a.biShiftLeft(d,1),++k,++f,m=Math.ceil(f/16)-1;g=a.biShiftLeft(g,k);c=Math.ceil((c+k)/16)-1;for(f=a.biMultiplyByRadixPower(d,c-m);-1!=a.biCompare(g,f);)++e.digits[c-m],g=a.biSubtract(g,f);for(;c>m;--c){var f=c>=g.digits.length?0:g.digits[c],r=c-1>=g.digits.length?0:g.digits[c-1],n=c-2>=g.digits.length?0:g.digits[c-2],u=m>=d.digits.length?0:d.digits[m],v=m-1>=d.digits.length?0:d.digits[m-1];e.digits[c-m-1]=f==u?65535:Math.floor((65536*f+r)/u);for(var p=e.digits[c-m-1]*(65536*u+v),x=4294967296*f+(65536*r+n);p>x;)--e.digits[c-m-1],p=e.digits[c-m-1]*(65536*u|v),x=4294967296*f+(65536*r+n);f=a.biMultiplyByRadixPower(d,c-m-1);g=a.biSubtract(g,a.biMultiplyDigit(f,e.digits[c-m-1]));g.isNeg&&(g=a.biAdd(g,f),--e.digits[c-m-1])}g=a.biShiftRight(g,k);e.isNeg=b.isNeg!=l;b.isNeg&&(e=l?a.biAdd(e,q):a.biSubtract(e,q),d=a.biShiftRight(d,k),g=a.biSubtract(d,g));0==g.digits[0]&&0==a.biHighIndex(g)&&(g.isNeg=!1);return[e,g]};a.biDivide=function(b,d){return a.biDivideModulo(b,d)[0]};a.biModulo=function(b,d){return a.biDivideModulo(b,d)[1]};a.biMultiplyMod=function(b,d,c){return a.biModulo(a.biMultiply(b,d),c)};a.biPow=function(b,d){for(var c=q,f=b;;){0!=(d&1)&&(c=a.biMultiply(c,f));d>>=1;if(0==d)break;f=a.biMultiply(f,f)}return c};a.biPowMod=function(b,d,c){for(var f=q;;){0!=(d.digits[0]&1)&&(f=a.biMultiplyMod(f,b,c));d=a.biShiftRight(d,1);if(0==d.digits[0]&&0==a.biHighIndex(d))break;b=a.biMultiplyMod(b,b,c)}return f};p.BarrettMu=function(b){this.modulus=a.biCopy(b);this.k=a.biHighIndex(this.modulus)+1;b=new h;b.digits[2*this.k]=1;this.mu=a.biDivide(b,this.modulus);this.bkplus1=new h;this.bkplus1.digits[this.k+1]=1;this.modulo=t;this.multiplyMod=k;this.powMod=n};var z=function(b,d,c){var f=a;this.e=f.biFromHex(b);this.d=f.biFromHex(d);this.m=f.biFromHex(c);this.chunkSize=2*f.biHighIndex(this.m);this.radix=16;this.barrett=new p.BarrettMu(this.m)};a.getKeyPair=function(b,d,c){return new z(b,d,c)};"undefined"===typeof p.twoDigit&&(p.twoDigit=function(b){return(10>b?"0":"")+String(b)});a.encryptedString=function(b,d){for(var c=[],f=d.length,e=0;e<f;)c[e]=d.charCodeAt(e),e++;for(;0!=c.length%b.chunkSize;)c[e++]=0;for(var g=c.length,f="",m,k,r,e=0;e<g;e+=b.chunkSize){r=new h;m=0;for(k=e;k<e+b.chunkSize;++m)r.digits[m]=c[k++],r.digits[m]+=c[k++]<<8;k=b.barrett.powMod(r,b.e);k=16==b.radix?a.biToHex(k):a.biToString(k,b.radix);f+=k+" "}c="";e=f.split(" ");for(k=e.length;1<=k;k--)c+=e[k-1];return c};a.decryptedString=function(b,d){var c=d.split(" "),f="",e,g,h;for(e=0;e<c.length;++e)for(g=16==b.radix?a.biFromHex(c[e]):a.biFromString(c[e],b.radix),h=b.barrett.powMod(g,b.d),g=0;g<=a.biHighIndex(h);++g)f+=String.fromCharCode(h.digits[g]&255,h.digits[g]>>8);0==f.charCodeAt(f.length-1)&&(f=f.substring(0,f.length-1));return f};a.setMaxDigits(130)})(window);(function(p){function t(){var a=window.location.href;if(Url.queryString("nextpage",a)===p)h.loginRedirectUrl=h.needAttribute?Url.addParams({from:"ew"},h.loginRedirectUrl):h.loginRedirectUrl;else{var e=Url.queryString("nextpage",a);h.loginRedirectUrl=Base64.decode(e)}Url.queryString("client",a)!==p&&(h.client=Url.queryString("client",a));Url.queryString("appId",h.loginRedirectUrl)!==p&&(h.appKey=Url.queryString("appId",h.loginRedirectUrl))}function k(a){var e=h.SSOServerUrl+"/login?service\x3d"+encodeURIComponent(h.loginRedirectUrl);$.ajax({url:e,type:"GET",dataType:"jsonp",jsonp:"callback",crossDomain:!0,cache:!1,success:function(e){e=$.trim(e).replace(/\t/g,"");e=q(e);e.result&&"success"==e.result?1001==parseInt(e.code)&&e.data&&e.data.st?g(function(){setTimeout(function(){k(a)},100)}):(params={lt:e.data.lt,execution:e.data.execution},a(params)):a(p)},error:function(e){a(p)}})}function n(e,g,r){t(h.needAttribute,h.appKey,h.client,h.loginRedirectUrl);encodeURIComponent(h.loginRedirectUrl);k(function(k){if(k===p)r({result:"fail",code:"-1",data:"\u767b\u5f55\u5931\u8d25\uff0c\u51fa\u73b0\u5f02\u5e38\uff01"});else{var m={};m.username=e;var u=RSAUtils.getKeyPair("010001","","008c147f73c2593cba0bd007e60a89ade5");m.password=RSAUtils.encryptedString(u,g);m.encode=!0;m.sourceappname=h.appName;m.key=v(e);m._eventId="submit";m.lt=k.lt;m.execution=k.execution;m.appId=h.appKey;k=h.SSOServerUrl+"/login?service\x3d"+encodeURIComponent(h.loginRedirectUrl);$.ajax({url:k,type:"POST",dataType:"jsonp",jsonp:"callback",data:m,crossDomain:!0,cache:!1,success:function(b){b=$.trim(b).replace(/\t/g,"");var d=q(b);d.result&&"success"==d.result&&1E3==parseInt(d.code)&&!h._retry?(h._retry=!0,n(e,g,r)):(h._retry=!1,d.params=params,!1===h.isCenterSSO?a(d.data.tgt,function(){r(d)}):r(d))},error:function(b){h._retry=!1;r({result:"fail",code:"-1",data:"\u767b\u5f55\u5931\u8d25\uff0c\u51fa\u73b0\u5f02\u5e38\uff01"})}})}})}function a(a,e){$.ajax({url:h.SSOCenterServerUrl+"/login?ticketGrantingTicketIdFromAreaSSO\x3d"+a,type:"GET",dataType:"jsonp",jsonp:"callback",crossDomain:!0,cache:!1,success:function(a){e()},error:function(a){e()}})}function e(a,e,g){var k=h.SSOServerUrl+"/v1/validation",m={};m.service=e;m.ticket=a;$.ajax({url:k,type:"GET",dataType:"jsonp",jsonp:"callback",data:m,crossDomain:!0,cache:!1,success:function(a){g&&g(a)},error:function(a){a={result:"fail",code:"-1",data:"\u6821\u9a8c\u5931\u8d25\uff0c\u51fa\u73b0\u5f02\u5e38\uff01"};g&&g(a)}})}function g(a){$.ajax({url:h.SSOServerUrl+"/logout",type:"GET",dataType:"jsonp",jsonp:"callback",crossDomain:!0,cache:!1,success:function(e){e=$.trim(e).replace(/\t/g,"");e=q(e);e.result&&"success"==e.result&&a(e)},error:function(e){a({result:"fail",code:"-1",data:"\u767b\u51fa\u5931\u8d25\uff0c\u51fa\u73b0\u5f02\u5e38\uff01"})}})}function v(a){var e=/^1[3-9]\d{9}$/,g="login_name";a.match(/^[0-9a-z]([._]?[0-9a-z])+@([0-9a-z][-\w]*[0-9a-z]\.)+[a-z]{2,9}$/)?g="login_email":a.match(e)&&(g="login_mobile");return g}function q(a){return eval("("+a+")")}var h={_version:"1.1.0.20160928",appName:"edc",appKey:"fault-appkey",client:"web",SSOServerUrl:"http://xf.sso.cycore.cn/sso",loginRedirectUrl:"http://i.changyan.com/icloud",SSOCenterServerUrl:"http://open.changyan.com/sso",isCenterSSO:!0,needAttribute:!0,_retry:!1,login:function(a,e,g){n(a,e,g)},logout:function(a){g(a)},getLoginTicket:function(a){k(a)},validateServiceTicket:function(a,g,h){e(a,g,h)}};window.SSO=window.SSO||h})();(function(p){var t=window.location,k=t.href,n=/\#.*$/,a={removeHash:function(a){return(a||k).replace(n,"")},getHash:function(a){return(a=(a||k).match(n))&&a[0]?a[0]:""},removeParams:function(e,g){g=g||k;var n=a.getHash(g);g=this.removeHash(g);var q;for(q=e.length-1;0<=q;q--)g=g.replace(new RegExp("(?:[\\?\\\x26]("+e[q]+"\x3d[^\x26]*))","g"),"");g=g.replace(/\&+/,"\x26").replace(/[\&]+$/,"").replace(/[\?]+$/,"")+n;return/^[^?]*\&/.test(g)?g.replace("\x26","?"):g},addParams:function(e,g){g=g||k;var n=[],q=[],h=a.getHash(g);g=this.removeHash(g);for(var m in e)e.hasOwnProperty(m)&&(n.push(m),q.push(m+"\x3d"+encodeURIComponent(e[m])));g=this.removeParams(n,g);return g+(q[0]?(-1===g.indexOf("?")?"?":"\x26")+q.join("\x26"):"")+h},queryString:function(a,g){var e=this.getParams(g);return null!=e[a]?e[a]:p},getParams:function(a){a=-1===a.indexOf("?")?[]:a.substr(a.indexOf("?")+1).split("\x26");for(var e=0,k=a.length,n={},h;e<k;e++)h=a[e].indexOf("\x3d"),0<h&&(n[a[e].substring(0,h)]=decodeURIComponent(a[e].substring(h+1)));return n},getUrl:function(){return t.protocol+"//"+t.host+t.pathname},redirect:function(a){t.href=a;try{window.event.returnValue=!1}catch(g){}}};window.Url=a})();(function(p){var t={_keyStr:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/\x3d",encode:function(k){var n="",a,e,g,p,q,h,m=0;for(k=t._utf8_encode(k);m<k.length;)a=k.charCodeAt(m++),e=k.charCodeAt(m++),g=k.charCodeAt(m++),p=a>>2,a=(a&3)<<4|e>>4,q=(e&15)<<2|g>>6,h=g&63,isNaN(e)?q=h=64:isNaN(g)&&(h=64),n=n+this._keyStr.charAt(p)+this._keyStr.charAt(a)+this._keyStr.charAt(q)+this._keyStr.charAt(h);return n},decode:function(k){var n="",a,e,g,p,q,h=0;for(k=k.replace(/[^A-Za-z0-9+/=]/g,"");h<k.length;)a=this._keyStr.indexOf(k.charAt(h++)),e=this._keyStr.indexOf(k.charAt(h++)),p=this._keyStr.indexOf(k.charAt(h++)),q=this._keyStr.indexOf(k.charAt(h++)),a=a<<2|e>>4,e=(e&15)<<4|p>>2,g=(p&3)<<6|q,n+=String.fromCharCode(a),64!=p&&(n+=String.fromCharCode(e)),64!=q&&(n+=String.fromCharCode(g));return n=t._utf8_decode(n)},_utf8_encode:function(k){k=k.replace(/rn/g,"n");for(var n="",a=0;a<k.length;a++){var e=k.charCodeAt(a);128>e?n+=String.fromCharCode(e):(127<e&&2048>e?n+=String.fromCharCode(e>>6|192):(n+=String.fromCharCode(e>>12|224),n+=String.fromCharCode(e>>6&63|128)),n+=String.fromCharCode(e&63|128))}return n},_utf8_decode:function(k){var n="",a=0,e;for(c1=c2=0;a<k.length;)e=k.charCodeAt(a),128>e?(n+=String.fromCharCode(e),a++):191<e&&224>e?(c2=k.charCodeAt(a+1),n+=String.fromCharCode((e&31)<<6|c2&63),a+=2):(c2=k.charCodeAt(a+1),c3=k.charCodeAt(a+2),n+=String.fromCharCode((e&15)<<12|(c2&63)<<6|c3&63),a+=3);return n}};window.Base64=t})();