/**
 * 评测卡片模板功能类
 * Created with JetBrains WebStorm.
 * User: qmjie
 * Date: 13-8-28
 * Time: 下午2:06
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports, module) {
    require('jquery');
    var shellcmd = require('../../../common/shellcmd');
    var md5helper = require('../../../common/md5helper');
    require('zebra_dialog');
    var ebookContext = require('../../ebookcontext').Instance;
    var define = require('../../define');

    function EvaluationCardTemplate() {
        var _self = this;
        _self.cnnum = 1 ;
        _self.ennum = 1 ;
        var _creatCardTime;

        /**
         * 中英文评测卡片模板界面按钮列表
         */
        _self.buttons = {
            evaluationTmpCHN: $("#evaluationTmpCHN"),
            evaluationTmpEN: $("#evaluationTmpEN"),
            closeBtn_evaluationTmpPanel: $("#closeBtn_evaluationTmpPanel"),
            nextBtn: $("#nextBtn"),
            modifyBtn: $("#modifyBtn"),
            createCardBtn: $("#createCardBtn"),
            smartbar_btnCnEval:$("#smartbar_btnCnEval"),
            smartbar_btnEnEval:$("#smartbar_btnEnEval")
        };
        /**
         * 中英文评测卡片模板界面控件列表
         */
        _self.controls = {
            templatePanel: $("#templatePanel"),
            evaluationTmpPanel: $("#evaluationTmpPanel"),
            evaluationTmpPanelMask: $("#evaluationTmpPanelMask"),
            evaluationTmpPanelTop: $("#evaluationTmpPanelTop"),
            evaluationDescription: $("#evaluationDescription"),
            cardEdit: $("#cardEdit"),
            evaluationTab: $("#evaluationTab"),
            evaluationTabContent: $("#evaluationTabContent"),
            evaluationTips: $("#evaluationTips"),
            evaluationEditPanel: $("#evaluationEditPanel"),
            previewPanel: $("#previewPanel"),
            cardBot: $("#cardBot")
        };

        //中英文卡片界面内容
        _self.cardEdit = "";
        _self.evaluationTab = "";
        _self.evaluationTabContent = "";
        _self.evaluationTips = "";

        //中文识别结果临时存放处
        _self.cnStr = "";

        /**
         * 评测卡片类型
         */
        _self.cardtype = "";

        /**
         * 初始化评测卡片模板
         */
        _self.init = function (bookContainer) {
            _self.bookContainer = bookContainer;

            // 中文评测模板
            _self.buttons.evaluationTmpCHN.click(function () {
                if (!ebookContext.getUser().getIsOnline()) {
                    _self.showTips(AppTips.LocalLoignMsg);
                } else {
                    _self.showEvaluationTmpPanel("cn_word");
                }
            });

            //smartbar 中文评测
           _self.buttons.smartbar_btnCnEval.click(function(){
               if (!ebookContext.getUser().getIsOnline()) {
                   _self.showTips(AppTips.LocalLoignMsg);
               } else {
                   _self.showEvaluationTmpPanel("cn_word");
               }

               //监管
               var action = LogManager.action.trigger;
               var params = {};
               params.module = '1130312';
               var user_id = ebookContext.getUser().getUid();
               if(user_id != '0' && user_id){
                   params.user_id =user_id;
               }
               LogManager.statistics(action,params);
           });

            //英文评测模板
            _self.buttons.evaluationTmpEN.click(function () {
                if (!ebookContext.getUser().getIsOnline()) {
                    _self.showTips(AppTips.LocalLoignMsg);
                } else {
                    _self.showEvaluationTmpPanel("en_word");
                }

            });
            //smartbar 英文评测
            _self.buttons.smartbar_btnEnEval.click(function(){
                if (!ebookContext.getUser().getIsOnline()) {
                    _self.showTips(AppTips.LocalLoignMsg);
                } else {
                    _self.showEvaluationTmpPanel("en_word");
                }

                //监管
                var action = LogManager.action.trigger;
                var params = {};
                params.module = '1130313';
                var user_id = ebookContext.getUser().getUid();
                if(user_id != '0' && user_id){
                    params.user_id =user_id;
                }
                LogManager.statistics(action,params);

            });

            //关闭评测模板界面
            _self.buttons.closeBtn_evaluationTmpPanel.click(function () {
                _self.hideEvaluationTmpPanel();
            });

            //下一步
            _self.buttons.nextBtn.click(function () {
                _self.nextStep();
            });

            //修改按钮
            _self.buttons.modifyBtn.click(function () {
                _self.modify();
            });

            //生成卡片
            _self.buttons.createCardBtn.click(function () {
                if (_self.cardtype === "en_word")
                    _self.createEnCard();
                else if (_self.cardtype === "cn_word")
                    _self.createCnCard();
            });

        };

        /**
         * 显示发音卡片模板面板
         * @param type 评测卡片类型 中文:cn_word 英文：en_word
         */
        _self.showEvaluationTmpPanel = function (type) {
            if (!type) return;
            //移除evaluationDescription的所有事件处理程序
            _self.controls.evaluationDescription.val("");
            _self.controls.evaluationDescription.unbind();
            _self.buttons.nextBtn.attr("disabled", true);
            _self.buttons.nextBtn.removeClass();
            _self.buttons.nextBtn.addClass("btn_gray_disable");

            _self.cardtype = type;
            if (_self.cardtype === "en_word") {
                _self.showEnEvaluationTmp();
            }
            else if (_self.cardtype === "cn_word") {
                _self.showCnEvaluationTmp();
            }
            else {
                return;
            }
            //居中显示
            _self.controls.evaluationTmpPanel.css({
                position: 'absolute',
                left: ($(window).width() - _self.controls.evaluationTmpPanel.outerWidth()) / 2,
                top: ($(window).height() - _self.controls.evaluationTmpPanel.outerHeight()) / 2 + $(document).scrollTop()
            });
            //弹出发音卡片模板面板
            _self.controls.evaluationTmpPanel.show();
            _self.controls.templatePanel.hide();
            //窗口拖动
            _self.controls.evaluationTmpPanelMask.hide();
            _self.controls.evaluationTmpPanel.draggable({
                handle: "#" + _self.controls.evaluationTmpPanelTop.attr("id"),
                containment: "parent",
                start: function () {
                    _self.controls.evaluationTmpPanelMask.show();
                },
                stop: function () {
                    _self.controls.evaluationTmpPanelMask.hide();
                }
            });
            _self.controls.evaluationDescription.focus();
        };

        /**
         * 显示中文评测卡片界面
         */
        _self.showCnEvaluationTmp = function () {
            _self.controls.evaluationDescription.bind('input propertychange', function () {
                //判断中英文字符
                var entryVal = _self.controls.evaluationDescription.val();
                entryVal = entryVal.replace(/[^\u4e00-\u9fa5\s,\uff0c]/g, '');

                var strArr = entryVal.split(/[\s,\uff0c]+/);

                entryVal = strArr.join(' ');
                var cnChar = entryVal.match(/[^\x00-\x80]/g);//利用match方法检索出中文字符并返回一个存放中文的数组
                _self.cnStr = cnChar;
                _self.buttons.nextBtn.attr("disabled", (cnChar == null || entryVal == "") ? true : false);
                var className = (cnChar == null || entryVal == "") ? "btn_gray_disable" : "btn_green";
                _self.buttons.nextBtn.removeClass();
                _self.buttons.nextBtn.addClass(className);

                //限定输入字数不超过100
                if (entryVal.length > 100) {
                    _self.controls.evaluationDescription.val(entryVal.substr(0, 100));
                    //_self.showTips("输入字数不超过100");
                }
            });

            _self.controls.cardEdit.html(AppCardTemplateTipsList.CnCardEdit);
            _self.controls.evaluationTab.html(AppCardTemplateTipsList.CnEvaluationTab);
            _self.controls.evaluationTabContent.html(AppCardTemplateTipsList.CnEvaluationTabContent);
            _self.controls.evaluationTips.html(AppCardTemplateTipsList.CnEvaluationTips);
            if(AppCfg.lang == "uyghur"){
                _self.controls.evaluationTabContent.css("direction","rtl");
            }
            _self.evaluationTabContent = AppCardTemplateTipsList.CnEvaluationTabContent;
        };

        /**
         * 显示英文评测卡片界面
         */
        _self.showEnEvaluationTmp = function () {
            _self.controls.evaluationDescription.bind('input propertychange', function () {
                //判断中英文字符
                var entryVal = _self.controls.evaluationDescription.val();
                var cnChar = entryVal.match(/[a-zA-Z]/g);//利用match方法检索出中文字符并返回一个存放中文的数组
                _self.buttons.nextBtn.attr("disabled", (cnChar == null || entryVal == "") ? true : false);
                var className = (cnChar == null || entryVal == "") ? "btn_gray_disable" : "btn_green";
                _self.buttons.nextBtn.removeClass();
                _self.buttons.nextBtn.addClass(className);

                //限定输入字符数不超过200
                if (entryVal.length > 200) {
                    _self.controls.evaluationDescription.val(entryVal.substr(0, 200));
                    //_self.showTips("输入字数不超过200");
                }
            });
            _self.controls.cardEdit.html(AppCardTemplateTipsList.EnCardEdit);
            _self.controls.evaluationTab.html(AppCardTemplateTipsList.EnEvaluationTab);
            _self.controls.evaluationTabContent.html(AppCardTemplateTipsList.EnEvaluationTabContent);
            _self.controls.evaluationTips.html(AppCardTemplateTipsList.EnEvaluationTips);
            if(AppCfg.lang == "uyghur"){
                _self.controls.evaluationTabContent.css("direction","rtl");
            }

            _self.evaluationTabContent = AppCardTemplateTipsList.EnEvaluationTabContent;
        };

        /**
         *隐藏发音卡片模板面板
         */
        _self.hideEvaluationTmpPanel = function () {
            _self.clearEvaluationData();
            _self.controls.evaluationTmpPanel.hide();
        };

        /**
         * 发音卡片模板退出时清除卡片数据
         */
        _self.clearEvaluationData = function () {
            //回退至初始界面即编辑界面，
            _self.modify();
            _self.controls.evaluationDescription.val("");
            _self.buttons.nextBtn.attr("disabled", true);
            _self.buttons.nextBtn.removeClass();
            _self.buttons.nextBtn.addClass("btn_gray_disable");
        };

        /**
         * 下一步操作
         */
        _self.nextStep = function () {
            //进入预览界面
            _self.controls.evaluationEditPanel.hide();
            //预览提示文字
            _self.controls.evaluationTabContent.html(AppCardTemplateTipsList.PreviewTabContent);
            var value = _self.controls.evaluationDescription.val();

            //根据中英文卡片模板类型提取中英文内容
            if (_self.cardtype == "cn_word") {
                value = value.replace(/[^\u4e00-\u9fa5\s,\uff0c]/g, '');
                var strArr = value.split(/[\s,\uff0c]+/);
                //-----以下代码由 pengfu 增加，为展示正常，当用户连续输入超过15个汉字时，将这15个汉字拆分成多个字词
                var newStrArr = [];
                for(var j = 0,len = strArr.length;j < len ;j++){
//                    strArr[j] = strArr[j].substr(0,15);
                    if(strArr[j].length > 15){
                        for(var k= 0,count = Math.ceil(strArr[j].length/15);k<count;k++){
                            newStrArr.push(strArr[j].substr(0+k*15,15));
                        }
                    }else{
                        newStrArr.push(strArr[j]);
                    }

                }
                value = newStrArr.join(' ');
                //-----以上代码由 pengfu 增加
//                value = strArr.join(' ');
            } else if (_self.cardtype == "en_word") {
                value = value.replace(/[^a-zA-Z\'\s,\uff0c]/g, '');
                var strArr = value.split(/[\s,\uff0c]+/);
                value = strArr.join(' ');
            }

            _self.controls.previewPanel.html(value);
            //预览内容
            _self.controls.previewPanel.show();
            //预览卡片操作选项
            _self.controls.cardBot.show();
            //底部操作按钮，修改和创建卡片按钮
            _self.buttons.nextBtn.hide();
            _self.buttons.modifyBtn.show();
            _self.buttons.createCardBtn.show();
        };

        /**
         * 修改操作
         */
        _self.modify = function () {
            //回退至卡片编辑界面
            _self.controls.evaluationEditPanel.show();
            //evaluationTabContent
            _self.controls.evaluationTabContent.html(_self.evaluationTabContent);
            //预览内容
            _self.controls.previewPanel.hide();
            //预览卡片操作选项
            _self.controls.cardBot.hide();
            //底部操作按钮，下一步按钮
            _self.buttons.nextBtn.show();
            _self.buttons.modifyBtn.hide();
            _self.buttons.createCardBtn.hide();
        };

        /**
         * 显示提示内容
         */
        _self.showTips = function (tips) {
            //console.error("网络连接失败，请检查网络");
            $.Zebra_Dialog(tips, {
                'type': 'information',
                'title': AppTips.WarmTips,
                'buttons': [ AppTips.OkTips]
            });
        };

        /**
         * 设定卡片生成定时器，如超过60秒，则提示用户卡片生成失败
         */
        _self.setCardTimeout = function () {
            _creatCardTime = setTimeout(function () {
                _self.showTips(AppCardTemplateTipsList.CreatCardsFail);
                _self.clearCardTimeout();
            }, AppCfg.createCardsTimeOut);
        };

        /**
         * 清除卡片生成定时器
         */
        _self.clearCardTimeout = function () {
            clearTimeout(_creatCardTime);
            _creatCardTime = null;
            hideLoading();
            //设置创建卡片按钮disabled为false
            _self.buttons.createCardBtn.attr("disabled", false);
        };

        /**
         * 检测定时器是否关闭
         */
        _self.timeoutIsExist = function () {
            return _creatCardTime != null;
        };

        /**
         * 创建英文发音评测卡片模板，将英文发音评测信息写入json文件
         */
        _self.createEnCard = function () {
            showLoading({tips: AppCardTemplateTipsList.CreatingCards});
            //设定定时器，超过定时器设定的时间，则提示用户卡片生成失败
            _self.setCardTimeout();
            //设置创建卡片按钮disabled为true
            _self.buttons.createCardBtn.attr("disabled", true);
            shellcmd.checkOnline().done(function (isNetWorking) {
                if (!isNetWorking) {
                    _self.showTips(AppTips.NetWorkConnectFailed);
                    _self.clearCardTimeout();
                    return;
                }

                //创建发音模板存放目录
                var value = _self.controls.evaluationDescription.val();
                var newDirName = "单词发音评测_" + md5helper.hex_md5(value);
                _self.createTmpDir(newDirName).done(function (dir) {
                    if (!dir) {
                        _self.clearCardTimeout();
                        return;
                    }
                    var speecher = "mary";//henry 男 marry 女
                    //英文合成
                    _self.enTTS(dir, value, speecher);
                });
            });
        };

        /**
         * 英文合成
         * @param dir
         * @param value
         * @param speecher
         */
        _self.enTTS = function (dir, value, speecher) {
            var wavArrJson = [];//存储json文件中的内容
            //提取英文内容
            value = value.replace(/[^a-zA-Z\'\s,\uff0c]/g, '');
            value = value.replace(/^[,\s\uff0c]+|[,\s\uff0c]+$/g, '');//去除字符串中的左右空格
            var wavArr = value.split(/[\s,\uff0c]+/); //处理单词间存在逗号和空格的情况
            console.time("单词发音评测");
            shellcmd.initTTS().done(function () {
                var callNum = wavArr.length;
                var wavArrLen = wavArr.length;
                /*enTTS_2是由于cef不稳定写的一个很挫的方法，类似于递归，但没办法，为了解决异步的问题*/
                var enTTS_2 = function(i){
                    var def = $.Deferred();
                    if(i>=wavArrLen){
                        def.resolve();
                    }
                    else{
                        console.log(wavArr[i]);
                        shellcmd.text2speech2(wavArr[i], speecher, dir + "/" + wavArr[i] + ".wav").done(function (json) {
                            if (json.length > 4) {
                            }
                            if(i == wavArrLen-1){
                                //若定时器不存在，说明已超时，放弃卡片生成操作
                                if (!_self.timeoutIsExist()) {
                                    //设置创建卡片按钮disabled为false
                                    _self.buttons.createCardBtn.attr("disabled", false);
                                    return;
                                }

                                //根据用户输入内容顺序拼接json文件内容
                                for (var j = 0; j < wavArr.length; j++) {
                                    //生成json信息
                                    var wavJson = {word: wavArr[j], audio: wavArr[j] + ".wav"};
                                    wavArrJson.push(wavJson);
                                }
                                var cardInfo = {"cardtype": _self.cardtype, "thumbnail": '', "title": '', "keywords": 'test', "words": wavArrJson};
                                console.log(JSON.stringify(cardInfo));
                                shellcmd.saveFile(JSON.stringify(cardInfo), dir + '/meta.json');

                                var option = {
                                    title :  ("单词评测卡片" + _self.ennum ),
                                    userName:ebookContext.getUser().getUserName()||ebookContext.getUser().getName(),
                                    uploadTime:new Date().toLocaleString()
                                }

                                _self.ennum ++ ;

                                //在主界面上添加发音卡片图标e(),upl
                                _self.bookContainer.insertSingleWidget(dir, define.WidgetType.Evaluate, _self.cardtype,option);
                                //卡片生成成功，清除定时器
                                _self.clearCardTimeout();
                                //关闭发音卡片模板对话框
                                _self.hideEvaluationTmpPanel();
                                console.timeEnd("单词发音评测");
                            }
                            enTTS_2(++i).done(function(){
                                def.resolve();
                            });
                        });
                    }
                    return def.promise();
                }
                enTTS_2(0);

            });
        };


        /**
         * 中文合成
         * @param dir       中文卡片路径
         * @param value     合成内容
         * @param speecher  合成者   默认xiaoyan 单字 wangru(发音饱满)
         * @param pyFile    拼音文件
         */
        _self.cnTTS = function (dir, value, speecher, pyFile) {
            console.time("中文合成");
            var wavArrJson = [];
            //提取中文内容
            value = value.replace(/[^\u4e00-\u9fa5\s,\uff0c]/g, '');
            value = value.replace(/^[,\s\uff0c]+|[,\s\uff0c]+$/g, '');//去除字符串中的左右空格
            var wavArr = value.split(/[\s,\uff0c]+/); //可能是逗号分开单词  .split(/[\s,]+/)正则表达式处理多个分隔符组成的字符串

            //以下代码为在页面上正常展示，当用户连续输入超过15个汉字时，将这15个汉字拆分成多个字词----pengfu
            var newWaveArr = [];
            for(var j = 0,len = wavArr.length; j < len ;j++){
//                wavArr[j] = wavArr[j].substr(0,15);
                if(wavArr[j].length > 15){
                    for(var k= 0,count = Math.ceil(wavArr[j].length/15);k<count;k++){
                        newWaveArr.push(wavArr[j].substr(0+k*15,15));
                    }
                }else{
                    newWaveArr.push(wavArr[j]);
                }
            }

            wavArr = newWaveArr;
            //以上代码为在页面上正常展示，规定每行不超过15个汉字

            console.log(wavArr);
            var pyContent = '<customizer: interphonic>\n';
//            var contentArr = [];//存储合成词对应的拼音信息
            var contentArr = "";
            shellcmd.initTTS().done(function () {
                var callNum = wavArr.length;//分组合成次数
                var wavArrLen = wavArr.length;

                /*cnTTS_2是由于cef不稳定写的一个很挫的方法，类似于递归，但没办法，为了解决异步的问题*/
                var cnTTS_2 = function(i){
                    var def = $.Deferred();
                    var fileName = ''+new Date().getTime();
                    if(i>=wavArrLen){
                        def.resolve();
                    }
                    else{

                        shellcmd.text2speech2(wavArr[i], speecher, dir + "/" + i + ".wav").done(function (audioJson) {
                            console.log(audioJson);
                            if (audioJson && audioJson != "]") {//无法连接合成服务器时"]"
                                var wavJsonObj = JSON.parse(audioJson);
                                var phraseArr = wavJsonObj[0].Sentence.Phrase;
                                var pyHzContent = "";
                                var Hz = "";
                                for (var j = 0; j < phraseArr.length; j++) {
                                    //取得合成词信息
                                    Hz += phraseArr[j].Hz;
                                    //分词对应拼音
                                    var py = phraseArr[j].Py;
                                    py = py.replace(/(\d)/g, "$1|");
                                    pyHzContent += py;
                                }

                                var lastIndex = pyHzContent.lastIndexOf("|");
                                pyHzContent = pyHzContent.substring(0, lastIndex);
                                //修正儿化音
                                pyHzContent = _self.TiddyTone(pyHzContent);
                                //console.log("pyHzContent:"+pyHzContent);
                                //记录中文合成词语对应的拼音信息，合成顺序可能不是按照用户输入的词语顺序
                                contentArr += Hz + "\n" + pyHzContent + "\n\n";
                            }

                            if(i == wavArrLen-1){
                                //若定时器不存在，说明已超时，放弃卡片生成操作
                                if (!_self.timeoutIsExist()) {
                                    //设置创建卡片按钮disabled为false
                                    _self.buttons.createCardBtn.attr("disabled", false);
                                    return;
                                }
                                //根据用户输入内容顺序拼接文件内容
                                for (var k = 0; k < wavArr.length; k++) {
//                                    //繁体字和简体字匹配不上
//                                    if(contentArr[wavArr[i]] == undefined){
//                                       flag = 1;
//                                       break;
//                                    }
                                    //生成拼音信息
                                    //    pyContent +=contentArr[wavArr[i]];
                                    //生成json信息
//                                    var wavJson = {word: wavArr[k], audio: wavArr[k] + ".wav"};
                                    var wavJson = {word: wavArr[k], audio:k + ".wav"};
                                    wavArrJson.push(wavJson);
                                    //console.log(wavArrJson)
                                }
                                pyContent += contentArr;
                                //console.log("----"+contentArr);
                                console.time("评测卡片文件");
                                console.log("拼音信息： " + pyContent);
                                //拼音文件 py.txt 生成拼音内容 并且保存py.txt文件
                                shellcmd.saveFile(pyContent, dir + '/' + pyFile);
                                var cardInfo = {"cardtype": _self.cardtype, "thumbnail": '', "title": '', "keywords": 'test', "words": wavArrJson, "py": pyFile};
                                //console.log(JSON.stringify(cardInfo));
                                shellcmd.saveFile(JSON.stringify(cardInfo), dir + '/meta.json');
                                console.timeEnd("评测卡片文件");
                                var option = {
                                    title :  ("中文评测卡片" + _self.cnnum ),
                                    userName:ebookContext.getUser().getUserName() || ebookContext.getUser().getName(),
                                    uploadTime:new Date().toLocaleString()
                                }

                                _self.cnnum ++ ;
                                //在主界面上添加发音卡片图标
                                _self.bookContainer.insertSingleWidget(dir, define.WidgetType.Evaluate, _self.cardtype,option);
                                //卡片生成成功，清除定时器
                                _self.clearCardTimeout();
                                //关闭发音卡片模板对话框
                                _self.hideEvaluationTmpPanel();
                                console.timeEnd("中文合成");
                                def.resolve();
                            }
                            cnTTS_2(++i).done(function(){
                                def.resolve();
                            });
                        });
                    }
                    return def.promise();
                }
                cnTTS_2(0);
                /*cnTTS_2结束*/

            });
        };

        /**
         * 创建中文发音评测卡片模板，将中文发音评测信息写入json文件
         */
        _self.createCnCard = function () {
            showLoading({tips: AppCardTemplateTipsList.CreatingCards});
            //设定定时器，超过定时器设定的时间，则提示用户卡片生成失败
            _self.setCardTimeout();
            //设置创建卡片按钮disabled为true
            _self.buttons.createCardBtn.attr("disabled", true);
            shellcmd.checkOnline().done(function (isNetWorking) {
                if (!isNetWorking) {
                    hideLoading();
                    _self.showTips(AppTips.NetWorkConnectFailed);
                    _self.clearCardTimeout();
                    return;
                }

                var value = _self.controls.evaluationDescription.val();
                var newDirName = "字词发音评测_" + md5helper.hex_md5(value);
                //创建发音模板存放目录
                _self.createTmpDir(newDirName).done(function (dir) {
                    console.log(dir);
                    if (!dir) {
                        hideLoading();
                        _self.clearCardTimeout();
                        return;
                    }
                    //中文合成
                    _self.cnTTS(dir, value, 'wangru', 'py.txt');
                });
            });

        };

        /**
         * 根据待创建的新目录名创建目录，返回新创建目录路径
         * @param newDirName
         * @returns {dir}
         */
        _self.createTmpDir = function (newDirName) {
            //画廊模板信息文件所在路径
            var ebookContext = require('../../ebookcontext').Instance;
            var path = require('../../../common/path');

            var ubPath = path.trimPosix( ebookContext.getWBEB() == "WB" ? ebookContext.getUser().getUserWBPath() :
                ebookContext.getUserBookPath());
            console.log(ubPath);
            //根据当前用户设置模板目录
            var _str =  ebookContext.getWBEB() == "WB" ? _self.bookContainer.getWbIndex() : _self.bookContainer.getPageIndex();
            var dir = path.join(ubPath, _str +'/'+newDirName);

            var defer = $.Deferred();
            shellcmd.isDirExist(dir).done(function (ret1) {
                if (!ret1) {
                    shellcmd.createDir(dir).done(function (ret2) {
                        if (!ret2) {
                            _self.showTips(dir + AppCardTemplateTipsList.FailCreateDir);
                            defer.resolve(null);
                        }
                    });
                }
                defer.resolve(dir);
            });

            return defer.promise();
        };

        /**
         * 修正儿化音：如 “待会儿” 音频为"dai1huir9"，转化为"dai1hui9r0"
         */
        _self.TiddyTone = function (strPy) {
            //如果返回就是er结尾，不变，否则，是r结尾，改作er2
            var test1 = /([^\d]{1})er(\d)/;
            if (!(test1.test(strPy))) {
                var test2 = /([^\d]{2})r(\d)/;
                return strPy.replace(test2, "$1$2er2");
            }
            return strPy;
        }
    }

    exports.EvaluationCardTemplate = EvaluationCardTemplate;
});
