/**
 * 随堂测试卡片模板功能类
 * Created by pengfu on 14-7-2.
 */

define(function (require, exports, module) {
    var _helper = require("./choicecardtmphelper").Instance;
    var md5helper = require('../../../../common/md5helper');
    var path = require('../../../../common/path');
    var shellcmd = require('../../../../common/shellcmd');
    var define = require('../../../define');
    var TextChoiceQuestion = require("./textchoice").TextChoiceQuestion;
    var TextChoiceWithImageQuestion = require("./textchoicewithimg").TextChoiceWithImageQuestion;
    var ImageChoiceQuestion = require("./imgchoice").ImageChoiceQuestion;
    var ebookContext = require('../../../ebookcontext').Instance;
    require('jquery');

    function ChoiceCardTemplate() {
        var _self = this;

        _self.num = 1;

        _self.noNewIconFlag = false;
        _self.dirName = "";

        _self.pageIndex = 1;

        /**
         * 存放题目
         * @type {Array}
         * @private
         */
        var _questionArr = [];

        /**
         * @type {jQuery}
         */
        var _questionPanel;

        /**
         * 当前题目索引
         * @type {Number}
         */
        var _currentQuestionIndex = 0;

        _self.buttons = {
            choiceTemplateImageChoice: $("#choiceTemplateImageChoice"),
            choiceTemplateTextChoice: $("#choiceTemplateTextChoice"),
            choiceTemplateTextChoiceWithImage: $("#choiceTemplateTextChoiceWithImage"),
            closeBtn_choiceTmpPanel: $("#closeBtn_choiceTmpPanel"),
            choiceCompleteBtn: $("#choiceCompleteBtn"),
            addoneItem: $("#addoneitem"),
            addTextChoiceWithImageItem: $("#addTextChoiceWithImageItem"),
            addImageChoiceItem: $("#addImageChoiceItem"),
            deletetheItem: $("#deletetheitem"),
            preQuestion: $('#btnPre'),
            nextQuestion: $('#btnNext'),
            addNewQueBtn: $('#addNewQueBtn'),
            changeOptionBtn: $('#changeOptionBtn'),
            theCurrentOptionNum:$("#theCurrentOptionNum")
        };

        _self.sbButtons = {
            sb_choiceTemplateImageChoice: $("#sb_choiceTemplateImageChoice"),
            sb_choiceTemplateTextChoice: $("#sb_choiceTemplateTextChoice"),
            sb_choiceTemplateTextChoiceWithImage: $("#sb_choiceTemplateTextChoiceWithImage")
        };

        _self.controls = {
            templatePanel: $("#templatePanel"),
            choiceTmpPanel: $("#choiceTmpPanel"),
            choiceTitle: $("#choiceTitle"),
            testTitle: $("#testTitle"),
            choiceTmpPanelTop:$("#choiceTmpPanelTop"),
            optionCountList:$("#optionCountList"),
            questionTypeList:$("#quesitiontypelist"),
            hasnoItem:$("#hasnoItemId")

        };

        /**
         * 课本容器对象
         * @type {null}
         */
        _self.bookContainer = null;

        function setCurrentQuestionIndex(index) {

            var numInfoStr = '第'+(index +1 ) + '题';
            var totalNumInfoStr = '共'+(_questionArr.length ) + '题';
            //_questionArr有题目和没有题目时 完成 按钮的灰显与否
            if(_questionArr.length > 0){
                _self.buttons.choiceCompleteBtn.removeClass('submit_disable');
                _self.controls.hasnoItem.hide();
            }else if(_questionArr.length == 0){
                _self.buttons.choiceCompleteBtn.addClass('submit_disable');
                $("#totalNumInfoId").get(0).innerHTML = '共0题';
                _self.controls.hasnoItem.show();
                return;
            }
            //根据当前题目的选项数来决定显示 “选项数XXX”
            var choiceNum = _questionArr[index].choiceItems.length;
            _self.buttons.theCurrentOptionNum[0].innerHTML = "选项数"+choiceNum;
            //将“√”设置在正确的位置上
            setTitToCorrectPostion(choiceNum);

//            if (1 != _questionArr.length) {
//                _questionArr[index]._dom.find(".showInfo").val(tmpInfo);
//            } else {
//                _questionArr[index]._dom.find(".showInfo").val("");
//            }
            _questionArr[index]._dom.find('.shit_input').find('label').get(0).innerHTML = numInfoStr;
            $("#totalNumInfoId").get(0).innerHTML = totalNumInfoStr;

            console.log("setCurrentQuestionIndex: %s", index);

            _currentQuestionIndex = index;

            if (_questionArr.length == 1) {
                _self.buttons.preQuestion.hide();
                _self.buttons.nextQuestion.hide();
            } else if (_questionArr.length > 1) {
                if (_currentQuestionIndex == 0) {
                    _self.buttons.preQuestion.hide();
                    _self.buttons.nextQuestion.show();
                } else if (_currentQuestionIndex == _questionArr.length - 1) {
                    _self.buttons.preQuestion.show();
                    _self.buttons.nextQuestion.hide();
                } else {
                    _self.buttons.preQuestion.show();
                    _self.buttons.nextQuestion.show();
                }
            }
            for (var i = 0, len = _questionArr.length; i < len; i++) {
                _questionArr[i].setVisiable(_currentQuestionIndex == i);
            }
            // TODO: 检查所有有效性
            // TODO: 设置左右箭头的样式
            // TODO: 设置显示隐藏
        }

        function setTitToCorrectPostion(optionCount){
            var listObj = _self.controls.optionCountList.children();
            var len = listObj.length;
            for (var i = 0; i < len; i++) {
                var tmpobj = $(listObj[i]);
                tmpobj.find('img[class1=titimg]').attr("src", "");
            }
            //[2,3,4,5,6]
            $(listObj[optionCount-2]).find('img[class1=titimg]').attr("src", "assert/images/right_ic.gif");
        }


        /**
         *
         * @param questionType {QuestionType}
         */
        function addQuestion(questionType) {
            var question;

            if (questionType == _helper.QuestionType.TextChoice) {
                question = new TextChoiceQuestion();
            } else if (questionType == _helper.QuestionType.ImageChoice) {
                question = new ImageChoiceQuestion();
            } else if (questionType == _helper.QuestionType.TextChoiceWithImage) {
                question = new TextChoiceWithImageQuestion();
            } else {
                throw  new Error('unknown questionTyop:' + questionType);
            }
            question.appendToBody();
            _questionArr.push(question);
            setCurrentQuestionIndex(_questionArr.length - 1);
        }

        /**
         *
         * @param questionObj
         */
        function renderQuestion(questionObj){
            var question,questionType ;
            questionType = questionObj.type;
            if(questionType == _helper.QuestionType.TextChoice){
                question = new TextChoiceQuestion(questionObj);
            }else if(questionType == _helper.QuestionType.TextChoiceWithImage){
                question = new TextChoiceWithImageQuestion(questionObj);
            }else if(questionType == _helper.QuestionType.ImageChoice){
                question = new ImageChoiceQuestion(questionObj);
            }

            question.appendToBody(questionObj);
            _questionArr.push(question);

        }

        _self.hideList = function(){
            //隐藏题目类型上拉框
            _self.controls.questionTypeList.hide();
            //隐藏选项数上拉框
            _self.controls.optionCountList.hide();
        }
        /**
         * 初始化随堂测试选择题卡片模板
         * @param bookContainer
         */
        _self.init = function (bookContainer) {
            _self.bookContainer = bookContainer;
            _questionPanel = $('#questionPanel');
            /**
             * 隐藏一些DOM
             */
            function hidelist(){
                //隐藏题目类型上拉框
                _self.controls.questionTypeList.hide();
                //隐藏选项数上拉框
                _self.controls.optionCountList.hide();
            }

            _self.buttons.preQuestion.click(function () {
                console.log("preQuestion _currentQuestionIndex: %s", _currentQuestionIndex);
                setCurrentQuestionIndex(_currentQuestionIndex - 1);
                hidelist();
            })

            _self.buttons.nextQuestion.click(function () {
                console.log("nextQuestion _currentQuestionIndex: %s", _currentQuestionIndex);
                setCurrentQuestionIndex(_currentQuestionIndex + 1);
                hidelist();
            });

            //弹出随堂测试选择题卡片模板文本选择题界面
            _self.buttons.choiceTemplateTextChoice.click(function () {
                _self.showChoiceTmpPanel(_helper.QuestionType.TextChoice);
                hidelist();
            });

            _self.sbButtons.sb_choiceTemplateTextChoice.click(function(){
                $("#sb_templatePanel").hide();
                _self.clearChoiceData();
                _self.showChoiceTmpPanel(_helper.QuestionType.TextChoice);
                hidelist();
            });

            //关闭随堂测试选择题卡片界面
            _self.buttons.closeBtn_choiceTmpPanel.click(function () {
                _self.hideChoiceTmpPanel();
            });

            //弹出随堂测试选择题 带图片的文本选择题模板界面
            _self.buttons.choiceTemplateTextChoiceWithImage.click(function () {

                _self.showChoiceTmpPanel(_helper.QuestionType.TextChoiceWithImage);
                hidelist();
            });

            _self.sbButtons.sb_choiceTemplateTextChoiceWithImage.click(function(){
                $("#sb_templatePanel").hide();
                _self.clearChoiceData();
                _self.showChoiceTmpPanel(_helper.QuestionType.TextChoiceWithImage);
                hidelist();
            })

            //smartbar
//            _self.buttons.smartbar_btnChoice.click(function(){
//                _self.showSmartbarChoiceTmpPannel();
//                hidelist();
//            });

            //弹出随堂测试选择题图片选择题
            _self.buttons.choiceTemplateImageChoice.click(function () {
                _self.showChoiceTmpPanel(_helper.QuestionType.ImageChoice);
                hidelist();
            });

            _self.sbButtons.sb_choiceTemplateImageChoice.click(function(){
                $("#sb_templatePanel").hide();
                _self.clearChoiceData();
                _self.showChoiceTmpPanel(_helper.QuestionType.ImageChoice);
                hidelist();
            });

            _self.controls.choiceTitle[0].onfocus = function () {
                if (this.value == AppCardTemplateTipsList.clickHereAddTitle)
                    this.value = '';
            }

            _self.controls.choiceTitle[0].onblur = function () {
                if (this.value == '')
                    this.value = AppCardTemplateTipsList.clickHereAddTitle;
            }

            //随堂测试选择题模板创建完成
            _self.buttons.choiceCompleteBtn.click(function () {
                if($(this).hasClass('submit_disable')){
                    return;
                }
                _self.choice2json();
            });

            _self.controls.choiceTitle.bind('input propertychange',function(){
                if(_self.controls.choiceTitle.val().length>45){
                    $.Zebra_Dialog(AppCardTemplateTipsList.TitleTooLong, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons':  [AppTips.OkTips],
                        'onClose': function(){
                            //标题过长，截断处理
                            _self.controls.choiceTitle.val(_self.controls.choiceTitle.val().substr(0,45));
                        }
                    });
                }
            });

            //当点击新增一题时，显示或者隐藏题目类型上拉框
            _self.buttons.addNewQueBtn.click(function () {
                var obj = _self.controls.questionTypeList;
                obj.is(":visible")?(obj.hide()):(obj.show());
                _self.controls.optionCountList.hide();
            });

            //当点击"选项4"按钮时，显示或者隐藏题目类型上拉框
            _self.buttons.changeOptionBtn.click(function () {
                if(_questionArr.length == 0){
                    return;
                }
                var optionObj = _self.controls.optionCountList;
                optionObj.is(":visible") ? (optionObj.hide()):(optionObj.show());
                _self.controls.questionTypeList.hide();
            })

            _self.buttons.addoneItem.click(function () {
                _self.controls.questionTypeList.hide();
                addQuestion(_helper.QuestionType.TextChoice);
            });

            _self.buttons.addTextChoiceWithImageItem.click(function () {
                _self.controls.questionTypeList.hide();
                addQuestion(_helper.QuestionType.TextChoiceWithImage);
            });

            _self.buttons.addImageChoiceItem.click(function () {
                _self.controls.questionTypeList.hide();
                addQuestion(_helper.QuestionType.ImageChoice);
            });

            _self.controls.optionCountList.children().click(function () {
                var queId = _questionArr[_currentQuestionIndex].questionId;
                var targetNum = $(this).attr("optionNum");
                //将“√”放在当前选中位置上
                setTitToCorrectPostion(targetNum);
                //选中某个选项时下面的按钮值对应变成 “选项数XXX”
                _self.buttons.theCurrentOptionNum[0].innerHTML = "选项数"+targetNum;

                var _items = $("#" + queId).children();
                console.log(_items);
                var optionCount = $(this).attr("optionNum");
                _questionArr[_currentQuestionIndex].changeChoiceItem(queId,optionCount);
                $(this).parent().hide();
            });

            _self.buttons.deletetheItem.click(function () {
                console.log(_currentQuestionIndex);
                if(_questionArr.length == 0){
                    return;
                }
                _questionArr[_currentQuestionIndex].setVisiable(false);
                _questionArr.splice(_currentQuestionIndex, 1);
                //删除当前题,当前题不是原来最后一题，则显示后面一题，如果是最后一题则显示前面一题
                if(_currentQuestionIndex < _questionArr.length){
                    setCurrentQuestionIndex(_currentQuestionIndex);
                }else if(_currentQuestionIndex == _questionArr.length){
                    setCurrentQuestionIndex(_currentQuestionIndex - 1);
                }
                hidelist();
            });
        }


        _self.showSmartbarChoiceTmpPannel = function(defaultQuestionType){
            _self.clearChoiceData();
            _self.showChoiceTmpPanel(defaultQuestionType);

        };

        _self.showChoiceTmpPanel = function (defaultQuestionType) {

            _self.noNewIconFlag = false;
            _self.dirName = "";

            (!defaultQuestionType) && ( defaultQuestionType = _helper.QuestionType.TextChoice);

            //每次弹出时是最新的
            _questionArr = [];
            if(!_questionArr.length){
                addQuestion(defaultQuestionType);
            }

            //居中显示
            _self.controls.choiceTmpPanel.css({
                position: 'absolute',
                left: ($(window).width() - _self.controls.choiceTmpPanel.outerWidth()) / 2,
                top: ($(window).height() - _self.controls.choiceTmpPanel.outerHeight()) / 2 + $(document).scrollTop()
            });

            _self.controls.templatePanel.hide();
            _self.controls.choiceTmpPanel.show();

            _self.controls.choiceTmpPanel.draggable({
                handle: "#" + _self.controls.choiceTmpPanelTop.attr("id"),
                containment: "parent",
                start: function () {
                },
                stop: function () {
                }
            });
        }

        //为反编辑选择题卡片添加
        _self.showEditChoiceTmpPanel = function(choiceJson,noNewIconFlag,dirName,pageIndex){
            //清除页面上数据
            _self.clearChoiceData();
            _self.pageIndex = pageIndex;

            _self.noNewIconFlag = noNewIconFlag;
            _self.dirName = dirName ? dirName : "";

            //每次弹出时是最新的
            _questionArr = [];

            var title = choiceJson.title;
            _self.controls.choiceTitle.val(title);

            //获得choiceJson中每道题的信息对象，在页面上渲染出来
            for(var i = 0, len = choiceJson.totalNum;i < len ;i++){
                renderQuestion(choiceJson.questionArr[i]);
            }
            //设置显示第一题
            setCurrentQuestionIndex(0);

            //居中显示
            _self.controls.choiceTmpPanel.css({
                position: 'absolute',
                left: ($(window).width() - _self.controls.choiceTmpPanel.outerWidth()) / 2,
                top: ($(window).height() - _self.controls.choiceTmpPanel.outerHeight()) / 2 + $(document).scrollTop()
            });

            _self.controls.templatePanel.hide();
            _self.controls.choiceTmpPanel.show();

            _self.controls.choiceTmpPanel.draggable({
                handle: "#" + _self.controls.choiceTmpPanelTop.attr("id"),
                containment: "parent",
                start: function () {
                },
                stop: function () {
                }
            });
            _self.hideList();
        }

        _self.hideChoiceTmpPanel = function () {
            _self.controls.choiceTmpPanel.hide();
            _self.clearChoiceData();
        }

        _self.clearChoiceData = function () {
            _questionPanel.empty();

            //将选项数4里面的勾选放在4上
            setTitToCorrectPostion(4);
            //关闭后标题（以后的文件夹名）恢复成原来的样子
            $("#choiceTitle").val(AppCardTemplateTipsList.clickHereAddTitle);
        }

        /**
         * 选择题模板创建完成，将信息存入json
         */
        _self.choice2json = function () {
            (_self.controls.choiceTitle.val() == AppCardTemplateTipsList.clickHereAddTitle)
                && _self.controls.choiceTitle.val("");
            console.log(_self.controls.choiceTitle.val());

//            var newDirName = _self.controls.choiceTitle.val();
//            newDirName = newDirName.replace(/^[\s\uff0c]+|[\s\uff0c]+$/g, '');//去除字符串中的左右空格
            //过滤“#”字符，过滤“:”字符，过滤“.”字符
//            newDirName = newDirName.replace(/\./g, '').replace(/#/g, '').replace(/:/g, '');
//            newDirName = newDirName.replace(/\./g, '')
//                .replace(/#/g, '')
//                .replace(/:/g, '')
       //         .replace(/\?/g,'')
     //           .replace(/\*/g,'')
      //          .replace(/\"/g,'')
       //         .replace(/\</g,'')
       //         .replace(/\>/g,'');

            if (!_self.dirName) {
                var date = new Date();
                _self.dirName = "随堂测试_" + date.getTime();
            }


            _self.createTmpDir(_self.dirName).done(function (dir) {
                console.log(dir);
                if (!dir) return;
                console.log(_questionArr);
                var title = _self.controls.choiceTitle.val();
                if(title == AppCardTemplateTipsList.clickHereAddTitle){
                    title = '';
                }
                var questionList = [];
                var questionItem = {};

                for (var i = 0; i < _questionArr.length; i++) {
                    questionItem = _questionArr[i].travel2Json(i,dir);
                    if(!questionItem){
                        return;
                    }
                    questionList.push(questionItem);
                }
                var choiceInfoObj = {};
                choiceInfoObj.title = title;
                choiceInfoObj.totalNum = questionList.length;
                choiceInfoObj.questionArr = questionList;
                console.log(JSON.stringify(choiceInfoObj));
                shellcmd.XinJiang_saveFilAsync(JSON.stringify(choiceInfoObj), path.join(dir, 'choiceinfo.json')).done(function (ret) {
                    console.log("saveFilAsync result: " + ret);
                    if (ret == 'true') {
                        var option = {
                            title : "随堂测试" +  _self.num,
                            userName:ebookContext.getUser().getUserName() || ebookContext.getUser().getName(),
                            uploadTime:new Date().toLocaleString(),
                            noNewIcon : _self.noNewIconFlag
                        }

                        _self.num ++ ;
                        //在主界面上添加图标
                        _self.bookContainer.insertSingleWidget(dir, define.WidgetType.Choice,null,option);
                        //关闭选择题模板对话框
                        _self.hideChoiceTmpPanel();
                    }
                });
            });
        }

        _self.createTmpDir = function (newDirName) {
            //模板信息文件所在路径
            var ebookContext = require('../../../ebookcontext').Instance;
//            var ubPath = path.trimPosix(ebookContext.getUserBookPath());
            var ubPath = path.trimPosix(ebookContext.getWBEB() == "WB" ? ebookContext.getUser().getUserWBPath() :
                ebookContext.getUserBookPath());
            console.log(ubPath);
            //根据当前用户设置模板目录
//            var dir = path.join(ubPath, _self.bookContainer.getPageIndex() + '/' + newDirName);
            //根据当前用户设置模板目录
//            var _str = ebookContext.getWBEB() == "WB" ? _self.bookContainer.getWbIndex() : _self.bookContainer.getPageIndex();
            //解决bug，widget从第1页拖到第二页时，不能用原来方法获取当前页
            var _str = ebookContext.getWBEB() == "WB" ? _self.bookContainer.getWbIndex() : _self.pageIndex;
            var dir = path.join(ubPath, _str + '/' + newDirName);

            var defer = $.Deferred();
            shellcmd.isDirExist(dir).done(function (ret1) {
                console.log("isDirExist done : " + ret1);
                if (!ret1) {
                    shellcmd.createDir(dir).done(function (ret2) {
                        if (!ret2) {
                            $.Zebra_Dialog(dir + AppCardTemplateTipsList.FailCreateDir, {
                                'type': 'information',
                                'title': AppTips.WarmTips,
                                'buttons': [AppTips.OkTips]
                            });
                            defer.resolve(null);
                        }
                    });
                }
                defer.resolve(dir);
            });
            return defer.promise();
        };
    }

    exports.ChoiceCardTemplate = ChoiceCardTemplate;
    exports.Instance = new ChoiceCardTemplate();
});

