/**
 * Created by pengfu on 14-7-14.
 */
;
define(function(require,exports){

    var _labelList = ['A', 'B', 'C', 'D', 'E', 'F'];

    /**
     *
     * @constructor
     */
    function QuestionItemBase() {

        var _questionPanel = $('#questionPanel');

        /**
         * 题目类别
         * @type {QuestionType}
         */
        this.type;

        /**
         * 题面
         * @type {String}
         */
        this.questionText;

        /**
         * 题目
         * @type{String}
         */
        this.questionId;

        /**
         * 正确答案
         */
        this.correctAnswer;

        /**
         * 题目选项及描述
         */
        this.choiceItems = [];

        /**
         * 是否可见
         * @type {boolean}
         */
        this.isVisiable;

        /**
         * DOM
         * @type {jQuery}
         */
        this._dom;

        /**
         * 选项标签，固定不变
         * */
        this.labelList = ['A', 'B', 'C', 'D', 'E', 'F'];


        /**
         *
         * @returns {QuestionType}
         */
        this.getType = function () {
            return this.type;
        }

        /**
         *
         * @returns {Array.<ChoiceItem>}
         */
        this.getChoiceItems = function () {
            return this.choiceItems;
        }

        /**
         *
         */
        this.buildHTML = function () {
            throw new Error('not implement');
        }

        /**
         *
         * @param isVisiable
         */
        this.setVisiable = function (isVisiable) {
            this.isVisiable = isVisiable;
            this.isVisiable ? this._dom.show() : this._dom.hide();
        }

        /**
         *
         * @returns {boolean}
         */
        this.getIsVisiable = function () {
            return  this.isVisiable;
        }

        this.appendToBody = function (questionObj) {
            var html = this.buildHTML(questionObj);
            _questionPanel.append(html);
        }

        this.addChioceItem = function () {
            throw new Error('not implement');
        }

        //TODO: 可以考虑再优化结构
        this.changeChoiceItem = function (queId,optionCount) {
            var _this =this;
            var currentCount = this.choiceItems.length;
            var _items = $("#" + queId).children();
            if (optionCount == currentCount) {
                return;
            } else if (optionCount < currentCount) {
                //解决bug：减少选项数时，判断正确答案的选项是否删除，若删除，则重置答案项为没有设置
                if(_this.correctAnswer >= optionCount){
                    _this.correctAnswer = -1;
                }
                for (var i = optionCount; i < currentCount; i++) {
                    _items[i].remove();//删除dom对象
                    this.choiceItems.splice(optionCount, currentCount - optionCount);//删除JS对象
                }
            } else if (optionCount > currentCount) {
                //TODO:应该根据题目类型增加相应dom

                var tmpStr1 = '<li index="{index}" class="chioceti">' +
                    '<a title="" id="{id}" class1="radioform" class="check_btn "></a>' + '<span class="sub_tit">{lable}.</span>' +
                    '<input type="text" class1="choicetext" class="add_answer" value="{addAnswer}">' +
                    '</li>';
                var str1 = tmpStr1.replace("{addAnswer}",AppCardTemplateTipsList.clickHereAddAnswer);

                for (var i = currentCount; i < optionCount; i++) {
                    //增加dom
                    var choiceId = "" + i + new Date().getTime();
                    var html = str1.replace("{index}", i)
                        .replace(/\{id\}/g, choiceId)
                        .replace("{lable}", _labelList[i]);

                    $("#" + queId).append(html);
                    //增加JS对象
                    var choiceitem = {};
                    choiceitem.label = _labelList[i];
                    this.choiceItems.push(choiceitem);
                }

                var choiceTxtDoms = $("#" + queId).find('input[class1=choicetext]');
                choiceTxtDoms.unbind("focusout").unbind("focusin");
                choiceTxtDoms.focusout(function () {
                    var i = $(this).parent().attr("index");
                    // TODO: 同步数据
                    _this.choiceItems[i].text = $(this).val();
                }).focusin(function () {
                        if ($(this).val().trim() ===AppCardTemplateTipsList.clickHereAddAnswer) {
                            $(this).val("");
                        }
                    });
                //答案描述不允许过长
                choiceTxtDoms.unbind('input propertychange').bind('input propertychange',function(){
                    var _this = this;
                    if($(this).val().length>45){
                        $.Zebra_Dialog(AppCardTemplateTipsList.AnswerTooLong, {
                            'type': 'information',
                            'title': AppTips.WarmTips,
                            'buttons':  [AppTips.OkTips],
                            'onClose': function(){
                                //答案过长，截断处理
                                $(_this).val($(_this).val().substr(0,45));
                            }
                        });
                    }
                });


                $("#" + queId).find('a[class1=radioform]').unbind("click");
                $("#" + queId).find('a[class1=radioform]').click(function () {
                    //TODO:改变checked 状态
                    var len = $(this).parent().parent().children().length;//选项数
                    for (var i = 0; i < len; i++) {
                        var obj = $($($(this).parent().parent().children()[i]).children()[0]).attr("class", "check_btn");
                    }

                    $(this).attr("class", "check_btn checked");

                    var index = $(this).attr("id")[0];
                    _this.correctAnswer = index;
                });

            }

            //根据选项个数，给予各个选项一个整体居中的位置
            optionCount = parseInt(optionCount);
            var questionObj = $("#"+queId);
            _this.changeChoiceItemStyle(questionObj,optionCount);
        }

        this.changeChoiceItemStyle = function(questionDom,optionCount){
            switch (optionCount){
                case 2:
                    questionDom.css("margin-top","125px");
                    break;
                case 3:
                    questionDom.css("margin-top","118px");
                    break;
                case 4:
                    questionDom.css("margin-top","86px");
                    break;
                case 5:
                    questionDom.css("margin-top","80px");
                    break;
                case 6:
                    questionDom.css("margin-top","65px");
                    break;
            }
        }

        this.travel2Json = function(){
            throw new Error('not implement');
        }
    }
    exports.QuestionItemBase = QuestionItemBase;
});