/**
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-12-2
 * Time: 上午10:39
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports) {
    var _path = require('../../common/path');
    var _shellcmd = require('../../common/shellcmd');
    var bookAccessor = require('./bookaccessor').Instance;
    var _bookLoader = require('./bookloader').Instance;
    var _userinfoAccessor = require('../../app/login/userinfoAccessor');
    var ebookContext = require('../ebookcontext').Instance;
    var _userData = require('../../common/userdata').Instance;
    var _bookDownloadHelper = require('./bookdownloadhelper');
    var _commonfunc = require('../../common/commonfunc');

    function ResourceUpdateManager() {
        var _self = this;
        _self.buttons = {};
        _self.controls = {};

        _self.user = null;

        //面板是否已添加至页面的标签
        _self.already = false;

        /*全部的更新信息*/
        _self.resUpdateMergedInfo = [];

        /*更新信息一共可以分多少页*/
        _self.maxPageCount = 1;
        _self.nowPage = 1;

        /**
         * @param buttons   按钮
         * @param controls  非按钮类控件
         * @param user 用户对象
         */
        _self.init = function (buttons, controls, user,lan) {
            _self.buttons = buttons;
            _self.controls = controls;
            _self.user = user;
			_self.lan = lan;
            _self.checkResUpdate();

            _self.buttons.closePanel.click(function () {
                _self.hideUpdateBooks();
            });

            _self.buttons.lastPage.click(function () {
                if (_self.nowPage == 1) {
                    return;
                }
                else {
                    _self.nowPage = parseInt(_self.nowPage) - 1;
                    _self.showNowPage(_self.nowPage);
                }
            });

            _self.buttons.nextPage.click(function () {
                if (_self.nowPage == _self.maxPageCount) {
                    return;
                }
                else {
                    _self.nowPage = parseInt(_self.nowPage) + 1;
                    _self.showNowPage(_self.nowPage);
                }
            });

            _self.buttons.selectPage.click(function () {
                _self.whetherShowPageTip();
            });

            _self.buttons.selectPageArrow.click(function () {
                _self.whetherShowPageTip();
            });
        }

        /**
         * 是否显示分页小面板
         */
        _self.whetherShowPageTip = function () {
            if (_self.controls.pageTip.is(":visible")) {
                _self.controls.pageTip.hide();
            }
            else {
                _self.controls.pageTip.show();
            }
        }

        /**
         * 根据当前页禁用相关翻页按钮
         */
        _self.pageBtnDisable = function () {
            _self.buttons.lastPage.removeClass("btn_flip_disable").addClass("btn_flip");
            _self.buttons.nextPage.removeClass("btn_flip_disable").addClass("btn_flip");
            if (_self.nowPage == 1) {
                _self.buttons.lastPage.removeClass("btn_flip").addClass("btn_flip_disable");
            }
            if (_self.nowPage == _self.maxPageCount) {
                _self.buttons.nextPage.removeClass("btn_flip").addClass("btn_flip_disable");
            }
        }

        /**
         * 弹出可更新div
         */
        _self.showUpdateBooks = function () {
            _self.controls.personalInfoPanel.hide();
            _self.controls.purchasedBooksPanel.hide();
            //已添加至页面body
            if (_self.already) {
                _self.controls.resUpdatePanel.show();
            }
            else {
                _self.controls.shelfPanel.append(_self.controls.resUpdatePanel);
                _self.controls.resUpdatePanel.show();
				 //翻译
                if(_self.lan){
                    _self.controls.resUpdatePanel = _self.lan.translateObj(_self.controls.resUpdatePanel);
                }

                _self.already = true;
            }

            _self.controls.resUpdatePanel.draggable({
                handle: "#" + _self.controls.updateTab.attr("id"),
                containment: "window",
                scroll: false,
                start: function () {
                },
                stop: function () {
                }
            });

            //屏幕分辩率800*600时，才放缩UI面板
            if (_self.controls.resUpdatePanel.outerHeight() > screen.height || _self.controls.resUpdatePanel.outerWidth() > screen.width) {
                _self.controls.resUpdatePanel.css('-webkit-transform', 'scale(0.8)');
            }

            //居中显示
            _self.controls.resUpdatePanel.css({
                position: 'absolute',
                left: ($(window).width() - _self.controls.resUpdatePanel.outerWidth()) / 2,
                top: ($(window).height() - _self.controls.resUpdatePanel.outerHeight()) / 2 + $(document).scrollTop()
            });

            _self.readyForShowList();
            _self.showNowPage(1);
        }

        _self.hideUpdateBooks = function () {
            _self.controls.resUpdatePanel.hide();
        }

        /**
         * 准备分页显示的初始化信息,每页10条
         */
        _self.readyForShowList = function () {
            if (_self.resUpdateMergedInfo.length == 0) {
                _self.controls.resUpdatePanel.hide();
                _self.buttons.booksNeedUpdate.hide();
                return;
            }
            _self.maxPageCount = (parseInt(_self.resUpdateMergedInfo.length / 10)) + ((_self.resUpdateMergedInfo.length % 10 == 0) ? 0 : 1);
            var liTemplate = "<li val = '{{num}}'>{{str}}</li>";
            var liHtmlStr = [], j = -1;
            //填充分页下拉框
            for (var i = 1; i <= _self.maxPageCount; ++i) {
                liHtmlStr[++j] = liTemplate.replace("{{num}}", i).replace("{{str}}", i + "/" + _self.maxPageCount);
            }
            var liHtmlText = liHtmlStr.join('');
            var liElements = $(liHtmlText);

            _self.controls.pageTip.empty().append(liElements);
            _self.controls.pageTip.find("li").click(function () {
                //单击翻页
                _self.nowPage = $(this).attr("val");
                _self.showNowPage(_self.nowPage);
            });
        }

        /**
         * 翻页至当前页，传入值为当前页的页码
         * @param num
         */
        _self.showNowPage = function (num) {
            _self.controls.pageTip.hide();
            //先把右下角当前页码更新
            var str = num + "/" + _self.maxPageCount;
            _self.buttons.selectPage.attr("value", str);
            //再根据需要禁灰相关按钮
            _self.pageBtnDisable();

            //显示页面模板
            var listTemplate = "<tr>" +
                "<td>{{index}}</td>" +
                "<td>{{title}}</td>" +
                "<td>{{downLoadTime}}</td>" +
                "<td id='{{bookCode}}'>" +
                   "<div id='{{bookid}}' class='BookProwy' hidden='true'>" +
                      "<div class='bb_img'>" +
                         "<img src='assert/images/downbook.gif'/>" +
                      "</div>" +
                      "<div class='book_prowy'>" +
                         "<p class='book_prowy_in' style='width:60%;'></p>" +
                      "</div>" +
                      "<strong>60%</strong>" +
                      "<a style='cursor:pointer;' resId='{{bookid}}'>"+AppTips.CancelTips +"</a>" +
                   "</div>" +
                   "<div id='{{resid}}' class='ResProwy' hidden='true'>" +
                      "<div class='bb_img'>" +
                         "<img src='assert/images/book_file.gif'/>" +
                      "</div>" +
                      "<div class='book_prowy'>" +
                          "<p class='book_prowy_in' style='width:60%;'></p>" +
                      "</div>" +
                      "<strong>60%</strong>" +
                      "<a style='cursor:pointer;' resId='{{resid}}'>"+AppTips.CancelTips+"</a>" +
                   "</div>" +
                   "<div class='BookUpdateStr'>" +
                      "{{extraStr}}"+
                   "</div>" +
                "</td>" +
                "</tr>";

            var minIndex = (num - 1) * 10;
            var maxIndex = minIndex + 9;
            //如果是最后一页，最大list号为总长度
            if (num == _self.maxPageCount) {
                maxIndex = _self.resUpdateMergedInfo.length -1;
            }
            var i = minIndex;
            var htmlStr = [];
            var htmlIndex = -1;
            //i从0开始，indexNum从1开始
            for (; i <= maxIndex; ++i) {
                var indexNum = i + 1;
                var titleStr = _self.resUpdateMergedInfo[i].title;
                if(titleStr.length>14){
                    titleStr = titleStr.slice(0,14)+"...";
                }
                var dateTimeStr = (new Date()).Format("yyyy-MM-dd");
                //var dateTimeStr = _self.resUpdateMergedInfo[i].downloadDate;
                var bookCodeStr = _self.resUpdateMergedInfo[i].bookCode;
                var cnStr_book = AppBookShelfTipsList.UpdateStr_book;
                var cnStr_res = AppBookShelfTipsList.UpdateStr_res;
                var bookIdStr = _self.resUpdateMergedInfo[i].newBookId;
                var resIdStr = _self.resUpdateMergedInfo[i].newResId;
                var extraStr = '';
                if(resIdStr&&resIdStr!=''){
                    extraStr += "<a indexNum='{{index}}' class='BookUpdateStr_res down_res' style='cursor:pointer;color:#017bb4;width:80px;display: inline;'>{{hrefStr_res}}</a>";
//
                }

                if(bookIdStr&&bookIdStr!=''){
                    extraStr += "&nbsp;&nbsp;&nbsp;<a indexNum='{{index}}' class='BookUpdateStr_book down_book' style='cursor:pointer;color:rgb(129, 185, 67);width:80px;display: inline;'>{{hrefStr_book}}</a>";
//
                }
                htmlStr[++htmlIndex] = listTemplate.replace('{{extraStr}}',extraStr).replace("{{index}}", indexNum).replace("{{index}}", indexNum).replace("{{index}}", indexNum).replace("{{title}}", titleStr)
                    .replace("{{bookid}}", bookIdStr).replace("{{resid}}", resIdStr).replace("{{bookid}}", bookIdStr).replace("{{resid}}", resIdStr)
                    .replace("{{bookCode}}", bookCodeStr).replace("{{downLoadTime}}", dateTimeStr).replace("{{hrefStr_book}}", cnStr_book).replace("{{hrefStr_res}}", cnStr_res);
            }
            for (; i <= (minIndex + 9); ++i) {
                //用空白填充剩余行
                htmlStr[++htmlIndex] = "<tr><td>&nbsp;</td><td></td><td></td><td></td></tr>";
            }
            var htmlText = htmlStr.join('');
            var listElements = $(htmlText);
            _self.controls.resUpdateList.empty().append(listElements);
            _self.controls.resUpdateList.find("tr:odd").addClass("c_f3");
            //为更新课本操作加事件
            _self.controls.resUpdateList.find(".BookUpdateStr .BookUpdateStr_book").click(function () {
                var $this = $(this);
                //去除下载重复绑定事件
                if($this.html() == AppBookShelfTipsList.ReadyForUpdate) return;
                var indexnum = parseInt($this.attr("indexNum")) - 1;
                var bookObj = _self.resUpdateMergedInfo[indexnum];
                var bookresJson = {} ,bookJson = {};
                $(this).parent().find('.BookUpdateStr_res')&&$(this).parent().find('.BookUpdateStr_res').hide();
                $this.html(AppBookShelfTipsList.ReadyForUpdate);
                    if (bookObj.newBookId) {
                        $.extend(bookJson,bookObj);
                        bookJson.id = bookObj.newBookId;
                        bookJson.file = bookObj.newBookDownloadUrl;
                        bookJson.thumbnail = bookObj.newBookThumbnailUrl;
                        _self.downloadBook(bookJson);
                    }
            });

            //为更新资源包操作加事件
            _self.controls.resUpdateList.find(".BookUpdateStr .BookUpdateStr_res").click(function () {
                var $this = $(this);
                //去除下载重复绑定事件
                if($this.html() == AppBookShelfTipsList.ReadyForUpdate) return;
                var indexnum = parseInt($this.attr("indexNum")) - 1;
                var bookObj = _self.resUpdateMergedInfo[indexnum];
                var bookresJson = {} ,bookJson = {};

                if(bookObj.newBookId){
                    $.Zebra_Dialog(AppBookShelfTipsList.FirstUpdateBookPlease,{
                        'type':'information',
                        'title':AppTips.WarmTips,
                        'buttons':[AppTips.OkTips]
                    })
                }else{
                    $(this).parent().find('.BookUpdateStr_book')&&$(this).parent().find('.BookUpdateStr_book').hide();
                    $this.html(AppBookShelfTipsList.ReadyForUpdate);
                    $.extend(bookresJson,bookObj);
                    bookresJson.id = bookObj.newResId;
                    bookresJson.file = bookObj.newResDownloadUrl;
                    _self.downloadResource(bookresJson);
                }
            });


            //为书取消操作加事件
            _self.controls.resUpdateList.find(".BookProwy a").click(function(){
                var $this = $(this);
                //书取消下载
                var bookObj = _self.findBookByResID($this.attr("resId"));
                var arr = [];
                if(bookObj.newBookId){
                    arr.push(bookObj.newBookId);
                }
                if(arr.length>0){
                    _self.cancelDownload(arr,function(){
                        var trObj = $("#"+bookObj.bookCode);
                        trObj.find(".BookProwy").hide();
                        trObj.find(".BookUpdateStr").show().find("a").show();
                        trObj.find(".BookUpdateStr").find('.BookUpdateStr_book').html(AppBookShelfTipsList.UpdateStr_book);
                    });
                }

            });
           //为资源包取消操作加事件
            _self.controls.resUpdateList.find(".ResProwy a").click(function(){
                var $this = $(this);
                //资源包取消下载
                var bookObj = _self.findBookByResID($this.attr("resId"));
                var arr = [];
                if(bookObj.newResId){
                    arr.push(bookObj.newResId);
                }
                if(arr.length>0){
                    _self.cancelDownload(arr,function(){
                        var trObj = $("#"+bookObj.bookCode);
                        trObj.find(".ResProwy").hide();
                        trObj.find(".BookUpdateStr").show().find("a").show();
                        trObj.find(".BookUpdateStr").find('.BookUpdateStr_res').html(AppBookShelfTipsList.UpdateStr_res);
                    });
                }

            });

        }

        /**
         * 处理由于外壳发来的消息
         * @param obj
         */
        _self.onMessageReceived = function (obj) {
            if (obj.evt == 'file_download' && (obj.data.sourcepage == 'bookupdate' || obj.data.sourcepage == 'resupdate')) {
                console.log(obj.data.id);
                if (obj.data.progress > 0) {
                    var _progressObj = $("#"+obj.data.id);
//                    var bookCodeTd = _self.controls.resUpdateList.find("#" + _obj.bookCode);
                    //progress>1说明下载完成了
                    if (obj.data.progress > 1) {
                        var flagNum = _self.set0InMergedInfo(obj.data.id);
                        if(flagNum == 1){
                            //bookObj被移除，刷新列表
                            //如果一本书之前已经打开，更新之后不显示新，则不需要刷新数据库
                            //如下做法是为了显示“新”标签
                            bookAccessor.initAllBookList(_self.user).done(function(){
                                _bookLoader.setToBeUpdateBooks(_self.resUpdateMergedInfo);
                                _self.readyForShowList();
                                _self.showNowPage(1);
                            });
                        }
                        else{
                            _progressObj.hide();
                            if(obj.data.sourcepage == 'bookupdate'){
                                _progressObj.parent().find('.BookUpdateStr_book').remove();
                            }else if(obj.data.sourcepage == 'resupdate'){
                                _progressObj.parent().find('.BookUpdateStr_res').remove();
                            }
                            _progressObj.parent().find('.BookUpdateStr').show().find('a').show();

                        }
                        return;
                    }
//                    _self.showProgress(bookCodeTd, progress, _obj.type);
                    var progress = parseInt(obj.data.progress * 100) + "%";
                    var _obj = _self.findBookByResID(obj.data.id);
                    var showProgress = null;
                    if(obj.data.id == _obj.newBookId){
                        showProgress = _progressObj;
                    }
                    else if(obj.data.id == _obj.newResId){
                        if(!_obj.newBookId){
                            showProgress = _progressObj;
                        }
                    }
                    _self.showProgress2(showProgress, progress);
                }
            }
        }

        _self.getResUpdateInfo = function (localResInfo) {
            var def = $.Deferred();
            var httpurl = AppRemoteSvcCfg.CheckResUpdateUrl;
            //ajax对数组转成json的方法真的无力吐槽
            var msgJson = {
                url: httpurl,
                resources: JSON.stringify(localResInfo)
            };
      //      console.log(JSON.stringify(localResInfo));
            _shellcmd.postHttpRequest(msgJson)
                .done(function (dataReceived) {
                    console.log(dataReceived);
                    def.resolve(dataReceived);
                });
            return def.promise();
        }

        /**
         * 检测书本和资源更新
         */
        _self.checkResUpdate = function () {
            //联网判断处理
            if (ebookContext.getUser().getIsOnline()) {
                bookAccessor.getAllBooks(_self.user).done(function (bookList) {
                    if (!bookList || bookList.length < 1) {
                        return;
                    }
                    var resInfo = _self.setLocalInfo(bookList);
                    console.log(JSON.stringify(resInfo));
                    _self.getResUpdateInfo(resInfo).done(function (resUpdateInfo) {
                        console.log(resUpdateInfo);
                        //得到字符串为空
                        if (!resUpdateInfo || resUpdateInfo.length < 1) {
                            return;
                        }
                        //先将得到的字符串转为数组
                        try{
                            resUpdateInfo = JSON.parse(resUpdateInfo);
                        }
                        catch(e){
                            console.log(e);
                             return;
                        }

                        //合并更新信息和本地信息，供界面使用
                        var resUpdateMergedInfo = _self.mergeInfo(bookList, resUpdateInfo);

                        if (!resUpdateMergedInfo || resUpdateMergedInfo.length < 1) {
                            return;
                        }
                        _self.resUpdateMergedInfo = resUpdateMergedInfo;
                        _bookLoader.setToBeUpdateBooks(_self.resUpdateMergedInfo);
//                      testData
//                        _self.resUpdateMergedInfo =  [
//                            {"title" : "语文","bookcode":"13170425-020","resid":"2c1eb986b6d046b7811bf95dfa9e097a","resourcetype":"1403","length":15730709,"file_url":"http:\/\/download.cycore.cn\/2\/files\/2c1eb986b6d046b7811bf95dfa9e097a.book2","thumbnail_url":"http:\/\/download.cycore.cn\/2\/thumbnails\/2c1eb986b6d046b7811bf95dfa9e097a_100_140.png","update_status":1},
//                            {"title" : "语文","bookcode":"13170425-007","resid":"d1f1669ed9234f71b39bbf8f3bf026c7","resourcetype":"1403","length":8509465,"file_url":"http:\/\/download.cycore.cn\/d\/files\/d1f1669ed9234f71b39bbf8f3bf026c7.book2","thumbnail_url":"http:\/\/download.cycore.cn\/d\/thumbnails\/d1f1669ed9234f71b39bbf8f3bf026c7_100_140.png","update_status":1},
//                            {"title" : "语文","bookcode":"13170425-020","resid":"2c1eb986b6d046b7811bf95dfa9e097a","resourcetype":"1403","length":15730709,"file_url":"http:\/\/download.cycore.cn\/2\/files\/2c1eb986b6d046b7811bf95dfa9e097a.book2","thumbnail_url":"http:\/\/download.cycore.cn\/2\/thumbnails\/2c1eb986b6d046b7811bf95dfa9e097a_100_140.png","update_status":1},
//                            {"title" : "语文","bookcode":"13170425-007","resid":"d1f1669ed9234f71b39bbf8f3bf026c7","resourcetype":"1403","length":8509465,"file_url":"http:\/\/download.cycore.cn\/d\/files\/d1f1669ed9234f71b39bbf8f3bf026c7.book2","thumbnail_url":"http:\/\/download.cycore.cn\/d\/thumbnails\/d1f1669ed9234f71b39bbf8f3bf026c7_100_140.png","update_status":1},
//                            {"title" : "语文","bookcode":"13170425-020","resid":"2c1eb986b6d046b7811bf95dfa9e097a","resourcetype":"1403","length":15730709,"file_url":"http:\/\/download.cycore.cn\/2\/files\/2c1eb986b6d046b7811bf95dfa9e097a.book2","thumbnail_url":"http:\/\/download.cycore.cn\/2\/thumbnails\/2c1eb986b6d046b7811bf95dfa9e097a_100_140.png","update_status":1},
//                            {"title" : "语文","bookcode":"13170425-007","resid":"d1f1669ed9234f71b39bbf8f3bf026c7","resourcetype":"1403","length":8509465,"file_url":"http:\/\/download.cycore.cn\/d\/files\/d1f1669ed9234f71b39bbf8f3bf026c7.book2","thumbnail_url":"http:\/\/download.cycore.cn\/d\/thumbnails\/d1f1669ed9234f71b39bbf8f3bf026c7_100_140.png","update_status":1},
//                            {"title" : "语文","bookcode":"13170425-020","resid":"2c1eb986b6d046b7811bf95dfa9e097a","resourcetype":"1403","length":15730709,"file_url":"http:\/\/download.cycore.cn\/2\/files\/2c1eb986b6d046b7811bf95dfa9e097a.book2","thumbnail_url":"http:\/\/download.cycore.cn\/2\/thumbnails\/2c1eb986b6d046b7811bf95dfa9e097a_100_140.png","update_status":1},
//                            {"title" : "语文","bookcode":"13170425-007","resid":"d1f1669ed9234f71b39bbf8f3bf026c7","resourcetype":"1403","length":8509465,"file_url":"http:\/\/download.cycore.cn\/d\/files\/d1f1669ed9234f71b39bbf8f3bf026c7.book2","thumbnail_url":"http:\/\/download.cycore.cn\/d\/thumbnails\/d1f1669ed9234f71b39bbf8f3bf026c7_100_140.png","update_status":1},
//                            {"title" : "语文","bookcode":"13170425-020","resid":"2c1eb986b6d046b7811bf95dfa9e097a","resourcetype":"1403","length":15730709,"file_url":"http:\/\/download.cycore.cn\/2\/files\/2c1eb986b6d046b7811bf95dfa9e097a.book2","thumbnail_url":"http:\/\/download.cycore.cn\/2\/thumbnails\/2c1eb986b6d046b7811bf95dfa9e097a_100_140.png","update_status":1},
//                            {"title" : "语文","bookcode":"13170425-007","resid":"d1f1669ed9234f71b39bbf8f3bf026c7","resourcetype":"1403","length":8509465,"file_url":"http:\/\/download.cycore.cn\/d\/files\/d1f1669ed9234f71b39bbf8f3bf026c7.book2","thumbnail_url":"http:\/\/download.cycore.cn\/d\/thumbnails\/d1f1669ed9234f71b39bbf8f3bf026c7_100_140.png","update_status":1},
//                            {"title" : "语文","bookcode":"13170425-020","resid":"2c1eb986b6d046b7811bf95dfa9e097a","resourcetype":"1403","length":15730709,"file_url":"http:\/\/download.cycore.cn\/2\/files\/2c1eb986b6d046b7811bf95dfa9e097a.book2","thumbnail_url":"http:\/\/download.cycore.cn\/2\/thumbnails\/2c1eb986b6d046b7811bf95dfa9e097a_100_140.png","update_status":1},
//                            {"title" : "语文","bookcode":"13170425-007","resid":"d1f1669ed9234f71b39bbf8f3bf026c7","resourcetype":"1403","length":8509465,"file_url":"http:\/\/download.cycore.cn\/d\/files\/d1f1669ed9234f71b39bbf8f3bf026c7.book2","thumbnail_url":"http:\/\/download.cycore.cn\/d\/thumbnails\/d1f1669ed9234f71b39bbf8f3bf026c7_100_140.png","update_status":1}
//                        ]
                    });
                });
            }
        }


        /**
         * 下载书本
         * @param bookJson
         */
        _self.downloadBook = function (bookJson) {
            var savePath = ebookContext.getUser().getStdBookRelativeBasePath() + '/' + bookJson.bookCode;
            var logObj = {
                type: "book2",
                source: "updateBook",
                bookcode: bookJson.bookCode,
                url: bookJson.file
            }
            _userData.start("add", logObj).done(function () {
                _bookDownloadHelper.updateBook(bookJson, ebookContext.getUser());
            });
        }

        /**
         * 下载资源
         * @param bookResJson
         */
        _self.downloadResource = function (bookResJson) {
            var logObj = {
                type: "mtbk",
                source: "updateBook",
                bookcode: bookResJson.bookCode,
                url: bookResJson.file
            }
            _userData.start("add", logObj).done(function () {
                bookResJson["sourcepage"] = "resupdate";
                bookResJson["moreparam"] = "true";
                var bookResExtension = ".mtbk";
                bookResJson["filesavename"] = bookResJson.bookCode + bookResExtension;
                bookResJson["thumbnailsavename"] = "";
                bookResJson["savepath"] = ebookContext.getUser().getUserBookRelativeBasePath() + '/' + bookResJson.bookCode;  //文件保存路径
                bookResJson["dbpath"] = ebookContext.getUser().getUserDbFullPath();
                var downloadRawData = JSON.stringify(bookResJson);
                _shellcmd.fileDownload(downloadRawData);
            });
        }

        /**
         * 取消下载，这个存在一个问题：当在书本下载完成之后，资源下载开始之后，取消功能不起作用
         * @param cancelIds  Array 待取消的书本和资源ID列表，可以之有其中的一个
         */
        _self.cancelDownload = function (cancelIds,callback) {
            /**
             * 因现在的更新都是单个的，要么课本，要么资源，所以数组中只会存在一个参数，
             * 可以用callback,callback用来处理，取消后的工作  by linwang5 -- 2015-12-17
             */
            for (var i in cancelIds) {
                _shellcmd.cancleDownload(cancelIds[i]).done(function (ret) {
                    var responseJson = {"evt": "cancelDownload",
                        "data": {"resid": cancelIds[i], "status": ret ? 'true' : 'false'}};
                    //在这里增加取消下载后，clear sessionStorage 免得关闭的时候又提示说还有书和资源正在下载 by linwang5 --2015-12-17
                    app_DownloadQueue.dele(cancelIds[i]);
                    dispatchClientMsg(JSON.stringify(responseJson));
                    callback&&callback();
                });
            }
        }

        /**
         * 过滤updateState状态为1的数据
         * @param list
         * @returns {Array}
         */
        _self.setUpdateInfo = function (list) {
            var resInfo = [];
            var iter = 0, len = list.length;
            for (; iter < len; ++iter) {
                if (list[iter].update_status == 1) {
                    resInfo.push(list[iter]);
                }
            }
            return resInfo;
        }

        /**
         * 准备请求信息
         * @param list
         */
        _self.setLocalInfo = function (bookList) {
            var resInfo = [];
            for (var i in bookList) {
                //书的信息(1403)
                resInfo.push({"bookcode": bookList[i].bookCode, "resid": bookList[i].id, "resourcetype": "1403"});
                if (bookList[i].mtbkId) {
                    //资源包的信息(1405)
                    resInfo.push({"bookcode": bookList[i].bookCode, "resid": bookList[i].mtbkId, "resourcetype": "1405"});
                }
            }
            return resInfo;
        }

        /**
         * 合并更新信息和本地信息，供界面使用
         */
        _self.mergeInfo = function (bookList, resUpdateInfo) {
            var resUpdateMergedInfo = [];
            var item = null;
            for (var j in bookList) {
                item = null;
                for (var i in resUpdateInfo) {
                    if (resUpdateInfo[i].bookcode == bookList[j].bookCode) {
                        item = item || $.extend({}, bookList[j]);
                        if (resUpdateInfo[i].resourcetype == "1403") {
                            item.newBookId = resUpdateInfo[i].resid;
                            item.newBookDownloadUrl = resUpdateInfo[i].file_url;
                            item.newBookThumbnailUrl = resUpdateInfo[i].thumbnail_url;
                        } else if (resUpdateInfo[i].resourcetype == "1405") {
                            item.newResId = resUpdateInfo[i].resid;
                            item.newResDownloadUrl = resUpdateInfo[i].file_url;
                        }
                    }
                }
                if (item) {
                    resUpdateMergedInfo.push(item);
                }
            }
            console.log(resUpdateMergedInfo);
            return resUpdateMergedInfo;
        }

        _self.showProgress = function (bookCodeTd, progress, type) {
            var aTagObjDiv = bookCodeTd.find(".BookUpdateStr");
            var aProgressDiv = bookCodeTd.find(".BookProwy");
            if (type == "1403") {
                aProgressDiv.find('img').attr("src", "assert/images/downbook.gif");
            }
            else if (type == "1405") {
                aProgressDiv.find('img').attr("src", "assert/images/book_file.gif");
            }
            aProgressDiv.find(".book_prowy_in").css("width", progress);
            aProgressDiv.find("strong").html(progress);
            aTagObjDiv.hide();
            aProgressDiv.show();
        }

        _self.showProgress2 = function (showObj, progress) {
            if(showObj !== null){
                try{
                    var aTagObjDiv = showObj.parent().find(".BookUpdateStr");
                }
                catch(e){
                    console.log(showObj);
                }
                showObj.find(".book_prowy_in").css("width", progress);
                showObj.find("strong").html(progress);
                aTagObjDiv.hide();
                showObj.show();
            }
        }

        _self.deleteArray = function (resid) {
            var i = 0, len = _self.resUpdateMergedInfo.length;
            var newArr = [];
            for (; i < len; ++i) {
                if (_self.resUpdateMergedInfo[i].newBookId != resid &&
                    _self.resUpdateMergedInfo[i].newResId != resid) {
                    newArr.push(_self.resUpdateMergedInfo[i]);
                }
            }
            return newArr;
        }

        //把resid置空，再单击“更新”时不会显示。如果书和资源包的resid都为空，删除
        _self.set0InMergedInfo = function(resid){
            var i = 0, len = _self.resUpdateMergedInfo.length;
            var flag = 0;
            for (; i < len; ++i) {
                if (_self.resUpdateMergedInfo[i].newBookId == resid ){
                    (_self.resUpdateMergedInfo[i].newResId)? _self.resUpdateMergedInfo[i].newBookId = "" : flag = 1;
                    break;
                }
                else if(_self.resUpdateMergedInfo[i].newResId == resid){
                    (_self.resUpdateMergedInfo[i].newBookId)? _self.resUpdateMergedInfo[i].newResId = "" : flag = 1;
                    break;
                }
            }
            if(flag == 1){
                _self.resUpdateMergedInfo = _self.deleteArray(resid);
            }
            return flag;
        }

        /**
         * 根据bookCode移除MergedInfo里信息
         * @param bookcode
         */
        _self.deleMergeDInfoByBookCode = function(bookcode){
            var newArr = [];
            for ( var i = 0, len = _self.resUpdateMergedInfo.length; i < len; ++i) {
                if(_self.resUpdateMergedInfo[i].bookCode != bookcode){
                    newArr.push(_self.resUpdateMergedInfo[i]);
                }
            }
            _self.resUpdateMergedInfo = newArr ;
        }

        /**
         * 根据resid寻找bookObj
         * @param resid
         * @returns {{}}
         */
        _self.findBookByResID = function (resid) {
            var i = 0, len = _self.resUpdateMergedInfo.length;
            var obj = {};
            for (; i < len; ++i) {
                if (_self.resUpdateMergedInfo[i].newBookId == resid) {
                    obj = _self.resUpdateMergedInfo[i];
                    obj.type = "1403";
                    break;
                }
                else if (_self.resUpdateMergedInfo[i].newResId == resid) {
                    obj = _self.resUpdateMergedInfo[i];
                    obj.type = "1405";
                    break;
                }
            }
            return obj;
        }
    }

    exports.Instance = new ResourceUpdateManager();
})
;