/**
 * Created with JetBrains WebStorm.
 * User: Administrator
 * Date: 14-10-11
 * Time: 下午4:37
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {
    var shellCmd = require("../../../common/shellcmd");
    var path = require('../../../common/path');
    var loginAssistor = require("../../login/loginAssistor");
    var ebookContext = require("../../ebookcontext").Instance;
    var pageNavigatorHelper = require("../../../common/pagenavigatorhelper");
    var CloudLogin = require("../../login/cloudlogin").CloudLogin;
    var result = require("../../login/loginhelper").Result;


    function Login() {

        var _self = this;

        _self._U = "";
        _self._isU = "";
        //账户名
        _self._Name = "";
        _self._Up = "";
        //姓名
        _self.userName = "";

        _self.cloudLogin = new CloudLogin();

        _self.init = function (U, name, isU, Up, userName) {
            _self._U = U;
            _self._Name = name;
            _self._isU = isU;
            _self._Up = Up;
            _self.userName = userName;
        }

        _self.login = function () {
            var def = $.Deferred();
            _getP(_self._Name, _self._Up).done(function (ret) {
                check(_self._Name, ret, _self._isU, _self._U).done(function (ret) {
                    def.resolve(ret);
                });
            });
            return def.promise();
        }

        _self.goToErrorLogin = function(){
            pageNavigatorHelper.goToErrorLogin();
        }

        function _getP(name, p) {
            var def = $.Deferred();
            shellCmd.desDecrpty(p, name).done(function (ret) {
                def.resolve(ret);
            })
            return def.promise();
        }

        //登录验证

        /*****************************************************************************
         * Caution :
         * TODO : 这一块其实可以和真正的loginmgr那一块放在一起考虑抽象重构了。
         * 可以在DOM显示和
         * 暂时先不理会
         *                              ------------   by  yczhu
         *****************************************************************************/
        function check(u, p, h, U) {
            var defer = $.Deferred();
            //先在线验证
            _self.cloudLogin.beforeCheckInfo(u, p).done(function (cloudresult) {
                if (cloudresult == result.CloudResult.alreadyBind ||
                    cloudresult == result.CloudResult.bindSuccess) {

                    ebookContext.getUser().setIsOnline(true);
                    //write SSO infomations into the security file when login through the dialog.
                    shellCmd.writeAESUserInfo(u + '|' + p);
                    loginAssistor.createUserFolder(ebookContext.getUser()).done(function (ret) {
                        if (!ret) {
                            console.log("创建用户目录失败");
                            shellCmd.deleteDir(path.trimPosix(ebookContext.getUser().getUserBasePath()));
                            _self.showTips(AppTips.loginCreateFolderFailMsg);
                            return;
                        }
                        socket.send({"type":"logic","action":"login","from":"ib","to":"all","data":""});
                        pageNavigatorHelper.goToShelfFromLogin(ebookContext.getUser());
                    });

                    defer.resolve(cloudresult);
                }
                else if (cloudresult == result.CloudResult.webError) {
                    loginAssistor.checkUAuthor(u, p, h, U).done(function (isValid) {
                        //不管账号正确与否，先记下再说
                        ebookContext.setUser(u, p);
                        ebookContext.getUser().setIsOnline(false);
                        ebookContext.getUser().setTicket("");
                        ebookContext.getUser().setIsActive(true);
                        ebookContext.getUser().setUserName(_self.userName);

                        ebookContext.setBinPath(Config.binPath);
                        addUserToDb(p).done(function () {
                            switch (isValid) {
                                //这里的30+是故意设定的，不是手误
                                case '-2':
                                    defer.resolve(31);
                                    break;
                                case '-1':
                                    defer.resolve(32);
                                    break;
                                case '0':
                                    defer.resolve(33);
                                    break;
                                case '1':
                                    defer.resolve(34);
                                    break;
                                case '2':
                                    defer.resolve(35);
                                    break;
                                case '3':
                                    defer.resolve(30);
                                    break;
                                case '4':
                                    socket.send({"type":"logic","action":"login","from":"ib","to":"all","data":""});
                                    pageNavigatorHelper.goToShelfFromLogin(ebookContext.getUser());
                                    defer.resolve(36);
                                    break;
                                default:
                                    defer.resolve();
                            }
                        })
                    });
                }
                else {
                    defer.resolve(cloudresult);
                }
            });
            return defer.promise();
        }

        function addUserToDb(pwd) {
            var def = $.Deferred();
            var curUser = ebookContext.getUser();
            //可用
            var userInfo = {
                userAccount: curUser.getName(),
                userEmail: curUser.getEmail(),
                userPhone: curUser.getPhoneNum(),
                isActive: curUser.getIsActive(),
                userName: curUser.getUserName()
            }

            shellCmd.desEncrpty(pwd, curUser.getName()).done(function (passwordData) {
                loginAssistor.addUserToLocalDb(userInfo, passwordData, 1).done(function () {
                    def.resolve();
                });
            });
            return def.promise();
        }
    }

    exports.Instance = new Login();
});
