/**
 * Created by pengfu on 14-10-11.
 */
;
define(function(require,exports,module){
    function BookExportSuccessMgr(){
        var _this = this;

        _this.controls = {
            bookExportSuccessPanel : $('#bookExportSuccessPanel'),
            bookExportSuccessPanelTop : $('#bookExportSuccessPanelTop')

        }
        _this.buttons = {
            closeBtn_bookExportSuccessPanel : $('#closeBtn_bookExportSuccessPanel'),
            bookExportSuccessBtn : $('#bookExportSuccessBtn')
        }

        _this.init = function(){
            //按钮事件绑定
            _this.buttons.closeBtn_bookExportSuccessPanel.click(function(){
                _this.controls.bookExportSuccessPanel.hide();
            })

            _this.buttons.bookExportSuccessBtn.click(function(){
                _this.controls.bookExportSuccessPanel.hide();
            })
        }

        /**
         * @param title 书本列表
         */
        _this.showBookExportSuccessPanel = function(title){
            //显示导出成功面板
            //居中显示
            _this.controls.bookExportSuccessPanel.css({
                position: 'absolute',
//                left: ($(window).width() - _this.controls.bookExportSuccessPanel.outerWidth()) / 2,
                top: ($(window).height() - _this.controls.bookExportSuccessPanel.outerHeight()) / 2 + $(document).scrollTop()
            });
            var exSuccess = false;
            var msg = "";
            //清除内容
            $("#exSuccessMsg").html("");

            var showMsg = '<table cellpadding="0" cellspacing="0" border="0" width="100%" overflow="scroll"><thead><tr><th>课本名称</th><th>完成情况</th></tr></thead><tbody>';
            $.each(title, function (i, n) {
                switch(n){
                    case 0:     //导出失败
                        msg = "导出失败";
                        break;
                    case 1:     //成功导出
                        msg = "成功导出";
                        exSuccess = true;
                        break;
                    case 2:     //成功覆盖
                        msg = "成功覆盖";
                        exSuccess = true;
                        break;
                    case 3:     //取消覆盖
                        msg = "取消覆盖";
                        break;
                    case 4:     //覆盖失败
                        msg = "覆盖失败";
                        break;
                    default:
                        msg = "导出失败";
                }
                showMsg = showMsg + '<tr><td>' + i + '</td><td>' + msg + '</td></tr>';
            });
            showMsg += "</tbody></table>";

            if (!exSuccess){
                $("#bookExportSuccessPanel").find(".data").hide();
            } else{
                $("#bookExportSuccessPanel").find(".data").show();
            }
            $("#exSuccessMsg").html(showMsg);

            //显示导出面板
            _this.controls.bookExportSuccessPanel.show();

            _this.controls.bookExportSuccessPanel.draggable({
                handle: "#" + _this.controls.bookExportSuccessPanelTop.attr("id"),
                containment: "parent",
                start: function () {
                },
                stop: function () {
                }
            });
        }
    }
    exports.Instance = new BookExportSuccessMgr();
})