/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-4
 * Time: 上午9:31
 * To change this template use File | Settings | File Templates.
 */
;
define(function(require,exports){
    var WidgetBase = require("./widgetbase").WidgetBase;
    require('browserContext');
    var define = require('../../define');
    var path = require('../../../common/path');
    require('jqjson');
    var CardWrapper = require('../../../app/card/cardwrapper').Instance;
    var shellcmd = require('../../../common/shellcmd');
    var model = require('../../model');
    var trace = require('../../trace').Instance;
    var actionType = require('../../trace').ActionType;
    var ResizeableAndDraggableBound=require('../../../common/resizeableAndDraggableBound');
    var playerMgr=require('../hotspot/playerMgr').Instance;
    require('popover');


    function WidgetVideo() {
    }

    WidgetVideo.prototype = new WidgetBase();
    WidgetVideo.prototype.constructor = WidgetVideo;

    function WidgetVideo(widgetType, obj) {
        var _this = this;
        this.WidgetType = widgetType;
        this.parse(obj);

        if (obj.video["src"] != undefined) {
            _this.File = obj.video["src"];
        }
        _this.Title = obj.video["title"];
        _this.showTitleFlag = !!(obj.video["showTitleFlag"] == "true");
        _this.showIconFlag = !!(obj.video["showIconFlag"] == "true");
        _this.description = obj.video["description"]||"";
        _this.userName = obj.video["userName"]||"";
        _this.uploadTime = obj.video["uploadTime"]||"";
        _this.score = obj.video["score"]|| 0;
        _this.userAddressInfo = obj.video["userAddressInfo"]||"";
        _this.resourceId =  obj.video["resourceId"]||"";
        _this.timestamp = obj.video["timestamp"]||"";
        if(json.TP.useDb){
            var src = obj.video['realPath'];
            var md5 = obj.video['md5'];
        }else{
            var src = path.join(obj.XamlPath, '../' + _this.File);
        }

        //是否区域播放
        this.playAsBound=false;
        if (this.PlayAreaWidth >= 0 && (path.extname(src) === '.mp4')) {
            this.player = playerMgr.createPlayer(define.PlayerType.VideoPlayer);
            this.playAsBound = this.PlayAreaWidth > 0 ? true : false;
        }

       // this.Content=this.getContent('assert/images/f_ic.png',[this.Left,this.Top,this.Width,this.Height]);
        this.Content=this.getContent();
        var _hasClick=false;
        this.Content.click(function (event) {
            // 定位到列表位置
            _this.scrollToPosition(_this);

            if (!_this.getIsEditing()) {
                _this.showIntro(_this);
                // _this.showBubble(this,_this);
                //内部全屏播放
                //请不要删除！！！！

//                if(!_hasClick){
//                    _hasClick=true;
//                    if (_this.player) {
//                        if(_this.playAsBound){
//                            _this.playAsBound=false;
//                            var currentTime= _this.player.getCurrPlayTime();
//                            _this.playVideo(currentTime);
//                            CardWrapper.one('minmize',function(){
//                                _this.playAsBound=true;
//                            });
//                        }
//                        event.stopPropagation();
//                    }
//                    else
//                     shellcmd.simpleShellExecute(path.trimPosix(_this.src)).done(function(ret){
//                         var retNumber = parseInt(ret);
//                         (retNumber < 32) && (
//                             $.Zebra_Dialog(AppCameraTips.openVideoFailure, {
//                                 'type': 'information',
//                                 'title': AppTips.WarmTips,
//                                 'buttons': [AppTips.OkTips]
//                             })
//                             );
//                     });
//                     setTimeout(function(){
//                         _hasClick=false;
//                     },500);
//                     trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
//                }
            }
            else {
                _this.showEdit(this,_this);
                /*if($(_this.Content.find(".user-popover")[1]).css("display")=="block")
                    $(_this.Content.find(".user-popover")[1]).hide();
                else{
                    $(".user-popover").hide();
                    _this.Content.popover("show", "toolbar");
                    x=$(".leftPageWrapper").width()-$(this).position().left;
                    if(x<307){
                        _this.Content.find("div[name=infoWideget_pop]").parent(".user-popover").css("left",-78);
                    }
                    var isTeachingPackage=$(document).data("isTeachingPackage");
                    if(isTeachingPackage){
                        $(".editor_ic a[name=deletefile]").show();
                    }
                }*/
            }
            event.stopPropagation();
        });

        this.Content.attr('id', _this.Id);
        this.Content.attr('data-uuid', _this.uuid);
        if(json.TP.useDb){
            this.encodeSrc= src && src.substring(0, src.lastIndexOf('/')) + '/' + encodeURIComponent(_this.File);
        }else{
            this.encodeSrc= path.join(obj.XamlPath, '../' + encodeURIComponent(_this.File));
        }
        this.src = src;
        this.setTitle(src);
        this.attachOnDragEvent();
        this.setPopover();
    }

    /**
     * 播放视频
     * @param {int=} currentTime 初始播放时间（<0则停止播放）
     */
    WidgetVideo.prototype.playVideo=function(currentTime){

        if(currentTime<0){
            //结束播放
            if(this.playContent){
                this.playContent.remove();
                this.playContent=null;
                if(!self.playAsBound)  CardWrapper.minimize();
            }
            return;
        }

        var content=$(document.getElementById('template_video_player').innerHTML);
        this.playContent=content;
        var bound;

        if(this.playAsBound){
            this.Content.css('-webkit-transform', 'matrix(1,0,0,1,0,0)');
            bound=this.getBound();
            bound.left -= (bound.width - this.Width) / 2;
            bound.top -= (bound.height - this.Height) / 2;
            this._resizeableAndDraggableBound.correctBound(bound);
            bound.height-=content.find('.head:first').outerHeight();
            this.Content.parent().append(content);
            this.player.init(content);
            this.player.play(this.Id,this.encodeSrc,{
                bound:bound,
                currentTime:currentTime,
                container:this.Content.parent()
            });
            this.Content.css('-webkit-transform', 'matrix(' + this.matrixTransform.join(',') + ')');
        }
        else
        {
            bound={left:50,top:0,width:Config.Width-100,height:Config.Height};
            content=content.find('.videoContainer');
            CardWrapper.show(content[0], this.Id);
            this.player.init(content);
            this.player.play(this.Id,this.encodeSrc,{
                bound:bound,
                currentTime:currentTime
            });

        }

        var _self=this;
        content.find("#closeBtn").one('click',function () {
            _self.playVideo(-1);
            event.stopPropagation();
        });
        content.find("#fullScreenBtn").one('click',function (event) {
            if(_self.playAsBound){
                _self.playAsBound=false;
                var currentTime= _self.player.getCurrPlayTime();
                content.remove();
                content=null;
                _self.playVideo(currentTime);
                CardWrapper.one('minmize',function(){
                    _self.playAsBound=true;
                });
            }
            event.stopPropagation();
        });
        this.player.one(this.Content,'play_error',function(event,continuePlay){
            _self.playVideo(-1);
            _self.playAsBound=false;
            _self.hideBound(false);
            _self.Content.popover('destroy');
            _self.player=null;
            _self.setPopover();
            _self.Content.popover('show','title');
            //标记为-1,下次可以直接识别不能内部播放
            _self.PlayAreaWidth=_self.PlayAreaHeight=-1;
            continuePlay&&shellcmd.simpleShellExecute(_self.src);
        });
        this.player.one(this.Content,'play_remove',function(){
            _self.playVideo(-1);
        });
    }

    WidgetVideo.prototype.getContent=function(){
        var icon,content;
        icon= 'assert/static/common/images/icon_24X24/movie.png';
        var Obj = this.getUnTransForm();
        var Obj1 = this.getUnTransFormBuble();
        // content=$("<div class='widget widgeticon' style='position: absolute;-webkit-transform:matrix("+
        //     Obj.wZoom + ",0,0," + Obj.hZoom+",0,0)'/>")
        //     .append("<div class='normal_video_play fs_closed'><img  id='normal' style='position: absolute' src='"+icon+"'/>" +
        //         "<img  id='tiny'  src='assert/images/bookicon/ic_black.png'>" +
        //         "<a id='resourceDelete' style='cursor:pointer;'></a></div>");

        content=$("<div class='jxbubble-positioning widget widgeticon' style='position: absolute;-webkit-transform:matrix("+ Obj.wZoom + ",0,0," + Obj.hZoom+",0,0)'/>")
            .append('<div class="format-bignumber format-number normal_video_play" draggable="true"></div>');
        // content.find('.normal_video_play').css({width:this.Width,height:this.Height});
        // var boundContent=  $(document.getElementById('template_video_bound').innerHTML);
        // icon='assert/images/video_play.png';
        // boundContent.find('.innerIcon').attr('src', icon);
        // content.append(boundContent);

        //对content进行包装，使其能够在书本内移动和调整大小
        var _self=this;
        this._resizeableAndDraggableBound=new ResizeableAndDraggableBound({
            content: content,
            left:this.Left,
            top:this.Top,
            minWidth:WidgetVideo.CONSTRANTS.minWidth,
            minHeight:WidgetVideo.CONSTRANTS.minHeight,
            draggable:false,  //禁用自己的拖动,采用html5的drag&drop
            resizable:false
        });
        this._resizeableAndDraggableBound.bind(content,'resize',function(event,bound){
            _self.isModify=true;
            _self.PlayAreaWidth=_self._resizeableAndDraggableBound.lastBound.width=bound.width;
            _self.PlayAreaHeight=_self._resizeableAndDraggableBound.lastBound.height=bound.height;
            _self.Content.css({left:bound.left,top:bound.top,width:_self.PlayAreaWidth,height:_self.PlayAreaHeight});
            _self.Content.find('.full_video_play').css({width:_self.PlayAreaWidth,height:_self.PlayAreaHeight});
            _self.Content.popover('reposition');
        });
        //保存上次设置的大小
        this._resizeableAndDraggableBound.lastBound={width:this.PlayAreaWidth,height:this.PlayAreaHeight};
        //等待页面加载完成
        content.one('pageLoaded',function(){
            //进行一些初始化操作
            _self.Height = 85;
            _self.Width=85;
            var container= _self.Content.parent();
            _self._resizeableAndDraggableBound.setOptions({
                container: container
            });
            if(_self.style&&_self.style.tiny!=='true')   content.find("#tiny").hide();
            else   content.find("#normal").hide();
            _self.matrixTransform = _self.getTransformMatrix(_self.Content);
            // _self.hideBound(_self.playAsBound);
        });
        return content;
    }

//    WidgetVideo.prototype.getToolBarContent = function () {
//
////        var $content = $('<dl class="toolbar" style="width: 144px;-webkit-transform:matrix(1.3,0,0,1.4,0,0);z-index:1"> \
////             <dd class="toolbar_black" id="btnFullScreen" onMouseDown="this.className=\'toolbar_black_current\'" onmouseout="this.className=\'toolbar_black\'"><img src="assert/images/tool_max.png"></dd>  \
////             <dd class="toolbar_black" id="btnDelete" onMouseDown="this.className=\'toolbar_black_current\'" onmouseout="this.className=\'toolbar_black\'"><img src="assert/images/tool_delete2.png"></dd> \
////             <dd class="ck" ><input id="btnTiny" type="checkbox" >'+ AppTips.hide +'</dd>\
////             <p class="top_arrow" style="display: none"><img src="assert/images/toolbar_arrow.png"></p>\
////             <p class="bot_arrow"><img src="assert/images/toolbar_arrow2.png"></p> \
////             </dl> ');
//        <!--资源属性框-->
//        var $content = $(' <div class="re_attr">'
//            +'<div class="re_attr_tit">'
//            +'<a href="javascript:;" name="resourceItem" class="re_attr_btn_view current" title="查看">查看</a>'
//            +'<a href="javascript:;" name="resourceItem" class="re_attr_btn_edit" title="编辑">编辑</a>'
//            +'<a href="javascript:;" name="resourceItem" class="re_attr_btn_name" title="名称不可见">名称不可见</a>'
//            +'<a href="javascript:;" name="resourceItem" class="re_attr_btn_icon" title="图标隐藏">图标隐藏</a>'
////                                +'<a href="javascript:;" class="re_attr_btn_icon" title="上传云盘">上传云盘</a>'
////                                +'<a href="javascript:;" class="re_attr_btn_icon" title="分享">分享</a>'
//            +'</div>'
//
//            +'<div class="re_attr_cont">'
//            +'<div class="re_attr_cont_img">'
//            +'      <span class="re_attr_cont_avatar">'
//            +'        <img src="./assert/images/re_attr_cont_img.jpg" alt="">'
//            +'     </span>'
//            +'     <p class="re_attr_cont_kj"> 示例课件1</p>'
//            +'    <p> 王老师 </p>'
//            +' </div>'
//            +' <p class="re_attr_cont_des"> 描述：这是关于资源内容的描述。这是关于资源内容的描述。这是关于资源内容的描述。</p>'
//            +'</div>'
//            +'<p class="re_attr_cont_time">'
//            +'<span>最近修改：2014-07-08 16:00</span>'
//            +'<span>创建时间：2014-07-08 12:00</span>'
//            +'</p>'
//            +'</div>');
//        <!--/资源属性框-->
//        if(AppCfg.lang == "uyghur"){
//            $content.css("width","170px");
//        }
//        var _self = this;
//        $content.find("#btnFullScreen").click(function () {
//            if (_self.player) {
//                var playerContainer = $(document.getElementById('template_video_player').innerHTML).find(".videoContainer").css({width: '580px', height: '445px'});
//                var player=playerContainer.find("video:first").css({width: '580px', height: '445px'});
//                _self.player.setTempNewPlayer(playerContainer);
//                var container=_self.showResScanPanel(playerContainer);
//                _self.player.play(player.attr('id'),_self.encodeSrc,{
//                    container: container
//                });
//            }
//            else shellcmd.simpleShellExecute(path.trimPosix(_self.src));
//            event.stopPropagation();
//        });
//
//        if (this.player) {
//            $content.css('width', "274px");
//            $content.find("#btnDelete").after('<dd class="ck" ><input id="btnPlayAsArea" name="btnPlayAsArea" type="checkbox" >'+ AppTips.fullScreen+'</dd>');
//
//            if(AppCfg.lang == "uyghur"){
//                $content.css("width","380px");
//            }
//
//            var btnPlayAsArea = $content.find('#btnPlayAsArea');
//            btnPlayAsArea.prop("checked", _self.playAsBound);
//            btnPlayAsArea.click(function (event) {
//                var isChecked = $(this).prop("checked");
//                if (!_self.isModify) _self.isModify =_self.PlayAreaWidth ? isChecked : !isChecked;
//                isChecked?_self.hideBound():_self.showBound();
//                event.stopPropagation();
//            });
//        }
//        this._bindToolBarCommands($content);
//        return $content;
//    }

    /**
     * 资源查看
     */
    WidgetVideo.prototype.resourcePreview = function(event){
        var _this  = this;
        var _hasClick=false;
        if(!_hasClick){
            _hasClick=true;
//            if (_this.player) {
////                _this.playVideo();
//                if(_this.playAsBound){
//                    _this.playAsBound=false;
//                    var currentTime= _this.player.getCurrPlayTime();
//                    _this.playVideo(currentTime);
//                    CardWrapper.one('minmize',function(){
//                        _this.playAsBound=true;
//                    });
//                }
////                event.stopPropagation();
//            }
//            else
//            shellcmd.simpleShellExecute(path.trimPosix(_this.src));
//            setTimeout(function(){
//                _hasClick=false;
//            },500);
//            trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
            shellcmd.simpleShellExecute(path.trimPosix(_this.src)).done(function(ret){
                var retNumber = parseInt(ret);
                (retNumber < 32) && (
                    $.Zebra_Dialog(AppCameraTips.openVideoFailure, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [AppTips.OkTips]
                    })
                    );
            });
            setTimeout(function(){
                _hasClick=false;
            },500);
            trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
        }
//        event.stopPropagation();

    };
    /**
     * 资源编辑
     */
    WidgetVideo.prototype.resourceEditor = function(event){
        alert("当前资源不可编辑")
    };

    WidgetVideo.prototype.getBound=function(){
        var bound;
        if(this._resizeableAndDraggableBound.getOption('container')){
            bound= this._resizeableAndDraggableBound.getBound(this._resizeableAndDraggableBound.lastBound);
            this._resizeableAndDraggableBound.lastBound={width:bound.width,height:bound.height};
        }
        else{
            bound=new model.Bound(this.Left,this.Top,this.Width,this.Height);
            if(this.playAsBound){
                bound.width=this.PlayAreaWidth;
                bound.height=this.PlayAreaHeight;
                bound.left+= (bound.width- this.Width) / 2;
                bound.top+=(bound.height - this.Height) / 2;
            }
        }
        return bound;
    }

    WidgetVideo.prototype.showBound=function(playAsBound){

        if(playAsBound===undefined) this.playAsBound=!this.playAsBound;
        else this.playAsBound=this.player&&playAsBound;
        this.playAsBound=this.player&&this.playAsBound;

        if(this.playAsBound&&this.IsEditing){
            this.Width=this.Height=85;
            var bound=this.getBound();
            bound.left -= (bound.width - this.Width) / 2;
            bound.top -= (bound.height - this.Height) / 2;
            this.PlayAreaWidth=bound.width;
            this.PlayAreaHeight=bound.height;

            this._resizeableAndDraggableBound.setOptions({
                resizable:true
            });

            //由于要支持低分辨率,widget的大小会动态进行放缩,在调整大小时在把它调整回去,否则在移动时位置会发生偏差
            this.Content.css('-webkit-transform', 'matrix(1,0,0,1,0,0)');
            this.Content.find('.user-popover').css('-webkit-transform', 'matrix(' + this.matrixTransform.join(',') + ')');

            this._resizeableAndDraggableBound.show(bound);
            this.Content.find('.normal_video_play').hide();
            this.Content.find('.resizeCorner').show();
            this.Content.find('.full_video_play').css({width:bound.width,height:bound.height
                ,background:'url(assert/images/video_play_back.png) repeat'}).show();
            this.Content.find('#btnPlayAsArea').prop('checked',false);
            this.Content.popover('reposition');
        }
    }

    WidgetVideo.prototype.hideBound=function(playAsBound){
        var isLastPlayAsBound=this.playAsBound;
        if(playAsBound===undefined) this.playAsBound=!this.playAsBound;
        else this.playAsBound=playAsBound;
        this.playAsBound=this.player&&this.playAsBound;

        if(!this.playAsBound){
            this.Width=26;
            this.Height=33;
        }
        else this.Width=this.Height=85;

        var bound=this.getBound();
        if (isLastPlayAsBound) {
            bound.left += (bound.width - this.Width) / 2;
            bound.top += (bound.height - this.Height) / 2;
        }
        bound.width = this.Width;
        bound.height = this.Height;

        if(!this.playAsBound){
            this.PlayAreaWidth = this.PlayAreaHeight = 0;
            this.Content.find('.full_video_play').hide();
            this.Content.find('.normal_video_play').css({width:this.Width,height:this.Height}).show();
            this.Content.find('#btnPlayAsArea').prop('checked',true);
        }
        else{
            if(this.style&&this.style.tiny==='true'){
                this.Content.find('.full_video_play').css({width:this.Width,height:this.Height,background:"none",border:'0px'}).hide();
                var content= this.Content.find('.normal_video_play');
                content.css({width:this.Width,height:this.Height}).show();
                content.find('#tiny').show();
                content.find('#normal').hide();
            }
            else{
                this.Content.find('.normal_video_play').hide();
                this.Content.find('.resizeCorner').hide();
                this.Content.find('.full_video_play').css({width:this.Width,height:this.Height,background:"none",border:'0px'}).show();
            }
        }

        this.Content.css('-webkit-transform', 'matrix(' + this.matrixTransform.join(',') + ')');
        this.Content.find('.user-popover').css('-webkit-transform', 'matrix(1,0,0,1,0,0)');

        this._resizeableAndDraggableBound.setOptions({
            resizable:false
        });
        this._resizeableAndDraggableBound.show(bound);
        this.IsEditing&&this.Content.popover('reposition');
    }

    WidgetVideo.prototype.destroy=function(isDeleteSrc){
        if(this.Content){
            this.Content.remove();
            this.Content=null;
            this.releaseRes();
            if (isDeleteSrc && this.src) {
                var dst = this.src.replace(/\//g, "\\");
                shellcmd.deleteFile(dst);
            }
        }
    }

    WidgetVideo.prototype.releaseRes=function(){
        if(this.player){
            this.playContent=null;
            this.player&&this.player.destroy();
            this.player=null;
        }
    }


//    WidgetVideo.prototype.setIsEditing=function(value){
//        if(this.IsEditing===value) return;
//        this.IsEditing = value;
//        !this.IsEditing? this.Content.find("#resourceDelete").hide():this.Content.find("#resourceDelete").show();
////        if (value) {
////            this.playVideo(-1);
////            this.showBound(this.playAsBound);
////            this.Content.popover('show', 'title');
////        }
////        else {
////            this.Content.popover('hide');
////            this.hideBound(this.playAsBound);
////        }
//    }

    WidgetVideo.prototype.toXml=function(){
        var xmlResult = '\n<eb:';
        var widgetContent;
        widgetContent = '\n<video src= "{0}" uploadTime="{8}" score="{9}" userAddressInfo="{10}" resourceId="{11}" timestamp="{12}" title="{1}" showTitleFlag="{2}" showIconFlag="{3}" description="{6}" userName="{7}" />\n<layout src="{4}" style="{5}" thumb=""/>'
            .format(this.File, this.Title ,
                (this.showTitleFlag === undefined) ? true : this.showTitleFlag ,
                (this.showIconFlag === undefined) ? true : this.showIconFlag,
                this.layout.src, this.layout.style,this.description,
                this.userName,this.uploadTime,this.score,this.userAddressInfo,this.resourceId ,this.timestamp);
        widgetContent += ' \n<event action="opened" style="zoomin_anim" />' +
            '\n<event action="closed" style="zoomout_anim" />';

        var bound=this.getBound();
        if(this.playAsBound&&!this.IsEditing){
            bound.left -= (bound.width - this.Width) / 2;
            bound.top -= (bound.height - this.Height) / 2;
        }

        xmlResult += '{0} id="{1}" bound="{2};{3};{4};{5}" editable="{6}" style="{7}" '
            .format(this.WidgetType, this.Id,bound.left , bound.top, this.PlayAreaWidth, this.PlayAreaHeight, this.IsEditing,this.style.toString());

        xmlResult += ">";
        xmlResult += widgetContent;
        xmlResult += "\n</eb:{0}>".format(this.WidgetType);

        return xmlResult;
    }

    //最小播放区域
    WidgetVideo.CONSTRANTS={
        minWidth:350,
        minHeight:350
    }


    exports.WidgetVideo = WidgetVideo;
});
