/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-4
 * Time: 上午9:37
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {
    var WidgetBase = require("./widgetbase").WidgetBase;
    var WidgetImg = require("./widgetimg").WidgetImg;
    require('browserContext');
    var define = require('../../define');
    var path = require('../../../common/path');
    require('jqjson');
    var shellcmd = require('../../../common/shellcmd');
    var trace = require('../../trace').Instance;
    var actionType = require('../../trace').ActionType;
    var playerMgr = require('../hotspot/playerMgr').Instance;
    var _pptIcwsAccessor = require('../resbar/ppticwsaccessor').Instance;
    require('popover');

    function _getPro3dIcon(file) {
        var icon;
        var ext = path.extname(file).toLowerCase();
        var extFilter = define.extFilter.array;
        for (var i in extFilter.officeExtArray) {
            if (extFilter.officeExtArray.hasOwnProperty(i) && $.inArray(ext, extFilter.officeExtArray[i]) != -1) {
                icon = i + "_ic.png";
                break;
            }
        }
        if (!icon) {
            if ($.inArray(ext, extFilter.htmlExtArray) != -1)
                icon = "htm_ic.png";
            else if ($.inArray(ext, extFilter.execExtArray) != -1)
                icon = 'exe_ic.png';
            else icon = "default.png";
        }
        return icon;
    }

    function WidgetProc3d() {
    }

    WidgetProc3d.prototype = new WidgetBase();
    WidgetProc3d.prototype.constructor = WidgetProc3d;

    function WidgetProc3d(widgetType, obj) {
        var _this = this;
        this.WidgetType = widgetType;
        this.parse(obj);
        this.obj = obj;
        if (obj.file["src"] != undefined) {
            _this.File = obj.file["src"];
        }
        _this.realPath = obj.realPath || obj.file.realPath;
        _this.md5 = obj.md5 || obj.file.md5 || "";
        _this.Title = obj.file["title"];
        //兼容新疆
//        if (_this.Title == undefined){
//            var titleUnit = _this.File.split('`');
//            var title='';
//            for(var i = 0 ;i < titleUnit.length ; i++){
//                title += String.fromCharCode(parseInt(titleUnit[i]));
//            }
//             _this.Title = title;
//        }
        _this.showTitleFlag = !!(obj.file["showTitleFlag"] == "true");
        _this.showIconFlag = !!(obj.file["showIconFlag"] == "true");
        _this.description = obj.file["description"] || "";
        _this.userName = obj.file["userName"] || "";
        _this.uploadTime = obj.file["uploadTime"] || "";
        _this.score = obj.file["score"] || 0;
        _this.userAddressInfo = obj.file["userAddressInfo"] || "";
        _this.resourceId = obj.file["resourceId"] || "";
        _this.timestamp=obj.file["timestamp"] || "";
        var icon = 'assert/images/bookicon/' + _getPro3dIcon(_this.File);
        if(json.TP.useDb){
            var src = obj.file['realPath'];
            var md5 = obj.file['md5'];
        }else{
            var src = path.join(obj.XamlPath, '../' + _this.File);
        }

        this.Content = this.getContent(icon, [this.Left, this.Top, this.Width, this.Height]);
        this.Content.click(function (event) {
            // 定位到列表位置
            _this.scrollToPosition(_this);

            if (!_this.getIsEditing()) {
                _this.showIntro(_this);
                // _this.showBubble(this,_this);
//                //查看的不是原物理路径，而是userBook文件夹下的文件
//                shellcmd.isFileExist(_this.realPath).done(function (ret) {
////                    var executePath = _this.realPath;
////                    if (!ret) executePath = src;
//                    var executePath = src;
//                    shellcmd.shellExecute(executePath);
//                    trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
//                })
//                 _this.resourcePreview();
            }
            else {
                _this.showEdit(this,_this);
            }
            event.stopPropagation();
        });

        this.Content.attr('id', _this.Id);
        this.Content.attr('data-uuid', _this.uuid);
        this.src = src;
        this.attachOnDragEvent();
        this.setTitle();
        this.setPopover();
    }


    /**
     * 资源查看
     */
    WidgetProc3d.prototype.resourcePreview = function (event) {
        var _this = this;
        var obj = this.obj;
        if(json.TP.useDb){
            var src = _this.src || _this.realPath;
            shellcmd.isFileExist(src).done(function (ret) {
                if(ret){
                    shellcmd.shellExecute(src);
                    trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
                }else{
                    console.log('资源不存在，resourcePreview失败');
                }
            });
        }else{
            var src = path.join(obj.XamlPath, '../' + _this.File);
            shellcmd.isFileExist(_this.realPath).done(function (ret) {
                var executePath = src;
                shellcmd.shellExecute(executePath);
                trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
            });
        }
    };

    /**
     * 资源编辑
     */
    WidgetProc3d.prototype.resourceEditor = function (event, mode) {
        var _this = this;
        var obj = this.obj;
        if(json.TP.useDb){
            var src = _this.realPath || _this.src;
        }else{
            var src = path.join(obj.XamlPath, '../' + _this.File || _this.file.src);
        }
        var executePath = src;
        //这几句是以前的启用方式，为了能够在关闭ppt等文件时进入回调而放弃，方法本身的写法是正确的，可以参照。
        // if (mode == 'edit') {
        //     //  alert('mode');
        //     executePath = executePath + '| ';
        // };
        // shellcmd.shellExecute(executePath);
        //打开软件进行编辑
        var exec = nodereq('child_process').exec;
        var childProcess = exec('"' + executePath + '"');
        // childProcess.on('exit', function (code) {
        //     if(code==0){
        //         console.log("Edit end:"+executePath);
        //         //回调，保存到TA对应目录下
        //         // IFB卡片保存路径
        //         var timestamp=obj.file.timestamp;
        //         var fileid=obj.file.resourceId;
        //         var ifbFilepath=src;
        //         var condition = {
        //             "filename" :obj.file.title,
        //             "unit1" : "",
        //             "unit2" : "",
        //             "unit3" : "",
        //             "unit4" : "",
        //             "timestamp" : timestamp,
        //             "fileid" : fileid,
        //             "type" : obj.file.src.substring(obj.file.src.lastIndexOf(".")+1),
        //             "bookcode" : "",
        //             "filepath" : obj.file.src,
        //             "filesavepath":"",
        //             "lasttime" : new Date().Format("yyyy-MM-dd hh:mm:ss"),
        //             "creator": obj.file.userName,
        //             "size": "",
        //             "secondType":""
        //         };
        //         //写入TA数据库并复制文件到TA
        //         _pptIcwsAccessor.addInfoWithCopyFile(condition,ifbFilepath).done(function(ret){
        //             console.log("success");
        //         }).fail(function(e){
        //             console.log("写TA数据库失败");
        //         });
        //     };
        // });
        trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
        //   shellcmd.isFileExist(_this.realPath).done(function (ret) {
        //     var executePath = _this.realPath;
        //   if (!ret) executePath = src;
        //  if (mode == 'edit'){
        //  alert('mode');
        //     executePath = executePath + '| ';
        // }

        //   shellcmd.shellExecute(executePath);
        //     trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
        //   })
        event.stopPropagation();
    };

//gallery
    WidgetProc3d.prototype.getToolBarContent = function (event) {
        var $content = WidgetImg.prototype.getToolBarContent.call(this);
        var _this = this;
        $content.find("#btnFullScreen").unbind().click(function () {
            _this.IsEditing = false;
            _this.Content.triggerHandler('click');
            _this.IsEditing = true;
            event.stopPropagation();
        });
        return $content;
    }

    WidgetProc3d.prototype.destroy = function (isDeleteSrc) {
        if (this.Content) {
            isDeleteSrc = isDeleteSrc == undefined ? true : isDeleteSrc;
            if (isDeleteSrc && this.src) {
                var dst = this.src.replace(/\//g, "\\");
                shellcmd.deleteFile(dst);
            }
            this.Content.remove();
            this.Content = null;
        }
    }

    WidgetProc3d.prototype.toXml = function () {
        var xmlResult = '\n<eb:';
        var widgetContent;
        widgetContent = '\n<file src= "{0}" uploadTime="{9}" score="{10}" userAddressInfo="{11}" resourceId="{12}" timestamp="{13}" title="{1}" realPath="{2}" showTitleFlag="{3}" showIconFlag="{4}" description="{7}" userName="{8}" />\n<layout src="{5}" style="{6}"/>'
            .format(this.File, this.Title, this.realPath,
                (this.showTitleFlag === undefined) ? true : this.showTitleFlag,
                (this.showIconFlag === undefined) ? true : this.showIconFlag,
                this.layout.src, this.layout.style, this.description,
                this.userName, this.uploadTime, this.score, this.userAddressInfo, this.resourceId,this.timestamp);

        var left = parseFloat(this.Content.css('left')), top = parseFloat(this.Content.css('top'));
        xmlResult += '{0} id="{1}" bound="{2};{3};{4};{5}" editable="{6}" style="{7}" '
            .format(this.WidgetType, this.Id, left, top, this.PlayAreaWidth, this.PlayAreaHeight, this.IsEditing, this.style.toString());

        xmlResult += 'type="' + this.type + '"';
        xmlResult += ">";
        xmlResult += widgetContent;
        xmlResult += "\n</eb:{0}>".format(this.WidgetType);
        return xmlResult;

        return xmlResult;

    }

    WidgetProc3d.prototype.setIsEditing = function (value) {
        this.IsEditing = value;
        !this.IsEditing ? this.Content.find("#resourceDelete").hide() : this.Content.find("#resourceDelete").show();
        !this.IsEditing ? this.Content.find("#resRDEdit").hide() : this.Content.find("#resRDEdit").show();

        this.showTitleSet();
        this.resourceIconHide();
    }

    /**
     * @param icon 资源图标
     * @param bound 定位
     * @returns {*|jQuery}
     */
    WidgetProc3d.prototype.getContent = function (icon, bound) {
        if (!icon || !bound) return;
        var Obj = this.getUnTransForm();
        var Obj1 = this.getUnTransFormBuble();
        var content = null;

        var extension = path.extname(this.File).toLowerCase();

        var iconDict = {
            "ppt":[".ppt",".pptx",".pps",".ppsx"],
            "word":[".doc",".docx"],
            "excel":[".xls",".xlsx"],
            "txt":[".txt"],
            "pdf":[".pdf"]
        };
        var iconSrc = "assert/static/common/images/icon_24X24/default.png";
        for(var key in iconDict){
            if(iconDict[key].indexOf(extension) >= 0){
                iconSrc = "assert/static/common/images/icon_24X24/" + key + ".png";
                break;
            }
        }

        if(extension=='.doc'||extension=='.docx'||extension=='.txt'||extension=='.ppt'||extension=='.pptx'
            ||extension=='.xlsx'||extension=='.xls'||extension=='.pps'||extension=='.ppsx'){
            content =
                $('<div class="jxbubble-positioning widgeticon" style="position: absolute; -webkit-transform:matrix('+ Obj.wZoom + ",0,0," + Obj.hZoom + ",0,0"+ ');"></div>')
                    .append('<div class="format-bignumber format-number" draggable="true"></div>')
                    .css({
                        'top': bound[0] + 'px',
                        'left': bound[1] + 'px'
                        // 'width': bound[2] + 'px',
                        // 'height': bound[3] + 'px'
                    });
        }
        else{
            content =
                $('<div class="jxbubble-positioning widgeticon" style="position: absolute; -webkit-transform:matrix('+ Obj.wZoom + ",0,0," + Obj.hZoom + ",0,0"+ ');"></div>')
                    .append('<div class="format-bignumber format-number" draggable="true"></div>')
                    .css({
                        'top': bound[0] + 'px',
                        'left': bound[1] + 'px'
                        // 'width': bound[2] + 'px',
                        // 'height': bound[3] + 'px'
                    });
        }

        (this.style && this.style.tiny !== 'true') ? (content.find("#tiny").hide()) : content.find("#normal").hide();

        return content;
    }


    exports.WidgetProc3d = WidgetProc3d;
});
