/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-4
 * Time: 上午9:37
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {
    var WidgetBase = require("./widgetbase").WidgetBase;
    var WidgetImg = require("./widgetimg").WidgetImg;
    require('browserContext');
    var define = require('../../define');
    var path = require('../../../common/path');
    require('jqjson');
    var shellcmd = require('../../../common/shellcmd');
    var trace = require('../../trace').Instance;
    var actionType = require('../../trace').ActionType;
    var playerMgr = require('../hotspot/playerMgr').Instance;
    var _pptIcwsAccessor = require('../resbar/ppticwsaccessor').Instance;
    require('popover');

    function _getPro3dIcon(file) {
        var icon;
        var ext = path.extname(file).toLowerCase();
        var extFilter = define.extFilter.array;
        for (var i in extFilter.officeExtArray) {
            if (extFilter.officeExtArray.hasOwnProperty(i) && $.inArray(ext, extFilter.officeExtArray[i]) != -1) {
                icon = i + "_ic.png";
                break;
            }
        }
        if (!icon) {
            if ($.inArray(ext, extFilter.htmlExtArray) != -1)
                icon = "htm_ic.png";
            else if ($.inArray(ext, extFilter.execExtArray) != -1)
                icon = 'exe_ic.png';
            else icon = "default.png";
        }
        return icon;
    }

    function WidgetInteractiveCard() {
    }

    WidgetInteractiveCard.prototype = new WidgetBase();
    WidgetInteractiveCard.prototype.constructor = WidgetInteractiveCard;

    function WidgetInteractiveCard(widgetType, obj) {
        var _this = this;
        this.WidgetType = widgetType;
        this.secondWidgetType=obj.type;
        this.parse(obj);
        this.obj = obj;
        if (obj.file["src"] != undefined) {
            _this.File = obj.file["src"];
        }
        _this.realPath = obj.realPath || obj.file.realPath;
        _this.md5 = obj.md5 || obj.file.md5 || "";
        _this.Title = obj.file["title"];
        //兼容新疆
//        if (_this.Title == undefined){
//            var titleUnit = _this.File.split('`');
//            var title='';
//            for(var i = 0 ;i < titleUnit.length ; i++){
//                title += String.fromCharCode(parseInt(titleUnit[i]));
//            }
//             _this.Title = title;
//        }
        _this.showTitleFlag = !!(obj.file["showTitleFlag"] == "true");
        _this.showIconFlag = !!(obj.file["showIconFlag"] == "true");
        _this.description = obj.file["description"] || "";
        _this.userName = obj.file["userName"] || "";
        _this.uploadTime = obj.file["uploadTime"] || "";
        _this.score = obj.file["score"] || 0;
        _this.userAddressInfo = obj.file["userAddressInfo"] || "";
        _this.resourceId = obj.file["resourceId"] || "";
        _this.timestamp=obj.file["timestamp"] || "";
        _this.type = obj.type;
        var icon = 'assert/images/bookicon/' + _getPro3dIcon(_this.File);
        if(json.TP.useDb){
            var src = obj.file['realPath'];
            var md5 = obj.file['md5'];
            //文件绝对路径
            var fileFullPath = src;
        }else{
            var src = path.join(obj.XamlPath, '../' + _this.File);
            //文件绝对路径
            var fileFullPath=xamlPath.substring(0,xamlPath.lastIndexOf("/")+1)+obj.file.src;
        }

        this.Content = this.getContent(icon, [this.Left, this.Top, this.Width, this.Height]);
        this.Content.click(function (event) {
            // 定位到列表位置
            _this.scrollToPosition(_this);

            if (!_this.getIsEditing()) {
                _this.showIntro(_this);
                // _this.showBubble(this,_this);
//                //查看的不是原物理路径，而是userBook文件夹下的文件
//                shellcmd.isFileExist(_this.realPath).done(function (ret) {
////                    var executePath = _this.realPath;
////                    if (!ret) executePath = src;
//                    var executePath = src;
//                    shellcmd.shellExecute(executePath);
//                    trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
//                })
//                 _this.resourcePreview();
            }
            else {
                _this.showEdit(this,_this);
            }
            event.stopPropagation();
        });

        //写缩略图文件
        var xamlPath = obj.XamlPath;
        //文件resourceID
        var resourceId=obj.file.resourceId;
        setTimeout(function(){
            _this.writeThumbnailFile(fileFullPath,resourceId,false);
        },200)



        this.Content.attr('id', _this.Id);
        this.Content.attr('data-uuid', _this.uuid);
        this.src = src;
        this.attachOnDragEvent();
        this.setTitle();
        this.setPopover();
    }


    /**
     * 资源查看
     */
    WidgetInteractiveCard.prototype.resourcePreview = function (event) {
        var _this = this;
        var obj = this.obj;
        if(json.TP.useDb){
            var src = _this.src || _this.realPath;
            src = path.toPosix(src || "");
            var exec = nodereq('child_process').exec;
            var cartToolExePath = path.join(Config.binPath, "../../../tools/card_tool/nw.exe").replace('file:/', '');
            var childProcess = exec('"' + cartToolExePath + '"  "' + src + '"');
            trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
        }else {
            var src = path.join(obj.XamlPath, '../' + _this.File);
            src = path.toPosix(src || "");
            var exec = nodereq('child_process').exec;
            var cartToolExePath = path.join(Config.binPath, "../../../tools/card_tool/nw.exe").replace('file:/', '');
            var childProcess = exec('"' + cartToolExePath + '"  "' + src + '"');
            trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
        }
    };


    //写卡片的缩略图文件，参数：sco文件绝对路径，文件resourceId
    WidgetInteractiveCard.prototype.writeThumbnailFile=function(fileFullPath,resourceId,reWriteThumb){
        if(fileFullPath&&resourceId){
            var thumbnailFilePath=fileFullPath.substring(0,fileFullPath.lastIndexOf("/")+1)+resourceId+".jpg";
            if(shellcmd.isFileExistSync(thumbnailFilePath)&&!reWriteThumb){
                //如果缩略图存在，返回
                return ;
            }else{
                //这一段处理是为了将互动卡片缩略图插入对应目录
                //第一次读取文件，第一次读取文件是为了判断从哪里开始截图需要的信息，第二次读取文件是读取截取的信息
                // 文件格式是“<!--SCOThumb,44470=data:imagexxxxxx”，44470是data长度，需要从data开始截取，截取44470长度
                this.getInfotoWriteThunbnail(fileFullPath).done(function(data){
                    var reg=/(\w+?),(\d+)?=/;
                    //正则后结果
                    var regResult=reg.exec(data);
                    //startIndex1是正则从第几位开始，startIndex2是正则截取长度
                    var startIndex1=data.search(reg);
                    var startIndex2=regResult[0].length;
                    var startIndex=startIndex1+startIndex2;
                    var endIndex=parseInt(regResult[2])+startIndex;
                    //第二次读取文件，这次需要把所有的图片信息读取出来
                    var readStream=fs.createReadStream(fileFullPath,{start:startIndex,end:endIndex});
                    var writeStream = fs.createWriteStream(thumbnailFilePath);
                    readStream.setEncoding("utf8");
                    var bufs="";
                    readStream.on("data",function(data){
                        bufs=bufs+data;
                    });
                    readStream.on('end', function() {// 当没有数据时，关闭数据流
                        var base64Data=bufs.replace(/^data:image\/\w+;base64,/,"");
                        var dataBuffer = new Buffer(base64Data,'base64');
                        writeStream.write(dataBuffer);
                    });
                })
            }
        }else{
            //如果有一个参数为空，报错
            console.log("写sco文件缩略图失败！")
        }
    };


    WidgetInteractiveCard.prototype.getInfotoWriteThunbnail=function(fileFullPath){
        var deffer = $.Deferred();
        var readStream=fs.createReadStream(fileFullPath,{start:0,end:100});
        readStream.setEncoding("utf8");
        var result=""
        //第一次读取到的字符串
        readStream.on("data",function (data) {
            result=result+data;
        });
        readStream.on("end",function () {
            deffer.resolve(result);
        });
        return deffer.promise();
    }


    /**
     * 资源编辑
     */
    WidgetInteractiveCard.prototype.resourceEditor = function (event, mode) {
        var _this = this;
        var obj = this.obj;
        var src = _this.src || _this.realPath;
        src=path.toPosix(src || "");
        var type=obj.type;
        var exec = nodereq('child_process').exec;
        var cartToolExePath = path.join(Config.binPath ,"../../../tools/card_tool/nw.exe").replace('file:/','');
        var childProcess = exec('"' + cartToolExePath + '" --action=edit --cardType='+type+' --path="' + src + '"');
        childProcess.on('exit', function (code) {
            if(code == 0) {
                //这段是老代码，我感觉没用了，但是为了以防万一放着吧..
                // //回调，编辑完成后，保存到TA对应目录下（文件复制替换，数据库update）
                // // IFB卡片保存路径
                // var Fileid=obj.file.resourceId;
                // var timestamp=obj.file.timestamp;
                // var ifbFilepath=src;
                // var condition = {
                //     "filename" :obj.file.title,
                //     "unit1" : "",
                //     "unit2" : "",
                //     "unit3" : "",
                //     "unit4" : "",
                //     "timestamp" : timestamp,
                //     "fileid" : Fileid,
                //     "type" : "sco",
                //     "bookcode" : "",
                //     "filepath" : obj.file.src ,
                //     "filesavepath":"",
                //     "lasttime" : new Date().Format("yyyy-MM-dd hh:mm:ss"),
                //     "creator": obj.file.userName,
                //     "size": "",
                //     "secondType":type
                // };
                // //写入TA数据库并复制文件到TA
                // _pptIcwsAccessor.addInfoWithCopyFile(condition,ifbFilepath).done(function(ret){
                //     console.log("success");
                //
                // }).fail(function(e){
                //     console.log("写TA数据库失败");
                // });
            };
            //写缩略图文件
            var xamlPath = obj.XamlPath;
            //文件resourceID
            var resourceId=obj.file.resourceId;
            var fileFullPath=src;
            setTimeout(function(){
                _this.writeThumbnailFile(fileFullPath,resourceId,true);
            },200)
        });
        trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
        event.stopPropagation();
    };

//gallery
    WidgetInteractiveCard.prototype.getToolBarContent = function (event) {
        var $content = WidgetImg.prototype.getToolBarContent.call(this);
        var _this = this;
        $content.find("#btnFullScreen").unbind().click(function () {
            _this.IsEditing = false;
            _this.Content.triggerHandler('click');
            _this.IsEditing = true;
            event.stopPropagation();
        });
        return $content;
    }

    WidgetInteractiveCard.prototype.destroy = function (isDeleteSrc) {
        if (this.Content) {
            isDeleteSrc = isDeleteSrc == undefined ? true : isDeleteSrc;
            if (isDeleteSrc && this.src) {
                var dst = this.src.replace(/\//g, "\\");
                shellcmd.deleteFile(dst);
            }
            this.Content.remove();
            this.Content = null;
        }
    }

    WidgetInteractiveCard.prototype.toXml = function () {
        var xmlResult = '\n<eb:';
        var widgetContent;
        widgetContent = '\n<file src= "{0}" uploadTime="{9}" score="{10}" userAddressInfo="{11}" resourceId="{12}" timestamp="{13}" title="{1}" realPath="{2}" showTitleFlag="{3}" showIconFlag="{4}" description="{7}" userName="{8}" />\n<layout src="{5}" style="{6}"/>'
            .format(this.File, this.Title, this.realPath,
                (this.showTitleFlag === undefined) ? true : this.showTitleFlag,
                (this.showIconFlag === undefined) ? true : this.showIconFlag,
                this.layout.src, this.layout.style, this.description,
                this.userName, this.uploadTime, this.score, this.userAddressInfo, this.resourceId, this.timestamp);

        var left = parseFloat(this.Content.css('left')), top = parseFloat(this.Content.css('top'));
        xmlResult += '{0} id="{1}" bound="{2};{3};{4};{5}" editable="{6}" style="{7}" '
            .format(this.WidgetType, this.Id, left, top, this.PlayAreaWidth, this.PlayAreaHeight, this.IsEditing, this.style.toString());

        xmlResult += 'type="' + this.type + '"';
        xmlResult += ">";
        xmlResult += widgetContent;
        xmlResult += "\n</eb:{0}>".format(this.WidgetType);
        return xmlResult;

        return xmlResult;

    }

    WidgetInteractiveCard.prototype.setIsEditing = function (value) {
        this.IsEditing = value;
        !this.IsEditing ? this.Content.find("#resourceDelete").hide() : this.Content.find("#resourceDelete").show();
        !this.IsEditing ? this.Content.find("#resRDEdit").hide() : this.Content.find("#resRDEdit").show();

        this.showTitleSet();
        this.resourceIconHide();
    }

    /**
     * @param icon 资源图标
     * @param bound 定位
     * @returns {*|jQuery}
     */
    WidgetInteractiveCard.prototype.getContent = function (icon, bound) {
        if (!icon || !bound) return;
        var Obj = this.getUnTransForm();
        var Obj1 = this.getUnTransFormBuble();
        var content = null;
        var extension = path.extname(this.File).toLowerCase();
        var type=this.obj.type;
        var typeUrl="";
        switch (type) {
            default:
                typeUrl="gallery";
            case "galary":
                typeUrl="gallery";
            break;
            case "cneval":
                typeUrl="cneval";
            break;
            case "eneval":
                typeUrl="eneval";
                break;
            case "exercise":
                typeUrl="exercise";
                break;
            case "situdlg":
                typeUrl="situdlg";
                break;
            case "flipcard":
                typeUrl="flipcard";
                break;
            case "history":
                typeUrl="history";
                break;
            case "matchcard":
                typeUrl="matchcard";
                break;
            case "mathequation":
                typeUrl="mathequation";
                break;
            case "pickcard":
                typeUrl="pickcard";
                break;
            case "onlineexam":
                typeUrl="onlineexam";
                break;
            case "mindmap":
                typeUrl="mindmap";
                break;
            case "onlinesupple":
                typeUrl="onlinesupple";
                break;
        }
        var iconSrc = "assert/static/common/images/interactivecard/"+typeUrl+".png";

        //if(extension=='.doc'||extension=='.docx'||extension=='.txt'||extension=='.ppt'||extension=='.pptx'
        //    ||extension=='.xlsx'||extension=='.xls'||extension=='.pps'||extension=='.ppsx'){
        //    content =
        //       $('<div class="jxbubble-positioning widgeticon" style="position: absolute; -webkit-transform:matrix('+ Obj.wZoom + ",0,0," + Obj.hZoom + ",0,0"+ ');"></div>')
        //        .append('<div class="format-bignumber format-number" draggable="true"></div>')
        //                .append("<div class='user-popover jxbubble-box jxbubble-left w160' style='display: none;cursor: pointer;-webkit-transform:matrix("+ Obj1.wZoom + ',0,0,' + Obj1.hZoom + ',0,0'+ ");'>" +
        //            "<div class='jxbubble-graphic'>"+
        //            " <em><img id='normal' src='"+ iconSrc +"'></em><p>{title}</p></div>")
        //        .css({
        //            'top': bound[0] + 'px',
        //            'left': bound[1] + 'px'
        //            // 'width': bound[2] + 'px',
        //            // 'height': bound[3] + 'px'
        //        });
        //}
        //else{
            content =
                $('<div class="jxbubble-positioning widgeticon" style="position: absolute; -webkit-transform:matrix('+ Obj.wZoom + ",0,0," + Obj.hZoom + ",0,0"+ ');"></div>')
                .append('<div class="format-bignumber format-number" draggable="true"></div>')
                .css({
                    'top': bound[0] + 'px',
                    'left': bound[1] + 'px'
                    // 'width': bound[2] + 'px',
                    // 'height': bound[3] + 'px'
                });
        //}

        (this.style && this.style.tiny !== 'true') ? (content.find("#tiny").hide()) : content.find("#normal").hide();

        return content;
    }


    exports.WidgetInteractiveCard = WidgetInteractiveCard;
});
