/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-4
 * Time: 上午9:29
 * To change this template use File | Settings | File Templates.
 */
;define(function(require,exports){
    var WidgetBase = require("./widgetbase").WidgetBase;
    require('browserContext');
    var define = require('../../define');
    var path = require('../../../common/path');
    require('jqjson');
    var CardWrapper = require('../../../app/card/cardwrapper').Instance;
    var shellcmd = require('../../../common/shellcmd');
    var trace = require('../../trace').Instance;
    var playerMgr=require('../hotspot/playerMgr').Instance;
    var guidCreate = require('../../../common/guid').Instance;
    require('popover');

    function WidgetImg(){

    }

    WidgetImg.prototype = new WidgetBase();
    WidgetImg.prototype.constructor = WidgetImg;

    function WidgetImg(widgetType, obj) {
        var _this = this;
        this.WidgetType = widgetType;
        this.parse(obj);
        (obj.img["src"]) && (_this.File =  obj.img["src"]);
        _this.Title = obj.img["title"];
        _this.showTitleFlag = !!(obj.img["showTitleFlag"] == "true");
        _this.showIconFlag = !!(obj.img["showIconFlag"] == "true");
        _this.description = obj.img["description"]||"";
        _this.userName = obj.img["userName"]||"";
        _this.uploadTime = obj.img["uploadTime"]||"";
        _this.score = obj.img["score"]|| 0 ;
        _this.userAddressInfo = obj.img["userAddressInfo"]||"";
        _this.resourceId = obj.img["resourceId"]||"";
        _this.timestamp=obj.img["timestamp"] || "";
        if(json.TP.useDb){
            var src = obj.img['realPath'];
            var md5 = obj.img['md5'];
        }else{
            var src = path.join(obj.XamlPath, '../' + _this.File);
        }

        this.Content=this.getContent('assert/static/common/images/icon_24X24/image.png',[this.Left,this.Top,this.Width,this.Height]);
        /**
         * 完成状态下打开
         */
        this.Content.click(function (event) {
            // 定位到列表位置
            _this.scrollToPosition(_this);

            if (!_this.getIsEditing()) {
                _this.showIntro(_this);
                // _this.showBubble(this,_this);
                // var showBubble= $(this).find(".jxbubble-box").is(":visible");
                // if(showBubble){
                //     _this.resourcePreview();
                //     $(".jxbubble-box").hide();
                //
                // }
                // else{
                //     $(".jxbubble-box").hide();
                //     $(this).find(".jxbubble-box").show();//完成状态下点击资源图标出现小弹框
                //
                //     $(this).find(".jxbubble-graphic span").text(_this.Title);
                // }


                /*
                 * 显示图片时根据图片尺寸放缩显示
                 * name: qmjie
                 * date:2013.10.18
                 */
//                var innerObj = $('<div>').append($('<image src="' + _this.encodeSrc + '">').css({
//                    'max-width': '100%',
//                    'max-height': '100%',
//                    'verticalAlign': 'middle'
//                }));
//                var actualHeight=Math.min($(document).height(),Config["Height"]);
//                innerObj.css({textAlign: 'center', lineHeight: actualHeight + 'px'});
//                CardWrapper.show(innerObj[0], _this.Id, true);
               // _this.resourcePreview();
            }
            else  {
                _this.showEdit(this,_this);

            }
            event.stopPropagation();
        });

        this.Content.attr('id', _this.Id);
        this.Content.attr('data-uuid', _this.uuid);
        this.src = src;
        if(json.TP.useDb){
            this.encodeSrc= src && src.substring(0, src.lastIndexOf('/')) + '/' + encodeURIComponent(_this.File);
        }else{
            this.encodeSrc= path.join(obj.XamlPath, '../' + encodeURIComponent(_this.File));
        }
        this.attachOnDragEvent();
        this.setTitle();
        this.setPopover();
    }




    /**
     * 资源查看
     */
    WidgetImg.prototype.resourcePreview = function(event){
             var _this = this;
        //solve the cache of image loading;
             var ImgSrc = _this.encodeSrc + '?rn=' + guidCreate.guid(2);
            /*
             * 显示图片时根据图片尺寸放缩显示
             * name: qmjie
             * date:2013.10.18
             */

        var innerObj = $('<div>').append($('<image src="' + ImgSrc + '">').css({
                'max-width': '100%',
                'max-height': '100%',
                'verticalAlign': 'middle'
            }));
            innerObj.find('img').css('img' , ImgSrc);
            var actualHeight=Math.min($(document).height(),Config["Height"]);
            innerObj.css({textAlign: 'center', lineHeight: actualHeight + 'px'});
            CardWrapper.show(innerObj[0], _this.Id, true);
//            event.stopPropagation();

    };

    /**
     * 资源编辑
     */
    WidgetImg.prototype.resourceEditor = function(){
            alert("当前资源不可编辑")
    };

    /**
     /**
     * 删除widget
     * @param {boolean=} isDeleteSrc 是否删除源文件
     */
    WidgetImg.prototype.destroy=function(isDeleteSrc){
        if(this.Content){
            isDeleteSrc = isDeleteSrc == undefined ? true : isDeleteSrc;
            if (isDeleteSrc && this.src) {
                var dst = this.src.replace(/\//g, "\\");
                shellcmd.deleteFile(dst);
            }
            this.Content.remove();
            this.Content=null;
        }
    }

    WidgetImg.prototype.toXml=function(){
        var xmlResult = '\n<eb:';
        var widgetContent;
        widgetContent = '\n<img src= "{0}"  uploadTime="{8}" score="{9}" userAddressInfo="{10}" resourceId="{11}" timestamp="{12}"  title="{1}" showTitleFlag="{2}" showIconFlag="{3}" description="{6}" userName="{7}" />\n<layout src="{4}" style="{5}" />'
            .format(this.File, this.Title ,
                (this.showTitleFlag === undefined) ? true : this.showTitleFlag ,
                (this.showIconFlag === undefined) ? true : this.showIconFlag,
                this.layout.src, this.layout.style,this.description,this.userName,this.uploadTime,this.score,this.userAddressInfo,this.resourceId,this.timestamp);

        widgetContent += ' \n<event action="opened" style="zoomin_anim" />' +
            '\n<event action="closed" style="zoomout_anim" />';

        var left=parseFloat(this.Content.css('left')),top=parseFloat(this.Content.css('top'));
        xmlResult += '{0} id="{1}" bound="{2};{3};{4};{5}" editable="{6}" style="{7}" '
            .format(this.WidgetType, this.Id,left , top, this.PlayAreaWidth, this.PlayAreaHeight, this.IsEditing,this.style.toString());

        xmlResult += ">";
        xmlResult += widgetContent;
        xmlResult += "\n</eb:{0}>".format(this.WidgetType);
        return xmlResult;
    }

    exports.WidgetImg = WidgetImg;
});
