/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-4
 * Time: 上午9:40
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {
    var WidgetBase = require("./widgetbase").WidgetBase;

    require('browserContext');
    var define = require('../../define');
    var path = require('../../../common/path');
    require('jqjson');
    var shellcmd = require('../../../common/shellcmd');
    var trace = require('../../trace').Instance;
    var ResizeableAndDraggableBound = require('../../../common/resizeableAndDraggableBound');
    var playerMgr=require('../hotspot/playerMgr').Instance;
    require('popover');

    function WidgetFadeCurtain(widgetType, obj) {
        var _self = this;
        _self.WidgetType = widgetType;
        _self.parse(obj);

        //幕布图片
        if (obj.fadeCurtain)
            _self.src = obj.fadeCurtain.src;
        else _self.src = "";

        _self.showTitleFlag = !!(obj.fadeCurtain["showTitleFlag"] == "true");
        _self.showIconFlag = !!(obj.fadeCurtain["showIconFlag"] == "true");
        _self.description = obj.fadeCurtain["description"]||"";
        _self.userName = obj.fadeCurtain["userName"]||"";
        _self.uploadTime = obj.fadeCurtain["uploadTime"]||"";
        _self.score = obj.fadeCurtain["score"]|| 0 ;
        _self.userAddressInfo = obj.fadeCurtain["userAddressInfo"]||"";
        _self.resourceId = obj.fadeCurtain["resourceId"]||"";
        _self.timestamp=obj.fadeCurtain["timestamp"] || "";
        _self.Content = null;
        _self._rect = null;
        if (_self.style.isShow === undefined) _self.style.isShow = 'true';
        _self.Content = $(document.getElementById('template_colorCurtain').innerHTML);
        _self.Content.attr('id', _self.Id).css('z-index', 1);
        //
        var innerImage = _self.Content.find("#innerImg");
        var pathPrefix = "assert/images/curtains/";
        if (!shellcmd.isFileExistSync(path.trimPosix(Config.binPath + "webapp/" + pathPrefix + _self.src)))
            _self.src = "01.png";

        innerImage.attr("src", pathPrefix + _self.src);
        //
        _self.Content.one('pageLoaded', function () {
            _self.addToBook();
            _self.hideBound();
        });
    }

    WidgetFadeCurtain.prototype = new WidgetBase();
    WidgetFadeCurtain.prototype.constructor = WidgetFadeCurtain;

    WidgetFadeCurtain.prototype.addToBook = function () {
        var _self = this;
        _self._rect = new ResizeableAndDraggableBound({
            left: _self.Left,
            top: _self.Top,
            minWidth: 30,
            minHeight: 30,
            content: _self.Content,
            container: _self.Content.parent(),
            draggable: false //不使用自身的drag，使用html5的drag
        });
        var innerImage = _self.Content.find("#innerImg");
        var pathPrefix = "assert/images/curtains/";
        if (!shellcmd.isFileExistSync(path.trimPosix(Config.binPath + "webapp/" + pathPrefix + _self.src)))
            _self.src = "01.png";

        innerImage.attr("src", pathPrefix + _self.src);
      //  _self.setPopover();
        _self._bindCommands();
        _self.attachOnDragEvent();

        _self.Content.find('.user-popover').css('-webkit-transform', 'matrix(' + _self.getTransformMatrix(_self.Content).join(',') + ')');
        _self.Content.css('-webkit-transform', 'matrix(1,0,0,1,0,0)');
        _self._rect.show({width: _self.PlayAreaWidth, height: _self.PlayAreaHeight});
        _self.Content.find("#curtainerImage").css("width",_self.PlayAreaWidth);
        _self.Content.find("#curtainerImage").css("height", _self.PlayAreaHeight);
    }

    WidgetFadeCurtain.prototype._bindCommands = function () {
        var _self = this;

        _self._rect.one(_self.Content, 'resizeStart', function () {
            _self.isModify = true;
        })

        _self._rect.bind(_self.Content, 'resize', function (event, bound) {
            _self.isModify = true;
            _self.PlayAreaWidth = bound.width;
            _self.PlayAreaHeight = bound.height;
            console.log(_self);
            _self.Content.find("#curtainerImage").css("width",bound.width);
            _self.Content.find("#curtainerImage").css("height",bound.height)
            //更新数据库
            var pageItem  = _self.Content.data("pagedata");
            var param = {
                unit1:_self.unit1, //新的目录
                unit2:_self.unit2,
                unit3:_self.unit3,
                unit4:_self.unit4,
                uuid:_self.uuid,
                sort:_self.sort,  //排序字段
                pageCode:'',
                pageIndex:_self.pageIndex,
                position:bound.left + ";" + bound.top + ";" + bound.width + ";" + bound.height,
                widgetId: _self.Id,
                widgetType: _self.WidgetType,
                resId: _self.resourceId || ''
            }
            pageItem.provider.updateTPP([param]).done(function(ret){
                if(ret && ret.code == 1){
                    console.log("resize成功");
                }else{
                    console.log("resize失败");
                }
            }).fail(function(e){
                console.log("resize失败");
            });
        });

        _self.Content.bind('click', function (event) {
            if (_self.IsEditing){
                _self.Content.popover('show');
            }
            else {
                _self.style.isShow = 'false';
                _self.Content.fadeOut(500);
                _self.showIconFlag = !_self.showIconFlag;
            }
            event.stopPropagation();
        });

        _self.Content.find("#resourceDelete").bind("click",function(e){
            var pageItem  = _self.Content.data("pagedata");
            pageItem.provider.deleteTPUuids([_self.uuid]).done(function(ret){
                if(ret){
                    console.log("删除幕布成功");
                    var p  = _self.Content.data("pagedata");
                    p.widgetPositions[p._getWidgetPosition([_self.Content[0].offsetLeft, _self.Content[0].offsetTop])] -= 1;
                    _self.destroy(false);
                    $(document).trigger("importGetWidget");
                }else{
                    console.log("删除幕布失败");
                }
            }).fail(function(e){
                console.log("删除幕布失败");
            });
            // pageItem && pageItem.trigger("widgetDeleted",[_self.Id]);
            
            e.stopPropagation();
            return false;
        });
    }

    WidgetFadeCurtain.prototype.getToolBarContent = function () {
        <!--资源属性框-->
        var $content = $('<div class="newpop curtainpop" style="width:80px;height:47px;z-index: 300;' +
            '-webkit-transform:matrix(1.8,0,0,1.8,0,0);">'
            +'<div class="new_pop_list" style="font-size: 13px;">'
            +'<ul class="clear">'
            +'<li><a title="图标隐藏"   name="resourceItem" index="3" style="cursor:pointer;">图标隐藏</a></li>'
            +'</ul>'
            +'<div class="clear"></div>'
            +'</div>'
            +'</div>');
        <!--/资源属性框-->

    //    this._bindToolBarCommands($content);
        var _self = this;
        $content.find('#btnRestore').click(function () {
            if (_self.style.isShow !== 'false') _self.style.isShow = 'false';
            else _self.style.isShow = 'true';
            _self.isModify = true;
        });
        return $content;
    }

    /**
     * 资源查看
     */
    WidgetFadeCurtain.prototype.resourcePreview = function(event){
        this.Content.popover('show');
//        event.stopPropagation();
    };

    /**
     * 资源编辑
     */
    WidgetFadeCurtain.prototype.resourceEditor = function(event){
        alert("当前资源不可编辑")
    };

    /**
     * 资源编辑
     */
    WidgetFadeCurtain.prototype.upload = function(event){
        alert("当前资源不可上传")
    };

    /**
     * 图标隐藏
     */
    WidgetFadeCurtain.prototype.resourceIconHide  = function(){
        var _self = this;
        this.showIconFlag ?_self.style.tiny = 'true':_self.style.tiny = 'false';
        //当前图标显示
        if ( _self.style.tiny === 'true') {
            _self.style.isShow = 'true';
            _self.Content.find("img").css('opacity','1');
        }
        //当前图标隐藏
        else{
            if(this.IsEditing&&$("#containerBox").css("display")=="block"){
                this.showIconFlag=true;
                _self.style.isShow = 'true';
               _self.Content.find("img").css('opacity','1');
            }else{
             //   _self.style.isShow = 'true';
          //      _self.Content.fadeOut(500);
            }
        }
        _self.isModify = true;

        !this.showIconFlag ?  $(_self.Content.find("a[name='resourceItem']")[0]).attr("title","图标隐藏")
            :$(this.Content.find("a[name='resourceItem']")[0]).attr("title","图标显示");
        !this.showIconFlag ?  $(_self.Content.find("a[name='resourceItem']")[0]).text("图标隐藏")
            :$(this.Content.find("a[name='resourceItem']")[0]).text("图标显示");

    }

    WidgetFadeCurtain.prototype.getTitleContent = function () {
        return null;
    }

    WidgetFadeCurtain.prototype.setIsEditing = function (value) {
        console.log(value)
//        if (value == this.IsEditing) return;
        this.IsEditing = value;
        if (this.IsEditing) {
            this.Content.find('#btnRestore').prop('checked', (this.style.isShow !== 'false' ? true : false));
            this.Content.find('.resizeCorner').show();
            this.Content.show();
            this._rect &&  this._rect.setOptions({
                resizable: true
            });
        }
        else {
            this.hideBound();
        }
        this.resourceIconHide();
    }

    WidgetFadeCurtain.prototype.hideBound = function () {
        if(this.Content){
            if (this.style.isShow === 'false') this.Content.hide();
            else  this.Content.find('.resizeCorner').hide();
        }
        this._rect && this._rect.setOptions({
            resizable: false
        });
    }

    WidgetFadeCurtain.prototype.destroy = function () {
        if (this.Content) {
            this.Content.remove();
            this.Content = this._rect = null;
        }
    }

    WidgetFadeCurtain.prototype.toXml = function () {
        var xmlResult = '\n<eb:';
        var widgetContent;
        widgetContent = '\n<fadeCurtain src= "{0}"  uploadTime="{8}" score="{9}" userAddressInfo="{10}" resourceId="{11}" timestamp="{12}"  showTitleFlag="{1}" showIconFlag="{2}" description="{6}" userName="{7}" />\n<layout src="{3}" style="{4}" />'
        .format(this.src ? this.src : "",
            (this.showTitleFlag === undefined) ? true : this.showTitleFlag ,
            (this.showIconFlag === undefined) ? true : this.showIconFlag,
            this.layout.src, this.layout.style,this.description,
                this.userName,this.uploadTime,this.score,this.userAddressInfo,this.resourceId,this.timestamp);
        widgetContent += ' \n<event action="opened" style="zoomin_anim" />' +
            '\n<event action="closed" style="zoomout_anim" />';

        var left = parseFloat(this.Content.css('left')), top = parseFloat(this.Content.css('top'));
        xmlResult += '{0} id="{1}" bound="{2};{3};{4};{5}" editable="{6}" style="{7}" '
            .format(this.WidgetType, this.Id, left, top, this.PlayAreaWidth, this.PlayAreaHeight, this.IsEditing, this.style.toString());

        xmlResult += ">";
        xmlResult += widgetContent;
        xmlResult += "\n</eb:{0}>".format(this.WidgetType);

        return xmlResult;
    }

    exports.WidgetFadeCurtain = WidgetFadeCurtain;
});
