/**
 * Created with JetBrains WebStorm.
 * User: Administrator
 * Date: 14-7-4
 * Time: 上午9:38
 * To change this template use File | Settings | File Templates.
 */
define(function (require,exports) {
    var WidgetBase = require("./widgetbase").WidgetBase;

    require('browserContext');
    var define = require('../../define');
    var path = require('../../../common/path');
    require('jqjson');
    var trace = require('../../trace').Instance;
    var playerMgr=require('../hotspot/playerMgr').Instance;
    require('popover');
    var cardResMgr = require('../../card/cardresourcemgr');
    var shellcmd = require('../../../common/shellcmd');

    var speechUI = require('../../../speechui/speechui');
    var speechuiDefine = require('../../../speechui/code/define');
    var CardWrapper = require('../../../app/card/cardwrapper').Instance;

    var choiceCardTpl = require('../../../app/card/template/choicecardtpl/choicecardtemplate').Instance;


    function WidgetChoiceCard(){

    }
    WidgetChoiceCard.prototype = new WidgetBase();
    WidgetChoiceCard.prototype.constructor = WidgetChoiceCard;

    function WidgetChoiceCard(widgetType, obj){
        var _this = this;
        this.WidgetType = widgetType;
        this.parse(obj);

        if (obj.file["src"] != undefined) {
            _this.File = obj.file["src"];
        }
        _this.Title = obj.file["title"];
        _this.showTitleFlag = !!(obj.file["showTitleFlag"] == "true");
        _this.showIconFlag = !!(obj.file["showIconFlag"] == "true");
        _this.description = obj.file["description"]||"";
        _this.userName = obj.file["userName"]||"";
        _this.uploadTime = obj.file["uploadTime"]||"";
        _this.score = obj.file["score"]|| 0 ;
        _this.userAddressInfo = obj.file["userAddressInfo"]||"";
        _this.resourceId = obj.file["resourceId"]||"";
        _this.timestamp=obj.file["timestamp"] || "";
        var icon = 'assert/images/bookicon/ic_ktcs.png';
        if(json.TP.useDb){
            var xmlPath = obj.file['realPath'];
            var md5 = obj.file['md5'];
        }else{
            var xmlPath = path.join(obj.XamlPath, '../' + _this.File);
        }
        _this.xmlpatn = xmlPath;
        this.Content=this.getContent(icon,[this.Left,this.Top,this.Width,this.Height]);
        this.Content.click(function (event) {
            console.log("icon clicked");
            var def = $.Deferred();
            // 定位到列表位置
            _this.scrollToPosition(_this);

            if (!_this.getIsEditing()) {
                _this.showIntro(_this);
                // _this.showBubble(this,_this);
                // cardResMgr.getChoiceCardOptions(xmlPath).done(function (cardOptions) {
                //     //TODO:随堂测试卡片展示
                //     console.log(JSON.stringify(cardOptions));
                //
                //     speechUI.init([speechuiDefine.CardName.Choice]);
                //     var galleryCard = speechUI.loadCard(speechuiDefine.CardName.Choice, cardOptions);
                //     CardWrapper.show(galleryCard.getContent()[0], _this.Id);
                // });
            }
            else {
                if($(_this.Content.find(".user-popover")[1]).css("display")=="block")
                    $(_this.Content.find(".user-popover")[1]).hide();
                else{
                    $(".user-popover").hide();
                    _this.Content.popover("show", "toolbar");
                    x=$(".leftPageWrapper").width()-$(this).position().left;
                    if(x<307){
                        _this.Content.find("div[name=infoWideget_pop]").parent(".user-popover").css("left",-78);
                    }
                    var isTeachingPackage=$(document).data("isTeachingPackage");
                    if(isTeachingPackage){
                        $(".editor_ic a[name=deletefile]").show();
                    }
                }
            }
            def.resolve();
            event.stopPropagation();
            return def.promise();
        });

        this.Content.attr('id', _this.Id);
        this.Content.attr('data-uuid', _this.uuid);
        this.src = xmlPath;
        this.attachOnDragEvent();
        this.setTitle();
        this.setPopover();

    }

    /**
     * 资源查看
     */
    WidgetChoiceCard.prototype.resourcePreview = function(event){
        var _this = this;
        if(json.TP.useDb){
            var xmlPath = _this.src;
        }else{
            var xmlPath = path.join(_this.xmlpatn, '../' + _this.File);
        }
        console.log("icon clicked");
        var def = $.Deferred();
        cardResMgr.getChoiceCardOptions(xmlPath).done(function (cardOptions) {
            //TODO:随堂测试卡片展示
            console.log(JSON.stringify(cardOptions));

            speechUI.init([speechuiDefine.CardName.Choice]);
            var galleryCard = speechUI.loadCard(speechuiDefine.CardName.Choice, cardOptions);
            CardWrapper.show(galleryCard.getContent()[0], _this.Id);
        });
        def.resolve();
//        event.stopPropagation();
        return def.promise();
    };

    /**
     * 资源编辑
     */
    WidgetChoiceCard.prototype.resourceEditor = function(){


//        alert("当前资源不可编辑")
        console.log('come into choicecard edit');
        var _this = this;
        //获得当前widget所属的pageItem
        var pageItem = _this.Content.data('pagedata');
        var pageIndex = pageItem.pageIndex ||1;
        var xmlPath = path.join(_this.xmlpatn, '../' + _this.File);
        console.log(xmlPath);
        //这里可以拿到json
        //TODO:读取json
        var filePath = xmlPath + '/choiceinfo.json';
        shellcmd.readFileAsync(filePath).done(function(ret){
            console.log(ret);
            var choiceJson = JSON.parse(ret);
            for(var i = 0,len = choiceJson.questionArr.length; i < len; i++){
                if(choiceJson.questionArr[i].imgPath){
                    choiceJson.questionArr[i].imgPath = xmlPath +'/'+choiceJson.questionArr[i].imgPath;
                }
                for(var j = 0 ,l = choiceJson.questionArr[i].choiceItems.length; j < l; j++){
                    if(choiceJson.questionArr[i].choiceItems[j].imgPath){
                        choiceJson.questionArr[i].choiceItems[j].imgPath
                            = xmlPath +'/'+choiceJson.questionArr[i].choiceItems[j].imgPath;
                    }
                }
            }
            choiceCardTpl.showEditChoiceTmpPanel(choiceJson,true,_this.File,pageIndex);//true 表示不是新的
        })
    };

    WidgetChoiceCard.prototype.upload = function(){
        alert("当前资源不可上传")
    };

    WidgetChoiceCard.prototype.destroy=function(isDeleteSrc){
        if (this.Content) {
            isDeleteSrc = isDeleteSrc == undefined ? true : isDeleteSrc;
            if (isDeleteSrc && this.src) {
                var dst = this.src.replace(/\//g, "\\");
                shellcmd.deleteDir(dst);
            }
            this.Content.remove();
            this.Content = null;
        }

    }

    WidgetChoiceCard.prototype.toXml=function(){
        var xmlResult = '\n<eb:';
        var widgetContent;
        widgetContent = '\n<file src= "{0}"  uploadTime="{8}" score="{9}" userAddressInfo="{10}" resourceId="{11}" timestamp="{12}" title="{1}" showTitleFlag="{2}" showIconFlag="{3}" description="{6}" userName="{7}"/>\n<layout src="{4}" style="{5}" />'
            .format(this.File, this.Title ,
                (this.showTitleFlag === undefined) ? true : this.showTitleFlag ,
                (this.showIconFlag === undefined) ? true : this.showIconFlag,
                this.layout.src, this.layout.style,this.description,
                this.userName,this.uploadTime,this.score,this.userAddressInfo,this.resourceId,this.timestamp);
        widgetContent += ' \n<event action="opened" style="zoomin_anim" />' +
            '\n<event action="closed" style="zoomout_anim" />';

        var left = parseFloat(this.Content.css('left')), top = parseFloat(this.Content.css('top'));
        xmlResult += '{0} id="{1}" bound="{2};{3};{4};{5}" editable="{6}" style="{7}" '
            .format(this.WidgetType, this.Id, left, top, this.PlayAreaWidth, this.PlayAreaHeight, this.IsEditing, this.style.toString());

        xmlResult += ">";
        xmlResult += widgetContent;
        xmlResult += "\n</eb:{0}>".format(this.WidgetType);

        return xmlResult;

    }

    WidgetChoiceCard.prototype.setIsEditing = function (value) {
        this.IsEditing = value;
        !this.IsEditing ? this.Content.find("#resourceDelete").hide() : this.Content.find("#resourceDelete").show();
        !this.IsEditing ? this.Content.find("#resRDEdit").hide() : this.Content.find("#resRDEdit").show();

        this.showTitleSet();
        this.resourceIconHide();
    }

    /**
     * @param icon 资源图标
     * @param bound 定位
     * @returns {*|jQuery}
     */
    WidgetChoiceCard.prototype.getContent = function (icon, bound) {
        if (!icon || !bound) return;
        var Obj = this.getUnTransForm();
        var Obj1 = this.getUnTransFormBuble();
        var content = $("<div class='jxbubble-positioning widgeticon' style='position: absolute;-webkit-transform:matrix(" +Obj.wZoom + ",0,0," + Obj.hZoom + ",0,0)'/>")
            .append('<div class="format-bignumber format-number" draggable="true"></div>')
            .css({
                'top': bound[0] + 'px',
                'left': bound[1] + 'px'
                // 'width': bound[2] + 'px',
                // 'height': bound[3] + 'px'
            });
            // .css({
            //     'top': bound[0] + 'px',
            //     'left': bound[1] + 'px',
            //     // 'width': bound[2] + 'px',
            // // 'height': bound[3] + 'px'
            // })
            // .append("<div class='fs_closed'  >" +
            //     "<img  id='normal' src='" + icon + "' width='" + bound[2] + "' height='" + bound[3] + "'>" +
            //     "<img  id='tiny'  src='assert/images/bookicon/ic_black.png'>" +
            //     "<a id='resourceDelete' ></a>" +
            //     "<div class='iconedit'><a id='resRDEdit' ></a></div></div>");

        (this.style && this.style.tiny !== 'true') ? (content.find("#tiny").hide()) : content.find("#normal").hide();

        return content;
    }

    exports.WidgetChoiceCard = WidgetChoiceCard;

});