/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-7
 * Time: 上午10:10
 * To change this template use File | Settings | File Templates.
 */
/**
 * Idea :
 * 这个模块是白板页面。
 * 基本仿自pageItem。有很多相似甚至相同的函数。
 * 为了和上层接口保持一致，有些函数名以"....page...."命名.
 * 如果您真的有时间，可以考虑将 pageItem 和 WhiteBoardItem 再次抽象重构一下
 * 以减少代码量
 *
 * 大多数模块中的 WB 就是 WhiteBoard 的简写。
 */
;
define(function (require, exports) {

    require('browserContext');
    var path = require('../../common/path');
    var define = require('../define');
    var model = require('../model');
    var factory = require('./widgetfactory');
    var shellcmd = require('../../common/shellcmd');
    var StrokeResult = require('../paint/strokeResult.js').Instance;

    var bbhelper = require("../blackboard/blackboardhelper.js").instance;

    var pageXmlParser = require('../../common/pagexmlparser').Instance;

    var ebookContext = require('../../app/ebookcontext').Instance;
    require('xml2json');

    /**
     * 白板
     * @param pageProvider
     * @param pageIndex
     * @param audioPlayer
     */
    function WhiteBoardItem(pageProvider, index, wbPath, audioPlayer) {
        /** @type {HTMLCanvasElement}  */
        var _paintCanvas;

        /** @type {boolean} 笔迹是否已经加载 */
        var _strokeLoaded = false;

        var ctx;

        this.isStrokeChanged = false;
        this.provider = pageProvider;
        //当前白板背景颜色
        this.bgColor = AppCfg.wbcolor;
        //当前白板号
        this.WBIndex = index;
        //当前白板保存路径(user/demo001/wboard)
        this.WBPath = wbPath;
        //当前白板info保存路径
        this.WBGenPath = wbPath + "/" + this.WBIndex;
        //当前白板描述内容文件路径（icon + 笔迹）
        this.WBXamlPath = this.WBGenPath + "/" + this.WBIndex + ".xaml";
        //当前白板笔迹保存地址
        this.strokeFilePath = this.WBGenPath + "/" + this.WBIndex + ".stroke.base64";
        //当前手势保存地址
        this.strokesPath = this.WBGenPath + "/" + this.WBIndex + ".stroke";
        //当前白板外壳内容保存地址
        this.contPath = this.WBPath + "/wb.xaml";
        this.content = null;
        this.WBObject = null;
        this.xamlPath = '';
        this.player = audioPlayer;
        this.widgetFactory = new factory.WidgetFactory();

        this.widgets = [];
        //位置数组
        this.widgetPositions = null;

        this._isModify = false;  //页面被修改
        this._isEditing = false;
        this.strokes = [];

        this.bookContainerDom = $("#bookContainer");

        this.setBgColor = function (color) {
            this.bgColor = color;
            AppCfg.wbcolor = color;
            this.content && this.changeBgColor();
            this.bookContainerDom.css({backgroundColor : color});
        }

        var _a = this;
        var WBBlack = $("#WBBlack");
        var WBWhite = $("#WBWhite");
        var WBGreen = $("#WBGreen");
        WBBlack.click(function () {
            _a.setBgColor("#666");
            WBGreen.attr("class","normal");
            WBWhite.attr("class","normal");
            WBBlack.attr("class","current");

//            //监管
//            var action = LogManager.action.trigger;
//            var params = {};
//            params.module = '1130621';
//            var user_id = ebookContext.getUser().getUid();
//            if(user_id != '0' && user_id){
//                params.user_id =user_id;
//            }
//            LogManager.statistics(action,params);
        });
        WBWhite.click(function () {
            _a.setBgColor("rgb(222,222,222)");
            WBGreen.attr("class","normal");
            WBWhite.attr("class","current");
            WBBlack.attr("class","normal");

            //监管
//            var action = LogManager.action.trigger;
//            var params = {};
//            params.module = '1130621';
//            var user_id = ebookContext.getUser().getUid();
//            if(user_id != '0' && user_id){
//                params.user_id =user_id;
//            }
//            LogManager.statistics(action,params);
        });
        WBGreen.click(function () {
            _a.setBgColor("rgb(123,150,133)");
            WBGreen.attr("class","current");
            WBWhite.attr("class","normal");
            WBBlack.attr("class","normal");

            //监管
//            var action = LogManager.action.trigger;
//            var params = {};
//            params.module = '1130621';
//            var user_id = ebookContext.getUser().getUid();
//            if(user_id != '0' && user_id){
//                params.user_id =user_id;
//            }
//            LogManager.statistics(action,params);
        })

        this.getStrokeLoaded = function () {
            return _strokeLoaded;
        };

        this._setStrokeLoaded = function (isLoaded) {
            _strokeLoaded = isLoaded;
        };

        /**
         * 设置笔迹Canvas
         * @param {HTMLCanvasElement} canvas
         * @private
         */
        this._setPaintCanvas = function (canvas) {
            _paintCanvas = canvas;
        };

        /**
         *  获取笔迹Canvas
         * @returns {HTMLCanvasElement}
         */
        this.getPaintCanvas = function () {
            return _paintCanvas;
        };

        this.saveStrokesToLocal = function () {
            this._savePainting();
            this.saveStrokes2File();
        }

        this.mergeStrokes = function (strokes) {
            this.strokes = this.strokes.concat(strokes);
        }

        this.getStrokes = function () {
            var hereThis = this;
            var def = $.Deferred();
            if ( (hereThis.strokes instanceof  Array) && (hereThis.strokes.length != 0)) {
                def.resolve(hereThis.strokes);
            }
            else {
                var strokesPath = path.trimPosix(hereThis.strokesPath);
                if(shellcmd.isFileExistSync(strokesPath)){
                    var strokes = shellcmd.readFile(strokesPath);
                    hereThis.strokes = JSON.parse(strokes);
                    def.resolve(hereThis.strokes);
                }
                else{
                    def.resolve(hereThis.strokes);
                }
            }
            return def.promise();
        }

        //保存手势
        this.saveStrokes2File = function () {
            var strokesPath = path.trimPosix(this.strokesPath);
            var strokes = JSON.stringify(this.strokes);
            shellcmd.saveFile(strokes, strokesPath);
        }

    };

    WhiteBoardItem.prototype.trigger = function (name, args) {
        this.content.triggerHandler(name, args);
    }

    WhiteBoardItem.prototype.getContent = function () {
        return this.content;
    };

    /**
     * 获取页面JSON对象
     * @param {String} xaml xaml文件路径
     * @returns {JSON} 转换后的JSON对象
     * @private
     */
    WhiteBoardItem.prototype._readWBObjectFromXaml = function (xaml) {
        var xml = shellcmd.readFile(xaml);
        if (isString(xml)) {
            if (xml.length > 0) {
                console.time('xmltojson: Page');
                var obj2 = pageXmlParser.ToJSON(xml);
                console.timeEnd('xmltojson: Page');
                return obj2;
            }
        }
        return xml;
    };

    WhiteBoardItem.prototype._bindCommands = function () {
        var _self = this;
        /**
         * 删除widget
         */
        this.content.on('widgetDeleted', function (event, id, isDeleted) {
            _self._isModify = true;
            _self.removeWidgetById(id, isDeleted);
            event.stopPropagation();
        });

        this.content.on('hideAllNote', function () {
            $.each(_self.widgets, function (i, widget) {
                widget.WidgetType === define.WidgetType.Note && widget.hide();
            });
        });
        this.content.bind('insertWidget', function (event, pageOffset, widgetId, srcPos, curPos) {
            var w = _self.getWidgetById(widgetId);
            if (w) {
                var curPageItem = pageOffset ? _self.provider.getPageItem(parseInt(_self.pageIndex) + parseInt(pageOffset)) : _self;
                _self._onDrop(_self, curPageItem, w, srcPos, curPos);
            }
        });
    }

    WhiteBoardItem.prototype._loadContent = function () {
        if (this.WBObject && this.content) {
            // this.WBPath
            this.widgetFactory.init(this.content, this.WBGenPath, this.WBXamlPath, this.player);

            this.loadBlackOverlay();

            // 创建绝对定位对象
            this._loadWidget(this.WBObject.absolutelayout);
            // 创建笔迹画布
            this._loadPaintCanvas();
            //创建位置数组
            this._initWidgetPosition();
        } else {
            console.warn('pageObject or content is null');
        }
    };

    WhiteBoardItem.prototype._loadWidget = function (absolutelayout) {
        if (!absolutelayout)  return;
        var value, _self = this;
        for (var key in absolutelayout) {
            if (absolutelayout.hasOwnProperty(key)) {
                value = $.makeArray(absolutelayout[key]);
                $.each(value, function (i, data) {
                    //注意约定把xaml中的类型字段的第一个字母大写后作为卡片的类型，如absolutelayout.video,则创建define.WidgetType.Video类型的卡片,这样减少许多if else
                    _self._insertWidget(define.WidgetType[key[0].toUpperCase() + key.substr(1)], data);
                });
            }
        }
    }

    /**
     * 加载笔迹画布
     * @private
     */
    WhiteBoardItem.prototype._loadPaintCanvas = function () {
        var _self = this;
        var w = this.provider.WBImageSize.width;
        var h = this.provider.WBImageSize.height;
        var canvas = $('<canvas class="paint" />').attr({width: w, height: h}).css({'position': 'absolute', 'z-index': -2});

        this.content.prepend(canvas);
        this._setPaintCanvas(canvas[0]);
        _self._loadPainting();
    };

    /**
     * 根据 id 获取widget
     * @param id
     */
    WhiteBoardItem.prototype.getWidgetById = function (id) {
        for (var i = 0; i < this.widgets.length; i++) {
            var w = this.widgets[i];
            if (w.Id === id) {
                return w;
            }
        }
        return null;
    };

    /**
     * 删除某个Widget
     * @param id
     * @param {boolean=} deleteSrc   是否删除物理文件
     */
    WhiteBoardItem.prototype.removeWidgetById = function (id, deleteSrc) {

        var deleteWidget = null;
        this.widgets = this.widgets.filter(function (w) {
            if (w.Id != id)
                return true;
            else {
                deleteWidget = w;
                return false;
            }
        });
        if (deleteWidget) {
            deleteSrc = (deleteSrc == undefined) ? true : deleteSrc;
            if (deleteSrc) {
                //避免删除有多个引用的文件
                $.each(this.widgets, function (i, e) {
                    if (e.src === deleteWidget.src) {
                        deleteSrc = false;
                        return false;
                    }
                });
            }
            this.widgetPositions[this._getWidgetPosition([deleteWidget.Content[0].offsetLeft, deleteWidget.Content[0].offsetTop])] -= 1;
            deleteWidget.destroy(deleteSrc);
            this._isModify = true;
        }
    };

    WhiteBoardItem.prototype._getWBObj = function (pageIndex) {
        var _self = this;
        var def = $.Deferred();
        var userPageXaml = _self.WBXamlPath;
        _self.xamlPath = userPageXaml;
        _self._getSTDWBObj().done(function (stdPgObj) {
            console.log(stdPgObj);
            shellcmd.isFileExist(userPageXaml).done(function (ret) {
                if (ret) {
                    var usrPgObj = _self._readWBObjectFromXaml(userPageXaml);
                    if (usrPgObj != null) {
                        stdPgObj.absolutelayout = usrPgObj.absolutelayout;
                    }
                } else {
                    _self._initUserWBXaml(userPageXaml);
                    _self._isModify = true;
                }
                def.resolve(stdPgObj);
            })
        });
        return def.promise();
    };

    WhiteBoardItem.prototype._getSTDWBObj = function (pageIndex) {
        var def = $.Deferred();
        var xaml = this.contPath;
        var obj = this._readWBObjectFromXaml(xaml);
        def.resolve(obj);
        return def.promise();
    };

    WhiteBoardItem.prototype._initUserWBXaml = function (userPageXaml) {
        /**
         * Caution : 这儿是个没实现的坑
         * 功能 : 初始化白板info文件
         * TODO : Come on !
         */
        shellcmd.createDirIfNotExist(this.WBGenPath, 0);
    };


    /**
     * 页面加载
     * @param {function=} callback
     */
    WhiteBoardItem.prototype.load = function () {
        var def = $.Deferred();
        var _self = this;
        _self._getWBObj(_self.WBIndex).done(function (ret) {
            _self.WBObject = ret;
            var w = _self.provider.WBImageSize.width;
            var h = _self.provider.WBImageSize.height;
            _self.content = $('<div class="pageItem" style="background:' + _self.bgColor + ';height:' + h + 'px;width:' + w + 'px;"></div>');

            _self._loadContent();
            _self._bindCommands();
            _self.content.dragable = true;

            //把当前数据保存到data里,否则有些回调里取不到当前的引用对象
            _self.content.data('pagedata', _self);
            def.resolve();
        });
        return def.promise()
    };

    WhiteBoardItem.prototype._onDrop = function (srcPageItem, curPageItem, w, srcPos, curPos) {
        var flag = curPageItem._correctPos(curPos, w);//更正位置信息
        if (flag) {
            if (srcPageItem.pageIndex === curPageItem.pageIndex) {
                srcPageItem.widgetPositions[srcPageItem._getWidgetPosition(srcPos)] -= 1;
                w.Content.css({
                    left: curPos[0],
                    top: curPos[1]
                });
                srcPageItem._isModify = true;
            } else {
                //从别的页面拖进来
                if (w) {
                    srcPageItem.removeWidgetById(w.Id, false);
                    curPageItem.insertWidget(w.WidgetType, {
                        file: w.src,
                        realPath: w.realPath,
                        title: w.Title,
                        left: curPos[0],
                        top: curPos[1],
                        width: w.PlayAreaWidth,
                        height: w.PlayAreaHeight,
                        type: w.type,
                        style: w.style.toString()
                    });
                }
            }
            //发送位置变化消息
            w.trigger('reposition', curPos);
        }
    }

    WhiteBoardItem.prototype.onDragOver = function (event) {
        event.stopPropagation();
        event.preventDefault();
    };

    /**
     * 页面卸载
     * @param {boolean=} index 默认为false，只是卸载当前页面，如果为true，则卸载整个书本页面。如从书本跳转到书架
     */
    WhiteBoardItem.prototype.unload = function (index) {
        this._savePainting();
        this.saveStrokes2File();
        this.saveXaml();

        this.content.data('pagedata', null);
        $(this.getPaintCanvas()).remove();
        this._setPaintCanvas(null);

        this.content.empty();
        //释放资源
        for (var i = 0, len = this.widgets.length; i < len; ++i) {
            var widget = this.widgets[i];
            widget.releaseRes && widget.releaseRes();
        }
        !index && this.content.remove();
    };

    /**
     * 插入卡片
     * @param widgetType 卡片类型
     * @param node  卡片节点信息
     * @param {object=} options 卡片额外参数
     */
    WhiteBoardItem.prototype._insertWidget = function (widgetType, node, options) {

        var _this = this,
            _fileFullPath="",
            _fileName="";
        var args = {"files": []};
        if(options){
            _fileFullPath=options.file;
            _fileName = _fileFullPath.substr(_fileFullPath.lastIndexOf("/")+1,_fileFullPath.length-1);
        }

        if(options && options.noNewIcon){
            _this.widgetFactory.createWidget(widgetType, node, options);
            return ;
        }

        var index=0 , exsit=0;
        for(;index<_this.widgets.length;index++){
            var _exsitFileName = _this.widgets[index].File;
            if(_fileName==_exsitFileName&&_fileName!="") {
                exsit=1;
                $.Zebra_Dialog(AppImportAndExportTips.ExistDownLoadFile, {
                    'type': 'question',
                    'title': AppTips.WarmTips,
                    'buttons': [AppTips.CancelTips,AppTips.OkTips],
                    'onClose': function (capition) {
                        if (capition == AppTips.OkTips) {
                            //只覆盖文件，不添加图标
                            var dstpath = path.trimPosix(path.join(ebookContext.getUser().getUserWBPath(), _this.WBIndex + "/" + _exsitFileName));
                            args.files[0] = {
                                "oriname": options.file,
                                "newname": dstpath
                            }
                            console.log(dstpath);
                            shellcmd.multiCopyFile(JSON.stringify(args));
                        }
                    }
                });
            }
        }
        if(index >= _this.widgets.length && exsit==0) insertWidgetAndover();

        function insertWidgetAndover(){
            var widget = _this.widgetFactory.createWidget(widgetType, node, options);
            if (widget) {
                var _self = _this;
                widget.Content.data('pagedata', _this);
                _this.widgets.push(widget);
                _this._isModify = true;

                setTimeout(function () {
                    var pos = [widget.Left, widget.Top];
                    if (_self._correctPos(pos, widget,options))    widget.Content.css({'left': pos[0], 'top': pos[1]});
                    widget.Content.show();
                 //   correctToBaseResolution(widget.Content, {scaleFromCenter: false, scaleOrder: false, keepScale: true, width: page_base_resolution.width, height: page_base_resolution.height});
                    //通知页面加载完成
                    widget.trigger('pageLoaded');
                    widget.setIsEditing(_self._isEditing);
                }, 0);
            }
        }
    }

    /**
     * 插入卡片，外部模块调用
     * @param {!object} widgetType 卡片类型
     * @param {!object} options  其他参数
     */
    WhiteBoardItem.prototype.insertWidget = function (widgetType, options) {
        var _self = this;
        if (!options) return;
        options.file = path.toPosix(options.file || "");
        if (!widgetType) {
            var ext = path.extname(options.file);
            widgetType = define.getWidgetTypeByExt(ext);
        }
        if(widgetType == define.WidgetType.Img ){
            widgetType = define.WidgetType.ImgPaint;
            shellcmd.getPicSize(options.file).done(function(ret){
                var sizelist = ret.split("|");
                //Cation ：这里修改大小
                options.width = AppCfg.imgPaintSize;
                options.height = AppCfg.imgPaintSize;
                if (sizelist[0] && sizelist[1] && sizelist[0] > sizelist[1]){
                    options.width = AppCfg.imgPaintSize / sizelist[1] * sizelist[0] ;
                }
                else if (sizelist[0] && sizelist[1] && sizelist[0] < sizelist[1]){
                    options.height = AppCfg.imgPaintSize / sizelist[0] * sizelist[1] ;
                }
                var filename = path.filename(options.file);
                var imgSavePath = path.trimPosix(_self.WBGenPath) + "/" + filename ;
                shellcmd.isDirExist(_self.WBGenPath.replace(/\bfile:(\/+)/g, "")).done(function(exist){
                    if(exist){
                        shellcmd.copyFile(options.file,imgSavePath).done(function(){
                            options.imgPaintSrc = filename;
                            _self._insertWidget(widgetType, null, options);
                        });
                    }else{
                        shellcmd.createDir(_self.WBGenPath.replace(/\bfile:(\/+)/g, "")).done(function(){
                            shellcmd.copyFile(options.file,imgSavePath).done(function(){
                                options.imgPaintSrc = filename;
                                _self._insertWidget(widgetType, null, options);
                            });
                        });
                    }

                });

            });

        }else{
            _self._insertWidget(widgetType, null, options);
        }
    }

    WhiteBoardItem.prototype.toXml = function () {
        var hotSpotXaml = "";
        /* 保存的时候,不保存热区信息,只要卡片信息
         $.each(this.hotspots, function (i, e) {
         hotSpotXaml += e.toXml();
         });
         */
        if (hotSpotXaml !== "") hotSpotXaml = "\n<eb:hotspot>" + hotSpotXaml + "\n</eb:hotspot>";
        var widgetsXaml = "";
        $.each(this.widgets, function (i, e) {
            widgetsXaml += e.toXml();
        });
        if (widgetsXaml !== "") widgetsXaml = "\n<eb:absolutelayout>" + widgetsXaml + "\n</eb:absolutelayout>"

        var xml = "<eb:page background=\"" + this.pageIndex + ".jpg\" xmlns:eb=\"EBookLib\">" + hotSpotXaml + widgetsXaml + "\n</eb:page>";
        return xml;
    };

    WhiteBoardItem.prototype.setIsEditing = function (isediting) {
        var _this = this;
        this._isEditing = isediting;
        $.each(_this.widgets, function () {
            this.setIsEditing(isediting);
        });
    };

    /**
     * 保存笔迹
     * @private
     */
    WhiteBoardItem.prototype._savePainting = function () {
        if (!this.isStrokeChanged) {
            return;
        }

        var paintCanvas = this.getPaintCanvas();
        var strokeBase64 = paintCanvas.toDataURL();
        var strokeFilePath = this.strokeFilePath;
        strokeFilePath = path.trimPosix(strokeFilePath);
        shellcmd.saveFile(strokeBase64, strokeFilePath);
    };


    WhiteBoardItem.prototype.saveXaml = function () {
        if (!this._isModifyChanged()) return;
        var xml = this.toXml();
        shellcmd.saveFile(xml, this.xamlPath);
        this._isModify = false;
    }


    WhiteBoardItem.prototype._isModifyChanged = function () {
        if (this._isModify) return true;
        for (var i = 0, len = this.widgets.length; i < len; ++i) {
            if (this.widgets[i].isModify) return true;
        }
        return false;
    };

    /**
     * 更正位置信息，防止widget移动时超出边界和重叠时的bug
     * @param {!Array.<number>} pos
     * @param {object} widget
     * @param {object=} options
     * @returns {boolean}是否更正了位置信息
     */
    WhiteBoardItem.prototype._correctPos = function (pos, widget, options) {
        if (!pos || pos.length < 2) return false;
        var flag = true;
        options = options || {};
        pos[0] = parseFloat(pos[0]);
        pos[1] = parseFloat(pos[1]);

        if (!this.widgetPositions) this._initWidgetPosition();

        //是否从外部插入，防止刚插入时重叠
        if (options.insertFromOuter) {
            var emptyPos = -1;//有任何可用的空位
            for (var i = 0; i < this.widgetPositions.length; ++i) {
                //如果当前位置可用
                if (this.widgetPositions[i] <= 0) {
                    emptyPos = i;
                    break;
                }
            }
            if (emptyPos < 0) {
                emptyPos = 0;
                var minPosCount = this.widgetPositions[0];
                for (var i = 0; i < this.widgetPositions.length; ++i) {
                    if (this.widgetPositions[i] < minPosCount) {
                        minPosCount = this.widgetPositions[i];
                        emptyPos = i;
                    }
                }
            }
            pos[0] = (emptyPos % this.widgetPositions.leftCount) * this.widgetPositions.leftOffset + (this.widgetPositions.leftOffset - widget.Width);
            pos[1] = Math.floor(emptyPos / this.widgetPositions.leftCount) * this.widgetPositions.topOffset + (this.widgetPositions.topOffset ) / 2;
        }

        if (isNaN(pos[0]) || isNaN(pos[1])) return false;

        // 防止超出边界
        var width = widget.Content.width(), height = widget.Content.height();
        var title = widget.Content.find('.widgetTitle:first');
        if (title.length) {
            minLeft = Math.max(title.outerWidth() - width, 0) / 2;
            width += minLeft;
        }
        var matrixTransform = this.getTransformMatrix(widget.Content);
        var offsetX = (matrixTransform[0] - 1) * width / 2, offsetY = (matrixTransform[3] - 1) * height / 2;
        var maxLeft = this.content.width() - offsetX, maxTop = this.content.height() - offsetY;
        var minLeft = offsetX, minTop = offsetY;

        pos[0] = pos[0] <= minLeft ? minLeft : pos[0], pos[1] = pos[1] <= minTop ? minTop : pos[1];

        if (pos[0] + width > maxLeft) pos[0] = maxLeft - 10 - width;
        if (widget.Content.find(".volet_clos").length > 0){
            if (pos[0] + 158 > maxLeft){
                $(widget.Content.find(".volet_clos")[0]).addClass('rotleft');

                $(widget.Content.find(".rotleft")[0]) .css({"-webkit-transform":"translateX(-162px) rotateY(180deg)"});
                $(widget.Content.find(".volet_clos")[0]) .css({"width":"200px"});
                $(widget.Content.find(".volet_clos .wrap")[0]) .css({"width":"200px"});
            }
            else{
                $(widget.Content.find(".rotleft")[0]) .css({"-webkit-transform":"translateX(0px) rotateY(0deg)"});
                $(widget.Content.find(".volet_clos")[0]) .css({"width":"40px"});
                $(widget.Content.find(".volet_clos .wrap")[0]) .css({"width":"40px"});
                $(widget.Content.find(".volet_clos")[0]).removeClass('rotleft');

            }
        }
        if (pos[1] + height > maxTop) pos[1] = maxTop - 10 - height;

        pos[0] = pos[0] <= minLeft ? minLeft : pos[0], pos[1] = pos[1] <= minTop ? minTop : pos[1];

        //更正位置数组
        this.widgetPositions[this._getWidgetPosition(pos)] += 1;
        return flag;
    }

    /**
     * 初始化widget的位置数组
     * @private
     */
    WhiteBoardItem.prototype._initWidgetPosition = function () {
        if (this.widgetPositions) return;
        this.widgetPositions = [];
        var matrixTransform = this.getTransformMatrix(this.content), leftOffset, topOffset;
        leftOffset = topOffset = parseInt(80 / matrixTransform[0] * 2) + 80; //每个widget的距离
        if (leftOffset < 130) leftOffset = 130;
        if (topOffset < 130) topOffset = 130;

        var maxLeft = this.content.width(), maxTop = this.content.height();

        var leftCount = Math.floor(maxLeft / leftOffset), topCount = Math.floor(maxTop / topOffset);

        for (var i = 0, len = leftCount * topCount; i < len; ++i) this.widgetPositions[i] = 0;

        $.extend(this.widgetPositions, {
            leftCount: leftCount,
            topCount: topCount,
            leftOffset: leftOffset,
            topOffset: topOffset
        });
    }

    /**
     * 根据当前位置获取在widget位置数组中的位置
     * @param {Array} pos
     * @returns {number}
     * @private
     */
    WhiteBoardItem.prototype._getWidgetPosition = function (pos) {
        if (!pos || pos.length != 2 || !pos[0] || !pos[1]) return -1;
        var index = Math.floor(pos[0] / this.widgetPositions.leftOffset) + Math.floor(pos[1] / this.widgetPositions.topOffset) * this.widgetPositions.leftCount;
        return index;
    }

    /**
     * 获得变换矩阵
     * @param {jQuery} ele
     * @return {Array}
     */
    WhiteBoardItem.prototype.getTransformMatrix = function (ele) {
        var matrix = [1, 0, 0, 1, 0, 0];
        if (ele) {
            var matrixTransform = ele.css('-webkit-transform');
            if (matrixTransform && matrixTransform != 'none')  matrix = matrixTransform.substr(7, matrixTransform.length - 8).split(",");
        }
        return matrix;
    };

    /**
     * 加载笔迹
     * @private
     */
    WhiteBoardItem.prototype._loadPainting = function () {
        var paintCanvas = this.getPaintCanvas();
        var self = this;
        var strokeFilePath = path.trimPosix(this.strokeFilePath);
        if(shellcmd.isFileExistSync(strokeFilePath)){
            var strokeBase64 = shellcmd.readFile(strokeFilePath);
            ctx = paintCanvas.getContext('2d');
            var image = new Image();
            image.onload = function () {
                ctx.clearRect(0, 0, self.provider.WBImageSize.width, self.provider.WBImageSize.height);
                ctx.drawImage(image, 0, 0);
                self._setStrokeLoaded(true);
                $(self).trigger('strokeLoaded');
            }
            image.src = strokeBase64;
        }
        else{
            self._setStrokeLoaded(true);
        }
    };

    /**
     * 笔迹分层
     * @param {HTMLCanvasElement} canvas
     * @param {Bound} boundd 原始画布中的边界信息
     */
    WhiteBoardItem.prototype.paintStroke = function (canvas, bound, isStrokeChanged) {
        var _self = this;
        var paintCanvas = _self.getPaintCanvas();
        if (isStrokeChanged) {
            var imgPaintList = $(".imgPaint");
            var i = 0;
            var imgContext, w, h,top,left,$imgPaint;
            if(imgPaintList.length > 0 && canvas){
                //Caution : 这里的顺序应该和层叠相反
                for(i=imgPaintList.length;i ;i--){
                    $imgPaint = $(imgPaintList[i-1]);
                    //将笔迹绘制到imgPaint上
                    imgContext = $imgPaint.find(".canPaintCan").get(0).getContext('2d');
                    w = parseInt($imgPaint.css("width"));
                    h = parseInt($imgPaint.css("height"));
                    top = parseInt($imgPaint.css("top"));
                    left = parseInt($imgPaint.css("left"));
                    try{
                        imgContext.drawImage(canvas, left,top,w,h,0, 0, w, h);

                        //分层后需要立即保存，防止缩放
                    }
                    catch(e){
                        console.log("can2imgPaint error");
                    }
                    //擦除这一块笔迹
                    canvas.getContext("2d").clearRect(left,top,w,h);
                    //擦除这一块手势，以免给识别造成影响。
                    _self.eraserStroke({x : left,y : top},{width: w, height: h});
                }
                _self.removeSerialJoints();
            }

            this.isStrokeChanged = isStrokeChanged;
            var w = this.provider.WBImageSize.width;
            var h = this.provider.WBImageSize.height;
            ctx = paintCanvas.getContext('2d');
            ctx.drawImage(canvas, bound.left, bound.top, bound.width, bound.height, 0, 0, w, h);
        }
    };

    //擦除
    WhiteBoardItem.prototype.doEraser = function (l,t,w,h) {
        var _self = this;
        var paintCanvas = _self.getPaintCanvas();
        var ctx = paintCanvas.getContext('2d');

        w < 0 && (l = l + w,w = -w );
        h < 0 && (t = t + h,h = -h );
        ctx.clearRect(l,t,w,h);

        var imgPaintList = $(".imgPaint");
        var i = 0;
        var imgContext, imgw, imgh,top,left,$imgPaint;
        var area = null;
        if(imgPaintList.length > 0){
            for(i=0;i< imgPaintList.length ;i++){
                $imgPaint = $(imgPaintList[i]);
                //将笔迹绘制到imgPaint上
                imgContext = $imgPaint.find(".canPaintCan").get(0).getContext('2d');
                imgw = parseInt($imgPaint.css("width"));
                imgh = parseInt($imgPaint.css("height"));
                top = parseInt($imgPaint.css("top"));
                left = parseInt($imgPaint.css("left"));
                area = imgEraserTest(l,t,w,h,left,top,imgw,imgh);
                if(area){
                    try{
                        imgContext.clearRect(area[0],area[1],area[2],area[3]);
                    }
                    catch(e){
                        console.log("can2imgPaint error");
                    }
                }
            }
        }

        _self.eraserStroke({x : l,y : t},{width: w, height: h});
        _self.removeSerialJoints();
    }

    //返回值的起点应减去left和top，取相对位置
    function imgEraserTest(l,t,w,h,left,top,imgw,imgh){
        //在外
        if( l + w < left || left + imgw < l || t + h < top || top + imgh < t ){
            return null;
        }
        //img全部在area内
        if( l <= left && l + w >= left + imgw && t <= top && t + h >= top + imgh ){
            return [0,0,imgw,imgh];
        }
        //area全部在img内
        if( left <= l && l + w <= left + imgw && t >= top && t + h <= top + imgh ){
            return [l-left,t-top,w,h];
        }
        //上半重叠1（area覆盖img）
        if(l<= left && l+w >=left+ imgw && t<= top && t+h <= top+imgh ){
            return [0,0,imgw,t+h-top];
        }
        //上半重叠2（img覆盖area）
        if(l >= left && l+w <=left+ imgw && t<= top && t+h <= top+imgh ){
            return [l-left,0,w,t+h-top];
        }
        //下半重叠1 （area覆盖img）
        if(l<= left && l+w >=left+ imgw && t >= top && t+h >= top+imgh ){
            return [0,t-top,imgw,top+imgh-t];
        }
        //下半重叠2（img覆盖area）
        if(l >= left && l+w <=left+ imgw && t>= top && t+h >= top+imgh ){
            return [l-left,t-top,w,top+imgh-t];
        }
        //左半重叠1（area覆盖img）
        if(l<= left && l+w <=left+ imgw && t <= top && t+h >= top+imgh ){
            return [0,0,l+w-left,imgh];
        }
        //左半重叠2（img覆盖area）
        if(l <= left && l+w <=left+ imgw && t>= top && t+h <= top+imgh ){
            return [0,t-top,l+w-left,h];
        }
        //右半重叠1 （area覆盖img）
        if(l>= left && l+w >=left+ imgw && t <= top && t+h >= top+imgh ){
            return [l-left,0,left+imgw-l,imgh];
        }
        //右半重叠2（img覆盖area）
        if(l >= left && l+w >=left+ imgw && t>= top && t+h <= top+imgh ){
            return [l-left,t-top,left+imgw-l,h];
        }
        //中部重叠（竖直）
        if(l >= left && l+w <=left+ imgw && t <= top && t+h >= top+imgh ){
            return [l-left,0,w,imgh];
        }
        //中部重叠（水平）
        if(l <= left && l+w >=left+ imgw && t>= top && t+h <= top+imgh ){
            return [0,t-top,imgw,h];
        }
        //左上重叠
        if( l <= left && l + w <= left + imgw && t <= top && t + h <= top + imgh ){
            return [0,0,l+w-left,t+h-top];
        }
        //右上重叠
        if( l >= left && l + w >= left + imgw && t <= top && t + h <= top + imgh ){
            return [l-left,0,left+imgw-l,t+h-top];
        }
        //左下重叠
        if( l <= left && l + w <= left + imgw && t >= top && t + h >= top + imgh ){
            return [0,t-top,l+w-left,top+imgh-t];
        }
        //右下重叠
        if( l >= left && l + w >= left + imgw && t >= top && t + h >= top + imgh ){
            return [l-left,t-top,left+imgw-l,top+imgh-t];
        }
    }

    WhiteBoardItem.prototype.eraserStroke = function(startPoint, size){
        var _self = this;
        _self.strokes = bbhelper.clearPoints(startPoint, size, _self.strokes);
    }

    WhiteBoardItem.prototype.removeSerialJoints = function(){
        var _self = this;
        _self.strokes = bbhelper.removeSerialJoints(bbhelper.removeFirstJoint(_self.strokes));
    }

    WhiteBoardItem.prototype.recognition = function (lan){
        var _self = this;
        (!StrokeResult.ready ) && StrokeResult.init();
        StrokeResult.showResult(lan, _self.strokes);
    }

    /**
     * 恢复笔迹画布
     * @param {HTMLCanvasElement} canvas
     * @param {Bound} boundd 原始画布中的边界信息
     */
    WhiteBoardItem.prototype.restoreStroke = function (canvas, bound) {
//        var w = this.provider.WBImageSize.width;
//        var h = this.provider.WBImageSize.height;
//
//        var self = this;
//        var paintCanvas = self.getPaintCanvas();
//        var ctx = canvas.getContext('2d');
//
//        var strokeLoaded = self.getStrokeLoaded();
//        if (strokeLoaded) {
//            ctx.drawImage(paintCanvas, 0, 0, w, h, bound.left, bound.top, bound.width, bound.height);
//        } else {
//            $(self).bind('strokeLoaded', function () {
//                ctx.drawImage(paintCanvas, 0, 0, w, h, bound.left, bound.top, bound.width, bound.height);
//                $(self).unbind('strokeLoaded');
//            })
//        }
    //    $(paintCanvas).hide();
    };


    /**
     * 获取本页资源 去除幕布
     */
    WhiteBoardItem.prototype.getCurrentPageRes = function(){
        var tmpWidgets = [];
        var widgets = this.widgets;
        for(var i = 0;i < widgets.length;i++){
            if(widgets[i].WidgetType != "fadeCurtain"){
                tmpWidgets.push(widgets[i]);
            }
        }
        return tmpWidgets;
    }

    /**
     * 清空本页资源
     * 这个函数暂时没用到
     */
    WhiteBoardItem.prototype.clearCurrentPageRes = function () {
//        this.player && this.player.releaseRes();
//        $.each(this.widgets, function (i, e) {
//            e.destroy(false);
//        });
//
//        var userPageXaml = this.WBPath;
//        var args = {
//            "filter": ".base64",
//            "dirs": userPageXaml
//        };
//        shellcmd.clearDir(JSON.stringify(args));
//        if (this.widgets.length) {
//            this.widgets = [];
//            for (var i = 0, len = this.widgetPositions.length; i < len; ++i) this.widgetPositions[i] = 0;
//            this._isModify = true;
//        }
    }

    /**
     * 导入时重新加载widgets
     * 这个函数暂时没用到
     */
    WhiteBoardItem.prototype.importBookRes = function () {
//        var _self = this;
//        this._getPageObj(this.pageIndex).done(function (ret) {
//            _self.pageObject = ret;
//            if (_self.pageObject.absolutelayout != null) {
//                _self._loadWidget(_self.pageObject.absolutelayout);
//                _self._isModify = true;
//            }
//        });
    }

    WhiteBoardItem.prototype.changeBgColor = function () {
        var _self = this;
        _self.content.css("background", _self.bgColor);
    }

    WhiteBoardItem.prototype.loadBlackOverlay = function(){
        var _DOM = $('<div class="itemOverlay" style="display:none;height:100%;width:100%;position: absolute;top: 0px;z-index:0;background:#666;opacity: 0.2;"></div>');
        this.content.append(_DOM);
    }

    exports.WBItem = WhiteBoardItem;
});